/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.parser;

import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.ext.emoji.EmojiImageType;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.Arrays;

public class MarkdownParser {
    private final Parser parser;
    private final HtmlRenderer renderer;

    public MarkdownParser() {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(StrikethroughExtension.create(), TablesExtension.create(), AutolinkExtension.create(), WikiLinkExtension.create(), TypographicExtension.create(), EmojiExtension.create()));
        options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
        options.set(EmojiExtension.USE_IMAGE_TYPE, (Object)EmojiImageType.UNICODE_ONLY);
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    public String render(String markdownText) {
        Document document = this.parser.parse(markdownText);
        String html = this.renderer.render((Node)document);
        return MarkdownParser.wrapWithMarkdownClassDiv(html);
    }

    public static String wrapWithMarkdownClassDiv(String html) {
        return "<div class=\"markdown-body\">\n" + html + "</div>";
    }
}

