/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cluster.protocol;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Serializer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.zeppelin.cluster.protocol.RaftMessagingProtocol;

public class RaftClientMessagingProtocol
extends RaftMessagingProtocol
implements RaftClientProtocol {
    public RaftClientMessagingProtocol(MessagingService messagingService, Serializer serializer, Function<MemberId, Address> addressProvider) {
        super(messagingService, serializer, addressProvider);
    }

    public CompletableFuture<OpenSessionResponse> openSession(MemberId memberId, OpenSessionRequest request) {
        return this.sendAndReceive(memberId, "open-session", request);
    }

    public CompletableFuture<CloseSessionResponse> closeSession(MemberId memberId, CloseSessionRequest request) {
        return this.sendAndReceive(memberId, "close-session", request);
    }

    public CompletableFuture<KeepAliveResponse> keepAlive(MemberId memberId, KeepAliveRequest request) {
        return this.sendAndReceive(memberId, "keep-alive", request);
    }

    public CompletableFuture<QueryResponse> query(MemberId memberId, QueryRequest request) {
        return this.sendAndReceive(memberId, "query", request);
    }

    public CompletableFuture<CommandResponse> command(MemberId memberId, CommandRequest request) {
        return this.sendAndReceive(memberId, "command", request);
    }

    public CompletableFuture<MetadataResponse> metadata(MemberId memberId, MetadataRequest request) {
        return this.sendAndReceive(memberId, "metadata", request);
    }

    public void registerHeartbeatHandler(Function<HeartbeatRequest, CompletableFuture<HeartbeatResponse>> handler) {
        this.registerHandler("heartbeat", handler);
    }

    public void unregisterHeartbeatHandler() {
        this.unregisterHandler("heartbeat");
    }

    public void reset(Set<MemberId> members, ResetRequest request) {
        for (MemberId memberId : members) {
            this.sendAsync(memberId, String.format("reset-%d", request.session()), request);
        }
    }

    public void registerPublishListener(SessionId sessionId, Consumer<PublishRequest> listener, Executor executor) {
        this.messagingService.registerHandler(String.format("publish-%d", sessionId.id()), (e, p) -> listener.accept((PublishRequest)this.serializer.decode(p)), executor);
    }

    public void unregisterPublishListener(SessionId sessionId) {
        this.messagingService.unregisterHandler(String.format("publish-%d", sessionId.id()));
    }
}

