/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import com.hubspot.jinjava.el.ExpressionResolver;
import com.hubspot.jinjava.interpret.Context;
import com.hubspot.jinjava.interpret.DeferredValue;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.OutputTooBigException;
import com.hubspot.jinjava.interpret.RenderTimings;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.random.ConstantZeroRandomNumberGenerator;
import com.hubspot.jinjava.random.DeferredRandomNumberGenerator;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TreeParser;
import com.hubspot.jinjava.tree.output.BlockInfo;
import com.hubspot.jinjava.tree.output.BlockPlaceholderOutputNode;
import com.hubspot.jinjava.tree.output.OutputList;
import com.hubspot.jinjava.tree.output.OutputNode;
import com.hubspot.jinjava.tree.output.RenderedOutputNode;
import com.hubspot.jinjava.util.Logging;
import com.hubspot.jinjava.util.Variable;
import com.hubspot.jinjava.util.WhitespaceUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;

public class JinjavaInterpreter {
    private final Multimap<String, BlockInfo> blocks = ArrayListMultimap.create();
    private final LinkedList<Node> extendParentRoots = new LinkedList();
    private Context context;
    private final JinjavaConfig config;
    private final ExpressionResolver expressionResolver;
    private final Jinjava application;
    private final Random random;
    private int lineNumber = -1;
    private int position = 0;
    private int scopeDepth = 1;
    private final List<TemplateError> errors = new LinkedList<TemplateError>();
    private static final int MAX_ERROR_SIZE = 100;
    private static final ThreadLocal<Stack<JinjavaInterpreter>> CURRENT_INTERPRETER = ThreadLocal.withInitial(Stack::new);

    public JinjavaInterpreter(Jinjava application, Context context, JinjavaConfig renderConfig) {
        this.context = context;
        this.config = renderConfig;
        this.application = application;
        switch (this.config.getRandomNumberGeneratorStrategy()) {
            case THREAD_LOCAL: {
                this.random = ThreadLocalRandom.current();
                break;
            }
            case CONSTANT_ZERO: {
                this.random = new ConstantZeroRandomNumberGenerator();
                break;
            }
            case DEFERRED: {
                this.random = new DeferredRandomNumberGenerator();
                break;
            }
            default: {
                throw new IllegalStateException("No random number generator with strategy " + (Object)((Object)this.config.getRandomNumberGeneratorStrategy()));
            }
        }
        this.expressionResolver = new ExpressionResolver(this, application.getExpressionFactory());
    }

    public JinjavaInterpreter(JinjavaInterpreter orig) {
        this(orig.application, new Context(orig.context), orig.config);
        this.scopeDepth = orig.getScopeDepth() + 1;
    }

    @Deprecated
    public JinjavaConfig getConfiguration() {
        return this.config;
    }

    public void addExtendParentRoot(Node root) {
        this.extendParentRoots.add(root);
    }

    public void addBlock(String name, BlockInfo blockInfo) {
        this.blocks.put(name, blockInfo);
    }

    public InterpreterScopeClosable enterScope() {
        return this.enterScope(null);
    }

    public InterpreterScopeClosable enterScope(Map<Context.Library, Set<String>> disabled) {
        this.context = new Context(this.context, null, disabled);
        ++this.scopeDepth;
        return new InterpreterScopeClosable();
    }

    public void leaveScope() {
        Context parent = this.context.getParent();
        --this.scopeDepth;
        if (parent != null) {
            parent.addDependencies(this.context.getDependencies());
            this.context = parent;
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean isValidationMode() {
        return this.config.isValidationMode();
    }

    public Node parse(String template) {
        return new TreeParser(this, template).buildTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderFlat(String template) {
        int depth = this.context.getRenderDepth();
        try {
            if (depth > this.config.getMaxRenderDepth()) {
                Logging.ENGINE_LOG.warn("Max render depth exceeded: {}", (Object)Integer.toString(depth));
                String string = template;
                return string;
            }
            this.context.setRenderDepth(depth + 1);
            String string = this.render(this.parse(template), false);
            return string;
        }
        finally {
            this.context.setRenderDepth(depth);
        }
    }

    public String render(String template) {
        return this.render(this.parse(template), true);
    }

    public String render(Node root) {
        return this.render(root, true);
    }

    public String render(Node root, boolean processExtendRoots) {
        OutputNode out;
        OutputList output = new OutputList(this.config.getMaxOutputSize());
        for (Node node : root.getChildren()) {
            this.lineNumber = node.getLineNumber();
            this.position = node.getStartPosition();
            String renderStr = node.getMaster().getImage();
            if (this.context.doesRenderStackContain(renderStr)) {
                this.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.EXCEPTION, TemplateError.ErrorItem.TAG, "Rendering cycle detected: '" + renderStr + "'", null, this.getLineNumber(), node.getStartPosition(), null, BasicTemplateErrorCategory.IMPORT_CYCLE_DETECTED, ImmutableMap.of("string", renderStr)));
                try {
                    output.addNode(new RenderedOutputNode(renderStr));
                    continue;
                }
                catch (OutputTooBigException e) {
                    this.addError(TemplateError.fromOutputTooBigException(e));
                    return output.getValue();
                }
            }
            this.context.pushRenderStack(renderStr);
            try {
                out = node.render(this);
            }
            catch (DeferredValueException e) {
                this.context.addDeferredNode(node);
                out = new RenderedOutputNode(node.getMaster().getImage());
            }
            this.context.popRenderStack();
            try {
                output.addNode(out);
            }
            catch (OutputTooBigException e) {
                this.addError(TemplateError.fromOutputTooBigException(e));
                return output.getValue();
            }
        }
        if (processExtendRoots) {
            while (!this.extendParentRoots.isEmpty()) {
                this.context.getCurrentPathStack().push(this.context.getExtendPathStack().peek().orElse(""), this.context.getExtendPathStack().getTopLineNumber(), this.context.getExtendPathStack().getTopStartPosition());
                Node parentRoot = this.extendParentRoots.removeFirst();
                output = new OutputList(this.config.getMaxOutputSize());
                for (Node node : parentRoot.getChildren()) {
                    this.lineNumber = node.getLineNumber() - 1;
                    this.position = node.getStartPosition();
                    out = node.render(this);
                    try {
                        output.addNode(out);
                    }
                    catch (OutputTooBigException e) {
                        this.addError(TemplateError.fromOutputTooBigException(e));
                        return output.getValue();
                    }
                }
                this.context.getExtendPathStack().pop();
                this.context.getCurrentPathStack().pop();
            }
        }
        this.resolveBlockStubs(output);
        return output.getValue();
    }

    private void resolveBlockStubs(OutputList output) {
        this.resolveBlockStubs(output, new Stack<String>());
    }

    @SuppressFBWarnings(justification="Iterables#getFirst DOES allow null for default value", value={"NP_NONNULL_PARAM_VIOLATION"})
    private void resolveBlockStubs(OutputList output, Stack<String> blockNames) {
        for (BlockPlaceholderOutputNode blockPlaceholder : output.getBlocks()) {
            Collection<BlockInfo> blockChain;
            BlockInfo block;
            if (!blockNames.contains(blockPlaceholder.getBlockName()) && (block = (BlockInfo)Iterables.getFirst(blockChain = this.blocks.get(blockPlaceholder.getBlockName()), null)) != null && block.getNodes() != null) {
                List superBlock = Optional.ofNullable(Iterables.get(blockChain, 1, null)).map(BlockInfo::getNodes).orElse(null);
                this.context.setSuperBlock(superBlock);
                OutputList blockValueBuilder = new OutputList(this.config.getMaxOutputSize());
                for (Node node : block.getNodes()) {
                    this.lineNumber = node.getLineNumber();
                    this.position = node.getStartPosition();
                    boolean pushedParentPathOntoStack = false;
                    if (block.getParentPath().isPresent() && !this.getContext().getCurrentPathStack().contains(block.getParentPath().get())) {
                        this.getContext().getCurrentPathStack().push(block.getParentPath().get(), block.getParentLineNo(), block.getParentPosition());
                        pushedParentPathOntoStack = true;
                        --this.lineNumber;
                    }
                    blockValueBuilder.addNode(node.render(this));
                    if (!pushedParentPathOntoStack) continue;
                    this.getContext().getCurrentPathStack().pop();
                }
                blockNames.push(blockPlaceholder.getBlockName());
                this.resolveBlockStubs(blockValueBuilder, blockNames);
                blockNames.pop();
                this.context.removeSuperBlock();
                blockPlaceholder.resolve(blockValueBuilder.getValue());
            }
            if (blockPlaceholder.isResolved()) continue;
            blockPlaceholder.resolve("");
        }
    }

    public Object retraceVariable(String variable, int lineNumber, int startPosition) {
        if (StringUtils.isBlank(variable)) {
            return "";
        }
        Variable var = new Variable(this, variable);
        String varName = var.getName();
        Object obj = this.context.get(varName);
        if (obj != null) {
            if (obj instanceof DeferredValue) {
                throw new DeferredValueException(variable, lineNumber, startPosition);
            }
            obj = var.resolve(obj);
        }
        return obj;
    }

    public Object retraceVariable(String variable, int lineNumber) {
        return this.retraceVariable(variable, lineNumber, -1);
    }

    public Object resolveObject(String variable, int lineNumber, int startPosition) {
        if (StringUtils.isBlank(variable)) {
            return "";
        }
        if (WhitespaceUtils.isQuoted(variable)) {
            return WhitespaceUtils.unquote(variable);
        }
        Object val = this.retraceVariable(variable, lineNumber, startPosition);
        if (val == null) {
            return variable;
        }
        return val;
    }

    public Object resolveObject(String variable, int lineNumber) {
        return this.resolveObject(variable, lineNumber, -1);
    }

    public String resolveString(String variable, int lineNumber, int startPosition) {
        return Objects.toString(this.resolveObject(variable, lineNumber, startPosition), "");
    }

    public String resolveString(String variable, int lineNumber) {
        return this.resolveString(variable, lineNumber, -1);
    }

    public Context getContext() {
        return this.context;
    }

    public String resolveResourceLocation(String location) {
        return this.application.getResourceLocator().getLocationResolver().map(resolver -> resolver.resolve(location, this)).orElse(location);
    }

    public String getResource(String resource) throws IOException {
        return this.application.getResourceLocator().getString(resource, this.config.getCharset(), this);
    }

    public JinjavaConfig getConfig() {
        return this.config;
    }

    public Object resolveELExpression(String expression, int lineNumber) {
        this.lineNumber = lineNumber;
        return this.expressionResolver.resolveExpression(expression);
    }

    public Object resolveProperty(Object object, String propertyName) {
        return this.resolveProperty(object, Collections.singletonList(propertyName));
    }

    public Object resolveProperty(Object object, List<String> propertyNames) {
        return this.expressionResolver.resolveProperty(object, propertyNames);
    }

    public Object wrap(Object object) {
        return this.expressionResolver.wrap(object);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void addError(TemplateError templateError) {
        if (!this.context.getCurrentPathStack().isEmpty()) {
            if (!templateError.getSourceTemplate().isPresent()) {
                templateError.setMessage(this.getWrappedErrorMessage(this.context.getCurrentPathStack().peek().get(), templateError));
                templateError.setSourceTemplate(this.context.getCurrentPathStack().peek().get());
            }
            templateError.setStartPosition(this.context.getCurrentPathStack().getTopStartPosition());
            templateError.setLineno(this.context.getCurrentPathStack().getTopLineNumber());
        }
        if (this.errors.size() < 100) {
            this.errors.add(templateError.withScopeDepth(this.scopeDepth));
        }
    }

    public int getScopeDepth() {
        return this.scopeDepth;
    }

    @Deprecated
    public void addAllErrors(Collection<TemplateError> other) {
        if (this.errors.size() >= 100) {
            return;
        }
        other.stream().limit(100 - this.errors.size()).forEach(this::addError);
    }

    public void addAllChildErrors(String childTemplateName, Collection<TemplateError> childErrors) {
        if (this.errors.size() >= 100) {
            return;
        }
        childErrors.stream().limit(100 - this.errors.size()).forEach(error -> {
            if (!error.getSourceTemplate().isPresent()) {
                error.setMessage(this.getWrappedErrorMessage(childTemplateName, (TemplateError)error));
                error.setSourceTemplate(childTemplateName);
            }
            error.setStartPosition(this.getPosition());
            error.setLineno(this.getLineNumber());
            this.addError((TemplateError)error);
        });
    }

    public List<TemplateError> getErrors() {
        return this.getErrorsCopy();
    }

    public List<TemplateError> getErrorsCopy() {
        return Lists.newArrayList(this.errors);
    }

    public static JinjavaInterpreter getCurrent() {
        if (CURRENT_INTERPRETER.get().isEmpty()) {
            return null;
        }
        return CURRENT_INTERPRETER.get().peek();
    }

    public static Optional<JinjavaInterpreter> getCurrentMaybe() {
        return Optional.ofNullable(JinjavaInterpreter.getCurrent());
    }

    public static void pushCurrent(JinjavaInterpreter interpreter) {
        CURRENT_INTERPRETER.get().push(interpreter);
    }

    public static void popCurrent() {
        if (!CURRENT_INTERPRETER.get().isEmpty()) {
            CURRENT_INTERPRETER.get().pop();
        }
    }

    public void startRender(String name) {
        RenderTimings renderTimings = (RenderTimings)this.getContext().get("request");
        if (renderTimings != null) {
            renderTimings.start(this, name);
        }
    }

    public void endRender(String name) {
        RenderTimings renderTimings = (RenderTimings)this.getContext().get("request");
        if (renderTimings != null) {
            renderTimings.end(this, name);
        }
    }

    public void endRender(String name, Map<String, Object> data) {
        RenderTimings renderTimings = (RenderTimings)this.getContext().get("request");
        if (renderTimings != null) {
            renderTimings.end(this, name, data);
        }
    }

    private String getWrappedErrorMessage(String childTemplateName, TemplateError templateError) {
        String lineNumber;
        String severity = templateError.getSeverity() == TemplateError.ErrorType.WARNING ? "Warning" : "Error";
        String string = lineNumber = templateError.getLineno() > 0 ? String.format(" on line %d", templateError.getLineno()) : "";
        if (Strings.isNullOrEmpty(templateError.getMessage())) {
            return String.format("Unknown %s in file `%s`%s", severity.toLowerCase(), childTemplateName, lineNumber);
        }
        return String.format("%s in `%s`%s: %s", severity, childTemplateName, lineNumber, templateError.getMessage());
    }

    public class InterpreterScopeClosable
    implements AutoCloseable {
        @Override
        public void close() {
            JinjavaInterpreter.this.leaveScope();
        }
    }
}

