/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.conf.ZeppelinConfiguration;

public class K8sUtils {
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private static final long MINIMUM_OVERHEAD = 384L;
    private static final String ZEPPELIN = "zeppelin";

    private K8sUtils() {
    }

    public static String calculateMemoryWithDefaultOverhead(String memory) {
        long memoryMB = K8sUtils.convertToBytes(memory) / 0x100000L;
        long memoryOverheadMB = Math.max((long)((float)memoryMB * 0.1f), 384L);
        return memoryMB + memoryOverheadMB + "Mi";
    }

    public static String calculateSparkMemory(String memory, String memoryOverhead) {
        long memoryMB = K8sUtils.convertToBytes(memory) / 0x100000L;
        long memoryOverheadMB = K8sUtils.convertToBytes(memoryOverhead) / 0x100000L;
        return memoryMB + memoryOverheadMB + "Mi";
    }

    private static long convertToBytes(String memory) {
        String lower = memory.toLowerCase().trim();
        Matcher m = Pattern.compile("([0-9]+)([a-z]+)?").matcher(lower);
        if (!m.matches()) {
            throw new NumberFormatException("Failed to parse string: " + memory);
        }
        long value = Long.parseLong(m.group(1));
        String suffix = m.group(2);
        long memoryAmountBytes = value;
        if (StringUtils.containsIgnoreCase(suffix, "k")) {
            memoryAmountBytes = value * 1024L;
        } else if (StringUtils.containsIgnoreCase(suffix, "m")) {
            memoryAmountBytes = value * 0x100000L;
        } else if (StringUtils.containsIgnoreCase(suffix, "g")) {
            memoryAmountBytes = value * 0x40000000L;
        } else if (StringUtils.containsIgnoreCase(suffix, "t")) {
            memoryAmountBytes = value * 0x10000000000L;
        }
        if (0L > memoryAmountBytes) {
            throw new NumberFormatException("Conversion of " + memory + " exceeds Long.MAX_VALUE");
        }
        return memoryAmountBytes;
    }

    public static String getCurrentK8sNamespace() {
        try {
            if (K8sUtils.isRunningOnKubernetes()) {
                return K8sUtils.readFile("/var/run/secrets/kubernetes.io/serviceaccount/namespace", Charset.defaultCharset()).trim();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getInterpreterNamespace(Properties properties, ZeppelinConfiguration zConf) throws IOException {
        if (properties.containsKey("zeppelin.k8s.interpreter.namespace")) {
            return properties.getProperty("zeppelin.k8s.interpreter.namespace");
        }
        if (K8sUtils.isRunningOnKubernetes()) {
            return K8sUtils.getCurrentK8sNamespace();
        }
        return zConf.getK8sNamepsace();
    }

    public static boolean isRunningOnKubernetes() {
        return new File("/var/run/secrets/kubernetes.io/serviceaccount/namespace").exists();
    }

    private static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public static String generateK8sName(String baseName, boolean randomSuffix) {
        String result = ZEPPELIN;
        if (StringUtils.isNotBlank(baseName)) {
            result = baseName.toLowerCase();
            result = result.replaceAll("[^a-z0-9\\.-]", "");
            if ((result = result.replaceAll("\\.+", ".")).isEmpty() || !Character.isLetterOrDigit(result.charAt(0))) {
                result = ZEPPELIN + result;
            }
            if (result.length() > 246 - ZEPPELIN.length()) {
                result = result.substring(0, 246 - ZEPPELIN.length());
            }
            if (!Character.isLetterOrDigit(result.charAt(result.length() - 1))) {
                result = result + ZEPPELIN;
            }
        }
        return randomSuffix ? result + "-" + RandomStringUtils.randomAlphabetic(6).toLowerCase() : result;
    }
}

