/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlExpression;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt2;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DBVEntityAttribute
implements DBSEntityAttribute,
DBPNamedObject2,
DBPImageProvider,
DBSTypedObjectExt2 {
    private final DBVEntity entity;
    private final DBVEntityAttribute parent;
    private final List<DBVEntityAttribute> children = new ArrayList<DBVEntityAttribute>();
    private String name;
    private String defaultValue;
    private String description;
    private boolean custom;
    private String expression;
    private DBPDataKind dataKind = DBPDataKind.UNKNOWN;
    private String typeName;
    private long maxLength = -1L;
    private Integer precision;
    private Integer scale;
    private DBVTransformSettings transformSettings;
    private Map<String, Object> properties;
    private JexlExpression parsedExpression;

    public DBVEntityAttribute(DBVEntity entity, DBVEntityAttribute parent, String name) {
        this.entity = entity;
        this.parent = parent;
        this.name = name;
    }

    DBVEntityAttribute(DBVEntity entity, DBVEntityAttribute parent, DBVEntityAttribute copy) {
        this.entity = entity;
        this.parent = parent;
        this.name = copy.name;
        for (DBVEntityAttribute child : copy.children) {
            this.children.add(new DBVEntityAttribute(entity, this, child));
        }
        this.defaultValue = copy.defaultValue;
        this.description = copy.description;
        this.custom = copy.custom;
        this.expression = copy.expression;
        this.dataKind = copy.dataKind;
        this.typeName = copy.typeName;
        DBVTransformSettings dBVTransformSettings = this.transformSettings = copy.transformSettings == null ? null : new DBVTransformSettings(copy.transformSettings);
        if (!CommonUtils.isEmpty(copy.properties)) {
            this.properties = new LinkedHashMap<String, Object>(copy.properties);
        }
    }

    DBVEntityAttribute(DBVEntity entity, DBVEntityAttribute parent, String name, Map<String, Object> map) {
        this(entity, parent, name);
        this.custom = JSONUtils.getBoolean(map, "custom");
        if (this.custom) {
            this.expression = JSONUtils.getString(map, "expression");
            this.dataKind = (DBPDataKind)CommonUtils.valueOf(DBPDataKind.class, (String)JSONUtils.getString(map, "dataKind"), (Enum)DBPDataKind.UNKNOWN);
            this.typeName = JSONUtils.getString(map, "typeName");
        }
        this.properties = JSONUtils.deserializeProperties(map, "properties");
        Map<String, Object> transformsCfg = JSONUtils.getObject(map, "transforms");
        if (!transformsCfg.isEmpty()) {
            DBDAttributeTransformerDescriptor transformer;
            this.transformSettings = new DBVTransformSettings();
            this.transformSettings.setCustomTransformer(JSONUtils.getString(transformsCfg, "custom"));
            for (String incTrans : JSONUtils.deserializeStringList(transformsCfg, "include")) {
                transformer = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(incTrans);
                if (transformer == null) continue;
                this.transformSettings.enableTransformer(transformer, true);
            }
            for (String excTrans : JSONUtils.deserializeStringList(transformsCfg, "exclude")) {
                transformer = DBWorkbench.getPlatform().getValueHandlerRegistry().getTransformer(excTrans);
                if (transformer == null) continue;
                this.transformSettings.enableTransformer(transformer, false);
            }
            this.transformSettings.setTransformOptions(JSONUtils.deserializeProperties(transformsCfg, "properties"));
        }
    }

    @Override
    @NotNull
    public DBVEntity getParentObject() {
        return this.entity;
    }

    @NotNull
    public DBVEntity getEntity() {
        return this.entity;
    }

    @Nullable
    public DBVEntityAttribute getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.entity.getDataSource();
    }

    @Override
    @Property(editable=true)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Property(editable=true)
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public void setTypeName(@NotNull String typeName) {
        this.typeName = typeName;
    }

    @Override
    @NotNull
    public String getFullTypeName() {
        return this.getTypeName();
    }

    @Override
    public int getTypeID() {
        return -1;
    }

    @Override
    @Property(editable=true)
    @NotNull
    public DBPDataKind getDataKind() {
        return this.dataKind;
    }

    public void setDataKind(DBPDataKind dataKind) {
        this.dataKind = dataKind;
    }

    @Override
    @Nullable
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setScale(@Nullable Integer scale) {
        this.scale = scale;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(@Nullable Integer precision) {
        this.precision = precision;
    }

    @Override
    public long getMaxLength() {
        return this.maxLength;
    }

    @Override
    public long getTypeModifiers() {
        return 0L;
    }

    @Override
    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public int getOrdinalPosition() {
        return 0;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public void setRequired(boolean required) {
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    @Property(editable=true)
    @Nullable
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.parsedExpression = null;
    }

    public List<DBVEntityAttribute> getChildren() {
        return this.children;
    }

    public DBVEntityAttribute getChild(String name) {
        return DBUtils.findObject(this.children, name);
    }

    public void addChild(DBVEntityAttribute child) {
        this.children.add(child);
    }

    public DBVTransformSettings getTransformSettings() {
        return this.transformSettings;
    }

    public void setTransformSettings(DBVTransformSettings transformSettings) {
        this.transformSettings = transformSettings;
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties == null ? Collections.emptyMap() : this.properties;
    }

    @Nullable
    public Object getProperty(String name) {
        return CommonUtils.isEmpty(this.properties) ? null : this.properties.get(name);
    }

    public void setProperty(String name, @Nullable Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public boolean hasValuableData() {
        if (!(CommonUtils.isEmpty((String)this.defaultValue) && CommonUtils.isEmpty((String)this.description) && CommonUtils.isEmpty((String)this.expression))) {
            return true;
        }
        if (!this.children.isEmpty()) {
            for (DBVEntityAttribute child : this.children) {
                if (!child.hasValuableData()) continue;
                return true;
            }
        }
        return this.transformSettings != null && this.transformSettings.hasValuableData() || !CommonUtils.isEmpty(this.properties);
    }

    public JexlExpression getParsedExpression() {
        if (this.parsedExpression == null) {
            if (CommonUtils.isEmpty((String)this.expression)) {
                return null;
            }
            this.parsedExpression = DBVUtils.parseExpression(this.expression);
        }
        return this.parsedExpression;
    }

    public String toString() {
        return this.name;
    }

    @Override
    @Nullable
    public DBPImage getObjectImage() {
        return DBValueFormatting.getTypeImage(this);
    }
}

