---
stage: Tenant Scale
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: グループを管理する
---

グループを使用して、関連する1つ以上のプロジェクトを同時に管理します。

{{< alert type="note" >}}

GitLab Self-Managedで組織全体の概要を表示する場合は、トップレベルグループを1つ作成する必要があります。すべてのグループの組織ビューを作成する取り組みについて詳しくは、[エピック9266](https://gitlab.com/groups/gitlab-org/-/epics/9266)をご覧ください。トップレベルグループは、完全な[セキュリティダッシュボードとセンター](../application_security/security_dashboard/_index.md)、[脆弱性レポート](../application_security/vulnerability_report/_index.md)、[コンプライアンスセンター](../compliance/compliance_center/_index.md)、[バリューストリーム分析](value_stream_analytics/_index.md)を通じて、組織全体のインサイトを提供します。

{{< /alert >}}

## グループのReadmeを追加する

Readmeファイルを追加して、チームに関する情報を提供し、ユーザーにプロジェクトへのコントリビュートを促すことができます。Readmeはグループの概要ページに表示されます。すべてのグループメンバーがReadmeを表示および編集できます。

前提要件:

- グループ設定からReadmeを作成するには、グループのオーナーロールが必要です。

グループのReadmeを追加するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **グループのREADME**セクションで、**Readmeを追加**を選択します。この操作により、`README.md`ファイルを含む新しいプロジェクト`gitlab-profile`が作成されます。
1. README作成のプロンプトで、**READMEを作成し追加**を選択します。Web IDEにリダイレクトされ、Readmeファイルが作成されます。
1. Web IDEで、`README.md`ファイルを編集してコミットします。

## グループのオーナーを変更する

グループのオーナーを変更できます。各グループには、オーナーロールを持つメンバーが少なくとも1人必要です。

- 管理者として、次を実行します。
  1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
  1. **管理 > メンバー**を選択します。
  1. 別のメンバーにオーナーロールを付与します。
  1. ページを更新します。これで、元のオーナーからオーナーロールを削除できるようになります。
- 現在のグループのオーナーとして、次を実行します。
  1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
  1. **管理 > メンバー**を選択します。
  1. 別のメンバーにオーナーロールを付与します。
  1. 新しいオーナーにサインインしてもらい、あなたのオーナーロールを削除してもらいます。

## グループのパスを変更する

グループのパス(グループURL)を変更すると、意図しない副次効果が発生する可能性があります。続行する前に、[プロジェクト](../project/repository/_index.md#repository-path-changes)と[API](../../api/rest/_index.md#redirects)のリダイレクトの動作を確認してください。

別のグループまたはユーザーが要求できるようにパスを変更する場合は、グループの名前も変更する必要があります。名前とパスは一意である必要があります。

元のネームスペースのオーナーシップを保持し、URLリダイレクトを保護するには、新しいグループを作成し、代わりにプロジェクトを転送します。

グループパス(グループURL)を変更するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **詳細設定**セクションを展開します。
1. **グループのURLの変更**で、新しい名前を入力します。
1. **グループのURLの変更**を選択します。

{{< alert type="warning" >}}

[コンテナレジストリ](../packages/container_registry/_index.md)タグを持つプロジェクトが含まれている場合、プロジェクトを移動できないため、ネームスペースの名前を変更することはできません。

{{< /alert >}}

{{< alert type="warning" >}}

数千のサブグループを持つグループが正しく処理されるようにするには、テスト環境でパスの変更をテストする必要があります。[Pumaワーカーのタイムアウト](../../administration/operations/puma.md#change-the-worker-timeout)を一時的に増やすことを検討してください。このタイムアウトのリスクを緩和するためのソリューションについて詳しくは、[イシュー432065](https://gitlab.com/gitlab-org/gitlab/-/issues/432065)をご覧ください。{{< /alert >}}

## グループのデフォルトブランチ保護を変更する

GitLabインスタンスの管理者は、[インスタンス内のすべてのプロジェクト](../project/repository/branches/default.md#for-all-projects-in-an-instance)に対してデフォルトブランチ保護を設定できます。そのインスタンス内のグループは、グローバルレベルで設定されたブランチ保護を継承します。グループオーナーは、グループ内のプロジェクトに対して[インスタンス設定を上書き](../project/repository/branches/default.md#for-all-projects-in-a-group)できます。[GitLab PremiumまたはUltimate](https://about.gitlab.com/pricing/)では、インスタンスの管理者はこの権限を無効にできます。

## 最初のブランチにカスタム名を使用する

GitLabで新しいプロジェクトを作成すると、最初のプッシュでデフォルトブランチが作成されます。グループオーナーは、グループのニーズに合わせて、グループのプロジェクトの[最初のブランチをカスタマイズ](../project/repository/branches/default.md#change-the-default-branch-name-for-new-projects-in-a-group)できます。

## グループを転送する

グループを転送すると、同じGitLabインスタンス内の別の場所に移動します。次のことができます。

- サブグループを新しい親グループに転送します。
- トップレベルグループを目的のグループに転送して、サブグループに変換します。
- サブグループを現在のグループから転送して、トップレベルグループに変換します。

グループを別のGitLabインスタンスにコピーする必要がある場合は、[直接転送でグループを移行](import/_index.md)します。

グループを転送する際は、次の点に注意してください。

- グループの親を変更すると、意図しない副次効果が発生する可能性があります。[リポジトリパスの変更時に何が起こるか](../project/repository/_index.md#repository-path-changes)をご覧ください。
- ローカルリポジトリを更新して、新しい場所を指定する必要があります。
- 直属の親グループの表示レベルがグループの現在の表示レベルよりも低い場合、サブグループとプロジェクトの表示レベルは、新しい親グループの表示レベルに合わせて変更されます。
- 明示的なグループメンバーシップのみが転送され、継承されたメンバーシップは転送されません。グループのオーナーが継承されたメンバーシップのみを持っている場合、グループにオーナーがいなくなります。この場合、グループを転送するユーザーがグループのオーナーになります。
- グループがトップレベルグループであり、グループ内のいずれかのプロジェクト、またはそのサブグループのいずれかに[命名規則](../packages/npm_registry/_index.md#naming-convention)に従う[NPMパッケージ](../packages/npm_registry/_index.md)が存在する場合、転送は失敗します。
- アーカイブされたプロジェクトの`container_registry`イメージは、転送前に削除する必要があります。詳細については、[トラブルシューティングセクション](troubleshooting.md#missing-or-insufficient-permission-delete-button-disabled)を参照してください。
- グループレベルのエンドポイント(Maven、NuGet、PyPI、Composer、Debian)を使用する既存のパッケージは、グループレベルのエンドポイントを設定するためのパッケージの手順に従って更新する必要があります。
- パッケージがインスタンスレベルのエンドポイント([Maven](../packages/maven_repository/_index.md#naming-convention)、[npm](../packages/npm_registry/_index.md#naming-convention)、[Conan](../packages/conan_repository/_index.md#package-recipe-naming-convention-for-instance-remotes))を使用し、グループが別のトップレベルグループに移動された場合、既存のパッケージ名を更新する必要があります。
- GitLab.comでサブスクリプションを使用しているトップレベルグループは転送できません。転送を可能にするには、最初にトップレベルグループのサブスクリプションを削除する必要があります。次に、トップレベルグループをサブグループとして別のトップレベルグループに転送できます。

前提要件:

- ソースグループとターゲットグループのオーナーロールが必要です。

グループを転送するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **詳細設定**セクションを展開します。
1. **グループを転送する**を選択します。
1. ドロップダウンメニューでグループ名を選択します。
1. **グループを転送する**を選択します。

## メール通知を無効にする

グループに関連するすべてのメール通知を無効にすることができます。これには、サブグループとプロジェクトが含まれます。

メール通知を無効にするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**セクションを展開します。
1. **メール通知を有効にする**チェックボックスをオフにします。

### メール通知で差分プレビューを無効にする

{{< history >}}

- GitLab 15.6で`diff_preview_in_email`[フラグとともに](../../administration/feature_flags.md)[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/24733)。デフォルトで無効になっています。
- GitLab 17.1で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/382055)になりました。機能フラグ`diff_preview_in_email`を削除しました。

{{< /history >}}

マージリクエストでコードにコメントすると、GitLabは参加者へのメール通知に差分の数行を含めます。一部の組織ポリシーでは、メールを安全性の低いシステムとして扱うか、メールのインフラストラクチャを自身で管理していない場合があります。これにより、知的財産(IP)またはソースコードのアクセス制御にリスクが発生する可能性があります。

前提要件:

- グループのオーナーロールが必要です。

グループ内のすべてのプロジェクトの差分プレビューを無効にするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**を展開します。
1. **差分プレビューを含める**をオフにします。
1. **変更を保存**を選択します。

## グループおよびプロジェクトアクセストークンの有効期限メール

{{< history >}}

- 継承されたグループメンバーへの通知は、GitLab 17.7で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/463016)されました（`pat_expiry_inherited_members_notification` という[フラグ](../../administration/feature_flags.md)を使用）。デフォルトで無効になっています。
- 機能フラグ`pat_expiry_inherited_members_notification`は、GitLab 17.10でデフォルトで[有効になっています](https://gitlab.com/gitlab-org/gitlab/-/issues/393772)。

{{< /history >}}

{{< alert type="flag" >}}

継承されたプロジェクトおよびグループメンバーへのメールの可用性は、機能フラグによって制御されます。詳細については履歴を参照してください。

{{< /alert >}}

次のグループおよびプロジェクトメンバーは、まもなく期限切れになるアクセストークンに関する通知メールを受信します。

- グループアクセストークン:
  - オーナーロールを持つメンバー。
  - GitLab 17.7以降で、グループまたはその親グループに適切な設定が構成されている場合は、グループのオーナーロールを継承するメンバー。
- プロジェクトアクセストークン:
  - 少なくともメンテナーロールを持つプロジェクトのメンバー。
  - GitLab 17.7以降では、そのグループまたはその親グループに適切な設定が構成されている場合、プロジェクトがグループに属しているためにオーナーまたはメンテナーロールを継承したプロジェクトメンバー。

次の手順に従うと、グループの継承されたメンバーへの通知を有効にできます。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**を展開します。
1. **当グループ内のグループとプロジェクトアクセストークンに関する有効期限通知メールは以下の対象に発送すべきです：**で、**グループまたはプロジェクトのすべての直接メンバーと継承メンバー**を選択します。
1. （オプション）**すべてのサブグループに実施する**チェックボックスをオンにします。
1. **変更を保存**を選択します。

詳細については、以下を参照してください。

- グループについては、[グループアクセストークンのドキュメント](settings/group_access_tokens.md#group-access-token-expiry-emails)を参照してください。
- プロジェクトについては、[プロジェクトアクセストークンのドキュメント](../project/settings/project_access_tokens.md#project-access-token-expiry-emails)を参照してください。

## グループアクセストークンの有効期限に関する追加のWebhookトリガーを追加する

{{< history >}}

- GitLab 17.9で、`pat_expiry_inherited_members_notification`という名前の[フラグ](../../administration/feature_flags.md)とともに、60日と30日のトリガーがプロジェクトとグループアクセストークンWebhookに[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/463016)されました。デフォルトで無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

この機能の可用性は、機能フラグによって制御されます。詳細については履歴を参照してください。

{{< /alert >}}

GitLabは、グループトークンの有効期限が切れる前に、複数の[有効期限メール](settings/group_access_tokens.md#group-access-token-expiry-emails)を送信し、関連する[Webhook](../project/integrations/webhook_events.md#project-and-group-access-token-events)をトリガーします。デフォルトでは、GitLabはトークンの有効期限が切れる7日前のみにこれらのWebhookをトリガーします。この機能が有効になっている場合、GitLabはトークンの有効期限が切れる60日前と30日前にもこれらのWebhookをトリガーできます。

これらのWebhookの追加のトリガーを有効にするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**セクションを展開します。
1. **Extended Group Access Tokens Expiry Webhook execution(拡張グループアクセストークン有効期限Webhookを実行)**チェックボックスをオンにします。
1. **変更を保存**を選択します。

## グループメンションを無効にする

ユーザーが会話に追加されたり、ユーザーがメンバーになっている[グループに誰かがメンション](../discussions/_index.md#mentions)すると通知されたりするのを防ぐことができます。

メンションが無効になっているグループは、オートコンプリートドロップダウンリストでそれに応じて視覚化されます。

これらの視覚的な合図は、多数のユーザーがいるグループに特に役立ちます。

グループメンションを無効にするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**セクションを展開します。
1. **グループメンションは無効です**を選択します。
1. **変更を保存**を選択します。

## メンバーをCSVとしてエクスポートする

{{< details >}}

- プラン: Premium、Ultimate
- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループまたはサブグループのメンバーリストをCSVとしてエクスポートできます。

1. 左側のサイドバーで、**検索または移動**を選択し、グループまたはサブグループを見つけます。
1. **管理 > メンバー**を選択します。
1. **CSV形式でエクスポート**を選択します。
1. CSVファイルが生成されると、リクエストしたユーザーに添付ファイルとしてメールで送信されます。

出力には、直接メンバーと祖先グループから継承されたメンバーがリストされます。選択したグループに`Minimal Access`を持つメンバーの場合、`Max Role`と`Source`はサブグループのメンバーシップから派生します。[イシュー390358](https://gitlab.com/gitlab-org/gitlab/-/issues/390358)は、グループメンバーCSVエクスポートリストがUIメンバーリストと一致しないことに関するディスカッションを追跡します。

## 制限付きアクセスをオンにする

{{< details >}}

- プラン: Premium、Ultimate
- 提供: GitLab.com
- 状態: ベータ

{{< /details >}}

{{< history >}}

- GitLab 17.5で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/442718)されました。

{{< /history >}}

制限付きアクセスを使用すると、超過料金を防げます。超過料金は、サブスクリプションのシート数を超えた場合に発生し、次回の[四半期ごとの調整](../../subscriptions/quarterly_reconciliation.md)で支払う必要があります。

制限付きアクセスをオンにすると、サブスクリプションに残りのシートがない場合、グループは新しい請求対象ユーザーを追加できません。

前提要件:

- グループのオーナーロールが必要です。
- グループまたはそのサブグループまたはプロジェクトの1つが外部で共有されていない状態である必要があります。

制限付きアクセスをオンにするには、次の手順に従います。

1. 左側のサイドバーで、**設定 > 一般**を選択します。
1. **権限とグループ機能**を展開します。
1. **シートコントロール**で、**制限付きアクセス**を選択します。

### 既知の問題

制限付きアクセスをオンにすると、次の既知の問題が発生し、超過が発生する可能性があります。

- シート数は、次の場合はまだ超過する可能性があります。
  - SAMLまたはSCIMを使用して新しいメンバーを追加し、サブスクリプションのシート数を超えた場合。
  - オーナーロールを持つ複数のユーザーが同時にメンバーを追加している場合。
  - 新しい請求対象メンバーが招待の承諾を遅らせている場合。
  - ユーザーキャパシティから制限付きアクセスへの変更、および制限付きアクセスへの変更前に承認待ちのメンバーがいる場合。この場合、これらのメンバーは保留状態のままです。制限付きアクセスを使用しているときに保留中のメンバーが承認された場合、サブスクリプションのシート数を超える可能性があります。
- 現在のサブスクリプションよりも少ないユーザー数でGitLabセールスチームを通じてサブスクリプションを更新すると、超過料金が発生します。この料金を回避するには、更新が開始される前に追加のユーザーを削除してください。たとえば、20人のユーザーがいて、15人のユーザーに対してサブスクリプションを更新する場合、5人の追加ユーザーに対して超過料金が請求されます。

さらに、制限付きアクセスが、次のように標準の非超過フローをブロックする可能性があります。

- 請求対象ロールに更新または追加されたサービスボットを誤ってブロックする。
- メールを介して既存の請求対象ユーザーを招待または更新した場合に、そのユーザーを予期せずにブロックする。

## グループのユーザーキャパシティ

{{< history >}}

- GitLab 16.3の[GitLab.comで有効になりました](https://gitlab.com/groups/gitlab-org/-/epics/9263)。
- GitLab 17.1で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/421693)になり、機能フラグ`saas_user_caps`が削除されました。

{{< /history >}}

GitLab Self-Managedのユーザー[キャパシティ](../../administration/settings/sign_up_restrictions.md#user-cap)については、こちらをご覧ください。

請求対象メンバーの数がユーザーキャパシティに達すると、グループオーナーは新規メンバーを承認する必要があります。

ユーザーキャパシティ機能を有効にしたグループは、グループとそのサブグループに対して[グループ共有](../project/members/sharing_projects_groups.md#invite-a-group-to-a-group)が無効になります。

### グループのユーザーキャパシティを指定する

前提要件:

- グループのオーナーの役割を割り当てられている必要があります。

ユーザーキャパシティを指定するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。トップレベルグループでのみキャパシティを設定できます。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**を展開します。
1. **シートの管理**から、**ユーザーキャパシティを設定する**チェックボックスを選択し、フィールドにユーザー数を入力します。
1. **変更を保存**を選択します。

グループ内のユーザー数がユーザーキャパシティ値よりも既に多い場合でも、ユーザーは削除されません。ただし、承認なしに追加することはできません。

ユーザーキャパシティを増やしても、保留中のメンバーは承認されません。

### グループのユーザーキャパシティを削除する

ユーザーキャパシティを削除して、グループに追加できるメンバーの数を無制限にすることができます。

前提要件:

- グループのオーナーの役割を割り当てられている必要があります。

ユーザーキャパシティを削除するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **権限とグループ機能**を展開します。
1. **シートの管理**から**オープンアクセス**を選択します。
1. **変更を保存**を選択します。

ユーザーキャパシティを減らしても、保留中のメンバーは承認されません。

### グループの保留中のメンバーを承認する

請求対象ユーザーの数がユーザーキャパシティに達すると、新しいメンバーは保留状態になります。追加するには、彼らを承認する必要があります。

保留中のメンバーは請求対象としてカウントされません。承認されて保留状態でなくなった後のみ、そのメンバーが請求対象としてカウントされます。

前提要件:

- グループのオーナーの役割を割り当てられている必要があります。

ユーザーキャパシティを超過したために保留になっているメンバーを承認するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 使用量割り当て**を選択します。
1. **シート**タブのアラートの下にある**保留中のユーザー承認を表示**を選択します。
1. 承認するメンバーごとに、**承認**を選択します。

### 既知の問題

グループ、サブグループ、またはプロジェクトが外部で共有されている場合、ユーザーキャパシティを有効にすることはできません。グループ、サブグループ、またはプロジェクトが外部で共有されている場合、階層内のレベルに関係なく、ネームスペース階層の外部で共有されます。

グループ、サブグループ、またはプロジェクトが外部で共有されている場合にユーザーキャパシティが適用されるようにするには、トップレベルのネームスペースでのみグループ共有を制限します。トップレベルでネームスペースを制限することで、同じネームスペースでの招待の許可、外部共有からの新しいユーザー(シート)の追加の防止が可能となります。

GitLab.com Ultimateには、請求対象ユーザーがユーザーキャパシティを超えている場合、ゲストユーザーをグループに追加できないという[既知の問題](https://gitlab.com/gitlab-org/gitlab/-/issues/441504)があります。たとえば、ユーザーキャパシティが5人で、3人のデベロッパーと2人のゲストがいるとします。さらに2人のデベロッパーを追加すると、請求可能なシートを消費しないゲストユーザーであっても、ユーザーを追加できなくなります。

## グループファイルテンプレート

{{< details >}}

- プラン: Premium、Ultimate
- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループファイルテンプレートを使用すると、グループ内のすべてのプロジェクトで、一般的なファイルタイプの一連のテンプレートを共有できます。これは、[インスタンステンプレートリポジトリ](../../administration/settings/instance_template_repository.md)に似ています。選択したプロジェクトは、そのページに記載されているのと同じ命名規則に従う必要があります。

テンプレートソースとしてグループ内のプロジェクトのみを選択できます。これにはグループと共有されているプロジェクトが含まれますが、構成されているグループのサブグループまたは親グループ内のプロジェクトは**除外**されます。

サブグループと直属の親グループの両方に対して、この機能を設定できます。サブグループ内のプロジェクトは、そのサブグループと直属の親グループのテンプレートにアクセスできます。

イシューとマージリクエストのテンプレートを作成する方法については、[説明テンプレート](../project/description_templates.md)を参照してください。

グループをテンプレートソースとして設定して、グループレベルでプロジェクトテンプレートを定義します。詳細については、[グループレベルのプロジェクトテンプレート](custom_project_templates.md)を参照してください。

### グループファイルテンプレートを有効にする

{{< details >}}

- プラン: Premium、Ultimate
- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループファイルテンプレートを有効にするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **テンプレート**セクションを展開します。
1. テンプレートリポジトリとして機能するプロジェクトを選択します。
1. **変更を保存**を選択します。

## グループマージチェックを設定する

{{< details >}}

- プラン: Premium、Ultimate
- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.9で、`support_group_level_merge_checks_setting`という名前の[フラグとともに](../../administration/feature_flags.md)[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/372040)されました。デフォルトで無効になっています。
- GitLab 16.9で、[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/142708)になりました。機能フラグ`support_group_level_merge_checks_setting`を削除しました。

{{< /history >}}

グループオーナーは、トップレベルグループでマージリクエストチェックを設定できます。これは、すべてのサブグループとプロジェクトに適用されます。

設定がサブグループまたはプロジェクトによって継承されている場合、継承元のサブグループまたはプロジェクトで変更することはできません。

### マージに成功したパイプラインを必須にする

グループ内のすべての子プロジェクトで、マージ前に完全かつ成功したパイプラインを必須にするように設定できます。

[プロジェクトレベルの設定](../project/merge_requests/auto_merge.md#require-a-successful-pipeline-for-merge)も参照してください。

前提要件:

- グループのオーナーである必要があります。

この設定を有効にするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **マージリクエスト**を展開します。
1. **マージチェック**で、**パイプラインが完了している**を選択します。これを設定すると、パイプラインがない場合はマージリクエストのマージも防止されます。
1. **変更を保存**を選択します。

#### スキップされたパイプラインの後にマージを許可する

[スキップされたパイプライン](../../ci/pipelines/_index.md#skip-a-pipeline)を設定して、マージリクエストがマージされないようにすることができます。

[プロジェクトレベルの設定](../project/merge_requests/auto_merge.md#allow-merge-after-skipped-pipelines)も参照してください。

前提要件:

- グループのオーナーである必要があります。

この動作を変更するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **マージリクエスト**を展開します。
1. **マージチェック**の下で、
   - **パイプラインが完了している**を選択します。
   - **スキップされたパイプラインは成功したと見なされます**を選択します。
1. **変更を保存**を選択します。

### すべてのスレッドが解決されるまでマージを禁止する

すべてのスレッドが解決されるまで、マージリクエストがマージされないようにすることができます。この設定を有効にすると、グループ内の子プロジェクトでは、少なくとも1つの未解決スレッドがあるマージリクエストの未解決スレッド数がオレンジ色で表示されます。

前提要件:

- グループのオーナーである必要があります。

この設定を有効にするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **マージリクエスト**を展開します。
1. **マージチェック**で、**すべてのスレッドが解決している**を選択します。
1. **変更を保存**を選択します。

## グループのマージリクエスト承認設定

{{< details >}}

- プラン: Premium、Ultimate
- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループの承認設定では、トップレベルグループ内のすべてのプロジェクトに対して[プロジェクトのマージリクエスト承認設定](../project/merge_requests/approvals/settings.md)を管理します。これらの設定は、グループに属する[すべてのプロジェクトに反映されます](../project/merge_requests/approvals/settings.md#cascade-settings-from-the-instance-or-top-level-group)。

グループのマージリクエスト承認設定を表示するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **設定 > 一般**を選択します。
1. **マージリクエストの承認**セクションを展開します。
1. 必要な設定を選択します。
1. **変更を保存**を選択します。

承認設定を[承認ルール](../project/merge_requests/approvals/rules.md)と混同しないようにしてください。グループのマージリクエスト承認ルールを設定する機能のサポートは、[エピック4367](https://gitlab.com/groups/gitlab-org/-/epics/4367)で追跡されます。

## グループアクティビティ分析

{{< details >}}

- プラン: Premium、Ultimate
- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループの場合、過去90日間に作成されたマージリクエスト、イシュー、およびメンバーの数を確認できます。

[グループWiki](../project/wiki/group.md)への変更は、グループアクティビティ分析には表示されません。

### グループアクティビティを表示する

次の手順に従うと、グループで実行された最新のアクションをブラウザまたはRSSフィードで表示できます。

1. 左側のサイドバーで、**検索または移動**を選択して、グループを見つけます。
1. **管理 > アクティビティー**を選択します。

Atom形式でアクティビティフィードを表示するには、**RSS**({{< icon name="rss" >}})アイコンを選択します。
