module mem_org_mode 
#( 
  parameter WIDTH=32,
  parameter CONDUIT_WIDTH=2
)
(
   input clk,
   input resetn,

   // Agent port
   input [WIDTH-1:0] agent_writedata,
   input agent_read,
   input agent_write,
   output agent_readdata,
   output agent_waitrequest,

   output [CONDUIT_WIDTH-1:0] mem_organization_kernel,
   output [CONDUIT_WIDTH-1:0] mem_organization_host
);

reg [CONDUIT_WIDTH-1:0] mem_organization;
assign agent_waitrequest = 1'b0;


(* altera_attribute  = "-name SDC_STATEMENT \"set_false_path -from [get_registers *mem_organization*]\"" *)
always@(posedge clk or negedge resetn)
  if (!resetn)
    mem_organization <= {CONDUIT_WIDTH{1'b0}};
  else if (agent_write)
    mem_organization <= agent_writedata;

assign mem_organization_kernel = mem_organization;
assign mem_organization_host = mem_organization;

assign agent_readdata = mem_organization;

endmodule

