# (c) 1992-2024 Intel Corporation.                                              
# Intel, the Intel logo, Intel, MegaCore, NIOS II, Quartus and TalkBack         
# words and logos are trademarks of Intel Corporation or its                    
# subsidiaries in the U.S. and/or other countries. Other marks and              
# brands may be claimed as the property of others.                              
# See Trademarks on intel.com for full list of Intel trademarks or the          
# Trademarks & Brands Names Database (if Intel)                                 
# or See www.Intel.com/legal (if Altera)                                        
# Your use of Intel Corporation's design tools, logic functions and             
# other software and tools, and its AMPP partner logic functions, and           
# any output files any of the foregoing (including device programming           
# or simulation files), and any associated documentation or information         
# are expressly subject to the terms and conditions of the Altera               
# Program License Subscription Agreement, Intel MegaCore Function               
# License Agreement, or other applicable license agreement, including,          
# without limitation, that your use is for the sole purpose of                  
# programming logic devices manufactured by Intel and sold by Intel or          
# its authorized distributors.                                                  
# Please refer to the applicable agreement for further details.                 


#  Inputs:  A target
#           One or more object file
#           An optional object library file name
#  Output:  An library file suitable for the target platform
#
#  Example:
#     Command:
#        fpga_libtool --create prim.a prim.o
#     Generates:
#        prim.a - object file suitable for use by the icpx compiler
#
# vim: set ts=2 sw=2 et

BEGIN {
  unshift @INC, (
    grep { -d $_ } (
      map { $ENV{INTELFPGAOCLSDKROOT} . $_ }
        qw(
        /host/windows64/bin/perl/lib/MSWin32-x64-multi-thread
        /host/windows64/bin/perl/lib
        /share/lib/perl
        /share/lib/perl/5.8.8 )
    )
  );
}


package FPGA_Libtool;
use strict;
use Exporter;
require acl::File;
require acl::Pkg;
require acl::Common;
use acl::AOCDriverCommon;
use acl::HLS_Pkg;

# checks host OS, returns true for linux, false for windows.
sub isLinux {
  if ($^O eq 'linux') {
    return 1;
  }
  return;
}

# Prefered to die, since die always prints where we bailed out (line number) 
sub myexit {
  my $exit_code = shift;
  if (scalar @_){
    my $message = shift;
    print STDERR "Error: $message\n";
  }
  exit $exit_code;
}

sub mybail {
  myexit (1, @_);
}

my $prog = acl::File::mybasename($0);
$prog =~ s/.pl$//;
my $usage =<<USAGE;
Usage: $prog --create <lib>.a <file>.o +
Options:
    -h, --help        Print this help, then exit successfully.
    -n, --dry-run     Don\'t actually do anything, just check command line
    --create <lib>.a
                      Create a library named <lib>.a. Existing
                      file will be overwritten
USAGE

sub create_sycl_library {
  my ($library_name, $objects) = @_;
  if (isLinux()) {
    (acl::Common::mysystem_full({},"ar rc $library_name @$objects")==0) or mybail "Not able to create library $library_name";
  } else {
    (acl::Common::mysystem_full({},"lib /NOLOGO /OUT:$library_name @$objects")==0) or mybail "Not able to create library $library_name";
  }
}

sub run() {
  my $library_name = undef;
  my @objects;
  my $verbose = undef;
  my $dry_run = 0;

  #Parse input
  while (@ARGV) {
    my $arg = shift @ARGV;

    if ( ($arg eq '-n') || ($arg eq '--dry-run') ) {
      $dry_run = 1;
    } elsif ( ($arg eq '-h') || ($arg eq '--help') ) {
      print $usage; exit 0;
    } elsif ($arg eq '-v') {
      $verbose +=1;
    } elsif ( $arg eq '--create' ) {
      ($#ARGV >= 0 and $ARGV[0] !~ m/^-./) or mybail "Option $arg requires a file argument.";
      $library_name = shift @ARGV;
    } elsif ( ( $arg eq '--target' )  ) {
      shift @ARGV;
      print("Warning: The --target flag is deprecated and will be ignored! This tool can only be used to target sycl.\n");
    } else {
      push @objects, $arg;
    }
  }

  acl::Common::set_verbose($verbose);

  # Check arguments
  ($library_name) or mybail "--create argument is required";
  ($#objects>=0) or mybail "at least one object file is required";

  my $input_suffix = undef;
  my $library_suffix = $library_name;
  $library_suffix =~ s/.*\.//;
  if ( isLinux() ) {
    $input_suffix = 'o';
    ($library_suffix eq 'a') or mybail "$library_name library must have the suffix .a";
  } else {
    $input_suffix = 'obj';
    ($library_suffix eq 'lib') or mybail "$library_name library must have the suffix .lib";
  }

  foreach my $input (@objects) {
    my $tmp = $input;
    $tmp =~ s/.*\.//;
    if ($tmp ne $input_suffix) {
      mybail "Cannot generate library of type $library_suffix based on object files of type $tmp";
    }
  }

  # Stop before packaging
  if ($dry_run) {
  exit (0);
  }

  create_sycl_library($library_name, \@objects);
}

run();
