import re
from functools import reduce
def convert_accesses_to_bytes(reads,writes,data_size,read_bw,write_bw=None):
 if not write_bw:
  write_bw=read_bw
 total_access=reads+writes
 total_bytes=total_access*data_size
 read_bytes=reads*data_size
 write_bytes=writes*data_size
 read_time=read_bytes/read_bw
 write_time=write_bytes/write_bw
 return total_bytes,read_bytes,write_bytes,read_time,write_time
def get_size_unit(size,units,base):
 unit=units[0]
 num=float(size)
 for u in units[:-1]:
  if num>base:
   num/=base
  else:
   unit=u
   break
 else:
  unit=units[-1]
 return num,unit
unit_prefixes_si=['','k','M','G','T']
class ValueLoader:
 def __init__(self,units,power_base,type_,unit_prefixes=None):
  self.units=units
  self.power_base=power_base
  self.type_=type_
  self.unit_prefixes=unit_prefixes or unit_prefixes_si
 def __call__(self,val):
  if isinstance(val,str):
   value=self.read_value(val)
  else:
   value=self.type_(val)
  return value
 def read_value(self,val_str):
  if self.units and val_str.endswith(self.units):
   val_str=val_str[:-len(self.units)]
  unit_multiplier=1
  if self.power_base:
   for prefix_idx,prefix in enumerate(self.unit_prefixes):
    if prefix and val_str.endswith(prefix):
     val_str=val_str[:-len(prefix)]
     unit_multiplier=pow(self.power_base,prefix_idx)
     break
  try:
   value=self.type_(unit_multiplier*float(val_str))
  except ValueError:
   raise
  return value
class ValueFormatter:
 NO_ZEROES=re.compile(r'\.?0+$')
 def __init__(self,units,power_base,signs_after_dot,value_unit_splitter=' ',unit_prefixes=None,):
  self.power_base=power_base if units else None
  self.number_fmt=f'{{value:.{signs_after_dot}f}}'
  self.fmt=f'{{value}}{value_unit_splitter}{{prefix}}{units}' if units else '{value}'
  self.unit_prefixes=unit_prefixes or unit_prefixes_si
 def __call__(self,value):
  if self.power_base:
   val,prefix=get_size_unit(value,self.unit_prefixes,self.power_base)
   val_str=self.number_fmt.format(value=val)
   val_str=self.NO_ZEROES.sub('',val_str)
   return self.fmt.format(value=val_str,prefix=prefix)
  else:
   return self.fmt.format(value=value,prefix='')
def work_size_to_str(data,delimiter='x',add_total_num=True):
 if not data:
  return ''
 res=delimiter.join(str(y)for y in data)
 if add_total_num and len(data)>1:
  res+=' ({})'.format(reduce(lambda x,y:x*y,data))
 return res
