# -*- coding: utf-8 -*-
#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#

import json
import os
import re
import sys

MAJOR, MINOR, _, _, _ = sys.version_info

template = r'''<!DOCTYPE html><html><head><meta charset="utf-8"><title>Joined Report</title><style>
table{font-family:arial;background-color:#CDCDCD;font-size:8pt;text-align:left;box-sizing:border-box;border-collapse:collapse}table thead tr th{background-color:#e6EEEE;border:1px solid #CDCDCD;font-size:8pt;padding:4px 0}.tablesorter thead tr th{width:100px;max-width:100px;min-width:100px}.tablesorter thead tr th.minwidth{width:30px;max-width:30px;min-width:30px}.tablesorter tbody tr td{max-width:10px}table tbody tr td{color:#3D3D3D;border:1px solid #CDCDCD;padding:4px;background-color:#FFF;vertical-align:top}table tbody tr.hidden td{display:none!important}table.tablesorter>.data-table-caption{display:table-caption;text-align:left;background:#fff;height:25px}table.tablesorter thead tr .tablesorter-header{background-image:url('data:image/png;base64,R0lGODlhFQAJAIAAACMtMP///yH5BAEAAAEALAAAAAAVAAkAAAIXjI+AywnaYnhUMoqt3gZXPmVg94yJVQAAOw==');background-repeat:no-repeat;background-position:center left;cursor:pointer}table.tablesorter thead th .tablesorter-header-inner{margin-left:15px;text-align:left;overflow:hidden;text-overflow:clip}table.tablesorter tbody tr.odd td{background-color:#F0F0F6}table.tablesorter thead tr .tablesorter-headerDesc{background-image:url('data:image/png;base64,R0lGODlhFQAEAIAAACMtMP///yH5BAEAAAEALAAAAAAVAAQAAAINjB+gC+jP2ptn0WskLQA7')}table.tablesorter thead tr .tablesorter-headerAsc{background-image:url('data:image/png;base64,R0lGODlhFQAEAIAAACMtMP///yH5BAEAAAEALAAAAAAVAAQAAAINjI8Bya2wnINUMopZAQA7')}table.tablesorter thead tr .tablesorter-headerAsc,table.tablesorter thead tr .tablesorter-headerDesc{background-color:#8dbdd8}table.tablesorter thead tr .tablesorter-header.sorter-false{background-image:none}.tablesorter .filtered{display:none}.tablesorter-filter-row td{background:#eee;line-height:normal;text-align:center;-webkit-transition:line-height .1s ease;-moz-transition:line-height .1s ease;-o-transition:line-height .1s ease;transition:line-height .1s ease}.tablesorter-filter-row .disabled{opacity:.5;filter:alpha(opacity=50);cursor:not-allowed}.tablesorter-filter-row.hideme td{padding:2px;margin:0;line-height:0;cursor:pointer}.tablesorter-filter-row.hideme *{height:1px;min-height:0;border:0;padding:0;margin:0;opacity:0;filter:alpha(opacity=0)}.tablesorter-filter{width:95%;height:inherit;margin:4px;padding:4px;background-color:#fff;border:1px solid #bbb;color:#333;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;-webkit-transition:height .1s ease;-moz-transition:height .1s ease;-o-transition:height .1s ease;transition:height .1s ease}.tablesorter-sticky-visible caption{padding-top:9px}.tablesorter thead .disabled{display:none}.overflow-wrapper .tablesorter td{overflow:hidden;text-overflow:ellipsis}.overflow-wrapper .tablesorter td{line-height:15px}.overflow-wrapper.collapsed .tablesorter td{max-width:10px}.overflow-wrapper.collapsed .tablesorter td>span{white-space:nowrap}.loading{height:100%;width:100%;display:table;position:fixed;background:#fff}.loading #nodata{display:table-cell;text-align:center;vertical-align:middle;font-size:20px;color:gray}#reset-filters,#fit-rows{font-family:arial;font-size:12px;position:fixed;width:120px;z-index:100}#fit-rows{left:130px}#additional_section{position:fixed;bottom:2px;display:inline-block;border:1px solid #bbb;z-index:100;background-color:#fff}#additional_section .content{display:flex;justify-content:space-around;align-items:center;flex-wrap:wrap}#additional_section .toggle-button{position:relative;height:10px;cursor:pointer;background:#bbb url('data:image/png;base64,R0lGODlhFQAEAIAAACMtMP///yH5BAEAAAEALAAAAAAVAAQAAAINjB+gC+jP2ptn0WskLQA7') center no-repeat}#additional_section .toggle-button.collapsed{background:#bbb url('data:image/png;base64,R0lGODlhFQAEAIAAACMtMP///yH5BAEAAAEALAAAAAAVAAQAAAINjI8Bya2wnINUMopZAQA7') center no-repeat;width:25px}#metrics-table{margin-left:2px;background-color:#e6EEEE;border:1px solid #bbb;font-size:14px}#metrics-table caption{font-size:20px}#metrics-table td.metric-value{text-align:right;color:#3D3D3D;font-weight:700}.cell-toggle-button{font-size:smaller;height:15px}
</style><script id="data"></script><script src="CURRENT_DIR/html/lib/jquery.min.js"></script><script src="CURRENT_DIR/html/lib/jquery.tablesorter.combined.min.js"></script><script>
function load(){if(!window.data||0===Object.keys(data).length)throw document.querySelector("#nodata").innerHTML="No Data Available",Error('The "data" object is not defined!');document.querySelector(".loading").visible(!1),document.querySelector(".loaded").visible(!0),new TableFiller({dataTable:document.querySelector("#data-table"),metricsTable:document.querySelector("#metrics-table")}).fill(data);var t=data.additional&&(data.additional.html_elems&&data.additional.html_elems.length>0||data.additional.images&&data.additional.images.length>0),e=data.metrics&&Object.keys(data.metrics).length>0,a=document.querySelector("#additional_section .content");if(t&&new SectionFiller({section:a}).fill(data.additional),e||t?document.querySelector("#additional_section .toggle-button").onclick=function(){a.visible(!a.isVisible()),this.classList.toggle("collapsed")}:document.querySelector("#additional_section").visible(!1),document.querySelectorAll(".cell-toggle-button").forEach(function(t){t.onclick=function(){var t=this;if(null!=t.parentElement&&null!=t.parentElement.parentElement){var e=t.parentElement.parentElement,a=e.classList.contains("collapsed");t.innerHTML=a?"-":"+",e.classList.toggle("collapsed");for(var r=e.nextElementSibling;r.classList.contains("tablesorter-childRow");)r.classList.contains(".fake")||(r.classList.toggle("hidden"),r=r.nextElementSibling)}}}),!window.$||!$().tablesorter)return document.querySelector("#reset-filters").visible(!1),document.querySelector("#fit-rows").visible(!1),void document.querySelector(".overflow-wrapper").classList.remove("overflow-wrapper");$("#data-table").tablesorter({theme:"blue",widthFixed:!1,sortInitialOrder:"desc",widgets:["zebra","resizable","filter","stickyHeaders"],widgetOptions:{filter_liveSearch:!0,filter_saveFilters:!0,filter_resetOnEsc:!0,filter_reset:"#filter-reset",resizable_addLastColumn:!0,resizable_includeFooter:!1,resizable_overflow:!0,stickyHeaders_includeCaption:!0}});var r=$(".overflow-wrapper");$("#fit-rows").on("click",function(){$(this).html(r.hasClass("collapsed")?"Fit row height":"Unfit row height"),r.toggleClass("collapsed").resize()})}function SectionFiller(t){t=t||{};var e=function(e){e&&e.forEach(function(e){var a=e instanceof Object,r=a?e.base64:e,n=a?e.width:"auto",l=a?e.height:"auto";createEl("img",{parent:t.section,attrs:{src:r,width:n,height:l}})})},a=function(e){e&&e.forEach(function(e){createEl("span",{parent:t.section,data:{html:e}})})};this.fill=function(r){r&&t.section&&(a(r.html_elems),e(r.images))}}function TableFiller(t){t=t||{};var e=function(e){if(e&&0!==Object.keys(e).length)for(var a in e)if(0!==e[a].length)if("caption"!=a){var r=createEl("td",{data:a+":",attrs:{class:"metric-key"}}),n=createEl("td",{data:e[a],attrs:{class:"metric-value"}});createEl("tr",{children:[r,n],parent:t.metricsTable})}else createEl("caption",{data:e[a],parent:t.metricsTable})},a=function(e){if(e&&0!==Object.keys(e).length){var a=t.dataTable;if(e.columns&&e.rows){var r=!!t.indexCol4DataTable;e.css&&window.appendStyle(e.css);for(var n=!1,l=0,i=e.rows.length;l<i;++l)if(!(e.rows[l]instanceof Array)){n=!!e.rows[l].parent;break}!function(t){var a=e.groups&&e.groups.length>0,l=createEl("tr",{parent:t}),i=a?2:1;if(n&&createEl("th",{data:"",parent:l,attrs:{class:"filter-false sorter-false minwidth",rowspan:i}}),r&&createEl("th",{data:"№",parent:l,attrs:{rowspan:i}}),a){for(e.groups.sort(function(t,e){return t.start-e.start}),f=0;f<e.groups[0].start;++f)createEl("th",{data:e.columns[f],parent:l,attrs:{rowspan:2}});for(var o=0;o<e.groups.length;++o){var s=e.groups[o],c=parseInt(s.end)-parseInt(s.start)+1,d={content:s.name,tooltip:s.description};createEl("th",{data:d,parent:l,attrs:{colspan:c}});for(var p=o<e.groups.length-1?e.groups[o+1].start:e.columns.length,f=s.end+1;f<p;++f)createEl("th",{data:e.columns[f],parent:l,attrs:{rowspan:2}})}l=createEl("tr",{parent:t}),e.groups.forEach(function(t){for(var a=t.start;a<=t.end;++a)createEl("th",{data:e.columns[a],parent:l})})}else e.columns.forEach(function(t){createEl("th",{data:t,parent:l})})}(createEl("thead",{parent:a})),function(t){var a=e.columns.length;e.rows.forEach(function(e,l){var i=0,o=!1;if(e instanceof Array)s=createEl("tr",{parent:t});else{if(e.child)s=createEl("tr",{parent:t,attrs:{class:"tablesorter-childRow"}}),o=!0;else if(e.parent){var s=createEl("tr",{parent:t});i=e.parent}e=e.data}if(n)if(0!==i||o)if(o)createEl("td",{parent:s,attrs:{style:"display: none",class:"fake"}});else{var c=createEl("button",{data:"-",attrs:{class:"cell-toggle-button"}});createEl("td",{children:[c],parent:s,attrs:{rowspan:i+1}})}else createEl("td",{parent:s});r&&createEl("td",{children:[createEl("span",{data:l})],parent:s});for(var d=0;d<a;++d){var p=e[d];p instanceof Object&&void 0!==p.style?(p.content=p.data,createEl("td",{children:[createEl("span",{data:p})],parent:s,attrs:{style:p.style}})):createEl("td",{children:[createEl("span",{data:p})],parent:s})}})}(createEl("tbody",{parent:a}))}}};this.fill=function(r){t.metricsTable&&e(r.metrics),t.dataTable&&a(r)}}window.onload=function(){load()},NodeList.prototype.forEach=Array.prototype.forEach;var elementsDisplayStyle=[];HTMLElement.prototype.visible=HTMLElement.prototype.Visible||function(t){"none"!=this.style.display&&(elementsDisplayStyle[this]=this.style.display),this in elementsDisplayStyle||(elementsDisplayStyle[this]="block"),this.style.display=t?elementsDisplayStyle[this]:"none"},HTMLElement.prototype.isVisible=HTMLElement.prototype.isVisible||function(){return!!(this.offsetWidth||this.offsetHeight||this.getClientRects().length)},window.appendStyle=function(t){var e=document.createElement("style");e.setAttribute("type","text/css"),"textContent"in e?e.textContent=t:e.styleSheet.cssText=t,document.querySelector("head").appendChild(e)},window.createEl=function(t){function e(t,e){"textContent"in t?t.textContent=e:t.innerText=e}if(!t)throw Error("The element name is not defined!");var a=document.createElement(t),r=arguments[1];if(!r)return a;var n=r.attrs;if(n)for(var l in n)a.setAttribute(l,n[l]);var i=r.data;return i&&(i instanceof Object?(void 0!==i.html?a.innerHTML=i.html:void 0!==i.content&&e(a,i.content),void 0!==i.tooltip&&(a.title=i.tooltip)):e(a,i)),r.children&&r.children.forEach(function(t){t&&a.appendChild(t)}),r.parent&&r.parent.appendChild(a),a};
</script></head><body><span class="loading"><span id="nodata">Data loading...</span> </span><span class="loaded" style="display:none"><div id="additional_section"><div class="toggle-button"></div><div class="content"><table id="metrics-table"></table></div></div><button id="reset-filters">Reset all filters</button> <button id="fit-rows">Fit row height</button><div class="overflow-wrapper"><table id="data-table"><caption class="data-table-caption"></caption></table></div></span></body></html>'''
libs = r'''<script>/*! jQuery v3.2.1 | (c) JS Foundation and other contributors | jquery.org/license */
!function(a,b){"use strict";"object"==typeof module&&"object"==typeof module.exports?module.exports=a.document?b(a,!0):function(a){if(!a.document)throw new Error("jQuery requires a window with a document");return b(a)}:b(a)}("undefined"!=typeof window?window:this,function(a,b){"use strict";var c=[],d=a.document,e=Object.getPrototypeOf,f=c.slice,g=c.concat,h=c.push,i=c.indexOf,j={},k=j.toString,l=j.hasOwnProperty,m=l.toString,n=m.call(Object),o={};function p(a,b){b=b||d;var c=b.createElement("script");c.text=a,b.head.appendChild(c).parentNode.removeChild(c)}var q="3.2.1",r=function(a,b){return new r.fn.init(a,b)},s=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,t=/^-ms-/,u=/-([a-z])/g,v=function(a,b){return b.toUpperCase()};r.fn=r.prototype={jquery:q,constructor:r,length:0,toArray:function(){return f.call(this)},get:function(a){return null==a?f.call(this):a<0?this[a+this.length]:this[a]},pushStack:function(a){var b=r.merge(this.constructor(),a);return b.prevObject=this,b},each:function(a){return r.each(this,a)},map:function(a){return this.pushStack(r.map(this,function(b,c){return a.call(b,c,b)}))},slice:function(){return this.pushStack(f.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(a){var b=this.length,c=+a+(a<0?b:0);return this.pushStack(c>=0&&c<b?[this[c]]:[])},end:function(){return this.prevObject||this.constructor()},push:h,sort:c.sort,splice:c.splice},r.extend=r.fn.extend=function(){var a,b,c,d,e,f,g=arguments[0]||{},h=1,i=arguments.length,j=!1;for("boolean"==typeof g&&(j=g,g=arguments[h]||{},h++),"object"==typeof g||r.isFunction(g)||(g={}),h===i&&(g=this,h--);h<i;h++)if(null!=(a=arguments[h]))for(b in a)c=g[b],d=a[b],g!==d&&(j&&d&&(r.isPlainObject(d)||(e=Array.isArray(d)))?(e?(e=!1,f=c&&Array.isArray(c)?c:[]):f=c&&r.isPlainObject(c)?c:{},g[b]=r.extend(j,f,d)):void 0!==d&&(g[b]=d));return g},r.extend({expando:"jQuery"+(q+Math.random()).replace(/\D/g,""),isReady:!0,error:function(a){throw new Error(a)},noop:function(){},isFunction:function(a){return"function"===r.type(a)},isWindow:function(a){return null!=a&&a===a.window},isNumeric:function(a){var b=r.type(a);return("number"===b||"string"===b)&&!isNaN(a-parseFloat(a))},isPlainObject:function(a){var b,c;return!(!a||"[object Object]"!==k.call(a))&&(!(b=e(a))||(c=l.call(b,"constructor")&&b.constructor,"function"==typeof c&&m.call(c)===n))},isEmptyObject:function(a){var b;for(b in a)return!1;return!0},type:function(a){return null==a?a+"":"object"==typeof a||"function"==typeof a?j[k.call(a)]||"object":typeof a},globalEval:function(a){p(a)},camelCase:function(a){return a.replace(t,"ms-").replace(u,v)},each:function(a,b){var c,d=0;if(w(a)){for(c=a.length;d<c;d++)if(b.call(a[d],d,a[d])===!1)break}else for(d in a)if(b.call(a[d],d,a[d])===!1)break;return a},trim:function(a){return null==a?"":(a+"").replace(s,"")},makeArray:function(a,b){var c=b||[];return null!=a&&(w(Object(a))?r.merge(c,"string"==typeof a?[a]:a):h.call(c,a)),c},inArray:function(a,b,c){return null==b?-1:i.call(b,a,c)},merge:function(a,b){for(var c=+b.length,d=0,e=a.length;d<c;d++)a[e++]=b[d];return a.length=e,a},grep:function(a,b,c){for(var d,e=[],f=0,g=a.length,h=!c;f<g;f++)d=!b(a[f],f),d!==h&&e.push(a[f]);return e},map:function(a,b,c){var d,e,f=0,h=[];if(w(a))for(d=a.length;f<d;f++)e=b(a[f],f,c),null!=e&&h.push(e);else for(f in a)e=b(a[f],f,c),null!=e&&h.push(e);return g.apply([],h)},guid:1,proxy:function(a,b){var c,d,e;if("string"==typeof b&&(c=a[b],b=a,a=c),r.isFunction(a))return d=f.call(arguments,2),e=function(){return a.apply(b||this,d.concat(f.call(arguments)))},e.guid=a.guid=a.guid||r.guid++,e},now:Date.now,support:o}),"function"==typeof Symbol&&(r.fn[Symbol.iterator]=c[Symbol.iterator]),r.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(a,b){j["[object "+b+"]"]=b.toLowerCase()});function w(a){var b=!!a&&"length"in a&&a.length,c=r.type(a);return"function"!==c&&!r.isWindow(a)&&("array"===c||0===b||"number"==typeof b&&b>0&&b-1 in a)}var x=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u="sizzle"+1*new Date,v=a.document,w=0,x=0,y=ha(),z=ha(),A=ha(),B=function(a,b){return a===b&&(l=!0),0},C={}.hasOwnProperty,D=[],E=D.pop,F=D.push,G=D.push,H=D.slice,I=function(a,b){for(var c=0,d=a.length;c<d;c++)if(a[c]===b)return c;return-1},J="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",K="[\\x20\\t\\r\\n\\f]",L="(?:\\\\.|[\\w-]|[^\0-\\xa0])+",M="\\["+K+"*("+L+")(?:"+K+"*([*^$|!~]?=)"+K+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+L+"))|)"+K+"*\\]",N=":("+L+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+M+")*)|.*)\\)|)",O=new RegExp(K+"+","g"),P=new RegExp("^"+K+"+|((?:^|[^\\\\])(?:\\\\.)*)"+K+"+$","g"),Q=new RegExp("^"+K+"*,"+K+"*"),R=new RegExp("^"+K+"*([>+~]|"+K+")"+K+"*"),S=new RegExp("="+K+"*([^\\]'\"]*?)"+K+"*\\]","g"),T=new RegExp(N),U=new RegExp("^"+L+"$"),V={ID:new RegExp("^#("+L+")"),CLASS:new RegExp("^\\.("+L+")"),TAG:new RegExp("^("+L+"|[*])"),ATTR:new RegExp("^"+M),PSEUDO:new RegExp("^"+N),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+K+"*(even|odd|(([+-]|)(\\d*)n|)"+K+"*(?:([+-]|)"+K+"*(\\d+)|))"+K+"*\\)|)","i"),bool:new RegExp("^(?:"+J+")$","i"),needsContext:new RegExp("^"+K+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+K+"*((?:-\\d)?\\d*)"+K+"*\\)|)(?=[^-]|$)","i")},W=/^(?:input|select|textarea|button)$/i,X=/^h\d$/i,Y=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,$=/[+~]/,_=new RegExp("\\\\([\\da-f]{1,6}"+K+"?|("+K+")|.)","ig"),aa=function(a,b,c){var d="0x"+b-65536;return d!==d||c?b:d<0?String.fromCharCode(d+65536):String.fromCharCode(d>>10|55296,1023&d|56320)},ba=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ca=function(a,b){return b?"\0"===a?"\ufffd":a.slice(0,-1)+"\\"+a.charCodeAt(a.length-1).toString(16)+" ":"\\"+a},da=function(){m()},ea=ta(function(a){return a.disabled===!0&&("form"in a||"label"in a)},{dir:"parentNode",next:"legend"});try{G.apply(D=H.call(v.childNodes),v.childNodes),D[v.childNodes.length].nodeType}catch(fa){G={apply:D.length?function(a,b){F.apply(a,H.call(b))}:function(a,b){var c=a.length,d=0;while(a[c++]=b[d++]);a.length=c-1}}}function ga(a,b,d,e){var f,h,j,k,l,o,r,s=b&&b.ownerDocument,w=b?b.nodeType:9;if(d=d||[],"string"!=typeof a||!a||1!==w&&9!==w&&11!==w)return d;if(!e&&((b?b.ownerDocument||b:v)!==n&&m(b),b=b||n,p)){if(11!==w&&(l=Z.exec(a)))if(f=l[1]){if(9===w){if(!(j=b.getElementById(f)))return d;if(j.id===f)return d.push(j),d}else if(s&&(j=s.getElementById(f))&&t(b,j)&&j.id===f)return d.push(j),d}else{if(l[2])return G.apply(d,b.getElementsByTagName(a)),d;if((f=l[3])&&c.getElementsByClassName&&b.getElementsByClassName)return G.apply(d,b.getElementsByClassName(f)),d}if(c.qsa&&!A[a+" "]&&(!q||!q.test(a))){if(1!==w)s=b,r=a;else if("object"!==b.nodeName.toLowerCase()){(k=b.getAttribute("id"))?k=k.replace(ba,ca):b.setAttribute("id",k=u),o=g(a),h=o.length;while(h--)o[h]="#"+k+" "+sa(o[h]);r=o.join(","),s=$.test(a)&&qa(b.parentNode)||b}if(r)try{return G.apply(d,s.querySelectorAll(r)),d}catch(x){}finally{k===u&&b.removeAttribute("id")}}}return i(a.replace(P,"$1"),b,d,e)}function ha(){var a=[];function b(c,e){return a.push(c+" ")>d.cacheLength&&delete b[a.shift()],b[c+" "]=e}return b}function ia(a){return a[u]=!0,a}function ja(a){var b=n.createElement("fieldset");try{return!!a(b)}catch(c){return!1}finally{b.parentNode&&b.parentNode.removeChild(b),b=null}}function ka(a,b){var c=a.split("|"),e=c.length;while(e--)d.attrHandle[c[e]]=b}function la(a,b){var c=b&&a,d=c&&1===a.nodeType&&1===b.nodeType&&a.sourceIndex-b.sourceIndex;if(d)return d;if(c)while(c=c.nextSibling)if(c===b)return-1;return a?1:-1}function ma(a){return function(b){var c=b.nodeName.toLowerCase();return"input"===c&&b.type===a}}function na(a){return function(b){var c=b.nodeName.toLowerCase();return("input"===c||"button"===c)&&b.type===a}}function oa(a){return function(b){return"form"in b?b.parentNode&&b.disabled===!1?"label"in b?"label"in b.parentNode?b.parentNode.disabled===a:b.disabled===a:b.isDisabled===a||b.isDisabled!==!a&&ea(b)===a:b.disabled===a:"label"in b&&b.disabled===a}}function pa(a){return ia(function(b){return b=+b,ia(function(c,d){var e,f=a([],c.length,b),g=f.length;while(g--)c[e=f[g]]&&(c[e]=!(d[e]=c[e]))})})}function qa(a){return a&&"undefined"!=typeof a.getElementsByTagName&&a}c=ga.support={},f=ga.isXML=function(a){var b=a&&(a.ownerDocument||a).documentElement;return!!b&&"HTML"!==b.nodeName},m=ga.setDocument=function(a){var b,e,g=a?a.ownerDocument||a:v;return g!==n&&9===g.nodeType&&g.documentElement?(n=g,o=n.documentElement,p=!f(n),v!==n&&(e=n.defaultView)&&e.top!==e&&(e.addEventListener?e.addEventListener("unload",da,!1):e.attachEvent&&e.attachEvent("onunload",da)),c.attributes=ja(function(a){return a.className="i",!a.getAttribute("className")}),c.getElementsByTagName=ja(function(a){return a.appendChild(n.createComment("")),!a.getElementsByTagName("*").length}),c.getElementsByClassName=Y.test(n.getElementsByClassName),c.getById=ja(function(a){return o.appendChild(a).id=u,!n.getElementsByName||!n.getElementsByName(u).length}),c.getById?(d.filter.ID=function(a){var b=a.replace(_,aa);return function(a){return a.getAttribute("id")===b}},d.find.ID=function(a,b){if("undefined"!=typeof b.getElementById&&p){var c=b.getElementById(a);return c?[c]:[]}}):(d.filter.ID=function(a){var b=a.replace(_,aa);return function(a){var c="undefined"!=typeof a.getAttributeNode&&a.getAttributeNode("id");return c&&c.value===b}},d.find.ID=function(a,b){if("undefined"!=typeof b.getElementById&&p){var c,d,e,f=b.getElementById(a);if(f){if(c=f.getAttributeNode("id"),c&&c.value===a)return[f];e=b.getElementsByName(a),d=0;while(f=e[d++])if(c=f.getAttributeNode("id"),c&&c.value===a)return[f]}return[]}}),d.find.TAG=c.getElementsByTagName?function(a,b){return"undefined"!=typeof b.getElementsByTagName?b.getElementsByTagName(a):c.qsa?b.querySelectorAll(a):void 0}:function(a,b){var c,d=[],e=0,f=b.getElementsByTagName(a);if("*"===a){while(c=f[e++])1===c.nodeType&&d.push(c);return d}return f},d.find.CLASS=c.getElementsByClassName&&function(a,b){if("undefined"!=typeof b.getElementsByClassName&&p)return b.getElementsByClassName(a)},r=[],q=[],(c.qsa=Y.test(n.querySelectorAll))&&(ja(function(a){o.appendChild(a).innerHTML="<a id='"+u+"'></a><select id='"+u+"-\r\\' msallowcapture=''><option selected=''></option></select>",a.querySelectorAll("[msallowcapture^='']").length&&q.push("[*^$]="+K+"*(?:''|\"\")"),a.querySelectorAll("[selected]").length||q.push("\\["+K+"*(?:value|"+J+")"),a.querySelectorAll("[id~="+u+"-]").length||q.push("~="),a.querySelectorAll(":checked").length||q.push(":checked"),a.querySelectorAll("a#"+u+"+*").length||q.push(".#.+[+~]")}),ja(function(a){a.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var b=n.createElement("input");b.setAttribute("type","hidden"),a.appendChild(b).setAttribute("name","D"),a.querySelectorAll("[name=d]").length&&q.push("name"+K+"*[*^$|!~]?="),2!==a.querySelectorAll(":enabled").length&&q.push(":enabled",":disabled"),o.appendChild(a).disabled=!0,2!==a.querySelectorAll(":disabled").length&&q.push(":enabled",":disabled"),a.querySelectorAll("*,:x"),q.push(",.*:")})),(c.matchesSelector=Y.test(s=o.matches||o.webkitMatchesSelector||o.mozMatchesSelector||o.oMatchesSelector||o.msMatchesSelector))&&ja(function(a){c.disconnectedMatch=s.call(a,"*"),s.call(a,"[s!='']:x"),r.push("!=",N)}),q=q.length&&new RegExp(q.join("|")),r=r.length&&new RegExp(r.join("|")),b=Y.test(o.compareDocumentPosition),t=b||Y.test(o.contains)?function(a,b){var c=9===a.nodeType?a.documentElement:a,d=b&&b.parentNode;return a===d||!(!d||1!==d.nodeType||!(c.contains?c.contains(d):a.compareDocumentPosition&&16&a.compareDocumentPosition(d)))}:function(a,b){if(b)while(b=b.parentNode)if(b===a)return!0;return!1},B=b?function(a,b){if(a===b)return l=!0,0;var d=!a.compareDocumentPosition-!b.compareDocumentPosition;return d?d:(d=(a.ownerDocument||a)===(b.ownerDocument||b)?a.compareDocumentPosition(b):1,1&d||!c.sortDetached&&b.compareDocumentPosition(a)===d?a===n||a.ownerDocument===v&&t(v,a)?-1:b===n||b.ownerDocument===v&&t(v,b)?1:k?I(k,a)-I(k,b):0:4&d?-1:1)}:function(a,b){if(a===b)return l=!0,0;var c,d=0,e=a.parentNode,f=b.parentNode,g=[a],h=[b];if(!e||!f)return a===n?-1:b===n?1:e?-1:f?1:k?I(k,a)-I(k,b):0;if(e===f)return la(a,b);c=a;while(c=c.parentNode)g.unshift(c);c=b;while(c=c.parentNode)h.unshift(c);while(g[d]===h[d])d++;return d?la(g[d],h[d]):g[d]===v?-1:h[d]===v?1:0},n):n},ga.matches=function(a,b){return ga(a,null,null,b)},ga.matchesSelector=function(a,b){if((a.ownerDocument||a)!==n&&m(a),b=b.replace(S,"='$1']"),c.matchesSelector&&p&&!A[b+" "]&&(!r||!r.test(b))&&(!q||!q.test(b)))try{var d=s.call(a,b);if(d||c.disconnectedMatch||a.document&&11!==a.document.nodeType)return d}catch(e){}return ga(b,n,null,[a]).length>0},ga.contains=function(a,b){return(a.ownerDocument||a)!==n&&m(a),t(a,b)},ga.attr=function(a,b){(a.ownerDocument||a)!==n&&m(a);var e=d.attrHandle[b.toLowerCase()],f=e&&C.call(d.attrHandle,b.toLowerCase())?e(a,b,!p):void 0;return void 0!==f?f:c.attributes||!p?a.getAttribute(b):(f=a.getAttributeNode(b))&&f.specified?f.value:null},ga.escape=function(a){return(a+"").replace(ba,ca)},ga.error=function(a){throw new Error("Syntax error, unrecognized expression: "+a)},ga.uniqueSort=function(a){var b,d=[],e=0,f=0;if(l=!c.detectDuplicates,k=!c.sortStable&&a.slice(0),a.sort(B),l){while(b=a[f++])b===a[f]&&(e=d.push(f));while(e--)a.splice(d[e],1)}return k=null,a},e=ga.getText=function(a){var b,c="",d=0,f=a.nodeType;if(f){if(1===f||9===f||11===f){if("string"==typeof a.textContent)return a.textContent;for(a=a.firstChild;a;a=a.nextSibling)c+=e(a)}else if(3===f||4===f)return a.nodeValue}else while(b=a[d++])c+=e(b);return c},d=ga.selectors={cacheLength:50,createPseudo:ia,match:V,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(a){return a[1]=a[1].replace(_,aa),a[3]=(a[3]||a[4]||a[5]||"").replace(_,aa),"~="===a[2]&&(a[3]=" "+a[3]+" "),a.slice(0,4)},CHILD:function(a){return a[1]=a[1].toLowerCase(),"nth"===a[1].slice(0,3)?(a[3]||ga.error(a[0]),a[4]=+(a[4]?a[5]+(a[6]||1):2*("even"===a[3]||"odd"===a[3])),a[5]=+(a[7]+a[8]||"odd"===a[3])):a[3]&&ga.error(a[0]),a},PSEUDO:function(a){var b,c=!a[6]&&a[2];return V.CHILD.test(a[0])?null:(a[3]?a[2]=a[4]||a[5]||"":c&&T.test(c)&&(b=g(c,!0))&&(b=c.indexOf(")",c.length-b)-c.length)&&(a[0]=a[0].slice(0,b),a[2]=c.slice(0,b)),a.slice(0,3))}},filter:{TAG:function(a){var b=a.replace(_,aa).toLowerCase();return"*"===a?function(){return!0}:function(a){return a.nodeName&&a.nodeName.toLowerCase()===b}},CLASS:function(a){var b=y[a+" "];return b||(b=new RegExp("(^|"+K+")"+a+"("+K+"|$)"))&&y(a,function(a){return b.test("string"==typeof a.className&&a.className||"undefined"!=typeof a.getAttribute&&a.getAttribute("class")||"")})},ATTR:function(a,b,c){return function(d){var e=ga.attr(d,a);return null==e?"!="===b:!b||(e+="","="===b?e===c:"!="===b?e!==c:"^="===b?c&&0===e.indexOf(c):"*="===b?c&&e.indexOf(c)>-1:"$="===b?c&&e.slice(-c.length)===c:"~="===b?(" "+e.replace(O," ")+" ").indexOf(c)>-1:"|="===b&&(e===c||e.slice(0,c.length+1)===c+"-"))}},CHILD:function(a,b,c,d,e){var f="nth"!==a.slice(0,3),g="last"!==a.slice(-4),h="of-type"===b;return 1===d&&0===e?function(a){return!!a.parentNode}:function(b,c,i){var j,k,l,m,n,o,p=f!==g?"nextSibling":"previousSibling",q=b.parentNode,r=h&&b.nodeName.toLowerCase(),s=!i&&!h,t=!1;if(q){if(f){while(p){m=b;while(m=m[p])if(h?m.nodeName.toLowerCase()===r:1===m.nodeType)return!1;o=p="only"===a&&!o&&"nextSibling"}return!0}if(o=[g?q.firstChild:q.lastChild],g&&s){m=q,l=m[u]||(m[u]={}),k=l[m.uniqueID]||(l[m.uniqueID]={}),j=k[a]||[],n=j[0]===w&&j[1],t=n&&j[2],m=n&&q.childNodes[n];while(m=++n&&m&&m[p]||(t=n=0)||o.pop())if(1===m.nodeType&&++t&&m===b){k[a]=[w,n,t];break}}else if(s&&(m=b,l=m[u]||(m[u]={}),k=l[m.uniqueID]||(l[m.uniqueID]={}),j=k[a]||[],n=j[0]===w&&j[1],t=n),t===!1)while(m=++n&&m&&m[p]||(t=n=0)||o.pop())if((h?m.nodeName.toLowerCase()===r:1===m.nodeType)&&++t&&(s&&(l=m[u]||(m[u]={}),k=l[m.uniqueID]||(l[m.uniqueID]={}),k[a]=[w,t]),m===b))break;return t-=e,t===d||t%d===0&&t/d>=0}}},PSEUDO:function(a,b){var c,e=d.pseudos[a]||d.setFilters[a.toLowerCase()]||ga.error("unsupported pseudo: "+a);return e[u]?e(b):e.length>1?(c=[a,a,"",b],d.setFilters.hasOwnProperty(a.toLowerCase())?ia(function(a,c){var d,f=e(a,b),g=f.length;while(g--)d=I(a,f[g]),a[d]=!(c[d]=f[g])}):function(a){return e(a,0,c)}):e}},pseudos:{not:ia(function(a){var b=[],c=[],d=h(a.replace(P,"$1"));return d[u]?ia(function(a,b,c,e){var f,g=d(a,null,e,[]),h=a.length;while(h--)(f=g[h])&&(a[h]=!(b[h]=f))}):function(a,e,f){return b[0]=a,d(b,null,f,c),b[0]=null,!c.pop()}}),has:ia(function(a){return function(b){return ga(a,b).length>0}}),contains:ia(function(a){return a=a.replace(_,aa),function(b){return(b.textContent||b.innerText||e(b)).indexOf(a)>-1}}),lang:ia(function(a){return U.test(a||"")||ga.error("unsupported lang: "+a),a=a.replace(_,aa).toLowerCase(),function(b){var c;do if(c=p?b.lang:b.getAttribute("xml:lang")||b.getAttribute("lang"))return c=c.toLowerCase(),c===a||0===c.indexOf(a+"-");while((b=b.parentNode)&&1===b.nodeType);return!1}}),target:function(b){var c=a.location&&a.location.hash;return c&&c.slice(1)===b.id},root:function(a){return a===o},focus:function(a){return a===n.activeElement&&(!n.hasFocus||n.hasFocus())&&!!(a.type||a.href||~a.tabIndex)},enabled:oa(!1),disabled:oa(!0),checked:function(a){var b=a.nodeName.toLowerCase();return"input"===b&&!!a.checked||"option"===b&&!!a.selected},selected:function(a){return a.parentNode&&a.parentNode.selectedIndex,a.selected===!0},empty:function(a){for(a=a.firstChild;a;a=a.nextSibling)if(a.nodeType<6)return!1;return!0},parent:function(a){return!d.pseudos.empty(a)},header:function(a){return X.test(a.nodeName)},input:function(a){return W.test(a.nodeName)},button:function(a){var b=a.nodeName.toLowerCase();return"input"===b&&"button"===a.type||"button"===b},text:function(a){var b;return"input"===a.nodeName.toLowerCase()&&"text"===a.type&&(null==(b=a.getAttribute("type"))||"text"===b.toLowerCase())},first:pa(function(){return[0]}),last:pa(function(a,b){return[b-1]}),eq:pa(function(a,b,c){return[c<0?c+b:c]}),even:pa(function(a,b){for(var c=0;c<b;c+=2)a.push(c);return a}),odd:pa(function(a,b){for(var c=1;c<b;c+=2)a.push(c);return a}),lt:pa(function(a,b,c){for(var d=c<0?c+b:c;--d>=0;)a.push(d);return a}),gt:pa(function(a,b,c){for(var d=c<0?c+b:c;++d<b;)a.push(d);return a})}},d.pseudos.nth=d.pseudos.eq;for(b in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})d.pseudos[b]=ma(b);for(b in{submit:!0,reset:!0})d.pseudos[b]=na(b);function ra(){}ra.prototype=d.filters=d.pseudos,d.setFilters=new ra,g=ga.tokenize=function(a,b){var c,e,f,g,h,i,j,k=z[a+" "];if(k)return b?0:k.slice(0);h=a,i=[],j=d.preFilter;while(h){c&&!(e=Q.exec(h))||(e&&(h=h.slice(e[0].length)||h),i.push(f=[])),c=!1,(e=R.exec(h))&&(c=e.shift(),f.push({value:c,type:e[0].replace(P," ")}),h=h.slice(c.length));for(g in d.filter)!(e=V[g].exec(h))||j[g]&&!(e=j[g](e))||(c=e.shift(),f.push({value:c,type:g,matches:e}),h=h.slice(c.length));if(!c)break}return b?h.length:h?ga.error(a):z(a,i).slice(0)};function sa(a){for(var b=0,c=a.length,d="";b<c;b++)d+=a[b].value;return d}function ta(a,b,c){var d=b.dir,e=b.next,f=e||d,g=c&&"parentNode"===f,h=x++;return b.first?function(b,c,e){while(b=b[d])if(1===b.nodeType||g)return a(b,c,e);return!1}:function(b,c,i){var j,k,l,m=[w,h];if(i){while(b=b[d])if((1===b.nodeType||g)&&a(b,c,i))return!0}else while(b=b[d])if(1===b.nodeType||g)if(l=b[u]||(b[u]={}),k=l[b.uniqueID]||(l[b.uniqueID]={}),e&&e===b.nodeName.toLowerCase())b=b[d]||b;else{if((j=k[f])&&j[0]===w&&j[1]===h)return m[2]=j[2];if(k[f]=m,m[2]=a(b,c,i))return!0}return!1}}function ua(a){return a.length>1?function(b,c,d){var e=a.length;while(e--)if(!a[e](b,c,d))return!1;return!0}:a[0]}function va(a,b,c){for(var d=0,e=b.length;d<e;d++)ga(a,b[d],c);return c}function wa(a,b,c,d,e){for(var f,g=[],h=0,i=a.length,j=null!=b;h<i;h++)(f=a[h])&&(c&&!c(f,d,e)||(g.push(f),j&&b.push(h)));return g}function xa(a,b,c,d,e,f){return d&&!d[u]&&(d=xa(d)),e&&!e[u]&&(e=xa(e,f)),ia(function(f,g,h,i){var j,k,l,m=[],n=[],o=g.length,p=f||va(b||"*",h.nodeType?[h]:h,[]),q=!a||!f&&b?p:wa(p,m,a,h,i),r=c?e||(f?a:o||d)?[]:g:q;if(c&&c(q,r,h,i),d){j=wa(r,n),d(j,[],h,i),k=j.length;while(k--)(l=j[k])&&(r[n[k]]=!(q[n[k]]=l))}if(f){if(e||a){if(e){j=[],k=r.length;while(k--)(l=r[k])&&j.push(q[k]=l);e(null,r=[],j,i)}k=r.length;while(k--)(l=r[k])&&(j=e?I(f,l):m[k])>-1&&(f[j]=!(g[j]=l))}}else r=wa(r===g?r.splice(o,r.length):r),e?e(null,g,r,i):G.apply(g,r)})}function ya(a){for(var b,c,e,f=a.length,g=d.relative[a[0].type],h=g||d.relative[" "],i=g?1:0,k=ta(function(a){return a===b},h,!0),l=ta(function(a){return I(b,a)>-1},h,!0),m=[function(a,c,d){var e=!g&&(d||c!==j)||((b=c).nodeType?k(a,c,d):l(a,c,d));return b=null,e}];i<f;i++)if(c=d.relative[a[i].type])m=[ta(ua(m),c)];else{if(c=d.filter[a[i].type].apply(null,a[i].matches),c[u]){for(e=++i;e<f;e++)if(d.relative[a[e].type])break;return xa(i>1&&ua(m),i>1&&sa(a.slice(0,i-1).concat({value:" "===a[i-2].type?"*":""})).replace(P,"$1"),c,i<e&&ya(a.slice(i,e)),e<f&&ya(a=a.slice(e)),e<f&&sa(a))}m.push(c)}return ua(m)}function za(a,b){var c=b.length>0,e=a.length>0,f=function(f,g,h,i,k){var l,o,q,r=0,s="0",t=f&&[],u=[],v=j,x=f||e&&d.find.TAG("*",k),y=w+=null==v?1:Math.random()||.1,z=x.length;for(k&&(j=g===n||g||k);s!==z&&null!=(l=x[s]);s++){if(e&&l){o=0,g||l.ownerDocument===n||(m(l),h=!p);while(q=a[o++])if(q(l,g||n,h)){i.push(l);break}k&&(w=y)}c&&((l=!q&&l)&&r--,f&&t.push(l))}if(r+=s,c&&s!==r){o=0;while(q=b[o++])q(t,u,g,h);if(f){if(r>0)while(s--)t[s]||u[s]||(u[s]=E.call(i));u=wa(u)}G.apply(i,u),k&&!f&&u.length>0&&r+b.length>1&&ga.uniqueSort(i)}return k&&(w=y,j=v),t};return c?ia(f):f}return h=ga.compile=function(a,b){var c,d=[],e=[],f=A[a+" "];if(!f){b||(b=g(a)),c=b.length;while(c--)f=ya(b[c]),f[u]?d.push(f):e.push(f);f=A(a,za(e,d)),f.selector=a}return f},i=ga.select=function(a,b,c,e){var f,i,j,k,l,m="function"==typeof a&&a,n=!e&&g(a=m.selector||a);if(c=c||[],1===n.length){if(i=n[0]=n[0].slice(0),i.length>2&&"ID"===(j=i[0]).type&&9===b.nodeType&&p&&d.relative[i[1].type]){if(b=(d.find.ID(j.matches[0].replace(_,aa),b)||[])[0],!b)return c;m&&(b=b.parentNode),a=a.slice(i.shift().value.length)}f=V.needsContext.test(a)?0:i.length;while(f--){if(j=i[f],d.relative[k=j.type])break;if((l=d.find[k])&&(e=l(j.matches[0].replace(_,aa),$.test(i[0].type)&&qa(b.parentNode)||b))){if(i.splice(f,1),a=e.length&&sa(i),!a)return G.apply(c,e),c;break}}}return(m||h(a,n))(e,b,!p,c,!b||$.test(a)&&qa(b.parentNode)||b),c},c.sortStable=u.split("").sort(B).join("")===u,c.detectDuplicates=!!l,m(),c.sortDetached=ja(function(a){return 1&a.compareDocumentPosition(n.createElement("fieldset"))}),ja(function(a){return a.innerHTML="<a href='#'></a>","#"===a.firstChild.getAttribute("href")})||ka("type|href|height|width",function(a,b,c){if(!c)return a.getAttribute(b,"type"===b.toLowerCase()?1:2)}),c.attributes&&ja(function(a){return a.innerHTML="<input/>",a.firstChild.setAttribute("value",""),""===a.firstChild.getAttribute("value")})||ka("value",function(a,b,c){if(!c&&"input"===a.nodeName.toLowerCase())return a.defaultValue}),ja(function(a){return null==a.getAttribute("disabled")})||ka(J,function(a,b,c){var d;if(!c)return a[b]===!0?b.toLowerCase():(d=a.getAttributeNode(b))&&d.specified?d.value:null}),ga}(a);r.find=x,r.expr=x.selectors,r.expr[":"]=r.expr.pseudos,r.uniqueSort=r.unique=x.uniqueSort,r.text=x.getText,r.isXMLDoc=x.isXML,r.contains=x.contains,r.escapeSelector=x.escape;var y=function(a,b,c){var d=[],e=void 0!==c;while((a=a[b])&&9!==a.nodeType)if(1===a.nodeType){if(e&&r(a).is(c))break;d.push(a)}return d},z=function(a,b){for(var c=[];a;a=a.nextSibling)1===a.nodeType&&a!==b&&c.push(a);return c},A=r.expr.match.needsContext;function B(a,b){return a.nodeName&&a.nodeName.toLowerCase()===b.toLowerCase()}var C=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i,D=/^.[^:#\[\.,]*$/;function E(a,b,c){return r.isFunction(b)?r.grep(a,function(a,d){return!!b.call(a,d,a)!==c}):b.nodeType?r.grep(a,function(a){return a===b!==c}):"string"!=typeof b?r.grep(a,function(a){return i.call(b,a)>-1!==c}):D.test(b)?r.filter(b,a,c):(b=r.filter(b,a),r.grep(a,function(a){return i.call(b,a)>-1!==c&&1===a.nodeType}))}r.filter=function(a,b,c){var d=b[0];return c&&(a=":not("+a+")"),1===b.length&&1===d.nodeType?r.find.matchesSelector(d,a)?[d]:[]:r.find.matches(a,r.grep(b,function(a){return 1===a.nodeType}))},r.fn.extend({find:function(a){var b,c,d=this.length,e=this;if("string"!=typeof a)return this.pushStack(r(a).filter(function(){for(b=0;b<d;b++)if(r.contains(e[b],this))return!0}));for(c=this.pushStack([]),b=0;b<d;b++)r.find(a,e[b],c);return d>1?r.uniqueSort(c):c},filter:function(a){return this.pushStack(E(this,a||[],!1))},not:function(a){return this.pushStack(E(this,a||[],!0))},is:function(a){return!!E(this,"string"==typeof a&&A.test(a)?r(a):a||[],!1).length}});var F,G=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,H=r.fn.init=function(a,b,c){var e,f;if(!a)return this;if(c=c||F,"string"==typeof a){if(e="<"===a[0]&&">"===a[a.length-1]&&a.length>=3?[null,a,null]:G.exec(a),!e||!e[1]&&b)return!b||b.jquery?(b||c).find(a):this.constructor(b).find(a);if(e[1]){if(b=b instanceof r?b[0]:b,r.merge(this,r.parseHTML(e[1],b&&b.nodeType?b.ownerDocument||b:d,!0)),C.test(e[1])&&r.isPlainObject(b))for(e in b)r.isFunction(this[e])?this[e](b[e]):this.attr(e,b[e]);return this}return f=d.getElementById(e[2]),f&&(this[0]=f,this.length=1),this}return a.nodeType?(this[0]=a,this.length=1,this):r.isFunction(a)?void 0!==c.ready?c.ready(a):a(r):r.makeArray(a,this)};H.prototype=r.fn,F=r(d);var I=/^(?:parents|prev(?:Until|All))/,J={children:!0,contents:!0,next:!0,prev:!0};r.fn.extend({has:function(a){var b=r(a,this),c=b.length;return this.filter(function(){for(var a=0;a<c;a++)if(r.contains(this,b[a]))return!0})},closest:function(a,b){var c,d=0,e=this.length,f=[],g="string"!=typeof a&&r(a);if(!A.test(a))for(;d<e;d++)for(c=this[d];c&&c!==b;c=c.parentNode)if(c.nodeType<11&&(g?g.index(c)>-1:1===c.nodeType&&r.find.matchesSelector(c,a))){f.push(c);break}return this.pushStack(f.length>1?r.uniqueSort(f):f)},index:function(a){return a?"string"==typeof a?i.call(r(a),this[0]):i.call(this,a.jquery?a[0]:a):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(a,b){return this.pushStack(r.uniqueSort(r.merge(this.get(),r(a,b))))},addBack:function(a){return this.add(null==a?this.prevObject:this.prevObject.filter(a))}});function K(a,b){while((a=a[b])&&1!==a.nodeType);return a}r.each({parent:function(a){var b=a.parentNode;return b&&11!==b.nodeType?b:null},parents:function(a){return y(a,"parentNode")},parentsUntil:function(a,b,c){return y(a,"parentNode",c)},next:function(a){return K(a,"nextSibling")},prev:function(a){return K(a,"previousSibling")},nextAll:function(a){return y(a,"nextSibling")},prevAll:function(a){return y(a,"previousSibling")},nextUntil:function(a,b,c){return y(a,"nextSibling",c)},prevUntil:function(a,b,c){return y(a,"previousSibling",c)},siblings:function(a){return z((a.parentNode||{}).firstChild,a)},children:function(a){return z(a.firstChild)},contents:function(a){return B(a,"iframe")?a.contentDocument:(B(a,"template")&&(a=a.content||a),r.merge([],a.childNodes))}},function(a,b){r.fn[a]=function(c,d){var e=r.map(this,b,c);return"Until"!==a.slice(-5)&&(d=c),d&&"string"==typeof d&&(e=r.filter(d,e)),this.length>1&&(J[a]||r.uniqueSort(e),I.test(a)&&e.reverse()),this.pushStack(e)}});var L=/[^\x20\t\r\n\f]+/g;function M(a){var b={};return r.each(a.match(L)||[],function(a,c){b[c]=!0}),b}r.Callbacks=function(a){a="string"==typeof a?M(a):r.extend({},a);var b,c,d,e,f=[],g=[],h=-1,i=function(){for(e=e||a.once,d=b=!0;g.length;h=-1){c=g.shift();while(++h<f.length)f[h].apply(c[0],c[1])===!1&&a.stopOnFalse&&(h=f.length,c=!1)}a.memory||(c=!1),b=!1,e&&(f=c?[]:"")},j={add:function(){return f&&(c&&!b&&(h=f.length-1,g.push(c)),function d(b){r.each(b,function(b,c){r.isFunction(c)?a.unique&&j.has(c)||f.push(c):c&&c.length&&"string"!==r.type(c)&&d(c)})}(arguments),c&&!b&&i()),this},remove:function(){return r.each(arguments,function(a,b){var c;while((c=r.inArray(b,f,c))>-1)f.splice(c,1),c<=h&&h--}),this},has:function(a){return a?r.inArray(a,f)>-1:f.length>0},empty:function(){return f&&(f=[]),this},disable:function(){return e=g=[],f=c="",this},disabled:function(){return!f},lock:function(){return e=g=[],c||b||(f=c=""),this},locked:function(){return!!e},fireWith:function(a,c){return e||(c=c||[],c=[a,c.slice?c.slice():c],g.push(c),b||i()),this},fire:function(){return j.fireWith(this,arguments),this},fired:function(){return!!d}};return j};function N(a){return a}function O(a){throw a}function P(a,b,c,d){var e;try{a&&r.isFunction(e=a.promise)?e.call(a).done(b).fail(c):a&&r.isFunction(e=a.then)?e.call(a,b,c):b.apply(void 0,[a].slice(d))}catch(a){c.apply(void 0,[a])}}r.extend({Deferred:function(b){var c=[["notify","progress",r.Callbacks("memory"),r.Callbacks("memory"),2],["resolve","done",r.Callbacks("once memory"),r.Callbacks("once memory"),0,"resolved"],["reject","fail",r.Callbacks("once memory"),r.Callbacks("once memory"),1,"rejected"]],d="pending",e={state:function(){return d},always:function(){return f.done(arguments).fail(arguments),this},"catch":function(a){return e.then(null,a)},pipe:function(){var a=arguments;return r.Deferred(function(b){r.each(c,function(c,d){var e=r.isFunction(a[d[4]])&&a[d[4]];f[d[1]](function(){var a=e&&e.apply(this,arguments);a&&r.isFunction(a.promise)?a.promise().progress(b.notify).done(b.resolve).fail(b.reject):b[d[0]+"With"](this,e?[a]:arguments)})}),a=null}).promise()},then:function(b,d,e){var f=0;function g(b,c,d,e){return function(){var h=this,i=arguments,j=function(){var a,j;if(!(b<f)){if(a=d.apply(h,i),a===c.promise())throw new TypeError("Thenable self-resolution");j=a&&("object"==typeof a||"function"==typeof a)&&a.then,r.isFunction(j)?e?j.call(a,g(f,c,N,e),g(f,c,O,e)):(f++,j.call(a,g(f,c,N,e),g(f,c,O,e),g(f,c,N,c.notifyWith))):(d!==N&&(h=void 0,i=[a]),(e||c.resolveWith)(h,i))}},k=e?j:function(){try{j()}catch(a){r.Deferred.exceptionHook&&r.Deferred.exceptionHook(a,k.stackTrace),b+1>=f&&(d!==O&&(h=void 0,i=[a]),c.rejectWith(h,i))}};b?k():(r.Deferred.getStackHook&&(k.stackTrace=r.Deferred.getStackHook()),a.setTimeout(k))}}return r.Deferred(function(a){c[0][3].add(g(0,a,r.isFunction(e)?e:N,a.notifyWith)),c[1][3].add(g(0,a,r.isFunction(b)?b:N)),c[2][3].add(g(0,a,r.isFunction(d)?d:O))}).promise()},promise:function(a){return null!=a?r.extend(a,e):e}},f={};return r.each(c,function(a,b){var g=b[2],h=b[5];e[b[1]]=g.add,h&&g.add(function(){d=h},c[3-a][2].disable,c[0][2].lock),g.add(b[3].fire),f[b[0]]=function(){return f[b[0]+"With"](this===f?void 0:this,arguments),this},f[b[0]+"With"]=g.fireWith}),e.promise(f),b&&b.call(f,f),f},when:function(a){var b=arguments.length,c=b,d=Array(c),e=f.call(arguments),g=r.Deferred(),h=function(a){return function(c){d[a]=this,e[a]=arguments.length>1?f.call(arguments):c,--b||g.resolveWith(d,e)}};if(b<=1&&(P(a,g.done(h(c)).resolve,g.reject,!b),"pending"===g.state()||r.isFunction(e[c]&&e[c].then)))return g.then();while(c--)P(e[c],h(c),g.reject);return g.promise()}});var Q=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;r.Deferred.exceptionHook=function(b,c){a.console&&a.console.warn&&b&&Q.test(b.name)&&a.console.warn("jQuery.Deferred exception: "+b.message,b.stack,c)},r.readyException=function(b){a.setTimeout(function(){throw b})};var R=r.Deferred();r.fn.ready=function(a){return R.then(a)["catch"](function(a){r.readyException(a)}),this},r.extend({isReady:!1,readyWait:1,ready:function(a){(a===!0?--r.readyWait:r.isReady)||(r.isReady=!0,a!==!0&&--r.readyWait>0||R.resolveWith(d,[r]))}}),r.ready.then=R.then;function S(){d.removeEventListener("DOMContentLoaded",S),
a.removeEventListener("load",S),r.ready()}"complete"===d.readyState||"loading"!==d.readyState&&!d.documentElement.doScroll?a.setTimeout(r.ready):(d.addEventListener("DOMContentLoaded",S),a.addEventListener("load",S));var T=function(a,b,c,d,e,f,g){var h=0,i=a.length,j=null==c;if("object"===r.type(c)){e=!0;for(h in c)T(a,b,h,c[h],!0,f,g)}else if(void 0!==d&&(e=!0,r.isFunction(d)||(g=!0),j&&(g?(b.call(a,d),b=null):(j=b,b=function(a,b,c){return j.call(r(a),c)})),b))for(;h<i;h++)b(a[h],c,g?d:d.call(a[h],h,b(a[h],c)));return e?a:j?b.call(a):i?b(a[0],c):f},U=function(a){return 1===a.nodeType||9===a.nodeType||!+a.nodeType};function V(){this.expando=r.expando+V.uid++}V.uid=1,V.prototype={cache:function(a){var b=a[this.expando];return b||(b={},U(a)&&(a.nodeType?a[this.expando]=b:Object.defineProperty(a,this.expando,{value:b,configurable:!0}))),b},set:function(a,b,c){var d,e=this.cache(a);if("string"==typeof b)e[r.camelCase(b)]=c;else for(d in b)e[r.camelCase(d)]=b[d];return e},get:function(a,b){return void 0===b?this.cache(a):a[this.expando]&&a[this.expando][r.camelCase(b)]},access:function(a,b,c){return void 0===b||b&&"string"==typeof b&&void 0===c?this.get(a,b):(this.set(a,b,c),void 0!==c?c:b)},remove:function(a,b){var c,d=a[this.expando];if(void 0!==d){if(void 0!==b){Array.isArray(b)?b=b.map(r.camelCase):(b=r.camelCase(b),b=b in d?[b]:b.match(L)||[]),c=b.length;while(c--)delete d[b[c]]}(void 0===b||r.isEmptyObject(d))&&(a.nodeType?a[this.expando]=void 0:delete a[this.expando])}},hasData:function(a){var b=a[this.expando];return void 0!==b&&!r.isEmptyObject(b)}};var W=new V,X=new V,Y=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,Z=/[A-Z]/g;function $(a){return"true"===a||"false"!==a&&("null"===a?null:a===+a+""?+a:Y.test(a)?JSON.parse(a):a)}function _(a,b,c){var d;if(void 0===c&&1===a.nodeType)if(d="data-"+b.replace(Z,"-$&").toLowerCase(),c=a.getAttribute(d),"string"==typeof c){try{c=$(c)}catch(e){}X.set(a,b,c)}else c=void 0;return c}r.extend({hasData:function(a){return X.hasData(a)||W.hasData(a)},data:function(a,b,c){return X.access(a,b,c)},removeData:function(a,b){X.remove(a,b)},_data:function(a,b,c){return W.access(a,b,c)},_removeData:function(a,b){W.remove(a,b)}}),r.fn.extend({data:function(a,b){var c,d,e,f=this[0],g=f&&f.attributes;if(void 0===a){if(this.length&&(e=X.get(f),1===f.nodeType&&!W.get(f,"hasDataAttrs"))){c=g.length;while(c--)g[c]&&(d=g[c].name,0===d.indexOf("data-")&&(d=r.camelCase(d.slice(5)),_(f,d,e[d])));W.set(f,"hasDataAttrs",!0)}return e}return"object"==typeof a?this.each(function(){X.set(this,a)}):T(this,function(b){var c;if(f&&void 0===b){if(c=X.get(f,a),void 0!==c)return c;if(c=_(f,a),void 0!==c)return c}else this.each(function(){X.set(this,a,b)})},null,b,arguments.length>1,null,!0)},removeData:function(a){return this.each(function(){X.remove(this,a)})}}),r.extend({queue:function(a,b,c){var d;if(a)return b=(b||"fx")+"queue",d=W.get(a,b),c&&(!d||Array.isArray(c)?d=W.access(a,b,r.makeArray(c)):d.push(c)),d||[]},dequeue:function(a,b){b=b||"fx";var c=r.queue(a,b),d=c.length,e=c.shift(),f=r._queueHooks(a,b),g=function(){r.dequeue(a,b)};"inprogress"===e&&(e=c.shift(),d--),e&&("fx"===b&&c.unshift("inprogress"),delete f.stop,e.call(a,g,f)),!d&&f&&f.empty.fire()},_queueHooks:function(a,b){var c=b+"queueHooks";return W.get(a,c)||W.access(a,c,{empty:r.Callbacks("once memory").add(function(){W.remove(a,[b+"queue",c])})})}}),r.fn.extend({queue:function(a,b){var c=2;return"string"!=typeof a&&(b=a,a="fx",c--),arguments.length<c?r.queue(this[0],a):void 0===b?this:this.each(function(){var c=r.queue(this,a,b);r._queueHooks(this,a),"fx"===a&&"inprogress"!==c[0]&&r.dequeue(this,a)})},dequeue:function(a){return this.each(function(){r.dequeue(this,a)})},clearQueue:function(a){return this.queue(a||"fx",[])},promise:function(a,b){var c,d=1,e=r.Deferred(),f=this,g=this.length,h=function(){--d||e.resolveWith(f,[f])};"string"!=typeof a&&(b=a,a=void 0),a=a||"fx";while(g--)c=W.get(f[g],a+"queueHooks"),c&&c.empty&&(d++,c.empty.add(h));return h(),e.promise(b)}});var aa=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,ba=new RegExp("^(?:([+-])=|)("+aa+")([a-z%]*)$","i"),ca=["Top","Right","Bottom","Left"],da=function(a,b){return a=b||a,"none"===a.style.display||""===a.style.display&&r.contains(a.ownerDocument,a)&&"none"===r.css(a,"display")},ea=function(a,b,c,d){var e,f,g={};for(f in b)g[f]=a.style[f],a.style[f]=b[f];e=c.apply(a,d||[]);for(f in b)a.style[f]=g[f];return e};function fa(a,b,c,d){var e,f=1,g=20,h=d?function(){return d.cur()}:function(){return r.css(a,b,"")},i=h(),j=c&&c[3]||(r.cssNumber[b]?"":"px"),k=(r.cssNumber[b]||"px"!==j&&+i)&&ba.exec(r.css(a,b));if(k&&k[3]!==j){j=j||k[3],c=c||[],k=+i||1;do f=f||".5",k/=f,r.style(a,b,k+j);while(f!==(f=h()/i)&&1!==f&&--g)}return c&&(k=+k||+i||0,e=c[1]?k+(c[1]+1)*c[2]:+c[2],d&&(d.unit=j,d.start=k,d.end=e)),e}var ga={};function ha(a){var b,c=a.ownerDocument,d=a.nodeName,e=ga[d];return e?e:(b=c.body.appendChild(c.createElement(d)),e=r.css(b,"display"),b.parentNode.removeChild(b),"none"===e&&(e="block"),ga[d]=e,e)}function ia(a,b){for(var c,d,e=[],f=0,g=a.length;f<g;f++)d=a[f],d.style&&(c=d.style.display,b?("none"===c&&(e[f]=W.get(d,"display")||null,e[f]||(d.style.display="")),""===d.style.display&&da(d)&&(e[f]=ha(d))):"none"!==c&&(e[f]="none",W.set(d,"display",c)));for(f=0;f<g;f++)null!=e[f]&&(a[f].style.display=e[f]);return a}r.fn.extend({show:function(){return ia(this,!0)},hide:function(){return ia(this)},toggle:function(a){return"boolean"==typeof a?a?this.show():this.hide():this.each(function(){da(this)?r(this).show():r(this).hide()})}});var ja=/^(?:checkbox|radio)$/i,ka=/<([a-z][^\/\0>\x20\t\r\n\f]+)/i,la=/^$|\/(?:java|ecma)script/i,ma={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};ma.optgroup=ma.option,ma.tbody=ma.tfoot=ma.colgroup=ma.caption=ma.thead,ma.th=ma.td;function na(a,b){var c;return c="undefined"!=typeof a.getElementsByTagName?a.getElementsByTagName(b||"*"):"undefined"!=typeof a.querySelectorAll?a.querySelectorAll(b||"*"):[],void 0===b||b&&B(a,b)?r.merge([a],c):c}function oa(a,b){for(var c=0,d=a.length;c<d;c++)W.set(a[c],"globalEval",!b||W.get(b[c],"globalEval"))}var pa=/<|&#?\w+;/;function qa(a,b,c,d,e){for(var f,g,h,i,j,k,l=b.createDocumentFragment(),m=[],n=0,o=a.length;n<o;n++)if(f=a[n],f||0===f)if("object"===r.type(f))r.merge(m,f.nodeType?[f]:f);else if(pa.test(f)){g=g||l.appendChild(b.createElement("div")),h=(ka.exec(f)||["",""])[1].toLowerCase(),i=ma[h]||ma._default,g.innerHTML=i[1]+r.htmlPrefilter(f)+i[2],k=i[0];while(k--)g=g.lastChild;r.merge(m,g.childNodes),g=l.firstChild,g.textContent=""}else m.push(b.createTextNode(f));l.textContent="",n=0;while(f=m[n++])if(d&&r.inArray(f,d)>-1)e&&e.push(f);else if(j=r.contains(f.ownerDocument,f),g=na(l.appendChild(f),"script"),j&&oa(g),c){k=0;while(f=g[k++])la.test(f.type||"")&&c.push(f)}return l}!function(){var a=d.createDocumentFragment(),b=a.appendChild(d.createElement("div")),c=d.createElement("input");c.setAttribute("type","radio"),c.setAttribute("checked","checked"),c.setAttribute("name","t"),b.appendChild(c),o.checkClone=b.cloneNode(!0).cloneNode(!0).lastChild.checked,b.innerHTML="<textarea>x</textarea>",o.noCloneChecked=!!b.cloneNode(!0).lastChild.defaultValue}();var ra=d.documentElement,sa=/^key/,ta=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,ua=/^([^.]*)(?:\.(.+)|)/;function va(){return!0}function wa(){return!1}function xa(){try{return d.activeElement}catch(a){}}function ya(a,b,c,d,e,f){var g,h;if("object"==typeof b){"string"!=typeof c&&(d=d||c,c=void 0);for(h in b)ya(a,h,c,d,b[h],f);return a}if(null==d&&null==e?(e=c,d=c=void 0):null==e&&("string"==typeof c?(e=d,d=void 0):(e=d,d=c,c=void 0)),e===!1)e=wa;else if(!e)return a;return 1===f&&(g=e,e=function(a){return r().off(a),g.apply(this,arguments)},e.guid=g.guid||(g.guid=r.guid++)),a.each(function(){r.event.add(this,b,e,d,c)})}r.event={global:{},add:function(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q=W.get(a);if(q){c.handler&&(f=c,c=f.handler,e=f.selector),e&&r.find.matchesSelector(ra,e),c.guid||(c.guid=r.guid++),(i=q.events)||(i=q.events={}),(g=q.handle)||(g=q.handle=function(b){return"undefined"!=typeof r&&r.event.triggered!==b.type?r.event.dispatch.apply(a,arguments):void 0}),b=(b||"").match(L)||[""],j=b.length;while(j--)h=ua.exec(b[j])||[],n=p=h[1],o=(h[2]||"").split(".").sort(),n&&(l=r.event.special[n]||{},n=(e?l.delegateType:l.bindType)||n,l=r.event.special[n]||{},k=r.extend({type:n,origType:p,data:d,handler:c,guid:c.guid,selector:e,needsContext:e&&r.expr.match.needsContext.test(e),namespace:o.join(".")},f),(m=i[n])||(m=i[n]=[],m.delegateCount=0,l.setup&&l.setup.call(a,d,o,g)!==!1||a.addEventListener&&a.addEventListener(n,g)),l.add&&(l.add.call(a,k),k.handler.guid||(k.handler.guid=c.guid)),e?m.splice(m.delegateCount++,0,k):m.push(k),r.event.global[n]=!0)}},remove:function(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q=W.hasData(a)&&W.get(a);if(q&&(i=q.events)){b=(b||"").match(L)||[""],j=b.length;while(j--)if(h=ua.exec(b[j])||[],n=p=h[1],o=(h[2]||"").split(".").sort(),n){l=r.event.special[n]||{},n=(d?l.delegateType:l.bindType)||n,m=i[n]||[],h=h[2]&&new RegExp("(^|\\.)"+o.join("\\.(?:.*\\.|)")+"(\\.|$)"),g=f=m.length;while(f--)k=m[f],!e&&p!==k.origType||c&&c.guid!==k.guid||h&&!h.test(k.namespace)||d&&d!==k.selector&&("**"!==d||!k.selector)||(m.splice(f,1),k.selector&&m.delegateCount--,l.remove&&l.remove.call(a,k));g&&!m.length&&(l.teardown&&l.teardown.call(a,o,q.handle)!==!1||r.removeEvent(a,n,q.handle),delete i[n])}else for(n in i)r.event.remove(a,n+b[j],c,d,!0);r.isEmptyObject(i)&&W.remove(a,"handle events")}},dispatch:function(a){var b=r.event.fix(a),c,d,e,f,g,h,i=new Array(arguments.length),j=(W.get(this,"events")||{})[b.type]||[],k=r.event.special[b.type]||{};for(i[0]=b,c=1;c<arguments.length;c++)i[c]=arguments[c];if(b.delegateTarget=this,!k.preDispatch||k.preDispatch.call(this,b)!==!1){h=r.event.handlers.call(this,b,j),c=0;while((f=h[c++])&&!b.isPropagationStopped()){b.currentTarget=f.elem,d=0;while((g=f.handlers[d++])&&!b.isImmediatePropagationStopped())b.rnamespace&&!b.rnamespace.test(g.namespace)||(b.handleObj=g,b.data=g.data,e=((r.event.special[g.origType]||{}).handle||g.handler).apply(f.elem,i),void 0!==e&&(b.result=e)===!1&&(b.preventDefault(),b.stopPropagation()))}return k.postDispatch&&k.postDispatch.call(this,b),b.result}},handlers:function(a,b){var c,d,e,f,g,h=[],i=b.delegateCount,j=a.target;if(i&&j.nodeType&&!("click"===a.type&&a.button>=1))for(;j!==this;j=j.parentNode||this)if(1===j.nodeType&&("click"!==a.type||j.disabled!==!0)){for(f=[],g={},c=0;c<i;c++)d=b[c],e=d.selector+" ",void 0===g[e]&&(g[e]=d.needsContext?r(e,this).index(j)>-1:r.find(e,this,null,[j]).length),g[e]&&f.push(d);f.length&&h.push({elem:j,handlers:f})}return j=this,i<b.length&&h.push({elem:j,handlers:b.slice(i)}),h},addProp:function(a,b){Object.defineProperty(r.Event.prototype,a,{enumerable:!0,configurable:!0,get:r.isFunction(b)?function(){if(this.originalEvent)return b(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[a]},set:function(b){Object.defineProperty(this,a,{enumerable:!0,configurable:!0,writable:!0,value:b})}})},fix:function(a){return a[r.expando]?a:new r.Event(a)},special:{load:{noBubble:!0},focus:{trigger:function(){if(this!==xa()&&this.focus)return this.focus(),!1},delegateType:"focusin"},blur:{trigger:function(){if(this===xa()&&this.blur)return this.blur(),!1},delegateType:"focusout"},click:{trigger:function(){if("checkbox"===this.type&&this.click&&B(this,"input"))return this.click(),!1},_default:function(a){return B(a.target,"a")}},beforeunload:{postDispatch:function(a){void 0!==a.result&&a.originalEvent&&(a.originalEvent.returnValue=a.result)}}}},r.removeEvent=function(a,b,c){a.removeEventListener&&a.removeEventListener(b,c)},r.Event=function(a,b){return this instanceof r.Event?(a&&a.type?(this.originalEvent=a,this.type=a.type,this.isDefaultPrevented=a.defaultPrevented||void 0===a.defaultPrevented&&a.returnValue===!1?va:wa,this.target=a.target&&3===a.target.nodeType?a.target.parentNode:a.target,this.currentTarget=a.currentTarget,this.relatedTarget=a.relatedTarget):this.type=a,b&&r.extend(this,b),this.timeStamp=a&&a.timeStamp||r.now(),void(this[r.expando]=!0)):new r.Event(a,b)},r.Event.prototype={constructor:r.Event,isDefaultPrevented:wa,isPropagationStopped:wa,isImmediatePropagationStopped:wa,isSimulated:!1,preventDefault:function(){var a=this.originalEvent;this.isDefaultPrevented=va,a&&!this.isSimulated&&a.preventDefault()},stopPropagation:function(){var a=this.originalEvent;this.isPropagationStopped=va,a&&!this.isSimulated&&a.stopPropagation()},stopImmediatePropagation:function(){var a=this.originalEvent;this.isImmediatePropagationStopped=va,a&&!this.isSimulated&&a.stopImmediatePropagation(),this.stopPropagation()}},r.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,"char":!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(a){var b=a.button;return null==a.which&&sa.test(a.type)?null!=a.charCode?a.charCode:a.keyCode:!a.which&&void 0!==b&&ta.test(a.type)?1&b?1:2&b?3:4&b?2:0:a.which}},r.event.addProp),r.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(a,b){r.event.special[a]={delegateType:b,bindType:b,handle:function(a){var c,d=this,e=a.relatedTarget,f=a.handleObj;return e&&(e===d||r.contains(d,e))||(a.type=f.origType,c=f.handler.apply(this,arguments),a.type=b),c}}}),r.fn.extend({on:function(a,b,c,d){return ya(this,a,b,c,d)},one:function(a,b,c,d){return ya(this,a,b,c,d,1)},off:function(a,b,c){var d,e;if(a&&a.preventDefault&&a.handleObj)return d=a.handleObj,r(a.delegateTarget).off(d.namespace?d.origType+"."+d.namespace:d.origType,d.selector,d.handler),this;if("object"==typeof a){for(e in a)this.off(e,b,a[e]);return this}return b!==!1&&"function"!=typeof b||(c=b,b=void 0),c===!1&&(c=wa),this.each(function(){r.event.remove(this,a,c,b)})}});var za=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,Aa=/<script|<style|<link/i,Ba=/checked\s*(?:[^=]|=\s*.checked.)/i,Ca=/^true\/(.*)/,Da=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function Ea(a,b){return B(a,"table")&&B(11!==b.nodeType?b:b.firstChild,"tr")?r(">tbody",a)[0]||a:a}function Fa(a){return a.type=(null!==a.getAttribute("type"))+"/"+a.type,a}function Ga(a){var b=Ca.exec(a.type);return b?a.type=b[1]:a.removeAttribute("type"),a}function Ha(a,b){var c,d,e,f,g,h,i,j;if(1===b.nodeType){if(W.hasData(a)&&(f=W.access(a),g=W.set(b,f),j=f.events)){delete g.handle,g.events={};for(e in j)for(c=0,d=j[e].length;c<d;c++)r.event.add(b,e,j[e][c])}X.hasData(a)&&(h=X.access(a),i=r.extend({},h),X.set(b,i))}}function Ia(a,b){var c=b.nodeName.toLowerCase();"input"===c&&ja.test(a.type)?b.checked=a.checked:"input"!==c&&"textarea"!==c||(b.defaultValue=a.defaultValue)}function Ja(a,b,c,d){b=g.apply([],b);var e,f,h,i,j,k,l=0,m=a.length,n=m-1,q=b[0],s=r.isFunction(q);if(s||m>1&&"string"==typeof q&&!o.checkClone&&Ba.test(q))return a.each(function(e){var f=a.eq(e);s&&(b[0]=q.call(this,e,f.html())),Ja(f,b,c,d)});if(m&&(e=qa(b,a[0].ownerDocument,!1,a,d),f=e.firstChild,1===e.childNodes.length&&(e=f),f||d)){for(h=r.map(na(e,"script"),Fa),i=h.length;l<m;l++)j=e,l!==n&&(j=r.clone(j,!0,!0),i&&r.merge(h,na(j,"script"))),c.call(a[l],j,l);if(i)for(k=h[h.length-1].ownerDocument,r.map(h,Ga),l=0;l<i;l++)j=h[l],la.test(j.type||"")&&!W.access(j,"globalEval")&&r.contains(k,j)&&(j.src?r._evalUrl&&r._evalUrl(j.src):p(j.textContent.replace(Da,""),k))}return a}function Ka(a,b,c){for(var d,e=b?r.filter(b,a):a,f=0;null!=(d=e[f]);f++)c||1!==d.nodeType||r.cleanData(na(d)),d.parentNode&&(c&&r.contains(d.ownerDocument,d)&&oa(na(d,"script")),d.parentNode.removeChild(d));return a}r.extend({htmlPrefilter:function(a){return a.replace(za,"<$1></$2>")},clone:function(a,b,c){var d,e,f,g,h=a.cloneNode(!0),i=r.contains(a.ownerDocument,a);if(!(o.noCloneChecked||1!==a.nodeType&&11!==a.nodeType||r.isXMLDoc(a)))for(g=na(h),f=na(a),d=0,e=f.length;d<e;d++)Ia(f[d],g[d]);if(b)if(c)for(f=f||na(a),g=g||na(h),d=0,e=f.length;d<e;d++)Ha(f[d],g[d]);else Ha(a,h);return g=na(h,"script"),g.length>0&&oa(g,!i&&na(a,"script")),h},cleanData:function(a){for(var b,c,d,e=r.event.special,f=0;void 0!==(c=a[f]);f++)if(U(c)){if(b=c[W.expando]){if(b.events)for(d in b.events)e[d]?r.event.remove(c,d):r.removeEvent(c,d,b.handle);c[W.expando]=void 0}c[X.expando]&&(c[X.expando]=void 0)}}}),r.fn.extend({detach:function(a){return Ka(this,a,!0)},remove:function(a){return Ka(this,a)},text:function(a){return T(this,function(a){return void 0===a?r.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=a)})},null,a,arguments.length)},append:function(){return Ja(this,arguments,function(a){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var b=Ea(this,a);b.appendChild(a)}})},prepend:function(){return Ja(this,arguments,function(a){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var b=Ea(this,a);b.insertBefore(a,b.firstChild)}})},before:function(){return Ja(this,arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this)})},after:function(){return Ja(this,arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this.nextSibling)})},empty:function(){for(var a,b=0;null!=(a=this[b]);b++)1===a.nodeType&&(r.cleanData(na(a,!1)),a.textContent="");return this},clone:function(a,b){return a=null!=a&&a,b=null==b?a:b,this.map(function(){return r.clone(this,a,b)})},html:function(a){return T(this,function(a){var b=this[0]||{},c=0,d=this.length;if(void 0===a&&1===b.nodeType)return b.innerHTML;if("string"==typeof a&&!Aa.test(a)&&!ma[(ka.exec(a)||["",""])[1].toLowerCase()]){a=r.htmlPrefilter(a);try{for(;c<d;c++)b=this[c]||{},1===b.nodeType&&(r.cleanData(na(b,!1)),b.innerHTML=a);b=0}catch(e){}}b&&this.empty().append(a)},null,a,arguments.length)},replaceWith:function(){var a=[];return Ja(this,arguments,function(b){var c=this.parentNode;r.inArray(this,a)<0&&(r.cleanData(na(this)),c&&c.replaceChild(b,this))},a)}}),r.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(a,b){r.fn[a]=function(a){for(var c,d=[],e=r(a),f=e.length-1,g=0;g<=f;g++)c=g===f?this:this.clone(!0),r(e[g])[b](c),h.apply(d,c.get());return this.pushStack(d)}});var La=/^margin/,Ma=new RegExp("^("+aa+")(?!px)[a-z%]+$","i"),Na=function(b){var c=b.ownerDocument.defaultView;return c&&c.opener||(c=a),c.getComputedStyle(b)};!function(){function b(){if(i){i.style.cssText="box-sizing:border-box;position:relative;display:block;margin:auto;border:1px;padding:1px;top:1%;width:50%",i.innerHTML="",ra.appendChild(h);var b=a.getComputedStyle(i);c="1%"!==b.top,g="2px"===b.marginLeft,e="4px"===b.width,i.style.marginRight="50%",f="4px"===b.marginRight,ra.removeChild(h),i=null}}var c,e,f,g,h=d.createElement("div"),i=d.createElement("div");i.style&&(i.style.backgroundClip="content-box",i.cloneNode(!0).style.backgroundClip="",o.clearCloneStyle="content-box"===i.style.backgroundClip,h.style.cssText="border:0;width:8px;height:0;top:0;left:-9999px;padding:0;margin-top:1px;position:absolute",h.appendChild(i),r.extend(o,{pixelPosition:function(){return b(),c},boxSizingReliable:function(){return b(),e},pixelMarginRight:function(){return b(),f},reliableMarginLeft:function(){return b(),g}}))}();function Oa(a,b,c){var d,e,f,g,h=a.style;return c=c||Na(a),c&&(g=c.getPropertyValue(b)||c[b],""!==g||r.contains(a.ownerDocument,a)||(g=r.style(a,b)),!o.pixelMarginRight()&&Ma.test(g)&&La.test(b)&&(d=h.width,e=h.minWidth,f=h.maxWidth,h.minWidth=h.maxWidth=h.width=g,g=c.width,h.width=d,h.minWidth=e,h.maxWidth=f)),void 0!==g?g+"":g}function Pa(a,b){return{get:function(){return a()?void delete this.get:(this.get=b).apply(this,arguments)}}}var Qa=/^(none|table(?!-c[ea]).+)/,Ra=/^--/,Sa={position:"absolute",visibility:"hidden",display:"block"},Ta={letterSpacing:"0",fontWeight:"400"},Ua=["Webkit","Moz","ms"],Va=d.createElement("div").style;function Wa(a){if(a in Va)return a;var b=a[0].toUpperCase()+a.slice(1),c=Ua.length;while(c--)if(a=Ua[c]+b,a in Va)return a}function Xa(a){var b=r.cssProps[a];return b||(b=r.cssProps[a]=Wa(a)||a),b}function Ya(a,b,c){var d=ba.exec(b);return d?Math.max(0,d[2]-(c||0))+(d[3]||"px"):b}function Za(a,b,c,d,e){var f,g=0;for(f=c===(d?"border":"content")?4:"width"===b?1:0;f<4;f+=2)"margin"===c&&(g+=r.css(a,c+ca[f],!0,e)),d?("content"===c&&(g-=r.css(a,"padding"+ca[f],!0,e)),"margin"!==c&&(g-=r.css(a,"border"+ca[f]+"Width",!0,e))):(g+=r.css(a,"padding"+ca[f],!0,e),"padding"!==c&&(g+=r.css(a,"border"+ca[f]+"Width",!0,e)));return g}function $a(a,b,c){var d,e=Na(a),f=Oa(a,b,e),g="border-box"===r.css(a,"boxSizing",!1,e);return Ma.test(f)?f:(d=g&&(o.boxSizingReliable()||f===a.style[b]),"auto"===f&&(f=a["offset"+b[0].toUpperCase()+b.slice(1)]),f=parseFloat(f)||0,f+Za(a,b,c||(g?"border":"content"),d,e)+"px")}r.extend({cssHooks:{opacity:{get:function(a,b){if(b){var c=Oa(a,"opacity");return""===c?"1":c}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{"float":"cssFloat"},style:function(a,b,c,d){if(a&&3!==a.nodeType&&8!==a.nodeType&&a.style){var e,f,g,h=r.camelCase(b),i=Ra.test(b),j=a.style;return i||(b=Xa(h)),g=r.cssHooks[b]||r.cssHooks[h],void 0===c?g&&"get"in g&&void 0!==(e=g.get(a,!1,d))?e:j[b]:(f=typeof c,"string"===f&&(e=ba.exec(c))&&e[1]&&(c=fa(a,b,e),f="number"),null!=c&&c===c&&("number"===f&&(c+=e&&e[3]||(r.cssNumber[h]?"":"px")),o.clearCloneStyle||""!==c||0!==b.indexOf("background")||(j[b]="inherit"),g&&"set"in g&&void 0===(c=g.set(a,c,d))||(i?j.setProperty(b,c):j[b]=c)),void 0)}},css:function(a,b,c,d){var e,f,g,h=r.camelCase(b),i=Ra.test(b);return i||(b=Xa(h)),g=r.cssHooks[b]||r.cssHooks[h],g&&"get"in g&&(e=g.get(a,!0,c)),void 0===e&&(e=Oa(a,b,d)),"normal"===e&&b in Ta&&(e=Ta[b]),""===c||c?(f=parseFloat(e),c===!0||isFinite(f)?f||0:e):e}}),r.each(["height","width"],function(a,b){r.cssHooks[b]={get:function(a,c,d){if(c)return!Qa.test(r.css(a,"display"))||a.getClientRects().length&&a.getBoundingClientRect().width?$a(a,b,d):ea(a,Sa,function(){return $a(a,b,d)})},set:function(a,c,d){var e,f=d&&Na(a),g=d&&Za(a,b,d,"border-box"===r.css(a,"boxSizing",!1,f),f);return g&&(e=ba.exec(c))&&"px"!==(e[3]||"px")&&(a.style[b]=c,c=r.css(a,b)),Ya(a,c,g)}}}),r.cssHooks.marginLeft=Pa(o.reliableMarginLeft,function(a,b){if(b)return(parseFloat(Oa(a,"marginLeft"))||a.getBoundingClientRect().left-ea(a,{marginLeft:0},function(){return a.getBoundingClientRect().left}))+"px"}),r.each({margin:"",padding:"",border:"Width"},function(a,b){r.cssHooks[a+b]={expand:function(c){for(var d=0,e={},f="string"==typeof c?c.split(" "):[c];d<4;d++)e[a+ca[d]+b]=f[d]||f[d-2]||f[0];return e}},La.test(a)||(r.cssHooks[a+b].set=Ya)}),r.fn.extend({css:function(a,b){return T(this,function(a,b,c){var d,e,f={},g=0;if(Array.isArray(b)){for(d=Na(a),e=b.length;g<e;g++)f[b[g]]=r.css(a,b[g],!1,d);return f}return void 0!==c?r.style(a,b,c):r.css(a,b)},a,b,arguments.length>1)}});function _a(a,b,c,d,e){return new _a.prototype.init(a,b,c,d,e)}r.Tween=_a,_a.prototype={constructor:_a,init:function(a,b,c,d,e,f){this.elem=a,this.prop=c,this.easing=e||r.easing._default,this.options=b,this.start=this.now=this.cur(),this.end=d,this.unit=f||(r.cssNumber[c]?"":"px")},cur:function(){var a=_a.propHooks[this.prop];return a&&a.get?a.get(this):_a.propHooks._default.get(this)},run:function(a){var b,c=_a.propHooks[this.prop];return this.options.duration?this.pos=b=r.easing[this.easing](a,this.options.duration*a,0,1,this.options.duration):this.pos=b=a,this.now=(this.end-this.start)*b+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),c&&c.set?c.set(this):_a.propHooks._default.set(this),this}},_a.prototype.init.prototype=_a.prototype,_a.propHooks={_default:{get:function(a){var b;return 1!==a.elem.nodeType||null!=a.elem[a.prop]&&null==a.elem.style[a.prop]?a.elem[a.prop]:(b=r.css(a.elem,a.prop,""),b&&"auto"!==b?b:0)},set:function(a){r.fx.step[a.prop]?r.fx.step[a.prop](a):1!==a.elem.nodeType||null==a.elem.style[r.cssProps[a.prop]]&&!r.cssHooks[a.prop]?a.elem[a.prop]=a.now:r.style(a.elem,a.prop,a.now+a.unit)}}},_a.propHooks.scrollTop=_a.propHooks.scrollLeft={set:function(a){a.elem.nodeType&&a.elem.parentNode&&(a.elem[a.prop]=a.now)}},r.easing={linear:function(a){return a},swing:function(a){return.5-Math.cos(a*Math.PI)/2},_default:"swing"},r.fx=_a.prototype.init,r.fx.step={};var ab,bb,cb=/^(?:toggle|show|hide)$/,db=/queueHooks$/;function eb(){bb&&(d.hidden===!1&&a.requestAnimationFrame?a.requestAnimationFrame(eb):a.setTimeout(eb,r.fx.interval),r.fx.tick())}function fb(){return a.setTimeout(function(){ab=void 0}),ab=r.now()}function gb(a,b){var c,d=0,e={height:a};for(b=b?1:0;d<4;d+=2-b)c=ca[d],e["margin"+c]=e["padding"+c]=a;return b&&(e.opacity=e.width=a),e}function hb(a,b,c){for(var d,e=(kb.tweeners[b]||[]).concat(kb.tweeners["*"]),f=0,g=e.length;f<g;f++)if(d=e[f].call(c,b,a))return d}function ib(a,b,c){var d,e,f,g,h,i,j,k,l="width"in b||"height"in b,m=this,n={},o=a.style,p=a.nodeType&&da(a),q=W.get(a,"fxshow");c.queue||(g=r._queueHooks(a,"fx"),null==g.unqueued&&(g.unqueued=0,h=g.empty.fire,g.empty.fire=function(){g.unqueued||h()}),g.unqueued++,m.always(function(){m.always(function(){g.unqueued--,r.queue(a,"fx").length||g.empty.fire()})}));for(d in b)if(e=b[d],cb.test(e)){if(delete b[d],f=f||"toggle"===e,e===(p?"hide":"show")){if("show"!==e||!q||void 0===q[d])continue;p=!0}n[d]=q&&q[d]||r.style(a,d)}if(i=!r.isEmptyObject(b),i||!r.isEmptyObject(n)){l&&1===a.nodeType&&(c.overflow=[o.overflow,o.overflowX,o.overflowY],j=q&&q.display,null==j&&(j=W.get(a,"display")),k=r.css(a,"display"),"none"===k&&(j?k=j:(ia([a],!0),j=a.style.display||j,k=r.css(a,"display"),ia([a]))),("inline"===k||"inline-block"===k&&null!=j)&&"none"===r.css(a,"float")&&(i||(m.done(function(){o.display=j}),null==j&&(k=o.display,j="none"===k?"":k)),o.display="inline-block")),c.overflow&&(o.overflow="hidden",m.always(function(){o.overflow=c.overflow[0],o.overflowX=c.overflow[1],o.overflowY=c.overflow[2]})),i=!1;for(d in n)i||(q?"hidden"in q&&(p=q.hidden):q=W.access(a,"fxshow",{display:j}),f&&(q.hidden=!p),p&&ia([a],!0),m.done(function(){p||ia([a]),W.remove(a,"fxshow");for(d in n)r.style(a,d,n[d])})),i=hb(p?q[d]:0,d,m),d in q||(q[d]=i.start,p&&(i.end=i.start,i.start=0))}}function jb(a,b){var c,d,e,f,g;for(c in a)if(d=r.camelCase(c),e=b[d],f=a[c],Array.isArray(f)&&(e=f[1],f=a[c]=f[0]),c!==d&&(a[d]=f,delete a[c]),g=r.cssHooks[d],g&&"expand"in g){f=g.expand(f),delete a[d];for(c in f)c in a||(a[c]=f[c],b[c]=e)}else b[d]=e}function kb(a,b,c){var d,e,f=0,g=kb.prefilters.length,h=r.Deferred().always(function(){delete i.elem}),i=function(){if(e)return!1;for(var b=ab||fb(),c=Math.max(0,j.startTime+j.duration-b),d=c/j.duration||0,f=1-d,g=0,i=j.tweens.length;g<i;g++)j.tweens[g].run(f);return h.notifyWith(a,[j,f,c]),f<1&&i?c:(i||h.notifyWith(a,[j,1,0]),h.resolveWith(a,[j]),!1)},j=h.promise({elem:a,props:r.extend({},b),opts:r.extend(!0,{specialEasing:{},easing:r.easing._default},c),originalProperties:b,originalOptions:c,startTime:ab||fb(),duration:c.duration,tweens:[],createTween:function(b,c){var d=r.Tween(a,j.opts,b,c,j.opts.specialEasing[b]||j.opts.easing);return j.tweens.push(d),d},stop:function(b){var c=0,d=b?j.tweens.length:0;if(e)return this;for(e=!0;c<d;c++)j.tweens[c].run(1);return b?(h.notifyWith(a,[j,1,0]),h.resolveWith(a,[j,b])):h.rejectWith(a,[j,b]),this}}),k=j.props;for(jb(k,j.opts.specialEasing);f<g;f++)if(d=kb.prefilters[f].call(j,a,k,j.opts))return r.isFunction(d.stop)&&(r._queueHooks(j.elem,j.opts.queue).stop=r.proxy(d.stop,d)),d;return r.map(k,hb,j),r.isFunction(j.opts.start)&&j.opts.start.call(a,j),j.progress(j.opts.progress).done(j.opts.done,j.opts.complete).fail(j.opts.fail).always(j.opts.always),r.fx.timer(r.extend(i,{elem:a,anim:j,queue:j.opts.queue})),j}r.Animation=r.extend(kb,{tweeners:{"*":[function(a,b){var c=this.createTween(a,b);return fa(c.elem,a,ba.exec(b),c),c}]},tweener:function(a,b){r.isFunction(a)?(b=a,a=["*"]):a=a.match(L);for(var c,d=0,e=a.length;d<e;d++)c=a[d],kb.tweeners[c]=kb.tweeners[c]||[],kb.tweeners[c].unshift(b)},prefilters:[ib],prefilter:function(a,b){b?kb.prefilters.unshift(a):kb.prefilters.push(a)}}),r.speed=function(a,b,c){var d=a&&"object"==typeof a?r.extend({},a):{complete:c||!c&&b||r.isFunction(a)&&a,duration:a,easing:c&&b||b&&!r.isFunction(b)&&b};return r.fx.off?d.duration=0:"number"!=typeof d.duration&&(d.duration in r.fx.speeds?d.duration=r.fx.speeds[d.duration]:d.duration=r.fx.speeds._default),null!=d.queue&&d.queue!==!0||(d.queue="fx"),d.old=d.complete,d.complete=function(){r.isFunction(d.old)&&d.old.call(this),d.queue&&r.dequeue(this,d.queue)},d},r.fn.extend({fadeTo:function(a,b,c,d){return this.filter(da).css("opacity",0).show().end().animate({opacity:b},a,c,d)},animate:function(a,b,c,d){var e=r.isEmptyObject(a),f=r.speed(b,c,d),g=function(){var b=kb(this,r.extend({},a),f);(e||W.get(this,"finish"))&&b.stop(!0)};return g.finish=g,e||f.queue===!1?this.each(g):this.queue(f.queue,g)},stop:function(a,b,c){var d=function(a){var b=a.stop;delete a.stop,b(c)};return"string"!=typeof a&&(c=b,b=a,a=void 0),b&&a!==!1&&this.queue(a||"fx",[]),this.each(function(){var b=!0,e=null!=a&&a+"queueHooks",f=r.timers,g=W.get(this);if(e)g[e]&&g[e].stop&&d(g[e]);else for(e in g)g[e]&&g[e].stop&&db.test(e)&&d(g[e]);for(e=f.length;e--;)f[e].elem!==this||null!=a&&f[e].queue!==a||(f[e].anim.stop(c),b=!1,f.splice(e,1));!b&&c||r.dequeue(this,a)})},finish:function(a){return a!==!1&&(a=a||"fx"),this.each(function(){var b,c=W.get(this),d=c[a+"queue"],e=c[a+"queueHooks"],f=r.timers,g=d?d.length:0;for(c.finish=!0,r.queue(this,a,[]),e&&e.stop&&e.stop.call(this,!0),b=f.length;b--;)f[b].elem===this&&f[b].queue===a&&(f[b].anim.stop(!0),f.splice(b,1));for(b=0;b<g;b++)d[b]&&d[b].finish&&d[b].finish.call(this);delete c.finish})}}),r.each(["toggle","show","hide"],function(a,b){var c=r.fn[b];r.fn[b]=function(a,d,e){return null==a||"boolean"==typeof a?c.apply(this,arguments):this.animate(gb(b,!0),a,d,e)}}),r.each({slideDown:gb("show"),slideUp:gb("hide"),slideToggle:gb("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(a,b){r.fn[a]=function(a,c,d){return this.animate(b,a,c,d)}}),r.timers=[],r.fx.tick=function(){var a,b=0,c=r.timers;for(ab=r.now();b<c.length;b++)a=c[b],a()||c[b]!==a||c.splice(b--,1);c.length||r.fx.stop(),ab=void 0},r.fx.timer=function(a){r.timers.push(a),r.fx.start()},r.fx.interval=13,r.fx.start=function(){bb||(bb=!0,eb())},r.fx.stop=function(){bb=null},r.fx.speeds={slow:600,fast:200,_default:400},r.fn.delay=function(b,c){return b=r.fx?r.fx.speeds[b]||b:b,c=c||"fx",this.queue(c,function(c,d){var e=a.setTimeout(c,b);d.stop=function(){a.clearTimeout(e)}})},function(){var a=d.createElement("input"),b=d.createElement("select"),c=b.appendChild(d.createElement("option"));a.type="checkbox",o.checkOn=""!==a.value,o.optSelected=c.selected,a=d.createElement("input"),a.value="t",a.type="radio",o.radioValue="t"===a.value}();var lb,mb=r.expr.attrHandle;r.fn.extend({attr:function(a,b){return T(this,r.attr,a,b,arguments.length>1)},removeAttr:function(a){return this.each(function(){r.removeAttr(this,a)})}}),r.extend({attr:function(a,b,c){var d,e,f=a.nodeType;if(3!==f&&8!==f&&2!==f)return"undefined"==typeof a.getAttribute?r.prop(a,b,c):(1===f&&r.isXMLDoc(a)||(e=r.attrHooks[b.toLowerCase()]||(r.expr.match.bool.test(b)?lb:void 0)),void 0!==c?null===c?void r.removeAttr(a,b):e&&"set"in e&&void 0!==(d=e.set(a,c,b))?d:(a.setAttribute(b,c+""),c):e&&"get"in e&&null!==(d=e.get(a,b))?d:(d=r.find.attr(a,b),
null==d?void 0:d))},attrHooks:{type:{set:function(a,b){if(!o.radioValue&&"radio"===b&&B(a,"input")){var c=a.value;return a.setAttribute("type",b),c&&(a.value=c),b}}}},removeAttr:function(a,b){var c,d=0,e=b&&b.match(L);if(e&&1===a.nodeType)while(c=e[d++])a.removeAttribute(c)}}),lb={set:function(a,b,c){return b===!1?r.removeAttr(a,c):a.setAttribute(c,c),c}},r.each(r.expr.match.bool.source.match(/\w+/g),function(a,b){var c=mb[b]||r.find.attr;mb[b]=function(a,b,d){var e,f,g=b.toLowerCase();return d||(f=mb[g],mb[g]=e,e=null!=c(a,b,d)?g:null,mb[g]=f),e}});var nb=/^(?:input|select|textarea|button)$/i,ob=/^(?:a|area)$/i;r.fn.extend({prop:function(a,b){return T(this,r.prop,a,b,arguments.length>1)},removeProp:function(a){return this.each(function(){delete this[r.propFix[a]||a]})}}),r.extend({prop:function(a,b,c){var d,e,f=a.nodeType;if(3!==f&&8!==f&&2!==f)return 1===f&&r.isXMLDoc(a)||(b=r.propFix[b]||b,e=r.propHooks[b]),void 0!==c?e&&"set"in e&&void 0!==(d=e.set(a,c,b))?d:a[b]=c:e&&"get"in e&&null!==(d=e.get(a,b))?d:a[b]},propHooks:{tabIndex:{get:function(a){var b=r.find.attr(a,"tabindex");return b?parseInt(b,10):nb.test(a.nodeName)||ob.test(a.nodeName)&&a.href?0:-1}}},propFix:{"for":"htmlFor","class":"className"}}),o.optSelected||(r.propHooks.selected={get:function(a){var b=a.parentNode;return b&&b.parentNode&&b.parentNode.selectedIndex,null},set:function(a){var b=a.parentNode;b&&(b.selectedIndex,b.parentNode&&b.parentNode.selectedIndex)}}),r.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){r.propFix[this.toLowerCase()]=this});function pb(a){var b=a.match(L)||[];return b.join(" ")}function qb(a){return a.getAttribute&&a.getAttribute("class")||""}r.fn.extend({addClass:function(a){var b,c,d,e,f,g,h,i=0;if(r.isFunction(a))return this.each(function(b){r(this).addClass(a.call(this,b,qb(this)))});if("string"==typeof a&&a){b=a.match(L)||[];while(c=this[i++])if(e=qb(c),d=1===c.nodeType&&" "+pb(e)+" "){g=0;while(f=b[g++])d.indexOf(" "+f+" ")<0&&(d+=f+" ");h=pb(d),e!==h&&c.setAttribute("class",h)}}return this},removeClass:function(a){var b,c,d,e,f,g,h,i=0;if(r.isFunction(a))return this.each(function(b){r(this).removeClass(a.call(this,b,qb(this)))});if(!arguments.length)return this.attr("class","");if("string"==typeof a&&a){b=a.match(L)||[];while(c=this[i++])if(e=qb(c),d=1===c.nodeType&&" "+pb(e)+" "){g=0;while(f=b[g++])while(d.indexOf(" "+f+" ")>-1)d=d.replace(" "+f+" "," ");h=pb(d),e!==h&&c.setAttribute("class",h)}}return this},toggleClass:function(a,b){var c=typeof a;return"boolean"==typeof b&&"string"===c?b?this.addClass(a):this.removeClass(a):r.isFunction(a)?this.each(function(c){r(this).toggleClass(a.call(this,c,qb(this),b),b)}):this.each(function(){var b,d,e,f;if("string"===c){d=0,e=r(this),f=a.match(L)||[];while(b=f[d++])e.hasClass(b)?e.removeClass(b):e.addClass(b)}else void 0!==a&&"boolean"!==c||(b=qb(this),b&&W.set(this,"__className__",b),this.setAttribute&&this.setAttribute("class",b||a===!1?"":W.get(this,"__className__")||""))})},hasClass:function(a){var b,c,d=0;b=" "+a+" ";while(c=this[d++])if(1===c.nodeType&&(" "+pb(qb(c))+" ").indexOf(b)>-1)return!0;return!1}});var rb=/\r/g;r.fn.extend({val:function(a){var b,c,d,e=this[0];{if(arguments.length)return d=r.isFunction(a),this.each(function(c){var e;1===this.nodeType&&(e=d?a.call(this,c,r(this).val()):a,null==e?e="":"number"==typeof e?e+="":Array.isArray(e)&&(e=r.map(e,function(a){return null==a?"":a+""})),b=r.valHooks[this.type]||r.valHooks[this.nodeName.toLowerCase()],b&&"set"in b&&void 0!==b.set(this,e,"value")||(this.value=e))});if(e)return b=r.valHooks[e.type]||r.valHooks[e.nodeName.toLowerCase()],b&&"get"in b&&void 0!==(c=b.get(e,"value"))?c:(c=e.value,"string"==typeof c?c.replace(rb,""):null==c?"":c)}}}),r.extend({valHooks:{option:{get:function(a){var b=r.find.attr(a,"value");return null!=b?b:pb(r.text(a))}},select:{get:function(a){var b,c,d,e=a.options,f=a.selectedIndex,g="select-one"===a.type,h=g?null:[],i=g?f+1:e.length;for(d=f<0?i:g?f:0;d<i;d++)if(c=e[d],(c.selected||d===f)&&!c.disabled&&(!c.parentNode.disabled||!B(c.parentNode,"optgroup"))){if(b=r(c).val(),g)return b;h.push(b)}return h},set:function(a,b){var c,d,e=a.options,f=r.makeArray(b),g=e.length;while(g--)d=e[g],(d.selected=r.inArray(r.valHooks.option.get(d),f)>-1)&&(c=!0);return c||(a.selectedIndex=-1),f}}}}),r.each(["radio","checkbox"],function(){r.valHooks[this]={set:function(a,b){if(Array.isArray(b))return a.checked=r.inArray(r(a).val(),b)>-1}},o.checkOn||(r.valHooks[this].get=function(a){return null===a.getAttribute("value")?"on":a.value})});var sb=/^(?:focusinfocus|focusoutblur)$/;r.extend(r.event,{trigger:function(b,c,e,f){var g,h,i,j,k,m,n,o=[e||d],p=l.call(b,"type")?b.type:b,q=l.call(b,"namespace")?b.namespace.split("."):[];if(h=i=e=e||d,3!==e.nodeType&&8!==e.nodeType&&!sb.test(p+r.event.triggered)&&(p.indexOf(".")>-1&&(q=p.split("."),p=q.shift(),q.sort()),k=p.indexOf(":")<0&&"on"+p,b=b[r.expando]?b:new r.Event(p,"object"==typeof b&&b),b.isTrigger=f?2:3,b.namespace=q.join("."),b.rnamespace=b.namespace?new RegExp("(^|\\.)"+q.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,b.result=void 0,b.target||(b.target=e),c=null==c?[b]:r.makeArray(c,[b]),n=r.event.special[p]||{},f||!n.trigger||n.trigger.apply(e,c)!==!1)){if(!f&&!n.noBubble&&!r.isWindow(e)){for(j=n.delegateType||p,sb.test(j+p)||(h=h.parentNode);h;h=h.parentNode)o.push(h),i=h;i===(e.ownerDocument||d)&&o.push(i.defaultView||i.parentWindow||a)}g=0;while((h=o[g++])&&!b.isPropagationStopped())b.type=g>1?j:n.bindType||p,m=(W.get(h,"events")||{})[b.type]&&W.get(h,"handle"),m&&m.apply(h,c),m=k&&h[k],m&&m.apply&&U(h)&&(b.result=m.apply(h,c),b.result===!1&&b.preventDefault());return b.type=p,f||b.isDefaultPrevented()||n._default&&n._default.apply(o.pop(),c)!==!1||!U(e)||k&&r.isFunction(e[p])&&!r.isWindow(e)&&(i=e[k],i&&(e[k]=null),r.event.triggered=p,e[p](),r.event.triggered=void 0,i&&(e[k]=i)),b.result}},simulate:function(a,b,c){var d=r.extend(new r.Event,c,{type:a,isSimulated:!0});r.event.trigger(d,null,b)}}),r.fn.extend({trigger:function(a,b){return this.each(function(){r.event.trigger(a,b,this)})},triggerHandler:function(a,b){var c=this[0];if(c)return r.event.trigger(a,b,c,!0)}}),r.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(a,b){r.fn[b]=function(a,c){return arguments.length>0?this.on(b,null,a,c):this.trigger(b)}}),r.fn.extend({hover:function(a,b){return this.mouseenter(a).mouseleave(b||a)}}),o.focusin="onfocusin"in a,o.focusin||r.each({focus:"focusin",blur:"focusout"},function(a,b){var c=function(a){r.event.simulate(b,a.target,r.event.fix(a))};r.event.special[b]={setup:function(){var d=this.ownerDocument||this,e=W.access(d,b);e||d.addEventListener(a,c,!0),W.access(d,b,(e||0)+1)},teardown:function(){var d=this.ownerDocument||this,e=W.access(d,b)-1;e?W.access(d,b,e):(d.removeEventListener(a,c,!0),W.remove(d,b))}}});var tb=a.location,ub=r.now(),vb=/\?/;r.parseXML=function(b){var c;if(!b||"string"!=typeof b)return null;try{c=(new a.DOMParser).parseFromString(b,"text/xml")}catch(d){c=void 0}return c&&!c.getElementsByTagName("parsererror").length||r.error("Invalid XML: "+b),c};var wb=/\[\]$/,xb=/\r?\n/g,yb=/^(?:submit|button|image|reset|file)$/i,zb=/^(?:input|select|textarea|keygen)/i;function Ab(a,b,c,d){var e;if(Array.isArray(b))r.each(b,function(b,e){c||wb.test(a)?d(a,e):Ab(a+"["+("object"==typeof e&&null!=e?b:"")+"]",e,c,d)});else if(c||"object"!==r.type(b))d(a,b);else for(e in b)Ab(a+"["+e+"]",b[e],c,d)}r.param=function(a,b){var c,d=[],e=function(a,b){var c=r.isFunction(b)?b():b;d[d.length]=encodeURIComponent(a)+"="+encodeURIComponent(null==c?"":c)};if(Array.isArray(a)||a.jquery&&!r.isPlainObject(a))r.each(a,function(){e(this.name,this.value)});else for(c in a)Ab(c,a[c],b,e);return d.join("&")},r.fn.extend({serialize:function(){return r.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var a=r.prop(this,"elements");return a?r.makeArray(a):this}).filter(function(){var a=this.type;return this.name&&!r(this).is(":disabled")&&zb.test(this.nodeName)&&!yb.test(a)&&(this.checked||!ja.test(a))}).map(function(a,b){var c=r(this).val();return null==c?null:Array.isArray(c)?r.map(c,function(a){return{name:b.name,value:a.replace(xb,"\r\n")}}):{name:b.name,value:c.replace(xb,"\r\n")}}).get()}});var Bb=/%20/g,Cb=/#.*$/,Db=/([?&])_=[^&]*/,Eb=/^(.*?):[ \t]*([^\r\n]*)$/gm,Fb=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,Gb=/^(?:GET|HEAD)$/,Hb=/^\/\//,Ib={},Jb={},Kb="*/".concat("*"),Lb=d.createElement("a");Lb.href=tb.href;function Mb(a){return function(b,c){"string"!=typeof b&&(c=b,b="*");var d,e=0,f=b.toLowerCase().match(L)||[];if(r.isFunction(c))while(d=f[e++])"+"===d[0]?(d=d.slice(1)||"*",(a[d]=a[d]||[]).unshift(c)):(a[d]=a[d]||[]).push(c)}}function Nb(a,b,c,d){var e={},f=a===Jb;function g(h){var i;return e[h]=!0,r.each(a[h]||[],function(a,h){var j=h(b,c,d);return"string"!=typeof j||f||e[j]?f?!(i=j):void 0:(b.dataTypes.unshift(j),g(j),!1)}),i}return g(b.dataTypes[0])||!e["*"]&&g("*")}function Ob(a,b){var c,d,e=r.ajaxSettings.flatOptions||{};for(c in b)void 0!==b[c]&&((e[c]?a:d||(d={}))[c]=b[c]);return d&&r.extend(!0,a,d),a}function Pb(a,b,c){var d,e,f,g,h=a.contents,i=a.dataTypes;while("*"===i[0])i.shift(),void 0===d&&(d=a.mimeType||b.getResponseHeader("Content-Type"));if(d)for(e in h)if(h[e]&&h[e].test(d)){i.unshift(e);break}if(i[0]in c)f=i[0];else{for(e in c){if(!i[0]||a.converters[e+" "+i[0]]){f=e;break}g||(g=e)}f=f||g}if(f)return f!==i[0]&&i.unshift(f),c[f]}function Qb(a,b,c,d){var e,f,g,h,i,j={},k=a.dataTypes.slice();if(k[1])for(g in a.converters)j[g.toLowerCase()]=a.converters[g];f=k.shift();while(f)if(a.responseFields[f]&&(c[a.responseFields[f]]=b),!i&&d&&a.dataFilter&&(b=a.dataFilter(b,a.dataType)),i=f,f=k.shift())if("*"===f)f=i;else if("*"!==i&&i!==f){if(g=j[i+" "+f]||j["* "+f],!g)for(e in j)if(h=e.split(" "),h[1]===f&&(g=j[i+" "+h[0]]||j["* "+h[0]])){g===!0?g=j[e]:j[e]!==!0&&(f=h[0],k.unshift(h[1]));break}if(g!==!0)if(g&&a["throws"])b=g(b);else try{b=g(b)}catch(l){return{state:"parsererror",error:g?l:"No conversion from "+i+" to "+f}}}return{state:"success",data:b}}r.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:tb.href,type:"GET",isLocal:Fb.test(tb.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":Kb,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":r.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(a,b){return b?Ob(Ob(a,r.ajaxSettings),b):Ob(r.ajaxSettings,a)},ajaxPrefilter:Mb(Ib),ajaxTransport:Mb(Jb),ajax:function(b,c){"object"==typeof b&&(c=b,b=void 0),c=c||{};var e,f,g,h,i,j,k,l,m,n,o=r.ajaxSetup({},c),p=o.context||o,q=o.context&&(p.nodeType||p.jquery)?r(p):r.event,s=r.Deferred(),t=r.Callbacks("once memory"),u=o.statusCode||{},v={},w={},x="canceled",y={readyState:0,getResponseHeader:function(a){var b;if(k){if(!h){h={};while(b=Eb.exec(g))h[b[1].toLowerCase()]=b[2]}b=h[a.toLowerCase()]}return null==b?null:b},getAllResponseHeaders:function(){return k?g:null},setRequestHeader:function(a,b){return null==k&&(a=w[a.toLowerCase()]=w[a.toLowerCase()]||a,v[a]=b),this},overrideMimeType:function(a){return null==k&&(o.mimeType=a),this},statusCode:function(a){var b;if(a)if(k)y.always(a[y.status]);else for(b in a)u[b]=[u[b],a[b]];return this},abort:function(a){var b=a||x;return e&&e.abort(b),A(0,b),this}};if(s.promise(y),o.url=((b||o.url||tb.href)+"").replace(Hb,tb.protocol+"//"),o.type=c.method||c.type||o.method||o.type,o.dataTypes=(o.dataType||"*").toLowerCase().match(L)||[""],null==o.crossDomain){j=d.createElement("a");try{j.href=o.url,j.href=j.href,o.crossDomain=Lb.protocol+"//"+Lb.host!=j.protocol+"//"+j.host}catch(z){o.crossDomain=!0}}if(o.data&&o.processData&&"string"!=typeof o.data&&(o.data=r.param(o.data,o.traditional)),Nb(Ib,o,c,y),k)return y;l=r.event&&o.global,l&&0===r.active++&&r.event.trigger("ajaxStart"),o.type=o.type.toUpperCase(),o.hasContent=!Gb.test(o.type),f=o.url.replace(Cb,""),o.hasContent?o.data&&o.processData&&0===(o.contentType||"").indexOf("application/x-www-form-urlencoded")&&(o.data=o.data.replace(Bb,"+")):(n=o.url.slice(f.length),o.data&&(f+=(vb.test(f)?"&":"?")+o.data,delete o.data),o.cache===!1&&(f=f.replace(Db,"$1"),n=(vb.test(f)?"&":"?")+"_="+ub++ +n),o.url=f+n),o.ifModified&&(r.lastModified[f]&&y.setRequestHeader("If-Modified-Since",r.lastModified[f]),r.etag[f]&&y.setRequestHeader("If-None-Match",r.etag[f])),(o.data&&o.hasContent&&o.contentType!==!1||c.contentType)&&y.setRequestHeader("Content-Type",o.contentType),y.setRequestHeader("Accept",o.dataTypes[0]&&o.accepts[o.dataTypes[0]]?o.accepts[o.dataTypes[0]]+("*"!==o.dataTypes[0]?", "+Kb+"; q=0.01":""):o.accepts["*"]);for(m in o.headers)y.setRequestHeader(m,o.headers[m]);if(o.beforeSend&&(o.beforeSend.call(p,y,o)===!1||k))return y.abort();if(x="abort",t.add(o.complete),y.done(o.success),y.fail(o.error),e=Nb(Jb,o,c,y)){if(y.readyState=1,l&&q.trigger("ajaxSend",[y,o]),k)return y;o.async&&o.timeout>0&&(i=a.setTimeout(function(){y.abort("timeout")},o.timeout));try{k=!1,e.send(v,A)}catch(z){if(k)throw z;A(-1,z)}}else A(-1,"No Transport");function A(b,c,d,h){var j,m,n,v,w,x=c;k||(k=!0,i&&a.clearTimeout(i),e=void 0,g=h||"",y.readyState=b>0?4:0,j=b>=200&&b<300||304===b,d&&(v=Pb(o,y,d)),v=Qb(o,v,y,j),j?(o.ifModified&&(w=y.getResponseHeader("Last-Modified"),w&&(r.lastModified[f]=w),w=y.getResponseHeader("etag"),w&&(r.etag[f]=w)),204===b||"HEAD"===o.type?x="nocontent":304===b?x="notmodified":(x=v.state,m=v.data,n=v.error,j=!n)):(n=x,!b&&x||(x="error",b<0&&(b=0))),y.status=b,y.statusText=(c||x)+"",j?s.resolveWith(p,[m,x,y]):s.rejectWith(p,[y,x,n]),y.statusCode(u),u=void 0,l&&q.trigger(j?"ajaxSuccess":"ajaxError",[y,o,j?m:n]),t.fireWith(p,[y,x]),l&&(q.trigger("ajaxComplete",[y,o]),--r.active||r.event.trigger("ajaxStop")))}return y},getJSON:function(a,b,c){return r.get(a,b,c,"json")},getScript:function(a,b){return r.get(a,void 0,b,"script")}}),r.each(["get","post"],function(a,b){r[b]=function(a,c,d,e){return r.isFunction(c)&&(e=e||d,d=c,c=void 0),r.ajax(r.extend({url:a,type:b,dataType:e,data:c,success:d},r.isPlainObject(a)&&a))}}),r._evalUrl=function(a){return r.ajax({url:a,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,"throws":!0})},r.fn.extend({wrapAll:function(a){var b;return this[0]&&(r.isFunction(a)&&(a=a.call(this[0])),b=r(a,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&b.insertBefore(this[0]),b.map(function(){var a=this;while(a.firstElementChild)a=a.firstElementChild;return a}).append(this)),this},wrapInner:function(a){return r.isFunction(a)?this.each(function(b){r(this).wrapInner(a.call(this,b))}):this.each(function(){var b=r(this),c=b.contents();c.length?c.wrapAll(a):b.append(a)})},wrap:function(a){var b=r.isFunction(a);return this.each(function(c){r(this).wrapAll(b?a.call(this,c):a)})},unwrap:function(a){return this.parent(a).not("body").each(function(){r(this).replaceWith(this.childNodes)}),this}}),r.expr.pseudos.hidden=function(a){return!r.expr.pseudos.visible(a)},r.expr.pseudos.visible=function(a){return!!(a.offsetWidth||a.offsetHeight||a.getClientRects().length)},r.ajaxSettings.xhr=function(){try{return new a.XMLHttpRequest}catch(b){}};var Rb={0:200,1223:204},Sb=r.ajaxSettings.xhr();o.cors=!!Sb&&"withCredentials"in Sb,o.ajax=Sb=!!Sb,r.ajaxTransport(function(b){var c,d;if(o.cors||Sb&&!b.crossDomain)return{send:function(e,f){var g,h=b.xhr();if(h.open(b.type,b.url,b.async,b.username,b.password),b.xhrFields)for(g in b.xhrFields)h[g]=b.xhrFields[g];b.mimeType&&h.overrideMimeType&&h.overrideMimeType(b.mimeType),b.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest");for(g in e)h.setRequestHeader(g,e[g]);c=function(a){return function(){c&&(c=d=h.onload=h.onerror=h.onabort=h.onreadystatechange=null,"abort"===a?h.abort():"error"===a?"number"!=typeof h.status?f(0,"error"):f(h.status,h.statusText):f(Rb[h.status]||h.status,h.statusText,"text"!==(h.responseType||"text")||"string"!=typeof h.responseText?{binary:h.response}:{text:h.responseText},h.getAllResponseHeaders()))}},h.onload=c(),d=h.onerror=c("error"),void 0!==h.onabort?h.onabort=d:h.onreadystatechange=function(){4===h.readyState&&a.setTimeout(function(){c&&d()})},c=c("abort");try{h.send(b.hasContent&&b.data||null)}catch(i){if(c)throw i}},abort:function(){c&&c()}}}),r.ajaxPrefilter(function(a){a.crossDomain&&(a.contents.script=!1)}),r.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(a){return r.globalEval(a),a}}}),r.ajaxPrefilter("script",function(a){void 0===a.cache&&(a.cache=!1),a.crossDomain&&(a.type="GET")}),r.ajaxTransport("script",function(a){if(a.crossDomain){var b,c;return{send:function(e,f){b=r("<script>").prop({charset:a.scriptCharset,src:a.url}).on("load error",c=function(a){b.remove(),c=null,a&&f("error"===a.type?404:200,a.type)}),d.head.appendChild(b[0])},abort:function(){c&&c()}}}});var Tb=[],Ub=/(=)\?(?=&|$)|\?\?/;r.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var a=Tb.pop()||r.expando+"_"+ub++;return this[a]=!0,a}}),r.ajaxPrefilter("json jsonp",function(b,c,d){var e,f,g,h=b.jsonp!==!1&&(Ub.test(b.url)?"url":"string"==typeof b.data&&0===(b.contentType||"").indexOf("application/x-www-form-urlencoded")&&Ub.test(b.data)&&"data");if(h||"jsonp"===b.dataTypes[0])return e=b.jsonpCallback=r.isFunction(b.jsonpCallback)?b.jsonpCallback():b.jsonpCallback,h?b[h]=b[h].replace(Ub,"$1"+e):b.jsonp!==!1&&(b.url+=(vb.test(b.url)?"&":"?")+b.jsonp+"="+e),b.converters["script json"]=function(){return g||r.error(e+" was not called"),g[0]},b.dataTypes[0]="json",f=a[e],a[e]=function(){g=arguments},d.always(function(){void 0===f?r(a).removeProp(e):a[e]=f,b[e]&&(b.jsonpCallback=c.jsonpCallback,Tb.push(e)),g&&r.isFunction(f)&&f(g[0]),g=f=void 0}),"script"}),o.createHTMLDocument=function(){var a=d.implementation.createHTMLDocument("").body;return a.innerHTML="<form></form><form></form>",2===a.childNodes.length}(),r.parseHTML=function(a,b,c){if("string"!=typeof a)return[];"boolean"==typeof b&&(c=b,b=!1);var e,f,g;return b||(o.createHTMLDocument?(b=d.implementation.createHTMLDocument(""),e=b.createElement("base"),e.href=d.location.href,b.head.appendChild(e)):b=d),f=C.exec(a),g=!c&&[],f?[b.createElement(f[1])]:(f=qa([a],b,g),g&&g.length&&r(g).remove(),r.merge([],f.childNodes))},r.fn.load=function(a,b,c){var d,e,f,g=this,h=a.indexOf(" ");return h>-1&&(d=pb(a.slice(h)),a=a.slice(0,h)),r.isFunction(b)?(c=b,b=void 0):b&&"object"==typeof b&&(e="POST"),g.length>0&&r.ajax({url:a,type:e||"GET",dataType:"html",data:b}).done(function(a){f=arguments,g.html(d?r("<div>").append(r.parseHTML(a)).find(d):a)}).always(c&&function(a,b){g.each(function(){c.apply(this,f||[a.responseText,b,a])})}),this},r.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(a,b){r.fn[b]=function(a){return this.on(b,a)}}),r.expr.pseudos.animated=function(a){return r.grep(r.timers,function(b){return a===b.elem}).length},r.offset={setOffset:function(a,b,c){var d,e,f,g,h,i,j,k=r.css(a,"position"),l=r(a),m={};"static"===k&&(a.style.position="relative"),h=l.offset(),f=r.css(a,"top"),i=r.css(a,"left"),j=("absolute"===k||"fixed"===k)&&(f+i).indexOf("auto")>-1,j?(d=l.position(),g=d.top,e=d.left):(g=parseFloat(f)||0,e=parseFloat(i)||0),r.isFunction(b)&&(b=b.call(a,c,r.extend({},h))),null!=b.top&&(m.top=b.top-h.top+g),null!=b.left&&(m.left=b.left-h.left+e),"using"in b?b.using.call(a,m):l.css(m)}},r.fn.extend({offset:function(a){if(arguments.length)return void 0===a?this:this.each(function(b){r.offset.setOffset(this,a,b)});var b,c,d,e,f=this[0];if(f)return f.getClientRects().length?(d=f.getBoundingClientRect(),b=f.ownerDocument,c=b.documentElement,e=b.defaultView,{top:d.top+e.pageYOffset-c.clientTop,left:d.left+e.pageXOffset-c.clientLeft}):{top:0,left:0}},position:function(){if(this[0]){var a,b,c=this[0],d={top:0,left:0};return"fixed"===r.css(c,"position")?b=c.getBoundingClientRect():(a=this.offsetParent(),b=this.offset(),B(a[0],"html")||(d=a.offset()),d={top:d.top+r.css(a[0],"borderTopWidth",!0),left:d.left+r.css(a[0],"borderLeftWidth",!0)}),{top:b.top-d.top-r.css(c,"marginTop",!0),left:b.left-d.left-r.css(c,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var a=this.offsetParent;while(a&&"static"===r.css(a,"position"))a=a.offsetParent;return a||ra})}}),r.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(a,b){var c="pageYOffset"===b;r.fn[a]=function(d){return T(this,function(a,d,e){var f;return r.isWindow(a)?f=a:9===a.nodeType&&(f=a.defaultView),void 0===e?f?f[b]:a[d]:void(f?f.scrollTo(c?f.pageXOffset:e,c?e:f.pageYOffset):a[d]=e)},a,d,arguments.length)}}),r.each(["top","left"],function(a,b){r.cssHooks[b]=Pa(o.pixelPosition,function(a,c){if(c)return c=Oa(a,b),Ma.test(c)?r(a).position()[b]+"px":c})}),r.each({Height:"height",Width:"width"},function(a,b){r.each({padding:"inner"+a,content:b,"":"outer"+a},function(c,d){r.fn[d]=function(e,f){var g=arguments.length&&(c||"boolean"!=typeof e),h=c||(e===!0||f===!0?"margin":"border");return T(this,function(b,c,e){var f;return r.isWindow(b)?0===d.indexOf("outer")?b["inner"+a]:b.document.documentElement["client"+a]:9===b.nodeType?(f=b.documentElement,Math.max(b.body["scroll"+a],f["scroll"+a],b.body["offset"+a],f["offset"+a],f["client"+a])):void 0===e?r.css(b,c,h):r.style(b,c,e,h)},b,g?e:void 0,g)}})}),r.fn.extend({bind:function(a,b,c){return this.on(a,null,b,c)},unbind:function(a,b){return this.off(a,null,b)},delegate:function(a,b,c,d){return this.on(b,a,c,d)},undelegate:function(a,b,c){return 1===arguments.length?this.off(a,"**"):this.off(b,a||"**",c)}}),r.holdReady=function(a){a?r.readyWait++:r.ready(!0)},r.isArray=Array.isArray,r.parseJSON=JSON.parse,r.nodeName=B,"function"==typeof define&&define.amd&&define("jquery",[],function(){return r});var Vb=a.jQuery,Wb=a.$;return r.noConflict=function(b){return a.$===r&&(a.$=Wb),b&&a.jQuery===r&&(a.jQuery=Vb),r},b||(a.jQuery=a.$=r),r});
!function(e){"function"==typeof define&&define.amd?define(["jquery"],e):"object"==typeof module&&"object"==typeof module.exports?module.exports=e(require("jquery")):e(jQuery)}(function(e){return function(t){"use strict";var r=t.tablesorter={version:"2.29.5",parsers:[],widgets:[],defaults:{theme:"default",widthFixed:!1,showProcessing:!1,headerTemplate:"{content}",onRenderTemplate:null,onRenderHeader:null,cancelSelection:!0,tabIndex:!0,dateFormat:"mmddyyyy",sortMultiSortKey:"shiftKey",sortResetKey:"ctrlKey",usNumberFormat:!0,delayInit:!1,serverSideSorting:!1,resort:!0,headers:{},ignoreCase:!0,sortForce:null,sortList:[],sortAppend:null,sortStable:!1,sortInitialOrder:"asc",sortLocaleCompare:!1,sortReset:!1,sortRestart:!1,emptyTo:"bottom",stringTo:"max",duplicateSpan:!0,textExtraction:"basic",textAttribute:"data-text",textSorter:null,numberSorter:null,initWidgets:!0,widgetClass:"widget-{name}",widgets:[],widgetOptions:{zebra:["even","odd"]},initialized:null,tableClass:"",cssAsc:"",cssDesc:"",cssNone:"",cssHeader:"",cssHeaderRow:"",cssProcessing:"",cssChildRow:"tablesorter-childRow",cssInfoBlock:"tablesorter-infoOnly",cssNoSort:"tablesorter-noSort",cssIgnoreRow:"tablesorter-ignoreRow",cssIcon:"tablesorter-icon",cssIconNone:"",cssIconAsc:"",cssIconDesc:"",cssIconDisabled:"",pointerClick:"click",pointerDown:"mousedown",pointerUp:"mouseup",selectorHeaders:"> thead th, > thead td",selectorSort:"th, td",selectorRemove:".remove-me",debug:!1,headerList:[],empties:{},strings:{},parsers:[],globalize:0,imgAttr:0},css:{table:"tablesorter",cssHasChild:"tablesorter-hasChildRow",childRow:"tablesorter-childRow",colgroup:"tablesorter-colgroup",header:"tablesorter-header",headerRow:"tablesorter-headerRow",headerIn:"tablesorter-header-inner",icon:"tablesorter-icon",processing:"tablesorter-processing",sortAsc:"tablesorter-headerAsc",sortDesc:"tablesorter-headerDesc",sortNone:"tablesorter-headerUnSorted"},language:{sortAsc:"Ascending sort applied, ",sortDesc:"Descending sort applied, ",sortNone:"No sort applied, ",sortDisabled:"sorting is disabled",nextAsc:"activate to apply an ascending sort",nextDesc:"activate to apply a descending sort",nextNone:"activate to remove the sort"},regex:{templateContent:/\{content\}/g,templateIcon:/\{icon\}/g,templateName:/\{name\}/i,spaces:/\s+/g,nonWord:/\W/g,formElements:/(input|select|button|textarea)/i,chunk:/(^([+\-]?(?:\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,chunks:/(^\\0|\\0$)/,hex:/^0x[0-9a-f]+$/i,comma:/,/g,digitNonUS:/[\s|\.]/g,digitNegativeTest:/^\s*\([.\d]+\)/,digitNegativeReplace:/^\s*\(([.\d]+)\)/,digitTest:/^[\-+(]?\d+[)]?$/,digitReplace:/[,.'"\s]/g},string:{max:1,min:-1,emptymin:1,emptymax:-1,zero:0,none:0,null:0,top:!0,bottom:!1},keyCodes:{enter:13},dates:{},instanceMethods:{},setup:function(e,a){if(e&&e.tHead&&0!==e.tBodies.length&&!0!==e.hasInitialized){var i="",s=t(e),o=t.metadata;e.hasInitialized=!1,e.isProcessing=!0,e.config=a,t.data(e,"tablesorter",a),a.debug&&(console[console.group?"group":"log"]("Initializing tablesorter v"+r.version),t.data(e,"startoveralltimer",new Date)),a.supportsDataObject=function(e){return e[0]=parseInt(e[0],10),e[0]>1||1===e[0]&&parseInt(e[1],10)>=4}(t.fn.jquery.split(".")),a.emptyTo=a.emptyTo.toLowerCase(),a.stringTo=a.stringTo.toLowerCase(),a.last={sortList:[],clickedIndex:-1},/tablesorter\-/.test(s.attr("class"))||(i=""!==a.theme?" tablesorter-"+a.theme:""),a.namespace?a.namespace="."+a.namespace.replace(r.regex.nonWord,""):a.namespace=".tablesorter"+Math.random().toString(16).slice(2),a.table=e,a.$table=s.addClass(r.css.table+" "+a.tableClass+i+" "+a.namespace.slice(1)).attr("role","grid"),a.$headers=s.find(a.selectorHeaders),a.$table.children().children("tr").attr("role","row"),a.$tbodies=s.children("tbody:not(."+a.cssInfoBlock+")").attr({"aria-live":"polite","aria-relevant":"all"}),a.$table.children("caption").length&&((i=a.$table.children("caption")[0]).id||(i.id=a.namespace.slice(1)+"caption"),a.$table.attr("aria-labelledby",i.id)),a.widgetInit={},a.textExtraction=a.$table.attr("data-text-extraction")||a.textExtraction||"basic",r.buildHeaders(a),r.fixColumnWidth(e),r.addWidgetFromClass(e),r.applyWidgetOptions(e),r.setupParsers(a),a.totalRows=0,r.validateOptions(a),a.delayInit||r.buildCache(a),r.bindEvents(e,a.$headers,!0),r.bindMethods(a),a.supportsDataObject&&void 0!==s.data().sortlist?a.sortList=s.data().sortlist:o&&s.metadata()&&s.metadata().sortlist&&(a.sortList=s.metadata().sortlist),r.applyWidget(e,!0),a.sortList.length>0?r.sortOn(a,a.sortList,{},!a.initWidgets):(r.setHeadersCss(a),a.initWidgets&&r.applyWidget(e,!1)),a.showProcessing&&s.unbind("sortBegin"+a.namespace+" sortEnd"+a.namespace).bind("sortBegin"+a.namespace+" sortEnd"+a.namespace,function(t){clearTimeout(a.timerProcessing),r.isProcessing(e),"sortBegin"===t.type&&(a.timerProcessing=setTimeout(function(){r.isProcessing(e,!0)},500))}),e.hasInitialized=!0,e.isProcessing=!1,a.debug&&(console.log("Overall initialization time:"+r.benchmark(t.data(e,"startoveralltimer"))),a.debug&&console.groupEnd&&console.groupEnd()),s.triggerHandler("tablesorter-initialized",e),"function"==typeof a.initialized&&a.initialized(e)}else a.debug&&(e.hasInitialized?console.warn("Stopping initialization. Tablesorter has already been initialized"):console.error("Stopping initialization! No table, thead or tbody",e))},bindMethods:function(e){var a=e.$table,i=e.namespace,s="sortReset update updateRows updateAll updateHeaders addRows updateCell updateComplete sorton appendCache updateCache applyWidgetId applyWidgets refreshWidgets destroy mouseup mouseleave ".split(" ").join(i+" ");a.unbind(s.replace(r.regex.spaces," ")).bind("sortReset"+i,function(e,t){e.stopPropagation(),r.sortReset(this.config,function(e){e.isApplyingWidgets?setTimeout(function(){r.applyWidget(e,"",t)},100):r.applyWidget(e,"",t)})}).bind("updateAll"+i,function(e,t,a){e.stopPropagation(),r.updateAll(this.config,t,a)}).bind("update"+i+" updateRows"+i,function(e,t,a){e.stopPropagation(),r.update(this.config,t,a)}).bind("updateHeaders"+i,function(e,t){e.stopPropagation(),r.updateHeaders(this.config,t)}).bind("updateCell"+i,function(e,t,a,i){e.stopPropagation(),r.updateCell(this.config,t,a,i)}).bind("addRows"+i,function(e,t,a,i){e.stopPropagation(),r.addRows(this.config,t,a,i)}).bind("updateComplete"+i,function(){this.isUpdating=!1}).bind("sorton"+i,function(e,t,a,i){e.stopPropagation(),r.sortOn(this.config,t,a,i)}).bind("appendCache"+i,function(e,a,i){e.stopPropagation(),r.appendCache(this.config,i),t.isFunction(a)&&a(this)}).bind("updateCache"+i,function(e,t,a){e.stopPropagation(),r.updateCache(this.config,t,a)}).bind("applyWidgetId"+i,function(e,t){e.stopPropagation(),r.applyWidgetId(this,t)}).bind("applyWidgets"+i,function(e,t){e.stopPropagation(),r.applyWidget(this,!1,t)}).bind("refreshWidgets"+i,function(e,t,a){e.stopPropagation(),r.refreshWidgets(this,t,a)}).bind("removeWidget"+i,function(e,t,a){e.stopPropagation(),r.removeWidget(this,t,a)}).bind("destroy"+i,function(e,t,a){e.stopPropagation(),r.destroy(this,t,a)}).bind("resetToLoadState"+i,function(a){a.stopPropagation(),r.removeWidget(this,!0,!1);var i=t.extend(!0,{},e.originalSettings);(e=t.extend(!0,{},r.defaults,i)).originalSettings=i,this.hasInitialized=!1,r.setup(this,e)})},bindEvents:function(e,a,i){var s,o=(e=t(e)[0]).config,n=o.namespace,l=null;!0!==i&&(a.addClass(n.slice(1)+"_extra_headers"),(s=r.getClosest(a,"table")).length&&"TABLE"===s[0].nodeName&&s[0]!==e&&t(s[0]).addClass(n.slice(1)+"_extra_table")),s=(o.pointerDown+" "+o.pointerUp+" "+o.pointerClick+" sort keyup ").replace(r.regex.spaces," ").split(" ").join(n+" "),a.find(o.selectorSort).add(a.filter(o.selectorSort)).unbind(s).bind(s,function(e,i){var s,n,d,c=t(e.target),f=" "+e.type+" ";if(!(1!==(e.which||e.button)&&!f.match(" "+o.pointerClick+" | sort | keyup ")||" keyup "===f&&e.which!==r.keyCodes.enter||f.match(" "+o.pointerClick+" ")&&void 0!==e.which||f.match(" "+o.pointerUp+" ")&&l!==e.target&&!0!==i)){if(f.match(" "+o.pointerDown+" "))return l=e.target,void("1"===(d=c.jquery.split("."))[0]&&d[1]<4&&e.preventDefault());if(l=null,r.regex.formElements.test(e.target.nodeName)||c.hasClass(o.cssNoSort)||c.parents("."+o.cssNoSort).length>0||c.parents("button").length>0)return!o.cancelSelection;o.delayInit&&r.isEmptyObject(o.cache)&&r.buildCache(o),s=r.getClosest(t(this),"."+r.css.header),d=a.index(s),o.last.clickedIndex=d<0?s.attr("data-column"):d,(n=o.$headers[o.last.clickedIndex])&&!n.sortDisabled&&r.initSort(o,n,e)}}),o.cancelSelection&&a.attr("unselectable","on").bind("selectstart",!1).css({"user-select":"none",MozUserSelect:"none"})},buildHeaders:function(e){var a,i,s,o;for(e.headerList=[],e.headerContent=[],e.sortVars=[],e.debug&&(s=new Date),e.columns=r.computeColumnIndex(e.$table.children("thead, tfoot").children("tr")),i=e.cssIcon?'<i class="'+(e.cssIcon===r.css.icon?r.css.icon:e.cssIcon+" "+r.css.icon)+'"></i>':"",e.$headers=t(t.map(e.$table.find(e.selectorHeaders),function(a,s){var o,n,l,d,c,f=t(a);if(!r.getClosest(f,"tr").hasClass(e.cssIgnoreRow))return/(th|td)/i.test(a.nodeName)||(c=r.getClosest(f,"th, td"),f.attr("data-column",c.attr("data-column"))),o=r.getColumnData(e.table,e.headers,s,!0),e.headerContent[s]=f.html(),""===e.headerTemplate||f.find("."+r.css.headerIn).length||(d=e.headerTemplate.replace(r.regex.templateContent,f.html()).replace(r.regex.templateIcon,f.find("."+r.css.icon).length?"":i),e.onRenderTemplate&&(n=e.onRenderTemplate.apply(f,[s,d]))&&"string"==typeof n&&(d=n),f.html('<div class="'+r.css.headerIn+'">'+d+"</div>")),e.onRenderHeader&&e.onRenderHeader.apply(f,[s,e,e.$table]),l=parseInt(f.attr("data-column"),10),a.column=l,c=r.getOrder(r.getData(f,o,"sortInitialOrder")||e.sortInitialOrder),e.sortVars[l]={count:-1,order:c?e.sortReset?[1,0,2]:[1,0]:e.sortReset?[0,1,2]:[0,1],lockedOrder:!1},void 0!==(c=r.getData(f,o,"lockedOrder")||!1)&&!1!==c&&(e.sortVars[l].lockedOrder=!0,e.sortVars[l].order=r.getOrder(c)?[1,1]:[0,0]),e.headerList[s]=a,f.addClass(r.css.header+" "+e.cssHeader),r.getClosest(f,"tr").addClass(r.css.headerRow+" "+e.cssHeaderRow).attr("role","row"),e.tabIndex&&f.attr("tabindex",0),a})),e.$headerIndexed=[],o=0;o<e.columns;o++)r.isEmptyObject(e.sortVars[o])&&(e.sortVars[o]={}),a=e.$headers.filter('[data-column="'+o+'"]'),e.$headerIndexed[o]=a.length?a.not(".sorter-false").length?a.not(".sorter-false").filter(":last"):a.filter(":last"):t();e.$table.find(e.selectorHeaders).attr({scope:"col",role:"columnheader"}),r.updateHeader(e),e.debug&&(console.log("Built headers:"+r.benchmark(s)),console.log(e.$headers))},addInstanceMethods:function(e){t.extend(r.instanceMethods,e)},setupParsers:function(e,t){var a,i,s,o,n,l,d,c,f,u,g,p,h,m,b=e.table,y=0,v={};if(e.$tbodies=e.$table.children("tbody:not(."+e.cssInfoBlock+")"),h=void 0===t?e.$tbodies:t,0===(m=h.length))return e.debug?console.warn("Warning: *Empty table!* Not building a parser cache"):"";for(e.debug&&(p=new Date,console[console.group?"group":"log"]("Detecting parsers for each column")),i={extractors:[],parsers:[]};y<m;){if((a=h[y].rows).length)for(n=0,o=e.columns,l=0;l<o;l++){if((d=e.$headerIndexed[n])&&d.length&&(c=r.getColumnData(b,e.headers,n),g=r.getParserById(r.getData(d,c,"extractor")),u=r.getParserById(r.getData(d,c,"sorter")),f="false"===r.getData(d,c,"parser"),e.empties[n]=(r.getData(d,c,"empty")||e.emptyTo||(e.emptyToBottom?"bottom":"top")).toLowerCase(),e.strings[n]=(r.getData(d,c,"string")||e.stringTo||"max").toLowerCase(),f&&(u=r.getParserById("no-parser")),g||(g=!1),u||(u=r.detectParserForColumn(e,a,-1,n)),e.debug&&(v["("+n+") "+d.text()]={parser:u.id,extractor:g?g.id:"none",string:e.strings[n],empty:e.empties[n]}),i.parsers[n]=u,i.extractors[n]=g,(s=d[0].colSpan-1)>0))for(n+=s,o+=s;s+1>0;)i.parsers[n-s]=u,i.extractors[n-s]=g,s--;n++}y+=i.parsers.length?m:1}e.debug&&(r.isEmptyObject(v)?console.warn("  No parsers detected!"):console[console.table?"table":"log"](v),console.log("Completed detecting parsers"+r.benchmark(p)),console.groupEnd&&console.groupEnd()),e.parsers=i.parsers,e.extractors=i.extractors},addParser:function(e){var t,a=r.parsers.length,i=!0;for(t=0;t<a;t++)r.parsers[t].id.toLowerCase()===e.id.toLowerCase()&&(i=!1);i&&(r.parsers[r.parsers.length]=e)},getParserById:function(e){if("false"==e)return!1;var t,a=r.parsers.length;for(t=0;t<a;t++)if(r.parsers[t].id.toLowerCase()===e.toString().toLowerCase())return r.parsers[t];return!1},detectParserForColumn:function(e,a,i,s){for(var o,n,l,d=r.parsers.length,c=!1,f="",u=!0;""===f&&u;)(l=a[++i])&&i<50?l.className.indexOf(r.cssIgnoreRow)<0&&(c=a[i].cells[s],f=r.getElementText(e,c,s),n=t(c),e.debug&&console.log("Checking if value was empty on row "+i+", column: "+s+': "'+f+'"')):u=!1;for(;--d>=0;)if((o=r.parsers[d])&&"text"!==o.id&&o.is&&o.is(f,e.table,c,n))return o;return r.getParserById("text")},getElementText:function(e,a,i){if(!a)return"";var s,o=e.textExtraction||"",n=a.jquery?a:t(a);return"string"==typeof o?"basic"===o&&void 0!==(s=n.attr(e.textAttribute))?t.trim(s):t.trim(a.textContent||n.text()):"function"==typeof o?t.trim(o(n[0],e.table,i)):"function"==typeof(s=r.getColumnData(e.table,o,i))?t.trim(s(n[0],e.table,i)):t.trim(n[0].textContent||n.text())},getParsedText:function(e,t,a,i){void 0===i&&(i=r.getElementText(e,t,a));var s=""+i,o=e.parsers[a],n=e.extractors[a];return o&&(n&&"function"==typeof n.format&&(i=n.format(i,e.table,t,a)),s="no-parser"===o.id?"":o.format(""+i,e.table,t,a),e.ignoreCase&&"string"==typeof s&&(s=s.toLowerCase())),s},buildCache:function(e,a,i){var s,o,n,l,d,c,f,u,g,p,h,m,b,y,v,w,x,C,_,$,S,z,F=e.table,R=e.parsers;if(e.$tbodies=e.$table.children("tbody:not(."+e.cssInfoBlock+")"),f=void 0===i?e.$tbodies:i,e.cache={},e.totalRows=0,!R)return e.debug?console.warn("Warning: *Empty table!* Not building a cache"):"";for(e.debug&&(m=new Date),e.showProcessing&&r.isProcessing(F,!0),c=0;c<f.length;c++){for(w=[],s=e.cache[c]={normalized:[]},b=f[c]&&f[c].rows.length||0,l=0;l<b;++l)if(y={child:[],raw:[]},u=t(f[c].rows[l]),g=[],!u.hasClass(e.selectorRemove.slice(1)))if(u.hasClass(e.cssChildRow)&&0!==l)for(S=s.normalized.length-1,(v=s.normalized[S][e.columns]).$row=v.$row.add(u),u.prev().hasClass(e.cssChildRow)||u.prev().addClass(r.css.cssHasChild),p=u.children("th, td"),S=v.child.length,v.child[S]=[],C=0,$=e.columns,d=0;d<$;d++)(h=p[d])&&(v.child[S][d]=r.getParsedText(e,h,d),(x=p[d].colSpan-1)>0&&(C+=x,$+=x)),C++;else{for(y.$row=u,y.order=l,C=0,$=e.columns,d=0;d<$;++d){if((h=u[0].cells[d])&&C<e.columns&&(!(_=void 0!==R[C])&&e.debug&&console.warn("No parser found for row: "+l+", column: "+d+'; cell containing: "'+t(h).text()+'"; does it have a header?'),o=r.getElementText(e,h,C),y.raw[C]=o,n=r.getParsedText(e,h,C,o),g[C]=n,_&&"numeric"===(R[C].type||"").toLowerCase()&&(w[C]=Math.max(Math.abs(n)||0,w[C]||0)),(x=h.colSpan-1)>0)){for(z=0;z<=x;)n=e.duplicateSpan||0===z?o:"string"!=typeof e.textExtraction?r.getElementText(e,h,C+z)||"":"",y.raw[C+z]=n,g[C+z]=n,z++;C+=x,$+=x}C++}g[e.columns]=y,s.normalized[s.normalized.length]=g}s.colMax=w,e.totalRows+=s.normalized.length}if(e.showProcessing&&r.isProcessing(F),e.debug){for(S=Math.min(5,e.cache[0].normalized.length),console[console.group?"group":"log"]("Building cache for "+e.totalRows+" rows (showing "+S+" rows in log) and "+e.columns+" columns"+r.benchmark(m)),o={},d=0;d<e.columns;d++)for(C=0;C<S;C++)o["row: "+C]||(o["row: "+C]={}),o["row: "+C][e.$headerIndexed[d].text()]=e.cache[0].normalized[C][d];console[console.table?"table":"log"](o),console.groupEnd&&console.groupEnd()}t.isFunction(a)&&a(F)},getColumnText:function(e,a,i,s){var o,n,l,d,c,f,u,g,p,h,m="function"==typeof i,b="all"===a,y={raw:[],parsed:[],$cell:[]},v=(e=t(e)[0]).config;if(!r.isEmptyObject(v)){for(c=v.$tbodies.length,o=0;o<c;o++)for(f=(l=v.cache[o].normalized).length,n=0;n<f;n++)d=l[n],s&&!d[v.columns].$row.is(s)||(h=!0,g=b?d.slice(0,v.columns):d[a],d=d[v.columns],u=b?d.raw:d.raw[a],p=b?d.$row.children():d.$row.children().eq(a),m&&(h=i({tbodyIndex:o,rowIndex:n,parsed:g,raw:u,$row:d.$row,$cell:p})),!1!==h&&(y.parsed[y.parsed.length]=g,y.raw[y.raw.length]=u,y.$cell[y.$cell.length]=p));return y}v.debug&&console.warn("No cache found - aborting getColumnText function!")},setHeadersCss:function(e){var a,i,s=e.sortList,o=s.length,n=r.css.sortNone+" "+e.cssNone,l=[r.css.sortAsc+" "+e.cssAsc,r.css.sortDesc+" "+e.cssDesc],d=[e.cssIconAsc,e.cssIconDesc,e.cssIconNone],c=["ascending","descending"],f=function(e,t){e.removeClass(n).addClass(l[t]).attr("aria-sort",c[t]).find("."+r.css.icon).removeClass(d[2]).addClass(d[t])},u=e.$table.find("tfoot tr").children("td, th").add(t(e.namespace+"_extra_headers")).removeClass(l.join(" ")),g=e.$headers.add(t("thead "+e.namespace+"_extra_headers")).removeClass(l.join(" ")).addClass(n).attr("aria-sort","none").find("."+r.css.icon).removeClass(d.join(" ")).end();for(g.not(".sorter-false").find("."+r.css.icon).addClass(d[2]),e.cssIconDisabled&&g.filter(".sorter-false").find("."+r.css.icon).addClass(e.cssIconDisabled),a=0;a<o;a++)if(2!==s[a][1]){if(g=e.$headers.filter(function(t){for(var a=!0,i=e.$headers.eq(t),s=parseInt(i.attr("data-column"),10),o=s+r.getClosest(i,"th, td")[0].colSpan;s<o;s++)a=!!a&&(a||r.isValueInArray(s,e.sortList)>-1);return a}),(g=g.not(".sorter-false").filter('[data-column="'+s[a][0]+'"]'+(1===o?":last":""))).length)for(i=0;i<g.length;i++)g[i].sortDisabled||f(g.eq(i),s[a][1]);u.length&&f(u.filter('[data-column="'+s[a][0]+'"]'),s[a][1])}for(o=e.$headers.length,a=0;a<o;a++)r.setColumnAriaLabel(e,e.$headers.eq(a))},getClosest:function(e,r){return t.fn.closest?e.closest(r):e.is(r)?e:e.parents(r).filter(":first")},setColumnAriaLabel:function(e,a,i){if(a.length){var s=parseInt(a.attr("data-column"),10),o=e.sortVars[s],n=a.hasClass(r.css.sortAsc)?"sortAsc":a.hasClass(r.css.sortDesc)?"sortDesc":"sortNone",l=t.trim(a.text())+": "+r.language[n];a.hasClass("sorter-false")||!1===i?l+=r.language.sortDisabled:(n=(o.count+1)%o.order.length,i=o.order[n],l+=r.language[0===i?"nextAsc":1===i?"nextDesc":"nextNone"]),a.attr("aria-label",l)}},updateHeader:function(e){var t,a,i,s,o=e.table,n=e.$headers.length;for(t=0;t<n;t++)i=e.$headers.eq(t),s=r.getColumnData(o,e.headers,t,!0),a="false"===r.getData(i,s,"sorter")||"false"===r.getData(i,s,"parser"),r.setColumnSort(e,i,a)},setColumnSort:function(e,t,r){var a=e.table.id;t[0].sortDisabled=r,t[r?"addClass":"removeClass"]("sorter-false").attr("aria-disabled",""+r),e.tabIndex&&(r?t.removeAttr("tabindex"):t.attr("tabindex","0")),a&&(r?t.removeAttr("aria-controls"):t.attr("aria-controls",a))},updateHeaderSortCount:function(e,a){var i,s,o,n,l,d,c,f,u=a||e.sortList,g=u.length;for(e.sortList=[],n=0;n<g;n++)if(c=u[n],(i=parseInt(c[0],10))<e.columns){switch(e.sortVars[i].order||(f=r.getOrder(e.sortInitialOrder)?e.sortReset?[1,0,2]:[1,0]:e.sortReset?[0,1,2]:[0,1],e.sortVars[i].order=f,e.sortVars[i].count=0),f=e.sortVars[i].order,s=(""+c[1]).match(/^(1|d|s|o|n)/),s=s?s[0]:""){case"1":case"d":s=1;break;case"s":s=l||0;break;case"o":s=0===(d=f[(l||0)%f.length])?1:1===d?0:2;break;case"n":s=f[++e.sortVars[i].count%f.length];break;default:s=0}l=0===n?s:l,o=[i,parseInt(s,10)||0],e.sortList[e.sortList.length]=o,s=t.inArray(o[1],f),e.sortVars[i].count=s>=0?s:o[1]%f.length}},updateAll:function(e,t,a){var i=e.table;i.isUpdating=!0,r.refreshWidgets(i,!0,!0),r.buildHeaders(e),r.bindEvents(i,e.$headers,!0),r.bindMethods(e),r.commonUpdate(e,t,a)},update:function(e,t,a){e.table.isUpdating=!0,r.updateHeader(e),r.commonUpdate(e,t,a)},updateHeaders:function(e,t){e.table.isUpdating=!0,r.buildHeaders(e),r.bindEvents(e.table,e.$headers,!0),r.resortComplete(e,t)},updateCell:function(e,a,i,s){if(t(a).closest("tr").hasClass(e.cssChildRow))console.warn('Tablesorter Warning! "updateCell" for child row content has been disabled, use "update" instead');else{if(r.isEmptyObject(e.cache))return r.updateHeader(e),void r.commonUpdate(e,i,s);e.table.isUpdating=!0,e.$table.find(e.selectorRemove).remove();var o,n,l,d,c,f,u=e.$tbodies,g=t(a),p=u.index(r.getClosest(g,"tbody")),h=e.cache[p],m=r.getClosest(g,"tr");if(a=g[0],u.length&&p>=0){if(l=u.eq(p).find("tr").not("."+e.cssChildRow).index(m),c=h.normalized[l],(f=m[0].cells.length)!==e.columns)for(d=0,o=!1,n=0;n<f;n++)o||m[0].cells[n]===a?o=!0:d+=m[0].cells[n].colSpan;else d=g.index();o=r.getElementText(e,a,d),c[e.columns].raw[d]=o,o=r.getParsedText(e,a,d,o),c[d]=o,"numeric"===(e.parsers[d].type||"").toLowerCase()&&(h.colMax[d]=Math.max(Math.abs(o)||0,h.colMax[d]||0)),!1!==(o="undefined"!==i?i:e.resort)?r.checkResort(e,o,s):r.resortComplete(e,s)}else e.debug&&console.error("updateCell aborted, tbody missing or not within the indicated table"),e.table.isUpdating=!1}},addRows:function(a,i,s,o){var n,l,d,c,f,u,g,p,h,m,b,y,v,w="string"==typeof i&&1===a.$tbodies.length&&/<tr/.test(i||""),x=a.table;if(w)i=t(i),a.$tbodies.append(i);else if(!(i&&i instanceof e&&r.getClosest(i,"table")[0]===a.table))return a.debug&&console.error("addRows method requires (1) a jQuery selector reference to rows that have already been added to the table, or (2) row HTML string to be added to a table with only one tbody"),!1;if(x.isUpdating=!0,r.isEmptyObject(a.cache))r.updateHeader(a),r.commonUpdate(a,s,o);else{for(f=i.filter("tr").attr("role","row").length,d=a.$tbodies.index(i.parents("tbody").filter(":first")),a.parsers&&a.parsers.length||r.setupParsers(a),c=0;c<f;c++){for(h=0,g=i[c].cells.length,p=a.cache[d].normalized.length,b=[],m={child:[],raw:[],$row:i.eq(c),order:p},u=0;u<g;u++)y=i[c].cells[u],n=r.getElementText(a,y,h),m.raw[h]=n,l=r.getParsedText(a,y,h,n),b[h]=l,"numeric"===(a.parsers[h].type||"").toLowerCase()&&(a.cache[d].colMax[h]=Math.max(Math.abs(l)||0,a.cache[d].colMax[h]||0)),(v=y.colSpan-1)>0&&(h+=v),h++;b[a.columns]=m,a.cache[d].normalized[p]=b}r.checkResort(a,s,o)}},updateCache:function(e,t,a){e.parsers&&e.parsers.length||r.setupParsers(e,a),r.buildCache(e,t,a)},appendCache:function(e,t){var a,i,s,o,n,l,d,c=e.table,f=e.widgetOptions,u=e.$tbodies,g=[],p=e.cache;if(r.isEmptyObject(p))return e.appender?e.appender(c,g):c.isUpdating?e.$table.triggerHandler("updateComplete",c):"";for(e.debug&&(d=new Date),l=0;l<u.length;l++)if((s=u.eq(l)).length){for(o=r.processTbody(c,s,!0),i=(a=p[l].normalized).length,n=0;n<i;n++)g[g.length]=a[n][e.columns].$row,e.appender&&(!e.pager||e.pager.removeRows&&f.pager_removeRows||e.pager.ajax)||o.append(a[n][e.columns].$row);r.processTbody(c,o,!1)}e.appender&&e.appender(c,g),e.debug&&console.log("Rebuilt table"+r.benchmark(d)),t||e.appender||r.applyWidget(c),c.isUpdating&&e.$table.triggerHandler("updateComplete",c)},commonUpdate:function(e,t,a){e.$table.find(e.selectorRemove).remove(),r.setupParsers(e),r.buildCache(e),r.checkResort(e,t,a)},initSort:function(e,a,i){if(e.table.isUpdating)return setTimeout(function(){r.initSort(e,a,i)},50);var s,o,n,l,d,c,f,u=!i[e.sortMultiSortKey],g=e.table,p=e.$headers.length,h=r.getClosest(t(a),"th, td"),m=parseInt(h.attr("data-column"),10),b=e.sortVars[m].order;if(h=h[0],e.$table.triggerHandler("sortStart",g),c=(e.sortVars[m].count+1)%b.length,e.sortVars[m].count=i[e.sortResetKey]?2:c,e.sortRestart)for(n=0;n<p;n++)f=e.$headers.eq(n),m!==(c=parseInt(f.attr("data-column"),10))&&(u||f.hasClass(r.css.sortNone))&&(e.sortVars[c].count=-1);if(u){if(e.sortList=[],e.last.sortList=[],null!==e.sortForce)for(s=e.sortForce,o=0;o<s.length;o++)s[o][0]!==m&&(e.sortList[e.sortList.length]=s[o]);if((l=b[e.sortVars[m].count])<2&&(e.sortList[e.sortList.length]=[m,l],h.colSpan>1))for(o=1;o<h.colSpan;o++)e.sortList[e.sortList.length]=[m+o,l],e.sortVars[m+o].count=t.inArray(l,b)}else if(e.sortList=t.extend([],e.last.sortList),r.isValueInArray(m,e.sortList)>=0)for(o=0;o<e.sortList.length;o++)(c=e.sortList[o])[0]===m&&(c[1]=b[e.sortVars[m].count],2===c[1]&&(e.sortList.splice(o,1),e.sortVars[m].count=-1));else if((l=b[e.sortVars[m].count])<2&&(e.sortList[e.sortList.length]=[m,l],h.colSpan>1))for(o=1;o<h.colSpan;o++)e.sortList[e.sortList.length]=[m+o,l],e.sortVars[m+o].count=t.inArray(l,b);if(e.last.sortList=t.extend([],e.sortList),e.sortList.length&&e.sortAppend&&(s=t.isArray(e.sortAppend)?e.sortAppend:e.sortAppend[e.sortList[0][0]],!r.isEmptyObject(s)))for(o=0;o<s.length;o++)if(s[o][0]!==m&&r.isValueInArray(s[o][0],e.sortList)<0){if(l=s[o][1],d=(""+l).match(/^(a|d|s|o|n)/))switch(c=e.sortList[0][1],d[0]){case"d":l=1;break;case"s":l=c;break;case"o":l=0===c?1:0;break;case"n":l=(c+1)%b.length;break;default:l=0}e.sortList[e.sortList.length]=[s[o][0],l]}e.$table.triggerHandler("sortBegin",g),setTimeout(function(){r.setHeadersCss(e),r.multisort(e),r.appendCache(e),e.$table.triggerHandler("sortBeforeEnd",g),e.$table.triggerHandler("sortEnd",g)},1)},multisort:function(e){var t,a,i,s,o=e.table,n=[],l=0,d=e.textSorter||"",c=e.sortList,f=c.length,u=e.$tbodies.length;if(!e.serverSideSorting&&!r.isEmptyObject(e.cache)){if(e.debug&&(a=new Date),"object"==typeof d)for(i=e.columns;i--;)"function"==typeof(s=r.getColumnData(o,d,i))&&(n[i]=s);for(t=0;t<u;t++)i=e.cache[t].colMax,e.cache[t].normalized.sort(function(t,a){var s,u,g,p,h,m,b;for(s=0;s<f;s++){if(g=c[s][0],p=c[s][1],l=0===p,e.sortStable&&t[g]===a[g]&&1===f)return t[e.columns].order-a[e.columns].order;if((u=/n/i.test(r.getSortType(e.parsers,g)))&&e.strings[g]?(u="boolean"==typeof r.string[e.strings[g]]?(l?1:-1)*(r.string[e.strings[g]]?-1:1):e.strings[g]?r.string[e.strings[g]]||0:0,h=e.numberSorter?e.numberSorter(t[g],a[g],l,i[g],o):r["sortNumeric"+(l?"Asc":"Desc")](t[g],a[g],u,i[g],g,e)):(m=l?t:a,b=l?a:t,h="function"==typeof d?d(m[g],b[g],l,g,o):"function"==typeof n[g]?n[g](m[g],b[g],l,g,o):r["sortNatural"+(l?"Asc":"Desc")](t[g],a[g],g,e)),h)return h}return t[e.columns].order-a[e.columns].order});e.debug&&console.log("Applying sort "+c.toString()+r.benchmark(a))}},resortComplete:function(e,r){e.table.isUpdating&&e.$table.triggerHandler("updateComplete",e.table),t.isFunction(r)&&r(e.table)},checkResort:function(e,a,i){var s=t.isArray(a)?a:e.sortList;!1===(void 0===a?e.resort:a)||e.serverSideSorting||e.table.isProcessing?(r.resortComplete(e,i),r.applyWidget(e.table,!1)):s.length?r.sortOn(e,s,function(){r.resortComplete(e,i)},!0):r.sortReset(e,function(){r.resortComplete(e,i),r.applyWidget(e.table,!1)})},sortOn:function(e,a,i,s){var o=e.table;e.$table.triggerHandler("sortStart",o),r.updateHeaderSortCount(e,a),r.setHeadersCss(e),e.delayInit&&r.isEmptyObject(e.cache)&&r.buildCache(e),e.$table.triggerHandler("sortBegin",o),r.multisort(e),r.appendCache(e,s),e.$table.triggerHandler("sortBeforeEnd",o),e.$table.triggerHandler("sortEnd",o),r.applyWidget(o),t.isFunction(i)&&i(o)},sortReset:function(e,a){e.sortList=[],r.setHeadersCss(e),r.multisort(e),r.appendCache(e);var i;for(i=0;i<e.columns;i++)e.sortVars[i].count=-1;t.isFunction(a)&&a(e.table)},getSortType:function(e,t){return e&&e[t]?e[t].type||"":""},getOrder:function(e){return/^d/i.test(e)||1===e},sortNatural:function(e,t){if(e===t)return 0;e=e.toString(),t=t.toString();var a,i,s,o,n,l,d=r.regex;if(d.hex.test(t)){if(a=parseInt((e||"").match(d.hex),16),i=parseInt((t||"").match(d.hex),16),a<i)return-1;if(a>i)return 1}for(a=(e||"").replace(d.chunk,"\\0$1\\0").replace(d.chunks,"").split("\\0"),i=(t||"").replace(d.chunk,"\\0$1\\0").replace(d.chunks,"").split("\\0"),l=Math.max(a.length,i.length),n=0;n<l;n++){if(s=isNaN(a[n])?a[n]||0:parseFloat(a[n])||0,o=isNaN(i[n])?i[n]||0:parseFloat(i[n])||0,isNaN(s)!==isNaN(o))return isNaN(s)?1:-1;if(typeof s!=typeof o&&(s+="",o+=""),s<o)return-1;if(s>o)return 1}return 0},sortNaturalAsc:function(e,t,a,i){if(e===t)return 0;var s=r.string[i.empties[a]||i.emptyTo];return""===e&&0!==s?"boolean"==typeof s?s?-1:1:-s||-1:""===t&&0!==s?"boolean"==typeof s?s?1:-1:s||1:r.sortNatural(e,t)},sortNaturalDesc:function(e,t,a,i){if(e===t)return 0;var s=r.string[i.empties[a]||i.emptyTo];return""===e&&0!==s?"boolean"==typeof s?s?-1:1:s||1:""===t&&0!==s?"boolean"==typeof s?s?1:-1:-s||-1:r.sortNatural(t,e)},sortText:function(e,t){return e>t?1:e<t?-1:0},getTextValue:function(e,t,r){if(r){var a,i=e?e.length:0,s=r+t;for(a=0;a<i;a++)s+=e.charCodeAt(a);return t*s}return 0},sortNumericAsc:function(e,t,a,i,s,o){if(e===t)return 0;var n=r.string[o.empties[s]||o.emptyTo];return""===e&&0!==n?"boolean"==typeof n?n?-1:1:-n||-1:""===t&&0!==n?"boolean"==typeof n?n?1:-1:n||1:(isNaN(e)&&(e=r.getTextValue(e,a,i)),isNaN(t)&&(t=r.getTextValue(t,a,i)),e-t)},sortNumericDesc:function(e,t,a,i,s,o){if(e===t)return 0;var n=r.string[o.empties[s]||o.emptyTo];return""===e&&0!==n?"boolean"==typeof n?n?-1:1:n||1:""===t&&0!==n?"boolean"==typeof n?n?1:-1:-n||-1:(isNaN(e)&&(e=r.getTextValue(e,a,i)),isNaN(t)&&(t=r.getTextValue(t,a,i)),t-e)},sortNumeric:function(e,t){return e-t},addWidget:function(e){e.id&&!r.isEmptyObject(r.getWidgetById(e.id))&&console.warn('"'+e.id+'" widget was loaded more than once!'),r.widgets[r.widgets.length]=e},hasWidget:function(e,r){return(e=t(e)).length&&e[0].config&&e[0].config.widgetInit[r]||!1},getWidgetById:function(e){var t,a,i=r.widgets.length;for(t=0;t<i;t++)if((a=r.widgets[t])&&a.id&&a.id.toLowerCase()===e.toLowerCase())return a},applyWidgetOptions:function(e){var a,i,s,o=e.config,n=o.widgets.length;if(n)for(a=0;a<n;a++)(i=r.getWidgetById(o.widgets[a]))&&i.options&&(s=t.extend(!0,{},i.options),o.widgetOptions=t.extend(!0,s,o.widgetOptions),t.extend(!0,r.defaults.widgetOptions,i.options))},addWidgetFromClass:function(e){var t,a,i=e.config,s="^"+i.widgetClass.replace(r.regex.templateName,"(\\S+)+")+"$",o=new RegExp(s,"g"),n=(e.className||"").split(r.regex.spaces);if(n.length)for(t=n.length,a=0;a<t;a++)n[a].match(o)&&(i.widgets[i.widgets.length]=n[a].replace(o,"$1"))},applyWidgetId:function(e,a,i){var s,o,n,l=(e=t(e)[0]).config,d=l.widgetOptions,c=r.getWidgetById(a);c&&(n=c.id,s=!1,t.inArray(n,l.widgets)<0&&(l.widgets[l.widgets.length]=n),l.debug&&(o=new Date),!i&&l.widgetInit[n]||(l.widgetInit[n]=!0,e.hasInitialized&&r.applyWidgetOptions(e),"function"==typeof c.init&&(s=!0,l.debug&&console[console.group?"group":"log"]("Initializing "+n+" widget"),c.init(e,c,l,d))),i||"function"!=typeof c.format||(s=!0,l.debug&&console[console.group?"group":"log"]("Updating "+n+" widget"),c.format(e,l,d,!1)),l.debug&&s&&(console.log("Completed "+(i?"initializing ":"applying ")+n+" widget"+r.benchmark(o)),console.groupEnd&&console.groupEnd()))},applyWidget:function(e,a,i){var s,o,n,l,d,c=(e=t(e)[0]).config,f=[];if(!1===a||!e.hasInitialized||!e.isApplyingWidgets&&!e.isUpdating){if(c.debug&&(d=new Date),r.addWidgetFromClass(e),clearTimeout(c.timerReady),c.widgets.length){for(e.isApplyingWidgets=!0,c.widgets=t.grep(c.widgets,function(e,r){return t.inArray(e,c.widgets)===r}),o=(n=c.widgets||[]).length,s=0;s<o;s++)(l=r.getWidgetById(n[s]))&&l.id?(l.priority||(l.priority=10),f[s]=l):c.debug&&console.warn('"'+n[s]+'" was enabled, but the widget code has not been loaded!');for(f.sort(function(e,t){return e.priority<t.priority?-1:e.priority===t.priority?0:1}),o=f.length,c.debug&&console[console.group?"group":"log"]("Start "+(a?"initializing":"applying")+" widgets"),s=0;s<o;s++)(l=f[s])&&l.id&&r.applyWidgetId(e,l.id,a);c.debug&&console.groupEnd&&console.groupEnd()}c.timerReady=setTimeout(function(){e.isApplyingWidgets=!1,t.data(e,"lastWidgetApplication",new Date),c.$table.triggerHandler("tablesorter-ready"),a||"function"!=typeof i||i(e),c.debug&&(l=c.widgets.length,console.log("Completed "+(!0===a?"initializing ":"applying ")+l+" widget"+(1!==l?"s":"")+r.benchmark(d)))},10)}},removeWidget:function(e,a,i){var s,o,n,l,d=(e=t(e)[0]).config;if(!0===a)for(a=[],l=r.widgets.length,n=0;n<l;n++)(o=r.widgets[n])&&o.id&&(a[a.length]=o.id);else a=(t.isArray(a)?a.join(","):a||"").toLowerCase().split(/[\s,]+/);for(l=a.length,s=0;s<l;s++)o=r.getWidgetById(a[s]),(n=t.inArray(a[s],d.widgets))>=0&&!0!==i&&d.widgets.splice(n,1),o&&o.remove&&(d.debug&&console.log((i?"Refreshing":"Removing")+' "'+a[s]+'" widget'),o.remove(e,d,d.widgetOptions,i),d.widgetInit[a[s]]=!1);d.$table.triggerHandler("widgetRemoveEnd",e)},refreshWidgets:function(e,a,i){var s,o,n=(e=t(e)[0]).config.widgets,l=r.widgets,d=l.length,c=[],f=function(e){t(e).triggerHandler("refreshComplete")};for(s=0;s<d;s++)(o=l[s])&&o.id&&(a||t.inArray(o.id,n)<0)&&(c[c.length]=o.id);r.removeWidget(e,c.join(","),!0),!0!==i?(r.applyWidget(e,a||!1,f),a&&r.applyWidget(e,!1,f)):f(e)},benchmark:function(e){return" ("+((new Date).getTime()-e.getTime())+" ms)"},log:function(){console.log(arguments)},isEmptyObject:function(e){for(var t in e)return!1;return!0},isValueInArray:function(e,t){var r,a=t&&t.length||0;for(r=0;r<a;r++)if(t[r][0]===e)return r;return-1},formatFloat:function(e,a){if("string"!=typeof e||""===e)return e;var i;return e=(a&&a.config?!1!==a.config.usNumberFormat:void 0===a||a)?e.replace(r.regex.comma,""):e.replace(r.regex.digitNonUS,"").replace(r.regex.comma,"."),r.regex.digitNegativeTest.test(e)&&(e=e.replace(r.regex.digitNegativeReplace,"-$1")),i=parseFloat(e),isNaN(i)?t.trim(e):i},isDigit:function(e){return isNaN(e)?r.regex.digitTest.test(e.toString().replace(r.regex.digitReplace,"")):""!==e},computeColumnIndex:function(e,a){var i,s,o,n,l,d,c,f,u,g,p=a&&a.columns||0,h=[],m=new Array(p);for(i=0;i<e.length;i++)for(d=e[i].cells,s=0;s<d.length;s++){for(c=i,f=(l=d[s]).rowSpan||1,u=l.colSpan||1,void 0===h[c]&&(h[c]=[]),o=0;o<h[c].length+1;o++)if(void 0===h[c][o]){g=o;break}for(p&&l.cellIndex===g||(l.setAttribute?l.setAttribute("data-column",g):t(l).attr("data-column",g)),o=c;o<c+f;o++)for(void 0===h[o]&&(h[o]=[]),m=h[o],n=g;n<g+u;n++)m[n]="x"}return r.checkColumnCount(e,h,m.length),m.length},checkColumnCount:function(e,t,r){var a,i,s=!0,o=[];for(a=0;a<t.length;a++)if(t[a]&&(i=t[a].length,t[a].length!==r)){s=!1;break}s||(e.each(function(e,t){var r=t.parentElement.nodeName;o.indexOf(r)<0&&o.push(r)}),console.error("Invalid or incorrect number of columns in the "+o.join(" or ")+"; expected "+r+", but found "+i+" columns"))},fixColumnWidth:function(e){var a,i,s,o,n,l=(e=t(e)[0]).config,d=l.$table.children("colgroup");if(d.length&&d.hasClass(r.css.colgroup)&&d.remove(),l.widthFixed&&0===l.$table.children("colgroup").length){for(d=t('<colgroup class="'+r.css.colgroup+'">'),a=l.$table.width(),o=(s=l.$tbodies.find("tr:first").children(":visible")).length,n=0;n<o;n++)i=parseInt(s.eq(n).width()/a*1e3,10)/10+"%",d.append(t("<col>").css("width",i));l.$table.prepend(d)}},getData:function(e,r,a){var i,s,o="",n=t(e);return n.length?(i=!!t.metadata&&n.metadata(),s=" "+(n.attr("class")||""),void 0!==n.data(a)||void 0!==n.data(a.toLowerCase())?o+=n.data(a)||n.data(a.toLowerCase()):i&&void 0!==i[a]?o+=i[a]:r&&void 0!==r[a]?o+=r[a]:" "!==s&&s.match(" "+a+"-")&&(o=s.match(new RegExp("\\s"+a+"-([\\w-]+)"))[1]||""),t.trim(o)):""},getColumnData:function(e,r,a,i,s){if("object"!=typeof r||null===r)return r;var o,n=(e=t(e)[0]).config,l=s||n.$headers,d=n.$headerIndexed&&n.$headerIndexed[a]||l.find('[data-column="'+a+'"]:last');if(void 0!==r[a])return i?r[a]:r[l.index(d)];for(o in r)if("string"==typeof o&&d.filter(o).add(d.find(o)).length)return r[o]},isProcessing:function(e,a,i){var s=(e=t(e))[0].config,o=i||e.find("."+r.css.header);a?(void 0!==i&&s.sortList.length>0&&(o=o.filter(function(){return!this.sortDisabled&&r.isValueInArray(parseFloat(t(this).attr("data-column")),s.sortList)>=0})),e.add(o).addClass(r.css.processing+" "+s.cssProcessing)):e.add(o).removeClass(r.css.processing+" "+s.cssProcessing)},processTbody:function(e,r,a){if(e=t(e)[0],a)return e.isProcessing=!0,r.before('<colgroup class="tablesorter-savemyplace"/>'),t.fn.detach?r.detach():r.remove();var i=t(e).find("colgroup.tablesorter-savemyplace");r.insertAfter(i),i.remove(),e.isProcessing=!1},clearTableBody:function(e){t(e)[0].config.$tbodies.children().detach()},characterEquivalents:{a:"áàâãäąå",A:"ÁÀÂÃÄĄÅ",c:"çćč",C:"ÇĆČ",e:"éèêëěę",E:"ÉÈÊËĚĘ",i:"íìİîïı",I:"ÍÌİÎÏ",o:"óòôõöō",O:"ÓÒÔÕÖŌ",ss:"ß",SS:"ẞ",u:"úùûüů",U:"ÚÙÛÜŮ"},replaceAccents:function(e){var t,a="[",i=r.characterEquivalents;if(!r.characterRegex){r.characterRegexArray={};for(t in i)"string"==typeof t&&(a+=i[t],r.characterRegexArray[t]=new RegExp("["+i[t]+"]","g"));r.characterRegex=new RegExp(a+"]")}if(r.characterRegex.test(e))for(t in i)"string"==typeof t&&(e=e.replace(r.characterRegexArray[t],t));return e},validateOptions:function(e){var a,i,s,o,n="headers sortForce sortList sortAppend widgets".split(" "),l=e.originalSettings;if(l){e.debug&&(o=new Date);for(a in l)if("undefined"==(s=typeof r.defaults[a]))console.warn('Tablesorter Warning! "table.config.'+a+'" option not recognized');else if("object"===s)for(i in l[a])s=r.defaults[a]&&typeof r.defaults[a][i],t.inArray(a,n)<0&&"undefined"===s&&console.warn('Tablesorter Warning! "table.config.'+a+"."+i+'" option not recognized');e.debug&&console.log("validate options time:"+r.benchmark(o))}},restoreHeaders:function(e){var a,i,s=t(e)[0].config,o=s.$table.find(s.selectorHeaders),n=o.length;for(a=0;a<n;a++)(i=o.eq(a)).find("."+r.css.headerIn).length&&i.html(s.headerContent[a])},destroy:function(e,a,i){if((e=t(e)[0]).hasInitialized){r.removeWidget(e,!0,!1);var s,o=t(e),n=e.config,l=n.debug,d=o.find("thead:first"),c=d.find("tr."+r.css.headerRow).removeClass(r.css.headerRow+" "+n.cssHeaderRow),f=o.find("tfoot:first > tr").children("th, td");!1===a&&t.inArray("uitheme",n.widgets)>=0&&(o.triggerHandler("applyWidgetId",["uitheme"]),o.triggerHandler("applyWidgetId",["zebra"])),d.find("tr").not(c).remove(),s="sortReset update updateRows updateAll updateHeaders updateCell addRows updateComplete sorton appendCache updateCache applyWidgetId applyWidgets refreshWidgets removeWidget destroy mouseup mouseleave "+"keypress sortBegin sortEnd resetToLoadState ".split(" ").join(n.namespace+" "),o.removeData("tablesorter").unbind(s.replace(r.regex.spaces," ")),n.$headers.add(f).removeClass([r.css.header,n.cssHeader,n.cssAsc,n.cssDesc,r.css.sortAsc,r.css.sortDesc,r.css.sortNone].join(" ")).removeAttr("data-column").removeAttr("aria-label").attr("aria-disabled","true"),c.find(n.selectorSort).unbind("mousedown mouseup keypress ".split(" ").join(n.namespace+" ").replace(r.regex.spaces," ")),r.restoreHeaders(e),o.toggleClass(r.css.table+" "+n.tableClass+" tablesorter-"+n.theme,!1===a),o.removeClass(n.namespace.slice(1)),e.hasInitialized=!1,delete e.config.cache,"function"==typeof i&&i(e),l&&console.log("tablesorter has been removed")}}};t.fn.tablesorter=function(e){return this.each(function(){var a=this,i=t.extend(!0,{},r.defaults,e,r.instanceMethods);i.originalSettings=e,!a.hasInitialized&&r.buildTable&&"TABLE"!==this.nodeName?r.buildTable(a,i):r.setup(a,i)})},window.console&&window.console.log||(r.logs=[],console={},console.log=console.warn=console.error=console.table=function(){var e=arguments.length>1?arguments:arguments[0];r.logs[r.logs.length]={date:Date.now(),log:e}}),r.addParser({id:"no-parser",is:function(){return!1},format:function(){return""},type:"text"}),r.addParser({id:"text",is:function(){return!0},format:function(e,a){var i=a.config;return e&&(e=t.trim(i.ignoreCase?e.toLocaleLowerCase():e),e=i.sortLocaleCompare?r.replaceAccents(e):e),e},type:"text"}),r.regex.nondigit=/[^\w,. \-()]/g,r.addParser({id:"digit",is:function(e){return r.isDigit(e)},format:function(e,a){var i=r.formatFloat((e||"").replace(r.regex.nondigit,""),a);return e&&"number"==typeof i?i:e?t.trim(e&&a.config.ignoreCase?e.toLocaleLowerCase():e):e},type:"numeric"}),r.regex.currencyReplace=/[+\-,. ]/g,r.regex.currencyTest=/^\(?\d+[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]|[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]\d+\)?$/,r.addParser({id:"currency",is:function(e){return e=(e||"").replace(r.regex.currencyReplace,""),r.regex.currencyTest.test(e)},format:function(e,a){var i=r.formatFloat((e||"").replace(r.regex.nondigit,""),a);return e&&"number"==typeof i?i:e?t.trim(e&&a.config.ignoreCase?e.toLocaleLowerCase():e):e},type:"numeric"}),r.regex.urlProtocolTest=/^(https?|ftp|file):\/\//,r.regex.urlProtocolReplace=/(https?|ftp|file):\/\/(www\.)?/,r.addParser({id:"url",is:function(e){return r.regex.urlProtocolTest.test(e)},format:function(e){return e?t.trim(e.replace(r.regex.urlProtocolReplace,"")):e},type:"text"}),r.regex.dash=/-/g,r.regex.isoDate=/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}/,r.addParser({id:"isoDate",is:function(e){return r.regex.isoDate.test(e)},format:function(e,t){var a=e?new Date(e.replace(r.regex.dash,"/")):e;return a instanceof Date&&isFinite(a)?a.getTime():e},type:"numeric"}),r.regex.percent=/%/g,r.regex.percentTest=/(\d\s*?%|%\s*?\d)/,r.addParser({id:"percent",is:function(e){return r.regex.percentTest.test(e)&&e.length<15},format:function(e,t){return e?r.formatFloat(e.replace(r.regex.percent,""),t):e},type:"numeric"}),r.addParser({id:"image",is:function(e,t,r,a){return a.find("img").length>0},format:function(e,r,a){return t(a).find("img").attr(r.config.imgAttr||"alt")||e},parsed:!0,type:"text"}),r.regex.dateReplace=/(\S)([AP]M)$/i,r.regex.usLongDateTest1=/^[A-Z]{3,10}\.?\s+\d{1,2},?\s+(\d{4})(\s+\d{1,2}:\d{2}(:\d{2})?(\s+[AP]M)?)?$/i,r.regex.usLongDateTest2=/^\d{1,2}\s+[A-Z]{3,10}\s+\d{4}/i,r.addParser({id:"usLongDate",is:function(e){return r.regex.usLongDateTest1.test(e)||r.regex.usLongDateTest2.test(e)},format:function(e,t){var a=e?new Date(e.replace(r.regex.dateReplace,"$1 $2")):e;return a instanceof Date&&isFinite(a)?a.getTime():e},type:"numeric"}),r.regex.shortDateTest=/(^\d{1,2}[\/\s]\d{1,2}[\/\s]\d{4})|(^\d{4}[\/\s]\d{1,2}[\/\s]\d{1,2})/,r.regex.shortDateReplace=/[\-.,]/g,r.regex.shortDateXXY=/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,r.regex.shortDateYMD=/(\d{4})[\/\s](\d{1,2})[\/\s](\d{1,2})/,r.convertFormat=function(e,t){e=(e||"").replace(r.regex.spaces," ").replace(r.regex.shortDateReplace,"/"),"mmddyyyy"===t?e=e.replace(r.regex.shortDateXXY,"$3/$1/$2"):"ddmmyyyy"===t?e=e.replace(r.regex.shortDateXXY,"$3/$2/$1"):"yyyymmdd"===t&&(e=e.replace(r.regex.shortDateYMD,"$1/$2/$3"));var a=new Date(e);return a instanceof Date&&isFinite(a)?a.getTime():""},r.addParser({id:"shortDate",is:function(e){return e=(e||"").replace(r.regex.spaces," ").replace(r.regex.shortDateReplace,"/"),r.regex.shortDateTest.test(e)},format:function(e,t,a,i){if(e){var s=t.config,o=s.$headerIndexed[i],n=o.length&&o.data("dateFormat")||r.getData(o,r.getColumnData(t,s.headers,i),"dateFormat")||s.dateFormat;return o.length&&o.data("dateFormat",n),r.convertFormat(e,n)||e}return e},type:"numeric"}),r.regex.timeTest=/^(0?[1-9]|1[0-2]):([0-5]\d)(\s[AP]M)$|^((?:[01]\d|[2][0-4]):[0-5]\d)$/i,r.regex.timeMatch=/(0?[1-9]|1[0-2]):([0-5]\d)(\s[AP]M)|((?:[01]\d|[2][0-4]):[0-5]\d)/i,r.addParser({id:"time",is:function(e){return r.regex.timeTest.test(e)},format:function(e,t){var a=(e||"").match(r.regex.timeMatch),i=new Date(e),s=e&&(null!==a?a[0]:"00:00 AM"),o=s?new Date("2000/01/01 "+s.replace(r.regex.dateReplace,"$1 $2")):s;return o instanceof Date&&isFinite(o)?(i instanceof Date&&isFinite(i)?i.getTime():0)?parseFloat(o.getTime()+"."+i.getTime()):o.getTime():e},type:"numeric"}),r.addParser({id:"metadata",is:function(){return!1},format:function(e,r,a){var i=r.config,s=i.parserMetadataName?i.parserMetadataName:"sortValue";return t(a).metadata()[s]},type:"numeric"}),r.addWidget({id:"zebra",priority:90,format:function(e,r,a){var i,s,o,n,l,d,c,f=new RegExp(r.cssChildRow,"i"),u=r.$tbodies.add(t(r.namespace+"_extra_table").children("tbody:not(."+r.cssInfoBlock+")"));for(l=0;l<u.length;l++)for(o=0,c=(i=u.eq(l).children("tr:visible").not(r.selectorRemove)).length,d=0;d<c;d++)s=i.eq(d),f.test(s[0].className)||o++,n=o%2==0,s.removeClass(a.zebra[n?1:0]).addClass(a.zebra[n?0:1])},remove:function(e,t,a,i){if(!i){var s,o,n=t.$tbodies,l=(a.zebra||["even","odd"]).join(" ");for(s=0;s<n.length;s++)(o=r.processTbody(e,n.eq(s),!0)).children().removeClass(l),r.processTbody(e,o,!1)}}})}(e),function(e,t,r){"use strict";var a=e.tablesorter||{};e.extend(!0,a.defaults,{fixedUrl:"",widgetOptions:{storage_fixedUrl:"",storage_group:"",storage_page:"",storage_storageType:"",storage_tableId:"",storage_useSessionStorage:""}}),a.storage=function(a,i,s,o){var n,l,d,c=!1,f={},u=(a=e(a)[0]).config,g=u&&u.widgetOptions,p=(o&&o.storageType||g&&g.storage_storageType).toString().charAt(0).toLowerCase(),h=p?"":o&&o.useSessionStorage||g&&g.storage_useSessionStorage,m=e(a),b=o&&o.id||m.attr(o&&o.group||g&&g.storage_group||"data-table-group")||g&&g.storage_tableId||a.id||e(".tablesorter").index(m),y=o&&o.url||m.attr(o&&o.page||g&&g.storage_page||"data-table-page")||g&&g.storage_fixedUrl||u&&u.fixedUrl||t.location.pathname;if("c"!==p&&(p="s"===p||h?"sessionStorage":"localStorage")in t)try{t[p].setItem("_tmptest","temp"),c=!0,t[p].removeItem("_tmptest")}catch(e){u&&u.debug&&console.warn(p+" is not supported in this browser")}if(u.debug&&console.log("Storage widget using",c?p:"cookies"),e.parseJSON&&(c?f=e.parseJSON(t[p][i]||"null")||{}:(l=r.cookie.split(/[;\s|=]/),f=0!==(n=e.inArray(i,l)+1)?e.parseJSON(l[n]||"null")||{}:{})),void 0===s||!t.JSON||!JSON.hasOwnProperty("stringify"))return f&&f[y]?f[y][b]:"";f[y]||(f[y]={}),f[y][b]=s,c?t[p][i]=JSON.stringify(f):((d=new Date).setTime(d.getTime()+31536e6),r.cookie=i+"="+JSON.stringify(f).replace(/\"/g,'"')+"; expires="+d.toGMTString()+"; path=/")}}(e,window,document),function(e){"use strict";var t=e.tablesorter||{};t.themes={bootstrap:{table:"table table-bordered table-striped",caption:"caption",header:"bootstrap-header",sortNone:"",sortAsc:"",sortDesc:"",active:"",hover:"",icons:"",iconSortNone:"bootstrap-icon-unsorted",iconSortAsc:"glyphicon glyphicon-chevron-up",iconSortDesc:"glyphicon glyphicon-chevron-down",filterRow:"",footerRow:"",footerCells:"",even:"",odd:""},jui:{table:"ui-widget ui-widget-content ui-corner-all",caption:"ui-widget-content",header:"ui-widget-header ui-corner-all ui-state-default",sortNone:"",sortAsc:"",sortDesc:"",active:"ui-state-active",hover:"ui-state-hover",icons:"ui-icon",iconSortNone:"ui-icon-carat-2-n-s ui-icon-caret-2-n-s",iconSortAsc:"ui-icon-carat-1-n ui-icon-caret-1-n",iconSortDesc:"ui-icon-carat-1-s ui-icon-caret-1-s",filterRow:"",footerRow:"",footerCells:"",even:"ui-widget-content",odd:"ui-state-default"}},e.extend(t.css,{wrapper:"tablesorter-wrapper"}),t.addWidget({id:"uitheme",priority:10,format:function(r,a,i){var s,o,n,l,d,c,f,u,g,p,h,m,b,y=t.themes,v=a.$table.add(e(a.namespace+"_extra_table")),w=a.$headers.add(e(a.namespace+"_extra_headers")),x=a.theme||"jui",C=y[x]||{},_=e.trim([C.sortNone,C.sortDesc,C.sortAsc,C.active].join(" ")),$=e.trim([C.iconSortNone,C.iconSortDesc,C.iconSortAsc].join(" "));for(a.debug&&(d=new Date),v.hasClass("tablesorter-"+x)&&a.theme===a.appliedTheme&&i.uitheme_applied||(i.uitheme_applied=!0,p=y[a.appliedTheme]||{},h=(b=!e.isEmptyObject(p))?[p.sortNone,p.sortDesc,p.sortAsc,p.active].join(" "):"",m=b?[p.iconSortNone,p.iconSortDesc,p.iconSortAsc].join(" "):"",b&&(i.zebra[0]=e.trim(" "+i.zebra[0].replace(" "+p.even,"")),i.zebra[1]=e.trim(" "+i.zebra[1].replace(" "+p.odd,"")),a.$tbodies.children().removeClass([p.even,p.odd].join(" "))),C.even&&(i.zebra[0]+=" "+C.even),C.odd&&(i.zebra[1]+=" "+C.odd),v.children("caption").removeClass(p.caption||"").addClass(C.caption),u=v.removeClass((a.appliedTheme?"tablesorter-"+(a.appliedTheme||""):"")+" "+(p.table||"")).addClass("tablesorter-"+x+" "+(C.table||"")).children("tfoot"),a.appliedTheme=a.theme,u.length&&u.children("tr").removeClass(p.footerRow||"").addClass(C.footerRow).children("th, td").removeClass(p.footerCells||"").addClass(C.footerCells),w.removeClass((b?[p.header,p.hover,h].join(" "):"")||"").addClass(C.header).not(".sorter-false").unbind("mouseenter.tsuitheme mouseleave.tsuitheme").bind("mouseenter.tsuitheme mouseleave.tsuitheme",function(t){e(this)["mouseenter"===t.type?"addClass":"removeClass"](C.hover||"")}),w.each(function(){var r=e(this);r.find("."+t.css.wrapper).length||r.wrapInner('<div class="'+t.css.wrapper+'" style="position:relative;height:100%;width:100%"></div>')}),a.cssIcon&&w.find("."+t.css.icon).removeClass(b?[p.icons,m].join(" "):"").addClass(C.icons||""),t.hasWidget(a.table,"filter")&&(o=function(){v.children("thead").children("."+t.css.filterRow).removeClass(b?p.filterRow||"":"").addClass(C.filterRow||"")},i.filter_initialized?o():v.one("filterInit",function(){o()}))),s=0;s<a.columns;s++)c=a.$headers.add(e(a.namespace+"_extra_headers")).not(".sorter-false").filter('[data-column="'+s+'"]'),f=t.css.icon?c.find("."+t.css.icon):e(),(g=w.not(".sorter-false").filter('[data-column="'+s+'"]:last')).length&&(c.removeClass(_),f.removeClass($),g[0].sortDisabled?f.removeClass(C.icons||""):(n=C.sortNone,l=C.iconSortNone,g.hasClass(t.css.sortAsc)?(n=[C.sortAsc,C.active].join(" "),l=C.iconSortAsc):g.hasClass(t.css.sortDesc)&&(n=[C.sortDesc,C.active].join(" "),l=C.iconSortDesc),c.addClass(n),f.addClass(l||"")));a.debug&&console.log("Applying "+x+" theme"+t.benchmark(d))},remove:function(e,r,a,i){if(a.uitheme_applied){var s=r.$table,o=r.appliedTheme||"jui",n=t.themes[o]||t.themes.jui,l=s.children("thead").children(),d=n.sortNone+" "+n.sortDesc+" "+n.sortAsc,c=n.iconSortNone+" "+n.iconSortDesc+" "+n.iconSortAsc;s.removeClass("tablesorter-"+o+" "+n.table),a.uitheme_applied=!1,i||(s.find(t.css.header).removeClass(n.header),l.unbind("mouseenter.tsuitheme mouseleave.tsuitheme").removeClass(n.hover+" "+d+" "+n.active).filter("."+t.css.filterRow).removeClass(n.filterRow),l.find("."+t.css.icon).removeClass(n.icons+" "+c))}}})}(e),function(e){"use strict";var t=e.tablesorter||{};t.addWidget({id:"columns",priority:65,options:{columns:["primary","secondary","tertiary"]},format:function(r,a,i){var s,o,n,l,d,c,f,u,g=a.$table,p=a.$tbodies,h=a.sortList,m=h.length,b=i&&i.columns||["primary","secondary","tertiary"],y=b.length-1;for(f=b.join(" "),o=0;o<p.length;o++)(n=(s=t.processTbody(r,p.eq(o),!0)).children("tr")).each(function(){if(d=e(this),"none"!==this.style.display&&(c=d.children().removeClass(f),h&&h[0]&&(c.eq(h[0][0]).addClass(b[0]),m>1)))for(u=1;u<m;u++)c.eq(h[u][0]).addClass(b[u]||b[y])}),t.processTbody(r,s,!1);if(l=!1!==i.columns_thead?["thead tr"]:[],!1!==i.columns_tfoot&&l.push("tfoot tr"),l.length&&(n=g.find(l.join(",")).children().removeClass(f),m))for(u=0;u<m;u++)n.filter('[data-column="'+h[u][0]+'"]').addClass(b[u]||b[y])},remove:function(r,a,i){var s,o,n=a.$tbodies,l=(i.columns||["primary","secondary","tertiary"]).join(" ");for(a.$headers.removeClass(l),a.$table.children("tfoot").children("tr").children("th, td").removeClass(l),s=0;s<n.length;s++)(o=t.processTbody(r,n.eq(s),!0)).children("tr").each(function(){e(this).children().removeClass(l)}),t.processTbody(r,o,!1)}})}(e),function(e){"use strict";var t,r,a=e.tablesorter||{},i=a.css,s=a.keyCodes;e.extend(i,{filterRow:"tablesorter-filter-row",filter:"tablesorter-filter",filterDisabled:"disabled",filterRowHide:"hideme"}),e.extend(s,{backSpace:8,escape:27,space:32,left:37,down:40}),a.addWidget({id:"filter",priority:50,options:{filter_cellFilter:"",filter_childRows:!1,filter_childByColumn:!1,filter_childWithSibs:!0,filter_columnAnyMatch:!0,filter_columnFilters:!0,filter_cssFilter:"",filter_defaultAttrib:"data-value",filter_defaultFilter:{},filter_excludeFilter:{},filter_external:"",filter_filteredRow:"filtered",filter_filterLabel:'Filter "{{label}}" column by...',filter_formatter:null,filter_functions:null,filter_hideEmpty:!0,filter_hideFilters:!1,filter_ignoreCase:!0,filter_liveSearch:!0,filter_matchType:{input:"exact",select:"exact"},filter_onlyAvail:"filter-onlyAvail",filter_placeholder:{search:"",select:""},filter_reset:null,filter_resetOnEsc:!0,filter_saveFilters:!1,filter_searchDelay:300,filter_searchFiltered:!0,filter_selectSource:null,filter_selectSourceSeparator:"|",filter_serversideFiltering:!1,filter_startsWith:!1,filter_useParsedData:!1},format:function(e,r,a){r.$table.hasClass("hasFilters")||t.init(e,r,a)},remove:function(t,r,s,o){var n,l,d=r.$table,c=r.$tbodies,f="addRows updateCell update updateRows updateComplete appendCache filterReset filterAndSortReset filterFomatterUpdate filterEnd search stickyHeadersInit ".split(" ").join(r.namespace+"filter ");if(d.removeClass("hasFilters").unbind(f.replace(a.regex.spaces," ")).find("."+i.filterRow).remove(),s.filter_initialized=!1,!o){for(n=0;n<c.length;n++)(l=a.processTbody(t,c.eq(n),!0)).children().removeClass(s.filter_filteredRow).show(),a.processTbody(t,l,!1);s.filter_reset&&e(document).undelegate(s.filter_reset,"click"+r.namespace+"filter")}}}),t=a.filter={regex:{regex:/^\/((?:\\\/|[^\/])+)\/([migyu]{0,5})?$/,child:/tablesorter-childRow/,filtered:/filtered/,type:/undefined|number/,exact:/(^[\"\'=]+)|([\"\'=]+$)/g,operators:/[<>=]/g,query:"(q|query)",wild01:/\?/g,wild0More:/\*/g,quote:/\"/g,isNeg1:/(>=?\s*-\d)/,isNeg2:/(<=?\s*\d)/},types:{or:function(a,i,s){if((r.orTest.test(i.iFilter)||r.orSplit.test(i.filter))&&!r.regex.test(i.filter)){var o,n,l,d,c=e.extend({},i),f=i.filter.split(r.orSplit),u=i.iFilter.split(r.orSplit),g=f.length;for(o=0;o<g;o++){c.nestedFilters=!0,c.filter=""+(t.parseFilter(a,f[o],i)||""),c.iFilter=""+(t.parseFilter(a,u[o],i)||""),l="("+(t.parseFilter(a,c.filter,i)||"")+")";try{if(d=new RegExp(i.isMatch?l:"^"+l+"$",a.widgetOptions.filter_ignoreCase?"i":""),n=d.test(c.exact)||t.processTypes(a,c,s))return n}catch(e){return null}}return n||!1}return null},and:function(a,i,s){if(r.andTest.test(i.filter)){var o,n,l,d,c=e.extend({},i),f=i.filter.split(r.andSplit),u=i.iFilter.split(r.andSplit),g=f.length;for(o=0;o<g;o++){c.nestedFilters=!0,c.filter=""+(t.parseFilter(a,f[o],i)||""),c.iFilter=""+(t.parseFilter(a,u[o],i)||""),d=("("+(t.parseFilter(a,c.filter,i)||"")+")").replace(r.wild01,"\\S{1}").replace(r.wild0More,"\\S*");try{l=new RegExp(i.isMatch?d:"^"+d+"$",a.widgetOptions.filter_ignoreCase?"i":"").test(c.exact)||t.processTypes(a,c,s),n=0===o?l:n&&l}catch(e){return null}}return n||!1}return null},regex:function(e,t){if(r.regex.test(t.filter)){var a,i=t.filter_regexCache[t.index]||r.regex.exec(t.filter),s=i instanceof RegExp;try{s||(t.filter_regexCache[t.index]=i=new RegExp(i[1],i[2])),a=i.test(t.exact)}catch(e){a=!1}return a}return null},operators:function(i,s){if(r.operTest.test(s.iFilter)&&""!==s.iExact){var o,n,l,d=i.table,c=s.parsed[s.index],f=a.formatFloat(s.iFilter.replace(r.operators,""),d),u=i.parsers[s.index]||{},g=f;return(c||"numeric"===u.type)&&(l=e.trim(""+s.iFilter.replace(r.operators,"")),f="number"!=typeof(n=t.parseFilter(i,l,s,!0))||""===n||isNaN(n)?f:n),!c&&"numeric"!==u.type||isNaN(f)||void 0===s.cache?(l=isNaN(s.iExact)?s.iExact.replace(a.regex.nondigit,""):s.iExact,o=a.formatFloat(l,d)):o=s.cache,r.gtTest.test(s.iFilter)?n=r.gteTest.test(s.iFilter)?o>=f:o>f:r.ltTest.test(s.iFilter)&&(n=r.lteTest.test(s.iFilter)?o<=f:o<f),n||""!==g||(n=!0),n}return null},notMatch:function(a,i){if(r.notTest.test(i.iFilter)){var s,o=i.iFilter.replace("!",""),n=t.parseFilter(a,o,i)||"";return r.exact.test(n)?""===(n=n.replace(r.exact,""))||e.trim(n)!==i.iExact:(s=i.iExact.search(e.trim(n)),""===n||(i.anyMatch?s<0:!(a.widgetOptions.filter_startsWith?0===s:s>=0)))}return null},exact:function(a,i){if(r.exact.test(i.iFilter)){var s=i.iFilter.replace(r.exact,""),o=t.parseFilter(a,s,i)||"";return i.anyMatch?e.inArray(o,i.rowArray)>=0:o==i.iExact}return null},range:function(e,i){if(r.toTest.test(i.iFilter)){var s,o,n,l,d=e.table,c=i.index,f=i.parsed[c],u=i.iFilter.split(r.toSplit);return o=u[0].replace(a.regex.nondigit,"")||"",n=a.formatFloat(t.parseFilter(e,o,i),d),o=u[1].replace(a.regex.nondigit,"")||"",l=a.formatFloat(t.parseFilter(e,o,i),d),(f||"numeric"===e.parsers[c].type)&&(n=""===(s=e.parsers[c].format(""+u[0],d,e.$headers.eq(c),c))||isNaN(s)?n:s,l=""===(s=e.parsers[c].format(""+u[1],d,e.$headers.eq(c),c))||isNaN(s)?l:s),!f&&"numeric"!==e.parsers[c].type||isNaN(n)||isNaN(l)?(o=isNaN(i.iExact)?i.iExact.replace(a.regex.nondigit,""):i.iExact,s=a.formatFloat(o,d)):s=i.cache,n>l&&(o=n,n=l,l=o),s>=n&&s<=l||""===n||""===l}return null},wild:function(e,a){if(r.wildOrTest.test(a.iFilter)){var i=""+(t.parseFilter(e,a.iFilter,a)||"");!r.wildTest.test(i)&&a.nestedFilters&&(i=a.isMatch?i:"^("+i+")$");try{return new RegExp(i.replace(r.wild01,"\\S{1}").replace(r.wild0More,"\\S*"),e.widgetOptions.filter_ignoreCase?"i":"").test(a.exact)}catch(e){return null}}return null},fuzzy:function(e,a){if(r.fuzzyTest.test(a.iFilter)){var i,s=0,o=a.iExact.length,n=a.iFilter.slice(1),l=t.parseFilter(e,n,a)||"";for(i=0;i<o;i++)a.iExact[i]===l[s]&&(s+=1);return s===l.length}return null}},init:function(s){a.language=e.extend(!0,{},{to:"to",or:"or",and:"and"},a.language);var o,n,l,d,c,f,u,g,p=s.config,h=p.widgetOptions,m=function(e,t,r){return""===(t=t.trim())?"":(e||"")+t+(r||"")};if(p.$table.addClass("hasFilters"),p.lastSearch=[],h.filter_searchTimer=null,h.filter_initTimer=null,h.filter_formatterCount=0,h.filter_formatterInit=[],h.filter_anyColumnSelector='[data-column="all"],[data-column="any"]',h.filter_multipleColumnSelector='[data-column*="-"],[data-column*=","]',f="\\{"+r.query+"\\}",e.extend(r,{child:new RegExp(p.cssChildRow),filtered:new RegExp(h.filter_filteredRow),alreadyFiltered:new RegExp("(\\s+(-"+m("|",a.language.or)+m("|",a.language.to)+")\\s+)","i"),toTest:new RegExp("\\s+(-"+m("|",a.language.to)+")\\s+","i"),toSplit:new RegExp("(?:\\s+(?:-"+m("|",a.language.to)+")\\s+)","gi"),andTest:new RegExp("\\s+("+m("",a.language.and,"|")+"&&)\\s+","i"),andSplit:new RegExp("(?:\\s+(?:"+m("",a.language.and,"|")+"&&)\\s+)","gi"),orTest:new RegExp("(\\|"+m("|\\s+",a.language.or,"\\s+")+")","i"),orSplit:new RegExp("(?:\\|"+m("|\\s+(?:",a.language.or,")\\s+")+")","gi"),iQuery:new RegExp(f,"i"),igQuery:new RegExp(f,"ig"),operTest:/^[<>]=?/,gtTest:/>/,gteTest:/>=/,ltTest:/</,lteTest:/<=/,notTest:/^\!/,wildOrTest:/[\?\*\|]/,wildTest:/\?\*/,fuzzyTest:/^~/,exactTest:/[=\"\|!]/}),f=p.$headers.filter(".filter-false, .parser-false").length,!1!==h.filter_columnFilters&&f!==p.$headers.length&&t.buildRow(s,p,h),l="addRows updateCell update updateRows updateComplete appendCache filterReset "+"filterAndSortReset filterResetSaved filterEnd search ".split(" ").join(p.namespace+"filter "),p.$table.bind(l,function(r,o){return f=h.filter_hideEmpty&&e.isEmptyObject(p.cache)&&!(p.delayInit&&"appendCache"===r.type),p.$table.find("."+i.filterRow).toggleClass(h.filter_filteredRow,f),/(search|filter)/.test(r.type)||(r.stopPropagation(),t.buildDefault(s,!0)),"filterReset"===r.type||"filterAndSortReset"===r.type?(p.$table.find("."+i.filter).add(h.filter_$externalFilters).val(""),"filterAndSortReset"===r.type?a.sortReset(this.config,function(){t.searching(s,[])}):t.searching(s,[])):"filterResetSaved"===r.type?a.storage(s,"tablesorter-filters",""):"filterEnd"===r.type?t.buildDefault(s,!0):(o="search"===r.type?o:"updateComplete"===r.type?p.$table.data("lastSearch"):"",/(update|add)/.test(r.type)&&"updateComplete"!==r.type&&(p.lastCombinedFilter=null,p.lastSearch=[],setTimeout(function(){p.$table.triggerHandler("filterFomatterUpdate")},100)),t.searching(s,o,!0)),!1}),h.filter_reset&&(h.filter_reset instanceof e?h.filter_reset.click(function(){p.$table.triggerHandler("filterReset")}):e(h.filter_reset).length&&e(document).undelegate(h.filter_reset,"click"+p.namespace+"filter").delegate(h.filter_reset,"click"+p.namespace+"filter",function(){p.$table.triggerHandler("filterReset")})),h.filter_functions)for(c=0;c<p.columns;c++)if(u=a.getColumnData(s,h.filter_functions,c))if(d=p.$headerIndexed[c].removeClass("filter-select"),g=!(d.hasClass("filter-false")||d.hasClass("parser-false")),o="",!0===u&&g)t.buildSelect(s,c);else if("object"==typeof u&&g){for(n in u)"string"==typeof n&&(o+=""===o?'<option value="">'+(d.data("placeholder")||d.attr("data-placeholder")||h.filter_placeholder.select||"")+"</option>":"",f=n,l=n,n.indexOf(h.filter_selectSourceSeparator)>=0&&(l=(f=n.split(h.filter_selectSourceSeparator))[1],f=f[0]),o+="<option "+(l===f?"":'data-function-name="'+n+'" ')+'value="'+f+'">'+l+"</option>");p.$table.find("thead").find("select."+i.filter+'[data-column="'+c+'"]').append(o),(u="function"==typeof(l=h.filter_selectSource)||a.getColumnData(s,l,c))&&t.buildSelect(p.table,c,"",!0,d.hasClass(h.filter_onlyAvail))}t.buildDefault(s,!0),t.bindSearch(s,p.$table.find("."+i.filter),!0),h.filter_external&&t.bindSearch(s,h.filter_external),h.filter_hideFilters&&t.hideFilters(p),p.showProcessing&&(l="filterStart filterEnd ".split(" ").join(p.namespace+"filter "),p.$table.unbind(l.replace(a.regex.spaces," ")).bind(l,function(t,r){d=r?p.$table.find("."+i.header).filter("[data-column]").filter(function(){return""!==r[e(this).data("column")]}):"",a.isProcessing(s,"filterStart"===t.type,r?d:"")})),p.filteredRows=p.totalRows,l="tablesorter-initialized pagerBeforeInitialized ".split(" ").join(p.namespace+"filter "),p.$table.unbind(l.replace(a.regex.spaces," ")).bind(l,function(){t.completeInit(this)}),p.pager&&p.pager.initialized&&!h.filter_initialized?(p.$table.triggerHandler("filterFomatterUpdate"),setTimeout(function(){t.filterInitComplete(p)},100)):h.filter_initialized||t.completeInit(s)},completeInit:function(e){var r=e.config,i=r.widgetOptions,s=t.setDefaults(e,r,i)||[];s.length&&(r.delayInit&&""===s.join("")||a.setFilters(e,s,!0)),r.$table.triggerHandler("filterFomatterUpdate"),setTimeout(function(){i.filter_initialized||t.filterInitComplete(r)},100)},formatterUpdated:function(e,t){var r=e&&e.closest("table"),a=r.length&&r[0].config,i=a&&a.widgetOptions;i&&!i.filter_initialized&&(i.filter_formatterInit[t]=1)},filterInitComplete:function(r){var a,i,s=r.widgetOptions,o=0,n=function(){s.filter_initialized=!0,r.lastSearch=r.$table.data("lastSearch"),r.$table.triggerHandler("filterInit",r),t.findRows(r.table,r.lastSearch||[])};if(e.isEmptyObject(s.filter_formatter))n();else{for(i=s.filter_formatterInit.length,a=0;a<i;a++)1===s.filter_formatterInit[a]&&o++;clearTimeout(s.filter_initTimer),s.filter_initialized||o!==s.filter_formatterCount?s.filter_initialized||(s.filter_initTimer=setTimeout(function(){n()},500)):n()}},processFilters:function(e,t){var r,a=[],i=t?encodeURIComponent:decodeURIComponent,s=e.length;for(r=0;r<s;r++)e[r]&&(a[r]=i(e[r]));return a},setDefaults:function(r,i,s){var o,n,l,d,c,f=a.getFilters(r)||[];if(s.filter_saveFilters&&a.storage&&(n=a.storage(r,"tablesorter-filters")||[],(o=e.isArray(n))&&""===n.join("")||!o||(f=t.processFilters(n))),""===f.join(""))for(c=i.$headers.add(s.filter_$externalFilters).filter("["+s.filter_defaultAttrib+"]"),l=0;l<=i.columns;l++)d=l===i.columns?"all":l,f[l]=c.filter('[data-column="'+d+'"]').attr(s.filter_defaultAttrib)||f[l]||"";return i.$table.data("lastSearch",f),f},parseFilter:function(e,t,r,a){return a||r.parsed[r.index]?e.parsers[r.index].format(t,e.table,[],r.index):t},buildRow:function(r,s,o){var n,l,d,c,f,u,g,p,h,m=o.filter_cellFilter,b=s.columns,y=e.isArray(m),v='<tr role="search" class="'+i.filterRow+" "+s.cssIgnoreRow+'">';for(d=0;d<b;d++)s.$headerIndexed[d].length&&(v+=(h=s.$headerIndexed[d]&&s.$headerIndexed[d][0].colSpan||0)>1?'<td data-column="'+d+"-"+(d+h-1)+'" colspan="'+h+'"':'<td data-column="'+d+'"',v+=y?m[d]?' class="'+m[d]+'"':"":""!==m?' class="'+m+'"':"",v+="></td>");for(s.$filters=e(v+="</tr>").appendTo(s.$table.children("thead").eq(0)).children("td"),d=0;d<b;d++)u=!1,(c=s.$headerIndexed[d])&&c.length&&(n=t.getColumnElm(s,s.$filters,d),p=a.getColumnData(r,o.filter_functions,d),f=o.filter_functions&&p&&"function"!=typeof p||c.hasClass("filter-select"),l=a.getColumnData(r,s.headers,d),u="false"===a.getData(c[0],l,"filter")||"false"===a.getData(c[0],l,"parser"),f?v=e("<select>").appendTo(n):((p=a.getColumnData(r,o.filter_formatter,d))?(o.filter_formatterCount++,(v=p(n,d))&&0===v.length&&(v=n.children("input")),v&&(0===v.parent().length||v.parent().length&&v.parent()[0]!==n[0])&&n.append(v)):v=e('<input type="search">').appendTo(n),v&&(h=c.data("placeholder")||c.attr("data-placeholder")||o.filter_placeholder.search||"",v.attr("placeholder",h))),v&&(g=(e.isArray(o.filter_cssFilter)?void 0!==o.filter_cssFilter[d]?o.filter_cssFilter[d]||"":"":o.filter_cssFilter)||"",v.addClass(i.filter+" "+g),(h=(g=o.filter_filterLabel).match(/{{([^}]+?)}}/g))||(h=["{{label}}"]),e.each(h,function(t,r){var a=new RegExp(r,"g"),i=c.attr("data-"+r.replace(/{{|}}/g,"")),s=void 0===i?c.text():i;g=g.replace(a,e.trim(s))}),v.attr({"data-column":n.attr("data-column"),"aria-label":g}),u&&(v.attr("placeholder","").addClass(i.filterDisabled)[0].disabled=!0)))},bindSearch:function(r,i,o){if(r=e(r)[0],(i=e(i)).length){var n,l=r.config,d=l.widgetOptions,c=l.namespace+"filter",f=d.filter_$externalFilters;!0!==o&&(n=d.filter_anyColumnSelector+","+d.filter_multipleColumnSelector,d.filter_$anyMatch=i.filter(n),f&&f.length?d.filter_$externalFilters=d.filter_$externalFilters.add(i):d.filter_$externalFilters=i,a.setFilters(r,l.$table.data("lastSearch")||[],!1===o)),n="keypress keyup keydown search change input ".split(" ").join(c+" "),i.attr("data-lastSearchTime",(new Date).getTime()).unbind(n.replace(a.regex.spaces," ")).bind("keydown"+c,function(e){if(e.which===s.escape&&!r.config.widgetOptions.filter_resetOnEsc)return!1}).bind("keyup"+c,function(i){d=r.config.widgetOptions;var o=parseInt(e(this).attr("data-column"),10),n="boolean"==typeof d.filter_liveSearch?d.filter_liveSearch:a.getColumnData(r,d.filter_liveSearch,o);if(void 0===n&&(n=d.filter_liveSearch.fallback||!1),e(this).attr("data-lastSearchTime",(new Date).getTime()),i.which===s.escape)this.value=d.filter_resetOnEsc?"":l.lastSearch[o];else{if(""!==this.value&&("number"==typeof n&&this.value.length<n||i.which!==s.enter&&i.which!==s.backSpace&&(i.which<s.space||i.which>=s.left&&i.which<=s.down)))return;if(!1===n&&""!==this.value&&i.which!==s.enter)return}t.searching(r,!0,!0,o)}).bind("search change keypress input blur ".split(" ").join(c+" "),function(i){var o=parseInt(e(this).attr("data-column"),10),n=i.type,c="boolean"==typeof d.filter_liveSearch?d.filter_liveSearch:a.getColumnData(r,d.filter_liveSearch,o);!r.config.widgetOptions.filter_initialized||i.which!==s.enter&&"search"!==n&&"blur"!==n&&("change"!==n&&"input"!==n||!0!==c&&(!0===c||"INPUT"===i.target.nodeName)||this.value===l.lastSearch[o])||(i.preventDefault(),e(this).attr("data-lastSearchTime",(new Date).getTime()),t.searching(r,"keypress"!==n,!0,o))})}},searching:function(e,r,i,s){var o,n=e.config.widgetOptions;void 0===s?o=!1:void 0===(o="boolean"==typeof n.filter_liveSearch?n.filter_liveSearch:a.getColumnData(e,n.filter_liveSearch,s))&&(o=n.filter_liveSearch.fallback||!1),clearTimeout(n.filter_searchTimer),void 0===r||!0===r?n.filter_searchTimer=setTimeout(function(){t.checkFilters(e,r,i)},o?n.filter_searchDelay:10):t.checkFilters(e,r,i)},equalFilters:function(t,r,a){var i,s=[],o=[],n=t.columns+1;for(r=e.isArray(r)?r:[],a=e.isArray(a)?a:[],i=0;i<n;i++)s[i]=r[i]||"",o[i]=a[i]||"";return s.join(",")===o.join(",")},checkFilters:function(r,s,o){var n=r.config,l=n.widgetOptions,d=e.isArray(s),c=d?s:a.getFilters(r,!0),f=c||[];if(e.isEmptyObject(n.cache))n.delayInit&&(!n.pager||n.pager&&n.pager.initialized)&&a.updateCache(n,function(){t.checkFilters(r,!1,o)});else if(d&&(a.setFilters(r,c,!1,!0!==o),l.filter_initialized||(n.lastSearch=[],n.lastCombinedFilter="")),l.filter_hideFilters&&n.$table.find("."+i.filterRow).triggerHandler(t.hideFiltersCheck(n)?"mouseleave":"mouseenter"),!t.equalFilters(n,n.lastSearch,f)||!1===s){if(!1===s&&(n.lastCombinedFilter="",n.lastSearch=[]),c=c||[],c=Array.prototype.map?c.map(String):c.join("�").split("�"),l.filter_initialized&&n.$table.triggerHandler("filterStart",[c]),!n.showProcessing)return t.findRows(r,c,f),!1;setTimeout(function(){return t.findRows(r,c,f),!1},30)}},hideFiltersCheck:function(e){if("function"==typeof e.widgetOptions.filter_hideFilters){var t=e.widgetOptions.filter_hideFilters(e);if("boolean"==typeof t)return t}return""===a.getFilters(e.$table).join("")},hideFilters:function(r,a){var s;(a||r.$table).find("."+i.filterRow).addClass(i.filterRowHide).bind("mouseenter mouseleave",function(a){var o=a,n=e(this);clearTimeout(s),s=setTimeout(function(){/enter|over/.test(o.type)?n.removeClass(i.filterRowHide):e(document.activeElement).closest("tr")[0]!==n[0]&&n.toggleClass(i.filterRowHide,t.hideFiltersCheck(r))},200)}).find("input, select").bind("focus blur",function(a){var o=a,n=e(this).closest("tr");clearTimeout(s),s=setTimeout(function(){clearTimeout(s),n.toggleClass(i.filterRowHide,t.hideFiltersCheck(r)&&"focus"!==o.type)},200)})},defaultFilter:function(t,a){if(""===t)return t;var i=r.iQuery,s=a.match(r.igQuery).length,o=s>1?e.trim(t).split(/\s/):[e.trim(t)],n=o.length-1,l=0,d=a;for(n<1&&s>1&&(o[1]=o[0]);i.test(d);)d=d.replace(i,o[l++]||""),i.test(d)&&l<n&&""!==(o[l]||"")&&(d=a.replace(i,d));return d},getLatestSearch:function(t){return t?t.sort(function(t,r){return e(r).attr("data-lastSearchTime")-e(t).attr("data-lastSearchTime")}):t||e()},findRange:function(e,t,r){var a,i,s,o,n,l,d,c,f,u=[];if(/^[0-9]+$/.test(t))return[parseInt(t,10)];if(!r&&/-/.test(t))for(f=(i=t.match(/(\d+)\s*-\s*(\d+)/g))?i.length:0,c=0;c<f;c++){for(s=i[c].split(/\s*-\s*/),(o=parseInt(s[0],10)||0)>(n=parseInt(s[1],10)||e.columns-1)&&(a=o,o=n,n=a),n>=e.columns&&(n=e.columns-1);o<=n;o++)u[u.length]=o;t=t.replace(i[c],"")}if(!r&&/,/.test(t))for(f=(l=t.split(/\s*,\s*/)).length,d=0;d<f;d++)""!==l[d]&&(c=parseInt(l[d],10))<e.columns&&(u[u.length]=c);if(!u.length)for(c=0;c<e.columns;c++)u[u.length]=c;return u},getColumnElm:function(r,a,i){return a.filter(function(){var a=t.findRange(r,e(this).attr("data-column"));return e.inArray(i,a)>-1})},multipleColumns:function(r,a){var i=r.widgetOptions,s=i.filter_initialized||!a.filter(i.filter_anyColumnSelector).length,o=e.trim(t.getLatestSearch(a).attr("data-column")||"");return t.findRange(r,o,!s)},processTypes:function(r,a,i){var s,o=null,n=null;for(s in t.types)e.inArray(s,i.excludeMatch)<0&&null===n&&null!==(n=t.types[s](r,a,i))&&(a.matchedOn=s,o=n);return o},matchType:function(e,t){var r,a=e.widgetOptions,s=e.$headerIndexed[t];return s.hasClass("filter-exact")?r=!1:s.hasClass("filter-match")?r=!0:(a.filter_columnFilters?s=e.$filters.find("."+i.filter).add(a.filter_$externalFilters).filter('[data-column="'+t+'"]'):a.filter_$externalFilters&&(s=a.filter_$externalFilters.filter('[data-column="'+t+'"]')),r=!!s.length&&"match"===e.widgetOptions.filter_matchType[(s[0].nodeName||"").toLowerCase()]),r},processRow:function(i,s,o){var n,l,d,c,f,u=i.widgetOptions,g=!0,p=u.filter_$anyMatch&&u.filter_$anyMatch.length,h=u.filter_$anyMatch&&u.filter_$anyMatch.length?t.multipleColumns(i,u.filter_$anyMatch):[];if(s.$cells=s.$row.children(),s.matchedOn=null,s.anyMatchFlag&&h.length>1||s.anyMatchFilter&&!p){if(s.anyMatch=!0,s.isMatch=!0,s.rowArray=s.$cells.map(function(t){if(e.inArray(t,h)>-1||s.anyMatchFilter&&!p)return s.parsed[t]?f=s.cacheArray[t]:(f=s.rawArray[t],f=e.trim(u.filter_ignoreCase?f.toLowerCase():f),i.sortLocaleCompare&&(f=a.replaceAccents(f))),f}).get(),s.filter=s.anyMatchFilter,s.iFilter=s.iAnyMatchFilter,s.exact=s.rowArray.join(" "),s.iExact=u.filter_ignoreCase?s.exact.toLowerCase():s.exact,s.cache=s.cacheArray.slice(0,-1).join(" "),o.excludeMatch=o.noAnyMatch,null!==(l=t.processTypes(i,s,o)))g=l;else if(u.filter_startsWith)for(g=!1,h=Math.min(i.columns,s.rowArray.length);!g&&h>0;)h--,g=g||0===s.rowArray[h].indexOf(s.iFilter);else g=(s.iExact+s.childRowText).indexOf(s.iFilter)>=0;if(s.anyMatch=!1,s.filters.join("")===s.filter)return g}for(h=0;h<i.columns;h++)s.filter=s.filters[h],s.index=h,o.excludeMatch=o.excludeFilter[h],s.filter&&(s.cache=s.cacheArray[h],n=s.parsed[h]?s.cache:s.rawArray[h]||"",s.exact=i.sortLocaleCompare?a.replaceAccents(n):n,s.iExact=!r.type.test(typeof s.exact)&&u.filter_ignoreCase?s.exact.toLowerCase():s.exact,s.isMatch=t.matchType(i,h),n=g,c=u.filter_columnFilters?i.$filters.add(u.filter_$externalFilters).filter('[data-column="'+h+'"]').find("select option:selected").attr("data-function-name")||"":"",i.sortLocaleCompare&&(s.filter=a.replaceAccents(s.filter)),u.filter_defaultFilter&&r.iQuery.test(o.defaultColFilter[h])&&(s.filter=t.defaultFilter(s.filter,o.defaultColFilter[h])),s.iFilter=u.filter_ignoreCase?(s.filter||"").toLowerCase():s.filter,l=null,(d=o.functions[h])&&("function"==typeof d?l=d(s.exact,s.cache,s.filter,h,s.$row,i,s):"function"==typeof d[c||s.filter]&&(l=d[f=c||s.filter](s.exact,s.cache,s.filter,h,s.$row,i,s))),null===l?(l=t.processTypes(i,s,o),f=!0===d&&("and"===s.matchedOn||"or"===s.matchedOn),null===l||f?!0===d?n=s.isMatch?(""+s.iExact).search(s.iFilter)>=0:s.filter===s.exact:(f=(s.iExact+s.childRowText).indexOf(t.parseFilter(i,s.iFilter,s)),n=!u.filter_startsWith&&f>=0||u.filter_startsWith&&0===f):n=l):n=l,g=!!n&&g);return g},findRows:function(i,s,o){if(!t.equalFilters(i.config,i.config.lastSearch,o)&&i.config.widgetOptions.filter_initialized){var n,l,d,c,f,u,g,p,h,m,b,y,v,w,x,C,_,$,S,z,F,R,T,I=e.extend([],s),k=i.config,A=k.widgetOptions,D={anyMatch:!1,filters:s,filter_regexCache:[]},H={noAnyMatch:["range","operators"],functions:[],excludeFilter:[],defaultColFilter:[],defaultAnyFilter:a.getColumnData(i,A.filter_defaultFilter,k.columns,!0)||""};for(D.parsed=[],h=0;h<k.columns;h++)D.parsed[h]=A.filter_useParsedData||k.parsers&&k.parsers[h]&&k.parsers[h].parsed||a.getData&&"parsed"===a.getData(k.$headerIndexed[h],a.getColumnData(i,k.headers,h),"filter")||k.$headerIndexed[h].hasClass("filter-parsed"),H.functions[h]=a.getColumnData(i,A.filter_functions,h)||k.$headerIndexed[h].hasClass("filter-select"),H.defaultColFilter[h]=a.getColumnData(i,A.filter_defaultFilter,h)||"",H.excludeFilter[h]=(a.getColumnData(i,A.filter_excludeFilter,h,!0)||"").split(/\s+/);for(k.debug&&(console.log("Filter: Starting filter widget search",s),w=new Date),k.filteredRows=0,k.totalRows=0,o=I||[],g=0;g<k.$tbodies.length;g++){if(p=a.processTbody(i,k.$tbodies.eq(g),!0),h=k.columns,l=k.cache[g].normalized,c=e(e.map(l,function(e){return e[h].$row.get()})),""===o.join("")||A.filter_serversideFiltering)c.removeClass(A.filter_filteredRow).not("."+k.cssChildRow).css("display","");else{if(c=c.not("."+k.cssChildRow),n=c.length,(A.filter_$anyMatch&&A.filter_$anyMatch.length||void 0!==s[k.columns])&&(D.anyMatchFlag=!0,D.anyMatchFilter=""+(s[k.columns]||A.filter_$anyMatch&&t.getLatestSearch(A.filter_$anyMatch).val()||""),A.filter_columnAnyMatch)){for(S=D.anyMatchFilter.split(r.andSplit),z=!1,C=0;C<S.length;C++)(F=S[C].split(":")).length>1&&(isNaN(F[0])?e.each(k.headerContent,function(e,t){t.toLowerCase().indexOf(F[0])>-1&&(s[R=e]=F[1])}):R=parseInt(F[0],10)-1,R>=0&&R<k.columns&&(s[R]=F[1],S.splice(C,1),C--,z=!0));z&&(D.anyMatchFilter=S.join(" && "))}if($=A.filter_searchFiltered,b=k.lastSearch||k.$table.data("lastSearch")||[],$)for(C=0;C<h+1;C++)x=s[C]||"",$||(C=h),$=$&&b.length&&0===x.indexOf(b[C]||"")&&!r.alreadyFiltered.test(x)&&!r.exactTest.test(x)&&!(r.isNeg1.test(x)||r.isNeg2.test(x))&&!(""!==x&&k.$filters&&k.$filters.filter('[data-column="'+C+'"]').find("select").length&&!t.matchType(k,C));for(_=c.not("."+A.filter_filteredRow).length,$&&0===_&&($=!1),k.debug&&console.log("Filter: Searching through "+($&&_<n?_:"all")+" rows"),D.anyMatchFlag&&(k.sortLocaleCompare&&(D.anyMatchFilter=a.replaceAccents(D.anyMatchFilter)),A.filter_defaultFilter&&r.iQuery.test(H.defaultAnyFilter)&&(D.anyMatchFilter=t.defaultFilter(D.anyMatchFilter,H.defaultAnyFilter),$=!1),D.iAnyMatchFilter=A.filter_ignoreCase&&k.ignoreCase?D.anyMatchFilter.toLowerCase():D.anyMatchFilter),u=0;u<n;u++)if(T=c[u].className,!(u&&r.child.test(T)||$&&r.filtered.test(T))){if(D.$row=c.eq(u),D.rowIndex=u,D.cacheArray=l[u],d=D.cacheArray[k.columns],D.rawArray=d.raw,D.childRowText="",!A.filter_childByColumn){for(T="",m=d.child,C=0;C<m.length;C++)T+=" "+m[C].join(" ")||"";D.childRowText=A.filter_childRows?A.filter_ignoreCase?T.toLowerCase():T:""}if(y=!1,v=t.processRow(k,D,H),f=d.$row,x=!!v,m=d.$row.filter(":gt(0)"),A.filter_childRows&&m.length){if(A.filter_childByColumn)for(A.filter_childWithSibs||(m.addClass(A.filter_filteredRow),f=f.eq(0)),C=0;C<m.length;C++)D.$row=m.eq(C),D.cacheArray=d.child[C],D.rawArray=D.cacheArray,x=t.processRow(k,D,H),y=y||x,!A.filter_childWithSibs&&x&&m.eq(C).removeClass(A.filter_filteredRow);y=y||v}else y=x;f.toggleClass(A.filter_filteredRow,!y)[0].display=y?"":"none"}}k.filteredRows+=c.not("."+A.filter_filteredRow).length,k.totalRows+=c.length,a.processTbody(i,p,!1)}k.lastCombinedFilter=I.join(""),k.lastSearch=I,k.$table.data("lastSearch",I),A.filter_saveFilters&&a.storage&&a.storage(i,"tablesorter-filters",t.processFilters(I,!0)),k.debug&&console.log("Completed filter widget search"+a.benchmark(w)),A.filter_initialized&&(k.$table.triggerHandler("filterBeforeEnd",k),k.$table.triggerHandler("filterEnd",k)),setTimeout(function(){a.applyWidget(k.table)},0)}},getOptionSource:function(r,i,s){var o=(r=e(r)[0]).config,n=!1,l=o.widgetOptions.filter_selectSource,d=o.$table.data("lastSearch")||[],c="function"==typeof l||a.getColumnData(r,l,i);if(s&&""!==d[i]&&(s=!1),!0===c)n=l(r,i,s);else{if(c instanceof e||"string"===e.type(c)&&c.indexOf("</option>")>=0)return c;if(e.isArray(c))n=c;else if("object"===e.type(l)&&c&&null===(n=c(r,i,s)))return null}return!1===n&&(n=t.getOptions(r,i,s)),t.processOptions(r,i,n)},processOptions:function(t,r,i){if(!e.isArray(i))return!1;var s,o,n,l,d,c,f=(t=e(t)[0]).config,u=void 0!==r&&null!==r&&r>=0&&r<f.columns,g=!!u&&f.$headerIndexed[r].hasClass("filter-select-sort-desc"),p=[];if(i=e.grep(i,function(t,r){return!!t.text||e.inArray(t,i)===r}),u&&f.$headerIndexed[r].hasClass("filter-select-nosort"))return i;for(l=i.length,n=0;n<l;n++)c=(o=i[n]).text?o.text:o,d=(u&&f.parsers&&f.parsers.length&&f.parsers[r].format(c,t,[],r)||c).toString(),d=f.widgetOptions.filter_ignoreCase?d.toLowerCase():d,o.text?(o.parsed=d,p[p.length]=o):p[p.length]={text:o,parsed:d};for(s=f.textSorter||"",p.sort(function(e,i){var o=g?i.parsed:e.parsed,n=g?e.parsed:i.parsed;return u&&"function"==typeof s?s(o,n,!0,r,t):u&&"object"==typeof s&&s.hasOwnProperty(r)?s[r](o,n,!0,r,t):!a.sortNatural||a.sortNatural(o,n)}),i=[],l=p.length,n=0;n<l;n++)i[i.length]=p[n];return i},getOptions:function(t,r,i){var s,o,n,l,d,c,f,u,g=(t=e(t)[0]).config,p=g.widgetOptions,h=[];for(o=0;o<g.$tbodies.length;o++)for(d=g.cache[o],n=g.cache[o].normalized.length,s=0;s<n;s++)if(l=d.row?d.row[s]:d.normalized[s][g.columns].$row[0],!i||!l.className.match(p.filter_filteredRow))if(p.filter_useParsedData||g.parsers[r].parsed||g.$headerIndexed[r].hasClass("filter-parsed")){if(h[h.length]=""+d.normalized[s][r],p.filter_childRows&&p.filter_childByColumn)for(u=d.normalized[s][g.columns].$row.length-1,c=0;c<u;c++)h[h.length]=""+d.normalized[s][g.columns].child[c][r]}else if(h[h.length]=d.normalized[s][g.columns].raw[r],p.filter_childRows&&p.filter_childByColumn)for(u=d.normalized[s][g.columns].$row.length,c=1;c<u;c++)f=d.normalized[s][g.columns].$row.eq(c).children().eq(r),h[h.length]=""+a.getElementText(g,f,r);return h},buildSelect:function(a,s,o,n,l){if(a=e(a)[0],s=parseInt(s,10),a.config.cache&&!e.isEmptyObject(a.config.cache)){var d,c,f,u,g,p,h,m=a.config,b=m.widgetOptions,y=m.$headerIndexed[s],v='<option value="">'+(y.data("placeholder")||y.attr("data-placeholder")||b.filter_placeholder.select||"")+"</option>",w=m.$table.find("thead").find("select."+i.filter+'[data-column="'+s+'"]').val();if(void 0!==o&&""!==o||null!==(o=t.getOptionSource(a,s,l))){if(e.isArray(o)){for(d=0;d<o.length;d++)if((h=o[d]).text){h["data-function-name"]=void 0===h.value?h.text:h.value,v+="<option";for(c in h)h.hasOwnProperty(c)&&"text"!==c&&(v+=" "+c+'="'+h[c]+'"');h.value||(v+=' value="'+h.text+'"'),v+=">"+h.text+"</option>"}else""+h!="[object Object]"&&(c=f=h=(""+h).replace(r.quote,"&quot;"),f.indexOf(b.filter_selectSourceSeparator)>=0&&(c=(u=f.split(b.filter_selectSourceSeparator))[0],f=u[1]),v+=""!==h?"<option "+(c===f?"":'data-function-name="'+h+'" ')+'value="'+c+'">'+f+"</option>":"");o=[]}g=(m.$filters?m.$filters:m.$table.children("thead")).find("."+i.filter),b.filter_$externalFilters&&(g=g&&g.length?g.add(b.filter_$externalFilters):b.filter_$externalFilters),(p=g.filter('select[data-column="'+s+'"]')).length&&(p[n?"html":"append"](v),e.isArray(o)||p.append(o).val(w),p.val(w))}}},buildDefault:function(e,r){var i,s,o,n=e.config,l=n.widgetOptions,d=n.columns;for(i=0;i<d;i++)o=!((s=n.$headerIndexed[i]).hasClass("filter-false")||s.hasClass("parser-false")),(s.hasClass("filter-select")||!0===a.getColumnData(e,l.filter_functions,i))&&o&&t.buildSelect(e,i,"",r,s.hasClass(l.filter_onlyAvail))}},r=t.regex,a.getFilters=function(r,a,s,o){var n,l,d,c,f=[],u=r?e(r)[0].config:"",g=u?u.widgetOptions:"";if(!0!==a&&g&&!g.filter_columnFilters||e.isArray(s)&&t.equalFilters(u,s,u.lastSearch))return e(r).data("lastSearch")||[];if(u&&(u.$filters&&(l=u.$filters.find("."+i.filter)),g.filter_$externalFilters&&(l=l&&l.length?l.add(g.filter_$externalFilters):g.filter_$externalFilters),l&&l.length))for(f=s||[],n=0;n<u.columns+1;n++)c=n===u.columns?g.filter_anyColumnSelector+","+g.filter_multipleColumnSelector:'[data-column="'+n+'"]',(d=l.filter(c)).length&&(d=t.getLatestSearch(d),e.isArray(s)?(o&&d.length>1&&(d=d.slice(1)),n===u.columns&&(d=(c=d.filter(g.filter_anyColumnSelector)).length?c:d),d.val(s[n]).trigger("change"+u.namespace)):(f[n]=d.val()||"",n===u.columns?d.slice(1).filter('[data-column*="'+d.attr("data-column")+'"]').val(f[n]):d.slice(1).val(f[n])),n===u.columns&&d.length&&(g.filter_$anyMatch=d));return f},a.setFilters=function(r,i,s,o){var n=r?e(r)[0].config:"",l=a.getFilters(r,!0,i,o);return void 0===s&&(s=!0),n&&s&&(n.lastCombinedFilter=null,n.lastSearch=[],t.searching(n.table,i,o),n.$table.triggerHandler("filterFomatterUpdate")),0!==l.length}}(e),function(e,t){"use strict";function r(t,r){var a=isNaN(r.stickyHeaders_offset)?e(r.stickyHeaders_offset):[];return a.length?a.height()||0:parseInt(r.stickyHeaders_offset,10)||0}var a=e.tablesorter||{};e.extend(a.css,{sticky:"tablesorter-stickyHeader",stickyVis:"tablesorter-sticky-visible",stickyHide:"tablesorter-sticky-hidden",stickyWrap:"tablesorter-sticky-wrapper"}),a.addHeaderResizeEvent=function(t,r,a){if((t=e(t)[0]).config){var i={timer:250},s=e.extend({},i,a),o=t.config,n=o.widgetOptions,l=function(e){var t,r,a,i,s,l,d=o.$headers.length;for(n.resize_flag=!0,r=[],t=0;t<d;t++)i=(a=o.$headers.eq(t)).data("savedSizes")||[0,0],s=a[0].offsetWidth,l=a[0].offsetHeight,s===i[0]&&l===i[1]||(a.data("savedSizes",[s,l]),r.push(a[0]));r.length&&!1!==e&&o.$table.triggerHandler("resize",[r]),n.resize_flag=!1};if(clearInterval(n.resize_timer),r)return n.resize_flag=!1,!1;l(!1),n.resize_timer=setInterval(function(){n.resize_flag||l()},s.timer)}},a.addWidget({id:"stickyHeaders",priority:54,options:{stickyHeaders:"",stickyHeaders_appendTo:null,stickyHeaders_attachTo:null,stickyHeaders_xScroll:null,stickyHeaders_yScroll:null,stickyHeaders_offset:0,stickyHeaders_filteredToTop:!0,stickyHeaders_cloneId:"-sticky",stickyHeaders_addResizeEvent:!0,stickyHeaders_includeCaption:!0,stickyHeaders_zIndex:2},format:function(i,s,o){if(!(s.$table.hasClass("hasStickyHeaders")||e.inArray("filter",s.widgets)>=0&&!s.$table.hasClass("hasFilters"))){var n,l,d,c,f=s.$table,u=e(o.stickyHeaders_attachTo),g=s.namespace+"stickyheaders ",p=e(o.stickyHeaders_yScroll||o.stickyHeaders_attachTo||t),h=e(o.stickyHeaders_xScroll||o.stickyHeaders_attachTo||t),m=f.children("thead:first").children("tr").not(".sticky-false").children(),b=f.children("tfoot"),y=r(0,o),v=f.parent().closest("."+a.css.table).hasClass("hasStickyHeaders")?f.parent().closest("table.tablesorter")[0].config.widgetOptions.$sticky.parent():[],w=v.length?v.height():0,x=o.$sticky=f.clone().addClass("containsStickyHeaders "+a.css.sticky+" "+o.stickyHeaders+" "+s.namespace.slice(1)+"_extra_table").wrap('<div class="'+a.css.stickyWrap+'">'),C=x.parent().addClass(a.css.stickyHide).css({position:u.length?"absolute":"fixed",padding:parseInt(x.parent().parent().css("padding-left"),10),top:y+w,left:0,visibility:"hidden",zIndex:o.stickyHeaders_zIndex||2}),_=x.children("thead:first"),$="",S=function(e,r){var a,i,s,o,n,l=e.filter(":visible"),d=l.length;for(a=0;a<d;a++)o=r.filter(":visible").eq(a),"border-box"===(n=l.eq(a)).css("box-sizing")?i=n.outerWidth():"collapse"===o.css("border-collapse")?t.getComputedStyle?i=parseFloat(t.getComputedStyle(n[0],null).width):(s=parseFloat(n.css("border-width")),i=n.outerWidth()-parseFloat(n.css("padding-left"))-parseFloat(n.css("padding-right"))-s):i=n.width(),o.css({width:i,"min-width":i,"max-width":i})},z=function(){return u.length?parseInt(u.css("padding-left"),10)||0:f.offset().left-parseInt(f.css("margin-left"),10)-e(t).scrollLeft()},F=function(){C.css({left:z(),width:f.outerWidth()}),S(f,x),S(m,c)},R=function(t){if(f.is(":visible")){w=v.length?v.offset().top-p.scrollTop()+v.height():0;var i,s=f.offset(),n=r(0,o),l=e.isWindow(p[0]),d=u.length?l?p.scrollTop():p.offset().top:p.scrollTop(),c=o.stickyHeaders_includeCaption?0:f.children("caption").height()||0,g=d+n+w-c,h=f.height()-(C.height()+(b.height()||0))-c,m=g>s.top&&g<s.top+h?"visible":"hidden",y="visible"===m?a.css.stickyVis:a.css.stickyHide,x=!C.hasClass(y),_={visibility:m};u.length&&(x=!0,_.top=l?g-u.offset().top:u.scrollTop()),(i=z())!==parseInt(C.css("left"),10)&&(x=!0,_.left=i),_.top=(_.top||0)+n+w,x&&C.removeClass(a.css.stickyVis+" "+a.css.stickyHide).addClass(y).css(_),(m!==$||t)&&(F(),$=m)}};if(u.length&&!u.css("position")&&u.css("position","relative"),x.attr("id")&&(x[0].id+=o.stickyHeaders_cloneId),x.find("thead:gt(0), tr.sticky-false").hide(),x.find("tbody, tfoot").remove(),x.find("caption").toggle(o.stickyHeaders_includeCaption),c=_.children().children(),x.css({height:0,width:0,margin:0}),c.find("."+a.css.resizer).remove(),f.addClass("hasStickyHeaders").bind("pagerComplete"+g,function(){F()}),a.bindEvents(i,_.children().children("."+a.css.header)),o.stickyHeaders_appendTo?e(o.stickyHeaders_appendTo).append(C):f.after(C),s.onRenderHeader)for(l=(d=_.children("tr").children()).length,n=0;n<l;n++)s.onRenderHeader.apply(d.eq(n),[n,s,x]);h.add(p).unbind("scroll resize ".split(" ").join(g).replace(/\s+/g," ")).bind("scroll resize ".split(" ").join(g),function(e){R("resize"===e.type)}),s.$table.unbind("stickyHeadersUpdate"+g).bind("stickyHeadersUpdate"+g,function(){R(!0)}),o.stickyHeaders_addResizeEvent&&a.addHeaderResizeEvent(i),f.hasClass("hasFilters")&&o.filter_columnFilters&&(f.bind("filterEnd"+g,function(){var r=e(document.activeElement).closest("td"),i=r.parent().children().index(r);C.hasClass(a.css.stickyVis)&&o.stickyHeaders_filteredToTop&&(t.scrollTo(0,f.position().top),i>=0&&s.$filters&&s.$filters.eq(i).find("a, select, input").filter(":visible").focus())}),a.filter.bindSearch(f,c.find("."+a.css.filter)),o.filter_hideFilters&&a.filter.hideFilters(s,x)),o.stickyHeaders_addResizeEvent&&f.bind("resize"+s.namespace+"stickyheaders",function(){F()}),R(!0),f.triggerHandler("stickyHeadersInit")}},remove:function(r,i,s){var o=i.namespace+"stickyheaders ";i.$table.removeClass("hasStickyHeaders").unbind("pagerComplete resize filterEnd stickyHeadersUpdate ".split(" ").join(o).replace(/\s+/g," ")).next("."+a.css.stickyWrap).remove(),s.$sticky&&s.$sticky.length&&s.$sticky.remove(),e(t).add(s.stickyHeaders_xScroll).add(s.stickyHeaders_yScroll).add(s.stickyHeaders_attachTo).unbind("scroll resize ".split(" ").join(o).replace(/\s+/g," ")),a.addHeaderResizeEvent(r,!0)}})}(e,window),function(e,t){"use strict";var r=e.tablesorter||{};e.extend(r.css,{resizableContainer:"tablesorter-resizable-container",resizableHandle:"tablesorter-resizable-handle",resizableNoSelect:"tablesorter-disableSelection",resizableStorage:"tablesorter-resizable"}),e(function(){var t="<style>body."+r.css.resizableNoSelect+" { -ms-user-select: none; -moz-user-select: -moz-none;-khtml-user-select: none; -webkit-user-select: none; user-select: none; }."+r.css.resizableContainer+" { position: relative; height: 1px; }."+r.css.resizableHandle+" { position: absolute; display: inline-block; width: 8px;top: 1px; cursor: ew-resize; z-index: 3; user-select: none; -moz-user-select: none; }</style>";e("head").append(t)}),r.resizable={init:function(t,a){if(!t.$table.hasClass("hasResizable")){t.$table.addClass("hasResizable");var i,s,o,n,l=t.$table,d=l.parent(),c=parseInt(l.css("margin-top"),10),f=a.resizable_vars={useStorage:r.storage&&!1!==a.resizable,$wrap:d,mouseXPosition:0,$target:null,$next:null,overflow:a.resizable_overflow||"auto"===d.css("overflow")||"scroll"===d.css("overflow")||"auto"===d.css("overflow-x")||"scroll"===d.css("overflow-x"),storedSizes:[]};for(r.resizableReset(t.table,!0),f.tableWidth=l.width(),f.fullWidth=Math.abs(d.width()-f.tableWidth)<20,f.useStorage&&f.overflow&&(r.storage(t.table,"tablesorter-table-original-css-width",f.tableWidth),n=r.storage(t.table,"tablesorter-table-resized-width")||"auto",r.resizable.setWidth(l,n,!0)),a.resizable_vars.storedSizes=o=(f.useStorage?r.storage(t.table,r.css.resizableStorage):[])||[],r.resizable.setWidths(t,a,o),r.resizable.updateStoredSizes(t,a),a.$resizable_container=e('<div class="'+r.css.resizableContainer+'">').css({top:c}).insertBefore(l),s=0;s<t.columns;s++)i=t.$headerIndexed[s],n=r.getColumnData(t.table,t.headers,s),"false"===r.getData(i,n,"resizable")||e('<div class="'+r.css.resizableHandle+'">').appendTo(a.$resizable_container).attr({"data-column":s,unselectable:"on"}).data("header",i).bind("selectstart",!1);r.resizable.bindings(t,a)}},updateStoredSizes:function(e,t){var r,a,i=e.columns,s=t.resizable_vars;for(s.storedSizes=[],r=0;r<i;r++)a=e.$headerIndexed[r],s.storedSizes[r]=a.is(":visible")?a.width():0},setWidth:function(e,t,r){e.css({width:t,"min-width":r?t:"","max-width":r?t:""})},setWidths:function(t,a,i){var s,o,n=a.resizable_vars,l=e(t.namespace+"_extra_headers"),d=t.$table.children("colgroup").children("col");if((i=i||n.storedSizes||[]).length){for(s=0;s<t.columns;s++)r.resizable.setWidth(t.$headerIndexed[s],i[s],n.overflow),l.length&&(o=l.eq(s).add(d.eq(s)),r.resizable.setWidth(o,i[s],n.overflow));(o=e(t.namespace+"_extra_table")).length&&!r.hasWidget(t.table,"scroller")&&r.resizable.setWidth(o,t.$table.outerWidth(),n.overflow)}},setHandlePosition:function(t,a){var i,s=t.$table.height(),o=a.$resizable_container.children(),n=Math.floor(o.width()/2);r.hasWidget(t.table,"scroller")&&(s=0,t.$table.closest("."+r.css.scrollerWrap).children().each(function(){var t=e(this);s+=t.filter('[style*="height"]').length?t.height():t.children("table").height()})),!a.resizable_includeFooter&&t.$table.children("tfoot").length&&(s-=t.$table.children("tfoot").height()),i=t.$table.position().left,o.each(function(){var o=e(this),l=parseInt(o.attr("data-column"),10),d=t.columns-1,c=o.data("header");c&&(!c.is(":visible")||!a.resizable_addLastColumn&&r.resizable.checkVisibleColumns(t,l)?o.hide():(l<d||l===d&&a.resizable_addLastColumn)&&o.css({display:"inline-block",height:s,left:c.position().left-i+c.outerWidth()-n}))})},checkVisibleColumns:function(e,t){var r,a=0;for(r=t+1;r<e.columns;r++)a+=e.$headerIndexed[r].is(":visible")?1:0;return 0===a},toggleTextSelection:function(t,a,i){var s=t.namespace+"tsresize";a.resizable_vars.disabled=i,e("body").toggleClass(r.css.resizableNoSelect,i),i?e("body").attr("unselectable","on").bind("selectstart"+s,!1):e("body").removeAttr("unselectable").unbind("selectstart"+s)},bindings:function(a,i){var s=a.namespace+"tsresize";i.$resizable_container.children().bind("mousedown",function(t){var s,o=i.resizable_vars,n=e(a.namespace+"_extra_headers"),l=e(t.target).data("header");s=parseInt(l.attr("data-column"),10),o.$target=l=l.add(n.filter('[data-column="'+s+'"]')),o.target=s,o.$next=t.shiftKey||i.resizable_targetLast?l.parent().children().not(".resizable-false").filter(":last"):l.nextAll(":not(.resizable-false)").eq(0),s=parseInt(o.$next.attr("data-column"),10),o.$next=o.$next.add(n.filter('[data-column="'+s+'"]')),o.next=s,o.mouseXPosition=t.pageX,r.resizable.updateStoredSizes(a,i),r.resizable.toggleTextSelection(a,i,!0)}),e(document).bind("mousemove"+s,function(e){var t=i.resizable_vars;t.disabled&&0!==t.mouseXPosition&&t.$target&&(i.resizable_throttle?(clearTimeout(t.timer),t.timer=setTimeout(function(){r.resizable.mouseMove(a,i,e)},isNaN(i.resizable_throttle)?5:i.resizable_throttle)):r.resizable.mouseMove(a,i,e))}).bind("mouseup"+s,function(){i.resizable_vars.disabled&&(r.resizable.toggleTextSelection(a,i,!1),r.resizable.stopResize(a,i),r.resizable.setHandlePosition(a,i))}),e(t).bind("resize"+s+" resizeEnd"+s,function(){r.resizable.setHandlePosition(a,i)}),a.$table.bind("columnUpdate pagerComplete resizableUpdate ".split(" ").join(s+" "),function(){r.resizable.setHandlePosition(a,i)}).bind("resizableReset"+s,function(){r.resizableReset(a.table)}).find("thead:first").add(e(a.namespace+"_extra_table").find("thead:first")).bind("contextmenu"+s,function(){var e=0===i.resizable_vars.storedSizes.length;return r.resizableReset(a.table),r.resizable.setHandlePosition(a,i),i.resizable_vars.storedSizes=[],e})},mouseMove:function(t,a,i){if(0!==a.resizable_vars.mouseXPosition&&a.resizable_vars.$target){var s,o=0,n=a.resizable_vars,l=n.$next,d=n.storedSizes[n.target],c=i.pageX-n.mouseXPosition;if(n.overflow){if(d+c>0){for(n.storedSizes[n.target]+=c,r.resizable.setWidth(n.$target,n.storedSizes[n.target],!0),s=0;s<t.columns;s++)o+=n.storedSizes[s];r.resizable.setWidth(t.$table.add(e(t.namespace+"_extra_table")),o)}l.length||(n.$wrap[0].scrollLeft=t.$table.width())}else n.fullWidth?(n.storedSizes[n.target]+=c,n.storedSizes[n.next]-=c,r.resizable.setWidths(t,a)):(n.storedSizes[n.target]+=c,r.resizable.setWidths(t,a));n.mouseXPosition=i.pageX,t.$table.triggerHandler("stickyHeadersUpdate")}},stopResize:function(e,t){var a=t.resizable_vars;r.resizable.updateStoredSizes(e,t),a.useStorage&&(r.storage(e.table,r.css.resizableStorage,a.storedSizes),r.storage(e.table,"tablesorter-table-resized-width",e.$table.width())),a.mouseXPosition=0,a.$target=a.$next=null,e.$table.triggerHandler("stickyHeadersUpdate"),e.$table.triggerHandler("resizableComplete")}},r.addWidget({id:"resizable",priority:40,options:{resizable:!0,resizable_addLastColumn:!1,resizable_includeFooter:!0,resizable_widths:[],resizable_throttle:!1,resizable_targetLast:!1,resizable_overflow:!1},init:function(e,t,a,i){r.resizable.init(a,i)},format:function(e,t,a){r.resizable.setHandlePosition(t,a)},remove:function(t,a,i,s){if(i.$resizable_container){var o=a.namespace+"tsresize";a.$table.add(e(a.namespace+"_extra_table")).removeClass("hasResizable").children("thead").unbind("contextmenu"+o),i.$resizable_container.remove(),r.resizable.toggleTextSelection(a,i,!1),r.resizableReset(t,s),e(document).unbind("mousemove"+o+" mouseup"+o)}}}),r.resizableReset=function(t,a){e(t).each(function(){var e,i,s=this.config,o=s&&s.widgetOptions,n=o.resizable_vars;if(t&&s&&s.$headerIndexed.length){for(n.overflow&&n.tableWidth&&(r.resizable.setWidth(s.$table,n.tableWidth,!0),n.useStorage&&r.storage(t,"tablesorter-table-resized-width",n.tableWidth)),e=0;e<s.columns;e++)i=s.$headerIndexed[e],o.resizable_widths&&o.resizable_widths[e]?r.resizable.setWidth(i,o.resizable_widths[e],n.overflow):i.hasClass("resizable-false")||r.resizable.setWidth(i,"",n.overflow);s.$table.triggerHandler("stickyHeadersUpdate"),r.storage&&!a&&r.storage(this,r.css.resizableStorage,[])}})}}(e,window),function(e){"use strict";var t=e.tablesorter||{};t.addWidget({id:"saveSort",priority:20,options:{saveSort:!0},init:function(e,t,r,a){t.format(e,r,a,!0)},format:function(r,a,i,s){var o,n,l=a.$table,d=!1!==i.saveSort,c={sortList:a.sortList};a.debug&&(n=new Date),l.hasClass("hasSaveSort")?d&&r.hasInitialized&&t.storage&&(t.storage(r,"tablesorter-savesort",c),a.debug&&console.log("saveSort widget: Saving last sort: "+a.sortList+t.benchmark(n))):(l.addClass("hasSaveSort"),c="",t.storage&&(c=(o=t.storage(r,"tablesorter-savesort"))&&o.hasOwnProperty("sortList")&&e.isArray(o.sortList)?o.sortList:"",a.debug&&console.log('saveSort: Last sort loaded: "'+c+'"'+t.benchmark(n)),l.bind("saveSortReset",function(e){e.stopPropagation(),t.storage(r,"tablesorter-savesort","")})),s&&c&&c.length>0?a.sortList=c:r.hasInitialized&&c&&c.length>0&&t.sortOn(a,c))},remove:function(e,r){r.$table.removeClass("hasSaveSort"),t.storage&&t.storage(e,"tablesorter-savesort","")}})}(e),e.tablesorter});</script>'''


def from_json(json_data, report_file=None, minimal=False):
    """
    Create HTML report from JSON.

    Args:
        json_data (json): data in json format.
            The json_data must have the following structure:
            {
                columns: [], - list of columns, represented as a string, for example: ['col1', 'col2', 'col3', 'col4']
                rows: [],    - list of rows, represented as a list of cell values in each column, for example: [[1, 2, 3, 3], [1, 2, 3, 4]]. If you have some hierarchical rows, you can use the following format: [{'parent': 1 /*child count*/, 'data': [1, 2, 3, 3]}, {'child': true, 'data': [1, 2, 3, 4]}, [1, 2, 3, 5]].
            }
            Optionally the json_data can be extended by the following fields:
            {
                groups: [],       - a list of column groups that has the following format: [{name: 'group1', description(optional):'group1', start: 0, end: 2}, {...}]
                css: "",          - css, represented as a string applied to the html report, for example: "#data-table tbody tr td {background-color:green;}"
                metrics: {},      - object of some common metrics that appear in the additional collapsible section, placed in the lower-left corner of the page, for example: {'metric1': 1, 'metric2': 2}. Metrics list will be displayed in the report as table, whose caption can be included in the object in the form of a pair {caption: "Metrics caption example"}.
                additional:
                {
                  html_elems: [], - list of html elements that appear in the additional collapsible section after metrics, if any
                  images : [],    - list of base64 codes represented as string (or object: {base64: "", width: "5px", height: "6px"}) that appear in the additional collapsible section after html_elems, if any
                }
            }
        report_file (str): path to save the result report. Default is None.
        minimal (bool): if True, minimal HTML report will be created. It has a smaller size and a shorter loading time. Some features like columns resizing, sorting, filtering, rows collapsing will depend on Advisor's product and will not work without it. Default is False.
    Returns:
        Created html as string.
    """
    html = template
    if minimal == False:
        html = re.sub(r'(<script src=(\"|\').*?jquery.*?(\"|\')>\s*</script>\s*?){2}', libs.replace('\\', '\\\\'), html)
    else:
        current_dir = os.path.dirname(os.path.realpath(__file__))
        html = re.sub('CURRENT_DIR', current_dir, html)
    html = re.sub(r'<script id=\"data\".*?>\s*</script>', '<script> data=' + json_data.replace('\\', '\\\\') + '</script>', html)

    if report_file:

        if MAJOR == 3:

            with open(report_file, encoding='utf8', mode='w') as output_file:

                output_file.write(html)

        else:

            with open(report_file, 'w') as output_file:

                output_file.write(html)

    return html


def from_rows(data, report_file=None, columns=None, groups=None, metrics=None, minimal=False, additional_html_elems=None, additional_images=None):
    """
    Create HTML report.

    Args:
        data (iterable): list of data rows.
        report_file (str): path to save the result report. Default is None.
        columns (iterable): list of columns to put into the report. If empty, all columns will be used. Default is None.
        groups (iterable): list of column groups to put into the report in the following format:
            [{name: 'group', description(optional):'This is a group', start: 0, end: 4}, {...}]. The default value is None.
        minimal (bool): if True, minimal HTML report will be created. It has a smaller size and a shorter loading time. Some features like columns resizing, sorting, filtering, rows collapsing will depend on Advisor's product and will not work without it. Default is False.
        metrics (iterable): object of some common metrics, represented as pairs {key: value} to put into the additional collapsible section of the report. The default value is None. Metrics object will be displayed in the report as table, whose caption can be included in the object in the form of a pair {caption: "Metrics caption example"}.
        additional_html_elems (iterable): list of html elements to put into the additional collapsible section of the report (after metrics, if any). The default value is None.
        additional_images (iterable): list of base64 codes represented as string (or object: {base64: "", width: "5px", height: "6px"}) to put into the additional collapsible section of the report (after additional_html_elements, if any). The default value is None.
    Examples:
        >>> project = advisor.open_project(sys.argv[1])
        >>> survey = project.load(advisor.SURVEY)
        >>> advisor.html_report.from_rows(survey.bottomup, report_file='my_report.html', columns=['function_call_sites_and_loops', 'self_time'], minimal=False)
    Returns:
        created html or empty string if there is no data
    """
    if not data:
        return ""

    if columns is None:
        columns = []
        for entry in data:
            columns = [key for key in entry if key]
            break

    values = []
    if len(columns) > 0:
        values = [[row[key] for key in columns] for row in data]
    else:
        print("Warning: No columns are provided.")

    json_dict = {'columns': columns, 'rows': values, 'groups': groups, 'metrics': metrics, 'additional': {'html_elems': additional_html_elems, 'images': additional_images}}
    json_data = json.dumps(json_dict)

    return from_json(json_data, report_file, minimal)
