#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#

def select_loops(self, loops, select):
    if isinstance(loops, row_type):
        self._select_loop(loops._get_id(), select)
    else:
        for loop in loops:
            self._select_loop(loop._get_id(), select)

def append(self, loops):
    """
    Append specified loops to the selection.

    Args:
        loops: one :class:`Hotspot` row or iterator over :class:`Hotspot` rows

    Examples:
        >>> rows = list(survey.bottomup)
        >>> project.mark_up_select(rows[0:2])
        >>> project.mark_up_append(rows[2])
    """
    select_loops(self, loops, True)

def remove(self, loops):
    """
    Remove specified loops from the selection.

    Args:
        loops: one :class:`Hotspot` row or iterator over :class:`Hotspot` rows

    Examples:
        >>> rows = list(survey.bottomup)
        >>> project.mark_up_select(rows)
        >>> project.mark_up_remove(rows[0:2])
    """
    select_loops(self, loops, False)

def select(self, loops):
    """
    Clear previous selection and select specified loops.

    Args:
        loops: one :class:`Hotspot` row or iterator over :class:`Hotspot` rows

    Examples:
        >>> rows = list(survey.bottomup)[:3]
        >>> project.mark_up_select(rows)
    """
    self.mark_up_clear()
    append(self, loops)


def select_for_target(self, loops, target_collector):
    """
    Clear previous selection and select specified loops.

    Args:
        loops: one :class:`Hotspot` row or iterator over :class:`Hotspot` rows
        target_collector: avisor.SelectionType.TRIPCOUNTS, advisor.SelectionType.FLOPS, \
            advisor.SelectionType.CACHESIM or advisor.SelectionType.DATA_TRANSFER.      \
            collectors can be combined using "|" operator:                              \
            advisor.SelectionType.CACHESIM | advisor.SelectionType.FLOPS

    Examples:
        >>> rows = list(survey.bottomup)[:3]
        >>> project.select_for_target(rows, advisor.SelectionType.TRIPCOUNTS | advisor.SelectionType.CACHESIM)
    """
    self.mark_up_clear()
    if isinstance(loops, row_type):
        self._select_loop_for_target(loops._get_id(), target_collector)
    else:
        for loop in loops:
            self._select_loop_for_target(loop._get_id(), target_collector)
