/*
 * Copyright (C) 2020 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

// Distance 53760000Gr:1f/53760000Gr:2f/53760000Gw:0f 13440000 0 1
// note that if the data in arrays are equal additional processing is done, affecting flop count
__kernel void Distance(__global float *pA, __global float *pB, __global float *pC)
{
    const int id = get_global_id(0);

    float4 a = (float4)(pA[4 * id], pA[4 * id + 1], pA[4 * id + 2], pA[4 * id + 3]);
    float4 b = (float4)(pB[4 * id], pB[4 * id + 1], pB[4 * id + 2], pB[4 * id + 3]);

    pC[id] = distance(a, b);
}
