#ifndef __ACL_OPENCL_PREDEFINES__
#define __ACL_OPENCL_PREDEFINES__
#pragma clang system_header
#define CL_VERSION_1_0 100
#if __OPENCL_C_VERSION__ >= 110
#define CL_VERSION_1_1 110
#endif
#if __OPENCL_C_VERSION__ >= 120
#define CL_VERSION_1_2 120
#endif
#if __OPENCL_C_VERSION__ >= 200
#define CL_VERSION_2_0 200
#endif
#define __OPENCL_VERSION__ CL_VERSION_1_0
#if __OPENCL_C_VERSION__ >= 120
#define __CONST_CHAR_STAR_COMPATIBILITY_VERSION__ CL_VERSION_1_2
#endif
#define __EMBEDDED_PROFILE__ 1
#define __ENDIAN_LITTLE__ 1
#define __kernel_exec(X,typen) __kernel __attribute__((work_group_size_hint(X,1,1))) __attribute__((vec_type_hint(typen)))

#define kernel_exec(X,typen) __kernel_exec(X,typen)
#ifdef __FPGA_EMULATION_X86__
   #define __fpga_reg(x) (x)
#elif __has_builtin(__builtin_fpga_reg)
   #ifndef __fpga_reg
       #define __fpga_reg __builtin_fpga_reg
   #endif
#endif

#define CHAR_BIT 8
#define SCHAR_MAX 127
#define SCHAR_MIN (-127-1)
#define CHAR_MAX 127
#define CHAR_MIN (-127-1)
#define SHRT_MAX 32767
#define SHRT_MIN (-32767-1)
#define INT_MAX 0x7fffffff
#define INT_MIN (-0x7fffffff-1)
#define LONG_MAX 0x7fffffffffffffffLL
#define LONG_MIN (-0x7fffffffffffffffLL-1)
#define UCHAR_MAX 255
#define USHRT_MAX 65535
#define UINT_MAX 0xffffffff
#define ULONG_MAX 0xffffffffffffffffULL
#define FP_ILOGBNAN INT_MAX
#define FP_ILOGB0 -INT_MAX
#pragma OPENCL EXTENSION cl_khr_fp64 : enable
#if __OPENCL_C_VERSION__ >= 120
int printf(__constant const char*, ...) __attribute__((format(printf, 1, 2)));
#endif
typedef unsigned __INT64_TYPE__ size_t;
typedef __INT64_TYPE__ ptrdiff_t;
typedef unsigned __INT64_TYPE__ uintptr_t;
typedef __INT64_TYPE__ intptr_t;
#define SIZE_MAX ((size_t)-1)
typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned __INT64_TYPE__ ulong;

#define _AV(_T,_n,_a) typedef _T _T##_n __attribute__(( ext_vector_type(_n),aligned(_a) ));
#define _AVP2(_T,_n) _AV(_T,_n,sizeof(_T)*_n)
#if __OPENCL_C_VERSION__ >= 110
#define _IHC_VDECLARES(_T) _AVP2(_T,2) _AVP2(_T,4) _AVP2(_T,8) _AVP2(_T,16) _AV(_T,3,sizeof(_T)*4)
#else
#define _IHC_VDECLARES(_T) _AVP2(_T,2) _AVP2(_T,4) _AVP2(_T,8) _AVP2(_T,16)
#endif
_IHC_VDECLARES(char)
_IHC_VDECLARES(uchar)
_IHC_VDECLARES(short)
_IHC_VDECLARES(ushort)
_IHC_VDECLARES(int)
_IHC_VDECLARES(uint)
_IHC_VDECLARES(long)
_IHC_VDECLARES(ulong)
_IHC_VDECLARES(half)
_IHC_VDECLARES(float)
_IHC_VDECLARES(double)
#undef _AV
#undef _AVP2
#undef _IHC_VDECLARES
#ifndef NO_DEFINITION
uint __acl__get_work_dim(void) __attribute(( const, noinline)) ;
size_t __acl_wide_get_global_size(uint dimindx) __attribute(( const, noinline)) ;
size_t __acl_wide_get_global_id(uint dimindx) __attribute(( const, noinline)) ;
size_t __acl_wide_get_local_size(uint dimindx) __attribute(( const, noinline)) ;
size_t __acl_wide_get_local_id(uint dimindx) __attribute(( const, noinline)) ;
size_t __acl_wide_get_local_linear_id(void) __attribute(( const, noinline)) ;
size_t __acl_wide_get_num_groups(uint dimindx) __attribute(( const, noinline)) ;
size_t __acl_wide_get_group_id(uint dimindx) __attribute(( const, noinline)) ;
size_t __acl_wide_get_global_offset(uint dimindx) __attribute(( const, noinline)) ;
size_t __acl__get_compute_id(uint dimindx) __attribute(( const, noinline)) ;
uint __acl_get_hw_wg_id(void) __attribute(( const, noinline)) ;
#endif
size_t __attribute__((__overloadable__,__always_inline__)) __spirv_BuiltInGlobalSize(int __d);
size_t __attribute__((__overloadable__,__always_inline__)) __spirv_BuiltInGlobalInvocationId(int __d);
size_t __attribute__((__overloadable__,__always_inline__)) __spirv_BuiltInWorkgroupSize(int __d);
size_t __attribute__((__overloadable__,__always_inline__)) __spirv_BuiltInLocalInvocationId(int __d);
size_t __attribute__((__overloadable__,__always_inline__)) __spirv_BuiltInNumWorkgroups(int __d);
size_t __attribute__((__overloadable__,__always_inline__)) __spirv_BuiltInWorkgroupId(int __d);
#if __OPENCL_C_VERSION__ >= 110
size_t __attribute__((__overloadable__,__always_inline__)) __spirv_BuiltInGlobalOffset(int __d);
#endif
#ifndef NO_DEFINITION
inline size_t __attribute__((__overloadable__,__always_inline__)) get_global_size(uint __d);
inline size_t __attribute__((__overloadable__,__always_inline__)) get_global_size(uint __d){ return __spirv_BuiltInGlobalSize((int)__d); }
inline size_t __attribute__((__overloadable__,__always_inline__)) get_global_id(uint __d);
inline size_t __attribute__((__overloadable__,__always_inline__)) get_global_id(uint __d){ return __spirv_BuiltInGlobalInvocationId((int)__d); }
inline size_t __attribute__((__overloadable__,__always_inline__)) get_local_size(uint __d);
inline size_t __attribute__((__overloadable__,__always_inline__)) get_local_size(uint __d){ return __spirv_BuiltInWorkgroupSize((int)__d); }
inline size_t __attribute__((__overloadable__,__always_inline__)) get_local_id(uint __d);
inline size_t __attribute__((__overloadable__,__always_inline__)) get_local_id(uint __d){ return __spirv_BuiltInLocalInvocationId((int)__d); }
inline size_t __attribute__((__overloadable__,__always_inline__)) get_num_groups(uint __d);
inline size_t __attribute__((__overloadable__,__always_inline__)) get_num_groups(uint __d){ return __spirv_BuiltInNumWorkgroups((int)__d); }
inline size_t __attribute__((__overloadable__,__always_inline__)) get_group_id(uint __d);
inline size_t __attribute__((__overloadable__,__always_inline__)) get_group_id(uint __d){ return __spirv_BuiltInWorkgroupId((int)__d); }
#if __OPENCL_C_VERSION__ >= 110
inline size_t __attribute__((__overloadable__,__always_inline__)) get_global_offset(uint __d);
inline size_t __attribute__((__overloadable__,__always_inline__)) get_global_offset(uint __d){ return __spirv_BuiltInGlobalOffset((int)__d); }
#endif
#endif
size_t __attribute__((__overloadable__,__always_inline__)) __spirv_BuiltInLocalInvocationIndex();
#ifndef NO_DEFINITION
inline size_t __attribute__((__overloadable__,__always_inline__)) get_local_linear_id();
inline size_t __attribute__((__overloadable__,__always_inline__)) get_local_linear_id(){ return __spirv_BuiltInLocalInvocationIndex(); }
#endif
uint __attribute__((__overloadable__,__always_inline__)) get_work_dim();
typedef enum {  CLK_LOCAL_MEM_FENCE=1,CLK_GLOBAL_MEM_FENCE=2,CLK_CHANNEL_MEM_FENCE=4 } cl_mem_fence_flags;

void __attribute__((  noinline, convergent )) __acl_barrier(cl_mem_fence_flags, uint, uint);
uint __acl_get_barrier_local_id(void); 
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) barrier(cl_mem_fence_flags _f);
inline void __attribute__((__overloadable__,__always_inline__)) barrier(cl_mem_fence_flags _f){ __acl_barrier(_f, __acl_get_hw_wg_id(), __acl_get_barrier_local_id()); }
#endif
void __attribute__((__overloadable__,__always_inline__)) __spirv_ControlBarrier(int f1, int f2, int f3);
void __attribute((noinline, convergent )) __acl_mem_fence(cl_mem_fence_flags, int);
#ifndef NO_DEFINITION
inline void __attribute((__overloadable__, convergent )) mem_fence(cl_mem_fence_flags f);
inline void __attribute((__overloadable__, convergent )) mem_fence(cl_mem_fence_flags f){ __acl_mem_fence(f, 1); }
#endif
void __attribute((__overloadable__, convergent )) __spirv_MemoryBarrier(int scope, int flags);
void __attribute(( __always_inline__, convergent )) read_mem_fence(cl_mem_fence_flags flags);
void __attribute(( __always_inline__, convergent )) write_mem_fence(cl_mem_fence_flags flags);
#define M_E 0X1.5BF0A8B145769P+1
#define M_LOG2E 0X1.71547652B82FEP+0
#define M_LOG10E 0X1.BCB7B1526E50EP-2
#define M_LN2 0X1.62E42FEFA39EFP-1
#define M_1_LN2 1.4426950408889634073599246810019
#define M_LN10 0X1.26BB1BBB55516P+1
#define M_1_LN10 0.43429448190325182765112891891661
#define M_PI 0X1.921FB54442D18P+1
#define M_PI_2 0X1.921FB54442D18P+0
#define M_PI_4 0X1.921FB54442D18P-1
#define M_1_PI 0X1.45F306DC9C883P-2
#define M_2_PI 0X1.45F306DC9C883P-1
#define M_2_SQRTPI 0X1.20DD750429B6DP+0
#define M_SQRT2 0X1.6A09E667F3BCDP+0
#define M_SQRT1_2 0X1.6A09E667F3BCDP-1
#define M_E_F 0X1.5BF0A8B145769P+1f
#define M_E_2_F 0X1.5BF0A8B145769P+0f
#define M_LOG2E_F 0X1.71547652B82FEP+0f
#define M_LOG10E_F 0X1.BCB7B1526E50EP-2f
#define M_LN2_F 0X1.62E42FEFA39EFP-1f
#define M_1_LN2_F 1.4426950408889634073599246810019f
#define M_LN10_F 0X1.26BB1BBB55516P+1f
#define M_1_LN10_F 0.43429448190325182765112891891661f
#define M_PI_F 0X1.921FB54442D18P+1f
#define M_PI_2_F 0X1.921FB54442D18P+0f
#define M_PI_4_F 0X1.921FB54442D18P-1f
#define M_1_PI_F 0X1.45F306DC9C883P-2f
#define M_2_PI_F 0X1.45F306DC9C883P-1f
#define M_2_SQRTPI_F 0X1.20DD750429B6DP+0f
#define M_SQRT2_F 0X1.6A09E667F3BCDP+0f
#define M_SQRT1_2_F 0X1.6A09E667F3BCDP-1f
#define FLT_DIG 6
#define FLT_MANT_DIG 24
#define FLT_MAX_10_EXP +38
#define FLT_MAX_EXP +128
#define FLT_MIN_10_EXP -37
#define FLT_MIN_EXP -125
#define FLT_RADIX 2
#define FLT_MAX 0x1.fffffep127f
#define FLT_MIN 0x1.0p-126f
#define FLT_EPSILON 0x1.0p-23f
#define DBL_DIG 15
#define DBL_MANT_DIG 53
#define DBL_MAX_10_EXP +308
#define DBL_MAX_EXP +1024
#define DBL_MIN_10_EXP -307
#define DBL_MIN_EXP -1021
#define DBL_MAX 0x1.fffffffffffffp1023
#define DBL_MIN 0x1.0p-1022
#define DBL_EPSILON 0x1.0p-52
#define HUGE_VAL 0x1.0p+1024
#define MAXFLOAT __FLT_MAX__
#define HUGE_VALF as_float(0x7f800000)
#define INFINITY HUGE_VALF
#define NAN as_float(0x7fffffff)
#define as_char(X) __builtin_astype(X,char)
#define as_char2(X) __builtin_astype(X,char2)
#if __OPENCL_C_VERSION__ >= 110
#define as_char3(X) __builtin_astype(X,char3)
#endif
#define as_char4(X) __builtin_astype(X,char4)
#define as_char8(X) __builtin_astype(X,char8)
#define as_char16(X) __builtin_astype(X,char16)
#define as_uchar(X) __builtin_astype(X,uchar)
#define as_uchar2(X) __builtin_astype(X,uchar2)
#if __OPENCL_C_VERSION__ >= 110
#define as_uchar3(X) __builtin_astype(X,uchar3)
#endif
#define as_uchar4(X) __builtin_astype(X,uchar4)
#define as_uchar8(X) __builtin_astype(X,uchar8)
#define as_uchar16(X) __builtin_astype(X,uchar16)
#define as_short(X) __builtin_astype(X,short)
#define as_short2(X) __builtin_astype(X,short2)
#if __OPENCL_C_VERSION__ >= 110
#define as_short3(X) __builtin_astype(X,short3)
#endif
#define as_short4(X) __builtin_astype(X,short4)
#define as_short8(X) __builtin_astype(X,short8)
#define as_short16(X) __builtin_astype(X,short16)
#define as_ushort(X) __builtin_astype(X,ushort)
#define as_ushort2(X) __builtin_astype(X,ushort2)
#if __OPENCL_C_VERSION__ >= 110
#define as_ushort3(X) __builtin_astype(X,ushort3)
#endif
#define as_ushort4(X) __builtin_astype(X,ushort4)
#define as_ushort8(X) __builtin_astype(X,ushort8)
#define as_ushort16(X) __builtin_astype(X,ushort16)
#define as_int(X) __builtin_astype(X,int)
#define as_int2(X) __builtin_astype(X,int2)
#if __OPENCL_C_VERSION__ >= 110
#define as_int3(X) __builtin_astype(X,int3)
#endif
#define as_int4(X) __builtin_astype(X,int4)
#define as_int8(X) __builtin_astype(X,int8)
#define as_int16(X) __builtin_astype(X,int16)
#define as_uint(X) __builtin_astype(X,uint)
#define as_uint2(X) __builtin_astype(X,uint2)
#if __OPENCL_C_VERSION__ >= 110
#define as_uint3(X) __builtin_astype(X,uint3)
#endif
#define as_uint4(X) __builtin_astype(X,uint4)
#define as_uint8(X) __builtin_astype(X,uint8)
#define as_uint16(X) __builtin_astype(X,uint16)
#define as_long(X) __builtin_astype(X,long)
#define as_long2(X) __builtin_astype(X,long2)
#if __OPENCL_C_VERSION__ >= 110
#define as_long3(X) __builtin_astype(X,long3)
#endif
#define as_long4(X) __builtin_astype(X,long4)
#define as_long8(X) __builtin_astype(X,long8)
#define as_long16(X) __builtin_astype(X,long16)
#define as_ulong(X) __builtin_astype(X,ulong)
#define as_ulong2(X) __builtin_astype(X,ulong2)
#if __OPENCL_C_VERSION__ >= 110
#define as_ulong3(X) __builtin_astype(X,ulong3)
#endif
#define as_ulong4(X) __builtin_astype(X,ulong4)
#define as_ulong8(X) __builtin_astype(X,ulong8)
#define as_ulong16(X) __builtin_astype(X,ulong16)
#define as_float(X) __builtin_astype(X,float)
#define as_float2(X) __builtin_astype(X,float2)
#if __OPENCL_C_VERSION__ >= 110
#define as_float3(X) __builtin_astype(X,float3)
#endif
#define as_float4(X) __builtin_astype(X,float4)
#define as_float8(X) __builtin_astype(X,float8)
#define as_float16(X) __builtin_astype(X,float16)
#define as_double(X) __builtin_astype(X,double)
#define as_double2(X) __builtin_astype(X,double2)
#if __OPENCL_C_VERSION__ >= 110
#define as_double3(X) __builtin_astype(X,double3)
#endif
#define as_double4(X) __builtin_astype(X,double4)
#define as_double8(X) __builtin_astype(X,double8)
#define as_double16(X) __builtin_astype(X,double16)

float __attribute__((__always_inline__)) __acl__flush_denorm(float x);
float __attribute__((__always_inline__)) __acl__flush_denorm_signed_zero(float x);
double __attribute__((__overloadable__)) __spirv_ocl_log10(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_log10(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_log10(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_log10(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_log10(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_log10(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_log10(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_log10(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_log10(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_log10(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_log10(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_log10(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_log2(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_log2(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_log2(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_log2(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_log2(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_log2(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_log2(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_log2(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_log2(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_log2(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_log2(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_log2(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_log1p(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_log1p(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_log1p(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_log1p(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_log1p(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_log1p(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_log1p(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_log1p(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_log1p(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_log1p(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_log1p(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_log1p(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_log(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_log(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_log(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_log(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_log(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_log(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_log(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_log(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_log(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_log(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_log(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_log(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_sqrt(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_sqrt(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_sqrt(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_sqrt(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_sqrt(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_sqrt(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_sqrt(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_sqrt(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_sqrt(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_sqrt(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_sqrt(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_sqrt(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_exp(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_exp(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_exp(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_exp(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_exp(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_exp(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_exp(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_exp(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_exp(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_exp(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_exp(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_exp(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_exp2(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_exp2(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_exp2(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_exp2(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_exp2(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_exp2(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_exp2(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_exp2(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_exp2(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_exp2(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_exp2(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_exp2(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_ldexp(double __x, int __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_ldexp(double2 __x, int2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_ldexp(double3 __x, int3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_ldexp(double4 __x, int4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_ldexp(double8 __x, int8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_ldexp(double16 __x, int16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_ldexp(float __x, int __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_ldexp(float2 __x, int2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_ldexp(float3 __x, int3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_ldexp(float4 __x, int4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_ldexp(float8 __x, int8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_ldexp(float16 __x, int16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_sin(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_sin(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_sin(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_sin(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_sin(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_sin(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_sin(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_sin(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_sin(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_sin(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_sin(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_sin(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_cos(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_cos(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_cos(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_cos(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_cos(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_cos(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_cos(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_cos(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_cos(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_cos(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_cos(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_cos(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_tan(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_tan(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_tan(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_tan(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_tan(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_tan(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_tan(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_tan(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_tan(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_tan(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_tan(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_tan(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_asin(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_asin(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_asin(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_asin(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_asin(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_asin(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_asin(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_asin(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_asin(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_asin(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_asin(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_asin(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_acos(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_acos(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_acos(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_acos(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_acos(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_acos(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_acos(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_acos(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_acos(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_acos(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_acos(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_acos(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_atan(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_atan(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_atan(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_atan(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_atan(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_atan(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_atan(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_atan(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_atan(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_atan(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_atan(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_atan(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_sinh(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_sinh(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_sinh(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_sinh(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_sinh(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_sinh(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_sinh(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_sinh(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_sinh(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_sinh(float4 __x );
float8  __attribute__((__overloadable__)) __spirv_ocl_sinh(float8 __x);
float16  __attribute__((__overloadable__)) __spirv_ocl_sinh(float16 __x);
double __attribute__((__overloadable__)) __spirv_ocl_cosh(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_cosh(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_cosh(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_cosh(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_cosh(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_cosh(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_cosh(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_cosh(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_cosh(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_cosh(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_cosh(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_cosh(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_tanh(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_tanh(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_tanh(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_tanh(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_tanh(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_tanh(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_tanh(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_tanh(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_tanh(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_tanh(float4 __x );
float8  __attribute__((__overloadable__)) __spirv_ocl_tanh(float8 __x);
float16  __attribute__((__overloadable__)) __spirv_ocl_tanh(float16 __x);
double __attribute__((__overloadable__)) __spirv_ocl_asinh(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_asinh(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_asinh(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_asinh(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_asinh(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_asinh(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_asinh(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_asinh(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_asinh(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_asinh(float4 __x );
float8  __attribute__((__overloadable__)) __spirv_ocl_asinh(float8 __x);
float16  __attribute__((__overloadable__)) __spirv_ocl_asinh(float16 __x);
double __attribute__((__overloadable__)) __spirv_ocl_acosh(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_acosh(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_acosh(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_acosh(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_acosh(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_acosh(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_acosh(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_acosh(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_acosh(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_acosh(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_acosh(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_acosh(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_atanh(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_atanh(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_atanh(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_atanh(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_atanh(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_atanh(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_atanh(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_atanh(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_atanh(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_atanh(float4 __x );
float8  __attribute__((__overloadable__)) __spirv_ocl_atanh(float8 __x);
float16  __attribute__((__overloadable__)) __spirv_ocl_atanh(float16 __x);
double __attribute__((__overloadable__)) __spirv_ocl_floor(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_floor(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_floor(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_floor(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_floor(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_floor(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_floor(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_floor(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_floor(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_floor(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_floor(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_floor(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_ceil(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_ceil(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_ceil(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_ceil(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_ceil(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_ceil(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_ceil(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_ceil(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_ceil(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_ceil(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_ceil(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_ceil(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_fabs(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_fabs(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_fabs(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_fabs(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_fabs(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_fabs(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_fabs(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_fabs(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_fabs(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_fabs(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_fabs(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_fabs(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_trunc(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_trunc(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_trunc(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_trunc(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_trunc(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_trunc(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_trunc(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_trunc(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_trunc(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_trunc(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_trunc(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_trunc(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_pow(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_pow(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_pow(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_pow(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_pow(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_pow(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_pow(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_pow(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_pow(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_pow(float4 __x, float4 __y);
float8  __attribute__((__overloadable__)) __spirv_ocl_pow(float8 __x, float8 __y);
float16  __attribute__((__overloadable__)) __spirv_ocl_pow(float16 __x, float16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_lgamma(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_lgamma(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_lgamma(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_lgamma(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_lgamma(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_lgamma(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_lgamma(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_lgamma(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_lgamma(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_lgamma(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_lgamma(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_lgamma(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_tgamma(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_tgamma(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_tgamma(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_tgamma(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_tgamma(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_tgamma(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_tgamma(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_tgamma(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_tgamma(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_tgamma(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_tgamma(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_tgamma(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_erf(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_erf(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_erf(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_erf(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_erf(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_erf(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_erf(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_erf(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_erf(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_erf(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_erf(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_erf(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_erfc(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_erfc(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_erfc(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_erfc(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_erfc(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_erfc(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_erfc(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_erfc(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_erfc(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_erfc(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_erfc(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_erfc(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_cbrt(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_cbrt(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_cbrt(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_cbrt(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_cbrt(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_cbrt(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_cbrt(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_cbrt(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_cbrt(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_cbrt(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_cbrt(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_cbrt(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_expm1(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_expm1(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_expm1(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_expm1(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_expm1(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_expm1(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_expm1(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_expm1(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_expm1(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_expm1(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_expm1(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_expm1(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_fdim(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_fdim(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_fdim(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_fdim(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_fdim(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_fdim(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_fdim(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_fdim(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_fdim(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_fdim(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_fdim(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_fdim(float16 __x, float16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_atan2(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_atan2(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_atan2(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_atan2(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_atan2(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_atan2(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_atan2(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_atan2(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_atan2(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_atan2(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_atan2(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_atan2(float16 __x, float16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_hypot(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_hypot(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_hypot(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_hypot(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_hypot(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_hypot(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_hypot(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_hypot(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_hypot(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_hypot(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_hypot(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_hypot(float16 __x, float16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_exp10(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_exp10(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_exp10(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_exp10(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_exp10(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_exp10(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_exp10(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_exp10(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_exp10(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_exp10(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_exp10(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_exp10(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_rsqrt(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_rsqrt(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_rsqrt(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_sinpi(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_sinpi(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_sinpi(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_sinpi(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_sinpi(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_sinpi(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_sinpi(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_sinpi(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_sinpi(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_sinpi(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_sinpi(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_sinpi(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_cospi(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_cospi(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_cospi(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_cospi(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_cospi(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_cospi(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_cospi(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_cospi(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_cospi(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_cospi(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_cospi(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_cospi(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_tanpi(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_tanpi(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_tanpi(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_tanpi(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_tanpi(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_tanpi(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_tanpi(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_tanpi(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_tanpi(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_tanpi(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_tanpi(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_tanpi(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_asinpi(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_asinpi(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_asinpi(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_asinpi(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_asinpi(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_asinpi(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_asinpi(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_asinpi(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_asinpi(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_asinpi(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_asinpi(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_asinpi(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_acospi(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_acospi(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_acospi(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_acospi(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_acospi(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_acospi(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_acospi(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_acospi(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_acospi(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_acospi(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_acospi(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_acospi(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_atanpi(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_atanpi(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_atanpi(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_atanpi(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_atanpi(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_atanpi(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_atanpi(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_atanpi(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_atanpi(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_atanpi(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_atanpi(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_atanpi(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_degrees(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_degrees(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_degrees(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_degrees(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_degrees(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_degrees(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_degrees(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_degrees(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_degrees(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_degrees(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_degrees(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_degrees(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_radians(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_radians(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_radians(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_radians(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_radians(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_radians(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_radians(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_radians(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_radians(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_radians(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_radians(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_radians(float16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_powr(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_powr(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_powr(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_powr(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_powr(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_powr(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_powr(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_powr(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_powr(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_powr(float4 __x, float4 __y);
float8  __attribute__((__overloadable__)) __spirv_ocl_powr(float8 __x, float8 __y);
float16  __attribute__((__overloadable__)) __spirv_ocl_powr(float16 __x, float16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_step(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_step(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_step(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_step(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_step(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_step(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_step(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_step(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_step(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_step(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_step(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_step(float16 __x, float16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_atan2pi(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_atan2pi(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_atan2pi(float16 __x, float16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_maxmag(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_maxmag(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_maxmag(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_maxmag(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_maxmag(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_maxmag(float16 __x, float16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_minmag(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_minmag(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_minmag(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_minmag(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_minmag(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_minmag(float16 __x, float16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_maxmag(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_maxmag(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_maxmag(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_maxmag(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_maxmag(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_maxmag(double16 __x, double16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_minmag(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_minmag(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_minmag(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_minmag(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_minmag(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_minmag(double16 __x, double16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_pown(double __x, int __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_pown(double2 __x, int2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_pown(double3 __x, int3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_pown(double4 __x, int4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_pown(double8 __x, int8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_pown(double16 __x, int16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_pown(float __x, int __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_pown(float2 __x, int2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_pown(float3 __x, int3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_pown(float4 __x, int4 __y);
float8  __attribute__((__overloadable__)) __spirv_ocl_pown(float8 __x, int8 __y);
float16  __attribute__((__overloadable__)) __spirv_ocl_pown(float16 __x, int16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_rootn(double __x, int __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_rootn(double2 __x, int2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_rootn(double3 __x, int3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_rootn(double4 __x, int4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_rootn(double8 __x, int8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_rootn(double16 __x, int16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_rootn(float __x, int __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_rootn(float2 __x, int2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_rootn(float3 __x, int3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_rootn(float4 __x, int4 __y);
float8  __attribute__((__overloadable__)) __spirv_ocl_rootn(float8 __x, int8 __y);
float16  __attribute__((__overloadable__)) __spirv_ocl_rootn(float16 __x, int16 __y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__)) log10(double __x);
inline double __attribute__((__overloadable__)) log10(double __x){  return (double) __spirv_ocl_log10(__x); }
inline double2 __attribute__((__overloadable__)) log10(double2 __x );
inline double2 __attribute__((__overloadable__)) log10(double2 __x ){ return (double2)( __spirv_ocl_log10(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) log10(double3 __x );
inline double3 __attribute__((__overloadable__)) log10(double3 __x ){ return (double3)( __spirv_ocl_log10(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) log10(double4 __x );
inline double4 __attribute__((__overloadable__)) log10(double4 __x ){ return (double4)( __spirv_ocl_log10(__x)); }
inline double8 __attribute__((__overloadable__)) log10(double8 __x );
inline double8 __attribute__((__overloadable__)) log10(double8 __x ){ return (double8)( __spirv_ocl_log10(__x)); }
inline double16 __attribute__((__overloadable__)) log10(double16 __x );
inline double16 __attribute__((__overloadable__)) log10(double16 __x ){ return (double16)( __spirv_ocl_log10(__x)); }
inline double __attribute__((__overloadable__)) log2(double __x);
inline double __attribute__((__overloadable__)) log2(double __x){  return (double) __spirv_ocl_log2(__x); }
inline double2 __attribute__((__overloadable__)) log2(double2 __x );
inline double2 __attribute__((__overloadable__)) log2(double2 __x ){ return (double2)( __spirv_ocl_log2(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) log2(double3 __x );
inline double3 __attribute__((__overloadable__)) log2(double3 __x ){ return (double3)( __spirv_ocl_log2(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) log2(double4 __x );
inline double4 __attribute__((__overloadable__)) log2(double4 __x ){ return (double4)( __spirv_ocl_log2(__x)); }
inline double8 __attribute__((__overloadable__)) log2(double8 __x );
inline double8 __attribute__((__overloadable__)) log2(double8 __x ){ return (double8)( __spirv_ocl_log2(__x)); }
inline double16 __attribute__((__overloadable__)) log2(double16 __x );
inline double16 __attribute__((__overloadable__)) log2(double16 __x ){ return (double16)( __spirv_ocl_log2(__x)); }
inline double __attribute__((__overloadable__)) log1p(double __x);
inline double __attribute__((__overloadable__)) log1p(double __x){  return (double) __spirv_ocl_log1p(__x); }
inline double2 __attribute__((__overloadable__)) log1p(double2 __x );
inline double2 __attribute__((__overloadable__)) log1p(double2 __x ){ return (double2)( __spirv_ocl_log1p(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) log1p(double3 __x );
inline double3 __attribute__((__overloadable__)) log1p(double3 __x ){ return (double3)( __spirv_ocl_log1p(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) log1p(double4 __x );
inline double4 __attribute__((__overloadable__)) log1p(double4 __x ){ return (double4)( __spirv_ocl_log1p(__x)); }
inline double8 __attribute__((__overloadable__)) log1p(double8 __x );
inline double8 __attribute__((__overloadable__)) log1p(double8 __x ){ return (double8)( __spirv_ocl_log1p(__x)); }
inline double16 __attribute__((__overloadable__)) log1p(double16 __x );
inline double16 __attribute__((__overloadable__)) log1p(double16 __x ){ return (double16)( __spirv_ocl_log1p(__x)); }
inline double __attribute__((__overloadable__)) log(double __x);
inline double __attribute__((__overloadable__)) log(double __x){  return (double) __spirv_ocl_log(__x); }
inline double2 __attribute__((__overloadable__)) log(double2 __x );
inline double2 __attribute__((__overloadable__)) log(double2 __x ){ return (double2)( __spirv_ocl_log(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) log(double3 __x );
inline double3 __attribute__((__overloadable__)) log(double3 __x ){ return (double3)( __spirv_ocl_log(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) log(double4 __x );
inline double4 __attribute__((__overloadable__)) log(double4 __x ){ return (double4)( __spirv_ocl_log(__x)); }
inline double8 __attribute__((__overloadable__)) log(double8 __x );
inline double8 __attribute__((__overloadable__)) log(double8 __x ){ return (double8)( __spirv_ocl_log(__x)); }
inline double16 __attribute__((__overloadable__)) log(double16 __x );
inline double16 __attribute__((__overloadable__)) log(double16 __x ){ return (double16)( __spirv_ocl_log(__x)); }
inline double __attribute__((__overloadable__)) sqrt(double __x);
inline double __attribute__((__overloadable__)) sqrt(double __x){  return (double) __spirv_ocl_sqrt(__x); }
inline double2 __attribute__((__overloadable__)) sqrt(double2 __x );
inline double2 __attribute__((__overloadable__)) sqrt(double2 __x ){ return (double2)( __spirv_ocl_sqrt(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) sqrt(double3 __x );
inline double3 __attribute__((__overloadable__)) sqrt(double3 __x ){ return (double3)( __spirv_ocl_sqrt(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) sqrt(double4 __x );
inline double4 __attribute__((__overloadable__)) sqrt(double4 __x ){ return (double4)( __spirv_ocl_sqrt(__x)); }
inline double8 __attribute__((__overloadable__)) sqrt(double8 __x );
inline double8 __attribute__((__overloadable__)) sqrt(double8 __x ){ return (double8)( __spirv_ocl_sqrt(__x)); }
inline double16 __attribute__((__overloadable__)) sqrt(double16 __x );
inline double16 __attribute__((__overloadable__)) sqrt(double16 __x ){ return (double16)( __spirv_ocl_sqrt(__x)); }
inline double __attribute__((__overloadable__)) exp(double __x);
inline double __attribute__((__overloadable__)) exp(double __x){  return (double) __spirv_ocl_exp(__x); }
inline double2 __attribute__((__overloadable__)) exp(double2 __x );
inline double2 __attribute__((__overloadable__)) exp(double2 __x ){ return (double2)( __spirv_ocl_exp(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) exp(double3 __x );
inline double3 __attribute__((__overloadable__)) exp(double3 __x ){ return (double3)( __spirv_ocl_exp(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) exp(double4 __x );
inline double4 __attribute__((__overloadable__)) exp(double4 __x ){ return (double4)( __spirv_ocl_exp(__x)); }
inline double8 __attribute__((__overloadable__)) exp(double8 __x );
inline double8 __attribute__((__overloadable__)) exp(double8 __x ){ return (double8)( __spirv_ocl_exp(__x)); }
inline double16 __attribute__((__overloadable__)) exp(double16 __x );
inline double16 __attribute__((__overloadable__)) exp(double16 __x ){ return (double16)( __spirv_ocl_exp(__x)); }
inline double __attribute__((__overloadable__)) exp2(double __x);
inline double __attribute__((__overloadable__)) exp2(double __x){  return (double) __spirv_ocl_exp2(__x); }
inline double2 __attribute__((__overloadable__)) exp2(double2 __x );
inline double2 __attribute__((__overloadable__)) exp2(double2 __x ){ return (double2)( __spirv_ocl_exp2(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) exp2(double3 __x );
inline double3 __attribute__((__overloadable__)) exp2(double3 __x ){ return (double3)( __spirv_ocl_exp2(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) exp2(double4 __x );
inline double4 __attribute__((__overloadable__)) exp2(double4 __x ){ return (double4)( __spirv_ocl_exp2(__x)); }
inline double8 __attribute__((__overloadable__)) exp2(double8 __x );
inline double8 __attribute__((__overloadable__)) exp2(double8 __x ){ return (double8)( __spirv_ocl_exp2(__x)); }
inline double16 __attribute__((__overloadable__)) exp2(double16 __x );
inline double16 __attribute__((__overloadable__)) exp2(double16 __x ){ return (double16)( __spirv_ocl_exp2(__x)); }
inline double __attribute__((__overloadable__)) ldexp(double __x, int __y);
inline double __attribute__((__overloadable__)) ldexp(double __x, int __y){  return __spirv_ocl_ldexp(__x, __y); }
inline double2 __attribute__((__overloadable__)) ldexp(double2 __x, int2 __y);
inline double2 __attribute__((__overloadable__)) ldexp(double2 __x, int2 __y){  return (double2)(__spirv_ocl_ldexp(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) ldexp(double3 __x, int3 __y);
inline double3 __attribute__((__overloadable__)) ldexp(double3 __x, int3 __y){  return (double3)(__spirv_ocl_ldexp(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) ldexp(double4 __x, int4 __y);
inline double4 __attribute__((__overloadable__)) ldexp(double4 __x, int4 __y){  return (double4)(__spirv_ocl_ldexp(__x, __y)); }
inline double8 __attribute__((__overloadable__)) ldexp(double8 __x, int8 __y);
inline double8 __attribute__((__overloadable__)) ldexp(double8 __x, int8 __y){  return (double8)(__spirv_ocl_ldexp(__x, __y)); }
inline double16 __attribute__((__overloadable__)) ldexp(double16 __x, int16 __y);
inline double16 __attribute__((__overloadable__)) ldexp(double16 __x, int16 __y){  return (double16)(__spirv_ocl_ldexp(__x, __y)); }
inline double __attribute__((__overloadable__)) sin(double __x);
inline double __attribute__((__overloadable__)) sin(double __x){  return (double) __spirv_ocl_sin(__x); }
inline double2 __attribute__((__overloadable__)) sin(double2 __x );
inline double2 __attribute__((__overloadable__)) sin(double2 __x ){ return (double2)( __spirv_ocl_sin(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) sin(double3 __x );
inline double3 __attribute__((__overloadable__)) sin(double3 __x ){ return (double3)( __spirv_ocl_sin(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) sin(double4 __x );
inline double4 __attribute__((__overloadable__)) sin(double4 __x ){ return (double4)( __spirv_ocl_sin(__x)); }
inline double8 __attribute__((__overloadable__)) sin(double8 __x );
inline double8 __attribute__((__overloadable__)) sin(double8 __x ){ return (double8)( __spirv_ocl_sin(__x)); }
inline double16 __attribute__((__overloadable__)) sin(double16 __x );
inline double16 __attribute__((__overloadable__)) sin(double16 __x ){ return (double16)( __spirv_ocl_sin(__x)); }
inline double __attribute__((__overloadable__)) cos(double __x);
inline double __attribute__((__overloadable__)) cos(double __x){  return (double) __spirv_ocl_cos(__x); }
inline double2 __attribute__((__overloadable__)) cos(double2 __x );
inline double2 __attribute__((__overloadable__)) cos(double2 __x ){ return (double2)( __spirv_ocl_cos(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) cos(double3 __x );
inline double3 __attribute__((__overloadable__)) cos(double3 __x ){ return (double3)( __spirv_ocl_cos(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) cos(double4 __x );
inline double4 __attribute__((__overloadable__)) cos(double4 __x ){ return (double4)( __spirv_ocl_cos(__x)); }
inline double8 __attribute__((__overloadable__)) cos(double8 __x );
inline double8 __attribute__((__overloadable__)) cos(double8 __x ){ return (double8)( __spirv_ocl_cos(__x)); }
inline double16 __attribute__((__overloadable__)) cos(double16 __x );
inline double16 __attribute__((__overloadable__)) cos(double16 __x ){ return (double16)( __spirv_ocl_cos(__x)); }
inline double __attribute__((__overloadable__)) tan(double __x);
inline double __attribute__((__overloadable__)) tan(double __x){  return (double) __spirv_ocl_tan(__x); }
inline double2 __attribute__((__overloadable__)) tan(double2 __x );
inline double2 __attribute__((__overloadable__)) tan(double2 __x ){ return (double2)( __spirv_ocl_tan(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) tan(double3 __x );
inline double3 __attribute__((__overloadable__)) tan(double3 __x ){ return (double3)( __spirv_ocl_tan(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) tan(double4 __x );
inline double4 __attribute__((__overloadable__)) tan(double4 __x ){ return (double4)( __spirv_ocl_tan(__x)); }
inline double8 __attribute__((__overloadable__)) tan(double8 __x );
inline double8 __attribute__((__overloadable__)) tan(double8 __x ){ return (double8)( __spirv_ocl_tan(__x)); }
inline double16 __attribute__((__overloadable__)) tan(double16 __x );
inline double16 __attribute__((__overloadable__)) tan(double16 __x ){ return (double16)( __spirv_ocl_tan(__x)); }
inline double __attribute__((__overloadable__)) asin(double __x);
inline double __attribute__((__overloadable__)) asin(double __x){  return (double) __spirv_ocl_asin(__x); }
inline double2 __attribute__((__overloadable__)) asin(double2 __x );
inline double2 __attribute__((__overloadable__)) asin(double2 __x ){ return (double2)( __spirv_ocl_asin(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) asin(double3 __x );
inline double3 __attribute__((__overloadable__)) asin(double3 __x ){ return (double3)( __spirv_ocl_asin(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) asin(double4 __x );
inline double4 __attribute__((__overloadable__)) asin(double4 __x ){ return (double4)( __spirv_ocl_asin(__x)); }
inline double8 __attribute__((__overloadable__)) asin(double8 __x );
inline double8 __attribute__((__overloadable__)) asin(double8 __x ){ return (double8)( __spirv_ocl_asin(__x)); }
inline double16 __attribute__((__overloadable__)) asin(double16 __x );
inline double16 __attribute__((__overloadable__)) asin(double16 __x ){ return (double16)( __spirv_ocl_asin(__x)); }
inline double __attribute__((__overloadable__)) acos(double __x);
inline double __attribute__((__overloadable__)) acos(double __x){  return (double) __spirv_ocl_acos(__x); }
inline double2 __attribute__((__overloadable__)) acos(double2 __x );
inline double2 __attribute__((__overloadable__)) acos(double2 __x ){ return (double2)( __spirv_ocl_acos(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) acos(double3 __x );
inline double3 __attribute__((__overloadable__)) acos(double3 __x ){ return (double3)( __spirv_ocl_acos(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) acos(double4 __x );
inline double4 __attribute__((__overloadable__)) acos(double4 __x ){ return (double4)( __spirv_ocl_acos(__x)); }
inline double8 __attribute__((__overloadable__)) acos(double8 __x );
inline double8 __attribute__((__overloadable__)) acos(double8 __x ){ return (double8)( __spirv_ocl_acos(__x)); }
inline double16 __attribute__((__overloadable__)) acos(double16 __x );
inline double16 __attribute__((__overloadable__)) acos(double16 __x ){ return (double16)( __spirv_ocl_acos(__x)); }
inline double __attribute__((__overloadable__)) atan(double __x);
inline double __attribute__((__overloadable__)) atan(double __x){  return (double) __spirv_ocl_atan(__x); }
inline double2 __attribute__((__overloadable__)) atan(double2 __x );
inline double2 __attribute__((__overloadable__)) atan(double2 __x ){ return (double2)( __spirv_ocl_atan(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) atan(double3 __x );
inline double3 __attribute__((__overloadable__)) atan(double3 __x ){ return (double3)( __spirv_ocl_atan(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) atan(double4 __x );
inline double4 __attribute__((__overloadable__)) atan(double4 __x ){ return (double4)( __spirv_ocl_atan(__x)); }
inline double8 __attribute__((__overloadable__)) atan(double8 __x );
inline double8 __attribute__((__overloadable__)) atan(double8 __x ){ return (double8)( __spirv_ocl_atan(__x)); }
inline double16 __attribute__((__overloadable__)) atan(double16 __x );
inline double16 __attribute__((__overloadable__)) atan(double16 __x ){ return (double16)( __spirv_ocl_atan(__x)); }
inline double __attribute__((__overloadable__)) sinh(double __x);
inline double __attribute__((__overloadable__)) sinh(double __x){  return (double) __spirv_ocl_sinh(__x); }
inline double2 __attribute__((__overloadable__)) sinh(double2 __x );
inline double2 __attribute__((__overloadable__)) sinh(double2 __x ){ return (double2)( __spirv_ocl_sinh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) sinh(double3 __x );
inline double3 __attribute__((__overloadable__)) sinh(double3 __x ){ return (double3)( __spirv_ocl_sinh(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) sinh(double4 __x );
inline double4 __attribute__((__overloadable__)) sinh(double4 __x ){ return (double4)( __spirv_ocl_sinh(__x)); }
inline double8 __attribute__((__overloadable__)) sinh(double8 __x );
inline double8 __attribute__((__overloadable__)) sinh(double8 __x ){ return (double8)( __spirv_ocl_sinh(__x)); }
inline double16 __attribute__((__overloadable__)) sinh(double16 __x );
inline double16 __attribute__((__overloadable__)) sinh(double16 __x ){ return (double16)( __spirv_ocl_sinh(__x)); }
inline double __attribute__((__overloadable__)) cosh(double __x);
inline double __attribute__((__overloadable__)) cosh(double __x){  return (double) __spirv_ocl_cosh(__x); }
inline double2 __attribute__((__overloadable__)) cosh(double2 __x );
inline double2 __attribute__((__overloadable__)) cosh(double2 __x ){ return (double2)( __spirv_ocl_cosh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) cosh(double3 __x );
inline double3 __attribute__((__overloadable__)) cosh(double3 __x ){ return (double3)( __spirv_ocl_cosh(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) cosh(double4 __x );
inline double4 __attribute__((__overloadable__)) cosh(double4 __x ){ return (double4)( __spirv_ocl_cosh(__x)); }
inline double8 __attribute__((__overloadable__)) cosh(double8 __x );
inline double8 __attribute__((__overloadable__)) cosh(double8 __x ){ return (double8)( __spirv_ocl_cosh(__x)); }
inline double16 __attribute__((__overloadable__)) cosh(double16 __x );
inline double16 __attribute__((__overloadable__)) cosh(double16 __x ){ return (double16)( __spirv_ocl_cosh(__x)); }
inline double __attribute__((__overloadable__)) tanh(double __x);
inline double __attribute__((__overloadable__)) tanh(double __x){  return (double) __spirv_ocl_tanh(__x); }
inline double2 __attribute__((__overloadable__)) tanh(double2 __x );
inline double2 __attribute__((__overloadable__)) tanh(double2 __x ){ return (double2)( __spirv_ocl_tanh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) tanh(double3 __x );
inline double3 __attribute__((__overloadable__)) tanh(double3 __x ){ return (double3)( __spirv_ocl_tanh(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) tanh(double4 __x );
inline double4 __attribute__((__overloadable__)) tanh(double4 __x ){ return (double4)( __spirv_ocl_tanh(__x)); }
inline double8 __attribute__((__overloadable__)) tanh(double8 __x );
inline double8 __attribute__((__overloadable__)) tanh(double8 __x ){ return (double8)( __spirv_ocl_tanh(__x)); }
inline double16 __attribute__((__overloadable__)) tanh(double16 __x );
inline double16 __attribute__((__overloadable__)) tanh(double16 __x ){ return (double16)( __spirv_ocl_tanh(__x)); }
inline double __attribute__((__overloadable__)) asinh(double __x);
inline double __attribute__((__overloadable__)) asinh(double __x){  return (double) __spirv_ocl_asinh(__x); }
inline double2 __attribute__((__overloadable__)) asinh(double2 __x );
inline double2 __attribute__((__overloadable__)) asinh(double2 __x ){ return (double2)( __spirv_ocl_asinh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) asinh(double3 __x );
inline double3 __attribute__((__overloadable__)) asinh(double3 __x ){ return (double3)( __spirv_ocl_asinh(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) asinh(double4 __x );
inline double4 __attribute__((__overloadable__)) asinh(double4 __x ){ return (double4)( __spirv_ocl_asinh(__x)); }
inline double8 __attribute__((__overloadable__)) asinh(double8 __x );
inline double8 __attribute__((__overloadable__)) asinh(double8 __x ){ return (double8)( __spirv_ocl_asinh(__x)); }
inline double16 __attribute__((__overloadable__)) asinh(double16 __x );
inline double16 __attribute__((__overloadable__)) asinh(double16 __x ){ return (double16)( __spirv_ocl_asinh(__x)); }
inline double __attribute__((__overloadable__)) acosh(double __x);
inline double __attribute__((__overloadable__)) acosh(double __x){  return (double) __spirv_ocl_acosh(__x); }
inline double2 __attribute__((__overloadable__)) acosh(double2 __x );
inline double2 __attribute__((__overloadable__)) acosh(double2 __x ){ return (double2)( __spirv_ocl_acosh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) acosh(double3 __x );
inline double3 __attribute__((__overloadable__)) acosh(double3 __x ){ return (double3)( __spirv_ocl_acosh(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) acosh(double4 __x );
inline double4 __attribute__((__overloadable__)) acosh(double4 __x ){ return (double4)( __spirv_ocl_acosh(__x)); }
inline double8 __attribute__((__overloadable__)) acosh(double8 __x );
inline double8 __attribute__((__overloadable__)) acosh(double8 __x ){ return (double8)( __spirv_ocl_acosh(__x)); }
inline double16 __attribute__((__overloadable__)) acosh(double16 __x );
inline double16 __attribute__((__overloadable__)) acosh(double16 __x ){ return (double16)( __spirv_ocl_acosh(__x)); }
inline double __attribute__((__overloadable__)) atanh(double __x);
inline double __attribute__((__overloadable__)) atanh(double __x){  return (double) __spirv_ocl_atanh(__x); }
inline double2 __attribute__((__overloadable__)) atanh(double2 __x );
inline double2 __attribute__((__overloadable__)) atanh(double2 __x ){ return (double2)( __spirv_ocl_atanh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) atanh(double3 __x );
inline double3 __attribute__((__overloadable__)) atanh(double3 __x ){ return (double3)( __spirv_ocl_atanh(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) atanh(double4 __x );
inline double4 __attribute__((__overloadable__)) atanh(double4 __x ){ return (double4)( __spirv_ocl_atanh(__x)); }
inline double8 __attribute__((__overloadable__)) atanh(double8 __x );
inline double8 __attribute__((__overloadable__)) atanh(double8 __x ){ return (double8)( __spirv_ocl_atanh(__x)); }
inline double16 __attribute__((__overloadable__)) atanh(double16 __x );
inline double16 __attribute__((__overloadable__)) atanh(double16 __x ){ return (double16)( __spirv_ocl_atanh(__x)); }
inline double __attribute__((__overloadable__)) floor(double __x);
inline double __attribute__((__overloadable__)) floor(double __x){  return (double) __spirv_ocl_floor(__x); }
inline double2 __attribute__((__overloadable__)) floor(double2 __x );
inline double2 __attribute__((__overloadable__)) floor(double2 __x ){ return (double2)( __spirv_ocl_floor(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) floor(double3 __x );
inline double3 __attribute__((__overloadable__)) floor(double3 __x ){ return (double3)( __spirv_ocl_floor(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) floor(double4 __x );
inline double4 __attribute__((__overloadable__)) floor(double4 __x ){ return (double4)( __spirv_ocl_floor(__x)); }
inline double8 __attribute__((__overloadable__)) floor(double8 __x );
inline double8 __attribute__((__overloadable__)) floor(double8 __x ){ return (double8)( __spirv_ocl_floor(__x)); }
inline double16 __attribute__((__overloadable__)) floor(double16 __x );
inline double16 __attribute__((__overloadable__)) floor(double16 __x ){ return (double16)( __spirv_ocl_floor(__x)); }
inline double __attribute__((__overloadable__)) ceil(double __x);
inline double __attribute__((__overloadable__)) ceil(double __x){  return (double) __spirv_ocl_ceil(__x); }
inline double2 __attribute__((__overloadable__)) ceil(double2 __x );
inline double2 __attribute__((__overloadable__)) ceil(double2 __x ){ return (double2)( __spirv_ocl_ceil(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) ceil(double3 __x );
inline double3 __attribute__((__overloadable__)) ceil(double3 __x ){ return (double3)( __spirv_ocl_ceil(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) ceil(double4 __x );
inline double4 __attribute__((__overloadable__)) ceil(double4 __x ){ return (double4)( __spirv_ocl_ceil(__x)); }
inline double8 __attribute__((__overloadable__)) ceil(double8 __x );
inline double8 __attribute__((__overloadable__)) ceil(double8 __x ){ return (double8)( __spirv_ocl_ceil(__x)); }
inline double16 __attribute__((__overloadable__)) ceil(double16 __x );
inline double16 __attribute__((__overloadable__)) ceil(double16 __x ){ return (double16)( __spirv_ocl_ceil(__x)); }
inline double __attribute__((__overloadable__)) fabs(double __x);
inline double __attribute__((__overloadable__)) fabs(double __x){  return (double) __spirv_ocl_fabs(__x); }
inline double2 __attribute__((__overloadable__)) fabs(double2 __x );
inline double2 __attribute__((__overloadable__)) fabs(double2 __x ){ return (double2)( __spirv_ocl_fabs(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) fabs(double3 __x );
inline double3 __attribute__((__overloadable__)) fabs(double3 __x ){ return (double3)( __spirv_ocl_fabs(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) fabs(double4 __x );
inline double4 __attribute__((__overloadable__)) fabs(double4 __x ){ return (double4)( __spirv_ocl_fabs(__x)); }
inline double8 __attribute__((__overloadable__)) fabs(double8 __x );
inline double8 __attribute__((__overloadable__)) fabs(double8 __x ){ return (double8)( __spirv_ocl_fabs(__x)); }
inline double16 __attribute__((__overloadable__)) fabs(double16 __x );
inline double16 __attribute__((__overloadable__)) fabs(double16 __x ){ return (double16)( __spirv_ocl_fabs(__x)); }
inline double __attribute__((__overloadable__)) trunc(double __x);
inline double __attribute__((__overloadable__)) trunc(double __x){  return (double) __spirv_ocl_trunc(__x); }
inline double2 __attribute__((__overloadable__)) trunc(double2 __x );
inline double2 __attribute__((__overloadable__)) trunc(double2 __x ){ return (double2)( __spirv_ocl_trunc(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) trunc(double3 __x );
inline double3 __attribute__((__overloadable__)) trunc(double3 __x ){ return (double3)( __spirv_ocl_trunc(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) trunc(double4 __x );
inline double4 __attribute__((__overloadable__)) trunc(double4 __x ){ return (double4)( __spirv_ocl_trunc(__x)); }
inline double8 __attribute__((__overloadable__)) trunc(double8 __x );
inline double8 __attribute__((__overloadable__)) trunc(double8 __x ){ return (double8)( __spirv_ocl_trunc(__x)); }
inline double16 __attribute__((__overloadable__)) trunc(double16 __x );
inline double16 __attribute__((__overloadable__)) trunc(double16 __x ){ return (double16)( __spirv_ocl_trunc(__x)); }
inline double __attribute__((__overloadable__)) pow(double __x, double __y);
inline double __attribute__((__overloadable__)) pow(double __x, double __y){  return (double) __spirv_ocl_pow(__x, __y); }
inline double2 __attribute__((__overloadable__)) pow(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) pow(double2 __x, double2 __y){ return (double2)( __spirv_ocl_pow(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) pow(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) pow(double3 __x, double3 __y){ return (double3)( __spirv_ocl_pow(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) pow(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) pow(double4 __x, double4 __y){ return (double4)( __spirv_ocl_pow(__x, __y)); }
inline double8 __attribute__((__overloadable__)) pow(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) pow(double8 __x, double8 __y){ return (double8)( __spirv_ocl_pow(__x, __y)); }
inline double16 __attribute__((__overloadable__)) pow(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) pow(double16 __x, double16 __y){ return (double16)( __spirv_ocl_pow(__x, __y)); }
inline double __attribute__((__overloadable__)) lgamma(double __x);
inline double __attribute__((__overloadable__)) lgamma(double __x){  return (double) __spirv_ocl_lgamma(__x); }
inline double2 __attribute__((__overloadable__)) lgamma(double2 __x );
inline double2 __attribute__((__overloadable__)) lgamma(double2 __x ){ return (double2)( __spirv_ocl_lgamma(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) lgamma(double3 __x );
inline double3 __attribute__((__overloadable__)) lgamma(double3 __x ){ return (double3)( __spirv_ocl_lgamma(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) lgamma(double4 __x );
inline double4 __attribute__((__overloadable__)) lgamma(double4 __x ){ return (double4)( __spirv_ocl_lgamma(__x)); }
inline double8 __attribute__((__overloadable__)) lgamma(double8 __x );
inline double8 __attribute__((__overloadable__)) lgamma(double8 __x ){ return (double8)( __spirv_ocl_lgamma(__x)); }
inline double16 __attribute__((__overloadable__)) lgamma(double16 __x );
inline double16 __attribute__((__overloadable__)) lgamma(double16 __x ){ return (double16)( __spirv_ocl_lgamma(__x)); }
inline double __attribute__((__overloadable__)) tgamma(double __x);
inline double __attribute__((__overloadable__)) tgamma(double __x){  return (double) __spirv_ocl_tgamma(__x); }
inline double2 __attribute__((__overloadable__)) tgamma(double2 __x );
inline double2 __attribute__((__overloadable__)) tgamma(double2 __x ){ return (double2)( __spirv_ocl_tgamma(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) tgamma(double3 __x );
inline double3 __attribute__((__overloadable__)) tgamma(double3 __x ){ return (double3)( __spirv_ocl_tgamma(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) tgamma(double4 __x );
inline double4 __attribute__((__overloadable__)) tgamma(double4 __x ){ return (double4)( __spirv_ocl_tgamma(__x)); }
inline double8 __attribute__((__overloadable__)) tgamma(double8 __x );
inline double8 __attribute__((__overloadable__)) tgamma(double8 __x ){ return (double8)( __spirv_ocl_tgamma(__x)); }
inline double16 __attribute__((__overloadable__)) tgamma(double16 __x );
inline double16 __attribute__((__overloadable__)) tgamma(double16 __x ){ return (double16)( __spirv_ocl_tgamma(__x)); }
inline double __attribute__((__overloadable__)) erf(double __x);
inline double __attribute__((__overloadable__)) erf(double __x){  return (double) __spirv_ocl_erf(__x); }
inline double2 __attribute__((__overloadable__)) erf(double2 __x );
inline double2 __attribute__((__overloadable__)) erf(double2 __x ){ return (double2)( __spirv_ocl_erf(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) erf(double3 __x );
inline double3 __attribute__((__overloadable__)) erf(double3 __x ){ return (double3)( __spirv_ocl_erf(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) erf(double4 __x );
inline double4 __attribute__((__overloadable__)) erf(double4 __x ){ return (double4)( __spirv_ocl_erf(__x)); }
inline double8 __attribute__((__overloadable__)) erf(double8 __x );
inline double8 __attribute__((__overloadable__)) erf(double8 __x ){ return (double8)( __spirv_ocl_erf(__x)); }
inline double16 __attribute__((__overloadable__)) erf(double16 __x );
inline double16 __attribute__((__overloadable__)) erf(double16 __x ){ return (double16)( __spirv_ocl_erf(__x)); }
inline double __attribute__((__overloadable__)) erfc(double __x);
inline double __attribute__((__overloadable__)) erfc(double __x){  return (double) __spirv_ocl_erfc(__x); }
inline double2 __attribute__((__overloadable__)) erfc(double2 __x );
inline double2 __attribute__((__overloadable__)) erfc(double2 __x ){ return (double2)( __spirv_ocl_erfc(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) erfc(double3 __x );
inline double3 __attribute__((__overloadable__)) erfc(double3 __x ){ return (double3)( __spirv_ocl_erfc(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) erfc(double4 __x );
inline double4 __attribute__((__overloadable__)) erfc(double4 __x ){ return (double4)( __spirv_ocl_erfc(__x)); }
inline double8 __attribute__((__overloadable__)) erfc(double8 __x );
inline double8 __attribute__((__overloadable__)) erfc(double8 __x ){ return (double8)( __spirv_ocl_erfc(__x)); }
inline double16 __attribute__((__overloadable__)) erfc(double16 __x );
inline double16 __attribute__((__overloadable__)) erfc(double16 __x ){ return (double16)( __spirv_ocl_erfc(__x)); }
inline double __attribute__((__overloadable__)) cbrt(double __x);
inline double __attribute__((__overloadable__)) cbrt(double __x){  return (double) __spirv_ocl_cbrt(__x); }
inline double2 __attribute__((__overloadable__)) cbrt(double2 __x );
inline double2 __attribute__((__overloadable__)) cbrt(double2 __x ){ return (double2)( __spirv_ocl_cbrt(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) cbrt(double3 __x );
inline double3 __attribute__((__overloadable__)) cbrt(double3 __x ){ return (double3)( __spirv_ocl_cbrt(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) cbrt(double4 __x );
inline double4 __attribute__((__overloadable__)) cbrt(double4 __x ){ return (double4)( __spirv_ocl_cbrt(__x)); }
inline double8 __attribute__((__overloadable__)) cbrt(double8 __x );
inline double8 __attribute__((__overloadable__)) cbrt(double8 __x ){ return (double8)( __spirv_ocl_cbrt(__x)); }
inline double16 __attribute__((__overloadable__)) cbrt(double16 __x );
inline double16 __attribute__((__overloadable__)) cbrt(double16 __x ){ return (double16)( __spirv_ocl_cbrt(__x)); }
inline double __attribute__((__overloadable__)) expm1(double __x);
inline double __attribute__((__overloadable__)) expm1(double __x){  return (double) __spirv_ocl_expm1(__x); }
inline double2 __attribute__((__overloadable__)) expm1(double2 __x );
inline double2 __attribute__((__overloadable__)) expm1(double2 __x ){ return (double2)( __spirv_ocl_expm1(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) expm1(double3 __x );
inline double3 __attribute__((__overloadable__)) expm1(double3 __x ){ return (double3)( __spirv_ocl_expm1(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) expm1(double4 __x );
inline double4 __attribute__((__overloadable__)) expm1(double4 __x ){ return (double4)( __spirv_ocl_expm1(__x)); }
inline double8 __attribute__((__overloadable__)) expm1(double8 __x );
inline double8 __attribute__((__overloadable__)) expm1(double8 __x ){ return (double8)( __spirv_ocl_expm1(__x)); }
inline double16 __attribute__((__overloadable__)) expm1(double16 __x );
inline double16 __attribute__((__overloadable__)) expm1(double16 __x ){ return (double16)( __spirv_ocl_expm1(__x)); }
inline double __attribute__((__overloadable__)) fdim(double __x, double __y);
inline double __attribute__((__overloadable__)) fdim(double __x, double __y){  return (double) __spirv_ocl_fdim(__x, __y); }
inline double2 __attribute__((__overloadable__)) fdim(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) fdim(double2 __x, double2 __y){ return (double2)( __spirv_ocl_fdim(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) fdim(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) fdim(double3 __x, double3 __y){ return (double3)( __spirv_ocl_fdim(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) fdim(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) fdim(double4 __x, double4 __y){ return (double4)( __spirv_ocl_fdim(__x, __y)); }
inline double8 __attribute__((__overloadable__)) fdim(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) fdim(double8 __x, double8 __y){ return (double8)( __spirv_ocl_fdim(__x, __y)); }
inline double16 __attribute__((__overloadable__)) fdim(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) fdim(double16 __x, double16 __y){ return (double16)( __spirv_ocl_fdim(__x, __y)); }
inline double __attribute__((__overloadable__)) atan2(double __x, double __y);
inline double __attribute__((__overloadable__)) atan2(double __x, double __y){  return (double) __spirv_ocl_atan2(__x, __y); }
inline double2 __attribute__((__overloadable__)) atan2(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) atan2(double2 __x, double2 __y){ return (double2)( __spirv_ocl_atan2(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) atan2(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) atan2(double3 __x, double3 __y){ return (double3)( __spirv_ocl_atan2(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) atan2(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) atan2(double4 __x, double4 __y){ return (double4)( __spirv_ocl_atan2(__x, __y)); }
inline double8 __attribute__((__overloadable__)) atan2(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) atan2(double8 __x, double8 __y){ return (double8)( __spirv_ocl_atan2(__x, __y)); }
inline double16 __attribute__((__overloadable__)) atan2(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) atan2(double16 __x, double16 __y){ return (double16)( __spirv_ocl_atan2(__x, __y)); }
inline double __attribute__((__overloadable__)) hypot(double __x, double __y);
inline double __attribute__((__overloadable__)) hypot(double __x, double __y){  return (double) __spirv_ocl_hypot(__x, __y); }
inline double2 __attribute__((__overloadable__)) hypot(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) hypot(double2 __x, double2 __y){ return (double2)( __spirv_ocl_hypot(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) hypot(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) hypot(double3 __x, double3 __y){ return (double3)( __spirv_ocl_hypot(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) hypot(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) hypot(double4 __x, double4 __y){ return (double4)( __spirv_ocl_hypot(__x, __y)); }
inline double8 __attribute__((__overloadable__)) hypot(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) hypot(double8 __x, double8 __y){ return (double8)( __spirv_ocl_hypot(__x, __y)); }
inline double16 __attribute__((__overloadable__)) hypot(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) hypot(double16 __x, double16 __y){ return (double16)( __spirv_ocl_hypot(__x, __y)); }
inline double __attribute__((__overloadable__)) exp10(double __x);
inline double __attribute__((__overloadable__)) exp10(double __x){  return (double) __spirv_ocl_exp(__x); }
inline double2 __attribute__((__overloadable__)) exp10(double2 __x );
inline double2 __attribute__((__overloadable__)) exp10(double2 __x ){ return (double2)( __spirv_ocl_exp(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) exp10(double3 __x );
inline double3 __attribute__((__overloadable__)) exp10(double3 __x ){ return (double3)( __spirv_ocl_exp(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) exp10(double4 __x );
inline double4 __attribute__((__overloadable__)) exp10(double4 __x ){ return (double4)( __spirv_ocl_exp(__x)); }
inline double8 __attribute__((__overloadable__)) exp10(double8 __x );
inline double8 __attribute__((__overloadable__)) exp10(double8 __x ){ return (double8)( __spirv_ocl_exp(__x)); }
inline double16 __attribute__((__overloadable__)) exp10(double16 __x );
inline double16 __attribute__((__overloadable__)) exp10(double16 __x ){ return (double16)( __spirv_ocl_exp(__x)); }
inline double __attribute__((__overloadable__)) rsqrt(double __x);
inline double __attribute__((__overloadable__)) rsqrt(double __x){  return (double) __spirv_ocl_rsqrt(__x); }
inline double2 __attribute__((__overloadable__)) rsqrt(double2 __x );
inline double2 __attribute__((__overloadable__)) rsqrt(double2 __x ){ return (double2)( __spirv_ocl_rsqrt(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) rsqrt(double3 __x );
inline double3 __attribute__((__overloadable__)) rsqrt(double3 __x ){ return (double3)( __spirv_ocl_rsqrt(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) rsqrt(double4 __x );
inline double4 __attribute__((__overloadable__)) rsqrt(double4 __x ){ return (double4)( __spirv_ocl_rsqrt(__x)); }
inline double8 __attribute__((__overloadable__)) rsqrt(double8 __x );
inline double8 __attribute__((__overloadable__)) rsqrt(double8 __x ){ return (double8)( __spirv_ocl_rsqrt(__x)); }
inline double16 __attribute__((__overloadable__)) rsqrt(double16 __x );
inline double16 __attribute__((__overloadable__)) rsqrt(double16 __x ){ return (double16)( __spirv_ocl_rsqrt(__x)); }
inline double __attribute__((__overloadable__)) sinpi(double __x);
inline double __attribute__((__overloadable__)) sinpi(double __x){  return (double) __spirv_ocl_sinpi(__x); }
inline double2 __attribute__((__overloadable__)) sinpi(double2 __x );
inline double2 __attribute__((__overloadable__)) sinpi(double2 __x ){ return (double2)( __spirv_ocl_sinpi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) sinpi(double3 __x );
inline double3 __attribute__((__overloadable__)) sinpi(double3 __x ){ return (double3)( __spirv_ocl_sinpi(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) sinpi(double4 __x );
inline double4 __attribute__((__overloadable__)) sinpi(double4 __x ){ return (double4)( __spirv_ocl_sinpi(__x)); }
inline double8 __attribute__((__overloadable__)) sinpi(double8 __x );
inline double8 __attribute__((__overloadable__)) sinpi(double8 __x ){ return (double8)( __spirv_ocl_sinpi(__x)); }
inline double16 __attribute__((__overloadable__)) sinpi(double16 __x );
inline double16 __attribute__((__overloadable__)) sinpi(double16 __x ){ return (double16)( __spirv_ocl_sinpi(__x)); }
inline double __attribute__((__overloadable__)) cospi(double __x);
inline double __attribute__((__overloadable__)) cospi(double __x){  return (double) __spirv_ocl_cospi(__x); }
inline double2 __attribute__((__overloadable__)) cospi(double2 __x );
inline double2 __attribute__((__overloadable__)) cospi(double2 __x ){ return (double2)( __spirv_ocl_cospi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) cospi(double3 __x );
inline double3 __attribute__((__overloadable__)) cospi(double3 __x ){ return (double3)( __spirv_ocl_cospi(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) cospi(double4 __x );
inline double4 __attribute__((__overloadable__)) cospi(double4 __x ){ return (double4)( __spirv_ocl_cospi(__x)); }
inline double8 __attribute__((__overloadable__)) cospi(double8 __x );
inline double8 __attribute__((__overloadable__)) cospi(double8 __x ){ return (double8)( __spirv_ocl_cospi(__x)); }
inline double16 __attribute__((__overloadable__)) cospi(double16 __x );
inline double16 __attribute__((__overloadable__)) cospi(double16 __x ){ return (double16)( __spirv_ocl_cospi(__x)); }
inline double __attribute__((__overloadable__)) tanpi(double __x);
inline double __attribute__((__overloadable__)) tanpi(double __x){  return (double) __spirv_ocl_tanpi(__x); }
inline double2 __attribute__((__overloadable__)) tanpi(double2 __x );
inline double2 __attribute__((__overloadable__)) tanpi(double2 __x ){ return (double2)( __spirv_ocl_tanpi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) tanpi(double3 __x );
inline double3 __attribute__((__overloadable__)) tanpi(double3 __x ){ return (double3)( __spirv_ocl_tanpi(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) tanpi(double4 __x );
inline double4 __attribute__((__overloadable__)) tanpi(double4 __x ){ return (double4)( __spirv_ocl_tanpi(__x)); }
inline double8 __attribute__((__overloadable__)) tanpi(double8 __x );
inline double8 __attribute__((__overloadable__)) tanpi(double8 __x ){ return (double8)( __spirv_ocl_tanpi(__x)); }
inline double16 __attribute__((__overloadable__)) tanpi(double16 __x );
inline double16 __attribute__((__overloadable__)) tanpi(double16 __x ){ return (double16)( __spirv_ocl_tanpi(__x)); }
inline double __attribute__((__overloadable__)) asinpi(double __x);
inline double __attribute__((__overloadable__)) asinpi(double __x){  return (double) __spirv_ocl_asinpi(__x); }
inline double2 __attribute__((__overloadable__)) asinpi(double2 __x );
inline double2 __attribute__((__overloadable__)) asinpi(double2 __x ){ return (double2)( __spirv_ocl_asinpi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) asinpi(double3 __x );
inline double3 __attribute__((__overloadable__)) asinpi(double3 __x ){ return (double3)( __spirv_ocl_asinpi(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) asinpi(double4 __x );
inline double4 __attribute__((__overloadable__)) asinpi(double4 __x ){ return (double4)( __spirv_ocl_asinpi(__x)); }
inline double8 __attribute__((__overloadable__)) asinpi(double8 __x );
inline double8 __attribute__((__overloadable__)) asinpi(double8 __x ){ return (double8)( __spirv_ocl_asinpi(__x)); }
inline double16 __attribute__((__overloadable__)) asinpi(double16 __x );
inline double16 __attribute__((__overloadable__)) asinpi(double16 __x ){ return (double16)( __spirv_ocl_asinpi(__x)); }
inline double __attribute__((__overloadable__)) acospi(double __x);
inline double __attribute__((__overloadable__)) acospi(double __x){  return (double) __spirv_ocl_acospi(__x); }
inline double2 __attribute__((__overloadable__)) acospi(double2 __x );
inline double2 __attribute__((__overloadable__)) acospi(double2 __x ){ return (double2)( __spirv_ocl_acospi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) acospi(double3 __x );
inline double3 __attribute__((__overloadable__)) acospi(double3 __x ){ return (double3)( __spirv_ocl_acospi(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) acospi(double4 __x );
inline double4 __attribute__((__overloadable__)) acospi(double4 __x ){ return (double4)( __spirv_ocl_acospi(__x)); }
inline double8 __attribute__((__overloadable__)) acospi(double8 __x );
inline double8 __attribute__((__overloadable__)) acospi(double8 __x ){ return (double8)( __spirv_ocl_acospi(__x)); }
inline double16 __attribute__((__overloadable__)) acospi(double16 __x );
inline double16 __attribute__((__overloadable__)) acospi(double16 __x ){ return (double16)( __spirv_ocl_acospi(__x)); }
inline double __attribute__((__overloadable__)) atanpi(double __x);
inline double __attribute__((__overloadable__)) atanpi(double __x){  return (double) __spirv_ocl_atanpi(__x); }
inline double2 __attribute__((__overloadable__)) atanpi(double2 __x );
inline double2 __attribute__((__overloadable__)) atanpi(double2 __x ){ return (double2)( __spirv_ocl_atanpi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) atanpi(double3 __x );
inline double3 __attribute__((__overloadable__)) atanpi(double3 __x ){ return (double3)( __spirv_ocl_atanpi(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) atanpi(double4 __x );
inline double4 __attribute__((__overloadable__)) atanpi(double4 __x ){ return (double4)( __spirv_ocl_atanpi(__x)); }
inline double8 __attribute__((__overloadable__)) atanpi(double8 __x );
inline double8 __attribute__((__overloadable__)) atanpi(double8 __x ){ return (double8)( __spirv_ocl_atanpi(__x)); }
inline double16 __attribute__((__overloadable__)) atanpi(double16 __x );
inline double16 __attribute__((__overloadable__)) atanpi(double16 __x ){ return (double16)( __spirv_ocl_atanpi(__x)); }
inline double __attribute__((__overloadable__)) degrees(double __x);
inline double __attribute__((__overloadable__)) degrees(double __x){  return (double) __spirv_ocl_degrees(__x); }
inline double2 __attribute__((__overloadable__)) degrees(double2 __x );
inline double2 __attribute__((__overloadable__)) degrees(double2 __x ){ return (double2)( __spirv_ocl_degrees(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) degrees(double3 __x );
inline double3 __attribute__((__overloadable__)) degrees(double3 __x ){ return (double3)( __spirv_ocl_degrees(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) degrees(double4 __x );
inline double4 __attribute__((__overloadable__)) degrees(double4 __x ){ return (double4)( __spirv_ocl_degrees(__x)); }
inline double8 __attribute__((__overloadable__)) degrees(double8 __x );
inline double8 __attribute__((__overloadable__)) degrees(double8 __x ){ return (double8)( __spirv_ocl_degrees(__x)); }
inline double16 __attribute__((__overloadable__)) degrees(double16 __x );
inline double16 __attribute__((__overloadable__)) degrees(double16 __x ){ return (double16)( __spirv_ocl_degrees(__x)); }
inline double __attribute__((__overloadable__)) radians(double __x);
inline double __attribute__((__overloadable__)) radians(double __x){  return (double) __spirv_ocl_radians(__x); }
inline double2 __attribute__((__overloadable__)) radians(double2 __x );
inline double2 __attribute__((__overloadable__)) radians(double2 __x ){ return (double2)( __spirv_ocl_radians(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) radians(double3 __x );
inline double3 __attribute__((__overloadable__)) radians(double3 __x ){ return (double3)( __spirv_ocl_radians(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) radians(double4 __x );
inline double4 __attribute__((__overloadable__)) radians(double4 __x ){ return (double4)( __spirv_ocl_radians(__x)); }
inline double8 __attribute__((__overloadable__)) radians(double8 __x );
inline double8 __attribute__((__overloadable__)) radians(double8 __x ){ return (double8)( __spirv_ocl_radians(__x)); }
inline double16 __attribute__((__overloadable__)) radians(double16 __x );
inline double16 __attribute__((__overloadable__)) radians(double16 __x ){ return (double16)( __spirv_ocl_radians(__x)); }
inline double __attribute__((__overloadable__)) powr(double __x, double __y);
inline double __attribute__((__overloadable__)) powr(double __x, double __y){  return (double) __spirv_ocl_powr(__x, __y); }
inline double2 __attribute__((__overloadable__)) powr(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) powr(double2 __x, double2 __y){ return (double2)( __spirv_ocl_powr(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) powr(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) powr(double3 __x, double3 __y){ return (double3)( __spirv_ocl_powr(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) powr(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) powr(double4 __x, double4 __y){ return (double4)( __spirv_ocl_powr(__x, __y)); }
inline double8 __attribute__((__overloadable__)) powr(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) powr(double8 __x, double8 __y){ return (double8)( __spirv_ocl_powr(__x, __y)); }
inline double16 __attribute__((__overloadable__)) powr(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) powr(double16 __x, double16 __y){ return (double16)( __spirv_ocl_powr(__x, __y)); }
inline double __attribute__((__overloadable__)) step(double __x, double __y);
inline double __attribute__((__overloadable__)) step(double __x, double __y){  return (double) __spirv_ocl_step(__x, __y); }
inline double2 __attribute__((__overloadable__)) step(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) step(double2 __x, double2 __y){ return (double2)( __spirv_ocl_step(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) step(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) step(double3 __x, double3 __y){ return (double3)( __spirv_ocl_step(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) step(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) step(double4 __x, double4 __y){ return (double4)( __spirv_ocl_step(__x, __y)); }
inline double8 __attribute__((__overloadable__)) step(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) step(double8 __x, double8 __y){ return (double8)( __spirv_ocl_step(__x, __y)); }
inline double16 __attribute__((__overloadable__)) step(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) step(double16 __x, double16 __y){ return (double16)( __spirv_ocl_step(__x, __y)); }
inline double __attribute__((__overloadable__)) atan2pi(double __x, double __y);
inline double __attribute__((__overloadable__)) atan2pi(double __x, double __y){  return (double) __spirv_ocl_atan2pi(__x, __y); }
inline double2 __attribute__((__overloadable__)) atan2pi(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) atan2pi(double2 __x, double2 __y){ return (double2)( __spirv_ocl_atan2pi(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) atan2pi(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) atan2pi(double3 __x, double3 __y){ return (double3)( __spirv_ocl_atan2pi(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) atan2pi(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) atan2pi(double4 __x, double4 __y){ return (double4)( __spirv_ocl_atan2pi(__x, __y)); }
inline double8 __attribute__((__overloadable__)) atan2pi(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) atan2pi(double8 __x, double8 __y){ return (double8)( __spirv_ocl_atan2pi(__x, __y)); }
inline double16 __attribute__((__overloadable__)) atan2pi(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) atan2pi(double16 __x, double16 __y){ return (double16)( __spirv_ocl_atan2pi(__x, __y)); }
inline double __attribute__((__overloadable__)) maxmag(double __x, double __y);
inline double __attribute__((__overloadable__)) maxmag(double __x, double __y){  return (double) __spirv_ocl_maxmag(__x, __y); }
inline double2 __attribute__((__overloadable__)) maxmag(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) maxmag(double2 __x, double2 __y){ return (double2)( __spirv_ocl_maxmag(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) maxmag(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) maxmag(double3 __x, double3 __y){ return (double3)( __spirv_ocl_maxmag(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) maxmag(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) maxmag(double4 __x, double4 __y){ return (double4)( __spirv_ocl_maxmag(__x, __y)); }
inline double8 __attribute__((__overloadable__)) maxmag(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) maxmag(double8 __x, double8 __y){ return (double8)( __spirv_ocl_maxmag(__x, __y)); }
inline double16 __attribute__((__overloadable__)) maxmag(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) maxmag(double16 __x, double16 __y){ return (double16)( __spirv_ocl_maxmag(__x, __y)); }
inline double __attribute__((__overloadable__)) minmag(double __x, double __y);
inline double __attribute__((__overloadable__)) minmag(double __x, double __y){  return (double) __spirv_ocl_minmag(__x, __y); }
inline double2 __attribute__((__overloadable__)) minmag(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) minmag(double2 __x, double2 __y){ return (double2)( __spirv_ocl_minmag(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) minmag(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) minmag(double3 __x, double3 __y){ return (double3)( __spirv_ocl_minmag(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) minmag(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) minmag(double4 __x, double4 __y){ return (double4)( __spirv_ocl_minmag(__x, __y)); }
inline double8 __attribute__((__overloadable__)) minmag(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) minmag(double8 __x, double8 __y){ return (double8)( __spirv_ocl_minmag(__x, __y)); }
inline double16 __attribute__((__overloadable__)) minmag(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) minmag(double16 __x, double16 __y){ return (double16)( __spirv_ocl_minmag(__x, __y)); }
inline double __attribute__((__overloadable__)) pown(double __x, int __y);
inline double __attribute__((__overloadable__)) pown(double __x, int __y){  return __spirv_ocl_pown(__x, __y); }
inline double2 __attribute__((__overloadable__)) pown(double2 __x, int2 __y);
inline double2 __attribute__((__overloadable__)) pown(double2 __x, int2 __y){  return (double2)(__spirv_ocl_pown(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) pown(double3 __x, int3 __y);
inline double3 __attribute__((__overloadable__)) pown(double3 __x, int3 __y){  return (double3)(__spirv_ocl_pown(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) pown(double4 __x, int4 __y);
inline double4 __attribute__((__overloadable__)) pown(double4 __x, int4 __y){  return (double4)(__spirv_ocl_pown(__x, __y)); }
inline double8 __attribute__((__overloadable__)) pown(double8 __x, int8 __y);
inline double8 __attribute__((__overloadable__)) pown(double8 __x, int8 __y){  return (double8)(__spirv_ocl_pown(__x, __y)); }
inline double16 __attribute__((__overloadable__)) pown(double16 __x, int16 __y);
inline double16 __attribute__((__overloadable__)) pown(double16 __x, int16 __y){  return (double16)(__spirv_ocl_pown(__x, __y)); }
inline double __attribute__((__overloadable__)) rootn(double __x, int __y);
inline double __attribute__((__overloadable__)) rootn(double __x, int __y){  return __spirv_ocl_rootn(__x, __y); }
inline double2 __attribute__((__overloadable__)) rootn(double2 __x, int2 __y);
inline double2 __attribute__((__overloadable__)) rootn(double2 __x, int2 __y){  return (double2)(__spirv_ocl_rootn(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) rootn(double3 __x, int3 __y);
inline double3 __attribute__((__overloadable__)) rootn(double3 __x, int3 __y){  return (double3)(__spirv_ocl_rootn(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) rootn(double4 __x, int4 __y);
inline double4 __attribute__((__overloadable__)) rootn(double4 __x, int4 __y){  return (double4)(__spirv_ocl_rootn(__x, __y)); }
inline double8 __attribute__((__overloadable__)) rootn(double8 __x, int8 __y);
inline double8 __attribute__((__overloadable__)) rootn(double8 __x, int8 __y){  return (double8)(__spirv_ocl_rootn(__x, __y)); }
inline double16 __attribute__((__overloadable__)) rootn(double16 __x, int16 __y);
inline double16 __attribute__((__overloadable__)) rootn(double16 __x, int16 __y){  return (double16)(__spirv_ocl_rootn(__x, __y)); }
#endif
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__)) log10(float __x);
inline float __attribute__((__overloadable__)) log10(float __x){  return (float) __spirv_ocl_log10(__x); }
inline float2 __attribute__((__overloadable__)) log10(float2 __x );
inline float2 __attribute__((__overloadable__)) log10(float2 __x ){ return (float2)( __spirv_ocl_log10(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) log10(float3 __x );
inline float3 __attribute__((__overloadable__)) log10(float3 __x ){ return (float3)( __spirv_ocl_log10(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) log10(float4 __x );
inline float4 __attribute__((__overloadable__)) log10(float4 __x ){ return (float4)( __spirv_ocl_log10(__x)); }
inline float8 __attribute__((__overloadable__)) log10(float8 __x );
inline float8 __attribute__((__overloadable__)) log10(float8 __x ){ return (float8)( __spirv_ocl_log10(__x)); }
inline float16 __attribute__((__overloadable__)) log10(float16 __x );
inline float16 __attribute__((__overloadable__)) log10(float16 __x ){ return (float16)( __spirv_ocl_log10(__x)); }
inline float __attribute__((__overloadable__)) log2(float __x);
inline float __attribute__((__overloadable__)) log2(float __x){  return (float) __spirv_ocl_log2(__x); }
inline float2 __attribute__((__overloadable__)) log2(float2 __x );
inline float2 __attribute__((__overloadable__)) log2(float2 __x ){ return (float2)( __spirv_ocl_log2(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) log2(float3 __x );
inline float3 __attribute__((__overloadable__)) log2(float3 __x ){ return (float3)( __spirv_ocl_log2(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) log2(float4 __x );
inline float4 __attribute__((__overloadable__)) log2(float4 __x ){ return (float4)( __spirv_ocl_log2(__x)); }
inline float8 __attribute__((__overloadable__)) log2(float8 __x );
inline float8 __attribute__((__overloadable__)) log2(float8 __x ){ return (float8)( __spirv_ocl_log2(__x)); }
inline float16 __attribute__((__overloadable__)) log2(float16 __x );
inline float16 __attribute__((__overloadable__)) log2(float16 __x ){ return (float16)( __spirv_ocl_log2(__x)); }
inline float __attribute__((__overloadable__)) log1p(float __x);
inline float __attribute__((__overloadable__)) log1p(float __x){  return (float) __spirv_ocl_log1p(__x); }
inline float2 __attribute__((__overloadable__)) log1p(float2 __x );
inline float2 __attribute__((__overloadable__)) log1p(float2 __x ){ return (float2)( __spirv_ocl_log1p(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) log1p(float3 __x );
inline float3 __attribute__((__overloadable__)) log1p(float3 __x ){ return (float3)( __spirv_ocl_log1p(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) log1p(float4 __x );
inline float4 __attribute__((__overloadable__)) log1p(float4 __x ){ return (float4)( __spirv_ocl_log1p(__x)); }
inline float8 __attribute__((__overloadable__)) log1p(float8 __x );
inline float8 __attribute__((__overloadable__)) log1p(float8 __x ){ return (float8)( __spirv_ocl_log1p(__x)); }
inline float16 __attribute__((__overloadable__)) log1p(float16 __x );
inline float16 __attribute__((__overloadable__)) log1p(float16 __x ){ return (float16)( __spirv_ocl_log1p(__x)); }
inline float __attribute__((__overloadable__)) log(float __x);
inline float __attribute__((__overloadable__)) log(float __x){  return (float) __spirv_ocl_log(__x); }
inline float2 __attribute__((__overloadable__)) log(float2 __x );
inline float2 __attribute__((__overloadable__)) log(float2 __x ){ return (float2)( __spirv_ocl_log(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) log(float3 __x );
inline float3 __attribute__((__overloadable__)) log(float3 __x ){ return (float3)( __spirv_ocl_log(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) log(float4 __x );
inline float4 __attribute__((__overloadable__)) log(float4 __x ){ return (float4)( __spirv_ocl_log(__x)); }
inline float8 __attribute__((__overloadable__)) log(float8 __x );
inline float8 __attribute__((__overloadable__)) log(float8 __x ){ return (float8)( __spirv_ocl_log(__x)); }
inline float16 __attribute__((__overloadable__)) log(float16 __x );
inline float16 __attribute__((__overloadable__)) log(float16 __x ){ return (float16)( __spirv_ocl_log(__x)); }
inline float __attribute__((__overloadable__)) sqrt(float __x);
inline float __attribute__((__overloadable__)) sqrt(float __x){  return (float) __spirv_ocl_sqrt(__x); }
inline float2 __attribute__((__overloadable__)) sqrt(float2 __x );
inline float2 __attribute__((__overloadable__)) sqrt(float2 __x ){ return (float2)( __spirv_ocl_sqrt(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) sqrt(float3 __x );
inline float3 __attribute__((__overloadable__)) sqrt(float3 __x ){ return (float3)( __spirv_ocl_sqrt(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) sqrt(float4 __x );
inline float4 __attribute__((__overloadable__)) sqrt(float4 __x ){ return (float4)( __spirv_ocl_sqrt(__x)); }
inline float8 __attribute__((__overloadable__)) sqrt(float8 __x );
inline float8 __attribute__((__overloadable__)) sqrt(float8 __x ){ return (float8)( __spirv_ocl_sqrt(__x)); }
inline float16 __attribute__((__overloadable__)) sqrt(float16 __x );
inline float16 __attribute__((__overloadable__)) sqrt(float16 __x ){ return (float16)( __spirv_ocl_sqrt(__x)); }
inline float __attribute__((__overloadable__)) exp(float __x);
inline float __attribute__((__overloadable__)) exp(float __x){  return (float) __spirv_ocl_exp(__x); }
inline float2 __attribute__((__overloadable__)) exp(float2 __x );
inline float2 __attribute__((__overloadable__)) exp(float2 __x ){ return (float2)( __spirv_ocl_exp(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) exp(float3 __x );
inline float3 __attribute__((__overloadable__)) exp(float3 __x ){ return (float3)( __spirv_ocl_exp(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) exp(float4 __x );
inline float4 __attribute__((__overloadable__)) exp(float4 __x ){ return (float4)( __spirv_ocl_exp(__x)); }
inline float8 __attribute__((__overloadable__)) exp(float8 __x );
inline float8 __attribute__((__overloadable__)) exp(float8 __x ){ return (float8)( __spirv_ocl_exp(__x)); }
inline float16 __attribute__((__overloadable__)) exp(float16 __x );
inline float16 __attribute__((__overloadable__)) exp(float16 __x ){ return (float16)( __spirv_ocl_exp(__x)); }
inline float __attribute__((__overloadable__)) exp2(float __x);
inline float __attribute__((__overloadable__)) exp2(float __x){  return (float) __spirv_ocl_exp2(__x); }
inline float2 __attribute__((__overloadable__)) exp2(float2 __x );
inline float2 __attribute__((__overloadable__)) exp2(float2 __x ){ return (float2)( __spirv_ocl_exp2(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) exp2(float3 __x );
inline float3 __attribute__((__overloadable__)) exp2(float3 __x ){ return (float3)( __spirv_ocl_exp2(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) exp2(float4 __x );
inline float4 __attribute__((__overloadable__)) exp2(float4 __x ){ return (float4)( __spirv_ocl_exp2(__x)); }
inline float8 __attribute__((__overloadable__)) exp2(float8 __x );
inline float8 __attribute__((__overloadable__)) exp2(float8 __x ){ return (float8)( __spirv_ocl_exp2(__x)); }
inline float16 __attribute__((__overloadable__)) exp2(float16 __x );
inline float16 __attribute__((__overloadable__)) exp2(float16 __x ){ return (float16)( __spirv_ocl_exp2(__x)); }
inline float __attribute__((__overloadable__)) ldexp(float __x, int __y);
inline float __attribute__((__overloadable__)) ldexp(float __x, int __y){  return __spirv_ocl_ldexp(__x, __y); }
inline float2 __attribute__((__overloadable__)) ldexp(float2 __x, int2 __y);
inline float2 __attribute__((__overloadable__)) ldexp(float2 __x, int2 __y){  return (float2)(__spirv_ocl_ldexp(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) ldexp(float3 __x, int3 __y);
inline float3 __attribute__((__overloadable__)) ldexp(float3 __x, int3 __y){  return (float3)(__spirv_ocl_ldexp(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) ldexp(float4 __x, int4 __y);
inline float4 __attribute__((__overloadable__)) ldexp(float4 __x, int4 __y){  return (float4)(__spirv_ocl_ldexp(__x, __y)); }
inline float8 __attribute__((__overloadable__)) ldexp(float8 __x, int8 __y);
inline float8 __attribute__((__overloadable__)) ldexp(float8 __x, int8 __y){  return (float8)(__spirv_ocl_ldexp(__x, __y)); }
inline float16 __attribute__((__overloadable__)) ldexp(float16 __x, int16 __y);
inline float16 __attribute__((__overloadable__)) ldexp(float16 __x, int16 __y){  return (float16)(__spirv_ocl_ldexp(__x, __y)); }
inline float __attribute__((__overloadable__)) sin(float __x);
inline float __attribute__((__overloadable__)) sin(float __x){  return (float) __spirv_ocl_sin(__x); }
inline float2 __attribute__((__overloadable__)) sin(float2 __x );
inline float2 __attribute__((__overloadable__)) sin(float2 __x ){ return (float2)( __spirv_ocl_sin(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) sin(float3 __x );
inline float3 __attribute__((__overloadable__)) sin(float3 __x ){ return (float3)( __spirv_ocl_sin(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) sin(float4 __x );
inline float4 __attribute__((__overloadable__)) sin(float4 __x ){ return (float4)( __spirv_ocl_sin(__x)); }
inline float8 __attribute__((__overloadable__)) sin(float8 __x );
inline float8 __attribute__((__overloadable__)) sin(float8 __x ){ return (float8)( __spirv_ocl_sin(__x)); }
inline float16 __attribute__((__overloadable__)) sin(float16 __x );
inline float16 __attribute__((__overloadable__)) sin(float16 __x ){ return (float16)( __spirv_ocl_sin(__x)); }
inline float __attribute__((__overloadable__)) cos(float __x);
inline float __attribute__((__overloadable__)) cos(float __x){  return (float) __spirv_ocl_cos(__x); }
inline float2 __attribute__((__overloadable__)) cos(float2 __x );
inline float2 __attribute__((__overloadable__)) cos(float2 __x ){ return (float2)( __spirv_ocl_cos(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) cos(float3 __x );
inline float3 __attribute__((__overloadable__)) cos(float3 __x ){ return (float3)( __spirv_ocl_cos(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) cos(float4 __x );
inline float4 __attribute__((__overloadable__)) cos(float4 __x ){ return (float4)( __spirv_ocl_cos(__x)); }
inline float8 __attribute__((__overloadable__)) cos(float8 __x );
inline float8 __attribute__((__overloadable__)) cos(float8 __x ){ return (float8)( __spirv_ocl_cos(__x)); }
inline float16 __attribute__((__overloadable__)) cos(float16 __x );
inline float16 __attribute__((__overloadable__)) cos(float16 __x ){ return (float16)( __spirv_ocl_cos(__x)); }
inline float __attribute__((__overloadable__)) tan(float __x);
inline float __attribute__((__overloadable__)) tan(float __x){  return (float) __spirv_ocl_tan(__x); }
inline float2 __attribute__((__overloadable__)) tan(float2 __x );
inline float2 __attribute__((__overloadable__)) tan(float2 __x ){ return (float2)( __spirv_ocl_tan(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) tan(float3 __x );
inline float3 __attribute__((__overloadable__)) tan(float3 __x ){ return (float3)( __spirv_ocl_tan(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) tan(float4 __x );
inline float4 __attribute__((__overloadable__)) tan(float4 __x ){ return (float4)( __spirv_ocl_tan(__x)); }
inline float8 __attribute__((__overloadable__)) tan(float8 __x );
inline float8 __attribute__((__overloadable__)) tan(float8 __x ){ return (float8)( __spirv_ocl_tan(__x)); }
inline float16 __attribute__((__overloadable__)) tan(float16 __x );
inline float16 __attribute__((__overloadable__)) tan(float16 __x ){ return (float16)( __spirv_ocl_tan(__x)); }
inline float __attribute__((__overloadable__)) asin(float __x);
inline float __attribute__((__overloadable__)) asin(float __x){  return (float) __spirv_ocl_asin(__x); }
inline float2 __attribute__((__overloadable__)) asin(float2 __x );
inline float2 __attribute__((__overloadable__)) asin(float2 __x ){ return (float2)( __spirv_ocl_asin(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) asin(float3 __x );
inline float3 __attribute__((__overloadable__)) asin(float3 __x ){ return (float3)( __spirv_ocl_asin(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) asin(float4 __x );
inline float4 __attribute__((__overloadable__)) asin(float4 __x ){ return (float4)( __spirv_ocl_asin(__x)); }
inline float8 __attribute__((__overloadable__)) asin(float8 __x );
inline float8 __attribute__((__overloadable__)) asin(float8 __x ){ return (float8)( __spirv_ocl_asin(__x)); }
inline float16 __attribute__((__overloadable__)) asin(float16 __x );
inline float16 __attribute__((__overloadable__)) asin(float16 __x ){ return (float16)( __spirv_ocl_asin(__x)); }
inline float __attribute__((__overloadable__)) acos(float __x);
inline float __attribute__((__overloadable__)) acos(float __x){  return (float) __spirv_ocl_acos(__x); }
inline float2 __attribute__((__overloadable__)) acos(float2 __x );
inline float2 __attribute__((__overloadable__)) acos(float2 __x ){ return (float2)( __spirv_ocl_acos(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) acos(float3 __x );
inline float3 __attribute__((__overloadable__)) acos(float3 __x ){ return (float3)( __spirv_ocl_acos(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) acos(float4 __x );
inline float4 __attribute__((__overloadable__)) acos(float4 __x ){ return (float4)( __spirv_ocl_acos(__x)); }
inline float8 __attribute__((__overloadable__)) acos(float8 __x );
inline float8 __attribute__((__overloadable__)) acos(float8 __x ){ return (float8)( __spirv_ocl_acos(__x)); }
inline float16 __attribute__((__overloadable__)) acos(float16 __x );
inline float16 __attribute__((__overloadable__)) acos(float16 __x ){ return (float16)( __spirv_ocl_acos(__x)); }
inline float __attribute__((__overloadable__)) atan(float __x);
inline float __attribute__((__overloadable__)) atan(float __x){  return (float) __spirv_ocl_atan(__x); }
inline float2 __attribute__((__overloadable__)) atan(float2 __x );
inline float2 __attribute__((__overloadable__)) atan(float2 __x ){ return (float2)( __spirv_ocl_atan(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) atan(float3 __x );
inline float3 __attribute__((__overloadable__)) atan(float3 __x ){ return (float3)( __spirv_ocl_atan(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) atan(float4 __x );
inline float4 __attribute__((__overloadable__)) atan(float4 __x ){ return (float4)( __spirv_ocl_atan(__x)); }
inline float8 __attribute__((__overloadable__)) atan(float8 __x );
inline float8 __attribute__((__overloadable__)) atan(float8 __x ){ return (float8)( __spirv_ocl_atan(__x)); }
inline float16 __attribute__((__overloadable__)) atan(float16 __x );
inline float16 __attribute__((__overloadable__)) atan(float16 __x ){ return (float16)( __spirv_ocl_atan(__x)); }
inline float __attribute__((__overloadable__)) sinh(float __x);
inline float __attribute__((__overloadable__)) sinh(float __x){  return (float) __spirv_ocl_sinh(__x); }
inline float2 __attribute__((__overloadable__)) sinh(float2 __x );
inline float2 __attribute__((__overloadable__)) sinh(float2 __x ){ return (float2)( __spirv_ocl_sinh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) sinh(float3 __x );
inline float3 __attribute__((__overloadable__)) sinh(float3 __x ){ return (float3)( __spirv_ocl_sinh(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) sinh(float4 __x );
inline float4 __attribute__((__overloadable__)) sinh(float4 __x ){ return (float4)( __spirv_ocl_sinh(__x)); }
inline float8 __attribute__((__overloadable__)) sinh(float8 __x );
inline float8 __attribute__((__overloadable__)) sinh(float8 __x ){ return (float8)( __spirv_ocl_sinh(__x)); }
inline float16 __attribute__((__overloadable__)) sinh(float16 __x );
inline float16 __attribute__((__overloadable__)) sinh(float16 __x ){ return (float16)( __spirv_ocl_sinh(__x)); }
inline float __attribute__((__overloadable__)) cosh(float __x);
inline float __attribute__((__overloadable__)) cosh(float __x){  return (float) __spirv_ocl_cosh(__x); }
inline float2 __attribute__((__overloadable__)) cosh(float2 __x );
inline float2 __attribute__((__overloadable__)) cosh(float2 __x ){ return (float2)( __spirv_ocl_cosh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) cosh(float3 __x );
inline float3 __attribute__((__overloadable__)) cosh(float3 __x ){ return (float3)( __spirv_ocl_cosh(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) cosh(float4 __x );
inline float4 __attribute__((__overloadable__)) cosh(float4 __x ){ return (float4)( __spirv_ocl_cosh(__x)); }
inline float8 __attribute__((__overloadable__)) cosh(float8 __x );
inline float8 __attribute__((__overloadable__)) cosh(float8 __x ){ return (float8)( __spirv_ocl_cosh(__x)); }
inline float16 __attribute__((__overloadable__)) cosh(float16 __x );
inline float16 __attribute__((__overloadable__)) cosh(float16 __x ){ return (float16)( __spirv_ocl_cosh(__x)); }
inline float __attribute__((__overloadable__)) tanh(float __x);
inline float __attribute__((__overloadable__)) tanh(float __x){  return (float) __spirv_ocl_tanh(__x); }
inline float2 __attribute__((__overloadable__)) tanh(float2 __x );
inline float2 __attribute__((__overloadable__)) tanh(float2 __x ){ return (float2)( __spirv_ocl_tanh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) tanh(float3 __x );
inline float3 __attribute__((__overloadable__)) tanh(float3 __x ){ return (float3)( __spirv_ocl_tanh(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) tanh(float4 __x );
inline float4 __attribute__((__overloadable__)) tanh(float4 __x ){ return (float4)( __spirv_ocl_tanh(__x)); }
inline float8 __attribute__((__overloadable__)) tanh(float8 __x );
inline float8 __attribute__((__overloadable__)) tanh(float8 __x ){ return (float8)( __spirv_ocl_tanh(__x)); }
inline float16 __attribute__((__overloadable__)) tanh(float16 __x );
inline float16 __attribute__((__overloadable__)) tanh(float16 __x ){ return (float16)( __spirv_ocl_tanh(__x)); }
inline float __attribute__((__overloadable__)) asinh(float __x);
inline float __attribute__((__overloadable__)) asinh(float __x){  return (float) __spirv_ocl_asinh(__x); }
inline float2 __attribute__((__overloadable__)) asinh(float2 __x );
inline float2 __attribute__((__overloadable__)) asinh(float2 __x ){ return (float2)( __spirv_ocl_asinh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) asinh(float3 __x );
inline float3 __attribute__((__overloadable__)) asinh(float3 __x ){ return (float3)( __spirv_ocl_asinh(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) asinh(float4 __x );
inline float4 __attribute__((__overloadable__)) asinh(float4 __x ){ return (float4)( __spirv_ocl_asinh(__x)); }
inline float8 __attribute__((__overloadable__)) asinh(float8 __x );
inline float8 __attribute__((__overloadable__)) asinh(float8 __x ){ return (float8)( __spirv_ocl_asinh(__x)); }
inline float16 __attribute__((__overloadable__)) asinh(float16 __x );
inline float16 __attribute__((__overloadable__)) asinh(float16 __x ){ return (float16)( __spirv_ocl_asinh(__x)); }
inline float __attribute__((__overloadable__)) acosh(float __x);
inline float __attribute__((__overloadable__)) acosh(float __x){  return (float) __spirv_ocl_acosh(__x); }
inline float2 __attribute__((__overloadable__)) acosh(float2 __x );
inline float2 __attribute__((__overloadable__)) acosh(float2 __x ){ return (float2)( __spirv_ocl_acosh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) acosh(float3 __x );
inline float3 __attribute__((__overloadable__)) acosh(float3 __x ){ return (float3)( __spirv_ocl_acosh(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) acosh(float4 __x );
inline float4 __attribute__((__overloadable__)) acosh(float4 __x ){ return (float4)( __spirv_ocl_acosh(__x)); }
inline float8 __attribute__((__overloadable__)) acosh(float8 __x );
inline float8 __attribute__((__overloadable__)) acosh(float8 __x ){ return (float8)( __spirv_ocl_acosh(__x)); }
inline float16 __attribute__((__overloadable__)) acosh(float16 __x );
inline float16 __attribute__((__overloadable__)) acosh(float16 __x ){ return (float16)( __spirv_ocl_acosh(__x)); }
inline float __attribute__((__overloadable__)) atanh(float __x);
inline float __attribute__((__overloadable__)) atanh(float __x){  return (float) __spirv_ocl_atanh(__x); }
inline float2 __attribute__((__overloadable__)) atanh(float2 __x );
inline float2 __attribute__((__overloadable__)) atanh(float2 __x ){ return (float2)( __spirv_ocl_atanh(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) atanh(float3 __x );
inline float3 __attribute__((__overloadable__)) atanh(float3 __x ){ return (float3)( __spirv_ocl_atanh(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) atanh(float4 __x );
inline float4 __attribute__((__overloadable__)) atanh(float4 __x ){ return (float4)( __spirv_ocl_atanh(__x)); }
inline float8 __attribute__((__overloadable__)) atanh(float8 __x );
inline float8 __attribute__((__overloadable__)) atanh(float8 __x ){ return (float8)( __spirv_ocl_atanh(__x)); }
inline float16 __attribute__((__overloadable__)) atanh(float16 __x );
inline float16 __attribute__((__overloadable__)) atanh(float16 __x ){ return (float16)( __spirv_ocl_atanh(__x)); }
inline float __attribute__((__overloadable__)) floor(float __x);
inline float __attribute__((__overloadable__)) floor(float __x){  return (float) __spirv_ocl_floor(__x); }
inline float2 __attribute__((__overloadable__)) floor(float2 __x );
inline float2 __attribute__((__overloadable__)) floor(float2 __x ){ return (float2)( __spirv_ocl_floor(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) floor(float3 __x );
inline float3 __attribute__((__overloadable__)) floor(float3 __x ){ return (float3)( __spirv_ocl_floor(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) floor(float4 __x );
inline float4 __attribute__((__overloadable__)) floor(float4 __x ){ return (float4)( __spirv_ocl_floor(__x)); }
inline float8 __attribute__((__overloadable__)) floor(float8 __x );
inline float8 __attribute__((__overloadable__)) floor(float8 __x ){ return (float8)( __spirv_ocl_floor(__x)); }
inline float16 __attribute__((__overloadable__)) floor(float16 __x );
inline float16 __attribute__((__overloadable__)) floor(float16 __x ){ return (float16)( __spirv_ocl_floor(__x)); }
inline float __attribute__((__overloadable__)) ceil(float __x);
inline float __attribute__((__overloadable__)) ceil(float __x){  return (float) __spirv_ocl_ceil(__x); }
inline float2 __attribute__((__overloadable__)) ceil(float2 __x );
inline float2 __attribute__((__overloadable__)) ceil(float2 __x ){ return (float2)( __spirv_ocl_ceil(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) ceil(float3 __x );
inline float3 __attribute__((__overloadable__)) ceil(float3 __x ){ return (float3)( __spirv_ocl_ceil(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) ceil(float4 __x );
inline float4 __attribute__((__overloadable__)) ceil(float4 __x ){ return (float4)( __spirv_ocl_ceil(__x)); }
inline float8 __attribute__((__overloadable__)) ceil(float8 __x );
inline float8 __attribute__((__overloadable__)) ceil(float8 __x ){ return (float8)( __spirv_ocl_ceil(__x)); }
inline float16 __attribute__((__overloadable__)) ceil(float16 __x );
inline float16 __attribute__((__overloadable__)) ceil(float16 __x ){ return (float16)( __spirv_ocl_ceil(__x)); }
inline float __attribute__((__overloadable__)) fabs(float __x);
inline float __attribute__((__overloadable__)) fabs(float __x){  return (float) __spirv_ocl_fabs(__x); }
inline float2 __attribute__((__overloadable__)) fabs(float2 __x );
inline float2 __attribute__((__overloadable__)) fabs(float2 __x ){ return (float2)( __spirv_ocl_fabs(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) fabs(float3 __x );
inline float3 __attribute__((__overloadable__)) fabs(float3 __x ){ return (float3)( __spirv_ocl_fabs(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) fabs(float4 __x );
inline float4 __attribute__((__overloadable__)) fabs(float4 __x ){ return (float4)( __spirv_ocl_fabs(__x)); }
inline float8 __attribute__((__overloadable__)) fabs(float8 __x );
inline float8 __attribute__((__overloadable__)) fabs(float8 __x ){ return (float8)( __spirv_ocl_fabs(__x)); }
inline float16 __attribute__((__overloadable__)) fabs(float16 __x );
inline float16 __attribute__((__overloadable__)) fabs(float16 __x ){ return (float16)( __spirv_ocl_fabs(__x)); }
inline float __attribute__((__overloadable__)) trunc(float __x);
inline float __attribute__((__overloadable__)) trunc(float __x){  return (float) __spirv_ocl_trunc(__x); }
inline float2 __attribute__((__overloadable__)) trunc(float2 __x );
inline float2 __attribute__((__overloadable__)) trunc(float2 __x ){ return (float2)( __spirv_ocl_trunc(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) trunc(float3 __x );
inline float3 __attribute__((__overloadable__)) trunc(float3 __x ){ return (float3)( __spirv_ocl_trunc(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) trunc(float4 __x );
inline float4 __attribute__((__overloadable__)) trunc(float4 __x ){ return (float4)( __spirv_ocl_trunc(__x)); }
inline float8 __attribute__((__overloadable__)) trunc(float8 __x );
inline float8 __attribute__((__overloadable__)) trunc(float8 __x ){ return (float8)( __spirv_ocl_trunc(__x)); }
inline float16 __attribute__((__overloadable__)) trunc(float16 __x );
inline float16 __attribute__((__overloadable__)) trunc(float16 __x ){ return (float16)( __spirv_ocl_trunc(__x)); }
inline float __attribute__((__overloadable__)) pow(float __x, float __y);
inline float __attribute__((__overloadable__)) pow(float __x, float __y){  return (float) __spirv_ocl_pow(__x, __y); }
inline float2 __attribute__((__overloadable__)) pow(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) pow(float2 __x, float2 __y){ return (float2)( __spirv_ocl_pow(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) pow(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) pow(float3 __x, float3 __y){ return (float3)( __spirv_ocl_pow(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) pow(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) pow(float4 __x, float4 __y){ return (float4)( __spirv_ocl_pow(__x, __y)); }
inline float8 __attribute__((__overloadable__)) pow(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) pow(float8 __x, float8 __y){ return (float8)( __spirv_ocl_pow(__x, __y)); }
inline float16 __attribute__((__overloadable__)) pow(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) pow(float16 __x, float16 __y){ return (float16)( __spirv_ocl_pow(__x, __y)); }
inline float __attribute__((__overloadable__)) lgamma(float __x);
inline float __attribute__((__overloadable__)) lgamma(float __x){  return (float) __spirv_ocl_lgamma(__x); }
inline float2 __attribute__((__overloadable__)) lgamma(float2 __x );
inline float2 __attribute__((__overloadable__)) lgamma(float2 __x ){ return (float2)( __spirv_ocl_lgamma(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) lgamma(float3 __x );
inline float3 __attribute__((__overloadable__)) lgamma(float3 __x ){ return (float3)( __spirv_ocl_lgamma(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) lgamma(float4 __x );
inline float4 __attribute__((__overloadable__)) lgamma(float4 __x ){ return (float4)( __spirv_ocl_lgamma(__x)); }
inline float8 __attribute__((__overloadable__)) lgamma(float8 __x );
inline float8 __attribute__((__overloadable__)) lgamma(float8 __x ){ return (float8)( __spirv_ocl_lgamma(__x)); }
inline float16 __attribute__((__overloadable__)) lgamma(float16 __x );
inline float16 __attribute__((__overloadable__)) lgamma(float16 __x ){ return (float16)( __spirv_ocl_lgamma(__x)); }
inline float __attribute__((__overloadable__)) tgamma(float __x);
inline float __attribute__((__overloadable__)) tgamma(float __x){  return (float) __spirv_ocl_tgamma(__x); }
inline float2 __attribute__((__overloadable__)) tgamma(float2 __x );
inline float2 __attribute__((__overloadable__)) tgamma(float2 __x ){ return (float2)( __spirv_ocl_tgamma(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) tgamma(float3 __x );
inline float3 __attribute__((__overloadable__)) tgamma(float3 __x ){ return (float3)( __spirv_ocl_tgamma(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) tgamma(float4 __x );
inline float4 __attribute__((__overloadable__)) tgamma(float4 __x ){ return (float4)( __spirv_ocl_tgamma(__x)); }
inline float8 __attribute__((__overloadable__)) tgamma(float8 __x );
inline float8 __attribute__((__overloadable__)) tgamma(float8 __x ){ return (float8)( __spirv_ocl_tgamma(__x)); }
inline float16 __attribute__((__overloadable__)) tgamma(float16 __x );
inline float16 __attribute__((__overloadable__)) tgamma(float16 __x ){ return (float16)( __spirv_ocl_tgamma(__x)); }
inline float __attribute__((__overloadable__)) erf(float __x);
inline float __attribute__((__overloadable__)) erf(float __x){  return (float) __spirv_ocl_erf(__x); }
inline float2 __attribute__((__overloadable__)) erf(float2 __x );
inline float2 __attribute__((__overloadable__)) erf(float2 __x ){ return (float2)( __spirv_ocl_erf(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) erf(float3 __x );
inline float3 __attribute__((__overloadable__)) erf(float3 __x ){ return (float3)( __spirv_ocl_erf(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) erf(float4 __x );
inline float4 __attribute__((__overloadable__)) erf(float4 __x ){ return (float4)( __spirv_ocl_erf(__x)); }
inline float8 __attribute__((__overloadable__)) erf(float8 __x );
inline float8 __attribute__((__overloadable__)) erf(float8 __x ){ return (float8)( __spirv_ocl_erf(__x)); }
inline float16 __attribute__((__overloadable__)) erf(float16 __x );
inline float16 __attribute__((__overloadable__)) erf(float16 __x ){ return (float16)( __spirv_ocl_erf(__x)); }
inline float __attribute__((__overloadable__)) erfc(float __x);
inline float __attribute__((__overloadable__)) erfc(float __x){  return (float) __spirv_ocl_erfc(__x); }
inline float2 __attribute__((__overloadable__)) erfc(float2 __x );
inline float2 __attribute__((__overloadable__)) erfc(float2 __x ){ return (float2)( __spirv_ocl_erfc(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) erfc(float3 __x );
inline float3 __attribute__((__overloadable__)) erfc(float3 __x ){ return (float3)( __spirv_ocl_erfc(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) erfc(float4 __x );
inline float4 __attribute__((__overloadable__)) erfc(float4 __x ){ return (float4)( __spirv_ocl_erfc(__x)); }
inline float8 __attribute__((__overloadable__)) erfc(float8 __x );
inline float8 __attribute__((__overloadable__)) erfc(float8 __x ){ return (float8)( __spirv_ocl_erfc(__x)); }
inline float16 __attribute__((__overloadable__)) erfc(float16 __x );
inline float16 __attribute__((__overloadable__)) erfc(float16 __x ){ return (float16)( __spirv_ocl_erfc(__x)); }
inline float __attribute__((__overloadable__)) cbrt(float __x);
inline float __attribute__((__overloadable__)) cbrt(float __x){  return (float) __spirv_ocl_cbrt(__x); }
inline float2 __attribute__((__overloadable__)) cbrt(float2 __x );
inline float2 __attribute__((__overloadable__)) cbrt(float2 __x ){ return (float2)( __spirv_ocl_cbrt(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) cbrt(float3 __x );
inline float3 __attribute__((__overloadable__)) cbrt(float3 __x ){ return (float3)( __spirv_ocl_cbrt(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) cbrt(float4 __x );
inline float4 __attribute__((__overloadable__)) cbrt(float4 __x ){ return (float4)( __spirv_ocl_cbrt(__x)); }
inline float8 __attribute__((__overloadable__)) cbrt(float8 __x );
inline float8 __attribute__((__overloadable__)) cbrt(float8 __x ){ return (float8)( __spirv_ocl_cbrt(__x)); }
inline float16 __attribute__((__overloadable__)) cbrt(float16 __x );
inline float16 __attribute__((__overloadable__)) cbrt(float16 __x ){ return (float16)( __spirv_ocl_cbrt(__x)); }
inline float __attribute__((__overloadable__)) expm1(float __x);
inline float __attribute__((__overloadable__)) expm1(float __x){  return (float) __spirv_ocl_expm1(__x); }
inline float2 __attribute__((__overloadable__)) expm1(float2 __x );
inline float2 __attribute__((__overloadable__)) expm1(float2 __x ){ return (float2)( __spirv_ocl_expm1(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) expm1(float3 __x );
inline float3 __attribute__((__overloadable__)) expm1(float3 __x ){ return (float3)( __spirv_ocl_expm1(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) expm1(float4 __x );
inline float4 __attribute__((__overloadable__)) expm1(float4 __x ){ return (float4)( __spirv_ocl_expm1(__x)); }
inline float8 __attribute__((__overloadable__)) expm1(float8 __x );
inline float8 __attribute__((__overloadable__)) expm1(float8 __x ){ return (float8)( __spirv_ocl_expm1(__x)); }
inline float16 __attribute__((__overloadable__)) expm1(float16 __x );
inline float16 __attribute__((__overloadable__)) expm1(float16 __x ){ return (float16)( __spirv_ocl_expm1(__x)); }
inline float __attribute__((__overloadable__)) fdim(float __x, float __y);
inline float __attribute__((__overloadable__)) fdim(float __x, float __y){  return (float) __spirv_ocl_fdim(__x, __y); }
inline float2 __attribute__((__overloadable__)) fdim(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) fdim(float2 __x, float2 __y){ return (float2)( __spirv_ocl_fdim(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) fdim(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) fdim(float3 __x, float3 __y){ return (float3)( __spirv_ocl_fdim(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) fdim(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) fdim(float4 __x, float4 __y){ return (float4)( __spirv_ocl_fdim(__x, __y)); }
inline float8 __attribute__((__overloadable__)) fdim(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) fdim(float8 __x, float8 __y){ return (float8)( __spirv_ocl_fdim(__x, __y)); }
inline float16 __attribute__((__overloadable__)) fdim(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) fdim(float16 __x, float16 __y){ return (float16)( __spirv_ocl_fdim(__x, __y)); }
inline float __attribute__((__overloadable__)) atan2(float __x, float __y);
inline float __attribute__((__overloadable__)) atan2(float __x, float __y){  return (float) __spirv_ocl_atan2(__x, __y); }
inline float2 __attribute__((__overloadable__)) atan2(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) atan2(float2 __x, float2 __y){ return (float2)( __spirv_ocl_atan2(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) atan2(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) atan2(float3 __x, float3 __y){ return (float3)( __spirv_ocl_atan2(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) atan2(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) atan2(float4 __x, float4 __y){ return (float4)( __spirv_ocl_atan2(__x, __y)); }
inline float8 __attribute__((__overloadable__)) atan2(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) atan2(float8 __x, float8 __y){ return (float8)( __spirv_ocl_atan2(__x, __y)); }
inline float16 __attribute__((__overloadable__)) atan2(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) atan2(float16 __x, float16 __y){ return (float16)( __spirv_ocl_atan2(__x, __y)); }
inline float __attribute__((__overloadable__)) hypot(float __x, float __y);
inline float __attribute__((__overloadable__)) hypot(float __x, float __y){  return (float) __spirv_ocl_hypot(__x, __y); }
inline float2 __attribute__((__overloadable__)) hypot(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) hypot(float2 __x, float2 __y){ return (float2)( __spirv_ocl_hypot(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) hypot(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) hypot(float3 __x, float3 __y){ return (float3)( __spirv_ocl_hypot(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) hypot(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) hypot(float4 __x, float4 __y){ return (float4)( __spirv_ocl_hypot(__x, __y)); }
inline float8 __attribute__((__overloadable__)) hypot(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) hypot(float8 __x, float8 __y){ return (float8)( __spirv_ocl_hypot(__x, __y)); }
inline float16 __attribute__((__overloadable__)) hypot(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) hypot(float16 __x, float16 __y){ return (float16)( __spirv_ocl_hypot(__x, __y)); }
inline float __attribute__((__overloadable__)) exp10(float __x);
inline float __attribute__((__overloadable__)) exp10(float __x){  return (float) __spirv_ocl_exp(__x); }
inline float2 __attribute__((__overloadable__)) exp10(float2 __x );
inline float2 __attribute__((__overloadable__)) exp10(float2 __x ){ return (float2)( __spirv_ocl_exp(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) exp10(float3 __x );
inline float3 __attribute__((__overloadable__)) exp10(float3 __x ){ return (float3)( __spirv_ocl_exp(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) exp10(float4 __x );
inline float4 __attribute__((__overloadable__)) exp10(float4 __x ){ return (float4)( __spirv_ocl_exp(__x)); }
inline float8 __attribute__((__overloadable__)) exp10(float8 __x );
inline float8 __attribute__((__overloadable__)) exp10(float8 __x ){ return (float8)( __spirv_ocl_exp(__x)); }
inline float16 __attribute__((__overloadable__)) exp10(float16 __x );
inline float16 __attribute__((__overloadable__)) exp10(float16 __x ){ return (float16)( __spirv_ocl_exp(__x)); }
inline float __attribute__((__overloadable__)) rsqrt(float __x);
inline float __attribute__((__overloadable__)) rsqrt(float __x){  return (float) __spirv_ocl_rsqrt(__x); }
inline float2 __attribute__((__overloadable__)) rsqrt(float2 __x );
inline float2 __attribute__((__overloadable__)) rsqrt(float2 __x ){ return (float2)( __spirv_ocl_rsqrt(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) rsqrt(float3 __x );
inline float3 __attribute__((__overloadable__)) rsqrt(float3 __x ){ return (float3)( __spirv_ocl_rsqrt(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) rsqrt(float4 __x );
inline float4 __attribute__((__overloadable__)) rsqrt(float4 __x ){ return (float4)( __spirv_ocl_rsqrt(__x)); }
inline float8 __attribute__((__overloadable__)) rsqrt(float8 __x );
inline float8 __attribute__((__overloadable__)) rsqrt(float8 __x ){ return (float8)( __spirv_ocl_rsqrt(__x)); }
inline float16 __attribute__((__overloadable__)) rsqrt(float16 __x );
inline float16 __attribute__((__overloadable__)) rsqrt(float16 __x ){ return (float16)( __spirv_ocl_rsqrt(__x)); }
inline float __attribute__((__overloadable__)) sinpi(float __x);
inline float __attribute__((__overloadable__)) sinpi(float __x){  return (float) __spirv_ocl_sinpi(__x); }
inline float2 __attribute__((__overloadable__)) sinpi(float2 __x );
inline float2 __attribute__((__overloadable__)) sinpi(float2 __x ){ return (float2)( __spirv_ocl_sinpi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) sinpi(float3 __x );
inline float3 __attribute__((__overloadable__)) sinpi(float3 __x ){ return (float3)( __spirv_ocl_sinpi(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) sinpi(float4 __x );
inline float4 __attribute__((__overloadable__)) sinpi(float4 __x ){ return (float4)( __spirv_ocl_sinpi(__x)); }
inline float8 __attribute__((__overloadable__)) sinpi(float8 __x );
inline float8 __attribute__((__overloadable__)) sinpi(float8 __x ){ return (float8)( __spirv_ocl_sinpi(__x)); }
inline float16 __attribute__((__overloadable__)) sinpi(float16 __x );
inline float16 __attribute__((__overloadable__)) sinpi(float16 __x ){ return (float16)( __spirv_ocl_sinpi(__x)); }
inline float __attribute__((__overloadable__)) cospi(float __x);
inline float __attribute__((__overloadable__)) cospi(float __x){  return (float) __spirv_ocl_cospi(__x); }
inline float2 __attribute__((__overloadable__)) cospi(float2 __x );
inline float2 __attribute__((__overloadable__)) cospi(float2 __x ){ return (float2)( __spirv_ocl_cospi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) cospi(float3 __x );
inline float3 __attribute__((__overloadable__)) cospi(float3 __x ){ return (float3)( __spirv_ocl_cospi(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) cospi(float4 __x );
inline float4 __attribute__((__overloadable__)) cospi(float4 __x ){ return (float4)( __spirv_ocl_cospi(__x)); }
inline float8 __attribute__((__overloadable__)) cospi(float8 __x );
inline float8 __attribute__((__overloadable__)) cospi(float8 __x ){ return (float8)( __spirv_ocl_cospi(__x)); }
inline float16 __attribute__((__overloadable__)) cospi(float16 __x );
inline float16 __attribute__((__overloadable__)) cospi(float16 __x ){ return (float16)( __spirv_ocl_cospi(__x)); }
inline float __attribute__((__overloadable__)) tanpi(float __x);
inline float __attribute__((__overloadable__)) tanpi(float __x){  return (float) __spirv_ocl_tanpi(__x); }
inline float2 __attribute__((__overloadable__)) tanpi(float2 __x );
inline float2 __attribute__((__overloadable__)) tanpi(float2 __x ){ return (float2)( __spirv_ocl_tanpi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) tanpi(float3 __x );
inline float3 __attribute__((__overloadable__)) tanpi(float3 __x ){ return (float3)( __spirv_ocl_tanpi(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) tanpi(float4 __x );
inline float4 __attribute__((__overloadable__)) tanpi(float4 __x ){ return (float4)( __spirv_ocl_tanpi(__x)); }
inline float8 __attribute__((__overloadable__)) tanpi(float8 __x );
inline float8 __attribute__((__overloadable__)) tanpi(float8 __x ){ return (float8)( __spirv_ocl_tanpi(__x)); }
inline float16 __attribute__((__overloadable__)) tanpi(float16 __x );
inline float16 __attribute__((__overloadable__)) tanpi(float16 __x ){ return (float16)( __spirv_ocl_tanpi(__x)); }
inline float __attribute__((__overloadable__)) asinpi(float __x);
inline float __attribute__((__overloadable__)) asinpi(float __x){  return (float) __spirv_ocl_asinpi(__x); }
inline float2 __attribute__((__overloadable__)) asinpi(float2 __x );
inline float2 __attribute__((__overloadable__)) asinpi(float2 __x ){ return (float2)( __spirv_ocl_asinpi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) asinpi(float3 __x );
inline float3 __attribute__((__overloadable__)) asinpi(float3 __x ){ return (float3)( __spirv_ocl_asinpi(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) asinpi(float4 __x );
inline float4 __attribute__((__overloadable__)) asinpi(float4 __x ){ return (float4)( __spirv_ocl_asinpi(__x)); }
inline float8 __attribute__((__overloadable__)) asinpi(float8 __x );
inline float8 __attribute__((__overloadable__)) asinpi(float8 __x ){ return (float8)( __spirv_ocl_asinpi(__x)); }
inline float16 __attribute__((__overloadable__)) asinpi(float16 __x );
inline float16 __attribute__((__overloadable__)) asinpi(float16 __x ){ return (float16)( __spirv_ocl_asinpi(__x)); }
inline float __attribute__((__overloadable__)) acospi(float __x);
inline float __attribute__((__overloadable__)) acospi(float __x){  return (float) __spirv_ocl_acospi(__x); }
inline float2 __attribute__((__overloadable__)) acospi(float2 __x );
inline float2 __attribute__((__overloadable__)) acospi(float2 __x ){ return (float2)( __spirv_ocl_acospi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) acospi(float3 __x );
inline float3 __attribute__((__overloadable__)) acospi(float3 __x ){ return (float3)( __spirv_ocl_acospi(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) acospi(float4 __x );
inline float4 __attribute__((__overloadable__)) acospi(float4 __x ){ return (float4)( __spirv_ocl_acospi(__x)); }
inline float8 __attribute__((__overloadable__)) acospi(float8 __x );
inline float8 __attribute__((__overloadable__)) acospi(float8 __x ){ return (float8)( __spirv_ocl_acospi(__x)); }
inline float16 __attribute__((__overloadable__)) acospi(float16 __x );
inline float16 __attribute__((__overloadable__)) acospi(float16 __x ){ return (float16)( __spirv_ocl_acospi(__x)); }
inline float __attribute__((__overloadable__)) atanpi(float __x);
inline float __attribute__((__overloadable__)) atanpi(float __x){  return (float) __spirv_ocl_atanpi(__x); }
inline float2 __attribute__((__overloadable__)) atanpi(float2 __x );
inline float2 __attribute__((__overloadable__)) atanpi(float2 __x ){ return (float2)( __spirv_ocl_atanpi(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) atanpi(float3 __x );
inline float3 __attribute__((__overloadable__)) atanpi(float3 __x ){ return (float3)( __spirv_ocl_atanpi(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) atanpi(float4 __x );
inline float4 __attribute__((__overloadable__)) atanpi(float4 __x ){ return (float4)( __spirv_ocl_atanpi(__x)); }
inline float8 __attribute__((__overloadable__)) atanpi(float8 __x );
inline float8 __attribute__((__overloadable__)) atanpi(float8 __x ){ return (float8)( __spirv_ocl_atanpi(__x)); }
inline float16 __attribute__((__overloadable__)) atanpi(float16 __x );
inline float16 __attribute__((__overloadable__)) atanpi(float16 __x ){ return (float16)( __spirv_ocl_atanpi(__x)); }
inline float __attribute__((__overloadable__)) degrees(float __x);
inline float __attribute__((__overloadable__)) degrees(float __x){  return (float) __spirv_ocl_degrees(__x); }
inline float2 __attribute__((__overloadable__)) degrees(float2 __x );
inline float2 __attribute__((__overloadable__)) degrees(float2 __x ){ return (float2)( __spirv_ocl_degrees(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) degrees(float3 __x );
inline float3 __attribute__((__overloadable__)) degrees(float3 __x ){ return (float3)( __spirv_ocl_degrees(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) degrees(float4 __x );
inline float4 __attribute__((__overloadable__)) degrees(float4 __x ){ return (float4)( __spirv_ocl_degrees(__x)); }
inline float8 __attribute__((__overloadable__)) degrees(float8 __x );
inline float8 __attribute__((__overloadable__)) degrees(float8 __x ){ return (float8)( __spirv_ocl_degrees(__x)); }
inline float16 __attribute__((__overloadable__)) degrees(float16 __x );
inline float16 __attribute__((__overloadable__)) degrees(float16 __x ){ return (float16)( __spirv_ocl_degrees(__x)); }
inline float __attribute__((__overloadable__)) radians(float __x);
inline float __attribute__((__overloadable__)) radians(float __x){  return (float) __spirv_ocl_radians(__x); }
inline float2 __attribute__((__overloadable__)) radians(float2 __x );
inline float2 __attribute__((__overloadable__)) radians(float2 __x ){ return (float2)( __spirv_ocl_radians(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) radians(float3 __x );
inline float3 __attribute__((__overloadable__)) radians(float3 __x ){ return (float3)( __spirv_ocl_radians(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) radians(float4 __x );
inline float4 __attribute__((__overloadable__)) radians(float4 __x ){ return (float4)( __spirv_ocl_radians(__x)); }
inline float8 __attribute__((__overloadable__)) radians(float8 __x );
inline float8 __attribute__((__overloadable__)) radians(float8 __x ){ return (float8)( __spirv_ocl_radians(__x)); }
inline float16 __attribute__((__overloadable__)) radians(float16 __x );
inline float16 __attribute__((__overloadable__)) radians(float16 __x ){ return (float16)( __spirv_ocl_radians(__x)); }
inline float __attribute__((__overloadable__)) powr(float __x, float __y);
inline float __attribute__((__overloadable__)) powr(float __x, float __y){  return (float) __spirv_ocl_powr(__x, __y); }
inline float2 __attribute__((__overloadable__)) powr(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) powr(float2 __x, float2 __y){ return (float2)( __spirv_ocl_powr(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) powr(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) powr(float3 __x, float3 __y){ return (float3)( __spirv_ocl_powr(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) powr(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) powr(float4 __x, float4 __y){ return (float4)( __spirv_ocl_powr(__x, __y)); }
inline float8 __attribute__((__overloadable__)) powr(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) powr(float8 __x, float8 __y){ return (float8)( __spirv_ocl_powr(__x, __y)); }
inline float16 __attribute__((__overloadable__)) powr(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) powr(float16 __x, float16 __y){ return (float16)( __spirv_ocl_powr(__x, __y)); }
inline float __attribute__((__overloadable__)) step(float __x, float __y);
inline float __attribute__((__overloadable__)) step(float __x, float __y){  return (float) __spirv_ocl_step(__x, __y); }
inline float2 __attribute__((__overloadable__)) step(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) step(float2 __x, float2 __y){ return (float2)( __spirv_ocl_step(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) step(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) step(float3 __x, float3 __y){ return (float3)( __spirv_ocl_step(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) step(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) step(float4 __x, float4 __y){ return (float4)( __spirv_ocl_step(__x, __y)); }
inline float8 __attribute__((__overloadable__)) step(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) step(float8 __x, float8 __y){ return (float8)( __spirv_ocl_step(__x, __y)); }
inline float16 __attribute__((__overloadable__)) step(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) step(float16 __x, float16 __y){ return (float16)( __spirv_ocl_step(__x, __y)); }
inline float __attribute__((__overloadable__)) atan2pi(float __x, float __y);
inline float __attribute__((__overloadable__)) atan2pi(float __x, float __y){  return (float) __spirv_ocl_atan2pi(__x, __y); }
inline float2 __attribute__((__overloadable__)) atan2pi(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) atan2pi(float2 __x, float2 __y){ return (float2)( __spirv_ocl_atan2pi(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) atan2pi(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) atan2pi(float3 __x, float3 __y){ return (float3)( __spirv_ocl_atan2pi(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) atan2pi(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) atan2pi(float4 __x, float4 __y){ return (float4)( __spirv_ocl_atan2pi(__x, __y)); }
inline float8 __attribute__((__overloadable__)) atan2pi(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) atan2pi(float8 __x, float8 __y){ return (float8)( __spirv_ocl_atan2pi(__x, __y)); }
inline float16 __attribute__((__overloadable__)) atan2pi(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) atan2pi(float16 __x, float16 __y){ return (float16)( __spirv_ocl_atan2pi(__x, __y)); }
inline float __attribute__((__overloadable__)) maxmag(float __x, float __y);
inline float __attribute__((__overloadable__)) maxmag(float __x, float __y){  return (float) __spirv_ocl_maxmag(__x, __y); }
inline float2 __attribute__((__overloadable__)) maxmag(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) maxmag(float2 __x, float2 __y){ return (float2)( __spirv_ocl_maxmag(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) maxmag(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) maxmag(float3 __x, float3 __y){ return (float3)( __spirv_ocl_maxmag(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) maxmag(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) maxmag(float4 __x, float4 __y){ return (float4)( __spirv_ocl_maxmag(__x, __y)); }
inline float8 __attribute__((__overloadable__)) maxmag(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) maxmag(float8 __x, float8 __y){ return (float8)( __spirv_ocl_maxmag(__x, __y)); }
inline float16 __attribute__((__overloadable__)) maxmag(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) maxmag(float16 __x, float16 __y){ return (float16)( __spirv_ocl_maxmag(__x, __y)); }
inline float __attribute__((__overloadable__)) minmag(float __x, float __y);
inline float __attribute__((__overloadable__)) minmag(float __x, float __y){  return (float) __spirv_ocl_minmag(__x, __y); }
inline float2 __attribute__((__overloadable__)) minmag(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) minmag(float2 __x, float2 __y){ return (float2)( __spirv_ocl_minmag(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) minmag(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) minmag(float3 __x, float3 __y){ return (float3)( __spirv_ocl_minmag(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) minmag(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) minmag(float4 __x, float4 __y){ return (float4)( __spirv_ocl_minmag(__x, __y)); }
inline float8 __attribute__((__overloadable__)) minmag(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) minmag(float8 __x, float8 __y){ return (float8)( __spirv_ocl_minmag(__x, __y)); }
inline float16 __attribute__((__overloadable__)) minmag(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) minmag(float16 __x, float16 __y){ return (float16)( __spirv_ocl_minmag(__x, __y)); }
inline float __attribute__((__overloadable__)) pown(float __x, int __y);
inline float __attribute__((__overloadable__)) pown(float __x, int __y){  return __spirv_ocl_pown(__x, __y); }
inline float2 __attribute__((__overloadable__)) pown(float2 __x, int2 __y);
inline float2 __attribute__((__overloadable__)) pown(float2 __x, int2 __y){  return (float2)(__spirv_ocl_pown(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) pown(float3 __x, int3 __y);
inline float3 __attribute__((__overloadable__)) pown(float3 __x, int3 __y){  return (float3)(__spirv_ocl_pown(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) pown(float4 __x, int4 __y);
inline float4 __attribute__((__overloadable__)) pown(float4 __x, int4 __y){  return (float4)(__spirv_ocl_pown(__x, __y)); }
inline float8 __attribute__((__overloadable__)) pown(float8 __x, int8 __y);
inline float8 __attribute__((__overloadable__)) pown(float8 __x, int8 __y){  return (float8)(__spirv_ocl_pown(__x, __y)); }
inline float16 __attribute__((__overloadable__)) pown(float16 __x, int16 __y);
inline float16 __attribute__((__overloadable__)) pown(float16 __x, int16 __y){  return (float16)(__spirv_ocl_pown(__x, __y)); }
inline float __attribute__((__overloadable__)) rootn(float __x, int __y);
inline float __attribute__((__overloadable__)) rootn(float __x, int __y){  return __spirv_ocl_rootn(__x, __y); }
inline float2 __attribute__((__overloadable__)) rootn(float2 __x, int2 __y);
inline float2 __attribute__((__overloadable__)) rootn(float2 __x, int2 __y){  return (float2)(__spirv_ocl_rootn(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) rootn(float3 __x, int3 __y);
inline float3 __attribute__((__overloadable__)) rootn(float3 __x, int3 __y){  return (float3)(__spirv_ocl_rootn(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) rootn(float4 __x, int4 __y);
inline float4 __attribute__((__overloadable__)) rootn(float4 __x, int4 __y){  return (float4)(__spirv_ocl_rootn(__x, __y)); }
inline float8 __attribute__((__overloadable__)) rootn(float8 __x, int8 __y);
inline float8 __attribute__((__overloadable__)) rootn(float8 __x, int8 __y){  return (float8)(__spirv_ocl_rootn(__x, __y)); }
inline float16 __attribute__((__overloadable__)) rootn(float16 __x, int16 __y);
inline float16 __attribute__((__overloadable__)) rootn(float16 __x, int16 __y){  return (float16)(__spirv_ocl_rootn(__x, __y)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(float x, float y );
inline float __attribute__((__overloadable__,__always_inline__,const)) copysign(float x, float y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) copysign(float x, float y){ return (float)(__spirv_ocl_copysign(x, y)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(float2 x, float2 y );
inline float2 __attribute__((__overloadable__,__always_inline__,const)) copysign(float2 x, float2 y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) copysign(float2 x, float2 y){ return (float2)(__spirv_ocl_copysign(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(float3 x, float3 y );
inline float3 __attribute__((__overloadable__,__always_inline__,const)) copysign(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) copysign(float3 x, float3 y){ return (float3)(__spirv_ocl_copysign(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(float4 x, float4 y );
inline float4 __attribute__((__overloadable__,__always_inline__,const)) copysign(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) copysign(float4 x, float4 y){ return (float4)(__spirv_ocl_copysign(x, y)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(float8 x, float8 y );
inline float8 __attribute__((__overloadable__,__always_inline__,const)) copysign(float8 x, float8 y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__,const)) copysign(float8 x, float8 y){ return (float8)(__spirv_ocl_copysign(x, y)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(float16 x, float16 y );
inline float16 __attribute__((__overloadable__,__always_inline__,const)) copysign(float16 x, float16 y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__,const)) copysign(float16 x, float16 y){ return (float16)(__spirv_ocl_copysign(x, y)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(double x, double y );
inline double __attribute__((__overloadable__,__always_inline__,const)) copysign(double x, double y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) copysign(double x, double y){ return (double)(__spirv_ocl_copysign(x, y)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(double2 x, double2 y );
inline double2 __attribute__((__overloadable__,__always_inline__,const)) copysign(double2 x, double2 y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) copysign(double2 x, double2 y){ return (double2)(__spirv_ocl_copysign(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(double3 x, double3 y );
inline double3 __attribute__((__overloadable__,__always_inline__,const)) copysign(double3 x, double3 y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) copysign(double3 x, double3 y){ return (double3)(__spirv_ocl_copysign(x, y)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(double4 x, double4 y );
inline double4 __attribute__((__overloadable__,__always_inline__,const)) copysign(double4 x, double4 y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) copysign(double4 x, double4 y){ return (double4)(__spirv_ocl_copysign(x, y)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(double8 x, double8 y );
inline double8 __attribute__((__overloadable__,__always_inline__,const)) copysign(double8 x, double8 y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__,const)) copysign(double8 x, double8 y){ return (double8)(__spirv_ocl_copysign(x, y)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_copysign(double16 x, double16 y );
inline double16 __attribute__((__overloadable__,__always_inline__,const)) copysign(double16 x, double16 y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__,const)) copysign(double16 x, double16 y){ return (double16)(__spirv_ocl_copysign(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char __attribute__((__overloadable__)) __spirv_ocl_s_max(char _x, char  _y);
char __attribute__((__overloadable__)) __spirv_ocl_s_min(char _x, char  _y);
inline char __attribute__((__overloadable__)) max(char x, char y);
#ifndef NO_DEFINITION
inline char __attribute__((__overloadable__)) max(char x, char y){ return (char)(__spirv_ocl_s_max(x, y)); }
#endif
inline char __attribute__((__overloadable__)) min(char x, char y);
#ifndef NO_DEFINITION
inline char __attribute__((__overloadable__)) min(char x, char y){ return (char)(__spirv_ocl_s_min(x, y)); }
#endif
uchar __attribute__((__overloadable__)) __spirv_ocl_u_max(uchar _x, uchar  _y);
uchar __attribute__((__overloadable__)) __spirv_ocl_u_min(uchar _x, uchar  _y);
inline uchar __attribute__((__overloadable__)) max(uchar x, uchar y);
#ifndef NO_DEFINITION
inline uchar __attribute__((__overloadable__)) max(uchar x, uchar y){ return (uchar)(__spirv_ocl_u_max(x, y)); }
#endif
inline uchar __attribute__((__overloadable__)) min(uchar x, uchar y);
#ifndef NO_DEFINITION
inline uchar __attribute__((__overloadable__)) min(uchar x, uchar y){ return (uchar)(__spirv_ocl_u_min(x, y)); }
#endif
short __attribute__((__overloadable__)) __spirv_ocl_s_max(short _x, short  _y);
short __attribute__((__overloadable__)) __spirv_ocl_s_min(short _x, short  _y);
inline short __attribute__((__overloadable__)) max(short x, short y);
#ifndef NO_DEFINITION
inline short __attribute__((__overloadable__)) max(short x, short y){ return (short)(__spirv_ocl_s_max(x, y)); }
#endif
inline short __attribute__((__overloadable__)) min(short x, short y);
#ifndef NO_DEFINITION
inline short __attribute__((__overloadable__)) min(short x, short y){ return (short)(__spirv_ocl_s_min(x, y)); }
#endif
ushort __attribute__((__overloadable__)) __spirv_ocl_u_max(ushort _x, ushort  _y);
ushort __attribute__((__overloadable__)) __spirv_ocl_u_min(ushort _x, ushort  _y);
inline ushort __attribute__((__overloadable__)) max(ushort x, ushort y);
#ifndef NO_DEFINITION
inline ushort __attribute__((__overloadable__)) max(ushort x, ushort y){ return (ushort)(__spirv_ocl_u_max(x, y)); }
#endif
inline ushort __attribute__((__overloadable__)) min(ushort x, ushort y);
#ifndef NO_DEFINITION
inline ushort __attribute__((__overloadable__)) min(ushort x, ushort y){ return (ushort)(__spirv_ocl_u_min(x, y)); }
#endif
int __attribute__((__overloadable__)) __spirv_ocl_s_max(int _x, int  _y);
int __attribute__((__overloadable__)) __spirv_ocl_s_min(int _x, int  _y);
inline int __attribute__((__overloadable__)) max(int x, int y);
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__)) max(int x, int y){ return (int)(__spirv_ocl_s_max(x, y)); }
#endif
inline int __attribute__((__overloadable__)) min(int x, int y);
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__)) min(int x, int y){ return (int)(__spirv_ocl_s_min(x, y)); }
#endif
uint __attribute__((__overloadable__)) __spirv_ocl_u_max(uint _x, uint  _y);
uint __attribute__((__overloadable__)) __spirv_ocl_u_min(uint _x, uint  _y);
inline uint __attribute__((__overloadable__)) max(uint x, uint y);
#ifndef NO_DEFINITION
inline uint __attribute__((__overloadable__)) max(uint x, uint y){ return (uint)(__spirv_ocl_u_max(x, y)); }
#endif
inline uint __attribute__((__overloadable__)) min(uint x, uint y);
#ifndef NO_DEFINITION
inline uint __attribute__((__overloadable__)) min(uint x, uint y){ return (uint)(__spirv_ocl_u_min(x, y)); }
#endif
long __attribute__((__overloadable__)) __spirv_ocl_s_max(long _x, long  _y);
long __attribute__((__overloadable__)) __spirv_ocl_s_min(long _x, long  _y);
inline long __attribute__((__overloadable__)) max(long x, long y);
#ifndef NO_DEFINITION
inline long __attribute__((__overloadable__)) max(long x, long y){ return (long)(__spirv_ocl_s_max(x, y)); }
#endif
inline long __attribute__((__overloadable__)) min(long x, long y);
#ifndef NO_DEFINITION
inline long __attribute__((__overloadable__)) min(long x, long y){ return (long)(__spirv_ocl_s_min(x, y)); }
#endif
ulong __attribute__((__overloadable__)) __spirv_ocl_u_max(ulong _x, ulong  _y);
ulong __attribute__((__overloadable__)) __spirv_ocl_u_min(ulong _x, ulong  _y);
inline ulong __attribute__((__overloadable__)) max(ulong x, ulong y);
#ifndef NO_DEFINITION
inline ulong __attribute__((__overloadable__)) max(ulong x, ulong y){ return (ulong)(__spirv_ocl_u_max(x, y)); }
#endif
inline ulong __attribute__((__overloadable__)) min(ulong x, ulong y);
#ifndef NO_DEFINITION
inline ulong __attribute__((__overloadable__)) min(ulong x, ulong y){ return (ulong)(__spirv_ocl_u_min(x, y)); }
#endif
#endif
float __attribute__((__overloadable__)) __spirv_ocl_fmax_common(float _x, float  _y);
float __attribute__((__overloadable__)) __spirv_ocl_fmin_common(float _x, float  _y);
inline float __attribute__((__overloadable__)) max(float x, float y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__)) max(float x, float y){ return (float)(__spirv_ocl_fmax_common(x, y)); }
#endif
inline float __attribute__((__overloadable__)) min(float x, float y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__)) min(float x, float y){ return (float)(__spirv_ocl_fmin_common(x, y)); }
#endif
double __attribute__((__overloadable__)) __spirv_ocl_fmax_common(double _x, double  _y);
double __attribute__((__overloadable__)) __spirv_ocl_fmin_common(double _x, double  _y);
inline double __attribute__((__overloadable__)) max(double x, double y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__)) max(double x, double y){ return (double)(__spirv_ocl_fmax_common(x, y)); }
#endif
inline double __attribute__((__overloadable__)) min(double x, double y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__)) min(double x, double y){ return (double)(__spirv_ocl_fmin_common(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char2 __attribute__((__overloadable__)) __spirv_ocl_s_min( char2 _x, char2 _y);
inline char2 __attribute__((__overloadable__)) min(char2 x, char2 y);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__)) min(char2 x, char2 y){ return (char2)(__spirv_ocl_s_min(x, y)); }
#endif
char2 __attribute__((__overloadable__)) __spirv_ocl_s_min( char2 _x, char _y);
inline char2 __attribute__((__overloadable__)) min(char2 x, char y);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__)) min(char2 x, char y){ return (char2)(__spirv_ocl_s_min(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__)) __spirv_ocl_s_min( char3 _x, char3 _y);
inline char3 __attribute__((__overloadable__)) min(char3 x, char3 y);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__)) min(char3 x, char3 y){ return (char3)(__spirv_ocl_s_min(x, y)); }
#endif
char3 __attribute__((__overloadable__)) __spirv_ocl_s_min( char3 _x, char _y);
inline char3 __attribute__((__overloadable__)) min(char3 x, char y);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__)) min(char3 x, char y){ return (char3)(__spirv_ocl_s_min(x, y)); }
#endif
#endif
char4 __attribute__((__overloadable__)) __spirv_ocl_s_min( char4 _x, char4 _y);
inline char4 __attribute__((__overloadable__)) min(char4 x, char4 y);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__)) min(char4 x, char4 y){ return (char4)(__spirv_ocl_s_min(x, y)); }
#endif
char4 __attribute__((__overloadable__)) __spirv_ocl_s_min( char4 _x, char _y);
inline char4 __attribute__((__overloadable__)) min(char4 x, char y);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__)) min(char4 x, char y){ return (char4)(__spirv_ocl_s_min(x, y)); }
#endif
char8 __attribute__((__overloadable__)) __spirv_ocl_s_min( char8 _x, char8 _y);
inline char8 __attribute__((__overloadable__)) min(char8 x, char8 y);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__)) min(char8 x, char8 y){ return (char8)(__spirv_ocl_s_min(x, y)); }
#endif
char8 __attribute__((__overloadable__)) __spirv_ocl_s_min( char8 _x, char _y);
inline char8 __attribute__((__overloadable__)) min(char8 x, char y);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__)) min(char8 x, char y){ return (char8)(__spirv_ocl_s_min(x, y)); }
#endif
char16 __attribute__((__overloadable__)) __spirv_ocl_s_min( char16 _x, char16 _y);
inline char16 __attribute__((__overloadable__)) min(char16 x, char16 y);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__)) min(char16 x, char16 y){ return (char16)(__spirv_ocl_s_min(x, y)); }
#endif
char16 __attribute__((__overloadable__)) __spirv_ocl_s_min( char16 _x, char _y);
inline char16 __attribute__((__overloadable__)) min(char16 x, char y);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__)) min(char16 x, char y){ return (char16)(__spirv_ocl_s_min(x, y)); }
#endif
char2 __attribute__((__overloadable__)) __spirv_ocl_s_max( char2 _x, char2 _y);
inline char2 __attribute__((__overloadable__)) max(char2 x, char2 y);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__)) max(char2 x, char2 y){ return (char2)(__spirv_ocl_s_max(x, y)); }
#endif
char2 __attribute__((__overloadable__)) __spirv_ocl_s_max( char2 _x, char _y);
inline char2 __attribute__((__overloadable__)) max(char2 x, char y);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__)) max(char2 x, char y){ return (char2)(__spirv_ocl_s_max(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__)) __spirv_ocl_s_max( char3 _x, char3 _y);
inline char3 __attribute__((__overloadable__)) max(char3 x, char3 y);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__)) max(char3 x, char3 y){ return (char3)(__spirv_ocl_s_max(x, y)); }
#endif
char3 __attribute__((__overloadable__)) __spirv_ocl_s_max( char3 _x, char _y);
inline char3 __attribute__((__overloadable__)) max(char3 x, char y);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__)) max(char3 x, char y){ return (char3)(__spirv_ocl_s_max(x, y)); }
#endif
#endif
char4 __attribute__((__overloadable__)) __spirv_ocl_s_max( char4 _x, char4 _y);
inline char4 __attribute__((__overloadable__)) max(char4 x, char4 y);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__)) max(char4 x, char4 y){ return (char4)(__spirv_ocl_s_max(x, y)); }
#endif
char4 __attribute__((__overloadable__)) __spirv_ocl_s_max( char4 _x, char _y);
inline char4 __attribute__((__overloadable__)) max(char4 x, char y);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__)) max(char4 x, char y){ return (char4)(__spirv_ocl_s_max(x, y)); }
#endif
char8 __attribute__((__overloadable__)) __spirv_ocl_s_max( char8 _x, char8 _y);
inline char8 __attribute__((__overloadable__)) max(char8 x, char8 y);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__)) max(char8 x, char8 y){ return (char8)(__spirv_ocl_s_max(x, y)); }
#endif
char8 __attribute__((__overloadable__)) __spirv_ocl_s_max( char8 _x, char _y);
inline char8 __attribute__((__overloadable__)) max(char8 x, char y);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__)) max(char8 x, char y){ return (char8)(__spirv_ocl_s_max(x, y)); }
#endif
char16 __attribute__((__overloadable__)) __spirv_ocl_s_max( char16 _x, char16 _y);
inline char16 __attribute__((__overloadable__)) max(char16 x, char16 y);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__)) max(char16 x, char16 y){ return (char16)(__spirv_ocl_s_max(x, y)); }
#endif
char16 __attribute__((__overloadable__)) __spirv_ocl_s_max( char16 _x, char _y);
inline char16 __attribute__((__overloadable__)) max(char16 x, char y);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__)) max(char16 x, char y){ return (char16)(__spirv_ocl_s_max(x, y)); }
#endif
uchar2 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar2 _x, uchar2 _y);
inline uchar2 __attribute__((__overloadable__)) min(uchar2 x, uchar2 y);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__)) min(uchar2 x, uchar2 y){ return (uchar2)(__spirv_ocl_u_min(x, y)); }
#endif
uchar2 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar2 _x, uchar _y);
inline uchar2 __attribute__((__overloadable__)) min(uchar2 x, uchar y);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__)) min(uchar2 x, uchar y){ return (uchar2)(__spirv_ocl_u_min(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uchar3 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar3 _x, uchar3 _y);
inline uchar3 __attribute__((__overloadable__)) min(uchar3 x, uchar3 y);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__)) min(uchar3 x, uchar3 y){ return (uchar3)(__spirv_ocl_u_min(x, y)); }
#endif
uchar3 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar3 _x, uchar _y);
inline uchar3 __attribute__((__overloadable__)) min(uchar3 x, uchar y);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__)) min(uchar3 x, uchar y){ return (uchar3)(__spirv_ocl_u_min(x, y)); }
#endif
#endif
uchar4 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar4 _x, uchar4 _y);
inline uchar4 __attribute__((__overloadable__)) min(uchar4 x, uchar4 y);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__)) min(uchar4 x, uchar4 y){ return (uchar4)(__spirv_ocl_u_min(x, y)); }
#endif
uchar4 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar4 _x, uchar _y);
inline uchar4 __attribute__((__overloadable__)) min(uchar4 x, uchar y);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__)) min(uchar4 x, uchar y){ return (uchar4)(__spirv_ocl_u_min(x, y)); }
#endif
uchar8 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar8 _x, uchar8 _y);
inline uchar8 __attribute__((__overloadable__)) min(uchar8 x, uchar8 y);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__)) min(uchar8 x, uchar8 y){ return (uchar8)(__spirv_ocl_u_min(x, y)); }
#endif
uchar8 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar8 _x, uchar _y);
inline uchar8 __attribute__((__overloadable__)) min(uchar8 x, uchar y);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__)) min(uchar8 x, uchar y){ return (uchar8)(__spirv_ocl_u_min(x, y)); }
#endif
uchar16 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar16 _x, uchar16 _y);
inline uchar16 __attribute__((__overloadable__)) min(uchar16 x, uchar16 y);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__)) min(uchar16 x, uchar16 y){ return (uchar16)(__spirv_ocl_u_min(x, y)); }
#endif
uchar16 __attribute__((__overloadable__)) __spirv_ocl_u_min( uchar16 _x, uchar _y);
inline uchar16 __attribute__((__overloadable__)) min(uchar16 x, uchar y);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__)) min(uchar16 x, uchar y){ return (uchar16)(__spirv_ocl_u_min(x, y)); }
#endif
uchar2 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar2 _x, uchar2 _y);
inline uchar2 __attribute__((__overloadable__)) max(uchar2 x, uchar2 y);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__)) max(uchar2 x, uchar2 y){ return (uchar2)(__spirv_ocl_u_max(x, y)); }
#endif
uchar2 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar2 _x, uchar _y);
inline uchar2 __attribute__((__overloadable__)) max(uchar2 x, uchar y);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__)) max(uchar2 x, uchar y){ return (uchar2)(__spirv_ocl_u_max(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uchar3 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar3 _x, uchar3 _y);
inline uchar3 __attribute__((__overloadable__)) max(uchar3 x, uchar3 y);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__)) max(uchar3 x, uchar3 y){ return (uchar3)(__spirv_ocl_u_max(x, y)); }
#endif
uchar3 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar3 _x, uchar _y);
inline uchar3 __attribute__((__overloadable__)) max(uchar3 x, uchar y);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__)) max(uchar3 x, uchar y){ return (uchar3)(__spirv_ocl_u_max(x, y)); }
#endif
#endif
uchar4 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar4 _x, uchar4 _y);
inline uchar4 __attribute__((__overloadable__)) max(uchar4 x, uchar4 y);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__)) max(uchar4 x, uchar4 y){ return (uchar4)(__spirv_ocl_u_max(x, y)); }
#endif
uchar4 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar4 _x, uchar _y);
inline uchar4 __attribute__((__overloadable__)) max(uchar4 x, uchar y);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__)) max(uchar4 x, uchar y){ return (uchar4)(__spirv_ocl_u_max(x, y)); }
#endif
uchar8 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar8 _x, uchar8 _y);
inline uchar8 __attribute__((__overloadable__)) max(uchar8 x, uchar8 y);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__)) max(uchar8 x, uchar8 y){ return (uchar8)(__spirv_ocl_u_max(x, y)); }
#endif
uchar8 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar8 _x, uchar _y);
inline uchar8 __attribute__((__overloadable__)) max(uchar8 x, uchar y);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__)) max(uchar8 x, uchar y){ return (uchar8)(__spirv_ocl_u_max(x, y)); }
#endif
uchar16 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar16 _x, uchar16 _y);
inline uchar16 __attribute__((__overloadable__)) max(uchar16 x, uchar16 y);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__)) max(uchar16 x, uchar16 y){ return (uchar16)(__spirv_ocl_u_max(x, y)); }
#endif
uchar16 __attribute__((__overloadable__)) __spirv_ocl_u_max( uchar16 _x, uchar _y);
inline uchar16 __attribute__((__overloadable__)) max(uchar16 x, uchar y);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__)) max(uchar16 x, uchar y){ return (uchar16)(__spirv_ocl_u_max(x, y)); }
#endif
short2 __attribute__((__overloadable__)) __spirv_ocl_s_min( short2 _x, short2 _y);
inline short2 __attribute__((__overloadable__)) min(short2 x, short2 y);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__)) min(short2 x, short2 y){ return (short2)(__spirv_ocl_s_min(x, y)); }
#endif
short2 __attribute__((__overloadable__)) __spirv_ocl_s_min( short2 _x, short _y);
inline short2 __attribute__((__overloadable__)) min(short2 x, short y);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__)) min(short2 x, short y){ return (short2)(__spirv_ocl_s_min(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
short3 __attribute__((__overloadable__)) __spirv_ocl_s_min( short3 _x, short3 _y);
inline short3 __attribute__((__overloadable__)) min(short3 x, short3 y);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__)) min(short3 x, short3 y){ return (short3)(__spirv_ocl_s_min(x, y)); }
#endif
short3 __attribute__((__overloadable__)) __spirv_ocl_s_min( short3 _x, short _y);
inline short3 __attribute__((__overloadable__)) min(short3 x, short y);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__)) min(short3 x, short y){ return (short3)(__spirv_ocl_s_min(x, y)); }
#endif
#endif
short4 __attribute__((__overloadable__)) __spirv_ocl_s_min( short4 _x, short4 _y);
inline short4 __attribute__((__overloadable__)) min(short4 x, short4 y);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__)) min(short4 x, short4 y){ return (short4)(__spirv_ocl_s_min(x, y)); }
#endif
short4 __attribute__((__overloadable__)) __spirv_ocl_s_min( short4 _x, short _y);
inline short4 __attribute__((__overloadable__)) min(short4 x, short y);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__)) min(short4 x, short y){ return (short4)(__spirv_ocl_s_min(x, y)); }
#endif
short8 __attribute__((__overloadable__)) __spirv_ocl_s_min( short8 _x, short8 _y);
inline short8 __attribute__((__overloadable__)) min(short8 x, short8 y);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__)) min(short8 x, short8 y){ return (short8)(__spirv_ocl_s_min(x, y)); }
#endif
short8 __attribute__((__overloadable__)) __spirv_ocl_s_min( short8 _x, short _y);
inline short8 __attribute__((__overloadable__)) min(short8 x, short y);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__)) min(short8 x, short y){ return (short8)(__spirv_ocl_s_min(x, y)); }
#endif
short16 __attribute__((__overloadable__)) __spirv_ocl_s_min( short16 _x, short16 _y);
inline short16 __attribute__((__overloadable__)) min(short16 x, short16 y);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__)) min(short16 x, short16 y){ return (short16)(__spirv_ocl_s_min(x, y)); }
#endif
short16 __attribute__((__overloadable__)) __spirv_ocl_s_min( short16 _x, short _y);
inline short16 __attribute__((__overloadable__)) min(short16 x, short y);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__)) min(short16 x, short y){ return (short16)(__spirv_ocl_s_min(x, y)); }
#endif
short2 __attribute__((__overloadable__)) __spirv_ocl_s_max( short2 _x, short2 _y);
inline short2 __attribute__((__overloadable__)) max(short2 x, short2 y);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__)) max(short2 x, short2 y){ return (short2)(__spirv_ocl_s_max(x, y)); }
#endif
short2 __attribute__((__overloadable__)) __spirv_ocl_s_max( short2 _x, short _y);
inline short2 __attribute__((__overloadable__)) max(short2 x, short y);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__)) max(short2 x, short y){ return (short2)(__spirv_ocl_s_max(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
short3 __attribute__((__overloadable__)) __spirv_ocl_s_max( short3 _x, short3 _y);
inline short3 __attribute__((__overloadable__)) max(short3 x, short3 y);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__)) max(short3 x, short3 y){ return (short3)(__spirv_ocl_s_max(x, y)); }
#endif
short3 __attribute__((__overloadable__)) __spirv_ocl_s_max( short3 _x, short _y);
inline short3 __attribute__((__overloadable__)) max(short3 x, short y);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__)) max(short3 x, short y){ return (short3)(__spirv_ocl_s_max(x, y)); }
#endif
#endif
short4 __attribute__((__overloadable__)) __spirv_ocl_s_max( short4 _x, short4 _y);
inline short4 __attribute__((__overloadable__)) max(short4 x, short4 y);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__)) max(short4 x, short4 y){ return (short4)(__spirv_ocl_s_max(x, y)); }
#endif
short4 __attribute__((__overloadable__)) __spirv_ocl_s_max( short4 _x, short _y);
inline short4 __attribute__((__overloadable__)) max(short4 x, short y);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__)) max(short4 x, short y){ return (short4)(__spirv_ocl_s_max(x, y)); }
#endif
short8 __attribute__((__overloadable__)) __spirv_ocl_s_max( short8 _x, short8 _y);
inline short8 __attribute__((__overloadable__)) max(short8 x, short8 y);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__)) max(short8 x, short8 y){ return (short8)(__spirv_ocl_s_max(x, y)); }
#endif
short8 __attribute__((__overloadable__)) __spirv_ocl_s_max( short8 _x, short _y);
inline short8 __attribute__((__overloadable__)) max(short8 x, short y);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__)) max(short8 x, short y){ return (short8)(__spirv_ocl_s_max(x, y)); }
#endif
short16 __attribute__((__overloadable__)) __spirv_ocl_s_max( short16 _x, short16 _y);
inline short16 __attribute__((__overloadable__)) max(short16 x, short16 y);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__)) max(short16 x, short16 y){ return (short16)(__spirv_ocl_s_max(x, y)); }
#endif
short16 __attribute__((__overloadable__)) __spirv_ocl_s_max( short16 _x, short _y);
inline short16 __attribute__((__overloadable__)) max(short16 x, short y);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__)) max(short16 x, short y){ return (short16)(__spirv_ocl_s_max(x, y)); }
#endif
ushort2 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort2 _x, ushort2 _y);
inline ushort2 __attribute__((__overloadable__)) min(ushort2 x, ushort2 y);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__)) min(ushort2 x, ushort2 y){ return (ushort2)(__spirv_ocl_u_min(x, y)); }
#endif
ushort2 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort2 _x, ushort _y);
inline ushort2 __attribute__((__overloadable__)) min(ushort2 x, ushort y);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__)) min(ushort2 x, ushort y){ return (ushort2)(__spirv_ocl_u_min(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ushort3 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort3 _x, ushort3 _y);
inline ushort3 __attribute__((__overloadable__)) min(ushort3 x, ushort3 y);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__)) min(ushort3 x, ushort3 y){ return (ushort3)(__spirv_ocl_u_min(x, y)); }
#endif
ushort3 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort3 _x, ushort _y);
inline ushort3 __attribute__((__overloadable__)) min(ushort3 x, ushort y);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__)) min(ushort3 x, ushort y){ return (ushort3)(__spirv_ocl_u_min(x, y)); }
#endif
#endif
ushort4 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort4 _x, ushort4 _y);
inline ushort4 __attribute__((__overloadable__)) min(ushort4 x, ushort4 y);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__)) min(ushort4 x, ushort4 y){ return (ushort4)(__spirv_ocl_u_min(x, y)); }
#endif
ushort4 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort4 _x, ushort _y);
inline ushort4 __attribute__((__overloadable__)) min(ushort4 x, ushort y);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__)) min(ushort4 x, ushort y){ return (ushort4)(__spirv_ocl_u_min(x, y)); }
#endif
ushort8 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort8 _x, ushort8 _y);
inline ushort8 __attribute__((__overloadable__)) min(ushort8 x, ushort8 y);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__)) min(ushort8 x, ushort8 y){ return (ushort8)(__spirv_ocl_u_min(x, y)); }
#endif
ushort8 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort8 _x, ushort _y);
inline ushort8 __attribute__((__overloadable__)) min(ushort8 x, ushort y);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__)) min(ushort8 x, ushort y){ return (ushort8)(__spirv_ocl_u_min(x, y)); }
#endif
ushort16 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort16 _x, ushort16 _y);
inline ushort16 __attribute__((__overloadable__)) min(ushort16 x, ushort16 y);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__)) min(ushort16 x, ushort16 y){ return (ushort16)(__spirv_ocl_u_min(x, y)); }
#endif
ushort16 __attribute__((__overloadable__)) __spirv_ocl_u_min( ushort16 _x, ushort _y);
inline ushort16 __attribute__((__overloadable__)) min(ushort16 x, ushort y);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__)) min(ushort16 x, ushort y){ return (ushort16)(__spirv_ocl_u_min(x, y)); }
#endif
ushort2 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort2 _x, ushort2 _y);
inline ushort2 __attribute__((__overloadable__)) max(ushort2 x, ushort2 y);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__)) max(ushort2 x, ushort2 y){ return (ushort2)(__spirv_ocl_u_max(x, y)); }
#endif
ushort2 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort2 _x, ushort _y);
inline ushort2 __attribute__((__overloadable__)) max(ushort2 x, ushort y);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__)) max(ushort2 x, ushort y){ return (ushort2)(__spirv_ocl_u_max(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ushort3 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort3 _x, ushort3 _y);
inline ushort3 __attribute__((__overloadable__)) max(ushort3 x, ushort3 y);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__)) max(ushort3 x, ushort3 y){ return (ushort3)(__spirv_ocl_u_max(x, y)); }
#endif
ushort3 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort3 _x, ushort _y);
inline ushort3 __attribute__((__overloadable__)) max(ushort3 x, ushort y);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__)) max(ushort3 x, ushort y){ return (ushort3)(__spirv_ocl_u_max(x, y)); }
#endif
#endif
ushort4 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort4 _x, ushort4 _y);
inline ushort4 __attribute__((__overloadable__)) max(ushort4 x, ushort4 y);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__)) max(ushort4 x, ushort4 y){ return (ushort4)(__spirv_ocl_u_max(x, y)); }
#endif
ushort4 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort4 _x, ushort _y);
inline ushort4 __attribute__((__overloadable__)) max(ushort4 x, ushort y);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__)) max(ushort4 x, ushort y){ return (ushort4)(__spirv_ocl_u_max(x, y)); }
#endif
ushort8 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort8 _x, ushort8 _y);
inline ushort8 __attribute__((__overloadable__)) max(ushort8 x, ushort8 y);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__)) max(ushort8 x, ushort8 y){ return (ushort8)(__spirv_ocl_u_max(x, y)); }
#endif
ushort8 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort8 _x, ushort _y);
inline ushort8 __attribute__((__overloadable__)) max(ushort8 x, ushort y);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__)) max(ushort8 x, ushort y){ return (ushort8)(__spirv_ocl_u_max(x, y)); }
#endif
ushort16 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort16 _x, ushort16 _y);
inline ushort16 __attribute__((__overloadable__)) max(ushort16 x, ushort16 y);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__)) max(ushort16 x, ushort16 y){ return (ushort16)(__spirv_ocl_u_max(x, y)); }
#endif
ushort16 __attribute__((__overloadable__)) __spirv_ocl_u_max( ushort16 _x, ushort _y);
inline ushort16 __attribute__((__overloadable__)) max(ushort16 x, ushort y);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__)) max(ushort16 x, ushort y){ return (ushort16)(__spirv_ocl_u_max(x, y)); }
#endif
int2 __attribute__((__overloadable__)) __spirv_ocl_s_min( int2 _x, int2 _y);
inline int2 __attribute__((__overloadable__)) min(int2 x, int2 y);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__)) min(int2 x, int2 y){ return (int2)(__spirv_ocl_s_min(x, y)); }
#endif
int2 __attribute__((__overloadable__)) __spirv_ocl_s_min( int2 _x, int _y);
inline int2 __attribute__((__overloadable__)) min(int2 x, int y);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__)) min(int2 x, int y){ return (int2)(__spirv_ocl_s_min(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
int3 __attribute__((__overloadable__)) __spirv_ocl_s_min( int3 _x, int3 _y);
inline int3 __attribute__((__overloadable__)) min(int3 x, int3 y);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__)) min(int3 x, int3 y){ return (int3)(__spirv_ocl_s_min(x, y)); }
#endif
int3 __attribute__((__overloadable__)) __spirv_ocl_s_min( int3 _x, int _y);
inline int3 __attribute__((__overloadable__)) min(int3 x, int y);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__)) min(int3 x, int y){ return (int3)(__spirv_ocl_s_min(x, y)); }
#endif
#endif
int4 __attribute__((__overloadable__)) __spirv_ocl_s_min( int4 _x, int4 _y);
inline int4 __attribute__((__overloadable__)) min(int4 x, int4 y);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__)) min(int4 x, int4 y){ return (int4)(__spirv_ocl_s_min(x, y)); }
#endif
int4 __attribute__((__overloadable__)) __spirv_ocl_s_min( int4 _x, int _y);
inline int4 __attribute__((__overloadable__)) min(int4 x, int y);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__)) min(int4 x, int y){ return (int4)(__spirv_ocl_s_min(x, y)); }
#endif
int8 __attribute__((__overloadable__)) __spirv_ocl_s_min( int8 _x, int8 _y);
inline int8 __attribute__((__overloadable__)) min(int8 x, int8 y);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__)) min(int8 x, int8 y){ return (int8)(__spirv_ocl_s_min(x, y)); }
#endif
int8 __attribute__((__overloadable__)) __spirv_ocl_s_min( int8 _x, int _y);
inline int8 __attribute__((__overloadable__)) min(int8 x, int y);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__)) min(int8 x, int y){ return (int8)(__spirv_ocl_s_min(x, y)); }
#endif
int16 __attribute__((__overloadable__)) __spirv_ocl_s_min( int16 _x, int16 _y);
inline int16 __attribute__((__overloadable__)) min(int16 x, int16 y);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__)) min(int16 x, int16 y){ return (int16)(__spirv_ocl_s_min(x, y)); }
#endif
int16 __attribute__((__overloadable__)) __spirv_ocl_s_min( int16 _x, int _y);
inline int16 __attribute__((__overloadable__)) min(int16 x, int y);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__)) min(int16 x, int y){ return (int16)(__spirv_ocl_s_min(x, y)); }
#endif
int2 __attribute__((__overloadable__)) __spirv_ocl_s_max( int2 _x, int2 _y);
inline int2 __attribute__((__overloadable__)) max(int2 x, int2 y);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__)) max(int2 x, int2 y){ return (int2)(__spirv_ocl_s_max(x, y)); }
#endif
int2 __attribute__((__overloadable__)) __spirv_ocl_s_max( int2 _x, int _y);
inline int2 __attribute__((__overloadable__)) max(int2 x, int y);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__)) max(int2 x, int y){ return (int2)(__spirv_ocl_s_max(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
int3 __attribute__((__overloadable__)) __spirv_ocl_s_max( int3 _x, int3 _y);
inline int3 __attribute__((__overloadable__)) max(int3 x, int3 y);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__)) max(int3 x, int3 y){ return (int3)(__spirv_ocl_s_max(x, y)); }
#endif
int3 __attribute__((__overloadable__)) __spirv_ocl_s_max( int3 _x, int _y);
inline int3 __attribute__((__overloadable__)) max(int3 x, int y);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__)) max(int3 x, int y){ return (int3)(__spirv_ocl_s_max(x, y)); }
#endif
#endif
int4 __attribute__((__overloadable__)) __spirv_ocl_s_max( int4 _x, int4 _y);
inline int4 __attribute__((__overloadable__)) max(int4 x, int4 y);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__)) max(int4 x, int4 y){ return (int4)(__spirv_ocl_s_max(x, y)); }
#endif
int4 __attribute__((__overloadable__)) __spirv_ocl_s_max( int4 _x, int _y);
inline int4 __attribute__((__overloadable__)) max(int4 x, int y);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__)) max(int4 x, int y){ return (int4)(__spirv_ocl_s_max(x, y)); }
#endif
int8 __attribute__((__overloadable__)) __spirv_ocl_s_max( int8 _x, int8 _y);
inline int8 __attribute__((__overloadable__)) max(int8 x, int8 y);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__)) max(int8 x, int8 y){ return (int8)(__spirv_ocl_s_max(x, y)); }
#endif
int8 __attribute__((__overloadable__)) __spirv_ocl_s_max( int8 _x, int _y);
inline int8 __attribute__((__overloadable__)) max(int8 x, int y);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__)) max(int8 x, int y){ return (int8)(__spirv_ocl_s_max(x, y)); }
#endif
int16 __attribute__((__overloadable__)) __spirv_ocl_s_max( int16 _x, int16 _y);
inline int16 __attribute__((__overloadable__)) max(int16 x, int16 y);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__)) max(int16 x, int16 y){ return (int16)(__spirv_ocl_s_max(x, y)); }
#endif
int16 __attribute__((__overloadable__)) __spirv_ocl_s_max( int16 _x, int _y);
inline int16 __attribute__((__overloadable__)) max(int16 x, int y);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__)) max(int16 x, int y){ return (int16)(__spirv_ocl_s_max(x, y)); }
#endif
uint2 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint2 _x, uint2 _y);
inline uint2 __attribute__((__overloadable__)) min(uint2 x, uint2 y);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__)) min(uint2 x, uint2 y){ return (uint2)(__spirv_ocl_u_min(x, y)); }
#endif
uint2 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint2 _x, uint _y);
inline uint2 __attribute__((__overloadable__)) min(uint2 x, uint y);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__)) min(uint2 x, uint y){ return (uint2)(__spirv_ocl_u_min(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uint3 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint3 _x, uint3 _y);
inline uint3 __attribute__((__overloadable__)) min(uint3 x, uint3 y);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__)) min(uint3 x, uint3 y){ return (uint3)(__spirv_ocl_u_min(x, y)); }
#endif
uint3 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint3 _x, uint _y);
inline uint3 __attribute__((__overloadable__)) min(uint3 x, uint y);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__)) min(uint3 x, uint y){ return (uint3)(__spirv_ocl_u_min(x, y)); }
#endif
#endif
uint4 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint4 _x, uint4 _y);
inline uint4 __attribute__((__overloadable__)) min(uint4 x, uint4 y);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__)) min(uint4 x, uint4 y){ return (uint4)(__spirv_ocl_u_min(x, y)); }
#endif
uint4 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint4 _x, uint _y);
inline uint4 __attribute__((__overloadable__)) min(uint4 x, uint y);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__)) min(uint4 x, uint y){ return (uint4)(__spirv_ocl_u_min(x, y)); }
#endif
uint8 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint8 _x, uint8 _y);
inline uint8 __attribute__((__overloadable__)) min(uint8 x, uint8 y);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__)) min(uint8 x, uint8 y){ return (uint8)(__spirv_ocl_u_min(x, y)); }
#endif
uint8 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint8 _x, uint _y);
inline uint8 __attribute__((__overloadable__)) min(uint8 x, uint y);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__)) min(uint8 x, uint y){ return (uint8)(__spirv_ocl_u_min(x, y)); }
#endif
uint16 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint16 _x, uint16 _y);
inline uint16 __attribute__((__overloadable__)) min(uint16 x, uint16 y);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__)) min(uint16 x, uint16 y){ return (uint16)(__spirv_ocl_u_min(x, y)); }
#endif
uint16 __attribute__((__overloadable__)) __spirv_ocl_u_min( uint16 _x, uint _y);
inline uint16 __attribute__((__overloadable__)) min(uint16 x, uint y);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__)) min(uint16 x, uint y){ return (uint16)(__spirv_ocl_u_min(x, y)); }
#endif
uint2 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint2 _x, uint2 _y);
inline uint2 __attribute__((__overloadable__)) max(uint2 x, uint2 y);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__)) max(uint2 x, uint2 y){ return (uint2)(__spirv_ocl_u_max(x, y)); }
#endif
uint2 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint2 _x, uint _y);
inline uint2 __attribute__((__overloadable__)) max(uint2 x, uint y);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__)) max(uint2 x, uint y){ return (uint2)(__spirv_ocl_u_max(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uint3 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint3 _x, uint3 _y);
inline uint3 __attribute__((__overloadable__)) max(uint3 x, uint3 y);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__)) max(uint3 x, uint3 y){ return (uint3)(__spirv_ocl_u_max(x, y)); }
#endif
uint3 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint3 _x, uint _y);
inline uint3 __attribute__((__overloadable__)) max(uint3 x, uint y);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__)) max(uint3 x, uint y){ return (uint3)(__spirv_ocl_u_max(x, y)); }
#endif
#endif
uint4 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint4 _x, uint4 _y);
inline uint4 __attribute__((__overloadable__)) max(uint4 x, uint4 y);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__)) max(uint4 x, uint4 y){ return (uint4)(__spirv_ocl_u_max(x, y)); }
#endif
uint4 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint4 _x, uint _y);
inline uint4 __attribute__((__overloadable__)) max(uint4 x, uint y);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__)) max(uint4 x, uint y){ return (uint4)(__spirv_ocl_u_max(x, y)); }
#endif
uint8 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint8 _x, uint8 _y);
inline uint8 __attribute__((__overloadable__)) max(uint8 x, uint8 y);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__)) max(uint8 x, uint8 y){ return (uint8)(__spirv_ocl_u_max(x, y)); }
#endif
uint8 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint8 _x, uint _y);
inline uint8 __attribute__((__overloadable__)) max(uint8 x, uint y);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__)) max(uint8 x, uint y){ return (uint8)(__spirv_ocl_u_max(x, y)); }
#endif
uint16 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint16 _x, uint16 _y);
inline uint16 __attribute__((__overloadable__)) max(uint16 x, uint16 y);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__)) max(uint16 x, uint16 y){ return (uint16)(__spirv_ocl_u_max(x, y)); }
#endif
uint16 __attribute__((__overloadable__)) __spirv_ocl_u_max( uint16 _x, uint _y);
inline uint16 __attribute__((__overloadable__)) max(uint16 x, uint y);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__)) max(uint16 x, uint y){ return (uint16)(__spirv_ocl_u_max(x, y)); }
#endif
long2 __attribute__((__overloadable__)) __spirv_ocl_s_min( long2 _x, long2 _y);
inline long2 __attribute__((__overloadable__)) min(long2 x, long2 y);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__)) min(long2 x, long2 y){ return (long2)(__spirv_ocl_s_min(x, y)); }
#endif
long2 __attribute__((__overloadable__)) __spirv_ocl_s_min( long2 _x, long _y);
inline long2 __attribute__((__overloadable__)) min(long2 x, long y);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__)) min(long2 x, long y){ return (long2)(__spirv_ocl_s_min(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
long3 __attribute__((__overloadable__)) __spirv_ocl_s_min( long3 _x, long3 _y);
inline long3 __attribute__((__overloadable__)) min(long3 x, long3 y);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__)) min(long3 x, long3 y){ return (long3)(__spirv_ocl_s_min(x, y)); }
#endif
long3 __attribute__((__overloadable__)) __spirv_ocl_s_min( long3 _x, long _y);
inline long3 __attribute__((__overloadable__)) min(long3 x, long y);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__)) min(long3 x, long y){ return (long3)(__spirv_ocl_s_min(x, y)); }
#endif
#endif
long4 __attribute__((__overloadable__)) __spirv_ocl_s_min( long4 _x, long4 _y);
inline long4 __attribute__((__overloadable__)) min(long4 x, long4 y);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__)) min(long4 x, long4 y){ return (long4)(__spirv_ocl_s_min(x, y)); }
#endif
long4 __attribute__((__overloadable__)) __spirv_ocl_s_min( long4 _x, long _y);
inline long4 __attribute__((__overloadable__)) min(long4 x, long y);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__)) min(long4 x, long y){ return (long4)(__spirv_ocl_s_min(x, y)); }
#endif
long8 __attribute__((__overloadable__)) __spirv_ocl_s_min( long8 _x, long8 _y);
inline long8 __attribute__((__overloadable__)) min(long8 x, long8 y);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__)) min(long8 x, long8 y){ return (long8)(__spirv_ocl_s_min(x, y)); }
#endif
long8 __attribute__((__overloadable__)) __spirv_ocl_s_min( long8 _x, long _y);
inline long8 __attribute__((__overloadable__)) min(long8 x, long y);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__)) min(long8 x, long y){ return (long8)(__spirv_ocl_s_min(x, y)); }
#endif
long16 __attribute__((__overloadable__)) __spirv_ocl_s_min( long16 _x, long16 _y);
inline long16 __attribute__((__overloadable__)) min(long16 x, long16 y);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__)) min(long16 x, long16 y){ return (long16)(__spirv_ocl_s_min(x, y)); }
#endif
long16 __attribute__((__overloadable__)) __spirv_ocl_s_min( long16 _x, long _y);
inline long16 __attribute__((__overloadable__)) min(long16 x, long y);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__)) min(long16 x, long y){ return (long16)(__spirv_ocl_s_min(x, y)); }
#endif
long2 __attribute__((__overloadable__)) __spirv_ocl_s_max( long2 _x, long2 _y);
inline long2 __attribute__((__overloadable__)) max(long2 x, long2 y);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__)) max(long2 x, long2 y){ return (long2)(__spirv_ocl_s_max(x, y)); }
#endif
long2 __attribute__((__overloadable__)) __spirv_ocl_s_max( long2 _x, long _y);
inline long2 __attribute__((__overloadable__)) max(long2 x, long y);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__)) max(long2 x, long y){ return (long2)(__spirv_ocl_s_max(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
long3 __attribute__((__overloadable__)) __spirv_ocl_s_max( long3 _x, long3 _y);
inline long3 __attribute__((__overloadable__)) max(long3 x, long3 y);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__)) max(long3 x, long3 y){ return (long3)(__spirv_ocl_s_max(x, y)); }
#endif
long3 __attribute__((__overloadable__)) __spirv_ocl_s_max( long3 _x, long _y);
inline long3 __attribute__((__overloadable__)) max(long3 x, long y);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__)) max(long3 x, long y){ return (long3)(__spirv_ocl_s_max(x, y)); }
#endif
#endif
long4 __attribute__((__overloadable__)) __spirv_ocl_s_max( long4 _x, long4 _y);
inline long4 __attribute__((__overloadable__)) max(long4 x, long4 y);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__)) max(long4 x, long4 y){ return (long4)(__spirv_ocl_s_max(x, y)); }
#endif
long4 __attribute__((__overloadable__)) __spirv_ocl_s_max( long4 _x, long _y);
inline long4 __attribute__((__overloadable__)) max(long4 x, long y);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__)) max(long4 x, long y){ return (long4)(__spirv_ocl_s_max(x, y)); }
#endif
long8 __attribute__((__overloadable__)) __spirv_ocl_s_max( long8 _x, long8 _y);
inline long8 __attribute__((__overloadable__)) max(long8 x, long8 y);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__)) max(long8 x, long8 y){ return (long8)(__spirv_ocl_s_max(x, y)); }
#endif
long8 __attribute__((__overloadable__)) __spirv_ocl_s_max( long8 _x, long _y);
inline long8 __attribute__((__overloadable__)) max(long8 x, long y);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__)) max(long8 x, long y){ return (long8)(__spirv_ocl_s_max(x, y)); }
#endif
long16 __attribute__((__overloadable__)) __spirv_ocl_s_max( long16 _x, long16 _y);
inline long16 __attribute__((__overloadable__)) max(long16 x, long16 y);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__)) max(long16 x, long16 y){ return (long16)(__spirv_ocl_s_max(x, y)); }
#endif
long16 __attribute__((__overloadable__)) __spirv_ocl_s_max( long16 _x, long _y);
inline long16 __attribute__((__overloadable__)) max(long16 x, long y);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__)) max(long16 x, long y){ return (long16)(__spirv_ocl_s_max(x, y)); }
#endif
ulong2 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong2 _x, ulong2 _y);
inline ulong2 __attribute__((__overloadable__)) min(ulong2 x, ulong2 y);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__)) min(ulong2 x, ulong2 y){ return (ulong2)(__spirv_ocl_u_min(x, y)); }
#endif
ulong2 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong2 _x, ulong _y);
inline ulong2 __attribute__((__overloadable__)) min(ulong2 x, ulong y);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__)) min(ulong2 x, ulong y){ return (ulong2)(__spirv_ocl_u_min(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ulong3 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong3 _x, ulong3 _y);
inline ulong3 __attribute__((__overloadable__)) min(ulong3 x, ulong3 y);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__)) min(ulong3 x, ulong3 y){ return (ulong3)(__spirv_ocl_u_min(x, y)); }
#endif
ulong3 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong3 _x, ulong _y);
inline ulong3 __attribute__((__overloadable__)) min(ulong3 x, ulong y);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__)) min(ulong3 x, ulong y){ return (ulong3)(__spirv_ocl_u_min(x, y)); }
#endif
#endif
ulong4 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong4 _x, ulong4 _y);
inline ulong4 __attribute__((__overloadable__)) min(ulong4 x, ulong4 y);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__)) min(ulong4 x, ulong4 y){ return (ulong4)(__spirv_ocl_u_min(x, y)); }
#endif
ulong4 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong4 _x, ulong _y);
inline ulong4 __attribute__((__overloadable__)) min(ulong4 x, ulong y);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__)) min(ulong4 x, ulong y){ return (ulong4)(__spirv_ocl_u_min(x, y)); }
#endif
ulong8 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong8 _x, ulong8 _y);
inline ulong8 __attribute__((__overloadable__)) min(ulong8 x, ulong8 y);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__)) min(ulong8 x, ulong8 y){ return (ulong8)(__spirv_ocl_u_min(x, y)); }
#endif
ulong8 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong8 _x, ulong _y);
inline ulong8 __attribute__((__overloadable__)) min(ulong8 x, ulong y);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__)) min(ulong8 x, ulong y){ return (ulong8)(__spirv_ocl_u_min(x, y)); }
#endif
ulong16 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong16 _x, ulong16 _y);
inline ulong16 __attribute__((__overloadable__)) min(ulong16 x, ulong16 y);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__)) min(ulong16 x, ulong16 y){ return (ulong16)(__spirv_ocl_u_min(x, y)); }
#endif
ulong16 __attribute__((__overloadable__)) __spirv_ocl_u_min( ulong16 _x, ulong _y);
inline ulong16 __attribute__((__overloadable__)) min(ulong16 x, ulong y);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__)) min(ulong16 x, ulong y){ return (ulong16)(__spirv_ocl_u_min(x, y)); }
#endif
ulong2 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong2 _x, ulong2 _y);
inline ulong2 __attribute__((__overloadable__)) max(ulong2 x, ulong2 y);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__)) max(ulong2 x, ulong2 y){ return (ulong2)(__spirv_ocl_u_max(x, y)); }
#endif
ulong2 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong2 _x, ulong _y);
inline ulong2 __attribute__((__overloadable__)) max(ulong2 x, ulong y);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__)) max(ulong2 x, ulong y){ return (ulong2)(__spirv_ocl_u_max(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ulong3 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong3 _x, ulong3 _y);
inline ulong3 __attribute__((__overloadable__)) max(ulong3 x, ulong3 y);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__)) max(ulong3 x, ulong3 y){ return (ulong3)(__spirv_ocl_u_max(x, y)); }
#endif
ulong3 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong3 _x, ulong _y);
inline ulong3 __attribute__((__overloadable__)) max(ulong3 x, ulong y);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__)) max(ulong3 x, ulong y){ return (ulong3)(__spirv_ocl_u_max(x, y)); }
#endif
#endif
ulong4 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong4 _x, ulong4 _y);
inline ulong4 __attribute__((__overloadable__)) max(ulong4 x, ulong4 y);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__)) max(ulong4 x, ulong4 y){ return (ulong4)(__spirv_ocl_u_max(x, y)); }
#endif
ulong4 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong4 _x, ulong _y);
inline ulong4 __attribute__((__overloadable__)) max(ulong4 x, ulong y);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__)) max(ulong4 x, ulong y){ return (ulong4)(__spirv_ocl_u_max(x, y)); }
#endif
ulong8 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong8 _x, ulong8 _y);
inline ulong8 __attribute__((__overloadable__)) max(ulong8 x, ulong8 y);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__)) max(ulong8 x, ulong8 y){ return (ulong8)(__spirv_ocl_u_max(x, y)); }
#endif
ulong8 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong8 _x, ulong _y);
inline ulong8 __attribute__((__overloadable__)) max(ulong8 x, ulong y);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__)) max(ulong8 x, ulong y){ return (ulong8)(__spirv_ocl_u_max(x, y)); }
#endif
ulong16 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong16 _x, ulong16 _y);
inline ulong16 __attribute__((__overloadable__)) max(ulong16 x, ulong16 y);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__)) max(ulong16 x, ulong16 y){ return (ulong16)(__spirv_ocl_u_max(x, y)); }
#endif
ulong16 __attribute__((__overloadable__)) __spirv_ocl_u_max( ulong16 _x, ulong _y);
inline ulong16 __attribute__((__overloadable__)) max(ulong16 x, ulong y);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__)) max(ulong16 x, ulong y){ return (ulong16)(__spirv_ocl_u_max(x, y)); }
#endif
#endif
float2 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float2 _x, float2 _y);
inline float2 __attribute__((__overloadable__)) min(float2 x, float2 y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__)) min(float2 x, float2 y){ return (float2)(__spirv_ocl_fmin_common(x, y)); }
#endif
float2 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float2 _x, float _y);
inline float2 __attribute__((__overloadable__)) min(float2 x, float y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__)) min(float2 x, float y){ return (float2)(__spirv_ocl_fmin_common(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float3 _x, float3 _y);
inline float3 __attribute__((__overloadable__)) min(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__)) min(float3 x, float3 y){ return (float3)(__spirv_ocl_fmin_common(x, y)); }
#endif
float3 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float3 _x, float _y);
inline float3 __attribute__((__overloadable__)) min(float3 x, float y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__)) min(float3 x, float y){ return (float3)(__spirv_ocl_fmin_common(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float4 _x, float4 _y);
inline float4 __attribute__((__overloadable__)) min(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__)) min(float4 x, float4 y){ return (float4)(__spirv_ocl_fmin_common(x, y)); }
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float4 _x, float _y);
inline float4 __attribute__((__overloadable__)) min(float4 x, float y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__)) min(float4 x, float y){ return (float4)(__spirv_ocl_fmin_common(x, y)); }
#endif
float8 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float8 _x, float8 _y);
inline float8 __attribute__((__overloadable__)) min(float8 x, float8 y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__)) min(float8 x, float8 y){ return (float8)(__spirv_ocl_fmin_common(x, y)); }
#endif
float8 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float8 _x, float _y);
inline float8 __attribute__((__overloadable__)) min(float8 x, float y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__)) min(float8 x, float y){ return (float8)(__spirv_ocl_fmin_common(x, y)); }
#endif
float16 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float16 _x, float16 _y);
inline float16 __attribute__((__overloadable__)) min(float16 x, float16 y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__)) min(float16 x, float16 y){ return (float16)(__spirv_ocl_fmin_common(x, y)); }
#endif
float16 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( float16 _x, float _y);
inline float16 __attribute__((__overloadable__)) min(float16 x, float y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__)) min(float16 x, float y){ return (float16)(__spirv_ocl_fmin_common(x, y)); }
#endif
float2 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float2 _x, float2 _y);
inline float2 __attribute__((__overloadable__)) max(float2 x, float2 y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__)) max(float2 x, float2 y){ return (float2)(__spirv_ocl_fmax_common(x, y)); }
#endif
float2 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float2 _x, float _y);
inline float2 __attribute__((__overloadable__)) max(float2 x, float y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__)) max(float2 x, float y){ return (float2)(__spirv_ocl_fmax_common(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float3 _x, float3 _y);
inline float3 __attribute__((__overloadable__)) max(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__)) max(float3 x, float3 y){ return (float3)(__spirv_ocl_fmax_common(x, y)); }
#endif
float3 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float3 _x, float _y);
inline float3 __attribute__((__overloadable__)) max(float3 x, float y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__)) max(float3 x, float y){ return (float3)(__spirv_ocl_fmax_common(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float4 _x, float4 _y);
inline float4 __attribute__((__overloadable__)) max(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__)) max(float4 x, float4 y){ return (float4)(__spirv_ocl_fmax_common(x, y)); }
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float4 _x, float _y);
inline float4 __attribute__((__overloadable__)) max(float4 x, float y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__)) max(float4 x, float y){ return (float4)(__spirv_ocl_fmax_common(x, y)); }
#endif
float8 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float8 _x, float8 _y);
inline float8 __attribute__((__overloadable__)) max(float8 x, float8 y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__)) max(float8 x, float8 y){ return (float8)(__spirv_ocl_fmax_common(x, y)); }
#endif
float8 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float8 _x, float _y);
inline float8 __attribute__((__overloadable__)) max(float8 x, float y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__)) max(float8 x, float y){ return (float8)(__spirv_ocl_fmax_common(x, y)); }
#endif
float16 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float16 _x, float16 _y);
inline float16 __attribute__((__overloadable__)) max(float16 x, float16 y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__)) max(float16 x, float16 y){ return (float16)(__spirv_ocl_fmax_common(x, y)); }
#endif
float16 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( float16 _x, float _y);
inline float16 __attribute__((__overloadable__)) max(float16 x, float y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__)) max(float16 x, float y){ return (float16)(__spirv_ocl_fmax_common(x, y)); }
#endif
double2 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double2 _x, double2 _y);
inline double2 __attribute__((__overloadable__)) min(double2 x, double2 y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__)) min(double2 x, double2 y){ return (double2)(__spirv_ocl_fmin_common(x, y)); }
#endif
double2 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double2 _x, double _y);
inline double2 __attribute__((__overloadable__)) min(double2 x, double y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__)) min(double2 x, double y){ return (double2)(__spirv_ocl_fmin_common(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double3 _x, double3 _y);
inline double3 __attribute__((__overloadable__)) min(double3 x, double3 y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__)) min(double3 x, double3 y){ return (double3)(__spirv_ocl_fmin_common(x, y)); }
#endif
double3 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double3 _x, double _y);
inline double3 __attribute__((__overloadable__)) min(double3 x, double y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__)) min(double3 x, double y){ return (double3)(__spirv_ocl_fmin_common(x, y)); }
#endif
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double4 _x, double4 _y);
inline double4 __attribute__((__overloadable__)) min(double4 x, double4 y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__)) min(double4 x, double4 y){ return (double4)(__spirv_ocl_fmin_common(x, y)); }
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double4 _x, double _y);
inline double4 __attribute__((__overloadable__)) min(double4 x, double y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__)) min(double4 x, double y){ return (double4)(__spirv_ocl_fmin_common(x, y)); }
#endif
double8 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double8 _x, double8 _y);
inline double8 __attribute__((__overloadable__)) min(double8 x, double8 y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__)) min(double8 x, double8 y){ return (double8)(__spirv_ocl_fmin_common(x, y)); }
#endif
double8 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double8 _x, double _y);
inline double8 __attribute__((__overloadable__)) min(double8 x, double y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__)) min(double8 x, double y){ return (double8)(__spirv_ocl_fmin_common(x, y)); }
#endif
double16 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double16 _x, double16 _y);
inline double16 __attribute__((__overloadable__)) min(double16 x, double16 y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__)) min(double16 x, double16 y){ return (double16)(__spirv_ocl_fmin_common(x, y)); }
#endif
double16 __attribute__((__overloadable__)) __spirv_ocl_fmin_common( double16 _x, double _y);
inline double16 __attribute__((__overloadable__)) min(double16 x, double y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__)) min(double16 x, double y){ return (double16)(__spirv_ocl_fmin_common(x, y)); }
#endif
double2 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double2 _x, double2 _y);
inline double2 __attribute__((__overloadable__)) max(double2 x, double2 y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__)) max(double2 x, double2 y){ return (double2)(__spirv_ocl_fmax_common(x, y)); }
#endif
double2 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double2 _x, double _y);
inline double2 __attribute__((__overloadable__)) max(double2 x, double y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__)) max(double2 x, double y){ return (double2)(__spirv_ocl_fmax_common(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double3 _x, double3 _y);
inline double3 __attribute__((__overloadable__)) max(double3 x, double3 y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__)) max(double3 x, double3 y){ return (double3)(__spirv_ocl_fmax_common(x, y)); }
#endif
double3 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double3 _x, double _y);
inline double3 __attribute__((__overloadable__)) max(double3 x, double y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__)) max(double3 x, double y){ return (double3)(__spirv_ocl_fmax_common(x, y)); }
#endif
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double4 _x, double4 _y);
inline double4 __attribute__((__overloadable__)) max(double4 x, double4 y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__)) max(double4 x, double4 y){ return (double4)(__spirv_ocl_fmax_common(x, y)); }
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double4 _x, double _y);
inline double4 __attribute__((__overloadable__)) max(double4 x, double y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__)) max(double4 x, double y){ return (double4)(__spirv_ocl_fmax_common(x, y)); }
#endif
double8 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double8 _x, double8 _y);
inline double8 __attribute__((__overloadable__)) max(double8 x, double8 y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__)) max(double8 x, double8 y){ return (double8)(__spirv_ocl_fmax_common(x, y)); }
#endif
double8 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double8 _x, double _y);
inline double8 __attribute__((__overloadable__)) max(double8 x, double y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__)) max(double8 x, double y){ return (double8)(__spirv_ocl_fmax_common(x, y)); }
#endif
double16 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double16 _x, double16 _y);
inline double16 __attribute__((__overloadable__)) max(double16 x, double16 y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__)) max(double16 x, double16 y){ return (double16)(__spirv_ocl_fmax_common(x, y)); }
#endif
double16 __attribute__((__overloadable__)) __spirv_ocl_fmax_common( double16 _x, double _y);
inline double16 __attribute__((__overloadable__)) max(double16 x, double y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__)) max(double16 x, double y){ return (double16)(__spirv_ocl_fmax_common(x, y)); }
#endif
#define __CVAttrs __attribute__((__overloadable__,__always_inline__,const))
char __CVAttrs convert_char(char);
char __CVAttrs convert_char(uchar);
char __CVAttrs convert_char(short);
char __CVAttrs convert_char(ushort);
char __CVAttrs convert_char(int);
char __CVAttrs convert_char(uint);
char __CVAttrs convert_char(long);
char __CVAttrs convert_char(ulong);
char __CVAttrs convert_char(float);
char __CVAttrs convert_char(double);
char __CVAttrs convert_char_rte(char);
char __CVAttrs convert_char_rte(uchar);
char __CVAttrs convert_char_rte(short);
char __CVAttrs convert_char_rte(ushort);
char __CVAttrs convert_char_rte(int);
char __CVAttrs convert_char_rte(uint);
char __CVAttrs convert_char_rte(long);
char __CVAttrs convert_char_rte(ulong);
char __CVAttrs convert_char_rte(float);
char __CVAttrs convert_char_rte(double);
char __CVAttrs convert_char_rtz(char);
char __CVAttrs convert_char_rtz(uchar);
char __CVAttrs convert_char_rtz(short);
char __CVAttrs convert_char_rtz(ushort);
char __CVAttrs convert_char_rtz(int);
char __CVAttrs convert_char_rtz(uint);
char __CVAttrs convert_char_rtz(long);
char __CVAttrs convert_char_rtz(ulong);
char __CVAttrs convert_char_rtz(float);
char __CVAttrs convert_char_rtz(double);
char __CVAttrs convert_char_rtp(char);
char __CVAttrs convert_char_rtp(uchar);
char __CVAttrs convert_char_rtp(short);
char __CVAttrs convert_char_rtp(ushort);
char __CVAttrs convert_char_rtp(int);
char __CVAttrs convert_char_rtp(uint);
char __CVAttrs convert_char_rtp(long);
char __CVAttrs convert_char_rtp(ulong);
char __CVAttrs convert_char_rtp(float);
char __CVAttrs convert_char_rtp(double);
char __CVAttrs convert_char_rtn(char);
char __CVAttrs convert_char_rtn(uchar);
char __CVAttrs convert_char_rtn(short);
char __CVAttrs convert_char_rtn(ushort);
char __CVAttrs convert_char_rtn(int);
char __CVAttrs convert_char_rtn(uint);
char __CVAttrs convert_char_rtn(long);
char __CVAttrs convert_char_rtn(ulong);
char __CVAttrs convert_char_rtn(float);
char __CVAttrs convert_char_rtn(double);
char __CVAttrs convert_char_sat(char);
char __CVAttrs convert_char_sat(uchar);
char __CVAttrs convert_char_sat(short);
char __CVAttrs convert_char_sat(ushort);
char __CVAttrs convert_char_sat(int);
char __CVAttrs convert_char_sat(uint);
char __CVAttrs convert_char_sat(long);
char __CVAttrs convert_char_sat(ulong);
char __CVAttrs convert_char_sat(float);
char __CVAttrs convert_char_sat(double);
char __CVAttrs convert_char_sat_rte(char);
char __CVAttrs convert_char_sat_rte(uchar);
char __CVAttrs convert_char_sat_rte(short);
char __CVAttrs convert_char_sat_rte(ushort);
char __CVAttrs convert_char_sat_rte(int);
char __CVAttrs convert_char_sat_rte(uint);
char __CVAttrs convert_char_sat_rte(long);
char __CVAttrs convert_char_sat_rte(ulong);
char __CVAttrs convert_char_sat_rte(float);
char __CVAttrs convert_char_sat_rte(double);
char __CVAttrs convert_char_sat_rtz(char);
char __CVAttrs convert_char_sat_rtz(uchar);
char __CVAttrs convert_char_sat_rtz(short);
char __CVAttrs convert_char_sat_rtz(ushort);
char __CVAttrs convert_char_sat_rtz(int);
char __CVAttrs convert_char_sat_rtz(uint);
char __CVAttrs convert_char_sat_rtz(long);
char __CVAttrs convert_char_sat_rtz(ulong);
char __CVAttrs convert_char_sat_rtz(float);
char __CVAttrs convert_char_sat_rtz(double);
char __CVAttrs convert_char_sat_rtp(char);
char __CVAttrs convert_char_sat_rtp(uchar);
char __CVAttrs convert_char_sat_rtp(short);
char __CVAttrs convert_char_sat_rtp(ushort);
char __CVAttrs convert_char_sat_rtp(int);
char __CVAttrs convert_char_sat_rtp(uint);
char __CVAttrs convert_char_sat_rtp(long);
char __CVAttrs convert_char_sat_rtp(ulong);
char __CVAttrs convert_char_sat_rtp(float);
char __CVAttrs convert_char_sat_rtp(double);
char __CVAttrs convert_char_sat_rtn(char);
char __CVAttrs convert_char_sat_rtn(uchar);
char __CVAttrs convert_char_sat_rtn(short);
char __CVAttrs convert_char_sat_rtn(ushort);
char __CVAttrs convert_char_sat_rtn(int);
char __CVAttrs convert_char_sat_rtn(uint);
char __CVAttrs convert_char_sat_rtn(long);
char __CVAttrs convert_char_sat_rtn(ulong);
char __CVAttrs convert_char_sat_rtn(float);
char __CVAttrs convert_char_sat_rtn(double);
char2 __CVAttrs convert_char2(char2);
char2 __CVAttrs convert_char2(uchar2);
char2 __CVAttrs convert_char2(short2);
char2 __CVAttrs convert_char2(ushort2);
char2 __CVAttrs convert_char2(int2);
char2 __CVAttrs convert_char2(uint2);
char2 __CVAttrs convert_char2(long2);
char2 __CVAttrs convert_char2(ulong2);
char2 __CVAttrs convert_char2(float2);
char2 __CVAttrs convert_char2(double2);
char2 __CVAttrs convert_char2_rte(char2);
char2 __CVAttrs convert_char2_rte(uchar2);
char2 __CVAttrs convert_char2_rte(short2);
char2 __CVAttrs convert_char2_rte(ushort2);
char2 __CVAttrs convert_char2_rte(int2);
char2 __CVAttrs convert_char2_rte(uint2);
char2 __CVAttrs convert_char2_rte(long2);
char2 __CVAttrs convert_char2_rte(ulong2);
char2 __CVAttrs convert_char2_rte(float2);
char2 __CVAttrs convert_char2_rte(double2);
char2 __CVAttrs convert_char2_rtz(char2);
char2 __CVAttrs convert_char2_rtz(uchar2);
char2 __CVAttrs convert_char2_rtz(short2);
char2 __CVAttrs convert_char2_rtz(ushort2);
char2 __CVAttrs convert_char2_rtz(int2);
char2 __CVAttrs convert_char2_rtz(uint2);
char2 __CVAttrs convert_char2_rtz(long2);
char2 __CVAttrs convert_char2_rtz(ulong2);
char2 __CVAttrs convert_char2_rtz(float2);
char2 __CVAttrs convert_char2_rtz(double2);
char2 __CVAttrs convert_char2_rtp(char2);
char2 __CVAttrs convert_char2_rtp(uchar2);
char2 __CVAttrs convert_char2_rtp(short2);
char2 __CVAttrs convert_char2_rtp(ushort2);
char2 __CVAttrs convert_char2_rtp(int2);
char2 __CVAttrs convert_char2_rtp(uint2);
char2 __CVAttrs convert_char2_rtp(long2);
char2 __CVAttrs convert_char2_rtp(ulong2);
char2 __CVAttrs convert_char2_rtp(float2);
char2 __CVAttrs convert_char2_rtp(double2);
char2 __CVAttrs convert_char2_rtn(char2);
char2 __CVAttrs convert_char2_rtn(uchar2);
char2 __CVAttrs convert_char2_rtn(short2);
char2 __CVAttrs convert_char2_rtn(ushort2);
char2 __CVAttrs convert_char2_rtn(int2);
char2 __CVAttrs convert_char2_rtn(uint2);
char2 __CVAttrs convert_char2_rtn(long2);
char2 __CVAttrs convert_char2_rtn(ulong2);
char2 __CVAttrs convert_char2_rtn(float2);
char2 __CVAttrs convert_char2_rtn(double2);
char2 __CVAttrs convert_char2_sat(char2);
char2 __CVAttrs convert_char2_sat(uchar2);
char2 __CVAttrs convert_char2_sat(short2);
char2 __CVAttrs convert_char2_sat(ushort2);
char2 __CVAttrs convert_char2_sat(int2);
char2 __CVAttrs convert_char2_sat(uint2);
char2 __CVAttrs convert_char2_sat(long2);
char2 __CVAttrs convert_char2_sat(ulong2);
char2 __CVAttrs convert_char2_sat(float2);
char2 __CVAttrs convert_char2_sat(double2);
char2 __CVAttrs convert_char2_sat_rte(char2);
char2 __CVAttrs convert_char2_sat_rte(uchar2);
char2 __CVAttrs convert_char2_sat_rte(short2);
char2 __CVAttrs convert_char2_sat_rte(ushort2);
char2 __CVAttrs convert_char2_sat_rte(int2);
char2 __CVAttrs convert_char2_sat_rte(uint2);
char2 __CVAttrs convert_char2_sat_rte(long2);
char2 __CVAttrs convert_char2_sat_rte(ulong2);
char2 __CVAttrs convert_char2_sat_rte(float2);
char2 __CVAttrs convert_char2_sat_rte(double2);
char2 __CVAttrs convert_char2_sat_rtz(char2);
char2 __CVAttrs convert_char2_sat_rtz(uchar2);
char2 __CVAttrs convert_char2_sat_rtz(short2);
char2 __CVAttrs convert_char2_sat_rtz(ushort2);
char2 __CVAttrs convert_char2_sat_rtz(int2);
char2 __CVAttrs convert_char2_sat_rtz(uint2);
char2 __CVAttrs convert_char2_sat_rtz(long2);
char2 __CVAttrs convert_char2_sat_rtz(ulong2);
char2 __CVAttrs convert_char2_sat_rtz(float2);
char2 __CVAttrs convert_char2_sat_rtz(double2);
char2 __CVAttrs convert_char2_sat_rtp(char2);
char2 __CVAttrs convert_char2_sat_rtp(uchar2);
char2 __CVAttrs convert_char2_sat_rtp(short2);
char2 __CVAttrs convert_char2_sat_rtp(ushort2);
char2 __CVAttrs convert_char2_sat_rtp(int2);
char2 __CVAttrs convert_char2_sat_rtp(uint2);
char2 __CVAttrs convert_char2_sat_rtp(long2);
char2 __CVAttrs convert_char2_sat_rtp(ulong2);
char2 __CVAttrs convert_char2_sat_rtp(float2);
char2 __CVAttrs convert_char2_sat_rtp(double2);
char2 __CVAttrs convert_char2_sat_rtn(char2);
char2 __CVAttrs convert_char2_sat_rtn(uchar2);
char2 __CVAttrs convert_char2_sat_rtn(short2);
char2 __CVAttrs convert_char2_sat_rtn(ushort2);
char2 __CVAttrs convert_char2_sat_rtn(int2);
char2 __CVAttrs convert_char2_sat_rtn(uint2);
char2 __CVAttrs convert_char2_sat_rtn(long2);
char2 __CVAttrs convert_char2_sat_rtn(ulong2);
char2 __CVAttrs convert_char2_sat_rtn(float2);
char2 __CVAttrs convert_char2_sat_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
char3 __CVAttrs convert_char3(char3);
char3 __CVAttrs convert_char3(uchar3);
char3 __CVAttrs convert_char3(short3);
char3 __CVAttrs convert_char3(ushort3);
char3 __CVAttrs convert_char3(int3);
char3 __CVAttrs convert_char3(uint3);
char3 __CVAttrs convert_char3(long3);
char3 __CVAttrs convert_char3(ulong3);
char3 __CVAttrs convert_char3(float3);
char3 __CVAttrs convert_char3(double3);
char3 __CVAttrs convert_char3_rte(char3);
char3 __CVAttrs convert_char3_rte(uchar3);
char3 __CVAttrs convert_char3_rte(short3);
char3 __CVAttrs convert_char3_rte(ushort3);
char3 __CVAttrs convert_char3_rte(int3);
char3 __CVAttrs convert_char3_rte(uint3);
char3 __CVAttrs convert_char3_rte(long3);
char3 __CVAttrs convert_char3_rte(ulong3);
char3 __CVAttrs convert_char3_rte(float3);
char3 __CVAttrs convert_char3_rte(double3);
char3 __CVAttrs convert_char3_rtz(char3);
char3 __CVAttrs convert_char3_rtz(uchar3);
char3 __CVAttrs convert_char3_rtz(short3);
char3 __CVAttrs convert_char3_rtz(ushort3);
char3 __CVAttrs convert_char3_rtz(int3);
char3 __CVAttrs convert_char3_rtz(uint3);
char3 __CVAttrs convert_char3_rtz(long3);
char3 __CVAttrs convert_char3_rtz(ulong3);
char3 __CVAttrs convert_char3_rtz(float3);
char3 __CVAttrs convert_char3_rtz(double3);
char3 __CVAttrs convert_char3_rtp(char3);
char3 __CVAttrs convert_char3_rtp(uchar3);
char3 __CVAttrs convert_char3_rtp(short3);
char3 __CVAttrs convert_char3_rtp(ushort3);
char3 __CVAttrs convert_char3_rtp(int3);
char3 __CVAttrs convert_char3_rtp(uint3);
char3 __CVAttrs convert_char3_rtp(long3);
char3 __CVAttrs convert_char3_rtp(ulong3);
char3 __CVAttrs convert_char3_rtp(float3);
char3 __CVAttrs convert_char3_rtp(double3);
char3 __CVAttrs convert_char3_rtn(char3);
char3 __CVAttrs convert_char3_rtn(uchar3);
char3 __CVAttrs convert_char3_rtn(short3);
char3 __CVAttrs convert_char3_rtn(ushort3);
char3 __CVAttrs convert_char3_rtn(int3);
char3 __CVAttrs convert_char3_rtn(uint3);
char3 __CVAttrs convert_char3_rtn(long3);
char3 __CVAttrs convert_char3_rtn(ulong3);
char3 __CVAttrs convert_char3_rtn(float3);
char3 __CVAttrs convert_char3_rtn(double3);
char3 __CVAttrs convert_char3_sat(char3);
char3 __CVAttrs convert_char3_sat(uchar3);
char3 __CVAttrs convert_char3_sat(short3);
char3 __CVAttrs convert_char3_sat(ushort3);
char3 __CVAttrs convert_char3_sat(int3);
char3 __CVAttrs convert_char3_sat(uint3);
char3 __CVAttrs convert_char3_sat(long3);
char3 __CVAttrs convert_char3_sat(ulong3);
char3 __CVAttrs convert_char3_sat(float3);
char3 __CVAttrs convert_char3_sat(double3);
char3 __CVAttrs convert_char3_sat_rte(char3);
char3 __CVAttrs convert_char3_sat_rte(uchar3);
char3 __CVAttrs convert_char3_sat_rte(short3);
char3 __CVAttrs convert_char3_sat_rte(ushort3);
char3 __CVAttrs convert_char3_sat_rte(int3);
char3 __CVAttrs convert_char3_sat_rte(uint3);
char3 __CVAttrs convert_char3_sat_rte(long3);
char3 __CVAttrs convert_char3_sat_rte(ulong3);
char3 __CVAttrs convert_char3_sat_rte(float3);
char3 __CVAttrs convert_char3_sat_rte(double3);
char3 __CVAttrs convert_char3_sat_rtz(char3);
char3 __CVAttrs convert_char3_sat_rtz(uchar3);
char3 __CVAttrs convert_char3_sat_rtz(short3);
char3 __CVAttrs convert_char3_sat_rtz(ushort3);
char3 __CVAttrs convert_char3_sat_rtz(int3);
char3 __CVAttrs convert_char3_sat_rtz(uint3);
char3 __CVAttrs convert_char3_sat_rtz(long3);
char3 __CVAttrs convert_char3_sat_rtz(ulong3);
char3 __CVAttrs convert_char3_sat_rtz(float3);
char3 __CVAttrs convert_char3_sat_rtz(double3);
char3 __CVAttrs convert_char3_sat_rtp(char3);
char3 __CVAttrs convert_char3_sat_rtp(uchar3);
char3 __CVAttrs convert_char3_sat_rtp(short3);
char3 __CVAttrs convert_char3_sat_rtp(ushort3);
char3 __CVAttrs convert_char3_sat_rtp(int3);
char3 __CVAttrs convert_char3_sat_rtp(uint3);
char3 __CVAttrs convert_char3_sat_rtp(long3);
char3 __CVAttrs convert_char3_sat_rtp(ulong3);
char3 __CVAttrs convert_char3_sat_rtp(float3);
char3 __CVAttrs convert_char3_sat_rtp(double3);
char3 __CVAttrs convert_char3_sat_rtn(char3);
char3 __CVAttrs convert_char3_sat_rtn(uchar3);
char3 __CVAttrs convert_char3_sat_rtn(short3);
char3 __CVAttrs convert_char3_sat_rtn(ushort3);
char3 __CVAttrs convert_char3_sat_rtn(int3);
char3 __CVAttrs convert_char3_sat_rtn(uint3);
char3 __CVAttrs convert_char3_sat_rtn(long3);
char3 __CVAttrs convert_char3_sat_rtn(ulong3);
char3 __CVAttrs convert_char3_sat_rtn(float3);
char3 __CVAttrs convert_char3_sat_rtn(double3);
#endif
char4 __CVAttrs convert_char4(char4);
char4 __CVAttrs convert_char4(uchar4);
char4 __CVAttrs convert_char4(short4);
char4 __CVAttrs convert_char4(ushort4);
char4 __CVAttrs convert_char4(int4);
char4 __CVAttrs convert_char4(uint4);
char4 __CVAttrs convert_char4(long4);
char4 __CVAttrs convert_char4(ulong4);
char4 __CVAttrs convert_char4(float4);
char4 __CVAttrs convert_char4(double4);
char4 __CVAttrs convert_char4_rte(char4);
char4 __CVAttrs convert_char4_rte(uchar4);
char4 __CVAttrs convert_char4_rte(short4);
char4 __CVAttrs convert_char4_rte(ushort4);
char4 __CVAttrs convert_char4_rte(int4);
char4 __CVAttrs convert_char4_rte(uint4);
char4 __CVAttrs convert_char4_rte(long4);
char4 __CVAttrs convert_char4_rte(ulong4);
char4 __CVAttrs convert_char4_rte(float4);
char4 __CVAttrs convert_char4_rte(double4);
char4 __CVAttrs convert_char4_rtz(char4);
char4 __CVAttrs convert_char4_rtz(uchar4);
char4 __CVAttrs convert_char4_rtz(short4);
char4 __CVAttrs convert_char4_rtz(ushort4);
char4 __CVAttrs convert_char4_rtz(int4);
char4 __CVAttrs convert_char4_rtz(uint4);
char4 __CVAttrs convert_char4_rtz(long4);
char4 __CVAttrs convert_char4_rtz(ulong4);
char4 __CVAttrs convert_char4_rtz(float4);
char4 __CVAttrs convert_char4_rtz(double4);
char4 __CVAttrs convert_char4_rtp(char4);
char4 __CVAttrs convert_char4_rtp(uchar4);
char4 __CVAttrs convert_char4_rtp(short4);
char4 __CVAttrs convert_char4_rtp(ushort4);
char4 __CVAttrs convert_char4_rtp(int4);
char4 __CVAttrs convert_char4_rtp(uint4);
char4 __CVAttrs convert_char4_rtp(long4);
char4 __CVAttrs convert_char4_rtp(ulong4);
char4 __CVAttrs convert_char4_rtp(float4);
char4 __CVAttrs convert_char4_rtp(double4);
char4 __CVAttrs convert_char4_rtn(char4);
char4 __CVAttrs convert_char4_rtn(uchar4);
char4 __CVAttrs convert_char4_rtn(short4);
char4 __CVAttrs convert_char4_rtn(ushort4);
char4 __CVAttrs convert_char4_rtn(int4);
char4 __CVAttrs convert_char4_rtn(uint4);
char4 __CVAttrs convert_char4_rtn(long4);
char4 __CVAttrs convert_char4_rtn(ulong4);
char4 __CVAttrs convert_char4_rtn(float4);
char4 __CVAttrs convert_char4_rtn(double4);
char4 __CVAttrs convert_char4_sat(char4);
char4 __CVAttrs convert_char4_sat(uchar4);
char4 __CVAttrs convert_char4_sat(short4);
char4 __CVAttrs convert_char4_sat(ushort4);
char4 __CVAttrs convert_char4_sat(int4);
char4 __CVAttrs convert_char4_sat(uint4);
char4 __CVAttrs convert_char4_sat(long4);
char4 __CVAttrs convert_char4_sat(ulong4);
char4 __CVAttrs convert_char4_sat(float4);
char4 __CVAttrs convert_char4_sat(double4);
char4 __CVAttrs convert_char4_sat_rte(char4);
char4 __CVAttrs convert_char4_sat_rte(uchar4);
char4 __CVAttrs convert_char4_sat_rte(short4);
char4 __CVAttrs convert_char4_sat_rte(ushort4);
char4 __CVAttrs convert_char4_sat_rte(int4);
char4 __CVAttrs convert_char4_sat_rte(uint4);
char4 __CVAttrs convert_char4_sat_rte(long4);
char4 __CVAttrs convert_char4_sat_rte(ulong4);
char4 __CVAttrs convert_char4_sat_rte(float4);
char4 __CVAttrs convert_char4_sat_rte(double4);
char4 __CVAttrs convert_char4_sat_rtz(char4);
char4 __CVAttrs convert_char4_sat_rtz(uchar4);
char4 __CVAttrs convert_char4_sat_rtz(short4);
char4 __CVAttrs convert_char4_sat_rtz(ushort4);
char4 __CVAttrs convert_char4_sat_rtz(int4);
char4 __CVAttrs convert_char4_sat_rtz(uint4);
char4 __CVAttrs convert_char4_sat_rtz(long4);
char4 __CVAttrs convert_char4_sat_rtz(ulong4);
char4 __CVAttrs convert_char4_sat_rtz(float4);
char4 __CVAttrs convert_char4_sat_rtz(double4);
char4 __CVAttrs convert_char4_sat_rtp(char4);
char4 __CVAttrs convert_char4_sat_rtp(uchar4);
char4 __CVAttrs convert_char4_sat_rtp(short4);
char4 __CVAttrs convert_char4_sat_rtp(ushort4);
char4 __CVAttrs convert_char4_sat_rtp(int4);
char4 __CVAttrs convert_char4_sat_rtp(uint4);
char4 __CVAttrs convert_char4_sat_rtp(long4);
char4 __CVAttrs convert_char4_sat_rtp(ulong4);
char4 __CVAttrs convert_char4_sat_rtp(float4);
char4 __CVAttrs convert_char4_sat_rtp(double4);
char4 __CVAttrs convert_char4_sat_rtn(char4);
char4 __CVAttrs convert_char4_sat_rtn(uchar4);
char4 __CVAttrs convert_char4_sat_rtn(short4);
char4 __CVAttrs convert_char4_sat_rtn(ushort4);
char4 __CVAttrs convert_char4_sat_rtn(int4);
char4 __CVAttrs convert_char4_sat_rtn(uint4);
char4 __CVAttrs convert_char4_sat_rtn(long4);
char4 __CVAttrs convert_char4_sat_rtn(ulong4);
char4 __CVAttrs convert_char4_sat_rtn(float4);
char4 __CVAttrs convert_char4_sat_rtn(double4);
char8 __CVAttrs convert_char8(char8);
char8 __CVAttrs convert_char8(uchar8);
char8 __CVAttrs convert_char8(short8);
char8 __CVAttrs convert_char8(ushort8);
char8 __CVAttrs convert_char8(int8);
char8 __CVAttrs convert_char8(uint8);
char8 __CVAttrs convert_char8(long8);
char8 __CVAttrs convert_char8(ulong8);
char8 __CVAttrs convert_char8(float8);
char8 __CVAttrs convert_char8(double8);
char8 __CVAttrs convert_char8_rte(char8);
char8 __CVAttrs convert_char8_rte(uchar8);
char8 __CVAttrs convert_char8_rte(short8);
char8 __CVAttrs convert_char8_rte(ushort8);
char8 __CVAttrs convert_char8_rte(int8);
char8 __CVAttrs convert_char8_rte(uint8);
char8 __CVAttrs convert_char8_rte(long8);
char8 __CVAttrs convert_char8_rte(ulong8);
char8 __CVAttrs convert_char8_rte(float8);
char8 __CVAttrs convert_char8_rte(double8);
char8 __CVAttrs convert_char8_rtz(char8);
char8 __CVAttrs convert_char8_rtz(uchar8);
char8 __CVAttrs convert_char8_rtz(short8);
char8 __CVAttrs convert_char8_rtz(ushort8);
char8 __CVAttrs convert_char8_rtz(int8);
char8 __CVAttrs convert_char8_rtz(uint8);
char8 __CVAttrs convert_char8_rtz(long8);
char8 __CVAttrs convert_char8_rtz(ulong8);
char8 __CVAttrs convert_char8_rtz(float8);
char8 __CVAttrs convert_char8_rtz(double8);
char8 __CVAttrs convert_char8_rtp(char8);
char8 __CVAttrs convert_char8_rtp(uchar8);
char8 __CVAttrs convert_char8_rtp(short8);
char8 __CVAttrs convert_char8_rtp(ushort8);
char8 __CVAttrs convert_char8_rtp(int8);
char8 __CVAttrs convert_char8_rtp(uint8);
char8 __CVAttrs convert_char8_rtp(long8);
char8 __CVAttrs convert_char8_rtp(ulong8);
char8 __CVAttrs convert_char8_rtp(float8);
char8 __CVAttrs convert_char8_rtp(double8);
char8 __CVAttrs convert_char8_rtn(char8);
char8 __CVAttrs convert_char8_rtn(uchar8);
char8 __CVAttrs convert_char8_rtn(short8);
char8 __CVAttrs convert_char8_rtn(ushort8);
char8 __CVAttrs convert_char8_rtn(int8);
char8 __CVAttrs convert_char8_rtn(uint8);
char8 __CVAttrs convert_char8_rtn(long8);
char8 __CVAttrs convert_char8_rtn(ulong8);
char8 __CVAttrs convert_char8_rtn(float8);
char8 __CVAttrs convert_char8_rtn(double8);
char8 __CVAttrs convert_char8_sat(char8);
char8 __CVAttrs convert_char8_sat(uchar8);
char8 __CVAttrs convert_char8_sat(short8);
char8 __CVAttrs convert_char8_sat(ushort8);
char8 __CVAttrs convert_char8_sat(int8);
char8 __CVAttrs convert_char8_sat(uint8);
char8 __CVAttrs convert_char8_sat(long8);
char8 __CVAttrs convert_char8_sat(ulong8);
char8 __CVAttrs convert_char8_sat(float8);
char8 __CVAttrs convert_char8_sat(double8);
char8 __CVAttrs convert_char8_sat_rte(char8);
char8 __CVAttrs convert_char8_sat_rte(uchar8);
char8 __CVAttrs convert_char8_sat_rte(short8);
char8 __CVAttrs convert_char8_sat_rte(ushort8);
char8 __CVAttrs convert_char8_sat_rte(int8);
char8 __CVAttrs convert_char8_sat_rte(uint8);
char8 __CVAttrs convert_char8_sat_rte(long8);
char8 __CVAttrs convert_char8_sat_rte(ulong8);
char8 __CVAttrs convert_char8_sat_rte(float8);
char8 __CVAttrs convert_char8_sat_rte(double8);
char8 __CVAttrs convert_char8_sat_rtz(char8);
char8 __CVAttrs convert_char8_sat_rtz(uchar8);
char8 __CVAttrs convert_char8_sat_rtz(short8);
char8 __CVAttrs convert_char8_sat_rtz(ushort8);
char8 __CVAttrs convert_char8_sat_rtz(int8);
char8 __CVAttrs convert_char8_sat_rtz(uint8);
char8 __CVAttrs convert_char8_sat_rtz(long8);
char8 __CVAttrs convert_char8_sat_rtz(ulong8);
char8 __CVAttrs convert_char8_sat_rtz(float8);
char8 __CVAttrs convert_char8_sat_rtz(double8);
char8 __CVAttrs convert_char8_sat_rtp(char8);
char8 __CVAttrs convert_char8_sat_rtp(uchar8);
char8 __CVAttrs convert_char8_sat_rtp(short8);
char8 __CVAttrs convert_char8_sat_rtp(ushort8);
char8 __CVAttrs convert_char8_sat_rtp(int8);
char8 __CVAttrs convert_char8_sat_rtp(uint8);
char8 __CVAttrs convert_char8_sat_rtp(long8);
char8 __CVAttrs convert_char8_sat_rtp(ulong8);
char8 __CVAttrs convert_char8_sat_rtp(float8);
char8 __CVAttrs convert_char8_sat_rtp(double8);
char8 __CVAttrs convert_char8_sat_rtn(char8);
char8 __CVAttrs convert_char8_sat_rtn(uchar8);
char8 __CVAttrs convert_char8_sat_rtn(short8);
char8 __CVAttrs convert_char8_sat_rtn(ushort8);
char8 __CVAttrs convert_char8_sat_rtn(int8);
char8 __CVAttrs convert_char8_sat_rtn(uint8);
char8 __CVAttrs convert_char8_sat_rtn(long8);
char8 __CVAttrs convert_char8_sat_rtn(ulong8);
char8 __CVAttrs convert_char8_sat_rtn(float8);
char8 __CVAttrs convert_char8_sat_rtn(double8);
char16 __CVAttrs convert_char16(char16);
char16 __CVAttrs convert_char16(uchar16);
char16 __CVAttrs convert_char16(short16);
char16 __CVAttrs convert_char16(ushort16);
char16 __CVAttrs convert_char16(int16);
char16 __CVAttrs convert_char16(uint16);
char16 __CVAttrs convert_char16(long16);
char16 __CVAttrs convert_char16(ulong16);
char16 __CVAttrs convert_char16(float16);
char16 __CVAttrs convert_char16(double16);
char16 __CVAttrs convert_char16_rte(char16);
char16 __CVAttrs convert_char16_rte(uchar16);
char16 __CVAttrs convert_char16_rte(short16);
char16 __CVAttrs convert_char16_rte(ushort16);
char16 __CVAttrs convert_char16_rte(int16);
char16 __CVAttrs convert_char16_rte(uint16);
char16 __CVAttrs convert_char16_rte(long16);
char16 __CVAttrs convert_char16_rte(ulong16);
char16 __CVAttrs convert_char16_rte(float16);
char16 __CVAttrs convert_char16_rte(double16);
char16 __CVAttrs convert_char16_rtz(char16);
char16 __CVAttrs convert_char16_rtz(uchar16);
char16 __CVAttrs convert_char16_rtz(short16);
char16 __CVAttrs convert_char16_rtz(ushort16);
char16 __CVAttrs convert_char16_rtz(int16);
char16 __CVAttrs convert_char16_rtz(uint16);
char16 __CVAttrs convert_char16_rtz(long16);
char16 __CVAttrs convert_char16_rtz(ulong16);
char16 __CVAttrs convert_char16_rtz(float16);
char16 __CVAttrs convert_char16_rtz(double16);
char16 __CVAttrs convert_char16_rtp(char16);
char16 __CVAttrs convert_char16_rtp(uchar16);
char16 __CVAttrs convert_char16_rtp(short16);
char16 __CVAttrs convert_char16_rtp(ushort16);
char16 __CVAttrs convert_char16_rtp(int16);
char16 __CVAttrs convert_char16_rtp(uint16);
char16 __CVAttrs convert_char16_rtp(long16);
char16 __CVAttrs convert_char16_rtp(ulong16);
char16 __CVAttrs convert_char16_rtp(float16);
char16 __CVAttrs convert_char16_rtp(double16);
char16 __CVAttrs convert_char16_rtn(char16);
char16 __CVAttrs convert_char16_rtn(uchar16);
char16 __CVAttrs convert_char16_rtn(short16);
char16 __CVAttrs convert_char16_rtn(ushort16);
char16 __CVAttrs convert_char16_rtn(int16);
char16 __CVAttrs convert_char16_rtn(uint16);
char16 __CVAttrs convert_char16_rtn(long16);
char16 __CVAttrs convert_char16_rtn(ulong16);
char16 __CVAttrs convert_char16_rtn(float16);
char16 __CVAttrs convert_char16_rtn(double16);
char16 __CVAttrs convert_char16_sat(char16);
char16 __CVAttrs convert_char16_sat(uchar16);
char16 __CVAttrs convert_char16_sat(short16);
char16 __CVAttrs convert_char16_sat(ushort16);
char16 __CVAttrs convert_char16_sat(int16);
char16 __CVAttrs convert_char16_sat(uint16);
char16 __CVAttrs convert_char16_sat(long16);
char16 __CVAttrs convert_char16_sat(ulong16);
char16 __CVAttrs convert_char16_sat(float16);
char16 __CVAttrs convert_char16_sat(double16);
char16 __CVAttrs convert_char16_sat_rte(char16);
char16 __CVAttrs convert_char16_sat_rte(uchar16);
char16 __CVAttrs convert_char16_sat_rte(short16);
char16 __CVAttrs convert_char16_sat_rte(ushort16);
char16 __CVAttrs convert_char16_sat_rte(int16);
char16 __CVAttrs convert_char16_sat_rte(uint16);
char16 __CVAttrs convert_char16_sat_rte(long16);
char16 __CVAttrs convert_char16_sat_rte(ulong16);
char16 __CVAttrs convert_char16_sat_rte(float16);
char16 __CVAttrs convert_char16_sat_rte(double16);
char16 __CVAttrs convert_char16_sat_rtz(char16);
char16 __CVAttrs convert_char16_sat_rtz(uchar16);
char16 __CVAttrs convert_char16_sat_rtz(short16);
char16 __CVAttrs convert_char16_sat_rtz(ushort16);
char16 __CVAttrs convert_char16_sat_rtz(int16);
char16 __CVAttrs convert_char16_sat_rtz(uint16);
char16 __CVAttrs convert_char16_sat_rtz(long16);
char16 __CVAttrs convert_char16_sat_rtz(ulong16);
char16 __CVAttrs convert_char16_sat_rtz(float16);
char16 __CVAttrs convert_char16_sat_rtz(double16);
char16 __CVAttrs convert_char16_sat_rtp(char16);
char16 __CVAttrs convert_char16_sat_rtp(uchar16);
char16 __CVAttrs convert_char16_sat_rtp(short16);
char16 __CVAttrs convert_char16_sat_rtp(ushort16);
char16 __CVAttrs convert_char16_sat_rtp(int16);
char16 __CVAttrs convert_char16_sat_rtp(uint16);
char16 __CVAttrs convert_char16_sat_rtp(long16);
char16 __CVAttrs convert_char16_sat_rtp(ulong16);
char16 __CVAttrs convert_char16_sat_rtp(float16);
char16 __CVAttrs convert_char16_sat_rtp(double16);
char16 __CVAttrs convert_char16_sat_rtn(char16);
char16 __CVAttrs convert_char16_sat_rtn(uchar16);
char16 __CVAttrs convert_char16_sat_rtn(short16);
char16 __CVAttrs convert_char16_sat_rtn(ushort16);
char16 __CVAttrs convert_char16_sat_rtn(int16);
char16 __CVAttrs convert_char16_sat_rtn(uint16);
char16 __CVAttrs convert_char16_sat_rtn(long16);
char16 __CVAttrs convert_char16_sat_rtn(ulong16);
char16 __CVAttrs convert_char16_sat_rtn(float16);
char16 __CVAttrs convert_char16_sat_rtn(double16);
uchar __CVAttrs convert_uchar(char);
uchar __CVAttrs convert_uchar(uchar);
uchar __CVAttrs convert_uchar(short);
uchar __CVAttrs convert_uchar(ushort);
uchar __CVAttrs convert_uchar(int);
uchar __CVAttrs convert_uchar(uint);
uchar __CVAttrs convert_uchar(long);
uchar __CVAttrs convert_uchar(ulong);
uchar __CVAttrs convert_uchar(float);
uchar __CVAttrs convert_uchar(double);
uchar __CVAttrs convert_uchar_rte(char);
uchar __CVAttrs convert_uchar_rte(uchar);
uchar __CVAttrs convert_uchar_rte(short);
uchar __CVAttrs convert_uchar_rte(ushort);
uchar __CVAttrs convert_uchar_rte(int);
uchar __CVAttrs convert_uchar_rte(uint);
uchar __CVAttrs convert_uchar_rte(long);
uchar __CVAttrs convert_uchar_rte(ulong);
uchar __CVAttrs convert_uchar_rte(float);
uchar __CVAttrs convert_uchar_rte(double);
uchar __CVAttrs convert_uchar_rtz(char);
uchar __CVAttrs convert_uchar_rtz(uchar);
uchar __CVAttrs convert_uchar_rtz(short);
uchar __CVAttrs convert_uchar_rtz(ushort);
uchar __CVAttrs convert_uchar_rtz(int);
uchar __CVAttrs convert_uchar_rtz(uint);
uchar __CVAttrs convert_uchar_rtz(long);
uchar __CVAttrs convert_uchar_rtz(ulong);
uchar __CVAttrs convert_uchar_rtz(float);
uchar __CVAttrs convert_uchar_rtz(double);
uchar __CVAttrs convert_uchar_rtp(char);
uchar __CVAttrs convert_uchar_rtp(uchar);
uchar __CVAttrs convert_uchar_rtp(short);
uchar __CVAttrs convert_uchar_rtp(ushort);
uchar __CVAttrs convert_uchar_rtp(int);
uchar __CVAttrs convert_uchar_rtp(uint);
uchar __CVAttrs convert_uchar_rtp(long);
uchar __CVAttrs convert_uchar_rtp(ulong);
uchar __CVAttrs convert_uchar_rtp(float);
uchar __CVAttrs convert_uchar_rtp(double);
uchar __CVAttrs convert_uchar_rtn(char);
uchar __CVAttrs convert_uchar_rtn(uchar);
uchar __CVAttrs convert_uchar_rtn(short);
uchar __CVAttrs convert_uchar_rtn(ushort);
uchar __CVAttrs convert_uchar_rtn(int);
uchar __CVAttrs convert_uchar_rtn(uint);
uchar __CVAttrs convert_uchar_rtn(long);
uchar __CVAttrs convert_uchar_rtn(ulong);
uchar __CVAttrs convert_uchar_rtn(float);
uchar __CVAttrs convert_uchar_rtn(double);
uchar __CVAttrs convert_uchar_sat(char);
uchar __CVAttrs convert_uchar_sat(uchar);
uchar __CVAttrs convert_uchar_sat(short);
uchar __CVAttrs convert_uchar_sat(ushort);
uchar __CVAttrs convert_uchar_sat(int);
uchar __CVAttrs convert_uchar_sat(uint);
uchar __CVAttrs convert_uchar_sat(long);
uchar __CVAttrs convert_uchar_sat(ulong);
uchar __CVAttrs convert_uchar_sat(float);
uchar __CVAttrs convert_uchar_sat(double);
uchar __CVAttrs convert_uchar_sat_rte(char);
uchar __CVAttrs convert_uchar_sat_rte(uchar);
uchar __CVAttrs convert_uchar_sat_rte(short);
uchar __CVAttrs convert_uchar_sat_rte(ushort);
uchar __CVAttrs convert_uchar_sat_rte(int);
uchar __CVAttrs convert_uchar_sat_rte(uint);
uchar __CVAttrs convert_uchar_sat_rte(long);
uchar __CVAttrs convert_uchar_sat_rte(ulong);
uchar __CVAttrs convert_uchar_sat_rte(float);
uchar __CVAttrs convert_uchar_sat_rte(double);
uchar __CVAttrs convert_uchar_sat_rtz(char);
uchar __CVAttrs convert_uchar_sat_rtz(uchar);
uchar __CVAttrs convert_uchar_sat_rtz(short);
uchar __CVAttrs convert_uchar_sat_rtz(ushort);
uchar __CVAttrs convert_uchar_sat_rtz(int);
uchar __CVAttrs convert_uchar_sat_rtz(uint);
uchar __CVAttrs convert_uchar_sat_rtz(long);
uchar __CVAttrs convert_uchar_sat_rtz(ulong);
uchar __CVAttrs convert_uchar_sat_rtz(float);
uchar __CVAttrs convert_uchar_sat_rtz(double);
uchar __CVAttrs convert_uchar_sat_rtp(char);
uchar __CVAttrs convert_uchar_sat_rtp(uchar);
uchar __CVAttrs convert_uchar_sat_rtp(short);
uchar __CVAttrs convert_uchar_sat_rtp(ushort);
uchar __CVAttrs convert_uchar_sat_rtp(int);
uchar __CVAttrs convert_uchar_sat_rtp(uint);
uchar __CVAttrs convert_uchar_sat_rtp(long);
uchar __CVAttrs convert_uchar_sat_rtp(ulong);
uchar __CVAttrs convert_uchar_sat_rtp(float);
uchar __CVAttrs convert_uchar_sat_rtp(double);
uchar __CVAttrs convert_uchar_sat_rtn(char);
uchar __CVAttrs convert_uchar_sat_rtn(uchar);
uchar __CVAttrs convert_uchar_sat_rtn(short);
uchar __CVAttrs convert_uchar_sat_rtn(ushort);
uchar __CVAttrs convert_uchar_sat_rtn(int);
uchar __CVAttrs convert_uchar_sat_rtn(uint);
uchar __CVAttrs convert_uchar_sat_rtn(long);
uchar __CVAttrs convert_uchar_sat_rtn(ulong);
uchar __CVAttrs convert_uchar_sat_rtn(float);
uchar __CVAttrs convert_uchar_sat_rtn(double);
uchar2 __CVAttrs convert_uchar2(char2);
uchar2 __CVAttrs convert_uchar2(uchar2);
uchar2 __CVAttrs convert_uchar2(short2);
uchar2 __CVAttrs convert_uchar2(ushort2);
uchar2 __CVAttrs convert_uchar2(int2);
uchar2 __CVAttrs convert_uchar2(uint2);
uchar2 __CVAttrs convert_uchar2(long2);
uchar2 __CVAttrs convert_uchar2(ulong2);
uchar2 __CVAttrs convert_uchar2(float2);
uchar2 __CVAttrs convert_uchar2(double2);
uchar2 __CVAttrs convert_uchar2_rte(char2);
uchar2 __CVAttrs convert_uchar2_rte(uchar2);
uchar2 __CVAttrs convert_uchar2_rte(short2);
uchar2 __CVAttrs convert_uchar2_rte(ushort2);
uchar2 __CVAttrs convert_uchar2_rte(int2);
uchar2 __CVAttrs convert_uchar2_rte(uint2);
uchar2 __CVAttrs convert_uchar2_rte(long2);
uchar2 __CVAttrs convert_uchar2_rte(ulong2);
uchar2 __CVAttrs convert_uchar2_rte(float2);
uchar2 __CVAttrs convert_uchar2_rte(double2);
uchar2 __CVAttrs convert_uchar2_rtz(char2);
uchar2 __CVAttrs convert_uchar2_rtz(uchar2);
uchar2 __CVAttrs convert_uchar2_rtz(short2);
uchar2 __CVAttrs convert_uchar2_rtz(ushort2);
uchar2 __CVAttrs convert_uchar2_rtz(int2);
uchar2 __CVAttrs convert_uchar2_rtz(uint2);
uchar2 __CVAttrs convert_uchar2_rtz(long2);
uchar2 __CVAttrs convert_uchar2_rtz(ulong2);
uchar2 __CVAttrs convert_uchar2_rtz(float2);
uchar2 __CVAttrs convert_uchar2_rtz(double2);
uchar2 __CVAttrs convert_uchar2_rtp(char2);
uchar2 __CVAttrs convert_uchar2_rtp(uchar2);
uchar2 __CVAttrs convert_uchar2_rtp(short2);
uchar2 __CVAttrs convert_uchar2_rtp(ushort2);
uchar2 __CVAttrs convert_uchar2_rtp(int2);
uchar2 __CVAttrs convert_uchar2_rtp(uint2);
uchar2 __CVAttrs convert_uchar2_rtp(long2);
uchar2 __CVAttrs convert_uchar2_rtp(ulong2);
uchar2 __CVAttrs convert_uchar2_rtp(float2);
uchar2 __CVAttrs convert_uchar2_rtp(double2);
uchar2 __CVAttrs convert_uchar2_rtn(char2);
uchar2 __CVAttrs convert_uchar2_rtn(uchar2);
uchar2 __CVAttrs convert_uchar2_rtn(short2);
uchar2 __CVAttrs convert_uchar2_rtn(ushort2);
uchar2 __CVAttrs convert_uchar2_rtn(int2);
uchar2 __CVAttrs convert_uchar2_rtn(uint2);
uchar2 __CVAttrs convert_uchar2_rtn(long2);
uchar2 __CVAttrs convert_uchar2_rtn(ulong2);
uchar2 __CVAttrs convert_uchar2_rtn(float2);
uchar2 __CVAttrs convert_uchar2_rtn(double2);
uchar2 __CVAttrs convert_uchar2_sat(char2);
uchar2 __CVAttrs convert_uchar2_sat(uchar2);
uchar2 __CVAttrs convert_uchar2_sat(short2);
uchar2 __CVAttrs convert_uchar2_sat(ushort2);
uchar2 __CVAttrs convert_uchar2_sat(int2);
uchar2 __CVAttrs convert_uchar2_sat(uint2);
uchar2 __CVAttrs convert_uchar2_sat(long2);
uchar2 __CVAttrs convert_uchar2_sat(ulong2);
uchar2 __CVAttrs convert_uchar2_sat(float2);
uchar2 __CVAttrs convert_uchar2_sat(double2);
uchar2 __CVAttrs convert_uchar2_sat_rte(char2);
uchar2 __CVAttrs convert_uchar2_sat_rte(uchar2);
uchar2 __CVAttrs convert_uchar2_sat_rte(short2);
uchar2 __CVAttrs convert_uchar2_sat_rte(ushort2);
uchar2 __CVAttrs convert_uchar2_sat_rte(int2);
uchar2 __CVAttrs convert_uchar2_sat_rte(uint2);
uchar2 __CVAttrs convert_uchar2_sat_rte(long2);
uchar2 __CVAttrs convert_uchar2_sat_rte(ulong2);
uchar2 __CVAttrs convert_uchar2_sat_rte(float2);
uchar2 __CVAttrs convert_uchar2_sat_rte(double2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(char2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(uchar2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(short2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(ushort2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(int2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(uint2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(long2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(ulong2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(float2);
uchar2 __CVAttrs convert_uchar2_sat_rtz(double2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(char2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(uchar2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(short2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(ushort2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(int2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(uint2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(long2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(ulong2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(float2);
uchar2 __CVAttrs convert_uchar2_sat_rtp(double2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(char2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(uchar2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(short2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(ushort2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(int2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(uint2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(long2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(ulong2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(float2);
uchar2 __CVAttrs convert_uchar2_sat_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
uchar3 __CVAttrs convert_uchar3(char3);
uchar3 __CVAttrs convert_uchar3(uchar3);
uchar3 __CVAttrs convert_uchar3(short3);
uchar3 __CVAttrs convert_uchar3(ushort3);
uchar3 __CVAttrs convert_uchar3(int3);
uchar3 __CVAttrs convert_uchar3(uint3);
uchar3 __CVAttrs convert_uchar3(long3);
uchar3 __CVAttrs convert_uchar3(ulong3);
uchar3 __CVAttrs convert_uchar3(float3);
uchar3 __CVAttrs convert_uchar3(double3);
uchar3 __CVAttrs convert_uchar3_rte(char3);
uchar3 __CVAttrs convert_uchar3_rte(uchar3);
uchar3 __CVAttrs convert_uchar3_rte(short3);
uchar3 __CVAttrs convert_uchar3_rte(ushort3);
uchar3 __CVAttrs convert_uchar3_rte(int3);
uchar3 __CVAttrs convert_uchar3_rte(uint3);
uchar3 __CVAttrs convert_uchar3_rte(long3);
uchar3 __CVAttrs convert_uchar3_rte(ulong3);
uchar3 __CVAttrs convert_uchar3_rte(float3);
uchar3 __CVAttrs convert_uchar3_rte(double3);
uchar3 __CVAttrs convert_uchar3_rtz(char3);
uchar3 __CVAttrs convert_uchar3_rtz(uchar3);
uchar3 __CVAttrs convert_uchar3_rtz(short3);
uchar3 __CVAttrs convert_uchar3_rtz(ushort3);
uchar3 __CVAttrs convert_uchar3_rtz(int3);
uchar3 __CVAttrs convert_uchar3_rtz(uint3);
uchar3 __CVAttrs convert_uchar3_rtz(long3);
uchar3 __CVAttrs convert_uchar3_rtz(ulong3);
uchar3 __CVAttrs convert_uchar3_rtz(float3);
uchar3 __CVAttrs convert_uchar3_rtz(double3);
uchar3 __CVAttrs convert_uchar3_rtp(char3);
uchar3 __CVAttrs convert_uchar3_rtp(uchar3);
uchar3 __CVAttrs convert_uchar3_rtp(short3);
uchar3 __CVAttrs convert_uchar3_rtp(ushort3);
uchar3 __CVAttrs convert_uchar3_rtp(int3);
uchar3 __CVAttrs convert_uchar3_rtp(uint3);
uchar3 __CVAttrs convert_uchar3_rtp(long3);
uchar3 __CVAttrs convert_uchar3_rtp(ulong3);
uchar3 __CVAttrs convert_uchar3_rtp(float3);
uchar3 __CVAttrs convert_uchar3_rtp(double3);
uchar3 __CVAttrs convert_uchar3_rtn(char3);
uchar3 __CVAttrs convert_uchar3_rtn(uchar3);
uchar3 __CVAttrs convert_uchar3_rtn(short3);
uchar3 __CVAttrs convert_uchar3_rtn(ushort3);
uchar3 __CVAttrs convert_uchar3_rtn(int3);
uchar3 __CVAttrs convert_uchar3_rtn(uint3);
uchar3 __CVAttrs convert_uchar3_rtn(long3);
uchar3 __CVAttrs convert_uchar3_rtn(ulong3);
uchar3 __CVAttrs convert_uchar3_rtn(float3);
uchar3 __CVAttrs convert_uchar3_rtn(double3);
uchar3 __CVAttrs convert_uchar3_sat(char3);
uchar3 __CVAttrs convert_uchar3_sat(uchar3);
uchar3 __CVAttrs convert_uchar3_sat(short3);
uchar3 __CVAttrs convert_uchar3_sat(ushort3);
uchar3 __CVAttrs convert_uchar3_sat(int3);
uchar3 __CVAttrs convert_uchar3_sat(uint3);
uchar3 __CVAttrs convert_uchar3_sat(long3);
uchar3 __CVAttrs convert_uchar3_sat(ulong3);
uchar3 __CVAttrs convert_uchar3_sat(float3);
uchar3 __CVAttrs convert_uchar3_sat(double3);
uchar3 __CVAttrs convert_uchar3_sat_rte(char3);
uchar3 __CVAttrs convert_uchar3_sat_rte(uchar3);
uchar3 __CVAttrs convert_uchar3_sat_rte(short3);
uchar3 __CVAttrs convert_uchar3_sat_rte(ushort3);
uchar3 __CVAttrs convert_uchar3_sat_rte(int3);
uchar3 __CVAttrs convert_uchar3_sat_rte(uint3);
uchar3 __CVAttrs convert_uchar3_sat_rte(long3);
uchar3 __CVAttrs convert_uchar3_sat_rte(ulong3);
uchar3 __CVAttrs convert_uchar3_sat_rte(float3);
uchar3 __CVAttrs convert_uchar3_sat_rte(double3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(char3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(uchar3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(short3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(ushort3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(int3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(uint3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(long3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(ulong3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(float3);
uchar3 __CVAttrs convert_uchar3_sat_rtz(double3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(char3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(uchar3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(short3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(ushort3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(int3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(uint3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(long3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(ulong3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(float3);
uchar3 __CVAttrs convert_uchar3_sat_rtp(double3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(char3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(uchar3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(short3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(ushort3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(int3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(uint3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(long3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(ulong3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(float3);
uchar3 __CVAttrs convert_uchar3_sat_rtn(double3);
#endif
uchar4 __CVAttrs convert_uchar4(char4);
uchar4 __CVAttrs convert_uchar4(uchar4);
uchar4 __CVAttrs convert_uchar4(short4);
uchar4 __CVAttrs convert_uchar4(ushort4);
uchar4 __CVAttrs convert_uchar4(int4);
uchar4 __CVAttrs convert_uchar4(uint4);
uchar4 __CVAttrs convert_uchar4(long4);
uchar4 __CVAttrs convert_uchar4(ulong4);
uchar4 __CVAttrs convert_uchar4(float4);
uchar4 __CVAttrs convert_uchar4(double4);
uchar4 __CVAttrs convert_uchar4_rte(char4);
uchar4 __CVAttrs convert_uchar4_rte(uchar4);
uchar4 __CVAttrs convert_uchar4_rte(short4);
uchar4 __CVAttrs convert_uchar4_rte(ushort4);
uchar4 __CVAttrs convert_uchar4_rte(int4);
uchar4 __CVAttrs convert_uchar4_rte(uint4);
uchar4 __CVAttrs convert_uchar4_rte(long4);
uchar4 __CVAttrs convert_uchar4_rte(ulong4);
uchar4 __CVAttrs convert_uchar4_rte(float4);
uchar4 __CVAttrs convert_uchar4_rte(double4);
uchar4 __CVAttrs convert_uchar4_rtz(char4);
uchar4 __CVAttrs convert_uchar4_rtz(uchar4);
uchar4 __CVAttrs convert_uchar4_rtz(short4);
uchar4 __CVAttrs convert_uchar4_rtz(ushort4);
uchar4 __CVAttrs convert_uchar4_rtz(int4);
uchar4 __CVAttrs convert_uchar4_rtz(uint4);
uchar4 __CVAttrs convert_uchar4_rtz(long4);
uchar4 __CVAttrs convert_uchar4_rtz(ulong4);
uchar4 __CVAttrs convert_uchar4_rtz(float4);
uchar4 __CVAttrs convert_uchar4_rtz(double4);
uchar4 __CVAttrs convert_uchar4_rtp(char4);
uchar4 __CVAttrs convert_uchar4_rtp(uchar4);
uchar4 __CVAttrs convert_uchar4_rtp(short4);
uchar4 __CVAttrs convert_uchar4_rtp(ushort4);
uchar4 __CVAttrs convert_uchar4_rtp(int4);
uchar4 __CVAttrs convert_uchar4_rtp(uint4);
uchar4 __CVAttrs convert_uchar4_rtp(long4);
uchar4 __CVAttrs convert_uchar4_rtp(ulong4);
uchar4 __CVAttrs convert_uchar4_rtp(float4);
uchar4 __CVAttrs convert_uchar4_rtp(double4);
uchar4 __CVAttrs convert_uchar4_rtn(char4);
uchar4 __CVAttrs convert_uchar4_rtn(uchar4);
uchar4 __CVAttrs convert_uchar4_rtn(short4);
uchar4 __CVAttrs convert_uchar4_rtn(ushort4);
uchar4 __CVAttrs convert_uchar4_rtn(int4);
uchar4 __CVAttrs convert_uchar4_rtn(uint4);
uchar4 __CVAttrs convert_uchar4_rtn(long4);
uchar4 __CVAttrs convert_uchar4_rtn(ulong4);
uchar4 __CVAttrs convert_uchar4_rtn(float4);
uchar4 __CVAttrs convert_uchar4_rtn(double4);
uchar4 __CVAttrs convert_uchar4_sat(char4);
uchar4 __CVAttrs convert_uchar4_sat(uchar4);
uchar4 __CVAttrs convert_uchar4_sat(short4);
uchar4 __CVAttrs convert_uchar4_sat(ushort4);
uchar4 __CVAttrs convert_uchar4_sat(int4);
uchar4 __CVAttrs convert_uchar4_sat(uint4);
uchar4 __CVAttrs convert_uchar4_sat(long4);
uchar4 __CVAttrs convert_uchar4_sat(ulong4);
uchar4 __CVAttrs convert_uchar4_sat(float4);
uchar4 __CVAttrs convert_uchar4_sat(double4);
uchar4 __CVAttrs convert_uchar4_sat_rte(char4);
uchar4 __CVAttrs convert_uchar4_sat_rte(uchar4);
uchar4 __CVAttrs convert_uchar4_sat_rte(short4);
uchar4 __CVAttrs convert_uchar4_sat_rte(ushort4);
uchar4 __CVAttrs convert_uchar4_sat_rte(int4);
uchar4 __CVAttrs convert_uchar4_sat_rte(uint4);
uchar4 __CVAttrs convert_uchar4_sat_rte(long4);
uchar4 __CVAttrs convert_uchar4_sat_rte(ulong4);
uchar4 __CVAttrs convert_uchar4_sat_rte(float4);
uchar4 __CVAttrs convert_uchar4_sat_rte(double4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(char4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(uchar4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(short4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(ushort4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(int4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(uint4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(long4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(ulong4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(float4);
uchar4 __CVAttrs convert_uchar4_sat_rtz(double4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(char4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(uchar4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(short4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(ushort4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(int4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(uint4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(long4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(ulong4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(float4);
uchar4 __CVAttrs convert_uchar4_sat_rtp(double4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(char4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(uchar4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(short4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(ushort4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(int4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(uint4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(long4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(ulong4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(float4);
uchar4 __CVAttrs convert_uchar4_sat_rtn(double4);
uchar8 __CVAttrs convert_uchar8(char8);
uchar8 __CVAttrs convert_uchar8(uchar8);
uchar8 __CVAttrs convert_uchar8(short8);
uchar8 __CVAttrs convert_uchar8(ushort8);
uchar8 __CVAttrs convert_uchar8(int8);
uchar8 __CVAttrs convert_uchar8(uint8);
uchar8 __CVAttrs convert_uchar8(long8);
uchar8 __CVAttrs convert_uchar8(ulong8);
uchar8 __CVAttrs convert_uchar8(float8);
uchar8 __CVAttrs convert_uchar8(double8);
uchar8 __CVAttrs convert_uchar8_rte(char8);
uchar8 __CVAttrs convert_uchar8_rte(uchar8);
uchar8 __CVAttrs convert_uchar8_rte(short8);
uchar8 __CVAttrs convert_uchar8_rte(ushort8);
uchar8 __CVAttrs convert_uchar8_rte(int8);
uchar8 __CVAttrs convert_uchar8_rte(uint8);
uchar8 __CVAttrs convert_uchar8_rte(long8);
uchar8 __CVAttrs convert_uchar8_rte(ulong8);
uchar8 __CVAttrs convert_uchar8_rte(float8);
uchar8 __CVAttrs convert_uchar8_rte(double8);
uchar8 __CVAttrs convert_uchar8_rtz(char8);
uchar8 __CVAttrs convert_uchar8_rtz(uchar8);
uchar8 __CVAttrs convert_uchar8_rtz(short8);
uchar8 __CVAttrs convert_uchar8_rtz(ushort8);
uchar8 __CVAttrs convert_uchar8_rtz(int8);
uchar8 __CVAttrs convert_uchar8_rtz(uint8);
uchar8 __CVAttrs convert_uchar8_rtz(long8);
uchar8 __CVAttrs convert_uchar8_rtz(ulong8);
uchar8 __CVAttrs convert_uchar8_rtz(float8);
uchar8 __CVAttrs convert_uchar8_rtz(double8);
uchar8 __CVAttrs convert_uchar8_rtp(char8);
uchar8 __CVAttrs convert_uchar8_rtp(uchar8);
uchar8 __CVAttrs convert_uchar8_rtp(short8);
uchar8 __CVAttrs convert_uchar8_rtp(ushort8);
uchar8 __CVAttrs convert_uchar8_rtp(int8);
uchar8 __CVAttrs convert_uchar8_rtp(uint8);
uchar8 __CVAttrs convert_uchar8_rtp(long8);
uchar8 __CVAttrs convert_uchar8_rtp(ulong8);
uchar8 __CVAttrs convert_uchar8_rtp(float8);
uchar8 __CVAttrs convert_uchar8_rtp(double8);
uchar8 __CVAttrs convert_uchar8_rtn(char8);
uchar8 __CVAttrs convert_uchar8_rtn(uchar8);
uchar8 __CVAttrs convert_uchar8_rtn(short8);
uchar8 __CVAttrs convert_uchar8_rtn(ushort8);
uchar8 __CVAttrs convert_uchar8_rtn(int8);
uchar8 __CVAttrs convert_uchar8_rtn(uint8);
uchar8 __CVAttrs convert_uchar8_rtn(long8);
uchar8 __CVAttrs convert_uchar8_rtn(ulong8);
uchar8 __CVAttrs convert_uchar8_rtn(float8);
uchar8 __CVAttrs convert_uchar8_rtn(double8);
uchar8 __CVAttrs convert_uchar8_sat(char8);
uchar8 __CVAttrs convert_uchar8_sat(uchar8);
uchar8 __CVAttrs convert_uchar8_sat(short8);
uchar8 __CVAttrs convert_uchar8_sat(ushort8);
uchar8 __CVAttrs convert_uchar8_sat(int8);
uchar8 __CVAttrs convert_uchar8_sat(uint8);
uchar8 __CVAttrs convert_uchar8_sat(long8);
uchar8 __CVAttrs convert_uchar8_sat(ulong8);
uchar8 __CVAttrs convert_uchar8_sat(float8);
uchar8 __CVAttrs convert_uchar8_sat(double8);
uchar8 __CVAttrs convert_uchar8_sat_rte(char8);
uchar8 __CVAttrs convert_uchar8_sat_rte(uchar8);
uchar8 __CVAttrs convert_uchar8_sat_rte(short8);
uchar8 __CVAttrs convert_uchar8_sat_rte(ushort8);
uchar8 __CVAttrs convert_uchar8_sat_rte(int8);
uchar8 __CVAttrs convert_uchar8_sat_rte(uint8);
uchar8 __CVAttrs convert_uchar8_sat_rte(long8);
uchar8 __CVAttrs convert_uchar8_sat_rte(ulong8);
uchar8 __CVAttrs convert_uchar8_sat_rte(float8);
uchar8 __CVAttrs convert_uchar8_sat_rte(double8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(char8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(uchar8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(short8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(ushort8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(int8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(uint8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(long8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(ulong8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(float8);
uchar8 __CVAttrs convert_uchar8_sat_rtz(double8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(char8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(uchar8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(short8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(ushort8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(int8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(uint8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(long8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(ulong8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(float8);
uchar8 __CVAttrs convert_uchar8_sat_rtp(double8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(char8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(uchar8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(short8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(ushort8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(int8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(uint8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(long8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(ulong8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(float8);
uchar8 __CVAttrs convert_uchar8_sat_rtn(double8);
uchar16 __CVAttrs convert_uchar16(char16);
uchar16 __CVAttrs convert_uchar16(uchar16);
uchar16 __CVAttrs convert_uchar16(short16);
uchar16 __CVAttrs convert_uchar16(ushort16);
uchar16 __CVAttrs convert_uchar16(int16);
uchar16 __CVAttrs convert_uchar16(uint16);
uchar16 __CVAttrs convert_uchar16(long16);
uchar16 __CVAttrs convert_uchar16(ulong16);
uchar16 __CVAttrs convert_uchar16(float16);
uchar16 __CVAttrs convert_uchar16(double16);
uchar16 __CVAttrs convert_uchar16_rte(char16);
uchar16 __CVAttrs convert_uchar16_rte(uchar16);
uchar16 __CVAttrs convert_uchar16_rte(short16);
uchar16 __CVAttrs convert_uchar16_rte(ushort16);
uchar16 __CVAttrs convert_uchar16_rte(int16);
uchar16 __CVAttrs convert_uchar16_rte(uint16);
uchar16 __CVAttrs convert_uchar16_rte(long16);
uchar16 __CVAttrs convert_uchar16_rte(ulong16);
uchar16 __CVAttrs convert_uchar16_rte(float16);
uchar16 __CVAttrs convert_uchar16_rte(double16);
uchar16 __CVAttrs convert_uchar16_rtz(char16);
uchar16 __CVAttrs convert_uchar16_rtz(uchar16);
uchar16 __CVAttrs convert_uchar16_rtz(short16);
uchar16 __CVAttrs convert_uchar16_rtz(ushort16);
uchar16 __CVAttrs convert_uchar16_rtz(int16);
uchar16 __CVAttrs convert_uchar16_rtz(uint16);
uchar16 __CVAttrs convert_uchar16_rtz(long16);
uchar16 __CVAttrs convert_uchar16_rtz(ulong16);
uchar16 __CVAttrs convert_uchar16_rtz(float16);
uchar16 __CVAttrs convert_uchar16_rtz(double16);
uchar16 __CVAttrs convert_uchar16_rtp(char16);
uchar16 __CVAttrs convert_uchar16_rtp(uchar16);
uchar16 __CVAttrs convert_uchar16_rtp(short16);
uchar16 __CVAttrs convert_uchar16_rtp(ushort16);
uchar16 __CVAttrs convert_uchar16_rtp(int16);
uchar16 __CVAttrs convert_uchar16_rtp(uint16);
uchar16 __CVAttrs convert_uchar16_rtp(long16);
uchar16 __CVAttrs convert_uchar16_rtp(ulong16);
uchar16 __CVAttrs convert_uchar16_rtp(float16);
uchar16 __CVAttrs convert_uchar16_rtp(double16);
uchar16 __CVAttrs convert_uchar16_rtn(char16);
uchar16 __CVAttrs convert_uchar16_rtn(uchar16);
uchar16 __CVAttrs convert_uchar16_rtn(short16);
uchar16 __CVAttrs convert_uchar16_rtn(ushort16);
uchar16 __CVAttrs convert_uchar16_rtn(int16);
uchar16 __CVAttrs convert_uchar16_rtn(uint16);
uchar16 __CVAttrs convert_uchar16_rtn(long16);
uchar16 __CVAttrs convert_uchar16_rtn(ulong16);
uchar16 __CVAttrs convert_uchar16_rtn(float16);
uchar16 __CVAttrs convert_uchar16_rtn(double16);
uchar16 __CVAttrs convert_uchar16_sat(char16);
uchar16 __CVAttrs convert_uchar16_sat(uchar16);
uchar16 __CVAttrs convert_uchar16_sat(short16);
uchar16 __CVAttrs convert_uchar16_sat(ushort16);
uchar16 __CVAttrs convert_uchar16_sat(int16);
uchar16 __CVAttrs convert_uchar16_sat(uint16);
uchar16 __CVAttrs convert_uchar16_sat(long16);
uchar16 __CVAttrs convert_uchar16_sat(ulong16);
uchar16 __CVAttrs convert_uchar16_sat(float16);
uchar16 __CVAttrs convert_uchar16_sat(double16);
uchar16 __CVAttrs convert_uchar16_sat_rte(char16);
uchar16 __CVAttrs convert_uchar16_sat_rte(uchar16);
uchar16 __CVAttrs convert_uchar16_sat_rte(short16);
uchar16 __CVAttrs convert_uchar16_sat_rte(ushort16);
uchar16 __CVAttrs convert_uchar16_sat_rte(int16);
uchar16 __CVAttrs convert_uchar16_sat_rte(uint16);
uchar16 __CVAttrs convert_uchar16_sat_rte(long16);
uchar16 __CVAttrs convert_uchar16_sat_rte(ulong16);
uchar16 __CVAttrs convert_uchar16_sat_rte(float16);
uchar16 __CVAttrs convert_uchar16_sat_rte(double16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(char16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(uchar16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(short16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(ushort16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(int16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(uint16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(long16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(ulong16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(float16);
uchar16 __CVAttrs convert_uchar16_sat_rtz(double16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(char16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(uchar16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(short16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(ushort16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(int16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(uint16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(long16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(ulong16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(float16);
uchar16 __CVAttrs convert_uchar16_sat_rtp(double16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(char16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(uchar16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(short16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(ushort16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(int16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(uint16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(long16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(ulong16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(float16);
uchar16 __CVAttrs convert_uchar16_sat_rtn(double16);
short __CVAttrs convert_short(char);
short __CVAttrs convert_short(uchar);
short __CVAttrs convert_short(short);
short __CVAttrs convert_short(ushort);
short __CVAttrs convert_short(int);
short __CVAttrs convert_short(uint);
short __CVAttrs convert_short(long);
short __CVAttrs convert_short(ulong);
short __CVAttrs convert_short(float);
short __CVAttrs convert_short(double);
short __CVAttrs convert_short_rte(char);
short __CVAttrs convert_short_rte(uchar);
short __CVAttrs convert_short_rte(short);
short __CVAttrs convert_short_rte(ushort);
short __CVAttrs convert_short_rte(int);
short __CVAttrs convert_short_rte(uint);
short __CVAttrs convert_short_rte(long);
short __CVAttrs convert_short_rte(ulong);
short __CVAttrs convert_short_rte(float);
short __CVAttrs convert_short_rte(double);
short __CVAttrs convert_short_rtz(char);
short __CVAttrs convert_short_rtz(uchar);
short __CVAttrs convert_short_rtz(short);
short __CVAttrs convert_short_rtz(ushort);
short __CVAttrs convert_short_rtz(int);
short __CVAttrs convert_short_rtz(uint);
short __CVAttrs convert_short_rtz(long);
short __CVAttrs convert_short_rtz(ulong);
short __CVAttrs convert_short_rtz(float);
short __CVAttrs convert_short_rtz(double);
short __CVAttrs convert_short_rtp(char);
short __CVAttrs convert_short_rtp(uchar);
short __CVAttrs convert_short_rtp(short);
short __CVAttrs convert_short_rtp(ushort);
short __CVAttrs convert_short_rtp(int);
short __CVAttrs convert_short_rtp(uint);
short __CVAttrs convert_short_rtp(long);
short __CVAttrs convert_short_rtp(ulong);
short __CVAttrs convert_short_rtp(float);
short __CVAttrs convert_short_rtp(double);
short __CVAttrs convert_short_rtn(char);
short __CVAttrs convert_short_rtn(uchar);
short __CVAttrs convert_short_rtn(short);
short __CVAttrs convert_short_rtn(ushort);
short __CVAttrs convert_short_rtn(int);
short __CVAttrs convert_short_rtn(uint);
short __CVAttrs convert_short_rtn(long);
short __CVAttrs convert_short_rtn(ulong);
short __CVAttrs convert_short_rtn(float);
short __CVAttrs convert_short_rtn(double);
short __CVAttrs convert_short_sat(char);
short __CVAttrs convert_short_sat(uchar);
short __CVAttrs convert_short_sat(short);
short __CVAttrs convert_short_sat(ushort);
short __CVAttrs convert_short_sat(int);
short __CVAttrs convert_short_sat(uint);
short __CVAttrs convert_short_sat(long);
short __CVAttrs convert_short_sat(ulong);
short __CVAttrs convert_short_sat(float);
short __CVAttrs convert_short_sat(double);
short __CVAttrs convert_short_sat_rte(char);
short __CVAttrs convert_short_sat_rte(uchar);
short __CVAttrs convert_short_sat_rte(short);
short __CVAttrs convert_short_sat_rte(ushort);
short __CVAttrs convert_short_sat_rte(int);
short __CVAttrs convert_short_sat_rte(uint);
short __CVAttrs convert_short_sat_rte(long);
short __CVAttrs convert_short_sat_rte(ulong);
short __CVAttrs convert_short_sat_rte(float);
short __CVAttrs convert_short_sat_rte(double);
short __CVAttrs convert_short_sat_rtz(char);
short __CVAttrs convert_short_sat_rtz(uchar);
short __CVAttrs convert_short_sat_rtz(short);
short __CVAttrs convert_short_sat_rtz(ushort);
short __CVAttrs convert_short_sat_rtz(int);
short __CVAttrs convert_short_sat_rtz(uint);
short __CVAttrs convert_short_sat_rtz(long);
short __CVAttrs convert_short_sat_rtz(ulong);
short __CVAttrs convert_short_sat_rtz(float);
short __CVAttrs convert_short_sat_rtz(double);
short __CVAttrs convert_short_sat_rtp(char);
short __CVAttrs convert_short_sat_rtp(uchar);
short __CVAttrs convert_short_sat_rtp(short);
short __CVAttrs convert_short_sat_rtp(ushort);
short __CVAttrs convert_short_sat_rtp(int);
short __CVAttrs convert_short_sat_rtp(uint);
short __CVAttrs convert_short_sat_rtp(long);
short __CVAttrs convert_short_sat_rtp(ulong);
short __CVAttrs convert_short_sat_rtp(float);
short __CVAttrs convert_short_sat_rtp(double);
short __CVAttrs convert_short_sat_rtn(char);
short __CVAttrs convert_short_sat_rtn(uchar);
short __CVAttrs convert_short_sat_rtn(short);
short __CVAttrs convert_short_sat_rtn(ushort);
short __CVAttrs convert_short_sat_rtn(int);
short __CVAttrs convert_short_sat_rtn(uint);
short __CVAttrs convert_short_sat_rtn(long);
short __CVAttrs convert_short_sat_rtn(ulong);
short __CVAttrs convert_short_sat_rtn(float);
short __CVAttrs convert_short_sat_rtn(double);
short2 __CVAttrs convert_short2(char2);
short2 __CVAttrs convert_short2(uchar2);
short2 __CVAttrs convert_short2(short2);
short2 __CVAttrs convert_short2(ushort2);
short2 __CVAttrs convert_short2(int2);
short2 __CVAttrs convert_short2(uint2);
short2 __CVAttrs convert_short2(long2);
short2 __CVAttrs convert_short2(ulong2);
short2 __CVAttrs convert_short2(float2);
short2 __CVAttrs convert_short2(double2);
short2 __CVAttrs convert_short2_rte(char2);
short2 __CVAttrs convert_short2_rte(uchar2);
short2 __CVAttrs convert_short2_rte(short2);
short2 __CVAttrs convert_short2_rte(ushort2);
short2 __CVAttrs convert_short2_rte(int2);
short2 __CVAttrs convert_short2_rte(uint2);
short2 __CVAttrs convert_short2_rte(long2);
short2 __CVAttrs convert_short2_rte(ulong2);
short2 __CVAttrs convert_short2_rte(float2);
short2 __CVAttrs convert_short2_rte(double2);
short2 __CVAttrs convert_short2_rtz(char2);
short2 __CVAttrs convert_short2_rtz(uchar2);
short2 __CVAttrs convert_short2_rtz(short2);
short2 __CVAttrs convert_short2_rtz(ushort2);
short2 __CVAttrs convert_short2_rtz(int2);
short2 __CVAttrs convert_short2_rtz(uint2);
short2 __CVAttrs convert_short2_rtz(long2);
short2 __CVAttrs convert_short2_rtz(ulong2);
short2 __CVAttrs convert_short2_rtz(float2);
short2 __CVAttrs convert_short2_rtz(double2);
short2 __CVAttrs convert_short2_rtp(char2);
short2 __CVAttrs convert_short2_rtp(uchar2);
short2 __CVAttrs convert_short2_rtp(short2);
short2 __CVAttrs convert_short2_rtp(ushort2);
short2 __CVAttrs convert_short2_rtp(int2);
short2 __CVAttrs convert_short2_rtp(uint2);
short2 __CVAttrs convert_short2_rtp(long2);
short2 __CVAttrs convert_short2_rtp(ulong2);
short2 __CVAttrs convert_short2_rtp(float2);
short2 __CVAttrs convert_short2_rtp(double2);
short2 __CVAttrs convert_short2_rtn(char2);
short2 __CVAttrs convert_short2_rtn(uchar2);
short2 __CVAttrs convert_short2_rtn(short2);
short2 __CVAttrs convert_short2_rtn(ushort2);
short2 __CVAttrs convert_short2_rtn(int2);
short2 __CVAttrs convert_short2_rtn(uint2);
short2 __CVAttrs convert_short2_rtn(long2);
short2 __CVAttrs convert_short2_rtn(ulong2);
short2 __CVAttrs convert_short2_rtn(float2);
short2 __CVAttrs convert_short2_rtn(double2);
short2 __CVAttrs convert_short2_sat(char2);
short2 __CVAttrs convert_short2_sat(uchar2);
short2 __CVAttrs convert_short2_sat(short2);
short2 __CVAttrs convert_short2_sat(ushort2);
short2 __CVAttrs convert_short2_sat(int2);
short2 __CVAttrs convert_short2_sat(uint2);
short2 __CVAttrs convert_short2_sat(long2);
short2 __CVAttrs convert_short2_sat(ulong2);
short2 __CVAttrs convert_short2_sat(float2);
short2 __CVAttrs convert_short2_sat(double2);
short2 __CVAttrs convert_short2_sat_rte(char2);
short2 __CVAttrs convert_short2_sat_rte(uchar2);
short2 __CVAttrs convert_short2_sat_rte(short2);
short2 __CVAttrs convert_short2_sat_rte(ushort2);
short2 __CVAttrs convert_short2_sat_rte(int2);
short2 __CVAttrs convert_short2_sat_rte(uint2);
short2 __CVAttrs convert_short2_sat_rte(long2);
short2 __CVAttrs convert_short2_sat_rte(ulong2);
short2 __CVAttrs convert_short2_sat_rte(float2);
short2 __CVAttrs convert_short2_sat_rte(double2);
short2 __CVAttrs convert_short2_sat_rtz(char2);
short2 __CVAttrs convert_short2_sat_rtz(uchar2);
short2 __CVAttrs convert_short2_sat_rtz(short2);
short2 __CVAttrs convert_short2_sat_rtz(ushort2);
short2 __CVAttrs convert_short2_sat_rtz(int2);
short2 __CVAttrs convert_short2_sat_rtz(uint2);
short2 __CVAttrs convert_short2_sat_rtz(long2);
short2 __CVAttrs convert_short2_sat_rtz(ulong2);
short2 __CVAttrs convert_short2_sat_rtz(float2);
short2 __CVAttrs convert_short2_sat_rtz(double2);
short2 __CVAttrs convert_short2_sat_rtp(char2);
short2 __CVAttrs convert_short2_sat_rtp(uchar2);
short2 __CVAttrs convert_short2_sat_rtp(short2);
short2 __CVAttrs convert_short2_sat_rtp(ushort2);
short2 __CVAttrs convert_short2_sat_rtp(int2);
short2 __CVAttrs convert_short2_sat_rtp(uint2);
short2 __CVAttrs convert_short2_sat_rtp(long2);
short2 __CVAttrs convert_short2_sat_rtp(ulong2);
short2 __CVAttrs convert_short2_sat_rtp(float2);
short2 __CVAttrs convert_short2_sat_rtp(double2);
short2 __CVAttrs convert_short2_sat_rtn(char2);
short2 __CVAttrs convert_short2_sat_rtn(uchar2);
short2 __CVAttrs convert_short2_sat_rtn(short2);
short2 __CVAttrs convert_short2_sat_rtn(ushort2);
short2 __CVAttrs convert_short2_sat_rtn(int2);
short2 __CVAttrs convert_short2_sat_rtn(uint2);
short2 __CVAttrs convert_short2_sat_rtn(long2);
short2 __CVAttrs convert_short2_sat_rtn(ulong2);
short2 __CVAttrs convert_short2_sat_rtn(float2);
short2 __CVAttrs convert_short2_sat_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
short3 __CVAttrs convert_short3(char3);
short3 __CVAttrs convert_short3(uchar3);
short3 __CVAttrs convert_short3(short3);
short3 __CVAttrs convert_short3(ushort3);
short3 __CVAttrs convert_short3(int3);
short3 __CVAttrs convert_short3(uint3);
short3 __CVAttrs convert_short3(long3);
short3 __CVAttrs convert_short3(ulong3);
short3 __CVAttrs convert_short3(float3);
short3 __CVAttrs convert_short3(double3);
short3 __CVAttrs convert_short3_rte(char3);
short3 __CVAttrs convert_short3_rte(uchar3);
short3 __CVAttrs convert_short3_rte(short3);
short3 __CVAttrs convert_short3_rte(ushort3);
short3 __CVAttrs convert_short3_rte(int3);
short3 __CVAttrs convert_short3_rte(uint3);
short3 __CVAttrs convert_short3_rte(long3);
short3 __CVAttrs convert_short3_rte(ulong3);
short3 __CVAttrs convert_short3_rte(float3);
short3 __CVAttrs convert_short3_rte(double3);
short3 __CVAttrs convert_short3_rtz(char3);
short3 __CVAttrs convert_short3_rtz(uchar3);
short3 __CVAttrs convert_short3_rtz(short3);
short3 __CVAttrs convert_short3_rtz(ushort3);
short3 __CVAttrs convert_short3_rtz(int3);
short3 __CVAttrs convert_short3_rtz(uint3);
short3 __CVAttrs convert_short3_rtz(long3);
short3 __CVAttrs convert_short3_rtz(ulong3);
short3 __CVAttrs convert_short3_rtz(float3);
short3 __CVAttrs convert_short3_rtz(double3);
short3 __CVAttrs convert_short3_rtp(char3);
short3 __CVAttrs convert_short3_rtp(uchar3);
short3 __CVAttrs convert_short3_rtp(short3);
short3 __CVAttrs convert_short3_rtp(ushort3);
short3 __CVAttrs convert_short3_rtp(int3);
short3 __CVAttrs convert_short3_rtp(uint3);
short3 __CVAttrs convert_short3_rtp(long3);
short3 __CVAttrs convert_short3_rtp(ulong3);
short3 __CVAttrs convert_short3_rtp(float3);
short3 __CVAttrs convert_short3_rtp(double3);
short3 __CVAttrs convert_short3_rtn(char3);
short3 __CVAttrs convert_short3_rtn(uchar3);
short3 __CVAttrs convert_short3_rtn(short3);
short3 __CVAttrs convert_short3_rtn(ushort3);
short3 __CVAttrs convert_short3_rtn(int3);
short3 __CVAttrs convert_short3_rtn(uint3);
short3 __CVAttrs convert_short3_rtn(long3);
short3 __CVAttrs convert_short3_rtn(ulong3);
short3 __CVAttrs convert_short3_rtn(float3);
short3 __CVAttrs convert_short3_rtn(double3);
short3 __CVAttrs convert_short3_sat(char3);
short3 __CVAttrs convert_short3_sat(uchar3);
short3 __CVAttrs convert_short3_sat(short3);
short3 __CVAttrs convert_short3_sat(ushort3);
short3 __CVAttrs convert_short3_sat(int3);
short3 __CVAttrs convert_short3_sat(uint3);
short3 __CVAttrs convert_short3_sat(long3);
short3 __CVAttrs convert_short3_sat(ulong3);
short3 __CVAttrs convert_short3_sat(float3);
short3 __CVAttrs convert_short3_sat(double3);
short3 __CVAttrs convert_short3_sat_rte(char3);
short3 __CVAttrs convert_short3_sat_rte(uchar3);
short3 __CVAttrs convert_short3_sat_rte(short3);
short3 __CVAttrs convert_short3_sat_rte(ushort3);
short3 __CVAttrs convert_short3_sat_rte(int3);
short3 __CVAttrs convert_short3_sat_rte(uint3);
short3 __CVAttrs convert_short3_sat_rte(long3);
short3 __CVAttrs convert_short3_sat_rte(ulong3);
short3 __CVAttrs convert_short3_sat_rte(float3);
short3 __CVAttrs convert_short3_sat_rte(double3);
short3 __CVAttrs convert_short3_sat_rtz(char3);
short3 __CVAttrs convert_short3_sat_rtz(uchar3);
short3 __CVAttrs convert_short3_sat_rtz(short3);
short3 __CVAttrs convert_short3_sat_rtz(ushort3);
short3 __CVAttrs convert_short3_sat_rtz(int3);
short3 __CVAttrs convert_short3_sat_rtz(uint3);
short3 __CVAttrs convert_short3_sat_rtz(long3);
short3 __CVAttrs convert_short3_sat_rtz(ulong3);
short3 __CVAttrs convert_short3_sat_rtz(float3);
short3 __CVAttrs convert_short3_sat_rtz(double3);
short3 __CVAttrs convert_short3_sat_rtp(char3);
short3 __CVAttrs convert_short3_sat_rtp(uchar3);
short3 __CVAttrs convert_short3_sat_rtp(short3);
short3 __CVAttrs convert_short3_sat_rtp(ushort3);
short3 __CVAttrs convert_short3_sat_rtp(int3);
short3 __CVAttrs convert_short3_sat_rtp(uint3);
short3 __CVAttrs convert_short3_sat_rtp(long3);
short3 __CVAttrs convert_short3_sat_rtp(ulong3);
short3 __CVAttrs convert_short3_sat_rtp(float3);
short3 __CVAttrs convert_short3_sat_rtp(double3);
short3 __CVAttrs convert_short3_sat_rtn(char3);
short3 __CVAttrs convert_short3_sat_rtn(uchar3);
short3 __CVAttrs convert_short3_sat_rtn(short3);
short3 __CVAttrs convert_short3_sat_rtn(ushort3);
short3 __CVAttrs convert_short3_sat_rtn(int3);
short3 __CVAttrs convert_short3_sat_rtn(uint3);
short3 __CVAttrs convert_short3_sat_rtn(long3);
short3 __CVAttrs convert_short3_sat_rtn(ulong3);
short3 __CVAttrs convert_short3_sat_rtn(float3);
short3 __CVAttrs convert_short3_sat_rtn(double3);
#endif
short4 __CVAttrs convert_short4(char4);
short4 __CVAttrs convert_short4(uchar4);
short4 __CVAttrs convert_short4(short4);
short4 __CVAttrs convert_short4(ushort4);
short4 __CVAttrs convert_short4(int4);
short4 __CVAttrs convert_short4(uint4);
short4 __CVAttrs convert_short4(long4);
short4 __CVAttrs convert_short4(ulong4);
short4 __CVAttrs convert_short4(float4);
short4 __CVAttrs convert_short4(double4);
short4 __CVAttrs convert_short4_rte(char4);
short4 __CVAttrs convert_short4_rte(uchar4);
short4 __CVAttrs convert_short4_rte(short4);
short4 __CVAttrs convert_short4_rte(ushort4);
short4 __CVAttrs convert_short4_rte(int4);
short4 __CVAttrs convert_short4_rte(uint4);
short4 __CVAttrs convert_short4_rte(long4);
short4 __CVAttrs convert_short4_rte(ulong4);
short4 __CVAttrs convert_short4_rte(float4);
short4 __CVAttrs convert_short4_rte(double4);
short4 __CVAttrs convert_short4_rtz(char4);
short4 __CVAttrs convert_short4_rtz(uchar4);
short4 __CVAttrs convert_short4_rtz(short4);
short4 __CVAttrs convert_short4_rtz(ushort4);
short4 __CVAttrs convert_short4_rtz(int4);
short4 __CVAttrs convert_short4_rtz(uint4);
short4 __CVAttrs convert_short4_rtz(long4);
short4 __CVAttrs convert_short4_rtz(ulong4);
short4 __CVAttrs convert_short4_rtz(float4);
short4 __CVAttrs convert_short4_rtz(double4);
short4 __CVAttrs convert_short4_rtp(char4);
short4 __CVAttrs convert_short4_rtp(uchar4);
short4 __CVAttrs convert_short4_rtp(short4);
short4 __CVAttrs convert_short4_rtp(ushort4);
short4 __CVAttrs convert_short4_rtp(int4);
short4 __CVAttrs convert_short4_rtp(uint4);
short4 __CVAttrs convert_short4_rtp(long4);
short4 __CVAttrs convert_short4_rtp(ulong4);
short4 __CVAttrs convert_short4_rtp(float4);
short4 __CVAttrs convert_short4_rtp(double4);
short4 __CVAttrs convert_short4_rtn(char4);
short4 __CVAttrs convert_short4_rtn(uchar4);
short4 __CVAttrs convert_short4_rtn(short4);
short4 __CVAttrs convert_short4_rtn(ushort4);
short4 __CVAttrs convert_short4_rtn(int4);
short4 __CVAttrs convert_short4_rtn(uint4);
short4 __CVAttrs convert_short4_rtn(long4);
short4 __CVAttrs convert_short4_rtn(ulong4);
short4 __CVAttrs convert_short4_rtn(float4);
short4 __CVAttrs convert_short4_rtn(double4);
short4 __CVAttrs convert_short4_sat(char4);
short4 __CVAttrs convert_short4_sat(uchar4);
short4 __CVAttrs convert_short4_sat(short4);
short4 __CVAttrs convert_short4_sat(ushort4);
short4 __CVAttrs convert_short4_sat(int4);
short4 __CVAttrs convert_short4_sat(uint4);
short4 __CVAttrs convert_short4_sat(long4);
short4 __CVAttrs convert_short4_sat(ulong4);
short4 __CVAttrs convert_short4_sat(float4);
short4 __CVAttrs convert_short4_sat(double4);
short4 __CVAttrs convert_short4_sat_rte(char4);
short4 __CVAttrs convert_short4_sat_rte(uchar4);
short4 __CVAttrs convert_short4_sat_rte(short4);
short4 __CVAttrs convert_short4_sat_rte(ushort4);
short4 __CVAttrs convert_short4_sat_rte(int4);
short4 __CVAttrs convert_short4_sat_rte(uint4);
short4 __CVAttrs convert_short4_sat_rte(long4);
short4 __CVAttrs convert_short4_sat_rte(ulong4);
short4 __CVAttrs convert_short4_sat_rte(float4);
short4 __CVAttrs convert_short4_sat_rte(double4);
short4 __CVAttrs convert_short4_sat_rtz(char4);
short4 __CVAttrs convert_short4_sat_rtz(uchar4);
short4 __CVAttrs convert_short4_sat_rtz(short4);
short4 __CVAttrs convert_short4_sat_rtz(ushort4);
short4 __CVAttrs convert_short4_sat_rtz(int4);
short4 __CVAttrs convert_short4_sat_rtz(uint4);
short4 __CVAttrs convert_short4_sat_rtz(long4);
short4 __CVAttrs convert_short4_sat_rtz(ulong4);
short4 __CVAttrs convert_short4_sat_rtz(float4);
short4 __CVAttrs convert_short4_sat_rtz(double4);
short4 __CVAttrs convert_short4_sat_rtp(char4);
short4 __CVAttrs convert_short4_sat_rtp(uchar4);
short4 __CVAttrs convert_short4_sat_rtp(short4);
short4 __CVAttrs convert_short4_sat_rtp(ushort4);
short4 __CVAttrs convert_short4_sat_rtp(int4);
short4 __CVAttrs convert_short4_sat_rtp(uint4);
short4 __CVAttrs convert_short4_sat_rtp(long4);
short4 __CVAttrs convert_short4_sat_rtp(ulong4);
short4 __CVAttrs convert_short4_sat_rtp(float4);
short4 __CVAttrs convert_short4_sat_rtp(double4);
short4 __CVAttrs convert_short4_sat_rtn(char4);
short4 __CVAttrs convert_short4_sat_rtn(uchar4);
short4 __CVAttrs convert_short4_sat_rtn(short4);
short4 __CVAttrs convert_short4_sat_rtn(ushort4);
short4 __CVAttrs convert_short4_sat_rtn(int4);
short4 __CVAttrs convert_short4_sat_rtn(uint4);
short4 __CVAttrs convert_short4_sat_rtn(long4);
short4 __CVAttrs convert_short4_sat_rtn(ulong4);
short4 __CVAttrs convert_short4_sat_rtn(float4);
short4 __CVAttrs convert_short4_sat_rtn(double4);
short8 __CVAttrs convert_short8(char8);
short8 __CVAttrs convert_short8(uchar8);
short8 __CVAttrs convert_short8(short8);
short8 __CVAttrs convert_short8(ushort8);
short8 __CVAttrs convert_short8(int8);
short8 __CVAttrs convert_short8(uint8);
short8 __CVAttrs convert_short8(long8);
short8 __CVAttrs convert_short8(ulong8);
short8 __CVAttrs convert_short8(float8);
short8 __CVAttrs convert_short8(double8);
short8 __CVAttrs convert_short8_rte(char8);
short8 __CVAttrs convert_short8_rte(uchar8);
short8 __CVAttrs convert_short8_rte(short8);
short8 __CVAttrs convert_short8_rte(ushort8);
short8 __CVAttrs convert_short8_rte(int8);
short8 __CVAttrs convert_short8_rte(uint8);
short8 __CVAttrs convert_short8_rte(long8);
short8 __CVAttrs convert_short8_rte(ulong8);
short8 __CVAttrs convert_short8_rte(float8);
short8 __CVAttrs convert_short8_rte(double8);
short8 __CVAttrs convert_short8_rtz(char8);
short8 __CVAttrs convert_short8_rtz(uchar8);
short8 __CVAttrs convert_short8_rtz(short8);
short8 __CVAttrs convert_short8_rtz(ushort8);
short8 __CVAttrs convert_short8_rtz(int8);
short8 __CVAttrs convert_short8_rtz(uint8);
short8 __CVAttrs convert_short8_rtz(long8);
short8 __CVAttrs convert_short8_rtz(ulong8);
short8 __CVAttrs convert_short8_rtz(float8);
short8 __CVAttrs convert_short8_rtz(double8);
short8 __CVAttrs convert_short8_rtp(char8);
short8 __CVAttrs convert_short8_rtp(uchar8);
short8 __CVAttrs convert_short8_rtp(short8);
short8 __CVAttrs convert_short8_rtp(ushort8);
short8 __CVAttrs convert_short8_rtp(int8);
short8 __CVAttrs convert_short8_rtp(uint8);
short8 __CVAttrs convert_short8_rtp(long8);
short8 __CVAttrs convert_short8_rtp(ulong8);
short8 __CVAttrs convert_short8_rtp(float8);
short8 __CVAttrs convert_short8_rtp(double8);
short8 __CVAttrs convert_short8_rtn(char8);
short8 __CVAttrs convert_short8_rtn(uchar8);
short8 __CVAttrs convert_short8_rtn(short8);
short8 __CVAttrs convert_short8_rtn(ushort8);
short8 __CVAttrs convert_short8_rtn(int8);
short8 __CVAttrs convert_short8_rtn(uint8);
short8 __CVAttrs convert_short8_rtn(long8);
short8 __CVAttrs convert_short8_rtn(ulong8);
short8 __CVAttrs convert_short8_rtn(float8);
short8 __CVAttrs convert_short8_rtn(double8);
short8 __CVAttrs convert_short8_sat(char8);
short8 __CVAttrs convert_short8_sat(uchar8);
short8 __CVAttrs convert_short8_sat(short8);
short8 __CVAttrs convert_short8_sat(ushort8);
short8 __CVAttrs convert_short8_sat(int8);
short8 __CVAttrs convert_short8_sat(uint8);
short8 __CVAttrs convert_short8_sat(long8);
short8 __CVAttrs convert_short8_sat(ulong8);
short8 __CVAttrs convert_short8_sat(float8);
short8 __CVAttrs convert_short8_sat(double8);
short8 __CVAttrs convert_short8_sat_rte(char8);
short8 __CVAttrs convert_short8_sat_rte(uchar8);
short8 __CVAttrs convert_short8_sat_rte(short8);
short8 __CVAttrs convert_short8_sat_rte(ushort8);
short8 __CVAttrs convert_short8_sat_rte(int8);
short8 __CVAttrs convert_short8_sat_rte(uint8);
short8 __CVAttrs convert_short8_sat_rte(long8);
short8 __CVAttrs convert_short8_sat_rte(ulong8);
short8 __CVAttrs convert_short8_sat_rte(float8);
short8 __CVAttrs convert_short8_sat_rte(double8);
short8 __CVAttrs convert_short8_sat_rtz(char8);
short8 __CVAttrs convert_short8_sat_rtz(uchar8);
short8 __CVAttrs convert_short8_sat_rtz(short8);
short8 __CVAttrs convert_short8_sat_rtz(ushort8);
short8 __CVAttrs convert_short8_sat_rtz(int8);
short8 __CVAttrs convert_short8_sat_rtz(uint8);
short8 __CVAttrs convert_short8_sat_rtz(long8);
short8 __CVAttrs convert_short8_sat_rtz(ulong8);
short8 __CVAttrs convert_short8_sat_rtz(float8);
short8 __CVAttrs convert_short8_sat_rtz(double8);
short8 __CVAttrs convert_short8_sat_rtp(char8);
short8 __CVAttrs convert_short8_sat_rtp(uchar8);
short8 __CVAttrs convert_short8_sat_rtp(short8);
short8 __CVAttrs convert_short8_sat_rtp(ushort8);
short8 __CVAttrs convert_short8_sat_rtp(int8);
short8 __CVAttrs convert_short8_sat_rtp(uint8);
short8 __CVAttrs convert_short8_sat_rtp(long8);
short8 __CVAttrs convert_short8_sat_rtp(ulong8);
short8 __CVAttrs convert_short8_sat_rtp(float8);
short8 __CVAttrs convert_short8_sat_rtp(double8);
short8 __CVAttrs convert_short8_sat_rtn(char8);
short8 __CVAttrs convert_short8_sat_rtn(uchar8);
short8 __CVAttrs convert_short8_sat_rtn(short8);
short8 __CVAttrs convert_short8_sat_rtn(ushort8);
short8 __CVAttrs convert_short8_sat_rtn(int8);
short8 __CVAttrs convert_short8_sat_rtn(uint8);
short8 __CVAttrs convert_short8_sat_rtn(long8);
short8 __CVAttrs convert_short8_sat_rtn(ulong8);
short8 __CVAttrs convert_short8_sat_rtn(float8);
short8 __CVAttrs convert_short8_sat_rtn(double8);
short16 __CVAttrs convert_short16(char16);
short16 __CVAttrs convert_short16(uchar16);
short16 __CVAttrs convert_short16(short16);
short16 __CVAttrs convert_short16(ushort16);
short16 __CVAttrs convert_short16(int16);
short16 __CVAttrs convert_short16(uint16);
short16 __CVAttrs convert_short16(long16);
short16 __CVAttrs convert_short16(ulong16);
short16 __CVAttrs convert_short16(float16);
short16 __CVAttrs convert_short16(double16);
short16 __CVAttrs convert_short16_rte(char16);
short16 __CVAttrs convert_short16_rte(uchar16);
short16 __CVAttrs convert_short16_rte(short16);
short16 __CVAttrs convert_short16_rte(ushort16);
short16 __CVAttrs convert_short16_rte(int16);
short16 __CVAttrs convert_short16_rte(uint16);
short16 __CVAttrs convert_short16_rte(long16);
short16 __CVAttrs convert_short16_rte(ulong16);
short16 __CVAttrs convert_short16_rte(float16);
short16 __CVAttrs convert_short16_rte(double16);
short16 __CVAttrs convert_short16_rtz(char16);
short16 __CVAttrs convert_short16_rtz(uchar16);
short16 __CVAttrs convert_short16_rtz(short16);
short16 __CVAttrs convert_short16_rtz(ushort16);
short16 __CVAttrs convert_short16_rtz(int16);
short16 __CVAttrs convert_short16_rtz(uint16);
short16 __CVAttrs convert_short16_rtz(long16);
short16 __CVAttrs convert_short16_rtz(ulong16);
short16 __CVAttrs convert_short16_rtz(float16);
short16 __CVAttrs convert_short16_rtz(double16);
short16 __CVAttrs convert_short16_rtp(char16);
short16 __CVAttrs convert_short16_rtp(uchar16);
short16 __CVAttrs convert_short16_rtp(short16);
short16 __CVAttrs convert_short16_rtp(ushort16);
short16 __CVAttrs convert_short16_rtp(int16);
short16 __CVAttrs convert_short16_rtp(uint16);
short16 __CVAttrs convert_short16_rtp(long16);
short16 __CVAttrs convert_short16_rtp(ulong16);
short16 __CVAttrs convert_short16_rtp(float16);
short16 __CVAttrs convert_short16_rtp(double16);
short16 __CVAttrs convert_short16_rtn(char16);
short16 __CVAttrs convert_short16_rtn(uchar16);
short16 __CVAttrs convert_short16_rtn(short16);
short16 __CVAttrs convert_short16_rtn(ushort16);
short16 __CVAttrs convert_short16_rtn(int16);
short16 __CVAttrs convert_short16_rtn(uint16);
short16 __CVAttrs convert_short16_rtn(long16);
short16 __CVAttrs convert_short16_rtn(ulong16);
short16 __CVAttrs convert_short16_rtn(float16);
short16 __CVAttrs convert_short16_rtn(double16);
short16 __CVAttrs convert_short16_sat(char16);
short16 __CVAttrs convert_short16_sat(uchar16);
short16 __CVAttrs convert_short16_sat(short16);
short16 __CVAttrs convert_short16_sat(ushort16);
short16 __CVAttrs convert_short16_sat(int16);
short16 __CVAttrs convert_short16_sat(uint16);
short16 __CVAttrs convert_short16_sat(long16);
short16 __CVAttrs convert_short16_sat(ulong16);
short16 __CVAttrs convert_short16_sat(float16);
short16 __CVAttrs convert_short16_sat(double16);
short16 __CVAttrs convert_short16_sat_rte(char16);
short16 __CVAttrs convert_short16_sat_rte(uchar16);
short16 __CVAttrs convert_short16_sat_rte(short16);
short16 __CVAttrs convert_short16_sat_rte(ushort16);
short16 __CVAttrs convert_short16_sat_rte(int16);
short16 __CVAttrs convert_short16_sat_rte(uint16);
short16 __CVAttrs convert_short16_sat_rte(long16);
short16 __CVAttrs convert_short16_sat_rte(ulong16);
short16 __CVAttrs convert_short16_sat_rte(float16);
short16 __CVAttrs convert_short16_sat_rte(double16);
short16 __CVAttrs convert_short16_sat_rtz(char16);
short16 __CVAttrs convert_short16_sat_rtz(uchar16);
short16 __CVAttrs convert_short16_sat_rtz(short16);
short16 __CVAttrs convert_short16_sat_rtz(ushort16);
short16 __CVAttrs convert_short16_sat_rtz(int16);
short16 __CVAttrs convert_short16_sat_rtz(uint16);
short16 __CVAttrs convert_short16_sat_rtz(long16);
short16 __CVAttrs convert_short16_sat_rtz(ulong16);
short16 __CVAttrs convert_short16_sat_rtz(float16);
short16 __CVAttrs convert_short16_sat_rtz(double16);
short16 __CVAttrs convert_short16_sat_rtp(char16);
short16 __CVAttrs convert_short16_sat_rtp(uchar16);
short16 __CVAttrs convert_short16_sat_rtp(short16);
short16 __CVAttrs convert_short16_sat_rtp(ushort16);
short16 __CVAttrs convert_short16_sat_rtp(int16);
short16 __CVAttrs convert_short16_sat_rtp(uint16);
short16 __CVAttrs convert_short16_sat_rtp(long16);
short16 __CVAttrs convert_short16_sat_rtp(ulong16);
short16 __CVAttrs convert_short16_sat_rtp(float16);
short16 __CVAttrs convert_short16_sat_rtp(double16);
short16 __CVAttrs convert_short16_sat_rtn(char16);
short16 __CVAttrs convert_short16_sat_rtn(uchar16);
short16 __CVAttrs convert_short16_sat_rtn(short16);
short16 __CVAttrs convert_short16_sat_rtn(ushort16);
short16 __CVAttrs convert_short16_sat_rtn(int16);
short16 __CVAttrs convert_short16_sat_rtn(uint16);
short16 __CVAttrs convert_short16_sat_rtn(long16);
short16 __CVAttrs convert_short16_sat_rtn(ulong16);
short16 __CVAttrs convert_short16_sat_rtn(float16);
short16 __CVAttrs convert_short16_sat_rtn(double16);
ushort __CVAttrs convert_ushort(char);
ushort __CVAttrs convert_ushort(uchar);
ushort __CVAttrs convert_ushort(short);
ushort __CVAttrs convert_ushort(ushort);
ushort __CVAttrs convert_ushort(int);
ushort __CVAttrs convert_ushort(uint);
ushort __CVAttrs convert_ushort(long);
ushort __CVAttrs convert_ushort(ulong);
ushort __CVAttrs convert_ushort(float);
ushort __CVAttrs convert_ushort(double);
ushort __CVAttrs convert_ushort_rte(char);
ushort __CVAttrs convert_ushort_rte(uchar);
ushort __CVAttrs convert_ushort_rte(short);
ushort __CVAttrs convert_ushort_rte(ushort);
ushort __CVAttrs convert_ushort_rte(int);
ushort __CVAttrs convert_ushort_rte(uint);
ushort __CVAttrs convert_ushort_rte(long);
ushort __CVAttrs convert_ushort_rte(ulong);
ushort __CVAttrs convert_ushort_rte(float);
ushort __CVAttrs convert_ushort_rte(double);
ushort __CVAttrs convert_ushort_rtz(char);
ushort __CVAttrs convert_ushort_rtz(uchar);
ushort __CVAttrs convert_ushort_rtz(short);
ushort __CVAttrs convert_ushort_rtz(ushort);
ushort __CVAttrs convert_ushort_rtz(int);
ushort __CVAttrs convert_ushort_rtz(uint);
ushort __CVAttrs convert_ushort_rtz(long);
ushort __CVAttrs convert_ushort_rtz(ulong);
ushort __CVAttrs convert_ushort_rtz(float);
ushort __CVAttrs convert_ushort_rtz(double);
ushort __CVAttrs convert_ushort_rtp(char);
ushort __CVAttrs convert_ushort_rtp(uchar);
ushort __CVAttrs convert_ushort_rtp(short);
ushort __CVAttrs convert_ushort_rtp(ushort);
ushort __CVAttrs convert_ushort_rtp(int);
ushort __CVAttrs convert_ushort_rtp(uint);
ushort __CVAttrs convert_ushort_rtp(long);
ushort __CVAttrs convert_ushort_rtp(ulong);
ushort __CVAttrs convert_ushort_rtp(float);
ushort __CVAttrs convert_ushort_rtp(double);
ushort __CVAttrs convert_ushort_rtn(char);
ushort __CVAttrs convert_ushort_rtn(uchar);
ushort __CVAttrs convert_ushort_rtn(short);
ushort __CVAttrs convert_ushort_rtn(ushort);
ushort __CVAttrs convert_ushort_rtn(int);
ushort __CVAttrs convert_ushort_rtn(uint);
ushort __CVAttrs convert_ushort_rtn(long);
ushort __CVAttrs convert_ushort_rtn(ulong);
ushort __CVAttrs convert_ushort_rtn(float);
ushort __CVAttrs convert_ushort_rtn(double);
ushort __CVAttrs convert_ushort_sat(char);
ushort __CVAttrs convert_ushort_sat(uchar);
ushort __CVAttrs convert_ushort_sat(short);
ushort __CVAttrs convert_ushort_sat(ushort);
ushort __CVAttrs convert_ushort_sat(int);
ushort __CVAttrs convert_ushort_sat(uint);
ushort __CVAttrs convert_ushort_sat(long);
ushort __CVAttrs convert_ushort_sat(ulong);
ushort __CVAttrs convert_ushort_sat(float);
ushort __CVAttrs convert_ushort_sat(double);
ushort __CVAttrs convert_ushort_sat_rte(char);
ushort __CVAttrs convert_ushort_sat_rte(uchar);
ushort __CVAttrs convert_ushort_sat_rte(short);
ushort __CVAttrs convert_ushort_sat_rte(ushort);
ushort __CVAttrs convert_ushort_sat_rte(int);
ushort __CVAttrs convert_ushort_sat_rte(uint);
ushort __CVAttrs convert_ushort_sat_rte(long);
ushort __CVAttrs convert_ushort_sat_rte(ulong);
ushort __CVAttrs convert_ushort_sat_rte(float);
ushort __CVAttrs convert_ushort_sat_rte(double);
ushort __CVAttrs convert_ushort_sat_rtz(char);
ushort __CVAttrs convert_ushort_sat_rtz(uchar);
ushort __CVAttrs convert_ushort_sat_rtz(short);
ushort __CVAttrs convert_ushort_sat_rtz(ushort);
ushort __CVAttrs convert_ushort_sat_rtz(int);
ushort __CVAttrs convert_ushort_sat_rtz(uint);
ushort __CVAttrs convert_ushort_sat_rtz(long);
ushort __CVAttrs convert_ushort_sat_rtz(ulong);
ushort __CVAttrs convert_ushort_sat_rtz(float);
ushort __CVAttrs convert_ushort_sat_rtz(double);
ushort __CVAttrs convert_ushort_sat_rtp(char);
ushort __CVAttrs convert_ushort_sat_rtp(uchar);
ushort __CVAttrs convert_ushort_sat_rtp(short);
ushort __CVAttrs convert_ushort_sat_rtp(ushort);
ushort __CVAttrs convert_ushort_sat_rtp(int);
ushort __CVAttrs convert_ushort_sat_rtp(uint);
ushort __CVAttrs convert_ushort_sat_rtp(long);
ushort __CVAttrs convert_ushort_sat_rtp(ulong);
ushort __CVAttrs convert_ushort_sat_rtp(float);
ushort __CVAttrs convert_ushort_sat_rtp(double);
ushort __CVAttrs convert_ushort_sat_rtn(char);
ushort __CVAttrs convert_ushort_sat_rtn(uchar);
ushort __CVAttrs convert_ushort_sat_rtn(short);
ushort __CVAttrs convert_ushort_sat_rtn(ushort);
ushort __CVAttrs convert_ushort_sat_rtn(int);
ushort __CVAttrs convert_ushort_sat_rtn(uint);
ushort __CVAttrs convert_ushort_sat_rtn(long);
ushort __CVAttrs convert_ushort_sat_rtn(ulong);
ushort __CVAttrs convert_ushort_sat_rtn(float);
ushort __CVAttrs convert_ushort_sat_rtn(double);
ushort2 __CVAttrs convert_ushort2(char2);
ushort2 __CVAttrs convert_ushort2(uchar2);
ushort2 __CVAttrs convert_ushort2(short2);
ushort2 __CVAttrs convert_ushort2(ushort2);
ushort2 __CVAttrs convert_ushort2(int2);
ushort2 __CVAttrs convert_ushort2(uint2);
ushort2 __CVAttrs convert_ushort2(long2);
ushort2 __CVAttrs convert_ushort2(ulong2);
ushort2 __CVAttrs convert_ushort2(float2);
ushort2 __CVAttrs convert_ushort2(double2);
ushort2 __CVAttrs convert_ushort2_rte(char2);
ushort2 __CVAttrs convert_ushort2_rte(uchar2);
ushort2 __CVAttrs convert_ushort2_rte(short2);
ushort2 __CVAttrs convert_ushort2_rte(ushort2);
ushort2 __CVAttrs convert_ushort2_rte(int2);
ushort2 __CVAttrs convert_ushort2_rte(uint2);
ushort2 __CVAttrs convert_ushort2_rte(long2);
ushort2 __CVAttrs convert_ushort2_rte(ulong2);
ushort2 __CVAttrs convert_ushort2_rte(float2);
ushort2 __CVAttrs convert_ushort2_rte(double2);
ushort2 __CVAttrs convert_ushort2_rtz(char2);
ushort2 __CVAttrs convert_ushort2_rtz(uchar2);
ushort2 __CVAttrs convert_ushort2_rtz(short2);
ushort2 __CVAttrs convert_ushort2_rtz(ushort2);
ushort2 __CVAttrs convert_ushort2_rtz(int2);
ushort2 __CVAttrs convert_ushort2_rtz(uint2);
ushort2 __CVAttrs convert_ushort2_rtz(long2);
ushort2 __CVAttrs convert_ushort2_rtz(ulong2);
ushort2 __CVAttrs convert_ushort2_rtz(float2);
ushort2 __CVAttrs convert_ushort2_rtz(double2);
ushort2 __CVAttrs convert_ushort2_rtp(char2);
ushort2 __CVAttrs convert_ushort2_rtp(uchar2);
ushort2 __CVAttrs convert_ushort2_rtp(short2);
ushort2 __CVAttrs convert_ushort2_rtp(ushort2);
ushort2 __CVAttrs convert_ushort2_rtp(int2);
ushort2 __CVAttrs convert_ushort2_rtp(uint2);
ushort2 __CVAttrs convert_ushort2_rtp(long2);
ushort2 __CVAttrs convert_ushort2_rtp(ulong2);
ushort2 __CVAttrs convert_ushort2_rtp(float2);
ushort2 __CVAttrs convert_ushort2_rtp(double2);
ushort2 __CVAttrs convert_ushort2_rtn(char2);
ushort2 __CVAttrs convert_ushort2_rtn(uchar2);
ushort2 __CVAttrs convert_ushort2_rtn(short2);
ushort2 __CVAttrs convert_ushort2_rtn(ushort2);
ushort2 __CVAttrs convert_ushort2_rtn(int2);
ushort2 __CVAttrs convert_ushort2_rtn(uint2);
ushort2 __CVAttrs convert_ushort2_rtn(long2);
ushort2 __CVAttrs convert_ushort2_rtn(ulong2);
ushort2 __CVAttrs convert_ushort2_rtn(float2);
ushort2 __CVAttrs convert_ushort2_rtn(double2);
ushort2 __CVAttrs convert_ushort2_sat(char2);
ushort2 __CVAttrs convert_ushort2_sat(uchar2);
ushort2 __CVAttrs convert_ushort2_sat(short2);
ushort2 __CVAttrs convert_ushort2_sat(ushort2);
ushort2 __CVAttrs convert_ushort2_sat(int2);
ushort2 __CVAttrs convert_ushort2_sat(uint2);
ushort2 __CVAttrs convert_ushort2_sat(long2);
ushort2 __CVAttrs convert_ushort2_sat(ulong2);
ushort2 __CVAttrs convert_ushort2_sat(float2);
ushort2 __CVAttrs convert_ushort2_sat(double2);
ushort2 __CVAttrs convert_ushort2_sat_rte(char2);
ushort2 __CVAttrs convert_ushort2_sat_rte(uchar2);
ushort2 __CVAttrs convert_ushort2_sat_rte(short2);
ushort2 __CVAttrs convert_ushort2_sat_rte(ushort2);
ushort2 __CVAttrs convert_ushort2_sat_rte(int2);
ushort2 __CVAttrs convert_ushort2_sat_rte(uint2);
ushort2 __CVAttrs convert_ushort2_sat_rte(long2);
ushort2 __CVAttrs convert_ushort2_sat_rte(ulong2);
ushort2 __CVAttrs convert_ushort2_sat_rte(float2);
ushort2 __CVAttrs convert_ushort2_sat_rte(double2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(char2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(uchar2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(short2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(ushort2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(int2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(uint2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(long2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(ulong2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(float2);
ushort2 __CVAttrs convert_ushort2_sat_rtz(double2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(char2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(uchar2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(short2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(ushort2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(int2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(uint2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(long2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(ulong2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(float2);
ushort2 __CVAttrs convert_ushort2_sat_rtp(double2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(char2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(uchar2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(short2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(ushort2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(int2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(uint2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(long2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(ulong2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(float2);
ushort2 __CVAttrs convert_ushort2_sat_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
ushort3 __CVAttrs convert_ushort3(char3);
ushort3 __CVAttrs convert_ushort3(uchar3);
ushort3 __CVAttrs convert_ushort3(short3);
ushort3 __CVAttrs convert_ushort3(ushort3);
ushort3 __CVAttrs convert_ushort3(int3);
ushort3 __CVAttrs convert_ushort3(uint3);
ushort3 __CVAttrs convert_ushort3(long3);
ushort3 __CVAttrs convert_ushort3(ulong3);
ushort3 __CVAttrs convert_ushort3(float3);
ushort3 __CVAttrs convert_ushort3(double3);
ushort3 __CVAttrs convert_ushort3_rte(char3);
ushort3 __CVAttrs convert_ushort3_rte(uchar3);
ushort3 __CVAttrs convert_ushort3_rte(short3);
ushort3 __CVAttrs convert_ushort3_rte(ushort3);
ushort3 __CVAttrs convert_ushort3_rte(int3);
ushort3 __CVAttrs convert_ushort3_rte(uint3);
ushort3 __CVAttrs convert_ushort3_rte(long3);
ushort3 __CVAttrs convert_ushort3_rte(ulong3);
ushort3 __CVAttrs convert_ushort3_rte(float3);
ushort3 __CVAttrs convert_ushort3_rte(double3);
ushort3 __CVAttrs convert_ushort3_rtz(char3);
ushort3 __CVAttrs convert_ushort3_rtz(uchar3);
ushort3 __CVAttrs convert_ushort3_rtz(short3);
ushort3 __CVAttrs convert_ushort3_rtz(ushort3);
ushort3 __CVAttrs convert_ushort3_rtz(int3);
ushort3 __CVAttrs convert_ushort3_rtz(uint3);
ushort3 __CVAttrs convert_ushort3_rtz(long3);
ushort3 __CVAttrs convert_ushort3_rtz(ulong3);
ushort3 __CVAttrs convert_ushort3_rtz(float3);
ushort3 __CVAttrs convert_ushort3_rtz(double3);
ushort3 __CVAttrs convert_ushort3_rtp(char3);
ushort3 __CVAttrs convert_ushort3_rtp(uchar3);
ushort3 __CVAttrs convert_ushort3_rtp(short3);
ushort3 __CVAttrs convert_ushort3_rtp(ushort3);
ushort3 __CVAttrs convert_ushort3_rtp(int3);
ushort3 __CVAttrs convert_ushort3_rtp(uint3);
ushort3 __CVAttrs convert_ushort3_rtp(long3);
ushort3 __CVAttrs convert_ushort3_rtp(ulong3);
ushort3 __CVAttrs convert_ushort3_rtp(float3);
ushort3 __CVAttrs convert_ushort3_rtp(double3);
ushort3 __CVAttrs convert_ushort3_rtn(char3);
ushort3 __CVAttrs convert_ushort3_rtn(uchar3);
ushort3 __CVAttrs convert_ushort3_rtn(short3);
ushort3 __CVAttrs convert_ushort3_rtn(ushort3);
ushort3 __CVAttrs convert_ushort3_rtn(int3);
ushort3 __CVAttrs convert_ushort3_rtn(uint3);
ushort3 __CVAttrs convert_ushort3_rtn(long3);
ushort3 __CVAttrs convert_ushort3_rtn(ulong3);
ushort3 __CVAttrs convert_ushort3_rtn(float3);
ushort3 __CVAttrs convert_ushort3_rtn(double3);
ushort3 __CVAttrs convert_ushort3_sat(char3);
ushort3 __CVAttrs convert_ushort3_sat(uchar3);
ushort3 __CVAttrs convert_ushort3_sat(short3);
ushort3 __CVAttrs convert_ushort3_sat(ushort3);
ushort3 __CVAttrs convert_ushort3_sat(int3);
ushort3 __CVAttrs convert_ushort3_sat(uint3);
ushort3 __CVAttrs convert_ushort3_sat(long3);
ushort3 __CVAttrs convert_ushort3_sat(ulong3);
ushort3 __CVAttrs convert_ushort3_sat(float3);
ushort3 __CVAttrs convert_ushort3_sat(double3);
ushort3 __CVAttrs convert_ushort3_sat_rte(char3);
ushort3 __CVAttrs convert_ushort3_sat_rte(uchar3);
ushort3 __CVAttrs convert_ushort3_sat_rte(short3);
ushort3 __CVAttrs convert_ushort3_sat_rte(ushort3);
ushort3 __CVAttrs convert_ushort3_sat_rte(int3);
ushort3 __CVAttrs convert_ushort3_sat_rte(uint3);
ushort3 __CVAttrs convert_ushort3_sat_rte(long3);
ushort3 __CVAttrs convert_ushort3_sat_rte(ulong3);
ushort3 __CVAttrs convert_ushort3_sat_rte(float3);
ushort3 __CVAttrs convert_ushort3_sat_rte(double3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(char3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(uchar3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(short3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(ushort3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(int3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(uint3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(long3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(ulong3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(float3);
ushort3 __CVAttrs convert_ushort3_sat_rtz(double3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(char3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(uchar3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(short3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(ushort3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(int3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(uint3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(long3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(ulong3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(float3);
ushort3 __CVAttrs convert_ushort3_sat_rtp(double3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(char3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(uchar3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(short3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(ushort3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(int3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(uint3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(long3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(ulong3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(float3);
ushort3 __CVAttrs convert_ushort3_sat_rtn(double3);
#endif
ushort4 __CVAttrs convert_ushort4(char4);
ushort4 __CVAttrs convert_ushort4(uchar4);
ushort4 __CVAttrs convert_ushort4(short4);
ushort4 __CVAttrs convert_ushort4(ushort4);
ushort4 __CVAttrs convert_ushort4(int4);
ushort4 __CVAttrs convert_ushort4(uint4);
ushort4 __CVAttrs convert_ushort4(long4);
ushort4 __CVAttrs convert_ushort4(ulong4);
ushort4 __CVAttrs convert_ushort4(float4);
ushort4 __CVAttrs convert_ushort4(double4);
ushort4 __CVAttrs convert_ushort4_rte(char4);
ushort4 __CVAttrs convert_ushort4_rte(uchar4);
ushort4 __CVAttrs convert_ushort4_rte(short4);
ushort4 __CVAttrs convert_ushort4_rte(ushort4);
ushort4 __CVAttrs convert_ushort4_rte(int4);
ushort4 __CVAttrs convert_ushort4_rte(uint4);
ushort4 __CVAttrs convert_ushort4_rte(long4);
ushort4 __CVAttrs convert_ushort4_rte(ulong4);
ushort4 __CVAttrs convert_ushort4_rte(float4);
ushort4 __CVAttrs convert_ushort4_rte(double4);
ushort4 __CVAttrs convert_ushort4_rtz(char4);
ushort4 __CVAttrs convert_ushort4_rtz(uchar4);
ushort4 __CVAttrs convert_ushort4_rtz(short4);
ushort4 __CVAttrs convert_ushort4_rtz(ushort4);
ushort4 __CVAttrs convert_ushort4_rtz(int4);
ushort4 __CVAttrs convert_ushort4_rtz(uint4);
ushort4 __CVAttrs convert_ushort4_rtz(long4);
ushort4 __CVAttrs convert_ushort4_rtz(ulong4);
ushort4 __CVAttrs convert_ushort4_rtz(float4);
ushort4 __CVAttrs convert_ushort4_rtz(double4);
ushort4 __CVAttrs convert_ushort4_rtp(char4);
ushort4 __CVAttrs convert_ushort4_rtp(uchar4);
ushort4 __CVAttrs convert_ushort4_rtp(short4);
ushort4 __CVAttrs convert_ushort4_rtp(ushort4);
ushort4 __CVAttrs convert_ushort4_rtp(int4);
ushort4 __CVAttrs convert_ushort4_rtp(uint4);
ushort4 __CVAttrs convert_ushort4_rtp(long4);
ushort4 __CVAttrs convert_ushort4_rtp(ulong4);
ushort4 __CVAttrs convert_ushort4_rtp(float4);
ushort4 __CVAttrs convert_ushort4_rtp(double4);
ushort4 __CVAttrs convert_ushort4_rtn(char4);
ushort4 __CVAttrs convert_ushort4_rtn(uchar4);
ushort4 __CVAttrs convert_ushort4_rtn(short4);
ushort4 __CVAttrs convert_ushort4_rtn(ushort4);
ushort4 __CVAttrs convert_ushort4_rtn(int4);
ushort4 __CVAttrs convert_ushort4_rtn(uint4);
ushort4 __CVAttrs convert_ushort4_rtn(long4);
ushort4 __CVAttrs convert_ushort4_rtn(ulong4);
ushort4 __CVAttrs convert_ushort4_rtn(float4);
ushort4 __CVAttrs convert_ushort4_rtn(double4);
ushort4 __CVAttrs convert_ushort4_sat(char4);
ushort4 __CVAttrs convert_ushort4_sat(uchar4);
ushort4 __CVAttrs convert_ushort4_sat(short4);
ushort4 __CVAttrs convert_ushort4_sat(ushort4);
ushort4 __CVAttrs convert_ushort4_sat(int4);
ushort4 __CVAttrs convert_ushort4_sat(uint4);
ushort4 __CVAttrs convert_ushort4_sat(long4);
ushort4 __CVAttrs convert_ushort4_sat(ulong4);
ushort4 __CVAttrs convert_ushort4_sat(float4);
ushort4 __CVAttrs convert_ushort4_sat(double4);
ushort4 __CVAttrs convert_ushort4_sat_rte(char4);
ushort4 __CVAttrs convert_ushort4_sat_rte(uchar4);
ushort4 __CVAttrs convert_ushort4_sat_rte(short4);
ushort4 __CVAttrs convert_ushort4_sat_rte(ushort4);
ushort4 __CVAttrs convert_ushort4_sat_rte(int4);
ushort4 __CVAttrs convert_ushort4_sat_rte(uint4);
ushort4 __CVAttrs convert_ushort4_sat_rte(long4);
ushort4 __CVAttrs convert_ushort4_sat_rte(ulong4);
ushort4 __CVAttrs convert_ushort4_sat_rte(float4);
ushort4 __CVAttrs convert_ushort4_sat_rte(double4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(char4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(uchar4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(short4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(ushort4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(int4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(uint4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(long4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(ulong4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(float4);
ushort4 __CVAttrs convert_ushort4_sat_rtz(double4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(char4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(uchar4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(short4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(ushort4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(int4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(uint4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(long4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(ulong4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(float4);
ushort4 __CVAttrs convert_ushort4_sat_rtp(double4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(char4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(uchar4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(short4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(ushort4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(int4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(uint4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(long4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(ulong4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(float4);
ushort4 __CVAttrs convert_ushort4_sat_rtn(double4);
ushort8 __CVAttrs convert_ushort8(char8);
ushort8 __CVAttrs convert_ushort8(uchar8);
ushort8 __CVAttrs convert_ushort8(short8);
ushort8 __CVAttrs convert_ushort8(ushort8);
ushort8 __CVAttrs convert_ushort8(int8);
ushort8 __CVAttrs convert_ushort8(uint8);
ushort8 __CVAttrs convert_ushort8(long8);
ushort8 __CVAttrs convert_ushort8(ulong8);
ushort8 __CVAttrs convert_ushort8(float8);
ushort8 __CVAttrs convert_ushort8(double8);
ushort8 __CVAttrs convert_ushort8_rte(char8);
ushort8 __CVAttrs convert_ushort8_rte(uchar8);
ushort8 __CVAttrs convert_ushort8_rte(short8);
ushort8 __CVAttrs convert_ushort8_rte(ushort8);
ushort8 __CVAttrs convert_ushort8_rte(int8);
ushort8 __CVAttrs convert_ushort8_rte(uint8);
ushort8 __CVAttrs convert_ushort8_rte(long8);
ushort8 __CVAttrs convert_ushort8_rte(ulong8);
ushort8 __CVAttrs convert_ushort8_rte(float8);
ushort8 __CVAttrs convert_ushort8_rte(double8);
ushort8 __CVAttrs convert_ushort8_rtz(char8);
ushort8 __CVAttrs convert_ushort8_rtz(uchar8);
ushort8 __CVAttrs convert_ushort8_rtz(short8);
ushort8 __CVAttrs convert_ushort8_rtz(ushort8);
ushort8 __CVAttrs convert_ushort8_rtz(int8);
ushort8 __CVAttrs convert_ushort8_rtz(uint8);
ushort8 __CVAttrs convert_ushort8_rtz(long8);
ushort8 __CVAttrs convert_ushort8_rtz(ulong8);
ushort8 __CVAttrs convert_ushort8_rtz(float8);
ushort8 __CVAttrs convert_ushort8_rtz(double8);
ushort8 __CVAttrs convert_ushort8_rtp(char8);
ushort8 __CVAttrs convert_ushort8_rtp(uchar8);
ushort8 __CVAttrs convert_ushort8_rtp(short8);
ushort8 __CVAttrs convert_ushort8_rtp(ushort8);
ushort8 __CVAttrs convert_ushort8_rtp(int8);
ushort8 __CVAttrs convert_ushort8_rtp(uint8);
ushort8 __CVAttrs convert_ushort8_rtp(long8);
ushort8 __CVAttrs convert_ushort8_rtp(ulong8);
ushort8 __CVAttrs convert_ushort8_rtp(float8);
ushort8 __CVAttrs convert_ushort8_rtp(double8);
ushort8 __CVAttrs convert_ushort8_rtn(char8);
ushort8 __CVAttrs convert_ushort8_rtn(uchar8);
ushort8 __CVAttrs convert_ushort8_rtn(short8);
ushort8 __CVAttrs convert_ushort8_rtn(ushort8);
ushort8 __CVAttrs convert_ushort8_rtn(int8);
ushort8 __CVAttrs convert_ushort8_rtn(uint8);
ushort8 __CVAttrs convert_ushort8_rtn(long8);
ushort8 __CVAttrs convert_ushort8_rtn(ulong8);
ushort8 __CVAttrs convert_ushort8_rtn(float8);
ushort8 __CVAttrs convert_ushort8_rtn(double8);
ushort8 __CVAttrs convert_ushort8_sat(char8);
ushort8 __CVAttrs convert_ushort8_sat(uchar8);
ushort8 __CVAttrs convert_ushort8_sat(short8);
ushort8 __CVAttrs convert_ushort8_sat(ushort8);
ushort8 __CVAttrs convert_ushort8_sat(int8);
ushort8 __CVAttrs convert_ushort8_sat(uint8);
ushort8 __CVAttrs convert_ushort8_sat(long8);
ushort8 __CVAttrs convert_ushort8_sat(ulong8);
ushort8 __CVAttrs convert_ushort8_sat(float8);
ushort8 __CVAttrs convert_ushort8_sat(double8);
ushort8 __CVAttrs convert_ushort8_sat_rte(char8);
ushort8 __CVAttrs convert_ushort8_sat_rte(uchar8);
ushort8 __CVAttrs convert_ushort8_sat_rte(short8);
ushort8 __CVAttrs convert_ushort8_sat_rte(ushort8);
ushort8 __CVAttrs convert_ushort8_sat_rte(int8);
ushort8 __CVAttrs convert_ushort8_sat_rte(uint8);
ushort8 __CVAttrs convert_ushort8_sat_rte(long8);
ushort8 __CVAttrs convert_ushort8_sat_rte(ulong8);
ushort8 __CVAttrs convert_ushort8_sat_rte(float8);
ushort8 __CVAttrs convert_ushort8_sat_rte(double8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(char8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(uchar8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(short8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(ushort8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(int8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(uint8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(long8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(ulong8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(float8);
ushort8 __CVAttrs convert_ushort8_sat_rtz(double8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(char8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(uchar8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(short8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(ushort8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(int8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(uint8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(long8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(ulong8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(float8);
ushort8 __CVAttrs convert_ushort8_sat_rtp(double8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(char8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(uchar8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(short8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(ushort8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(int8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(uint8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(long8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(ulong8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(float8);
ushort8 __CVAttrs convert_ushort8_sat_rtn(double8);
ushort16 __CVAttrs convert_ushort16(char16);
ushort16 __CVAttrs convert_ushort16(uchar16);
ushort16 __CVAttrs convert_ushort16(short16);
ushort16 __CVAttrs convert_ushort16(ushort16);
ushort16 __CVAttrs convert_ushort16(int16);
ushort16 __CVAttrs convert_ushort16(uint16);
ushort16 __CVAttrs convert_ushort16(long16);
ushort16 __CVAttrs convert_ushort16(ulong16);
ushort16 __CVAttrs convert_ushort16(float16);
ushort16 __CVAttrs convert_ushort16(double16);
ushort16 __CVAttrs convert_ushort16_rte(char16);
ushort16 __CVAttrs convert_ushort16_rte(uchar16);
ushort16 __CVAttrs convert_ushort16_rte(short16);
ushort16 __CVAttrs convert_ushort16_rte(ushort16);
ushort16 __CVAttrs convert_ushort16_rte(int16);
ushort16 __CVAttrs convert_ushort16_rte(uint16);
ushort16 __CVAttrs convert_ushort16_rte(long16);
ushort16 __CVAttrs convert_ushort16_rte(ulong16);
ushort16 __CVAttrs convert_ushort16_rte(float16);
ushort16 __CVAttrs convert_ushort16_rte(double16);
ushort16 __CVAttrs convert_ushort16_rtz(char16);
ushort16 __CVAttrs convert_ushort16_rtz(uchar16);
ushort16 __CVAttrs convert_ushort16_rtz(short16);
ushort16 __CVAttrs convert_ushort16_rtz(ushort16);
ushort16 __CVAttrs convert_ushort16_rtz(int16);
ushort16 __CVAttrs convert_ushort16_rtz(uint16);
ushort16 __CVAttrs convert_ushort16_rtz(long16);
ushort16 __CVAttrs convert_ushort16_rtz(ulong16);
ushort16 __CVAttrs convert_ushort16_rtz(float16);
ushort16 __CVAttrs convert_ushort16_rtz(double16);
ushort16 __CVAttrs convert_ushort16_rtp(char16);
ushort16 __CVAttrs convert_ushort16_rtp(uchar16);
ushort16 __CVAttrs convert_ushort16_rtp(short16);
ushort16 __CVAttrs convert_ushort16_rtp(ushort16);
ushort16 __CVAttrs convert_ushort16_rtp(int16);
ushort16 __CVAttrs convert_ushort16_rtp(uint16);
ushort16 __CVAttrs convert_ushort16_rtp(long16);
ushort16 __CVAttrs convert_ushort16_rtp(ulong16);
ushort16 __CVAttrs convert_ushort16_rtp(float16);
ushort16 __CVAttrs convert_ushort16_rtp(double16);
ushort16 __CVAttrs convert_ushort16_rtn(char16);
ushort16 __CVAttrs convert_ushort16_rtn(uchar16);
ushort16 __CVAttrs convert_ushort16_rtn(short16);
ushort16 __CVAttrs convert_ushort16_rtn(ushort16);
ushort16 __CVAttrs convert_ushort16_rtn(int16);
ushort16 __CVAttrs convert_ushort16_rtn(uint16);
ushort16 __CVAttrs convert_ushort16_rtn(long16);
ushort16 __CVAttrs convert_ushort16_rtn(ulong16);
ushort16 __CVAttrs convert_ushort16_rtn(float16);
ushort16 __CVAttrs convert_ushort16_rtn(double16);
ushort16 __CVAttrs convert_ushort16_sat(char16);
ushort16 __CVAttrs convert_ushort16_sat(uchar16);
ushort16 __CVAttrs convert_ushort16_sat(short16);
ushort16 __CVAttrs convert_ushort16_sat(ushort16);
ushort16 __CVAttrs convert_ushort16_sat(int16);
ushort16 __CVAttrs convert_ushort16_sat(uint16);
ushort16 __CVAttrs convert_ushort16_sat(long16);
ushort16 __CVAttrs convert_ushort16_sat(ulong16);
ushort16 __CVAttrs convert_ushort16_sat(float16);
ushort16 __CVAttrs convert_ushort16_sat(double16);
ushort16 __CVAttrs convert_ushort16_sat_rte(char16);
ushort16 __CVAttrs convert_ushort16_sat_rte(uchar16);
ushort16 __CVAttrs convert_ushort16_sat_rte(short16);
ushort16 __CVAttrs convert_ushort16_sat_rte(ushort16);
ushort16 __CVAttrs convert_ushort16_sat_rte(int16);
ushort16 __CVAttrs convert_ushort16_sat_rte(uint16);
ushort16 __CVAttrs convert_ushort16_sat_rte(long16);
ushort16 __CVAttrs convert_ushort16_sat_rte(ulong16);
ushort16 __CVAttrs convert_ushort16_sat_rte(float16);
ushort16 __CVAttrs convert_ushort16_sat_rte(double16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(char16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(uchar16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(short16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(ushort16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(int16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(uint16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(long16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(ulong16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(float16);
ushort16 __CVAttrs convert_ushort16_sat_rtz(double16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(char16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(uchar16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(short16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(ushort16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(int16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(uint16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(long16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(ulong16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(float16);
ushort16 __CVAttrs convert_ushort16_sat_rtp(double16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(char16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(uchar16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(short16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(ushort16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(int16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(uint16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(long16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(ulong16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(float16);
ushort16 __CVAttrs convert_ushort16_sat_rtn(double16);
int __CVAttrs convert_int(char);
int __CVAttrs convert_int(uchar);
int __CVAttrs convert_int(short);
int __CVAttrs convert_int(ushort);
int __CVAttrs convert_int(int);
int __CVAttrs convert_int(uint);
int __CVAttrs convert_int(long);
int __CVAttrs convert_int(ulong);
int __CVAttrs convert_int(float);
int __CVAttrs convert_int(double);
int __CVAttrs convert_int_rte(char);
int __CVAttrs convert_int_rte(uchar);
int __CVAttrs convert_int_rte(short);
int __CVAttrs convert_int_rte(ushort);
int __CVAttrs convert_int_rte(int);
int __CVAttrs convert_int_rte(uint);
int __CVAttrs convert_int_rte(long);
int __CVAttrs convert_int_rte(ulong);
int __CVAttrs convert_int_rte(float);
int __CVAttrs convert_int_rte(double);
int __CVAttrs convert_int_rtz(char);
int __CVAttrs convert_int_rtz(uchar);
int __CVAttrs convert_int_rtz(short);
int __CVAttrs convert_int_rtz(ushort);
int __CVAttrs convert_int_rtz(int);
int __CVAttrs convert_int_rtz(uint);
int __CVAttrs convert_int_rtz(long);
int __CVAttrs convert_int_rtz(ulong);
int __CVAttrs convert_int_rtz(float);
int __CVAttrs convert_int_rtz(double);
int __CVAttrs convert_int_rtp(char);
int __CVAttrs convert_int_rtp(uchar);
int __CVAttrs convert_int_rtp(short);
int __CVAttrs convert_int_rtp(ushort);
int __CVAttrs convert_int_rtp(int);
int __CVAttrs convert_int_rtp(uint);
int __CVAttrs convert_int_rtp(long);
int __CVAttrs convert_int_rtp(ulong);
int __CVAttrs convert_int_rtp(float);
int __CVAttrs convert_int_rtp(double);
int __CVAttrs convert_int_rtn(char);
int __CVAttrs convert_int_rtn(uchar);
int __CVAttrs convert_int_rtn(short);
int __CVAttrs convert_int_rtn(ushort);
int __CVAttrs convert_int_rtn(int);
int __CVAttrs convert_int_rtn(uint);
int __CVAttrs convert_int_rtn(long);
int __CVAttrs convert_int_rtn(ulong);
int __CVAttrs convert_int_rtn(float);
int __CVAttrs convert_int_rtn(double);
int __CVAttrs convert_int_sat(char);
int __CVAttrs convert_int_sat(uchar);
int __CVAttrs convert_int_sat(short);
int __CVAttrs convert_int_sat(ushort);
int __CVAttrs convert_int_sat(int);
int __CVAttrs convert_int_sat(uint);
int __CVAttrs convert_int_sat(long);
int __CVAttrs convert_int_sat(ulong);
int __CVAttrs convert_int_sat(float);
int __CVAttrs convert_int_sat(double);
int __CVAttrs convert_int_sat_rte(char);
int __CVAttrs convert_int_sat_rte(uchar);
int __CVAttrs convert_int_sat_rte(short);
int __CVAttrs convert_int_sat_rte(ushort);
int __CVAttrs convert_int_sat_rte(int);
int __CVAttrs convert_int_sat_rte(uint);
int __CVAttrs convert_int_sat_rte(long);
int __CVAttrs convert_int_sat_rte(ulong);
int __CVAttrs convert_int_sat_rte(float);
int __CVAttrs convert_int_sat_rte(double);
int __CVAttrs convert_int_sat_rtz(char);
int __CVAttrs convert_int_sat_rtz(uchar);
int __CVAttrs convert_int_sat_rtz(short);
int __CVAttrs convert_int_sat_rtz(ushort);
int __CVAttrs convert_int_sat_rtz(int);
int __CVAttrs convert_int_sat_rtz(uint);
int __CVAttrs convert_int_sat_rtz(long);
int __CVAttrs convert_int_sat_rtz(ulong);
int __CVAttrs convert_int_sat_rtz(float);
int __CVAttrs convert_int_sat_rtz(double);
int __CVAttrs convert_int_sat_rtp(char);
int __CVAttrs convert_int_sat_rtp(uchar);
int __CVAttrs convert_int_sat_rtp(short);
int __CVAttrs convert_int_sat_rtp(ushort);
int __CVAttrs convert_int_sat_rtp(int);
int __CVAttrs convert_int_sat_rtp(uint);
int __CVAttrs convert_int_sat_rtp(long);
int __CVAttrs convert_int_sat_rtp(ulong);
int __CVAttrs convert_int_sat_rtp(float);
int __CVAttrs convert_int_sat_rtp(double);
int __CVAttrs convert_int_sat_rtn(char);
int __CVAttrs convert_int_sat_rtn(uchar);
int __CVAttrs convert_int_sat_rtn(short);
int __CVAttrs convert_int_sat_rtn(ushort);
int __CVAttrs convert_int_sat_rtn(int);
int __CVAttrs convert_int_sat_rtn(uint);
int __CVAttrs convert_int_sat_rtn(long);
int __CVAttrs convert_int_sat_rtn(ulong);
int __CVAttrs convert_int_sat_rtn(float);
int __CVAttrs convert_int_sat_rtn(double);
int2 __CVAttrs convert_int2(char2);
int2 __CVAttrs convert_int2(uchar2);
int2 __CVAttrs convert_int2(short2);
int2 __CVAttrs convert_int2(ushort2);
int2 __CVAttrs convert_int2(int2);
int2 __CVAttrs convert_int2(uint2);
int2 __CVAttrs convert_int2(long2);
int2 __CVAttrs convert_int2(ulong2);
int2 __CVAttrs convert_int2(float2);
int2 __CVAttrs convert_int2(double2);
int2 __CVAttrs convert_int2_rte(char2);
int2 __CVAttrs convert_int2_rte(uchar2);
int2 __CVAttrs convert_int2_rte(short2);
int2 __CVAttrs convert_int2_rte(ushort2);
int2 __CVAttrs convert_int2_rte(int2);
int2 __CVAttrs convert_int2_rte(uint2);
int2 __CVAttrs convert_int2_rte(long2);
int2 __CVAttrs convert_int2_rte(ulong2);
int2 __CVAttrs convert_int2_rte(float2);
int2 __CVAttrs convert_int2_rte(double2);
int2 __CVAttrs convert_int2_rtz(char2);
int2 __CVAttrs convert_int2_rtz(uchar2);
int2 __CVAttrs convert_int2_rtz(short2);
int2 __CVAttrs convert_int2_rtz(ushort2);
int2 __CVAttrs convert_int2_rtz(int2);
int2 __CVAttrs convert_int2_rtz(uint2);
int2 __CVAttrs convert_int2_rtz(long2);
int2 __CVAttrs convert_int2_rtz(ulong2);
int2 __CVAttrs convert_int2_rtz(float2);
int2 __CVAttrs convert_int2_rtz(double2);
int2 __CVAttrs convert_int2_rtp(char2);
int2 __CVAttrs convert_int2_rtp(uchar2);
int2 __CVAttrs convert_int2_rtp(short2);
int2 __CVAttrs convert_int2_rtp(ushort2);
int2 __CVAttrs convert_int2_rtp(int2);
int2 __CVAttrs convert_int2_rtp(uint2);
int2 __CVAttrs convert_int2_rtp(long2);
int2 __CVAttrs convert_int2_rtp(ulong2);
int2 __CVAttrs convert_int2_rtp(float2);
int2 __CVAttrs convert_int2_rtp(double2);
int2 __CVAttrs convert_int2_rtn(char2);
int2 __CVAttrs convert_int2_rtn(uchar2);
int2 __CVAttrs convert_int2_rtn(short2);
int2 __CVAttrs convert_int2_rtn(ushort2);
int2 __CVAttrs convert_int2_rtn(int2);
int2 __CVAttrs convert_int2_rtn(uint2);
int2 __CVAttrs convert_int2_rtn(long2);
int2 __CVAttrs convert_int2_rtn(ulong2);
int2 __CVAttrs convert_int2_rtn(float2);
int2 __CVAttrs convert_int2_rtn(double2);
int2 __CVAttrs convert_int2_sat(char2);
int2 __CVAttrs convert_int2_sat(uchar2);
int2 __CVAttrs convert_int2_sat(short2);
int2 __CVAttrs convert_int2_sat(ushort2);
int2 __CVAttrs convert_int2_sat(int2);
int2 __CVAttrs convert_int2_sat(uint2);
int2 __CVAttrs convert_int2_sat(long2);
int2 __CVAttrs convert_int2_sat(ulong2);
int2 __CVAttrs convert_int2_sat(float2);
int2 __CVAttrs convert_int2_sat(double2);
int2 __CVAttrs convert_int2_sat_rte(char2);
int2 __CVAttrs convert_int2_sat_rte(uchar2);
int2 __CVAttrs convert_int2_sat_rte(short2);
int2 __CVAttrs convert_int2_sat_rte(ushort2);
int2 __CVAttrs convert_int2_sat_rte(int2);
int2 __CVAttrs convert_int2_sat_rte(uint2);
int2 __CVAttrs convert_int2_sat_rte(long2);
int2 __CVAttrs convert_int2_sat_rte(ulong2);
int2 __CVAttrs convert_int2_sat_rte(float2);
int2 __CVAttrs convert_int2_sat_rte(double2);
int2 __CVAttrs convert_int2_sat_rtz(char2);
int2 __CVAttrs convert_int2_sat_rtz(uchar2);
int2 __CVAttrs convert_int2_sat_rtz(short2);
int2 __CVAttrs convert_int2_sat_rtz(ushort2);
int2 __CVAttrs convert_int2_sat_rtz(int2);
int2 __CVAttrs convert_int2_sat_rtz(uint2);
int2 __CVAttrs convert_int2_sat_rtz(long2);
int2 __CVAttrs convert_int2_sat_rtz(ulong2);
int2 __CVAttrs convert_int2_sat_rtz(float2);
int2 __CVAttrs convert_int2_sat_rtz(double2);
int2 __CVAttrs convert_int2_sat_rtp(char2);
int2 __CVAttrs convert_int2_sat_rtp(uchar2);
int2 __CVAttrs convert_int2_sat_rtp(short2);
int2 __CVAttrs convert_int2_sat_rtp(ushort2);
int2 __CVAttrs convert_int2_sat_rtp(int2);
int2 __CVAttrs convert_int2_sat_rtp(uint2);
int2 __CVAttrs convert_int2_sat_rtp(long2);
int2 __CVAttrs convert_int2_sat_rtp(ulong2);
int2 __CVAttrs convert_int2_sat_rtp(float2);
int2 __CVAttrs convert_int2_sat_rtp(double2);
int2 __CVAttrs convert_int2_sat_rtn(char2);
int2 __CVAttrs convert_int2_sat_rtn(uchar2);
int2 __CVAttrs convert_int2_sat_rtn(short2);
int2 __CVAttrs convert_int2_sat_rtn(ushort2);
int2 __CVAttrs convert_int2_sat_rtn(int2);
int2 __CVAttrs convert_int2_sat_rtn(uint2);
int2 __CVAttrs convert_int2_sat_rtn(long2);
int2 __CVAttrs convert_int2_sat_rtn(ulong2);
int2 __CVAttrs convert_int2_sat_rtn(float2);
int2 __CVAttrs convert_int2_sat_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
int3 __CVAttrs convert_int3(char3);
int3 __CVAttrs convert_int3(uchar3);
int3 __CVAttrs convert_int3(short3);
int3 __CVAttrs convert_int3(ushort3);
int3 __CVAttrs convert_int3(int3);
int3 __CVAttrs convert_int3(uint3);
int3 __CVAttrs convert_int3(long3);
int3 __CVAttrs convert_int3(ulong3);
int3 __CVAttrs convert_int3(float3);
int3 __CVAttrs convert_int3(double3);
int3 __CVAttrs convert_int3_rte(char3);
int3 __CVAttrs convert_int3_rte(uchar3);
int3 __CVAttrs convert_int3_rte(short3);
int3 __CVAttrs convert_int3_rte(ushort3);
int3 __CVAttrs convert_int3_rte(int3);
int3 __CVAttrs convert_int3_rte(uint3);
int3 __CVAttrs convert_int3_rte(long3);
int3 __CVAttrs convert_int3_rte(ulong3);
int3 __CVAttrs convert_int3_rte(float3);
int3 __CVAttrs convert_int3_rte(double3);
int3 __CVAttrs convert_int3_rtz(char3);
int3 __CVAttrs convert_int3_rtz(uchar3);
int3 __CVAttrs convert_int3_rtz(short3);
int3 __CVAttrs convert_int3_rtz(ushort3);
int3 __CVAttrs convert_int3_rtz(int3);
int3 __CVAttrs convert_int3_rtz(uint3);
int3 __CVAttrs convert_int3_rtz(long3);
int3 __CVAttrs convert_int3_rtz(ulong3);
int3 __CVAttrs convert_int3_rtz(float3);
int3 __CVAttrs convert_int3_rtz(double3);
int3 __CVAttrs convert_int3_rtp(char3);
int3 __CVAttrs convert_int3_rtp(uchar3);
int3 __CVAttrs convert_int3_rtp(short3);
int3 __CVAttrs convert_int3_rtp(ushort3);
int3 __CVAttrs convert_int3_rtp(int3);
int3 __CVAttrs convert_int3_rtp(uint3);
int3 __CVAttrs convert_int3_rtp(long3);
int3 __CVAttrs convert_int3_rtp(ulong3);
int3 __CVAttrs convert_int3_rtp(float3);
int3 __CVAttrs convert_int3_rtp(double3);
int3 __CVAttrs convert_int3_rtn(char3);
int3 __CVAttrs convert_int3_rtn(uchar3);
int3 __CVAttrs convert_int3_rtn(short3);
int3 __CVAttrs convert_int3_rtn(ushort3);
int3 __CVAttrs convert_int3_rtn(int3);
int3 __CVAttrs convert_int3_rtn(uint3);
int3 __CVAttrs convert_int3_rtn(long3);
int3 __CVAttrs convert_int3_rtn(ulong3);
int3 __CVAttrs convert_int3_rtn(float3);
int3 __CVAttrs convert_int3_rtn(double3);
int3 __CVAttrs convert_int3_sat(char3);
int3 __CVAttrs convert_int3_sat(uchar3);
int3 __CVAttrs convert_int3_sat(short3);
int3 __CVAttrs convert_int3_sat(ushort3);
int3 __CVAttrs convert_int3_sat(int3);
int3 __CVAttrs convert_int3_sat(uint3);
int3 __CVAttrs convert_int3_sat(long3);
int3 __CVAttrs convert_int3_sat(ulong3);
int3 __CVAttrs convert_int3_sat(float3);
int3 __CVAttrs convert_int3_sat(double3);
int3 __CVAttrs convert_int3_sat_rte(char3);
int3 __CVAttrs convert_int3_sat_rte(uchar3);
int3 __CVAttrs convert_int3_sat_rte(short3);
int3 __CVAttrs convert_int3_sat_rte(ushort3);
int3 __CVAttrs convert_int3_sat_rte(int3);
int3 __CVAttrs convert_int3_sat_rte(uint3);
int3 __CVAttrs convert_int3_sat_rte(long3);
int3 __CVAttrs convert_int3_sat_rte(ulong3);
int3 __CVAttrs convert_int3_sat_rte(float3);
int3 __CVAttrs convert_int3_sat_rte(double3);
int3 __CVAttrs convert_int3_sat_rtz(char3);
int3 __CVAttrs convert_int3_sat_rtz(uchar3);
int3 __CVAttrs convert_int3_sat_rtz(short3);
int3 __CVAttrs convert_int3_sat_rtz(ushort3);
int3 __CVAttrs convert_int3_sat_rtz(int3);
int3 __CVAttrs convert_int3_sat_rtz(uint3);
int3 __CVAttrs convert_int3_sat_rtz(long3);
int3 __CVAttrs convert_int3_sat_rtz(ulong3);
int3 __CVAttrs convert_int3_sat_rtz(float3);
int3 __CVAttrs convert_int3_sat_rtz(double3);
int3 __CVAttrs convert_int3_sat_rtp(char3);
int3 __CVAttrs convert_int3_sat_rtp(uchar3);
int3 __CVAttrs convert_int3_sat_rtp(short3);
int3 __CVAttrs convert_int3_sat_rtp(ushort3);
int3 __CVAttrs convert_int3_sat_rtp(int3);
int3 __CVAttrs convert_int3_sat_rtp(uint3);
int3 __CVAttrs convert_int3_sat_rtp(long3);
int3 __CVAttrs convert_int3_sat_rtp(ulong3);
int3 __CVAttrs convert_int3_sat_rtp(float3);
int3 __CVAttrs convert_int3_sat_rtp(double3);
int3 __CVAttrs convert_int3_sat_rtn(char3);
int3 __CVAttrs convert_int3_sat_rtn(uchar3);
int3 __CVAttrs convert_int3_sat_rtn(short3);
int3 __CVAttrs convert_int3_sat_rtn(ushort3);
int3 __CVAttrs convert_int3_sat_rtn(int3);
int3 __CVAttrs convert_int3_sat_rtn(uint3);
int3 __CVAttrs convert_int3_sat_rtn(long3);
int3 __CVAttrs convert_int3_sat_rtn(ulong3);
int3 __CVAttrs convert_int3_sat_rtn(float3);
int3 __CVAttrs convert_int3_sat_rtn(double3);
#endif
int4 __CVAttrs convert_int4(char4);
int4 __CVAttrs convert_int4(uchar4);
int4 __CVAttrs convert_int4(short4);
int4 __CVAttrs convert_int4(ushort4);
int4 __CVAttrs convert_int4(int4);
int4 __CVAttrs convert_int4(uint4);
int4 __CVAttrs convert_int4(long4);
int4 __CVAttrs convert_int4(ulong4);
int4 __CVAttrs convert_int4(float4);
int4 __CVAttrs convert_int4(double4);
int4 __CVAttrs convert_int4_rte(char4);
int4 __CVAttrs convert_int4_rte(uchar4);
int4 __CVAttrs convert_int4_rte(short4);
int4 __CVAttrs convert_int4_rte(ushort4);
int4 __CVAttrs convert_int4_rte(int4);
int4 __CVAttrs convert_int4_rte(uint4);
int4 __CVAttrs convert_int4_rte(long4);
int4 __CVAttrs convert_int4_rte(ulong4);
int4 __CVAttrs convert_int4_rte(float4);
int4 __CVAttrs convert_int4_rte(double4);
int4 __CVAttrs convert_int4_rtz(char4);
int4 __CVAttrs convert_int4_rtz(uchar4);
int4 __CVAttrs convert_int4_rtz(short4);
int4 __CVAttrs convert_int4_rtz(ushort4);
int4 __CVAttrs convert_int4_rtz(int4);
int4 __CVAttrs convert_int4_rtz(uint4);
int4 __CVAttrs convert_int4_rtz(long4);
int4 __CVAttrs convert_int4_rtz(ulong4);
int4 __CVAttrs convert_int4_rtz(float4);
int4 __CVAttrs convert_int4_rtz(double4);
int4 __CVAttrs convert_int4_rtp(char4);
int4 __CVAttrs convert_int4_rtp(uchar4);
int4 __CVAttrs convert_int4_rtp(short4);
int4 __CVAttrs convert_int4_rtp(ushort4);
int4 __CVAttrs convert_int4_rtp(int4);
int4 __CVAttrs convert_int4_rtp(uint4);
int4 __CVAttrs convert_int4_rtp(long4);
int4 __CVAttrs convert_int4_rtp(ulong4);
int4 __CVAttrs convert_int4_rtp(float4);
int4 __CVAttrs convert_int4_rtp(double4);
int4 __CVAttrs convert_int4_rtn(char4);
int4 __CVAttrs convert_int4_rtn(uchar4);
int4 __CVAttrs convert_int4_rtn(short4);
int4 __CVAttrs convert_int4_rtn(ushort4);
int4 __CVAttrs convert_int4_rtn(int4);
int4 __CVAttrs convert_int4_rtn(uint4);
int4 __CVAttrs convert_int4_rtn(long4);
int4 __CVAttrs convert_int4_rtn(ulong4);
int4 __CVAttrs convert_int4_rtn(float4);
int4 __CVAttrs convert_int4_rtn(double4);
int4 __CVAttrs convert_int4_sat(char4);
int4 __CVAttrs convert_int4_sat(uchar4);
int4 __CVAttrs convert_int4_sat(short4);
int4 __CVAttrs convert_int4_sat(ushort4);
int4 __CVAttrs convert_int4_sat(int4);
int4 __CVAttrs convert_int4_sat(uint4);
int4 __CVAttrs convert_int4_sat(long4);
int4 __CVAttrs convert_int4_sat(ulong4);
int4 __CVAttrs convert_int4_sat(float4);
int4 __CVAttrs convert_int4_sat(double4);
int4 __CVAttrs convert_int4_sat_rte(char4);
int4 __CVAttrs convert_int4_sat_rte(uchar4);
int4 __CVAttrs convert_int4_sat_rte(short4);
int4 __CVAttrs convert_int4_sat_rte(ushort4);
int4 __CVAttrs convert_int4_sat_rte(int4);
int4 __CVAttrs convert_int4_sat_rte(uint4);
int4 __CVAttrs convert_int4_sat_rte(long4);
int4 __CVAttrs convert_int4_sat_rte(ulong4);
int4 __CVAttrs convert_int4_sat_rte(float4);
int4 __CVAttrs convert_int4_sat_rte(double4);
int4 __CVAttrs convert_int4_sat_rtz(char4);
int4 __CVAttrs convert_int4_sat_rtz(uchar4);
int4 __CVAttrs convert_int4_sat_rtz(short4);
int4 __CVAttrs convert_int4_sat_rtz(ushort4);
int4 __CVAttrs convert_int4_sat_rtz(int4);
int4 __CVAttrs convert_int4_sat_rtz(uint4);
int4 __CVAttrs convert_int4_sat_rtz(long4);
int4 __CVAttrs convert_int4_sat_rtz(ulong4);
int4 __CVAttrs convert_int4_sat_rtz(float4);
int4 __CVAttrs convert_int4_sat_rtz(double4);
int4 __CVAttrs convert_int4_sat_rtp(char4);
int4 __CVAttrs convert_int4_sat_rtp(uchar4);
int4 __CVAttrs convert_int4_sat_rtp(short4);
int4 __CVAttrs convert_int4_sat_rtp(ushort4);
int4 __CVAttrs convert_int4_sat_rtp(int4);
int4 __CVAttrs convert_int4_sat_rtp(uint4);
int4 __CVAttrs convert_int4_sat_rtp(long4);
int4 __CVAttrs convert_int4_sat_rtp(ulong4);
int4 __CVAttrs convert_int4_sat_rtp(float4);
int4 __CVAttrs convert_int4_sat_rtp(double4);
int4 __CVAttrs convert_int4_sat_rtn(char4);
int4 __CVAttrs convert_int4_sat_rtn(uchar4);
int4 __CVAttrs convert_int4_sat_rtn(short4);
int4 __CVAttrs convert_int4_sat_rtn(ushort4);
int4 __CVAttrs convert_int4_sat_rtn(int4);
int4 __CVAttrs convert_int4_sat_rtn(uint4);
int4 __CVAttrs convert_int4_sat_rtn(long4);
int4 __CVAttrs convert_int4_sat_rtn(ulong4);
int4 __CVAttrs convert_int4_sat_rtn(float4);
int4 __CVAttrs convert_int4_sat_rtn(double4);
int8 __CVAttrs convert_int8(char8);
int8 __CVAttrs convert_int8(uchar8);
int8 __CVAttrs convert_int8(short8);
int8 __CVAttrs convert_int8(ushort8);
int8 __CVAttrs convert_int8(int8);
int8 __CVAttrs convert_int8(uint8);
int8 __CVAttrs convert_int8(long8);
int8 __CVAttrs convert_int8(ulong8);
int8 __CVAttrs convert_int8(float8);
int8 __CVAttrs convert_int8(double8);
int8 __CVAttrs convert_int8_rte(char8);
int8 __CVAttrs convert_int8_rte(uchar8);
int8 __CVAttrs convert_int8_rte(short8);
int8 __CVAttrs convert_int8_rte(ushort8);
int8 __CVAttrs convert_int8_rte(int8);
int8 __CVAttrs convert_int8_rte(uint8);
int8 __CVAttrs convert_int8_rte(long8);
int8 __CVAttrs convert_int8_rte(ulong8);
int8 __CVAttrs convert_int8_rte(float8);
int8 __CVAttrs convert_int8_rte(double8);
int8 __CVAttrs convert_int8_rtz(char8);
int8 __CVAttrs convert_int8_rtz(uchar8);
int8 __CVAttrs convert_int8_rtz(short8);
int8 __CVAttrs convert_int8_rtz(ushort8);
int8 __CVAttrs convert_int8_rtz(int8);
int8 __CVAttrs convert_int8_rtz(uint8);
int8 __CVAttrs convert_int8_rtz(long8);
int8 __CVAttrs convert_int8_rtz(ulong8);
int8 __CVAttrs convert_int8_rtz(float8);
int8 __CVAttrs convert_int8_rtz(double8);
int8 __CVAttrs convert_int8_rtp(char8);
int8 __CVAttrs convert_int8_rtp(uchar8);
int8 __CVAttrs convert_int8_rtp(short8);
int8 __CVAttrs convert_int8_rtp(ushort8);
int8 __CVAttrs convert_int8_rtp(int8);
int8 __CVAttrs convert_int8_rtp(uint8);
int8 __CVAttrs convert_int8_rtp(long8);
int8 __CVAttrs convert_int8_rtp(ulong8);
int8 __CVAttrs convert_int8_rtp(float8);
int8 __CVAttrs convert_int8_rtp(double8);
int8 __CVAttrs convert_int8_rtn(char8);
int8 __CVAttrs convert_int8_rtn(uchar8);
int8 __CVAttrs convert_int8_rtn(short8);
int8 __CVAttrs convert_int8_rtn(ushort8);
int8 __CVAttrs convert_int8_rtn(int8);
int8 __CVAttrs convert_int8_rtn(uint8);
int8 __CVAttrs convert_int8_rtn(long8);
int8 __CVAttrs convert_int8_rtn(ulong8);
int8 __CVAttrs convert_int8_rtn(float8);
int8 __CVAttrs convert_int8_rtn(double8);
int8 __CVAttrs convert_int8_sat(char8);
int8 __CVAttrs convert_int8_sat(uchar8);
int8 __CVAttrs convert_int8_sat(short8);
int8 __CVAttrs convert_int8_sat(ushort8);
int8 __CVAttrs convert_int8_sat(int8);
int8 __CVAttrs convert_int8_sat(uint8);
int8 __CVAttrs convert_int8_sat(long8);
int8 __CVAttrs convert_int8_sat(ulong8);
int8 __CVAttrs convert_int8_sat(float8);
int8 __CVAttrs convert_int8_sat(double8);
int8 __CVAttrs convert_int8_sat_rte(char8);
int8 __CVAttrs convert_int8_sat_rte(uchar8);
int8 __CVAttrs convert_int8_sat_rte(short8);
int8 __CVAttrs convert_int8_sat_rte(ushort8);
int8 __CVAttrs convert_int8_sat_rte(int8);
int8 __CVAttrs convert_int8_sat_rte(uint8);
int8 __CVAttrs convert_int8_sat_rte(long8);
int8 __CVAttrs convert_int8_sat_rte(ulong8);
int8 __CVAttrs convert_int8_sat_rte(float8);
int8 __CVAttrs convert_int8_sat_rte(double8);
int8 __CVAttrs convert_int8_sat_rtz(char8);
int8 __CVAttrs convert_int8_sat_rtz(uchar8);
int8 __CVAttrs convert_int8_sat_rtz(short8);
int8 __CVAttrs convert_int8_sat_rtz(ushort8);
int8 __CVAttrs convert_int8_sat_rtz(int8);
int8 __CVAttrs convert_int8_sat_rtz(uint8);
int8 __CVAttrs convert_int8_sat_rtz(long8);
int8 __CVAttrs convert_int8_sat_rtz(ulong8);
int8 __CVAttrs convert_int8_sat_rtz(float8);
int8 __CVAttrs convert_int8_sat_rtz(double8);
int8 __CVAttrs convert_int8_sat_rtp(char8);
int8 __CVAttrs convert_int8_sat_rtp(uchar8);
int8 __CVAttrs convert_int8_sat_rtp(short8);
int8 __CVAttrs convert_int8_sat_rtp(ushort8);
int8 __CVAttrs convert_int8_sat_rtp(int8);
int8 __CVAttrs convert_int8_sat_rtp(uint8);
int8 __CVAttrs convert_int8_sat_rtp(long8);
int8 __CVAttrs convert_int8_sat_rtp(ulong8);
int8 __CVAttrs convert_int8_sat_rtp(float8);
int8 __CVAttrs convert_int8_sat_rtp(double8);
int8 __CVAttrs convert_int8_sat_rtn(char8);
int8 __CVAttrs convert_int8_sat_rtn(uchar8);
int8 __CVAttrs convert_int8_sat_rtn(short8);
int8 __CVAttrs convert_int8_sat_rtn(ushort8);
int8 __CVAttrs convert_int8_sat_rtn(int8);
int8 __CVAttrs convert_int8_sat_rtn(uint8);
int8 __CVAttrs convert_int8_sat_rtn(long8);
int8 __CVAttrs convert_int8_sat_rtn(ulong8);
int8 __CVAttrs convert_int8_sat_rtn(float8);
int8 __CVAttrs convert_int8_sat_rtn(double8);
int16 __CVAttrs convert_int16(char16);
int16 __CVAttrs convert_int16(uchar16);
int16 __CVAttrs convert_int16(short16);
int16 __CVAttrs convert_int16(ushort16);
int16 __CVAttrs convert_int16(int16);
int16 __CVAttrs convert_int16(uint16);
int16 __CVAttrs convert_int16(long16);
int16 __CVAttrs convert_int16(ulong16);
int16 __CVAttrs convert_int16(float16);
int16 __CVAttrs convert_int16(double16);
int16 __CVAttrs convert_int16_rte(char16);
int16 __CVAttrs convert_int16_rte(uchar16);
int16 __CVAttrs convert_int16_rte(short16);
int16 __CVAttrs convert_int16_rte(ushort16);
int16 __CVAttrs convert_int16_rte(int16);
int16 __CVAttrs convert_int16_rte(uint16);
int16 __CVAttrs convert_int16_rte(long16);
int16 __CVAttrs convert_int16_rte(ulong16);
int16 __CVAttrs convert_int16_rte(float16);
int16 __CVAttrs convert_int16_rte(double16);
int16 __CVAttrs convert_int16_rtz(char16);
int16 __CVAttrs convert_int16_rtz(uchar16);
int16 __CVAttrs convert_int16_rtz(short16);
int16 __CVAttrs convert_int16_rtz(ushort16);
int16 __CVAttrs convert_int16_rtz(int16);
int16 __CVAttrs convert_int16_rtz(uint16);
int16 __CVAttrs convert_int16_rtz(long16);
int16 __CVAttrs convert_int16_rtz(ulong16);
int16 __CVAttrs convert_int16_rtz(float16);
int16 __CVAttrs convert_int16_rtz(double16);
int16 __CVAttrs convert_int16_rtp(char16);
int16 __CVAttrs convert_int16_rtp(uchar16);
int16 __CVAttrs convert_int16_rtp(short16);
int16 __CVAttrs convert_int16_rtp(ushort16);
int16 __CVAttrs convert_int16_rtp(int16);
int16 __CVAttrs convert_int16_rtp(uint16);
int16 __CVAttrs convert_int16_rtp(long16);
int16 __CVAttrs convert_int16_rtp(ulong16);
int16 __CVAttrs convert_int16_rtp(float16);
int16 __CVAttrs convert_int16_rtp(double16);
int16 __CVAttrs convert_int16_rtn(char16);
int16 __CVAttrs convert_int16_rtn(uchar16);
int16 __CVAttrs convert_int16_rtn(short16);
int16 __CVAttrs convert_int16_rtn(ushort16);
int16 __CVAttrs convert_int16_rtn(int16);
int16 __CVAttrs convert_int16_rtn(uint16);
int16 __CVAttrs convert_int16_rtn(long16);
int16 __CVAttrs convert_int16_rtn(ulong16);
int16 __CVAttrs convert_int16_rtn(float16);
int16 __CVAttrs convert_int16_rtn(double16);
int16 __CVAttrs convert_int16_sat(char16);
int16 __CVAttrs convert_int16_sat(uchar16);
int16 __CVAttrs convert_int16_sat(short16);
int16 __CVAttrs convert_int16_sat(ushort16);
int16 __CVAttrs convert_int16_sat(int16);
int16 __CVAttrs convert_int16_sat(uint16);
int16 __CVAttrs convert_int16_sat(long16);
int16 __CVAttrs convert_int16_sat(ulong16);
int16 __CVAttrs convert_int16_sat(float16);
int16 __CVAttrs convert_int16_sat(double16);
int16 __CVAttrs convert_int16_sat_rte(char16);
int16 __CVAttrs convert_int16_sat_rte(uchar16);
int16 __CVAttrs convert_int16_sat_rte(short16);
int16 __CVAttrs convert_int16_sat_rte(ushort16);
int16 __CVAttrs convert_int16_sat_rte(int16);
int16 __CVAttrs convert_int16_sat_rte(uint16);
int16 __CVAttrs convert_int16_sat_rte(long16);
int16 __CVAttrs convert_int16_sat_rte(ulong16);
int16 __CVAttrs convert_int16_sat_rte(float16);
int16 __CVAttrs convert_int16_sat_rte(double16);
int16 __CVAttrs convert_int16_sat_rtz(char16);
int16 __CVAttrs convert_int16_sat_rtz(uchar16);
int16 __CVAttrs convert_int16_sat_rtz(short16);
int16 __CVAttrs convert_int16_sat_rtz(ushort16);
int16 __CVAttrs convert_int16_sat_rtz(int16);
int16 __CVAttrs convert_int16_sat_rtz(uint16);
int16 __CVAttrs convert_int16_sat_rtz(long16);
int16 __CVAttrs convert_int16_sat_rtz(ulong16);
int16 __CVAttrs convert_int16_sat_rtz(float16);
int16 __CVAttrs convert_int16_sat_rtz(double16);
int16 __CVAttrs convert_int16_sat_rtp(char16);
int16 __CVAttrs convert_int16_sat_rtp(uchar16);
int16 __CVAttrs convert_int16_sat_rtp(short16);
int16 __CVAttrs convert_int16_sat_rtp(ushort16);
int16 __CVAttrs convert_int16_sat_rtp(int16);
int16 __CVAttrs convert_int16_sat_rtp(uint16);
int16 __CVAttrs convert_int16_sat_rtp(long16);
int16 __CVAttrs convert_int16_sat_rtp(ulong16);
int16 __CVAttrs convert_int16_sat_rtp(float16);
int16 __CVAttrs convert_int16_sat_rtp(double16);
int16 __CVAttrs convert_int16_sat_rtn(char16);
int16 __CVAttrs convert_int16_sat_rtn(uchar16);
int16 __CVAttrs convert_int16_sat_rtn(short16);
int16 __CVAttrs convert_int16_sat_rtn(ushort16);
int16 __CVAttrs convert_int16_sat_rtn(int16);
int16 __CVAttrs convert_int16_sat_rtn(uint16);
int16 __CVAttrs convert_int16_sat_rtn(long16);
int16 __CVAttrs convert_int16_sat_rtn(ulong16);
int16 __CVAttrs convert_int16_sat_rtn(float16);
int16 __CVAttrs convert_int16_sat_rtn(double16);
uint __CVAttrs convert_uint(char);
uint __CVAttrs convert_uint(uchar);
uint __CVAttrs convert_uint(short);
uint __CVAttrs convert_uint(ushort);
uint __CVAttrs convert_uint(int);
uint __CVAttrs convert_uint(uint);
uint __CVAttrs convert_uint(long);
uint __CVAttrs convert_uint(ulong);
uint __CVAttrs convert_uint(float);
uint __CVAttrs convert_uint(double);
uint __CVAttrs convert_uint_rte(char);
uint __CVAttrs convert_uint_rte(uchar);
uint __CVAttrs convert_uint_rte(short);
uint __CVAttrs convert_uint_rte(ushort);
uint __CVAttrs convert_uint_rte(int);
uint __CVAttrs convert_uint_rte(uint);
uint __CVAttrs convert_uint_rte(long);
uint __CVAttrs convert_uint_rte(ulong);
uint __CVAttrs convert_uint_rte(float);
uint __CVAttrs convert_uint_rte(double);
uint __CVAttrs convert_uint_rtz(char);
uint __CVAttrs convert_uint_rtz(uchar);
uint __CVAttrs convert_uint_rtz(short);
uint __CVAttrs convert_uint_rtz(ushort);
uint __CVAttrs convert_uint_rtz(int);
uint __CVAttrs convert_uint_rtz(uint);
uint __CVAttrs convert_uint_rtz(long);
uint __CVAttrs convert_uint_rtz(ulong);
uint __CVAttrs convert_uint_rtz(float);
uint __CVAttrs convert_uint_rtz(double);
uint __CVAttrs convert_uint_rtp(char);
uint __CVAttrs convert_uint_rtp(uchar);
uint __CVAttrs convert_uint_rtp(short);
uint __CVAttrs convert_uint_rtp(ushort);
uint __CVAttrs convert_uint_rtp(int);
uint __CVAttrs convert_uint_rtp(uint);
uint __CVAttrs convert_uint_rtp(long);
uint __CVAttrs convert_uint_rtp(ulong);
uint __CVAttrs convert_uint_rtp(float);
uint __CVAttrs convert_uint_rtp(double);
uint __CVAttrs convert_uint_rtn(char);
uint __CVAttrs convert_uint_rtn(uchar);
uint __CVAttrs convert_uint_rtn(short);
uint __CVAttrs convert_uint_rtn(ushort);
uint __CVAttrs convert_uint_rtn(int);
uint __CVAttrs convert_uint_rtn(uint);
uint __CVAttrs convert_uint_rtn(long);
uint __CVAttrs convert_uint_rtn(ulong);
uint __CVAttrs convert_uint_rtn(float);
uint __CVAttrs convert_uint_rtn(double);
uint __CVAttrs convert_uint_sat(char);
uint __CVAttrs convert_uint_sat(uchar);
uint __CVAttrs convert_uint_sat(short);
uint __CVAttrs convert_uint_sat(ushort);
uint __CVAttrs convert_uint_sat(int);
uint __CVAttrs convert_uint_sat(uint);
uint __CVAttrs convert_uint_sat(long);
uint __CVAttrs convert_uint_sat(ulong);
uint __CVAttrs convert_uint_sat(float);
uint __CVAttrs convert_uint_sat(double);
uint __CVAttrs convert_uint_sat_rte(char);
uint __CVAttrs convert_uint_sat_rte(uchar);
uint __CVAttrs convert_uint_sat_rte(short);
uint __CVAttrs convert_uint_sat_rte(ushort);
uint __CVAttrs convert_uint_sat_rte(int);
uint __CVAttrs convert_uint_sat_rte(uint);
uint __CVAttrs convert_uint_sat_rte(long);
uint __CVAttrs convert_uint_sat_rte(ulong);
uint __CVAttrs convert_uint_sat_rte(float);
uint __CVAttrs convert_uint_sat_rte(double);
uint __CVAttrs convert_uint_sat_rtz(char);
uint __CVAttrs convert_uint_sat_rtz(uchar);
uint __CVAttrs convert_uint_sat_rtz(short);
uint __CVAttrs convert_uint_sat_rtz(ushort);
uint __CVAttrs convert_uint_sat_rtz(int);
uint __CVAttrs convert_uint_sat_rtz(uint);
uint __CVAttrs convert_uint_sat_rtz(long);
uint __CVAttrs convert_uint_sat_rtz(ulong);
uint __CVAttrs convert_uint_sat_rtz(float);
uint __CVAttrs convert_uint_sat_rtz(double);
uint __CVAttrs convert_uint_sat_rtp(char);
uint __CVAttrs convert_uint_sat_rtp(uchar);
uint __CVAttrs convert_uint_sat_rtp(short);
uint __CVAttrs convert_uint_sat_rtp(ushort);
uint __CVAttrs convert_uint_sat_rtp(int);
uint __CVAttrs convert_uint_sat_rtp(uint);
uint __CVAttrs convert_uint_sat_rtp(long);
uint __CVAttrs convert_uint_sat_rtp(ulong);
uint __CVAttrs convert_uint_sat_rtp(float);
uint __CVAttrs convert_uint_sat_rtp(double);
uint __CVAttrs convert_uint_sat_rtn(char);
uint __CVAttrs convert_uint_sat_rtn(uchar);
uint __CVAttrs convert_uint_sat_rtn(short);
uint __CVAttrs convert_uint_sat_rtn(ushort);
uint __CVAttrs convert_uint_sat_rtn(int);
uint __CVAttrs convert_uint_sat_rtn(uint);
uint __CVAttrs convert_uint_sat_rtn(long);
uint __CVAttrs convert_uint_sat_rtn(ulong);
uint __CVAttrs convert_uint_sat_rtn(float);
uint __CVAttrs convert_uint_sat_rtn(double);
uint2 __CVAttrs convert_uint2(char2);
uint2 __CVAttrs convert_uint2(uchar2);
uint2 __CVAttrs convert_uint2(short2);
uint2 __CVAttrs convert_uint2(ushort2);
uint2 __CVAttrs convert_uint2(int2);
uint2 __CVAttrs convert_uint2(uint2);
uint2 __CVAttrs convert_uint2(long2);
uint2 __CVAttrs convert_uint2(ulong2);
uint2 __CVAttrs convert_uint2(float2);
uint2 __CVAttrs convert_uint2(double2);
uint2 __CVAttrs convert_uint2_rte(char2);
uint2 __CVAttrs convert_uint2_rte(uchar2);
uint2 __CVAttrs convert_uint2_rte(short2);
uint2 __CVAttrs convert_uint2_rte(ushort2);
uint2 __CVAttrs convert_uint2_rte(int2);
uint2 __CVAttrs convert_uint2_rte(uint2);
uint2 __CVAttrs convert_uint2_rte(long2);
uint2 __CVAttrs convert_uint2_rte(ulong2);
uint2 __CVAttrs convert_uint2_rte(float2);
uint2 __CVAttrs convert_uint2_rte(double2);
uint2 __CVAttrs convert_uint2_rtz(char2);
uint2 __CVAttrs convert_uint2_rtz(uchar2);
uint2 __CVAttrs convert_uint2_rtz(short2);
uint2 __CVAttrs convert_uint2_rtz(ushort2);
uint2 __CVAttrs convert_uint2_rtz(int2);
uint2 __CVAttrs convert_uint2_rtz(uint2);
uint2 __CVAttrs convert_uint2_rtz(long2);
uint2 __CVAttrs convert_uint2_rtz(ulong2);
uint2 __CVAttrs convert_uint2_rtz(float2);
uint2 __CVAttrs convert_uint2_rtz(double2);
uint2 __CVAttrs convert_uint2_rtp(char2);
uint2 __CVAttrs convert_uint2_rtp(uchar2);
uint2 __CVAttrs convert_uint2_rtp(short2);
uint2 __CVAttrs convert_uint2_rtp(ushort2);
uint2 __CVAttrs convert_uint2_rtp(int2);
uint2 __CVAttrs convert_uint2_rtp(uint2);
uint2 __CVAttrs convert_uint2_rtp(long2);
uint2 __CVAttrs convert_uint2_rtp(ulong2);
uint2 __CVAttrs convert_uint2_rtp(float2);
uint2 __CVAttrs convert_uint2_rtp(double2);
uint2 __CVAttrs convert_uint2_rtn(char2);
uint2 __CVAttrs convert_uint2_rtn(uchar2);
uint2 __CVAttrs convert_uint2_rtn(short2);
uint2 __CVAttrs convert_uint2_rtn(ushort2);
uint2 __CVAttrs convert_uint2_rtn(int2);
uint2 __CVAttrs convert_uint2_rtn(uint2);
uint2 __CVAttrs convert_uint2_rtn(long2);
uint2 __CVAttrs convert_uint2_rtn(ulong2);
uint2 __CVAttrs convert_uint2_rtn(float2);
uint2 __CVAttrs convert_uint2_rtn(double2);
uint2 __CVAttrs convert_uint2_sat(char2);
uint2 __CVAttrs convert_uint2_sat(uchar2);
uint2 __CVAttrs convert_uint2_sat(short2);
uint2 __CVAttrs convert_uint2_sat(ushort2);
uint2 __CVAttrs convert_uint2_sat(int2);
uint2 __CVAttrs convert_uint2_sat(uint2);
uint2 __CVAttrs convert_uint2_sat(long2);
uint2 __CVAttrs convert_uint2_sat(ulong2);
uint2 __CVAttrs convert_uint2_sat(float2);
uint2 __CVAttrs convert_uint2_sat(double2);
uint2 __CVAttrs convert_uint2_sat_rte(char2);
uint2 __CVAttrs convert_uint2_sat_rte(uchar2);
uint2 __CVAttrs convert_uint2_sat_rte(short2);
uint2 __CVAttrs convert_uint2_sat_rte(ushort2);
uint2 __CVAttrs convert_uint2_sat_rte(int2);
uint2 __CVAttrs convert_uint2_sat_rte(uint2);
uint2 __CVAttrs convert_uint2_sat_rte(long2);
uint2 __CVAttrs convert_uint2_sat_rte(ulong2);
uint2 __CVAttrs convert_uint2_sat_rte(float2);
uint2 __CVAttrs convert_uint2_sat_rte(double2);
uint2 __CVAttrs convert_uint2_sat_rtz(char2);
uint2 __CVAttrs convert_uint2_sat_rtz(uchar2);
uint2 __CVAttrs convert_uint2_sat_rtz(short2);
uint2 __CVAttrs convert_uint2_sat_rtz(ushort2);
uint2 __CVAttrs convert_uint2_sat_rtz(int2);
uint2 __CVAttrs convert_uint2_sat_rtz(uint2);
uint2 __CVAttrs convert_uint2_sat_rtz(long2);
uint2 __CVAttrs convert_uint2_sat_rtz(ulong2);
uint2 __CVAttrs convert_uint2_sat_rtz(float2);
uint2 __CVAttrs convert_uint2_sat_rtz(double2);
uint2 __CVAttrs convert_uint2_sat_rtp(char2);
uint2 __CVAttrs convert_uint2_sat_rtp(uchar2);
uint2 __CVAttrs convert_uint2_sat_rtp(short2);
uint2 __CVAttrs convert_uint2_sat_rtp(ushort2);
uint2 __CVAttrs convert_uint2_sat_rtp(int2);
uint2 __CVAttrs convert_uint2_sat_rtp(uint2);
uint2 __CVAttrs convert_uint2_sat_rtp(long2);
uint2 __CVAttrs convert_uint2_sat_rtp(ulong2);
uint2 __CVAttrs convert_uint2_sat_rtp(float2);
uint2 __CVAttrs convert_uint2_sat_rtp(double2);
uint2 __CVAttrs convert_uint2_sat_rtn(char2);
uint2 __CVAttrs convert_uint2_sat_rtn(uchar2);
uint2 __CVAttrs convert_uint2_sat_rtn(short2);
uint2 __CVAttrs convert_uint2_sat_rtn(ushort2);
uint2 __CVAttrs convert_uint2_sat_rtn(int2);
uint2 __CVAttrs convert_uint2_sat_rtn(uint2);
uint2 __CVAttrs convert_uint2_sat_rtn(long2);
uint2 __CVAttrs convert_uint2_sat_rtn(ulong2);
uint2 __CVAttrs convert_uint2_sat_rtn(float2);
uint2 __CVAttrs convert_uint2_sat_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
uint3 __CVAttrs convert_uint3(char3);
uint3 __CVAttrs convert_uint3(uchar3);
uint3 __CVAttrs convert_uint3(short3);
uint3 __CVAttrs convert_uint3(ushort3);
uint3 __CVAttrs convert_uint3(int3);
uint3 __CVAttrs convert_uint3(uint3);
uint3 __CVAttrs convert_uint3(long3);
uint3 __CVAttrs convert_uint3(ulong3);
uint3 __CVAttrs convert_uint3(float3);
uint3 __CVAttrs convert_uint3(double3);
uint3 __CVAttrs convert_uint3_rte(char3);
uint3 __CVAttrs convert_uint3_rte(uchar3);
uint3 __CVAttrs convert_uint3_rte(short3);
uint3 __CVAttrs convert_uint3_rte(ushort3);
uint3 __CVAttrs convert_uint3_rte(int3);
uint3 __CVAttrs convert_uint3_rte(uint3);
uint3 __CVAttrs convert_uint3_rte(long3);
uint3 __CVAttrs convert_uint3_rte(ulong3);
uint3 __CVAttrs convert_uint3_rte(float3);
uint3 __CVAttrs convert_uint3_rte(double3);
uint3 __CVAttrs convert_uint3_rtz(char3);
uint3 __CVAttrs convert_uint3_rtz(uchar3);
uint3 __CVAttrs convert_uint3_rtz(short3);
uint3 __CVAttrs convert_uint3_rtz(ushort3);
uint3 __CVAttrs convert_uint3_rtz(int3);
uint3 __CVAttrs convert_uint3_rtz(uint3);
uint3 __CVAttrs convert_uint3_rtz(long3);
uint3 __CVAttrs convert_uint3_rtz(ulong3);
uint3 __CVAttrs convert_uint3_rtz(float3);
uint3 __CVAttrs convert_uint3_rtz(double3);
uint3 __CVAttrs convert_uint3_rtp(char3);
uint3 __CVAttrs convert_uint3_rtp(uchar3);
uint3 __CVAttrs convert_uint3_rtp(short3);
uint3 __CVAttrs convert_uint3_rtp(ushort3);
uint3 __CVAttrs convert_uint3_rtp(int3);
uint3 __CVAttrs convert_uint3_rtp(uint3);
uint3 __CVAttrs convert_uint3_rtp(long3);
uint3 __CVAttrs convert_uint3_rtp(ulong3);
uint3 __CVAttrs convert_uint3_rtp(float3);
uint3 __CVAttrs convert_uint3_rtp(double3);
uint3 __CVAttrs convert_uint3_rtn(char3);
uint3 __CVAttrs convert_uint3_rtn(uchar3);
uint3 __CVAttrs convert_uint3_rtn(short3);
uint3 __CVAttrs convert_uint3_rtn(ushort3);
uint3 __CVAttrs convert_uint3_rtn(int3);
uint3 __CVAttrs convert_uint3_rtn(uint3);
uint3 __CVAttrs convert_uint3_rtn(long3);
uint3 __CVAttrs convert_uint3_rtn(ulong3);
uint3 __CVAttrs convert_uint3_rtn(float3);
uint3 __CVAttrs convert_uint3_rtn(double3);
uint3 __CVAttrs convert_uint3_sat(char3);
uint3 __CVAttrs convert_uint3_sat(uchar3);
uint3 __CVAttrs convert_uint3_sat(short3);
uint3 __CVAttrs convert_uint3_sat(ushort3);
uint3 __CVAttrs convert_uint3_sat(int3);
uint3 __CVAttrs convert_uint3_sat(uint3);
uint3 __CVAttrs convert_uint3_sat(long3);
uint3 __CVAttrs convert_uint3_sat(ulong3);
uint3 __CVAttrs convert_uint3_sat(float3);
uint3 __CVAttrs convert_uint3_sat(double3);
uint3 __CVAttrs convert_uint3_sat_rte(char3);
uint3 __CVAttrs convert_uint3_sat_rte(uchar3);
uint3 __CVAttrs convert_uint3_sat_rte(short3);
uint3 __CVAttrs convert_uint3_sat_rte(ushort3);
uint3 __CVAttrs convert_uint3_sat_rte(int3);
uint3 __CVAttrs convert_uint3_sat_rte(uint3);
uint3 __CVAttrs convert_uint3_sat_rte(long3);
uint3 __CVAttrs convert_uint3_sat_rte(ulong3);
uint3 __CVAttrs convert_uint3_sat_rte(float3);
uint3 __CVAttrs convert_uint3_sat_rte(double3);
uint3 __CVAttrs convert_uint3_sat_rtz(char3);
uint3 __CVAttrs convert_uint3_sat_rtz(uchar3);
uint3 __CVAttrs convert_uint3_sat_rtz(short3);
uint3 __CVAttrs convert_uint3_sat_rtz(ushort3);
uint3 __CVAttrs convert_uint3_sat_rtz(int3);
uint3 __CVAttrs convert_uint3_sat_rtz(uint3);
uint3 __CVAttrs convert_uint3_sat_rtz(long3);
uint3 __CVAttrs convert_uint3_sat_rtz(ulong3);
uint3 __CVAttrs convert_uint3_sat_rtz(float3);
uint3 __CVAttrs convert_uint3_sat_rtz(double3);
uint3 __CVAttrs convert_uint3_sat_rtp(char3);
uint3 __CVAttrs convert_uint3_sat_rtp(uchar3);
uint3 __CVAttrs convert_uint3_sat_rtp(short3);
uint3 __CVAttrs convert_uint3_sat_rtp(ushort3);
uint3 __CVAttrs convert_uint3_sat_rtp(int3);
uint3 __CVAttrs convert_uint3_sat_rtp(uint3);
uint3 __CVAttrs convert_uint3_sat_rtp(long3);
uint3 __CVAttrs convert_uint3_sat_rtp(ulong3);
uint3 __CVAttrs convert_uint3_sat_rtp(float3);
uint3 __CVAttrs convert_uint3_sat_rtp(double3);
uint3 __CVAttrs convert_uint3_sat_rtn(char3);
uint3 __CVAttrs convert_uint3_sat_rtn(uchar3);
uint3 __CVAttrs convert_uint3_sat_rtn(short3);
uint3 __CVAttrs convert_uint3_sat_rtn(ushort3);
uint3 __CVAttrs convert_uint3_sat_rtn(int3);
uint3 __CVAttrs convert_uint3_sat_rtn(uint3);
uint3 __CVAttrs convert_uint3_sat_rtn(long3);
uint3 __CVAttrs convert_uint3_sat_rtn(ulong3);
uint3 __CVAttrs convert_uint3_sat_rtn(float3);
uint3 __CVAttrs convert_uint3_sat_rtn(double3);
#endif
uint4 __CVAttrs convert_uint4(char4);
uint4 __CVAttrs convert_uint4(uchar4);
uint4 __CVAttrs convert_uint4(short4);
uint4 __CVAttrs convert_uint4(ushort4);
uint4 __CVAttrs convert_uint4(int4);
uint4 __CVAttrs convert_uint4(uint4);
uint4 __CVAttrs convert_uint4(long4);
uint4 __CVAttrs convert_uint4(ulong4);
uint4 __CVAttrs convert_uint4(float4);
uint4 __CVAttrs convert_uint4(double4);
uint4 __CVAttrs convert_uint4_rte(char4);
uint4 __CVAttrs convert_uint4_rte(uchar4);
uint4 __CVAttrs convert_uint4_rte(short4);
uint4 __CVAttrs convert_uint4_rte(ushort4);
uint4 __CVAttrs convert_uint4_rte(int4);
uint4 __CVAttrs convert_uint4_rte(uint4);
uint4 __CVAttrs convert_uint4_rte(long4);
uint4 __CVAttrs convert_uint4_rte(ulong4);
uint4 __CVAttrs convert_uint4_rte(float4);
uint4 __CVAttrs convert_uint4_rte(double4);
uint4 __CVAttrs convert_uint4_rtz(char4);
uint4 __CVAttrs convert_uint4_rtz(uchar4);
uint4 __CVAttrs convert_uint4_rtz(short4);
uint4 __CVAttrs convert_uint4_rtz(ushort4);
uint4 __CVAttrs convert_uint4_rtz(int4);
uint4 __CVAttrs convert_uint4_rtz(uint4);
uint4 __CVAttrs convert_uint4_rtz(long4);
uint4 __CVAttrs convert_uint4_rtz(ulong4);
uint4 __CVAttrs convert_uint4_rtz(float4);
uint4 __CVAttrs convert_uint4_rtz(double4);
uint4 __CVAttrs convert_uint4_rtp(char4);
uint4 __CVAttrs convert_uint4_rtp(uchar4);
uint4 __CVAttrs convert_uint4_rtp(short4);
uint4 __CVAttrs convert_uint4_rtp(ushort4);
uint4 __CVAttrs convert_uint4_rtp(int4);
uint4 __CVAttrs convert_uint4_rtp(uint4);
uint4 __CVAttrs convert_uint4_rtp(long4);
uint4 __CVAttrs convert_uint4_rtp(ulong4);
uint4 __CVAttrs convert_uint4_rtp(float4);
uint4 __CVAttrs convert_uint4_rtp(double4);
uint4 __CVAttrs convert_uint4_rtn(char4);
uint4 __CVAttrs convert_uint4_rtn(uchar4);
uint4 __CVAttrs convert_uint4_rtn(short4);
uint4 __CVAttrs convert_uint4_rtn(ushort4);
uint4 __CVAttrs convert_uint4_rtn(int4);
uint4 __CVAttrs convert_uint4_rtn(uint4);
uint4 __CVAttrs convert_uint4_rtn(long4);
uint4 __CVAttrs convert_uint4_rtn(ulong4);
uint4 __CVAttrs convert_uint4_rtn(float4);
uint4 __CVAttrs convert_uint4_rtn(double4);
uint4 __CVAttrs convert_uint4_sat(char4);
uint4 __CVAttrs convert_uint4_sat(uchar4);
uint4 __CVAttrs convert_uint4_sat(short4);
uint4 __CVAttrs convert_uint4_sat(ushort4);
uint4 __CVAttrs convert_uint4_sat(int4);
uint4 __CVAttrs convert_uint4_sat(uint4);
uint4 __CVAttrs convert_uint4_sat(long4);
uint4 __CVAttrs convert_uint4_sat(ulong4);
uint4 __CVAttrs convert_uint4_sat(float4);
uint4 __CVAttrs convert_uint4_sat(double4);
uint4 __CVAttrs convert_uint4_sat_rte(char4);
uint4 __CVAttrs convert_uint4_sat_rte(uchar4);
uint4 __CVAttrs convert_uint4_sat_rte(short4);
uint4 __CVAttrs convert_uint4_sat_rte(ushort4);
uint4 __CVAttrs convert_uint4_sat_rte(int4);
uint4 __CVAttrs convert_uint4_sat_rte(uint4);
uint4 __CVAttrs convert_uint4_sat_rte(long4);
uint4 __CVAttrs convert_uint4_sat_rte(ulong4);
uint4 __CVAttrs convert_uint4_sat_rte(float4);
uint4 __CVAttrs convert_uint4_sat_rte(double4);
uint4 __CVAttrs convert_uint4_sat_rtz(char4);
uint4 __CVAttrs convert_uint4_sat_rtz(uchar4);
uint4 __CVAttrs convert_uint4_sat_rtz(short4);
uint4 __CVAttrs convert_uint4_sat_rtz(ushort4);
uint4 __CVAttrs convert_uint4_sat_rtz(int4);
uint4 __CVAttrs convert_uint4_sat_rtz(uint4);
uint4 __CVAttrs convert_uint4_sat_rtz(long4);
uint4 __CVAttrs convert_uint4_sat_rtz(ulong4);
uint4 __CVAttrs convert_uint4_sat_rtz(float4);
uint4 __CVAttrs convert_uint4_sat_rtz(double4);
uint4 __CVAttrs convert_uint4_sat_rtp(char4);
uint4 __CVAttrs convert_uint4_sat_rtp(uchar4);
uint4 __CVAttrs convert_uint4_sat_rtp(short4);
uint4 __CVAttrs convert_uint4_sat_rtp(ushort4);
uint4 __CVAttrs convert_uint4_sat_rtp(int4);
uint4 __CVAttrs convert_uint4_sat_rtp(uint4);
uint4 __CVAttrs convert_uint4_sat_rtp(long4);
uint4 __CVAttrs convert_uint4_sat_rtp(ulong4);
uint4 __CVAttrs convert_uint4_sat_rtp(float4);
uint4 __CVAttrs convert_uint4_sat_rtp(double4);
uint4 __CVAttrs convert_uint4_sat_rtn(char4);
uint4 __CVAttrs convert_uint4_sat_rtn(uchar4);
uint4 __CVAttrs convert_uint4_sat_rtn(short4);
uint4 __CVAttrs convert_uint4_sat_rtn(ushort4);
uint4 __CVAttrs convert_uint4_sat_rtn(int4);
uint4 __CVAttrs convert_uint4_sat_rtn(uint4);
uint4 __CVAttrs convert_uint4_sat_rtn(long4);
uint4 __CVAttrs convert_uint4_sat_rtn(ulong4);
uint4 __CVAttrs convert_uint4_sat_rtn(float4);
uint4 __CVAttrs convert_uint4_sat_rtn(double4);
uint8 __CVAttrs convert_uint8(char8);
uint8 __CVAttrs convert_uint8(uchar8);
uint8 __CVAttrs convert_uint8(short8);
uint8 __CVAttrs convert_uint8(ushort8);
uint8 __CVAttrs convert_uint8(int8);
uint8 __CVAttrs convert_uint8(uint8);
uint8 __CVAttrs convert_uint8(long8);
uint8 __CVAttrs convert_uint8(ulong8);
uint8 __CVAttrs convert_uint8(float8);
uint8 __CVAttrs convert_uint8(double8);
uint8 __CVAttrs convert_uint8_rte(char8);
uint8 __CVAttrs convert_uint8_rte(uchar8);
uint8 __CVAttrs convert_uint8_rte(short8);
uint8 __CVAttrs convert_uint8_rte(ushort8);
uint8 __CVAttrs convert_uint8_rte(int8);
uint8 __CVAttrs convert_uint8_rte(uint8);
uint8 __CVAttrs convert_uint8_rte(long8);
uint8 __CVAttrs convert_uint8_rte(ulong8);
uint8 __CVAttrs convert_uint8_rte(float8);
uint8 __CVAttrs convert_uint8_rte(double8);
uint8 __CVAttrs convert_uint8_rtz(char8);
uint8 __CVAttrs convert_uint8_rtz(uchar8);
uint8 __CVAttrs convert_uint8_rtz(short8);
uint8 __CVAttrs convert_uint8_rtz(ushort8);
uint8 __CVAttrs convert_uint8_rtz(int8);
uint8 __CVAttrs convert_uint8_rtz(uint8);
uint8 __CVAttrs convert_uint8_rtz(long8);
uint8 __CVAttrs convert_uint8_rtz(ulong8);
uint8 __CVAttrs convert_uint8_rtz(float8);
uint8 __CVAttrs convert_uint8_rtz(double8);
uint8 __CVAttrs convert_uint8_rtp(char8);
uint8 __CVAttrs convert_uint8_rtp(uchar8);
uint8 __CVAttrs convert_uint8_rtp(short8);
uint8 __CVAttrs convert_uint8_rtp(ushort8);
uint8 __CVAttrs convert_uint8_rtp(int8);
uint8 __CVAttrs convert_uint8_rtp(uint8);
uint8 __CVAttrs convert_uint8_rtp(long8);
uint8 __CVAttrs convert_uint8_rtp(ulong8);
uint8 __CVAttrs convert_uint8_rtp(float8);
uint8 __CVAttrs convert_uint8_rtp(double8);
uint8 __CVAttrs convert_uint8_rtn(char8);
uint8 __CVAttrs convert_uint8_rtn(uchar8);
uint8 __CVAttrs convert_uint8_rtn(short8);
uint8 __CVAttrs convert_uint8_rtn(ushort8);
uint8 __CVAttrs convert_uint8_rtn(int8);
uint8 __CVAttrs convert_uint8_rtn(uint8);
uint8 __CVAttrs convert_uint8_rtn(long8);
uint8 __CVAttrs convert_uint8_rtn(ulong8);
uint8 __CVAttrs convert_uint8_rtn(float8);
uint8 __CVAttrs convert_uint8_rtn(double8);
uint8 __CVAttrs convert_uint8_sat(char8);
uint8 __CVAttrs convert_uint8_sat(uchar8);
uint8 __CVAttrs convert_uint8_sat(short8);
uint8 __CVAttrs convert_uint8_sat(ushort8);
uint8 __CVAttrs convert_uint8_sat(int8);
uint8 __CVAttrs convert_uint8_sat(uint8);
uint8 __CVAttrs convert_uint8_sat(long8);
uint8 __CVAttrs convert_uint8_sat(ulong8);
uint8 __CVAttrs convert_uint8_sat(float8);
uint8 __CVAttrs convert_uint8_sat(double8);
uint8 __CVAttrs convert_uint8_sat_rte(char8);
uint8 __CVAttrs convert_uint8_sat_rte(uchar8);
uint8 __CVAttrs convert_uint8_sat_rte(short8);
uint8 __CVAttrs convert_uint8_sat_rte(ushort8);
uint8 __CVAttrs convert_uint8_sat_rte(int8);
uint8 __CVAttrs convert_uint8_sat_rte(uint8);
uint8 __CVAttrs convert_uint8_sat_rte(long8);
uint8 __CVAttrs convert_uint8_sat_rte(ulong8);
uint8 __CVAttrs convert_uint8_sat_rte(float8);
uint8 __CVAttrs convert_uint8_sat_rte(double8);
uint8 __CVAttrs convert_uint8_sat_rtz(char8);
uint8 __CVAttrs convert_uint8_sat_rtz(uchar8);
uint8 __CVAttrs convert_uint8_sat_rtz(short8);
uint8 __CVAttrs convert_uint8_sat_rtz(ushort8);
uint8 __CVAttrs convert_uint8_sat_rtz(int8);
uint8 __CVAttrs convert_uint8_sat_rtz(uint8);
uint8 __CVAttrs convert_uint8_sat_rtz(long8);
uint8 __CVAttrs convert_uint8_sat_rtz(ulong8);
uint8 __CVAttrs convert_uint8_sat_rtz(float8);
uint8 __CVAttrs convert_uint8_sat_rtz(double8);
uint8 __CVAttrs convert_uint8_sat_rtp(char8);
uint8 __CVAttrs convert_uint8_sat_rtp(uchar8);
uint8 __CVAttrs convert_uint8_sat_rtp(short8);
uint8 __CVAttrs convert_uint8_sat_rtp(ushort8);
uint8 __CVAttrs convert_uint8_sat_rtp(int8);
uint8 __CVAttrs convert_uint8_sat_rtp(uint8);
uint8 __CVAttrs convert_uint8_sat_rtp(long8);
uint8 __CVAttrs convert_uint8_sat_rtp(ulong8);
uint8 __CVAttrs convert_uint8_sat_rtp(float8);
uint8 __CVAttrs convert_uint8_sat_rtp(double8);
uint8 __CVAttrs convert_uint8_sat_rtn(char8);
uint8 __CVAttrs convert_uint8_sat_rtn(uchar8);
uint8 __CVAttrs convert_uint8_sat_rtn(short8);
uint8 __CVAttrs convert_uint8_sat_rtn(ushort8);
uint8 __CVAttrs convert_uint8_sat_rtn(int8);
uint8 __CVAttrs convert_uint8_sat_rtn(uint8);
uint8 __CVAttrs convert_uint8_sat_rtn(long8);
uint8 __CVAttrs convert_uint8_sat_rtn(ulong8);
uint8 __CVAttrs convert_uint8_sat_rtn(float8);
uint8 __CVAttrs convert_uint8_sat_rtn(double8);
uint16 __CVAttrs convert_uint16(char16);
uint16 __CVAttrs convert_uint16(uchar16);
uint16 __CVAttrs convert_uint16(short16);
uint16 __CVAttrs convert_uint16(ushort16);
uint16 __CVAttrs convert_uint16(int16);
uint16 __CVAttrs convert_uint16(uint16);
uint16 __CVAttrs convert_uint16(long16);
uint16 __CVAttrs convert_uint16(ulong16);
uint16 __CVAttrs convert_uint16(float16);
uint16 __CVAttrs convert_uint16(double16);
uint16 __CVAttrs convert_uint16_rte(char16);
uint16 __CVAttrs convert_uint16_rte(uchar16);
uint16 __CVAttrs convert_uint16_rte(short16);
uint16 __CVAttrs convert_uint16_rte(ushort16);
uint16 __CVAttrs convert_uint16_rte(int16);
uint16 __CVAttrs convert_uint16_rte(uint16);
uint16 __CVAttrs convert_uint16_rte(long16);
uint16 __CVAttrs convert_uint16_rte(ulong16);
uint16 __CVAttrs convert_uint16_rte(float16);
uint16 __CVAttrs convert_uint16_rte(double16);
uint16 __CVAttrs convert_uint16_rtz(char16);
uint16 __CVAttrs convert_uint16_rtz(uchar16);
uint16 __CVAttrs convert_uint16_rtz(short16);
uint16 __CVAttrs convert_uint16_rtz(ushort16);
uint16 __CVAttrs convert_uint16_rtz(int16);
uint16 __CVAttrs convert_uint16_rtz(uint16);
uint16 __CVAttrs convert_uint16_rtz(long16);
uint16 __CVAttrs convert_uint16_rtz(ulong16);
uint16 __CVAttrs convert_uint16_rtz(float16);
uint16 __CVAttrs convert_uint16_rtz(double16);
uint16 __CVAttrs convert_uint16_rtp(char16);
uint16 __CVAttrs convert_uint16_rtp(uchar16);
uint16 __CVAttrs convert_uint16_rtp(short16);
uint16 __CVAttrs convert_uint16_rtp(ushort16);
uint16 __CVAttrs convert_uint16_rtp(int16);
uint16 __CVAttrs convert_uint16_rtp(uint16);
uint16 __CVAttrs convert_uint16_rtp(long16);
uint16 __CVAttrs convert_uint16_rtp(ulong16);
uint16 __CVAttrs convert_uint16_rtp(float16);
uint16 __CVAttrs convert_uint16_rtp(double16);
uint16 __CVAttrs convert_uint16_rtn(char16);
uint16 __CVAttrs convert_uint16_rtn(uchar16);
uint16 __CVAttrs convert_uint16_rtn(short16);
uint16 __CVAttrs convert_uint16_rtn(ushort16);
uint16 __CVAttrs convert_uint16_rtn(int16);
uint16 __CVAttrs convert_uint16_rtn(uint16);
uint16 __CVAttrs convert_uint16_rtn(long16);
uint16 __CVAttrs convert_uint16_rtn(ulong16);
uint16 __CVAttrs convert_uint16_rtn(float16);
uint16 __CVAttrs convert_uint16_rtn(double16);
uint16 __CVAttrs convert_uint16_sat(char16);
uint16 __CVAttrs convert_uint16_sat(uchar16);
uint16 __CVAttrs convert_uint16_sat(short16);
uint16 __CVAttrs convert_uint16_sat(ushort16);
uint16 __CVAttrs convert_uint16_sat(int16);
uint16 __CVAttrs convert_uint16_sat(uint16);
uint16 __CVAttrs convert_uint16_sat(long16);
uint16 __CVAttrs convert_uint16_sat(ulong16);
uint16 __CVAttrs convert_uint16_sat(float16);
uint16 __CVAttrs convert_uint16_sat(double16);
uint16 __CVAttrs convert_uint16_sat_rte(char16);
uint16 __CVAttrs convert_uint16_sat_rte(uchar16);
uint16 __CVAttrs convert_uint16_sat_rte(short16);
uint16 __CVAttrs convert_uint16_sat_rte(ushort16);
uint16 __CVAttrs convert_uint16_sat_rte(int16);
uint16 __CVAttrs convert_uint16_sat_rte(uint16);
uint16 __CVAttrs convert_uint16_sat_rte(long16);
uint16 __CVAttrs convert_uint16_sat_rte(ulong16);
uint16 __CVAttrs convert_uint16_sat_rte(float16);
uint16 __CVAttrs convert_uint16_sat_rte(double16);
uint16 __CVAttrs convert_uint16_sat_rtz(char16);
uint16 __CVAttrs convert_uint16_sat_rtz(uchar16);
uint16 __CVAttrs convert_uint16_sat_rtz(short16);
uint16 __CVAttrs convert_uint16_sat_rtz(ushort16);
uint16 __CVAttrs convert_uint16_sat_rtz(int16);
uint16 __CVAttrs convert_uint16_sat_rtz(uint16);
uint16 __CVAttrs convert_uint16_sat_rtz(long16);
uint16 __CVAttrs convert_uint16_sat_rtz(ulong16);
uint16 __CVAttrs convert_uint16_sat_rtz(float16);
uint16 __CVAttrs convert_uint16_sat_rtz(double16);
uint16 __CVAttrs convert_uint16_sat_rtp(char16);
uint16 __CVAttrs convert_uint16_sat_rtp(uchar16);
uint16 __CVAttrs convert_uint16_sat_rtp(short16);
uint16 __CVAttrs convert_uint16_sat_rtp(ushort16);
uint16 __CVAttrs convert_uint16_sat_rtp(int16);
uint16 __CVAttrs convert_uint16_sat_rtp(uint16);
uint16 __CVAttrs convert_uint16_sat_rtp(long16);
uint16 __CVAttrs convert_uint16_sat_rtp(ulong16);
uint16 __CVAttrs convert_uint16_sat_rtp(float16);
uint16 __CVAttrs convert_uint16_sat_rtp(double16);
uint16 __CVAttrs convert_uint16_sat_rtn(char16);
uint16 __CVAttrs convert_uint16_sat_rtn(uchar16);
uint16 __CVAttrs convert_uint16_sat_rtn(short16);
uint16 __CVAttrs convert_uint16_sat_rtn(ushort16);
uint16 __CVAttrs convert_uint16_sat_rtn(int16);
uint16 __CVAttrs convert_uint16_sat_rtn(uint16);
uint16 __CVAttrs convert_uint16_sat_rtn(long16);
uint16 __CVAttrs convert_uint16_sat_rtn(ulong16);
uint16 __CVAttrs convert_uint16_sat_rtn(float16);
uint16 __CVAttrs convert_uint16_sat_rtn(double16);
long __CVAttrs convert_long(char);
long __CVAttrs convert_long(uchar);
long __CVAttrs convert_long(short);
long __CVAttrs convert_long(ushort);
long __CVAttrs convert_long(int);
long __CVAttrs convert_long(uint);
long __CVAttrs convert_long(long);
long __CVAttrs convert_long(ulong);
long __CVAttrs convert_long(float);
long __CVAttrs convert_long(double);
long __CVAttrs convert_long_rte(char);
long __CVAttrs convert_long_rte(uchar);
long __CVAttrs convert_long_rte(short);
long __CVAttrs convert_long_rte(ushort);
long __CVAttrs convert_long_rte(int);
long __CVAttrs convert_long_rte(uint);
long __CVAttrs convert_long_rte(long);
long __CVAttrs convert_long_rte(ulong);
long __CVAttrs convert_long_rte(float);
long __CVAttrs convert_long_rte(double);
long __CVAttrs convert_long_rtz(char);
long __CVAttrs convert_long_rtz(uchar);
long __CVAttrs convert_long_rtz(short);
long __CVAttrs convert_long_rtz(ushort);
long __CVAttrs convert_long_rtz(int);
long __CVAttrs convert_long_rtz(uint);
long __CVAttrs convert_long_rtz(long);
long __CVAttrs convert_long_rtz(ulong);
long __CVAttrs convert_long_rtz(float);
long __CVAttrs convert_long_rtz(double);
long __CVAttrs convert_long_rtp(char);
long __CVAttrs convert_long_rtp(uchar);
long __CVAttrs convert_long_rtp(short);
long __CVAttrs convert_long_rtp(ushort);
long __CVAttrs convert_long_rtp(int);
long __CVAttrs convert_long_rtp(uint);
long __CVAttrs convert_long_rtp(long);
long __CVAttrs convert_long_rtp(ulong);
long __CVAttrs convert_long_rtp(float);
long __CVAttrs convert_long_rtp(double);
long __CVAttrs convert_long_rtn(char);
long __CVAttrs convert_long_rtn(uchar);
long __CVAttrs convert_long_rtn(short);
long __CVAttrs convert_long_rtn(ushort);
long __CVAttrs convert_long_rtn(int);
long __CVAttrs convert_long_rtn(uint);
long __CVAttrs convert_long_rtn(long);
long __CVAttrs convert_long_rtn(ulong);
long __CVAttrs convert_long_rtn(float);
long __CVAttrs convert_long_rtn(double);
long __CVAttrs convert_long_sat(char);
long __CVAttrs convert_long_sat(uchar);
long __CVAttrs convert_long_sat(short);
long __CVAttrs convert_long_sat(ushort);
long __CVAttrs convert_long_sat(int);
long __CVAttrs convert_long_sat(uint);
long __CVAttrs convert_long_sat(long);
long __CVAttrs convert_long_sat(ulong);
long __CVAttrs convert_long_sat(float);
long __CVAttrs convert_long_sat(double);
long __CVAttrs convert_long_sat_rte(char);
long __CVAttrs convert_long_sat_rte(uchar);
long __CVAttrs convert_long_sat_rte(short);
long __CVAttrs convert_long_sat_rte(ushort);
long __CVAttrs convert_long_sat_rte(int);
long __CVAttrs convert_long_sat_rte(uint);
long __CVAttrs convert_long_sat_rte(long);
long __CVAttrs convert_long_sat_rte(ulong);
long __CVAttrs convert_long_sat_rte(float);
long __CVAttrs convert_long_sat_rte(double);
long __CVAttrs convert_long_sat_rtz(char);
long __CVAttrs convert_long_sat_rtz(uchar);
long __CVAttrs convert_long_sat_rtz(short);
long __CVAttrs convert_long_sat_rtz(ushort);
long __CVAttrs convert_long_sat_rtz(int);
long __CVAttrs convert_long_sat_rtz(uint);
long __CVAttrs convert_long_sat_rtz(long);
long __CVAttrs convert_long_sat_rtz(ulong);
long __CVAttrs convert_long_sat_rtz(float);
long __CVAttrs convert_long_sat_rtz(double);
long __CVAttrs convert_long_sat_rtp(char);
long __CVAttrs convert_long_sat_rtp(uchar);
long __CVAttrs convert_long_sat_rtp(short);
long __CVAttrs convert_long_sat_rtp(ushort);
long __CVAttrs convert_long_sat_rtp(int);
long __CVAttrs convert_long_sat_rtp(uint);
long __CVAttrs convert_long_sat_rtp(long);
long __CVAttrs convert_long_sat_rtp(ulong);
long __CVAttrs convert_long_sat_rtp(float);
long __CVAttrs convert_long_sat_rtp(double);
long __CVAttrs convert_long_sat_rtn(char);
long __CVAttrs convert_long_sat_rtn(uchar);
long __CVAttrs convert_long_sat_rtn(short);
long __CVAttrs convert_long_sat_rtn(ushort);
long __CVAttrs convert_long_sat_rtn(int);
long __CVAttrs convert_long_sat_rtn(uint);
long __CVAttrs convert_long_sat_rtn(long);
long __CVAttrs convert_long_sat_rtn(ulong);
long __CVAttrs convert_long_sat_rtn(float);
long __CVAttrs convert_long_sat_rtn(double);
long2 __CVAttrs convert_long2(char2);
long2 __CVAttrs convert_long2(uchar2);
long2 __CVAttrs convert_long2(short2);
long2 __CVAttrs convert_long2(ushort2);
long2 __CVAttrs convert_long2(int2);
long2 __CVAttrs convert_long2(uint2);
long2 __CVAttrs convert_long2(long2);
long2 __CVAttrs convert_long2(ulong2);
long2 __CVAttrs convert_long2(float2);
long2 __CVAttrs convert_long2(double2);
long2 __CVAttrs convert_long2_rte(char2);
long2 __CVAttrs convert_long2_rte(uchar2);
long2 __CVAttrs convert_long2_rte(short2);
long2 __CVAttrs convert_long2_rte(ushort2);
long2 __CVAttrs convert_long2_rte(int2);
long2 __CVAttrs convert_long2_rte(uint2);
long2 __CVAttrs convert_long2_rte(long2);
long2 __CVAttrs convert_long2_rte(ulong2);
long2 __CVAttrs convert_long2_rte(float2);
long2 __CVAttrs convert_long2_rte(double2);
long2 __CVAttrs convert_long2_rtz(char2);
long2 __CVAttrs convert_long2_rtz(uchar2);
long2 __CVAttrs convert_long2_rtz(short2);
long2 __CVAttrs convert_long2_rtz(ushort2);
long2 __CVAttrs convert_long2_rtz(int2);
long2 __CVAttrs convert_long2_rtz(uint2);
long2 __CVAttrs convert_long2_rtz(long2);
long2 __CVAttrs convert_long2_rtz(ulong2);
long2 __CVAttrs convert_long2_rtz(float2);
long2 __CVAttrs convert_long2_rtz(double2);
long2 __CVAttrs convert_long2_rtp(char2);
long2 __CVAttrs convert_long2_rtp(uchar2);
long2 __CVAttrs convert_long2_rtp(short2);
long2 __CVAttrs convert_long2_rtp(ushort2);
long2 __CVAttrs convert_long2_rtp(int2);
long2 __CVAttrs convert_long2_rtp(uint2);
long2 __CVAttrs convert_long2_rtp(long2);
long2 __CVAttrs convert_long2_rtp(ulong2);
long2 __CVAttrs convert_long2_rtp(float2);
long2 __CVAttrs convert_long2_rtp(double2);
long2 __CVAttrs convert_long2_rtn(char2);
long2 __CVAttrs convert_long2_rtn(uchar2);
long2 __CVAttrs convert_long2_rtn(short2);
long2 __CVAttrs convert_long2_rtn(ushort2);
long2 __CVAttrs convert_long2_rtn(int2);
long2 __CVAttrs convert_long2_rtn(uint2);
long2 __CVAttrs convert_long2_rtn(long2);
long2 __CVAttrs convert_long2_rtn(ulong2);
long2 __CVAttrs convert_long2_rtn(float2);
long2 __CVAttrs convert_long2_rtn(double2);
long2 __CVAttrs convert_long2_sat(char2);
long2 __CVAttrs convert_long2_sat(uchar2);
long2 __CVAttrs convert_long2_sat(short2);
long2 __CVAttrs convert_long2_sat(ushort2);
long2 __CVAttrs convert_long2_sat(int2);
long2 __CVAttrs convert_long2_sat(uint2);
long2 __CVAttrs convert_long2_sat(long2);
long2 __CVAttrs convert_long2_sat(ulong2);
long2 __CVAttrs convert_long2_sat(float2);
long2 __CVAttrs convert_long2_sat(double2);
long2 __CVAttrs convert_long2_sat_rte(char2);
long2 __CVAttrs convert_long2_sat_rte(uchar2);
long2 __CVAttrs convert_long2_sat_rte(short2);
long2 __CVAttrs convert_long2_sat_rte(ushort2);
long2 __CVAttrs convert_long2_sat_rte(int2);
long2 __CVAttrs convert_long2_sat_rte(uint2);
long2 __CVAttrs convert_long2_sat_rte(long2);
long2 __CVAttrs convert_long2_sat_rte(ulong2);
long2 __CVAttrs convert_long2_sat_rte(float2);
long2 __CVAttrs convert_long2_sat_rte(double2);
long2 __CVAttrs convert_long2_sat_rtz(char2);
long2 __CVAttrs convert_long2_sat_rtz(uchar2);
long2 __CVAttrs convert_long2_sat_rtz(short2);
long2 __CVAttrs convert_long2_sat_rtz(ushort2);
long2 __CVAttrs convert_long2_sat_rtz(int2);
long2 __CVAttrs convert_long2_sat_rtz(uint2);
long2 __CVAttrs convert_long2_sat_rtz(long2);
long2 __CVAttrs convert_long2_sat_rtz(ulong2);
long2 __CVAttrs convert_long2_sat_rtz(float2);
long2 __CVAttrs convert_long2_sat_rtz(double2);
long2 __CVAttrs convert_long2_sat_rtp(char2);
long2 __CVAttrs convert_long2_sat_rtp(uchar2);
long2 __CVAttrs convert_long2_sat_rtp(short2);
long2 __CVAttrs convert_long2_sat_rtp(ushort2);
long2 __CVAttrs convert_long2_sat_rtp(int2);
long2 __CVAttrs convert_long2_sat_rtp(uint2);
long2 __CVAttrs convert_long2_sat_rtp(long2);
long2 __CVAttrs convert_long2_sat_rtp(ulong2);
long2 __CVAttrs convert_long2_sat_rtp(float2);
long2 __CVAttrs convert_long2_sat_rtp(double2);
long2 __CVAttrs convert_long2_sat_rtn(char2);
long2 __CVAttrs convert_long2_sat_rtn(uchar2);
long2 __CVAttrs convert_long2_sat_rtn(short2);
long2 __CVAttrs convert_long2_sat_rtn(ushort2);
long2 __CVAttrs convert_long2_sat_rtn(int2);
long2 __CVAttrs convert_long2_sat_rtn(uint2);
long2 __CVAttrs convert_long2_sat_rtn(long2);
long2 __CVAttrs convert_long2_sat_rtn(ulong2);
long2 __CVAttrs convert_long2_sat_rtn(float2);
long2 __CVAttrs convert_long2_sat_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
long3 __CVAttrs convert_long3(char3);
long3 __CVAttrs convert_long3(uchar3);
long3 __CVAttrs convert_long3(short3);
long3 __CVAttrs convert_long3(ushort3);
long3 __CVAttrs convert_long3(int3);
long3 __CVAttrs convert_long3(uint3);
long3 __CVAttrs convert_long3(long3);
long3 __CVAttrs convert_long3(ulong3);
long3 __CVAttrs convert_long3(float3);
long3 __CVAttrs convert_long3(double3);
long3 __CVAttrs convert_long3_rte(char3);
long3 __CVAttrs convert_long3_rte(uchar3);
long3 __CVAttrs convert_long3_rte(short3);
long3 __CVAttrs convert_long3_rte(ushort3);
long3 __CVAttrs convert_long3_rte(int3);
long3 __CVAttrs convert_long3_rte(uint3);
long3 __CVAttrs convert_long3_rte(long3);
long3 __CVAttrs convert_long3_rte(ulong3);
long3 __CVAttrs convert_long3_rte(float3);
long3 __CVAttrs convert_long3_rte(double3);
long3 __CVAttrs convert_long3_rtz(char3);
long3 __CVAttrs convert_long3_rtz(uchar3);
long3 __CVAttrs convert_long3_rtz(short3);
long3 __CVAttrs convert_long3_rtz(ushort3);
long3 __CVAttrs convert_long3_rtz(int3);
long3 __CVAttrs convert_long3_rtz(uint3);
long3 __CVAttrs convert_long3_rtz(long3);
long3 __CVAttrs convert_long3_rtz(ulong3);
long3 __CVAttrs convert_long3_rtz(float3);
long3 __CVAttrs convert_long3_rtz(double3);
long3 __CVAttrs convert_long3_rtp(char3);
long3 __CVAttrs convert_long3_rtp(uchar3);
long3 __CVAttrs convert_long3_rtp(short3);
long3 __CVAttrs convert_long3_rtp(ushort3);
long3 __CVAttrs convert_long3_rtp(int3);
long3 __CVAttrs convert_long3_rtp(uint3);
long3 __CVAttrs convert_long3_rtp(long3);
long3 __CVAttrs convert_long3_rtp(ulong3);
long3 __CVAttrs convert_long3_rtp(float3);
long3 __CVAttrs convert_long3_rtp(double3);
long3 __CVAttrs convert_long3_rtn(char3);
long3 __CVAttrs convert_long3_rtn(uchar3);
long3 __CVAttrs convert_long3_rtn(short3);
long3 __CVAttrs convert_long3_rtn(ushort3);
long3 __CVAttrs convert_long3_rtn(int3);
long3 __CVAttrs convert_long3_rtn(uint3);
long3 __CVAttrs convert_long3_rtn(long3);
long3 __CVAttrs convert_long3_rtn(ulong3);
long3 __CVAttrs convert_long3_rtn(float3);
long3 __CVAttrs convert_long3_rtn(double3);
long3 __CVAttrs convert_long3_sat(char3);
long3 __CVAttrs convert_long3_sat(uchar3);
long3 __CVAttrs convert_long3_sat(short3);
long3 __CVAttrs convert_long3_sat(ushort3);
long3 __CVAttrs convert_long3_sat(int3);
long3 __CVAttrs convert_long3_sat(uint3);
long3 __CVAttrs convert_long3_sat(long3);
long3 __CVAttrs convert_long3_sat(ulong3);
long3 __CVAttrs convert_long3_sat(float3);
long3 __CVAttrs convert_long3_sat(double3);
long3 __CVAttrs convert_long3_sat_rte(char3);
long3 __CVAttrs convert_long3_sat_rte(uchar3);
long3 __CVAttrs convert_long3_sat_rte(short3);
long3 __CVAttrs convert_long3_sat_rte(ushort3);
long3 __CVAttrs convert_long3_sat_rte(int3);
long3 __CVAttrs convert_long3_sat_rte(uint3);
long3 __CVAttrs convert_long3_sat_rte(long3);
long3 __CVAttrs convert_long3_sat_rte(ulong3);
long3 __CVAttrs convert_long3_sat_rte(float3);
long3 __CVAttrs convert_long3_sat_rte(double3);
long3 __CVAttrs convert_long3_sat_rtz(char3);
long3 __CVAttrs convert_long3_sat_rtz(uchar3);
long3 __CVAttrs convert_long3_sat_rtz(short3);
long3 __CVAttrs convert_long3_sat_rtz(ushort3);
long3 __CVAttrs convert_long3_sat_rtz(int3);
long3 __CVAttrs convert_long3_sat_rtz(uint3);
long3 __CVAttrs convert_long3_sat_rtz(long3);
long3 __CVAttrs convert_long3_sat_rtz(ulong3);
long3 __CVAttrs convert_long3_sat_rtz(float3);
long3 __CVAttrs convert_long3_sat_rtz(double3);
long3 __CVAttrs convert_long3_sat_rtp(char3);
long3 __CVAttrs convert_long3_sat_rtp(uchar3);
long3 __CVAttrs convert_long3_sat_rtp(short3);
long3 __CVAttrs convert_long3_sat_rtp(ushort3);
long3 __CVAttrs convert_long3_sat_rtp(int3);
long3 __CVAttrs convert_long3_sat_rtp(uint3);
long3 __CVAttrs convert_long3_sat_rtp(long3);
long3 __CVAttrs convert_long3_sat_rtp(ulong3);
long3 __CVAttrs convert_long3_sat_rtp(float3);
long3 __CVAttrs convert_long3_sat_rtp(double3);
long3 __CVAttrs convert_long3_sat_rtn(char3);
long3 __CVAttrs convert_long3_sat_rtn(uchar3);
long3 __CVAttrs convert_long3_sat_rtn(short3);
long3 __CVAttrs convert_long3_sat_rtn(ushort3);
long3 __CVAttrs convert_long3_sat_rtn(int3);
long3 __CVAttrs convert_long3_sat_rtn(uint3);
long3 __CVAttrs convert_long3_sat_rtn(long3);
long3 __CVAttrs convert_long3_sat_rtn(ulong3);
long3 __CVAttrs convert_long3_sat_rtn(float3);
long3 __CVAttrs convert_long3_sat_rtn(double3);
#endif
long4 __CVAttrs convert_long4(char4);
long4 __CVAttrs convert_long4(uchar4);
long4 __CVAttrs convert_long4(short4);
long4 __CVAttrs convert_long4(ushort4);
long4 __CVAttrs convert_long4(int4);
long4 __CVAttrs convert_long4(uint4);
long4 __CVAttrs convert_long4(long4);
long4 __CVAttrs convert_long4(ulong4);
long4 __CVAttrs convert_long4(float4);
long4 __CVAttrs convert_long4(double4);
long4 __CVAttrs convert_long4_rte(char4);
long4 __CVAttrs convert_long4_rte(uchar4);
long4 __CVAttrs convert_long4_rte(short4);
long4 __CVAttrs convert_long4_rte(ushort4);
long4 __CVAttrs convert_long4_rte(int4);
long4 __CVAttrs convert_long4_rte(uint4);
long4 __CVAttrs convert_long4_rte(long4);
long4 __CVAttrs convert_long4_rte(ulong4);
long4 __CVAttrs convert_long4_rte(float4);
long4 __CVAttrs convert_long4_rte(double4);
long4 __CVAttrs convert_long4_rtz(char4);
long4 __CVAttrs convert_long4_rtz(uchar4);
long4 __CVAttrs convert_long4_rtz(short4);
long4 __CVAttrs convert_long4_rtz(ushort4);
long4 __CVAttrs convert_long4_rtz(int4);
long4 __CVAttrs convert_long4_rtz(uint4);
long4 __CVAttrs convert_long4_rtz(long4);
long4 __CVAttrs convert_long4_rtz(ulong4);
long4 __CVAttrs convert_long4_rtz(float4);
long4 __CVAttrs convert_long4_rtz(double4);
long4 __CVAttrs convert_long4_rtp(char4);
long4 __CVAttrs convert_long4_rtp(uchar4);
long4 __CVAttrs convert_long4_rtp(short4);
long4 __CVAttrs convert_long4_rtp(ushort4);
long4 __CVAttrs convert_long4_rtp(int4);
long4 __CVAttrs convert_long4_rtp(uint4);
long4 __CVAttrs convert_long4_rtp(long4);
long4 __CVAttrs convert_long4_rtp(ulong4);
long4 __CVAttrs convert_long4_rtp(float4);
long4 __CVAttrs convert_long4_rtp(double4);
long4 __CVAttrs convert_long4_rtn(char4);
long4 __CVAttrs convert_long4_rtn(uchar4);
long4 __CVAttrs convert_long4_rtn(short4);
long4 __CVAttrs convert_long4_rtn(ushort4);
long4 __CVAttrs convert_long4_rtn(int4);
long4 __CVAttrs convert_long4_rtn(uint4);
long4 __CVAttrs convert_long4_rtn(long4);
long4 __CVAttrs convert_long4_rtn(ulong4);
long4 __CVAttrs convert_long4_rtn(float4);
long4 __CVAttrs convert_long4_rtn(double4);
long4 __CVAttrs convert_long4_sat(char4);
long4 __CVAttrs convert_long4_sat(uchar4);
long4 __CVAttrs convert_long4_sat(short4);
long4 __CVAttrs convert_long4_sat(ushort4);
long4 __CVAttrs convert_long4_sat(int4);
long4 __CVAttrs convert_long4_sat(uint4);
long4 __CVAttrs convert_long4_sat(long4);
long4 __CVAttrs convert_long4_sat(ulong4);
long4 __CVAttrs convert_long4_sat(float4);
long4 __CVAttrs convert_long4_sat(double4);
long4 __CVAttrs convert_long4_sat_rte(char4);
long4 __CVAttrs convert_long4_sat_rte(uchar4);
long4 __CVAttrs convert_long4_sat_rte(short4);
long4 __CVAttrs convert_long4_sat_rte(ushort4);
long4 __CVAttrs convert_long4_sat_rte(int4);
long4 __CVAttrs convert_long4_sat_rte(uint4);
long4 __CVAttrs convert_long4_sat_rte(long4);
long4 __CVAttrs convert_long4_sat_rte(ulong4);
long4 __CVAttrs convert_long4_sat_rte(float4);
long4 __CVAttrs convert_long4_sat_rte(double4);
long4 __CVAttrs convert_long4_sat_rtz(char4);
long4 __CVAttrs convert_long4_sat_rtz(uchar4);
long4 __CVAttrs convert_long4_sat_rtz(short4);
long4 __CVAttrs convert_long4_sat_rtz(ushort4);
long4 __CVAttrs convert_long4_sat_rtz(int4);
long4 __CVAttrs convert_long4_sat_rtz(uint4);
long4 __CVAttrs convert_long4_sat_rtz(long4);
long4 __CVAttrs convert_long4_sat_rtz(ulong4);
long4 __CVAttrs convert_long4_sat_rtz(float4);
long4 __CVAttrs convert_long4_sat_rtz(double4);
long4 __CVAttrs convert_long4_sat_rtp(char4);
long4 __CVAttrs convert_long4_sat_rtp(uchar4);
long4 __CVAttrs convert_long4_sat_rtp(short4);
long4 __CVAttrs convert_long4_sat_rtp(ushort4);
long4 __CVAttrs convert_long4_sat_rtp(int4);
long4 __CVAttrs convert_long4_sat_rtp(uint4);
long4 __CVAttrs convert_long4_sat_rtp(long4);
long4 __CVAttrs convert_long4_sat_rtp(ulong4);
long4 __CVAttrs convert_long4_sat_rtp(float4);
long4 __CVAttrs convert_long4_sat_rtp(double4);
long4 __CVAttrs convert_long4_sat_rtn(char4);
long4 __CVAttrs convert_long4_sat_rtn(uchar4);
long4 __CVAttrs convert_long4_sat_rtn(short4);
long4 __CVAttrs convert_long4_sat_rtn(ushort4);
long4 __CVAttrs convert_long4_sat_rtn(int4);
long4 __CVAttrs convert_long4_sat_rtn(uint4);
long4 __CVAttrs convert_long4_sat_rtn(long4);
long4 __CVAttrs convert_long4_sat_rtn(ulong4);
long4 __CVAttrs convert_long4_sat_rtn(float4);
long4 __CVAttrs convert_long4_sat_rtn(double4);
long8 __CVAttrs convert_long8(char8);
long8 __CVAttrs convert_long8(uchar8);
long8 __CVAttrs convert_long8(short8);
long8 __CVAttrs convert_long8(ushort8);
long8 __CVAttrs convert_long8(int8);
long8 __CVAttrs convert_long8(uint8);
long8 __CVAttrs convert_long8(long8);
long8 __CVAttrs convert_long8(ulong8);
long8 __CVAttrs convert_long8(float8);
long8 __CVAttrs convert_long8(double8);
long8 __CVAttrs convert_long8_rte(char8);
long8 __CVAttrs convert_long8_rte(uchar8);
long8 __CVAttrs convert_long8_rte(short8);
long8 __CVAttrs convert_long8_rte(ushort8);
long8 __CVAttrs convert_long8_rte(int8);
long8 __CVAttrs convert_long8_rte(uint8);
long8 __CVAttrs convert_long8_rte(long8);
long8 __CVAttrs convert_long8_rte(ulong8);
long8 __CVAttrs convert_long8_rte(float8);
long8 __CVAttrs convert_long8_rte(double8);
long8 __CVAttrs convert_long8_rtz(char8);
long8 __CVAttrs convert_long8_rtz(uchar8);
long8 __CVAttrs convert_long8_rtz(short8);
long8 __CVAttrs convert_long8_rtz(ushort8);
long8 __CVAttrs convert_long8_rtz(int8);
long8 __CVAttrs convert_long8_rtz(uint8);
long8 __CVAttrs convert_long8_rtz(long8);
long8 __CVAttrs convert_long8_rtz(ulong8);
long8 __CVAttrs convert_long8_rtz(float8);
long8 __CVAttrs convert_long8_rtz(double8);
long8 __CVAttrs convert_long8_rtp(char8);
long8 __CVAttrs convert_long8_rtp(uchar8);
long8 __CVAttrs convert_long8_rtp(short8);
long8 __CVAttrs convert_long8_rtp(ushort8);
long8 __CVAttrs convert_long8_rtp(int8);
long8 __CVAttrs convert_long8_rtp(uint8);
long8 __CVAttrs convert_long8_rtp(long8);
long8 __CVAttrs convert_long8_rtp(ulong8);
long8 __CVAttrs convert_long8_rtp(float8);
long8 __CVAttrs convert_long8_rtp(double8);
long8 __CVAttrs convert_long8_rtn(char8);
long8 __CVAttrs convert_long8_rtn(uchar8);
long8 __CVAttrs convert_long8_rtn(short8);
long8 __CVAttrs convert_long8_rtn(ushort8);
long8 __CVAttrs convert_long8_rtn(int8);
long8 __CVAttrs convert_long8_rtn(uint8);
long8 __CVAttrs convert_long8_rtn(long8);
long8 __CVAttrs convert_long8_rtn(ulong8);
long8 __CVAttrs convert_long8_rtn(float8);
long8 __CVAttrs convert_long8_rtn(double8);
long8 __CVAttrs convert_long8_sat(char8);
long8 __CVAttrs convert_long8_sat(uchar8);
long8 __CVAttrs convert_long8_sat(short8);
long8 __CVAttrs convert_long8_sat(ushort8);
long8 __CVAttrs convert_long8_sat(int8);
long8 __CVAttrs convert_long8_sat(uint8);
long8 __CVAttrs convert_long8_sat(long8);
long8 __CVAttrs convert_long8_sat(ulong8);
long8 __CVAttrs convert_long8_sat(float8);
long8 __CVAttrs convert_long8_sat(double8);
long8 __CVAttrs convert_long8_sat_rte(char8);
long8 __CVAttrs convert_long8_sat_rte(uchar8);
long8 __CVAttrs convert_long8_sat_rte(short8);
long8 __CVAttrs convert_long8_sat_rte(ushort8);
long8 __CVAttrs convert_long8_sat_rte(int8);
long8 __CVAttrs convert_long8_sat_rte(uint8);
long8 __CVAttrs convert_long8_sat_rte(long8);
long8 __CVAttrs convert_long8_sat_rte(ulong8);
long8 __CVAttrs convert_long8_sat_rte(float8);
long8 __CVAttrs convert_long8_sat_rte(double8);
long8 __CVAttrs convert_long8_sat_rtz(char8);
long8 __CVAttrs convert_long8_sat_rtz(uchar8);
long8 __CVAttrs convert_long8_sat_rtz(short8);
long8 __CVAttrs convert_long8_sat_rtz(ushort8);
long8 __CVAttrs convert_long8_sat_rtz(int8);
long8 __CVAttrs convert_long8_sat_rtz(uint8);
long8 __CVAttrs convert_long8_sat_rtz(long8);
long8 __CVAttrs convert_long8_sat_rtz(ulong8);
long8 __CVAttrs convert_long8_sat_rtz(float8);
long8 __CVAttrs convert_long8_sat_rtz(double8);
long8 __CVAttrs convert_long8_sat_rtp(char8);
long8 __CVAttrs convert_long8_sat_rtp(uchar8);
long8 __CVAttrs convert_long8_sat_rtp(short8);
long8 __CVAttrs convert_long8_sat_rtp(ushort8);
long8 __CVAttrs convert_long8_sat_rtp(int8);
long8 __CVAttrs convert_long8_sat_rtp(uint8);
long8 __CVAttrs convert_long8_sat_rtp(long8);
long8 __CVAttrs convert_long8_sat_rtp(ulong8);
long8 __CVAttrs convert_long8_sat_rtp(float8);
long8 __CVAttrs convert_long8_sat_rtp(double8);
long8 __CVAttrs convert_long8_sat_rtn(char8);
long8 __CVAttrs convert_long8_sat_rtn(uchar8);
long8 __CVAttrs convert_long8_sat_rtn(short8);
long8 __CVAttrs convert_long8_sat_rtn(ushort8);
long8 __CVAttrs convert_long8_sat_rtn(int8);
long8 __CVAttrs convert_long8_sat_rtn(uint8);
long8 __CVAttrs convert_long8_sat_rtn(long8);
long8 __CVAttrs convert_long8_sat_rtn(ulong8);
long8 __CVAttrs convert_long8_sat_rtn(float8);
long8 __CVAttrs convert_long8_sat_rtn(double8);
long16 __CVAttrs convert_long16(char16);
long16 __CVAttrs convert_long16(uchar16);
long16 __CVAttrs convert_long16(short16);
long16 __CVAttrs convert_long16(ushort16);
long16 __CVAttrs convert_long16(int16);
long16 __CVAttrs convert_long16(uint16);
long16 __CVAttrs convert_long16(long16);
long16 __CVAttrs convert_long16(ulong16);
long16 __CVAttrs convert_long16(float16);
long16 __CVAttrs convert_long16(double16);
long16 __CVAttrs convert_long16_rte(char16);
long16 __CVAttrs convert_long16_rte(uchar16);
long16 __CVAttrs convert_long16_rte(short16);
long16 __CVAttrs convert_long16_rte(ushort16);
long16 __CVAttrs convert_long16_rte(int16);
long16 __CVAttrs convert_long16_rte(uint16);
long16 __CVAttrs convert_long16_rte(long16);
long16 __CVAttrs convert_long16_rte(ulong16);
long16 __CVAttrs convert_long16_rte(float16);
long16 __CVAttrs convert_long16_rte(double16);
long16 __CVAttrs convert_long16_rtz(char16);
long16 __CVAttrs convert_long16_rtz(uchar16);
long16 __CVAttrs convert_long16_rtz(short16);
long16 __CVAttrs convert_long16_rtz(ushort16);
long16 __CVAttrs convert_long16_rtz(int16);
long16 __CVAttrs convert_long16_rtz(uint16);
long16 __CVAttrs convert_long16_rtz(long16);
long16 __CVAttrs convert_long16_rtz(ulong16);
long16 __CVAttrs convert_long16_rtz(float16);
long16 __CVAttrs convert_long16_rtz(double16);
long16 __CVAttrs convert_long16_rtp(char16);
long16 __CVAttrs convert_long16_rtp(uchar16);
long16 __CVAttrs convert_long16_rtp(short16);
long16 __CVAttrs convert_long16_rtp(ushort16);
long16 __CVAttrs convert_long16_rtp(int16);
long16 __CVAttrs convert_long16_rtp(uint16);
long16 __CVAttrs convert_long16_rtp(long16);
long16 __CVAttrs convert_long16_rtp(ulong16);
long16 __CVAttrs convert_long16_rtp(float16);
long16 __CVAttrs convert_long16_rtp(double16);
long16 __CVAttrs convert_long16_rtn(char16);
long16 __CVAttrs convert_long16_rtn(uchar16);
long16 __CVAttrs convert_long16_rtn(short16);
long16 __CVAttrs convert_long16_rtn(ushort16);
long16 __CVAttrs convert_long16_rtn(int16);
long16 __CVAttrs convert_long16_rtn(uint16);
long16 __CVAttrs convert_long16_rtn(long16);
long16 __CVAttrs convert_long16_rtn(ulong16);
long16 __CVAttrs convert_long16_rtn(float16);
long16 __CVAttrs convert_long16_rtn(double16);
long16 __CVAttrs convert_long16_sat(char16);
long16 __CVAttrs convert_long16_sat(uchar16);
long16 __CVAttrs convert_long16_sat(short16);
long16 __CVAttrs convert_long16_sat(ushort16);
long16 __CVAttrs convert_long16_sat(int16);
long16 __CVAttrs convert_long16_sat(uint16);
long16 __CVAttrs convert_long16_sat(long16);
long16 __CVAttrs convert_long16_sat(ulong16);
long16 __CVAttrs convert_long16_sat(float16);
long16 __CVAttrs convert_long16_sat(double16);
long16 __CVAttrs convert_long16_sat_rte(char16);
long16 __CVAttrs convert_long16_sat_rte(uchar16);
long16 __CVAttrs convert_long16_sat_rte(short16);
long16 __CVAttrs convert_long16_sat_rte(ushort16);
long16 __CVAttrs convert_long16_sat_rte(int16);
long16 __CVAttrs convert_long16_sat_rte(uint16);
long16 __CVAttrs convert_long16_sat_rte(long16);
long16 __CVAttrs convert_long16_sat_rte(ulong16);
long16 __CVAttrs convert_long16_sat_rte(float16);
long16 __CVAttrs convert_long16_sat_rte(double16);
long16 __CVAttrs convert_long16_sat_rtz(char16);
long16 __CVAttrs convert_long16_sat_rtz(uchar16);
long16 __CVAttrs convert_long16_sat_rtz(short16);
long16 __CVAttrs convert_long16_sat_rtz(ushort16);
long16 __CVAttrs convert_long16_sat_rtz(int16);
long16 __CVAttrs convert_long16_sat_rtz(uint16);
long16 __CVAttrs convert_long16_sat_rtz(long16);
long16 __CVAttrs convert_long16_sat_rtz(ulong16);
long16 __CVAttrs convert_long16_sat_rtz(float16);
long16 __CVAttrs convert_long16_sat_rtz(double16);
long16 __CVAttrs convert_long16_sat_rtp(char16);
long16 __CVAttrs convert_long16_sat_rtp(uchar16);
long16 __CVAttrs convert_long16_sat_rtp(short16);
long16 __CVAttrs convert_long16_sat_rtp(ushort16);
long16 __CVAttrs convert_long16_sat_rtp(int16);
long16 __CVAttrs convert_long16_sat_rtp(uint16);
long16 __CVAttrs convert_long16_sat_rtp(long16);
long16 __CVAttrs convert_long16_sat_rtp(ulong16);
long16 __CVAttrs convert_long16_sat_rtp(float16);
long16 __CVAttrs convert_long16_sat_rtp(double16);
long16 __CVAttrs convert_long16_sat_rtn(char16);
long16 __CVAttrs convert_long16_sat_rtn(uchar16);
long16 __CVAttrs convert_long16_sat_rtn(short16);
long16 __CVAttrs convert_long16_sat_rtn(ushort16);
long16 __CVAttrs convert_long16_sat_rtn(int16);
long16 __CVAttrs convert_long16_sat_rtn(uint16);
long16 __CVAttrs convert_long16_sat_rtn(long16);
long16 __CVAttrs convert_long16_sat_rtn(ulong16);
long16 __CVAttrs convert_long16_sat_rtn(float16);
long16 __CVAttrs convert_long16_sat_rtn(double16);
ulong __CVAttrs convert_ulong(char);
ulong __CVAttrs convert_ulong(uchar);
ulong __CVAttrs convert_ulong(short);
ulong __CVAttrs convert_ulong(ushort);
ulong __CVAttrs convert_ulong(int);
ulong __CVAttrs convert_ulong(uint);
ulong __CVAttrs convert_ulong(long);
ulong __CVAttrs convert_ulong(ulong);
ulong __CVAttrs convert_ulong(float);
ulong __CVAttrs convert_ulong(double);
ulong __CVAttrs convert_ulong_rte(char);
ulong __CVAttrs convert_ulong_rte(uchar);
ulong __CVAttrs convert_ulong_rte(short);
ulong __CVAttrs convert_ulong_rte(ushort);
ulong __CVAttrs convert_ulong_rte(int);
ulong __CVAttrs convert_ulong_rte(uint);
ulong __CVAttrs convert_ulong_rte(long);
ulong __CVAttrs convert_ulong_rte(ulong);
ulong __CVAttrs convert_ulong_rte(float);
ulong __CVAttrs convert_ulong_rte(double);
ulong __CVAttrs convert_ulong_rtz(char);
ulong __CVAttrs convert_ulong_rtz(uchar);
ulong __CVAttrs convert_ulong_rtz(short);
ulong __CVAttrs convert_ulong_rtz(ushort);
ulong __CVAttrs convert_ulong_rtz(int);
ulong __CVAttrs convert_ulong_rtz(uint);
ulong __CVAttrs convert_ulong_rtz(long);
ulong __CVAttrs convert_ulong_rtz(ulong);
ulong __CVAttrs convert_ulong_rtz(float);
ulong __CVAttrs convert_ulong_rtz(double);
ulong __CVAttrs convert_ulong_rtp(char);
ulong __CVAttrs convert_ulong_rtp(uchar);
ulong __CVAttrs convert_ulong_rtp(short);
ulong __CVAttrs convert_ulong_rtp(ushort);
ulong __CVAttrs convert_ulong_rtp(int);
ulong __CVAttrs convert_ulong_rtp(uint);
ulong __CVAttrs convert_ulong_rtp(long);
ulong __CVAttrs convert_ulong_rtp(ulong);
ulong __CVAttrs convert_ulong_rtp(float);
ulong __CVAttrs convert_ulong_rtp(double);
ulong __CVAttrs convert_ulong_rtn(char);
ulong __CVAttrs convert_ulong_rtn(uchar);
ulong __CVAttrs convert_ulong_rtn(short);
ulong __CVAttrs convert_ulong_rtn(ushort);
ulong __CVAttrs convert_ulong_rtn(int);
ulong __CVAttrs convert_ulong_rtn(uint);
ulong __CVAttrs convert_ulong_rtn(long);
ulong __CVAttrs convert_ulong_rtn(ulong);
ulong __CVAttrs convert_ulong_rtn(float);
ulong __CVAttrs convert_ulong_rtn(double);
ulong __CVAttrs convert_ulong_sat(char);
ulong __CVAttrs convert_ulong_sat(uchar);
ulong __CVAttrs convert_ulong_sat(short);
ulong __CVAttrs convert_ulong_sat(ushort);
ulong __CVAttrs convert_ulong_sat(int);
ulong __CVAttrs convert_ulong_sat(uint);
ulong __CVAttrs convert_ulong_sat(long);
ulong __CVAttrs convert_ulong_sat(ulong);
ulong __CVAttrs convert_ulong_sat(float);
ulong __CVAttrs convert_ulong_sat(double);
ulong __CVAttrs convert_ulong_sat_rte(char);
ulong __CVAttrs convert_ulong_sat_rte(uchar);
ulong __CVAttrs convert_ulong_sat_rte(short);
ulong __CVAttrs convert_ulong_sat_rte(ushort);
ulong __CVAttrs convert_ulong_sat_rte(int);
ulong __CVAttrs convert_ulong_sat_rte(uint);
ulong __CVAttrs convert_ulong_sat_rte(long);
ulong __CVAttrs convert_ulong_sat_rte(ulong);
ulong __CVAttrs convert_ulong_sat_rte(float);
ulong __CVAttrs convert_ulong_sat_rte(double);
ulong __CVAttrs convert_ulong_sat_rtz(char);
ulong __CVAttrs convert_ulong_sat_rtz(uchar);
ulong __CVAttrs convert_ulong_sat_rtz(short);
ulong __CVAttrs convert_ulong_sat_rtz(ushort);
ulong __CVAttrs convert_ulong_sat_rtz(int);
ulong __CVAttrs convert_ulong_sat_rtz(uint);
ulong __CVAttrs convert_ulong_sat_rtz(long);
ulong __CVAttrs convert_ulong_sat_rtz(ulong);
ulong __CVAttrs convert_ulong_sat_rtz(float);
ulong __CVAttrs convert_ulong_sat_rtz(double);
ulong __CVAttrs convert_ulong_sat_rtp(char);
ulong __CVAttrs convert_ulong_sat_rtp(uchar);
ulong __CVAttrs convert_ulong_sat_rtp(short);
ulong __CVAttrs convert_ulong_sat_rtp(ushort);
ulong __CVAttrs convert_ulong_sat_rtp(int);
ulong __CVAttrs convert_ulong_sat_rtp(uint);
ulong __CVAttrs convert_ulong_sat_rtp(long);
ulong __CVAttrs convert_ulong_sat_rtp(ulong);
ulong __CVAttrs convert_ulong_sat_rtp(float);
ulong __CVAttrs convert_ulong_sat_rtp(double);
ulong __CVAttrs convert_ulong_sat_rtn(char);
ulong __CVAttrs convert_ulong_sat_rtn(uchar);
ulong __CVAttrs convert_ulong_sat_rtn(short);
ulong __CVAttrs convert_ulong_sat_rtn(ushort);
ulong __CVAttrs convert_ulong_sat_rtn(int);
ulong __CVAttrs convert_ulong_sat_rtn(uint);
ulong __CVAttrs convert_ulong_sat_rtn(long);
ulong __CVAttrs convert_ulong_sat_rtn(ulong);
ulong __CVAttrs convert_ulong_sat_rtn(float);
ulong __CVAttrs convert_ulong_sat_rtn(double);
ulong2 __CVAttrs convert_ulong2(char2);
ulong2 __CVAttrs convert_ulong2(uchar2);
ulong2 __CVAttrs convert_ulong2(short2);
ulong2 __CVAttrs convert_ulong2(ushort2);
ulong2 __CVAttrs convert_ulong2(int2);
ulong2 __CVAttrs convert_ulong2(uint2);
ulong2 __CVAttrs convert_ulong2(long2);
ulong2 __CVAttrs convert_ulong2(ulong2);
ulong2 __CVAttrs convert_ulong2(float2);
ulong2 __CVAttrs convert_ulong2(double2);
ulong2 __CVAttrs convert_ulong2_rte(char2);
ulong2 __CVAttrs convert_ulong2_rte(uchar2);
ulong2 __CVAttrs convert_ulong2_rte(short2);
ulong2 __CVAttrs convert_ulong2_rte(ushort2);
ulong2 __CVAttrs convert_ulong2_rte(int2);
ulong2 __CVAttrs convert_ulong2_rte(uint2);
ulong2 __CVAttrs convert_ulong2_rte(long2);
ulong2 __CVAttrs convert_ulong2_rte(ulong2);
ulong2 __CVAttrs convert_ulong2_rte(float2);
ulong2 __CVAttrs convert_ulong2_rte(double2);
ulong2 __CVAttrs convert_ulong2_rtz(char2);
ulong2 __CVAttrs convert_ulong2_rtz(uchar2);
ulong2 __CVAttrs convert_ulong2_rtz(short2);
ulong2 __CVAttrs convert_ulong2_rtz(ushort2);
ulong2 __CVAttrs convert_ulong2_rtz(int2);
ulong2 __CVAttrs convert_ulong2_rtz(uint2);
ulong2 __CVAttrs convert_ulong2_rtz(long2);
ulong2 __CVAttrs convert_ulong2_rtz(ulong2);
ulong2 __CVAttrs convert_ulong2_rtz(float2);
ulong2 __CVAttrs convert_ulong2_rtz(double2);
ulong2 __CVAttrs convert_ulong2_rtp(char2);
ulong2 __CVAttrs convert_ulong2_rtp(uchar2);
ulong2 __CVAttrs convert_ulong2_rtp(short2);
ulong2 __CVAttrs convert_ulong2_rtp(ushort2);
ulong2 __CVAttrs convert_ulong2_rtp(int2);
ulong2 __CVAttrs convert_ulong2_rtp(uint2);
ulong2 __CVAttrs convert_ulong2_rtp(long2);
ulong2 __CVAttrs convert_ulong2_rtp(ulong2);
ulong2 __CVAttrs convert_ulong2_rtp(float2);
ulong2 __CVAttrs convert_ulong2_rtp(double2);
ulong2 __CVAttrs convert_ulong2_rtn(char2);
ulong2 __CVAttrs convert_ulong2_rtn(uchar2);
ulong2 __CVAttrs convert_ulong2_rtn(short2);
ulong2 __CVAttrs convert_ulong2_rtn(ushort2);
ulong2 __CVAttrs convert_ulong2_rtn(int2);
ulong2 __CVAttrs convert_ulong2_rtn(uint2);
ulong2 __CVAttrs convert_ulong2_rtn(long2);
ulong2 __CVAttrs convert_ulong2_rtn(ulong2);
ulong2 __CVAttrs convert_ulong2_rtn(float2);
ulong2 __CVAttrs convert_ulong2_rtn(double2);
ulong2 __CVAttrs convert_ulong2_sat(char2);
ulong2 __CVAttrs convert_ulong2_sat(uchar2);
ulong2 __CVAttrs convert_ulong2_sat(short2);
ulong2 __CVAttrs convert_ulong2_sat(ushort2);
ulong2 __CVAttrs convert_ulong2_sat(int2);
ulong2 __CVAttrs convert_ulong2_sat(uint2);
ulong2 __CVAttrs convert_ulong2_sat(long2);
ulong2 __CVAttrs convert_ulong2_sat(ulong2);
ulong2 __CVAttrs convert_ulong2_sat(float2);
ulong2 __CVAttrs convert_ulong2_sat(double2);
ulong2 __CVAttrs convert_ulong2_sat_rte(char2);
ulong2 __CVAttrs convert_ulong2_sat_rte(uchar2);
ulong2 __CVAttrs convert_ulong2_sat_rte(short2);
ulong2 __CVAttrs convert_ulong2_sat_rte(ushort2);
ulong2 __CVAttrs convert_ulong2_sat_rte(int2);
ulong2 __CVAttrs convert_ulong2_sat_rte(uint2);
ulong2 __CVAttrs convert_ulong2_sat_rte(long2);
ulong2 __CVAttrs convert_ulong2_sat_rte(ulong2);
ulong2 __CVAttrs convert_ulong2_sat_rte(float2);
ulong2 __CVAttrs convert_ulong2_sat_rte(double2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(char2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(uchar2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(short2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(ushort2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(int2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(uint2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(long2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(ulong2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(float2);
ulong2 __CVAttrs convert_ulong2_sat_rtz(double2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(char2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(uchar2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(short2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(ushort2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(int2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(uint2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(long2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(ulong2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(float2);
ulong2 __CVAttrs convert_ulong2_sat_rtp(double2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(char2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(uchar2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(short2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(ushort2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(int2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(uint2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(long2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(ulong2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(float2);
ulong2 __CVAttrs convert_ulong2_sat_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
ulong3 __CVAttrs convert_ulong3(char3);
ulong3 __CVAttrs convert_ulong3(uchar3);
ulong3 __CVAttrs convert_ulong3(short3);
ulong3 __CVAttrs convert_ulong3(ushort3);
ulong3 __CVAttrs convert_ulong3(int3);
ulong3 __CVAttrs convert_ulong3(uint3);
ulong3 __CVAttrs convert_ulong3(long3);
ulong3 __CVAttrs convert_ulong3(ulong3);
ulong3 __CVAttrs convert_ulong3(float3);
ulong3 __CVAttrs convert_ulong3(double3);
ulong3 __CVAttrs convert_ulong3_rte(char3);
ulong3 __CVAttrs convert_ulong3_rte(uchar3);
ulong3 __CVAttrs convert_ulong3_rte(short3);
ulong3 __CVAttrs convert_ulong3_rte(ushort3);
ulong3 __CVAttrs convert_ulong3_rte(int3);
ulong3 __CVAttrs convert_ulong3_rte(uint3);
ulong3 __CVAttrs convert_ulong3_rte(long3);
ulong3 __CVAttrs convert_ulong3_rte(ulong3);
ulong3 __CVAttrs convert_ulong3_rte(float3);
ulong3 __CVAttrs convert_ulong3_rte(double3);
ulong3 __CVAttrs convert_ulong3_rtz(char3);
ulong3 __CVAttrs convert_ulong3_rtz(uchar3);
ulong3 __CVAttrs convert_ulong3_rtz(short3);
ulong3 __CVAttrs convert_ulong3_rtz(ushort3);
ulong3 __CVAttrs convert_ulong3_rtz(int3);
ulong3 __CVAttrs convert_ulong3_rtz(uint3);
ulong3 __CVAttrs convert_ulong3_rtz(long3);
ulong3 __CVAttrs convert_ulong3_rtz(ulong3);
ulong3 __CVAttrs convert_ulong3_rtz(float3);
ulong3 __CVAttrs convert_ulong3_rtz(double3);
ulong3 __CVAttrs convert_ulong3_rtp(char3);
ulong3 __CVAttrs convert_ulong3_rtp(uchar3);
ulong3 __CVAttrs convert_ulong3_rtp(short3);
ulong3 __CVAttrs convert_ulong3_rtp(ushort3);
ulong3 __CVAttrs convert_ulong3_rtp(int3);
ulong3 __CVAttrs convert_ulong3_rtp(uint3);
ulong3 __CVAttrs convert_ulong3_rtp(long3);
ulong3 __CVAttrs convert_ulong3_rtp(ulong3);
ulong3 __CVAttrs convert_ulong3_rtp(float3);
ulong3 __CVAttrs convert_ulong3_rtp(double3);
ulong3 __CVAttrs convert_ulong3_rtn(char3);
ulong3 __CVAttrs convert_ulong3_rtn(uchar3);
ulong3 __CVAttrs convert_ulong3_rtn(short3);
ulong3 __CVAttrs convert_ulong3_rtn(ushort3);
ulong3 __CVAttrs convert_ulong3_rtn(int3);
ulong3 __CVAttrs convert_ulong3_rtn(uint3);
ulong3 __CVAttrs convert_ulong3_rtn(long3);
ulong3 __CVAttrs convert_ulong3_rtn(ulong3);
ulong3 __CVAttrs convert_ulong3_rtn(float3);
ulong3 __CVAttrs convert_ulong3_rtn(double3);
ulong3 __CVAttrs convert_ulong3_sat(char3);
ulong3 __CVAttrs convert_ulong3_sat(uchar3);
ulong3 __CVAttrs convert_ulong3_sat(short3);
ulong3 __CVAttrs convert_ulong3_sat(ushort3);
ulong3 __CVAttrs convert_ulong3_sat(int3);
ulong3 __CVAttrs convert_ulong3_sat(uint3);
ulong3 __CVAttrs convert_ulong3_sat(long3);
ulong3 __CVAttrs convert_ulong3_sat(ulong3);
ulong3 __CVAttrs convert_ulong3_sat(float3);
ulong3 __CVAttrs convert_ulong3_sat(double3);
ulong3 __CVAttrs convert_ulong3_sat_rte(char3);
ulong3 __CVAttrs convert_ulong3_sat_rte(uchar3);
ulong3 __CVAttrs convert_ulong3_sat_rte(short3);
ulong3 __CVAttrs convert_ulong3_sat_rte(ushort3);
ulong3 __CVAttrs convert_ulong3_sat_rte(int3);
ulong3 __CVAttrs convert_ulong3_sat_rte(uint3);
ulong3 __CVAttrs convert_ulong3_sat_rte(long3);
ulong3 __CVAttrs convert_ulong3_sat_rte(ulong3);
ulong3 __CVAttrs convert_ulong3_sat_rte(float3);
ulong3 __CVAttrs convert_ulong3_sat_rte(double3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(char3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(uchar3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(short3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(ushort3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(int3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(uint3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(long3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(ulong3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(float3);
ulong3 __CVAttrs convert_ulong3_sat_rtz(double3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(char3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(uchar3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(short3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(ushort3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(int3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(uint3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(long3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(ulong3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(float3);
ulong3 __CVAttrs convert_ulong3_sat_rtp(double3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(char3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(uchar3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(short3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(ushort3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(int3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(uint3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(long3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(ulong3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(float3);
ulong3 __CVAttrs convert_ulong3_sat_rtn(double3);
#endif
ulong4 __CVAttrs convert_ulong4(char4);
ulong4 __CVAttrs convert_ulong4(uchar4);
ulong4 __CVAttrs convert_ulong4(short4);
ulong4 __CVAttrs convert_ulong4(ushort4);
ulong4 __CVAttrs convert_ulong4(int4);
ulong4 __CVAttrs convert_ulong4(uint4);
ulong4 __CVAttrs convert_ulong4(long4);
ulong4 __CVAttrs convert_ulong4(ulong4);
ulong4 __CVAttrs convert_ulong4(float4);
ulong4 __CVAttrs convert_ulong4(double4);
ulong4 __CVAttrs convert_ulong4_rte(char4);
ulong4 __CVAttrs convert_ulong4_rte(uchar4);
ulong4 __CVAttrs convert_ulong4_rte(short4);
ulong4 __CVAttrs convert_ulong4_rte(ushort4);
ulong4 __CVAttrs convert_ulong4_rte(int4);
ulong4 __CVAttrs convert_ulong4_rte(uint4);
ulong4 __CVAttrs convert_ulong4_rte(long4);
ulong4 __CVAttrs convert_ulong4_rte(ulong4);
ulong4 __CVAttrs convert_ulong4_rte(float4);
ulong4 __CVAttrs convert_ulong4_rte(double4);
ulong4 __CVAttrs convert_ulong4_rtz(char4);
ulong4 __CVAttrs convert_ulong4_rtz(uchar4);
ulong4 __CVAttrs convert_ulong4_rtz(short4);
ulong4 __CVAttrs convert_ulong4_rtz(ushort4);
ulong4 __CVAttrs convert_ulong4_rtz(int4);
ulong4 __CVAttrs convert_ulong4_rtz(uint4);
ulong4 __CVAttrs convert_ulong4_rtz(long4);
ulong4 __CVAttrs convert_ulong4_rtz(ulong4);
ulong4 __CVAttrs convert_ulong4_rtz(float4);
ulong4 __CVAttrs convert_ulong4_rtz(double4);
ulong4 __CVAttrs convert_ulong4_rtp(char4);
ulong4 __CVAttrs convert_ulong4_rtp(uchar4);
ulong4 __CVAttrs convert_ulong4_rtp(short4);
ulong4 __CVAttrs convert_ulong4_rtp(ushort4);
ulong4 __CVAttrs convert_ulong4_rtp(int4);
ulong4 __CVAttrs convert_ulong4_rtp(uint4);
ulong4 __CVAttrs convert_ulong4_rtp(long4);
ulong4 __CVAttrs convert_ulong4_rtp(ulong4);
ulong4 __CVAttrs convert_ulong4_rtp(float4);
ulong4 __CVAttrs convert_ulong4_rtp(double4);
ulong4 __CVAttrs convert_ulong4_rtn(char4);
ulong4 __CVAttrs convert_ulong4_rtn(uchar4);
ulong4 __CVAttrs convert_ulong4_rtn(short4);
ulong4 __CVAttrs convert_ulong4_rtn(ushort4);
ulong4 __CVAttrs convert_ulong4_rtn(int4);
ulong4 __CVAttrs convert_ulong4_rtn(uint4);
ulong4 __CVAttrs convert_ulong4_rtn(long4);
ulong4 __CVAttrs convert_ulong4_rtn(ulong4);
ulong4 __CVAttrs convert_ulong4_rtn(float4);
ulong4 __CVAttrs convert_ulong4_rtn(double4);
ulong4 __CVAttrs convert_ulong4_sat(char4);
ulong4 __CVAttrs convert_ulong4_sat(uchar4);
ulong4 __CVAttrs convert_ulong4_sat(short4);
ulong4 __CVAttrs convert_ulong4_sat(ushort4);
ulong4 __CVAttrs convert_ulong4_sat(int4);
ulong4 __CVAttrs convert_ulong4_sat(uint4);
ulong4 __CVAttrs convert_ulong4_sat(long4);
ulong4 __CVAttrs convert_ulong4_sat(ulong4);
ulong4 __CVAttrs convert_ulong4_sat(float4);
ulong4 __CVAttrs convert_ulong4_sat(double4);
ulong4 __CVAttrs convert_ulong4_sat_rte(char4);
ulong4 __CVAttrs convert_ulong4_sat_rte(uchar4);
ulong4 __CVAttrs convert_ulong4_sat_rte(short4);
ulong4 __CVAttrs convert_ulong4_sat_rte(ushort4);
ulong4 __CVAttrs convert_ulong4_sat_rte(int4);
ulong4 __CVAttrs convert_ulong4_sat_rte(uint4);
ulong4 __CVAttrs convert_ulong4_sat_rte(long4);
ulong4 __CVAttrs convert_ulong4_sat_rte(ulong4);
ulong4 __CVAttrs convert_ulong4_sat_rte(float4);
ulong4 __CVAttrs convert_ulong4_sat_rte(double4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(char4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(uchar4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(short4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(ushort4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(int4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(uint4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(long4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(ulong4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(float4);
ulong4 __CVAttrs convert_ulong4_sat_rtz(double4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(char4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(uchar4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(short4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(ushort4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(int4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(uint4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(long4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(ulong4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(float4);
ulong4 __CVAttrs convert_ulong4_sat_rtp(double4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(char4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(uchar4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(short4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(ushort4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(int4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(uint4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(long4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(ulong4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(float4);
ulong4 __CVAttrs convert_ulong4_sat_rtn(double4);
ulong8 __CVAttrs convert_ulong8(char8);
ulong8 __CVAttrs convert_ulong8(uchar8);
ulong8 __CVAttrs convert_ulong8(short8);
ulong8 __CVAttrs convert_ulong8(ushort8);
ulong8 __CVAttrs convert_ulong8(int8);
ulong8 __CVAttrs convert_ulong8(uint8);
ulong8 __CVAttrs convert_ulong8(long8);
ulong8 __CVAttrs convert_ulong8(ulong8);
ulong8 __CVAttrs convert_ulong8(float8);
ulong8 __CVAttrs convert_ulong8(double8);
ulong8 __CVAttrs convert_ulong8_rte(char8);
ulong8 __CVAttrs convert_ulong8_rte(uchar8);
ulong8 __CVAttrs convert_ulong8_rte(short8);
ulong8 __CVAttrs convert_ulong8_rte(ushort8);
ulong8 __CVAttrs convert_ulong8_rte(int8);
ulong8 __CVAttrs convert_ulong8_rte(uint8);
ulong8 __CVAttrs convert_ulong8_rte(long8);
ulong8 __CVAttrs convert_ulong8_rte(ulong8);
ulong8 __CVAttrs convert_ulong8_rte(float8);
ulong8 __CVAttrs convert_ulong8_rte(double8);
ulong8 __CVAttrs convert_ulong8_rtz(char8);
ulong8 __CVAttrs convert_ulong8_rtz(uchar8);
ulong8 __CVAttrs convert_ulong8_rtz(short8);
ulong8 __CVAttrs convert_ulong8_rtz(ushort8);
ulong8 __CVAttrs convert_ulong8_rtz(int8);
ulong8 __CVAttrs convert_ulong8_rtz(uint8);
ulong8 __CVAttrs convert_ulong8_rtz(long8);
ulong8 __CVAttrs convert_ulong8_rtz(ulong8);
ulong8 __CVAttrs convert_ulong8_rtz(float8);
ulong8 __CVAttrs convert_ulong8_rtz(double8);
ulong8 __CVAttrs convert_ulong8_rtp(char8);
ulong8 __CVAttrs convert_ulong8_rtp(uchar8);
ulong8 __CVAttrs convert_ulong8_rtp(short8);
ulong8 __CVAttrs convert_ulong8_rtp(ushort8);
ulong8 __CVAttrs convert_ulong8_rtp(int8);
ulong8 __CVAttrs convert_ulong8_rtp(uint8);
ulong8 __CVAttrs convert_ulong8_rtp(long8);
ulong8 __CVAttrs convert_ulong8_rtp(ulong8);
ulong8 __CVAttrs convert_ulong8_rtp(float8);
ulong8 __CVAttrs convert_ulong8_rtp(double8);
ulong8 __CVAttrs convert_ulong8_rtn(char8);
ulong8 __CVAttrs convert_ulong8_rtn(uchar8);
ulong8 __CVAttrs convert_ulong8_rtn(short8);
ulong8 __CVAttrs convert_ulong8_rtn(ushort8);
ulong8 __CVAttrs convert_ulong8_rtn(int8);
ulong8 __CVAttrs convert_ulong8_rtn(uint8);
ulong8 __CVAttrs convert_ulong8_rtn(long8);
ulong8 __CVAttrs convert_ulong8_rtn(ulong8);
ulong8 __CVAttrs convert_ulong8_rtn(float8);
ulong8 __CVAttrs convert_ulong8_rtn(double8);
ulong8 __CVAttrs convert_ulong8_sat(char8);
ulong8 __CVAttrs convert_ulong8_sat(uchar8);
ulong8 __CVAttrs convert_ulong8_sat(short8);
ulong8 __CVAttrs convert_ulong8_sat(ushort8);
ulong8 __CVAttrs convert_ulong8_sat(int8);
ulong8 __CVAttrs convert_ulong8_sat(uint8);
ulong8 __CVAttrs convert_ulong8_sat(long8);
ulong8 __CVAttrs convert_ulong8_sat(ulong8);
ulong8 __CVAttrs convert_ulong8_sat(float8);
ulong8 __CVAttrs convert_ulong8_sat(double8);
ulong8 __CVAttrs convert_ulong8_sat_rte(char8);
ulong8 __CVAttrs convert_ulong8_sat_rte(uchar8);
ulong8 __CVAttrs convert_ulong8_sat_rte(short8);
ulong8 __CVAttrs convert_ulong8_sat_rte(ushort8);
ulong8 __CVAttrs convert_ulong8_sat_rte(int8);
ulong8 __CVAttrs convert_ulong8_sat_rte(uint8);
ulong8 __CVAttrs convert_ulong8_sat_rte(long8);
ulong8 __CVAttrs convert_ulong8_sat_rte(ulong8);
ulong8 __CVAttrs convert_ulong8_sat_rte(float8);
ulong8 __CVAttrs convert_ulong8_sat_rte(double8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(char8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(uchar8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(short8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(ushort8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(int8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(uint8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(long8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(ulong8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(float8);
ulong8 __CVAttrs convert_ulong8_sat_rtz(double8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(char8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(uchar8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(short8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(ushort8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(int8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(uint8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(long8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(ulong8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(float8);
ulong8 __CVAttrs convert_ulong8_sat_rtp(double8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(char8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(uchar8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(short8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(ushort8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(int8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(uint8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(long8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(ulong8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(float8);
ulong8 __CVAttrs convert_ulong8_sat_rtn(double8);
ulong16 __CVAttrs convert_ulong16(char16);
ulong16 __CVAttrs convert_ulong16(uchar16);
ulong16 __CVAttrs convert_ulong16(short16);
ulong16 __CVAttrs convert_ulong16(ushort16);
ulong16 __CVAttrs convert_ulong16(int16);
ulong16 __CVAttrs convert_ulong16(uint16);
ulong16 __CVAttrs convert_ulong16(long16);
ulong16 __CVAttrs convert_ulong16(ulong16);
ulong16 __CVAttrs convert_ulong16(float16);
ulong16 __CVAttrs convert_ulong16(double16);
ulong16 __CVAttrs convert_ulong16_rte(char16);
ulong16 __CVAttrs convert_ulong16_rte(uchar16);
ulong16 __CVAttrs convert_ulong16_rte(short16);
ulong16 __CVAttrs convert_ulong16_rte(ushort16);
ulong16 __CVAttrs convert_ulong16_rte(int16);
ulong16 __CVAttrs convert_ulong16_rte(uint16);
ulong16 __CVAttrs convert_ulong16_rte(long16);
ulong16 __CVAttrs convert_ulong16_rte(ulong16);
ulong16 __CVAttrs convert_ulong16_rte(float16);
ulong16 __CVAttrs convert_ulong16_rte(double16);
ulong16 __CVAttrs convert_ulong16_rtz(char16);
ulong16 __CVAttrs convert_ulong16_rtz(uchar16);
ulong16 __CVAttrs convert_ulong16_rtz(short16);
ulong16 __CVAttrs convert_ulong16_rtz(ushort16);
ulong16 __CVAttrs convert_ulong16_rtz(int16);
ulong16 __CVAttrs convert_ulong16_rtz(uint16);
ulong16 __CVAttrs convert_ulong16_rtz(long16);
ulong16 __CVAttrs convert_ulong16_rtz(ulong16);
ulong16 __CVAttrs convert_ulong16_rtz(float16);
ulong16 __CVAttrs convert_ulong16_rtz(double16);
ulong16 __CVAttrs convert_ulong16_rtp(char16);
ulong16 __CVAttrs convert_ulong16_rtp(uchar16);
ulong16 __CVAttrs convert_ulong16_rtp(short16);
ulong16 __CVAttrs convert_ulong16_rtp(ushort16);
ulong16 __CVAttrs convert_ulong16_rtp(int16);
ulong16 __CVAttrs convert_ulong16_rtp(uint16);
ulong16 __CVAttrs convert_ulong16_rtp(long16);
ulong16 __CVAttrs convert_ulong16_rtp(ulong16);
ulong16 __CVAttrs convert_ulong16_rtp(float16);
ulong16 __CVAttrs convert_ulong16_rtp(double16);
ulong16 __CVAttrs convert_ulong16_rtn(char16);
ulong16 __CVAttrs convert_ulong16_rtn(uchar16);
ulong16 __CVAttrs convert_ulong16_rtn(short16);
ulong16 __CVAttrs convert_ulong16_rtn(ushort16);
ulong16 __CVAttrs convert_ulong16_rtn(int16);
ulong16 __CVAttrs convert_ulong16_rtn(uint16);
ulong16 __CVAttrs convert_ulong16_rtn(long16);
ulong16 __CVAttrs convert_ulong16_rtn(ulong16);
ulong16 __CVAttrs convert_ulong16_rtn(float16);
ulong16 __CVAttrs convert_ulong16_rtn(double16);
ulong16 __CVAttrs convert_ulong16_sat(char16);
ulong16 __CVAttrs convert_ulong16_sat(uchar16);
ulong16 __CVAttrs convert_ulong16_sat(short16);
ulong16 __CVAttrs convert_ulong16_sat(ushort16);
ulong16 __CVAttrs convert_ulong16_sat(int16);
ulong16 __CVAttrs convert_ulong16_sat(uint16);
ulong16 __CVAttrs convert_ulong16_sat(long16);
ulong16 __CVAttrs convert_ulong16_sat(ulong16);
ulong16 __CVAttrs convert_ulong16_sat(float16);
ulong16 __CVAttrs convert_ulong16_sat(double16);
ulong16 __CVAttrs convert_ulong16_sat_rte(char16);
ulong16 __CVAttrs convert_ulong16_sat_rte(uchar16);
ulong16 __CVAttrs convert_ulong16_sat_rte(short16);
ulong16 __CVAttrs convert_ulong16_sat_rte(ushort16);
ulong16 __CVAttrs convert_ulong16_sat_rte(int16);
ulong16 __CVAttrs convert_ulong16_sat_rte(uint16);
ulong16 __CVAttrs convert_ulong16_sat_rte(long16);
ulong16 __CVAttrs convert_ulong16_sat_rte(ulong16);
ulong16 __CVAttrs convert_ulong16_sat_rte(float16);
ulong16 __CVAttrs convert_ulong16_sat_rte(double16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(char16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(uchar16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(short16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(ushort16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(int16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(uint16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(long16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(ulong16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(float16);
ulong16 __CVAttrs convert_ulong16_sat_rtz(double16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(char16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(uchar16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(short16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(ushort16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(int16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(uint16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(long16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(ulong16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(float16);
ulong16 __CVAttrs convert_ulong16_sat_rtp(double16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(char16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(uchar16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(short16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(ushort16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(int16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(uint16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(long16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(ulong16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(float16);
ulong16 __CVAttrs convert_ulong16_sat_rtn(double16);
float __CVAttrs convert_float(char);
float __CVAttrs convert_float(uchar);
float __CVAttrs convert_float(short);
float __CVAttrs convert_float(ushort);
float __CVAttrs convert_float(int);
float __CVAttrs convert_float(uint);
float __CVAttrs convert_float(long);
float __CVAttrs convert_float(ulong);
float __CVAttrs convert_float(float);
float __CVAttrs convert_float(double);
float __CVAttrs convert_float_rte(char);
float __CVAttrs convert_float_rte(uchar);
float __CVAttrs convert_float_rte(short);
float __CVAttrs convert_float_rte(ushort);
float __CVAttrs convert_float_rte(int);
float __CVAttrs convert_float_rte(uint);
float __CVAttrs convert_float_rte(long);
float __CVAttrs convert_float_rte(ulong);
float __CVAttrs convert_float_rte(float);
float __CVAttrs convert_float_rte(double);
float __CVAttrs convert_float_rtz(char);
float __CVAttrs convert_float_rtz(uchar);
float __CVAttrs convert_float_rtz(short);
float __CVAttrs convert_float_rtz(ushort);
float __CVAttrs convert_float_rtz(int);
float __CVAttrs convert_float_rtz(uint);
float __CVAttrs convert_float_rtz(long);
float __CVAttrs convert_float_rtz(ulong);
float __CVAttrs convert_float_rtz(float);
float __CVAttrs convert_float_rtz(double);
float __CVAttrs convert_float_rtp(char);
float __CVAttrs convert_float_rtp(uchar);
float __CVAttrs convert_float_rtp(short);
float __CVAttrs convert_float_rtp(ushort);
float __CVAttrs convert_float_rtp(int);
float __CVAttrs convert_float_rtp(uint);
float __CVAttrs convert_float_rtp(long);
float __CVAttrs convert_float_rtp(ulong);
float __CVAttrs convert_float_rtp(float);
float __CVAttrs convert_float_rtp(double);
float __CVAttrs convert_float_rtn(char);
float __CVAttrs convert_float_rtn(uchar);
float __CVAttrs convert_float_rtn(short);
float __CVAttrs convert_float_rtn(ushort);
float __CVAttrs convert_float_rtn(int);
float __CVAttrs convert_float_rtn(uint);
float __CVAttrs convert_float_rtn(long);
float __CVAttrs convert_float_rtn(ulong);
float __CVAttrs convert_float_rtn(float);
float __CVAttrs convert_float_rtn(double);
float2 __CVAttrs convert_float2(char2);
float2 __CVAttrs convert_float2(uchar2);
float2 __CVAttrs convert_float2(short2);
float2 __CVAttrs convert_float2(ushort2);
float2 __CVAttrs convert_float2(int2);
float2 __CVAttrs convert_float2(uint2);
float2 __CVAttrs convert_float2(long2);
float2 __CVAttrs convert_float2(ulong2);
float2 __CVAttrs convert_float2(float2);
float2 __CVAttrs convert_float2(double2);
float2 __CVAttrs convert_float2_rte(char2);
float2 __CVAttrs convert_float2_rte(uchar2);
float2 __CVAttrs convert_float2_rte(short2);
float2 __CVAttrs convert_float2_rte(ushort2);
float2 __CVAttrs convert_float2_rte(int2);
float2 __CVAttrs convert_float2_rte(uint2);
float2 __CVAttrs convert_float2_rte(long2);
float2 __CVAttrs convert_float2_rte(ulong2);
float2 __CVAttrs convert_float2_rte(float2);
float2 __CVAttrs convert_float2_rte(double2);
float2 __CVAttrs convert_float2_rtz(char2);
float2 __CVAttrs convert_float2_rtz(uchar2);
float2 __CVAttrs convert_float2_rtz(short2);
float2 __CVAttrs convert_float2_rtz(ushort2);
float2 __CVAttrs convert_float2_rtz(int2);
float2 __CVAttrs convert_float2_rtz(uint2);
float2 __CVAttrs convert_float2_rtz(long2);
float2 __CVAttrs convert_float2_rtz(ulong2);
float2 __CVAttrs convert_float2_rtz(float2);
float2 __CVAttrs convert_float2_rtz(double2);
float2 __CVAttrs convert_float2_rtp(char2);
float2 __CVAttrs convert_float2_rtp(uchar2);
float2 __CVAttrs convert_float2_rtp(short2);
float2 __CVAttrs convert_float2_rtp(ushort2);
float2 __CVAttrs convert_float2_rtp(int2);
float2 __CVAttrs convert_float2_rtp(uint2);
float2 __CVAttrs convert_float2_rtp(long2);
float2 __CVAttrs convert_float2_rtp(ulong2);
float2 __CVAttrs convert_float2_rtp(float2);
float2 __CVAttrs convert_float2_rtp(double2);
float2 __CVAttrs convert_float2_rtn(char2);
float2 __CVAttrs convert_float2_rtn(uchar2);
float2 __CVAttrs convert_float2_rtn(short2);
float2 __CVAttrs convert_float2_rtn(ushort2);
float2 __CVAttrs convert_float2_rtn(int2);
float2 __CVAttrs convert_float2_rtn(uint2);
float2 __CVAttrs convert_float2_rtn(long2);
float2 __CVAttrs convert_float2_rtn(ulong2);
float2 __CVAttrs convert_float2_rtn(float2);
float2 __CVAttrs convert_float2_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
float3 __CVAttrs convert_float3(char3);
float3 __CVAttrs convert_float3(uchar3);
float3 __CVAttrs convert_float3(short3);
float3 __CVAttrs convert_float3(ushort3);
float3 __CVAttrs convert_float3(int3);
float3 __CVAttrs convert_float3(uint3);
float3 __CVAttrs convert_float3(long3);
float3 __CVAttrs convert_float3(ulong3);
float3 __CVAttrs convert_float3(float3);
float3 __CVAttrs convert_float3(double3);
float3 __CVAttrs convert_float3_rte(char3);
float3 __CVAttrs convert_float3_rte(uchar3);
float3 __CVAttrs convert_float3_rte(short3);
float3 __CVAttrs convert_float3_rte(ushort3);
float3 __CVAttrs convert_float3_rte(int3);
float3 __CVAttrs convert_float3_rte(uint3);
float3 __CVAttrs convert_float3_rte(long3);
float3 __CVAttrs convert_float3_rte(ulong3);
float3 __CVAttrs convert_float3_rte(float3);
float3 __CVAttrs convert_float3_rte(double3);
float3 __CVAttrs convert_float3_rtz(char3);
float3 __CVAttrs convert_float3_rtz(uchar3);
float3 __CVAttrs convert_float3_rtz(short3);
float3 __CVAttrs convert_float3_rtz(ushort3);
float3 __CVAttrs convert_float3_rtz(int3);
float3 __CVAttrs convert_float3_rtz(uint3);
float3 __CVAttrs convert_float3_rtz(long3);
float3 __CVAttrs convert_float3_rtz(ulong3);
float3 __CVAttrs convert_float3_rtz(float3);
float3 __CVAttrs convert_float3_rtz(double3);
float3 __CVAttrs convert_float3_rtp(char3);
float3 __CVAttrs convert_float3_rtp(uchar3);
float3 __CVAttrs convert_float3_rtp(short3);
float3 __CVAttrs convert_float3_rtp(ushort3);
float3 __CVAttrs convert_float3_rtp(int3);
float3 __CVAttrs convert_float3_rtp(uint3);
float3 __CVAttrs convert_float3_rtp(long3);
float3 __CVAttrs convert_float3_rtp(ulong3);
float3 __CVAttrs convert_float3_rtp(float3);
float3 __CVAttrs convert_float3_rtp(double3);
float3 __CVAttrs convert_float3_rtn(char3);
float3 __CVAttrs convert_float3_rtn(uchar3);
float3 __CVAttrs convert_float3_rtn(short3);
float3 __CVAttrs convert_float3_rtn(ushort3);
float3 __CVAttrs convert_float3_rtn(int3);
float3 __CVAttrs convert_float3_rtn(uint3);
float3 __CVAttrs convert_float3_rtn(long3);
float3 __CVAttrs convert_float3_rtn(ulong3);
float3 __CVAttrs convert_float3_rtn(float3);
float3 __CVAttrs convert_float3_rtn(double3);
#endif
float4 __CVAttrs convert_float4(char4);
float4 __CVAttrs convert_float4(uchar4);
float4 __CVAttrs convert_float4(short4);
float4 __CVAttrs convert_float4(ushort4);
float4 __CVAttrs convert_float4(int4);
float4 __CVAttrs convert_float4(uint4);
float4 __CVAttrs convert_float4(long4);
float4 __CVAttrs convert_float4(ulong4);
float4 __CVAttrs convert_float4(float4);
float4 __CVAttrs convert_float4(double4);
float4 __CVAttrs convert_float4_rte(char4);
float4 __CVAttrs convert_float4_rte(uchar4);
float4 __CVAttrs convert_float4_rte(short4);
float4 __CVAttrs convert_float4_rte(ushort4);
float4 __CVAttrs convert_float4_rte(int4);
float4 __CVAttrs convert_float4_rte(uint4);
float4 __CVAttrs convert_float4_rte(long4);
float4 __CVAttrs convert_float4_rte(ulong4);
float4 __CVAttrs convert_float4_rte(float4);
float4 __CVAttrs convert_float4_rte(double4);
float4 __CVAttrs convert_float4_rtz(char4);
float4 __CVAttrs convert_float4_rtz(uchar4);
float4 __CVAttrs convert_float4_rtz(short4);
float4 __CVAttrs convert_float4_rtz(ushort4);
float4 __CVAttrs convert_float4_rtz(int4);
float4 __CVAttrs convert_float4_rtz(uint4);
float4 __CVAttrs convert_float4_rtz(long4);
float4 __CVAttrs convert_float4_rtz(ulong4);
float4 __CVAttrs convert_float4_rtz(float4);
float4 __CVAttrs convert_float4_rtz(double4);
float4 __CVAttrs convert_float4_rtp(char4);
float4 __CVAttrs convert_float4_rtp(uchar4);
float4 __CVAttrs convert_float4_rtp(short4);
float4 __CVAttrs convert_float4_rtp(ushort4);
float4 __CVAttrs convert_float4_rtp(int4);
float4 __CVAttrs convert_float4_rtp(uint4);
float4 __CVAttrs convert_float4_rtp(long4);
float4 __CVAttrs convert_float4_rtp(ulong4);
float4 __CVAttrs convert_float4_rtp(float4);
float4 __CVAttrs convert_float4_rtp(double4);
float4 __CVAttrs convert_float4_rtn(char4);
float4 __CVAttrs convert_float4_rtn(uchar4);
float4 __CVAttrs convert_float4_rtn(short4);
float4 __CVAttrs convert_float4_rtn(ushort4);
float4 __CVAttrs convert_float4_rtn(int4);
float4 __CVAttrs convert_float4_rtn(uint4);
float4 __CVAttrs convert_float4_rtn(long4);
float4 __CVAttrs convert_float4_rtn(ulong4);
float4 __CVAttrs convert_float4_rtn(float4);
float4 __CVAttrs convert_float4_rtn(double4);
float8 __CVAttrs convert_float8(char8);
float8 __CVAttrs convert_float8(uchar8);
float8 __CVAttrs convert_float8(short8);
float8 __CVAttrs convert_float8(ushort8);
float8 __CVAttrs convert_float8(int8);
float8 __CVAttrs convert_float8(uint8);
float8 __CVAttrs convert_float8(long8);
float8 __CVAttrs convert_float8(ulong8);
float8 __CVAttrs convert_float8(float8);
float8 __CVAttrs convert_float8(double8);
float8 __CVAttrs convert_float8_rte(char8);
float8 __CVAttrs convert_float8_rte(uchar8);
float8 __CVAttrs convert_float8_rte(short8);
float8 __CVAttrs convert_float8_rte(ushort8);
float8 __CVAttrs convert_float8_rte(int8);
float8 __CVAttrs convert_float8_rte(uint8);
float8 __CVAttrs convert_float8_rte(long8);
float8 __CVAttrs convert_float8_rte(ulong8);
float8 __CVAttrs convert_float8_rte(float8);
float8 __CVAttrs convert_float8_rte(double8);
float8 __CVAttrs convert_float8_rtz(char8);
float8 __CVAttrs convert_float8_rtz(uchar8);
float8 __CVAttrs convert_float8_rtz(short8);
float8 __CVAttrs convert_float8_rtz(ushort8);
float8 __CVAttrs convert_float8_rtz(int8);
float8 __CVAttrs convert_float8_rtz(uint8);
float8 __CVAttrs convert_float8_rtz(long8);
float8 __CVAttrs convert_float8_rtz(ulong8);
float8 __CVAttrs convert_float8_rtz(float8);
float8 __CVAttrs convert_float8_rtz(double8);
float8 __CVAttrs convert_float8_rtp(char8);
float8 __CVAttrs convert_float8_rtp(uchar8);
float8 __CVAttrs convert_float8_rtp(short8);
float8 __CVAttrs convert_float8_rtp(ushort8);
float8 __CVAttrs convert_float8_rtp(int8);
float8 __CVAttrs convert_float8_rtp(uint8);
float8 __CVAttrs convert_float8_rtp(long8);
float8 __CVAttrs convert_float8_rtp(ulong8);
float8 __CVAttrs convert_float8_rtp(float8);
float8 __CVAttrs convert_float8_rtp(double8);
float8 __CVAttrs convert_float8_rtn(char8);
float8 __CVAttrs convert_float8_rtn(uchar8);
float8 __CVAttrs convert_float8_rtn(short8);
float8 __CVAttrs convert_float8_rtn(ushort8);
float8 __CVAttrs convert_float8_rtn(int8);
float8 __CVAttrs convert_float8_rtn(uint8);
float8 __CVAttrs convert_float8_rtn(long8);
float8 __CVAttrs convert_float8_rtn(ulong8);
float8 __CVAttrs convert_float8_rtn(float8);
float8 __CVAttrs convert_float8_rtn(double8);
float16 __CVAttrs convert_float16(char16);
float16 __CVAttrs convert_float16(uchar16);
float16 __CVAttrs convert_float16(short16);
float16 __CVAttrs convert_float16(ushort16);
float16 __CVAttrs convert_float16(int16);
float16 __CVAttrs convert_float16(uint16);
float16 __CVAttrs convert_float16(long16);
float16 __CVAttrs convert_float16(ulong16);
float16 __CVAttrs convert_float16(float16);
float16 __CVAttrs convert_float16(double16);
float16 __CVAttrs convert_float16_rte(char16);
float16 __CVAttrs convert_float16_rte(uchar16);
float16 __CVAttrs convert_float16_rte(short16);
float16 __CVAttrs convert_float16_rte(ushort16);
float16 __CVAttrs convert_float16_rte(int16);
float16 __CVAttrs convert_float16_rte(uint16);
float16 __CVAttrs convert_float16_rte(long16);
float16 __CVAttrs convert_float16_rte(ulong16);
float16 __CVAttrs convert_float16_rte(float16);
float16 __CVAttrs convert_float16_rte(double16);
float16 __CVAttrs convert_float16_rtz(char16);
float16 __CVAttrs convert_float16_rtz(uchar16);
float16 __CVAttrs convert_float16_rtz(short16);
float16 __CVAttrs convert_float16_rtz(ushort16);
float16 __CVAttrs convert_float16_rtz(int16);
float16 __CVAttrs convert_float16_rtz(uint16);
float16 __CVAttrs convert_float16_rtz(long16);
float16 __CVAttrs convert_float16_rtz(ulong16);
float16 __CVAttrs convert_float16_rtz(float16);
float16 __CVAttrs convert_float16_rtz(double16);
float16 __CVAttrs convert_float16_rtp(char16);
float16 __CVAttrs convert_float16_rtp(uchar16);
float16 __CVAttrs convert_float16_rtp(short16);
float16 __CVAttrs convert_float16_rtp(ushort16);
float16 __CVAttrs convert_float16_rtp(int16);
float16 __CVAttrs convert_float16_rtp(uint16);
float16 __CVAttrs convert_float16_rtp(long16);
float16 __CVAttrs convert_float16_rtp(ulong16);
float16 __CVAttrs convert_float16_rtp(float16);
float16 __CVAttrs convert_float16_rtp(double16);
float16 __CVAttrs convert_float16_rtn(char16);
float16 __CVAttrs convert_float16_rtn(uchar16);
float16 __CVAttrs convert_float16_rtn(short16);
float16 __CVAttrs convert_float16_rtn(ushort16);
float16 __CVAttrs convert_float16_rtn(int16);
float16 __CVAttrs convert_float16_rtn(uint16);
float16 __CVAttrs convert_float16_rtn(long16);
float16 __CVAttrs convert_float16_rtn(ulong16);
float16 __CVAttrs convert_float16_rtn(float16);
float16 __CVAttrs convert_float16_rtn(double16);
double __CVAttrs convert_double(char);
double __CVAttrs convert_double(uchar);
double __CVAttrs convert_double(short);
double __CVAttrs convert_double(ushort);
double __CVAttrs convert_double(int);
double __CVAttrs convert_double(uint);
double __CVAttrs convert_double(long);
double __CVAttrs convert_double(ulong);
double __CVAttrs convert_double(float);
double __CVAttrs convert_double(double);
double __CVAttrs convert_double_rte(char);
double __CVAttrs convert_double_rte(uchar);
double __CVAttrs convert_double_rte(short);
double __CVAttrs convert_double_rte(ushort);
double __CVAttrs convert_double_rte(int);
double __CVAttrs convert_double_rte(uint);
double __CVAttrs convert_double_rte(long);
double __CVAttrs convert_double_rte(ulong);
double __CVAttrs convert_double_rte(float);
double __CVAttrs convert_double_rte(double);
double __CVAttrs convert_double_rtz(char);
double __CVAttrs convert_double_rtz(uchar);
double __CVAttrs convert_double_rtz(short);
double __CVAttrs convert_double_rtz(ushort);
double __CVAttrs convert_double_rtz(int);
double __CVAttrs convert_double_rtz(uint);
double __CVAttrs convert_double_rtz(long);
double __CVAttrs convert_double_rtz(ulong);
double __CVAttrs convert_double_rtz(float);
double __CVAttrs convert_double_rtz(double);
double __CVAttrs convert_double_rtp(char);
double __CVAttrs convert_double_rtp(uchar);
double __CVAttrs convert_double_rtp(short);
double __CVAttrs convert_double_rtp(ushort);
double __CVAttrs convert_double_rtp(int);
double __CVAttrs convert_double_rtp(uint);
double __CVAttrs convert_double_rtp(long);
double __CVAttrs convert_double_rtp(ulong);
double __CVAttrs convert_double_rtp(float);
double __CVAttrs convert_double_rtp(double);
double __CVAttrs convert_double_rtn(char);
double __CVAttrs convert_double_rtn(uchar);
double __CVAttrs convert_double_rtn(short);
double __CVAttrs convert_double_rtn(ushort);
double __CVAttrs convert_double_rtn(int);
double __CVAttrs convert_double_rtn(uint);
double __CVAttrs convert_double_rtn(long);
double __CVAttrs convert_double_rtn(ulong);
double __CVAttrs convert_double_rtn(float);
double __CVAttrs convert_double_rtn(double);
double2 __CVAttrs convert_double2(char2);
double2 __CVAttrs convert_double2(uchar2);
double2 __CVAttrs convert_double2(short2);
double2 __CVAttrs convert_double2(ushort2);
double2 __CVAttrs convert_double2(int2);
double2 __CVAttrs convert_double2(uint2);
double2 __CVAttrs convert_double2(long2);
double2 __CVAttrs convert_double2(ulong2);
double2 __CVAttrs convert_double2(float2);
double2 __CVAttrs convert_double2(double2);
double2 __CVAttrs convert_double2_rte(char2);
double2 __CVAttrs convert_double2_rte(uchar2);
double2 __CVAttrs convert_double2_rte(short2);
double2 __CVAttrs convert_double2_rte(ushort2);
double2 __CVAttrs convert_double2_rte(int2);
double2 __CVAttrs convert_double2_rte(uint2);
double2 __CVAttrs convert_double2_rte(long2);
double2 __CVAttrs convert_double2_rte(ulong2);
double2 __CVAttrs convert_double2_rte(float2);
double2 __CVAttrs convert_double2_rte(double2);
double2 __CVAttrs convert_double2_rtz(char2);
double2 __CVAttrs convert_double2_rtz(uchar2);
double2 __CVAttrs convert_double2_rtz(short2);
double2 __CVAttrs convert_double2_rtz(ushort2);
double2 __CVAttrs convert_double2_rtz(int2);
double2 __CVAttrs convert_double2_rtz(uint2);
double2 __CVAttrs convert_double2_rtz(long2);
double2 __CVAttrs convert_double2_rtz(ulong2);
double2 __CVAttrs convert_double2_rtz(float2);
double2 __CVAttrs convert_double2_rtz(double2);
double2 __CVAttrs convert_double2_rtp(char2);
double2 __CVAttrs convert_double2_rtp(uchar2);
double2 __CVAttrs convert_double2_rtp(short2);
double2 __CVAttrs convert_double2_rtp(ushort2);
double2 __CVAttrs convert_double2_rtp(int2);
double2 __CVAttrs convert_double2_rtp(uint2);
double2 __CVAttrs convert_double2_rtp(long2);
double2 __CVAttrs convert_double2_rtp(ulong2);
double2 __CVAttrs convert_double2_rtp(float2);
double2 __CVAttrs convert_double2_rtp(double2);
double2 __CVAttrs convert_double2_rtn(char2);
double2 __CVAttrs convert_double2_rtn(uchar2);
double2 __CVAttrs convert_double2_rtn(short2);
double2 __CVAttrs convert_double2_rtn(ushort2);
double2 __CVAttrs convert_double2_rtn(int2);
double2 __CVAttrs convert_double2_rtn(uint2);
double2 __CVAttrs convert_double2_rtn(long2);
double2 __CVAttrs convert_double2_rtn(ulong2);
double2 __CVAttrs convert_double2_rtn(float2);
double2 __CVAttrs convert_double2_rtn(double2);
#if __OPENCL_C_VERSION__ >= 110
double3 __CVAttrs convert_double3(char3);
double3 __CVAttrs convert_double3(uchar3);
double3 __CVAttrs convert_double3(short3);
double3 __CVAttrs convert_double3(ushort3);
double3 __CVAttrs convert_double3(int3);
double3 __CVAttrs convert_double3(uint3);
double3 __CVAttrs convert_double3(long3);
double3 __CVAttrs convert_double3(ulong3);
double3 __CVAttrs convert_double3(float3);
double3 __CVAttrs convert_double3(double3);
double3 __CVAttrs convert_double3_rte(char3);
double3 __CVAttrs convert_double3_rte(uchar3);
double3 __CVAttrs convert_double3_rte(short3);
double3 __CVAttrs convert_double3_rte(ushort3);
double3 __CVAttrs convert_double3_rte(int3);
double3 __CVAttrs convert_double3_rte(uint3);
double3 __CVAttrs convert_double3_rte(long3);
double3 __CVAttrs convert_double3_rte(ulong3);
double3 __CVAttrs convert_double3_rte(float3);
double3 __CVAttrs convert_double3_rte(double3);
double3 __CVAttrs convert_double3_rtz(char3);
double3 __CVAttrs convert_double3_rtz(uchar3);
double3 __CVAttrs convert_double3_rtz(short3);
double3 __CVAttrs convert_double3_rtz(ushort3);
double3 __CVAttrs convert_double3_rtz(int3);
double3 __CVAttrs convert_double3_rtz(uint3);
double3 __CVAttrs convert_double3_rtz(long3);
double3 __CVAttrs convert_double3_rtz(ulong3);
double3 __CVAttrs convert_double3_rtz(float3);
double3 __CVAttrs convert_double3_rtz(double3);
double3 __CVAttrs convert_double3_rtp(char3);
double3 __CVAttrs convert_double3_rtp(uchar3);
double3 __CVAttrs convert_double3_rtp(short3);
double3 __CVAttrs convert_double3_rtp(ushort3);
double3 __CVAttrs convert_double3_rtp(int3);
double3 __CVAttrs convert_double3_rtp(uint3);
double3 __CVAttrs convert_double3_rtp(long3);
double3 __CVAttrs convert_double3_rtp(ulong3);
double3 __CVAttrs convert_double3_rtp(float3);
double3 __CVAttrs convert_double3_rtp(double3);
double3 __CVAttrs convert_double3_rtn(char3);
double3 __CVAttrs convert_double3_rtn(uchar3);
double3 __CVAttrs convert_double3_rtn(short3);
double3 __CVAttrs convert_double3_rtn(ushort3);
double3 __CVAttrs convert_double3_rtn(int3);
double3 __CVAttrs convert_double3_rtn(uint3);
double3 __CVAttrs convert_double3_rtn(long3);
double3 __CVAttrs convert_double3_rtn(ulong3);
double3 __CVAttrs convert_double3_rtn(float3);
double3 __CVAttrs convert_double3_rtn(double3);
#endif
double4 __CVAttrs convert_double4(char4);
double4 __CVAttrs convert_double4(uchar4);
double4 __CVAttrs convert_double4(short4);
double4 __CVAttrs convert_double4(ushort4);
double4 __CVAttrs convert_double4(int4);
double4 __CVAttrs convert_double4(uint4);
double4 __CVAttrs convert_double4(long4);
double4 __CVAttrs convert_double4(ulong4);
double4 __CVAttrs convert_double4(float4);
double4 __CVAttrs convert_double4(double4);
double4 __CVAttrs convert_double4_rte(char4);
double4 __CVAttrs convert_double4_rte(uchar4);
double4 __CVAttrs convert_double4_rte(short4);
double4 __CVAttrs convert_double4_rte(ushort4);
double4 __CVAttrs convert_double4_rte(int4);
double4 __CVAttrs convert_double4_rte(uint4);
double4 __CVAttrs convert_double4_rte(long4);
double4 __CVAttrs convert_double4_rte(ulong4);
double4 __CVAttrs convert_double4_rte(float4);
double4 __CVAttrs convert_double4_rte(double4);
double4 __CVAttrs convert_double4_rtz(char4);
double4 __CVAttrs convert_double4_rtz(uchar4);
double4 __CVAttrs convert_double4_rtz(short4);
double4 __CVAttrs convert_double4_rtz(ushort4);
double4 __CVAttrs convert_double4_rtz(int4);
double4 __CVAttrs convert_double4_rtz(uint4);
double4 __CVAttrs convert_double4_rtz(long4);
double4 __CVAttrs convert_double4_rtz(ulong4);
double4 __CVAttrs convert_double4_rtz(float4);
double4 __CVAttrs convert_double4_rtz(double4);
double4 __CVAttrs convert_double4_rtp(char4);
double4 __CVAttrs convert_double4_rtp(uchar4);
double4 __CVAttrs convert_double4_rtp(short4);
double4 __CVAttrs convert_double4_rtp(ushort4);
double4 __CVAttrs convert_double4_rtp(int4);
double4 __CVAttrs convert_double4_rtp(uint4);
double4 __CVAttrs convert_double4_rtp(long4);
double4 __CVAttrs convert_double4_rtp(ulong4);
double4 __CVAttrs convert_double4_rtp(float4);
double4 __CVAttrs convert_double4_rtp(double4);
double4 __CVAttrs convert_double4_rtn(char4);
double4 __CVAttrs convert_double4_rtn(uchar4);
double4 __CVAttrs convert_double4_rtn(short4);
double4 __CVAttrs convert_double4_rtn(ushort4);
double4 __CVAttrs convert_double4_rtn(int4);
double4 __CVAttrs convert_double4_rtn(uint4);
double4 __CVAttrs convert_double4_rtn(long4);
double4 __CVAttrs convert_double4_rtn(ulong4);
double4 __CVAttrs convert_double4_rtn(float4);
double4 __CVAttrs convert_double4_rtn(double4);
double8 __CVAttrs convert_double8(char8);
double8 __CVAttrs convert_double8(uchar8);
double8 __CVAttrs convert_double8(short8);
double8 __CVAttrs convert_double8(ushort8);
double8 __CVAttrs convert_double8(int8);
double8 __CVAttrs convert_double8(uint8);
double8 __CVAttrs convert_double8(long8);
double8 __CVAttrs convert_double8(ulong8);
double8 __CVAttrs convert_double8(float8);
double8 __CVAttrs convert_double8(double8);
double8 __CVAttrs convert_double8_rte(char8);
double8 __CVAttrs convert_double8_rte(uchar8);
double8 __CVAttrs convert_double8_rte(short8);
double8 __CVAttrs convert_double8_rte(ushort8);
double8 __CVAttrs convert_double8_rte(int8);
double8 __CVAttrs convert_double8_rte(uint8);
double8 __CVAttrs convert_double8_rte(long8);
double8 __CVAttrs convert_double8_rte(ulong8);
double8 __CVAttrs convert_double8_rte(float8);
double8 __CVAttrs convert_double8_rte(double8);
double8 __CVAttrs convert_double8_rtz(char8);
double8 __CVAttrs convert_double8_rtz(uchar8);
double8 __CVAttrs convert_double8_rtz(short8);
double8 __CVAttrs convert_double8_rtz(ushort8);
double8 __CVAttrs convert_double8_rtz(int8);
double8 __CVAttrs convert_double8_rtz(uint8);
double8 __CVAttrs convert_double8_rtz(long8);
double8 __CVAttrs convert_double8_rtz(ulong8);
double8 __CVAttrs convert_double8_rtz(float8);
double8 __CVAttrs convert_double8_rtz(double8);
double8 __CVAttrs convert_double8_rtp(char8);
double8 __CVAttrs convert_double8_rtp(uchar8);
double8 __CVAttrs convert_double8_rtp(short8);
double8 __CVAttrs convert_double8_rtp(ushort8);
double8 __CVAttrs convert_double8_rtp(int8);
double8 __CVAttrs convert_double8_rtp(uint8);
double8 __CVAttrs convert_double8_rtp(long8);
double8 __CVAttrs convert_double8_rtp(ulong8);
double8 __CVAttrs convert_double8_rtp(float8);
double8 __CVAttrs convert_double8_rtp(double8);
double8 __CVAttrs convert_double8_rtn(char8);
double8 __CVAttrs convert_double8_rtn(uchar8);
double8 __CVAttrs convert_double8_rtn(short8);
double8 __CVAttrs convert_double8_rtn(ushort8);
double8 __CVAttrs convert_double8_rtn(int8);
double8 __CVAttrs convert_double8_rtn(uint8);
double8 __CVAttrs convert_double8_rtn(long8);
double8 __CVAttrs convert_double8_rtn(ulong8);
double8 __CVAttrs convert_double8_rtn(float8);
double8 __CVAttrs convert_double8_rtn(double8);
double16 __CVAttrs convert_double16(char16);
double16 __CVAttrs convert_double16(uchar16);
double16 __CVAttrs convert_double16(short16);
double16 __CVAttrs convert_double16(ushort16);
double16 __CVAttrs convert_double16(int16);
double16 __CVAttrs convert_double16(uint16);
double16 __CVAttrs convert_double16(long16);
double16 __CVAttrs convert_double16(ulong16);
double16 __CVAttrs convert_double16(float16);
double16 __CVAttrs convert_double16(double16);
double16 __CVAttrs convert_double16_rte(char16);
double16 __CVAttrs convert_double16_rte(uchar16);
double16 __CVAttrs convert_double16_rte(short16);
double16 __CVAttrs convert_double16_rte(ushort16);
double16 __CVAttrs convert_double16_rte(int16);
double16 __CVAttrs convert_double16_rte(uint16);
double16 __CVAttrs convert_double16_rte(long16);
double16 __CVAttrs convert_double16_rte(ulong16);
double16 __CVAttrs convert_double16_rte(float16);
double16 __CVAttrs convert_double16_rte(double16);
double16 __CVAttrs convert_double16_rtz(char16);
double16 __CVAttrs convert_double16_rtz(uchar16);
double16 __CVAttrs convert_double16_rtz(short16);
double16 __CVAttrs convert_double16_rtz(ushort16);
double16 __CVAttrs convert_double16_rtz(int16);
double16 __CVAttrs convert_double16_rtz(uint16);
double16 __CVAttrs convert_double16_rtz(long16);
double16 __CVAttrs convert_double16_rtz(ulong16);
double16 __CVAttrs convert_double16_rtz(float16);
double16 __CVAttrs convert_double16_rtz(double16);
double16 __CVAttrs convert_double16_rtp(char16);
double16 __CVAttrs convert_double16_rtp(uchar16);
double16 __CVAttrs convert_double16_rtp(short16);
double16 __CVAttrs convert_double16_rtp(ushort16);
double16 __CVAttrs convert_double16_rtp(int16);
double16 __CVAttrs convert_double16_rtp(uint16);
double16 __CVAttrs convert_double16_rtp(long16);
double16 __CVAttrs convert_double16_rtp(ulong16);
double16 __CVAttrs convert_double16_rtp(float16);
double16 __CVAttrs convert_double16_rtp(double16);
double16 __CVAttrs convert_double16_rtn(char16);
double16 __CVAttrs convert_double16_rtn(uchar16);
double16 __CVAttrs convert_double16_rtn(short16);
double16 __CVAttrs convert_double16_rtn(ushort16);
double16 __CVAttrs convert_double16_rtn(int16);
double16 __CVAttrs convert_double16_rtn(uint16);
double16 __CVAttrs convert_double16_rtn(long16);
double16 __CVAttrs convert_double16_rtn(ulong16);
double16 __CVAttrs convert_double16_rtn(float16);
double16 __CVAttrs convert_double16_rtn(double16);
#undef __CVAttrs

bool  __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(float x);
inline int  __attribute__((__overloadable__,__always_inline__,const)) isnan(float x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) isnan(float x ){ return (int )(__spirv_IsNan(x)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(float2 x);
inline int2 __attribute__((__overloadable__,__always_inline__,const)) isnan(float2 x );
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) isnan(float2 x ){ return convert_int2(__spirv_IsNan(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(float3 x);
inline int3 __attribute__((__overloadable__,__always_inline__,const)) isnan(float3 x );
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) isnan(float3 x ){ return convert_int3(__spirv_IsNan(x)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(float4 x);
inline int4 __attribute__((__overloadable__,__always_inline__,const)) isnan(float4 x );
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) isnan(float4 x ){ return convert_int4(__spirv_IsNan(x)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(float8 x);
inline int8 __attribute__((__overloadable__,__always_inline__,const)) isnan(float8 x );
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) isnan(float8 x ){ return convert_int8(__spirv_IsNan(x)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(float16 x);
inline int16 __attribute__((__overloadable__,__always_inline__,const)) isnan(float16 x );
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) isnan(float16 x ){ return convert_int16(__spirv_IsNan(x)); }
#endif
bool  __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(double x);
inline int  __attribute__((__overloadable__,__always_inline__,const)) isnan(double x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) isnan(double x ){ return (int )(__spirv_IsNan(x)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(double2 x);
inline long2 __attribute__((__overloadable__,__always_inline__,const)) isnan(double2 x );
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,__always_inline__,const)) isnan(double2 x ){ return convert_long2(__spirv_IsNan(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(double3 x);
inline long3 __attribute__((__overloadable__,__always_inline__,const)) isnan(double3 x );
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,__always_inline__,const)) isnan(double3 x ){ return convert_long3(__spirv_IsNan(x)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(double4 x);
inline long4 __attribute__((__overloadable__,__always_inline__,const)) isnan(double4 x );
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,__always_inline__,const)) isnan(double4 x ){ return convert_long4(__spirv_IsNan(x)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(double8 x);
inline long8 __attribute__((__overloadable__,__always_inline__,const)) isnan(double8 x );
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,__always_inline__,const)) isnan(double8 x ){ return convert_long8(__spirv_IsNan(x)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsNan(double16 x);
inline long16 __attribute__((__overloadable__,__always_inline__,const)) isnan(double16 x );
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,__always_inline__,const)) isnan(double16 x ){ return convert_long16(__spirv_IsNan(x)); }
#endif
bool  __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(float x);
inline int  __attribute__((__overloadable__,__always_inline__,const)) isinf(float x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) isinf(float x ){ return (int )(__spirv_IsInf(x)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(float2 x);
inline int2 __attribute__((__overloadable__,__always_inline__,const)) isinf(float2 x );
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) isinf(float2 x ){ return convert_int2(__spirv_IsInf(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(float3 x);
inline int3 __attribute__((__overloadable__,__always_inline__,const)) isinf(float3 x );
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) isinf(float3 x ){ return convert_int3(__spirv_IsInf(x)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(float4 x);
inline int4 __attribute__((__overloadable__,__always_inline__,const)) isinf(float4 x );
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) isinf(float4 x ){ return convert_int4(__spirv_IsInf(x)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(float8 x);
inline int8 __attribute__((__overloadable__,__always_inline__,const)) isinf(float8 x );
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) isinf(float8 x ){ return convert_int8(__spirv_IsInf(x)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(float16 x);
inline int16 __attribute__((__overloadable__,__always_inline__,const)) isinf(float16 x );
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) isinf(float16 x ){ return convert_int16(__spirv_IsInf(x)); }
#endif
bool  __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(double x);
inline int  __attribute__((__overloadable__,__always_inline__,const)) isinf(double x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) isinf(double x ){ return (int )(__spirv_IsInf(x)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(double2 x);
inline long2 __attribute__((__overloadable__,__always_inline__,const)) isinf(double2 x );
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,__always_inline__,const)) isinf(double2 x ){ return convert_long2(__spirv_IsInf(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(double3 x);
inline long3 __attribute__((__overloadable__,__always_inline__,const)) isinf(double3 x );
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,__always_inline__,const)) isinf(double3 x ){ return convert_long3(__spirv_IsInf(x)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(double4 x);
inline long4 __attribute__((__overloadable__,__always_inline__,const)) isinf(double4 x );
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,__always_inline__,const)) isinf(double4 x ){ return convert_long4(__spirv_IsInf(x)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(double8 x);
inline long8 __attribute__((__overloadable__,__always_inline__,const)) isinf(double8 x );
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,__always_inline__,const)) isinf(double8 x ){ return convert_long8(__spirv_IsInf(x)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsInf(double16 x);
inline long16 __attribute__((__overloadable__,__always_inline__,const)) isinf(double16 x );
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,__always_inline__,const)) isinf(double16 x ){ return convert_long16(__spirv_IsInf(x)); }
#endif
bool  __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(float x);
inline int  __attribute__((__overloadable__,__always_inline__,const)) isfinite(float x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) isfinite(float x ){ return (int )(__spirv_IsFinite(x)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(float2 x);
inline int2 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float2 x );
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float2 x ){ return convert_int2(__spirv_IsFinite(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(float3 x);
inline int3 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float3 x );
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float3 x ){ return convert_int3(__spirv_IsFinite(x)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(float4 x);
inline int4 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float4 x );
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float4 x ){ return convert_int4(__spirv_IsFinite(x)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(float8 x);
inline int8 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float8 x );
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float8 x ){ return convert_int8(__spirv_IsFinite(x)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(float16 x);
inline int16 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float16 x );
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) isfinite(float16 x ){ return convert_int16(__spirv_IsFinite(x)); }
#endif
bool  __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(double x);
inline int  __attribute__((__overloadable__,__always_inline__,const)) isfinite(double x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) isfinite(double x ){ return (int )(__spirv_IsFinite(x)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(double2 x);
inline long2 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double2 x );
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double2 x ){ return convert_long2(__spirv_IsFinite(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(double3 x);
inline long3 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double3 x );
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double3 x ){ return convert_long3(__spirv_IsFinite(x)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(double4 x);
inline long4 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double4 x );
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double4 x ){ return convert_long4(__spirv_IsFinite(x)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(double8 x);
inline long8 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double8 x );
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double8 x ){ return convert_long8(__spirv_IsFinite(x)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_IsFinite(double16 x);
inline long16 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double16 x );
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,__always_inline__,const)) isfinite(double16 x ){ return convert_long16(__spirv_IsFinite(x)); }
#endif
float  __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(float x );
inline float __attribute__((__overloadable__,__always_inline__,const)) logb(float x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) logb(float x ){ return (float)(__spirv_ocl_logb(x)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(float2 x );
inline float2 __attribute__((__overloadable__,__always_inline__,const)) logb(float2 x );
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) logb(float2 x ){ return (float2)(__spirv_ocl_logb(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(float3 x );
inline float3 __attribute__((__overloadable__,__always_inline__,const)) logb(float3 x );
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) logb(float3 x ){ return (float3)(__spirv_ocl_logb(x)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(float4 x );
inline float4 __attribute__((__overloadable__,__always_inline__,const)) logb(float4 x );
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) logb(float4 x ){ return (float4)(__spirv_ocl_logb(x)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(float8 x );
inline float8 __attribute__((__overloadable__,__always_inline__,const)) logb(float8 x );
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__,const)) logb(float8 x ){ return (float8)(__spirv_ocl_logb(x)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(float16 x );
inline float16 __attribute__((__overloadable__,__always_inline__,const)) logb(float16 x );
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__,const)) logb(float16 x ){ return (float16)(__spirv_ocl_logb(x)); }
#endif
double  __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(double x );
inline double __attribute__((__overloadable__,__always_inline__,const)) logb(double x );
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) logb(double x ){ return (double)(__spirv_ocl_logb(x)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(double2 x );
inline double2 __attribute__((__overloadable__,__always_inline__,const)) logb(double2 x );
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) logb(double2 x ){ return (double2)(__spirv_ocl_logb(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(double3 x );
inline double3 __attribute__((__overloadable__,__always_inline__,const)) logb(double3 x );
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) logb(double3 x ){ return (double3)(__spirv_ocl_logb(x)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(double4 x );
inline double4 __attribute__((__overloadable__,__always_inline__,const)) logb(double4 x );
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) logb(double4 x ){ return (double4)(__spirv_ocl_logb(x)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(double8 x );
inline double8 __attribute__((__overloadable__,__always_inline__,const)) logb(double8 x );
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__,const)) logb(double8 x ){ return (double8)(__spirv_ocl_logb(x)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_logb(double16 x );
inline double16 __attribute__((__overloadable__,__always_inline__,const)) logb(double16 x );
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__,const)) logb(double16 x ){ return (double16)(__spirv_ocl_logb(x)); }
#endif
int  __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(float x);
inline int  __attribute__((__overloadable__,__always_inline__,const)) ilogb(float x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) ilogb(float x ){ return (int )(__spirv_ocl_ilogb(x)); }
#endif
int2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(float2 x );
inline int2 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float2 x );
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float2 x ){ return (int2)(__spirv_ocl_ilogb(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
int3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(float3 x );
inline int3 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float3 x );
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float3 x ){ return (int3)(__spirv_ocl_ilogb(x)); }
#endif
#endif
int4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(float4 x );
inline int4 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float4 x );
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float4 x ){ return (int4)(__spirv_ocl_ilogb(x)); }
#endif
int8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(float8 x );
inline int8 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float8 x );
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float8 x ){ return (int8)(__spirv_ocl_ilogb(x)); }
#endif
int16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(float16 x );
inline int16 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float16 x );
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) ilogb(float16 x ){ return (int16)(__spirv_ocl_ilogb(x)); }
#endif
int  __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(double x);
inline int  __attribute__((__overloadable__,__always_inline__,const)) ilogb(double x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) ilogb(double x ){ return (int )(__spirv_ocl_ilogb(x)); }
#endif
int2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(double2 x );
inline int2 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double2 x );
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double2 x ){ return (int2)(__spirv_ocl_ilogb(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
int3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(double3 x );
inline int3 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double3 x );
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double3 x ){ return (int3)(__spirv_ocl_ilogb(x)); }
#endif
#endif
int4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(double4 x );
inline int4 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double4 x );
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double4 x ){ return (int4)(__spirv_ocl_ilogb(x)); }
#endif
int8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(double8 x );
inline int8 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double8 x );
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double8 x ){ return (int8)(__spirv_ocl_ilogb(x)); }
#endif
int16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_ilogb(double16 x );
inline int16 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double16 x );
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) ilogb(double16 x ){ return (int16)(__spirv_ocl_ilogb(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(int x);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) nan(uint x);
inline float __attribute__((__overloadable__,__always_inline__,const)) nan(uint x){  int mask = x & 0x003fffff;
 int exp_mask = 0x7fC00000;
 return (as_float(mask | exp_mask));
 }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(int2 x );
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) nan(uint2 x );
inline float2 __attribute__((__overloadable__,__always_inline__,const)) nan(uint2 x ){  float2 nan_val;
 int2 mask;
 int2 exp_mask;
 mask.s0 = x.s0 & 0x003fffff;
 exp_mask.s0 = 0x7fC00000;
 nan_val.s0 = as_float(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x003fffff;
 exp_mask.s1 = 0x7fC00000;
 nan_val.s1 = as_float(mask.s1 | exp_mask.s1);
 return nan_val;
 }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(int3 x );
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) nan(uint3 x );
inline float3 __attribute__((__overloadable__,__always_inline__,const)) nan(uint3 x ){  float3 nan_val;
 int3 mask;
 int3 exp_mask;
 mask.s0 = x.s0 & 0x003fffff;
 exp_mask.s0 = 0x7fC00000;
 nan_val.s0 = as_float(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x003fffff;
 exp_mask.s1 = 0x7fC00000;
 nan_val.s1 = as_float(mask.s1 | exp_mask.s1);
 mask.s2 = x.s2 & 0x003fffff;
 exp_mask.s2 = 0x7fC00000;
 nan_val.s2 = as_float(mask.s2 | exp_mask.s2);
 return nan_val;
 }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(int4 x );
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) nan(uint4 x );
inline float4 __attribute__((__overloadable__,__always_inline__,const)) nan(uint4 x ){  float4 nan_val;
 int4 mask;
 int4 exp_mask;
 mask.s0 = x.s0 & 0x003fffff;
 exp_mask.s0 = 0x7fC00000;
 nan_val.s0 = as_float(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x003fffff;
 exp_mask.s1 = 0x7fC00000;
 nan_val.s1 = as_float(mask.s1 | exp_mask.s1);
 mask.s2 = x.s2 & 0x003fffff;
 exp_mask.s2 = 0x7fC00000;
 nan_val.s2 = as_float(mask.s2 | exp_mask.s2);
 mask.s3 = x.s3 & 0x003fffff;
 exp_mask.s3 = 0x7fC00000;
 nan_val.s3 = as_float(mask.s3 | exp_mask.s3);
 return nan_val;
 }
#endif
float8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(int8 x );
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__,const)) nan(uint8 x );
inline float8 __attribute__((__overloadable__,__always_inline__,const)) nan(uint8 x ){  float8 nan_val;
 int8 mask;
 int8 exp_mask;
 mask.s0 = x.s0 & 0x003fffff;
 exp_mask.s0 = 0x7fC00000;
 nan_val.s0 = as_float(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x003fffff;
 exp_mask.s1 = 0x7fC00000;
 nan_val.s1 = as_float(mask.s1 | exp_mask.s1);
 mask.s2 = x.s2 & 0x003fffff;
 exp_mask.s2 = 0x7fC00000;
 nan_val.s2 = as_float(mask.s2 | exp_mask.s2);
 mask.s3 = x.s3 & 0x003fffff;
 exp_mask.s3 = 0x7fC00000;
 nan_val.s3 = as_float(mask.s3 | exp_mask.s3);
 mask.s4 = x.s4 & 0x003fffff;
 exp_mask.s4 = 0x7fC00000;
 nan_val.s4 = as_float(mask.s4 | exp_mask.s4);
 mask.s5 = x.s5 & 0x003fffff;
 exp_mask.s5 = 0x7fC00000;
 nan_val.s5 = as_float(mask.s5 | exp_mask.s5);
 mask.s6 = x.s6 & 0x003fffff;
 exp_mask.s6 = 0x7fC00000;
 nan_val.s6 = as_float(mask.s6 | exp_mask.s6);
 mask.s7 = x.s7 & 0x003fffff;
 exp_mask.s7 = 0x7fC00000;
 nan_val.s7 = as_float(mask.s7 | exp_mask.s7);
 return nan_val;
 }
#endif
float16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(int16 x );
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__,const)) nan(uint16 x );
inline float16 __attribute__((__overloadable__,__always_inline__,const)) nan(uint16 x ){  float16 nan_val;
 int16 mask;
 int16 exp_mask;
 mask.s0 = x.s0 & 0x003fffff;
 exp_mask.s0 = 0x7fC00000;
 nan_val.s0 = as_float(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x003fffff;
 exp_mask.s1 = 0x7fC00000;
 nan_val.s1 = as_float(mask.s1 | exp_mask.s1);
 mask.s2 = x.s2 & 0x003fffff;
 exp_mask.s2 = 0x7fC00000;
 nan_val.s2 = as_float(mask.s2 | exp_mask.s2);
 mask.s3 = x.s3 & 0x003fffff;
 exp_mask.s3 = 0x7fC00000;
 nan_val.s3 = as_float(mask.s3 | exp_mask.s3);
 mask.s4 = x.s4 & 0x003fffff;
 exp_mask.s4 = 0x7fC00000;
 nan_val.s4 = as_float(mask.s4 | exp_mask.s4);
 mask.s5 = x.s5 & 0x003fffff;
 exp_mask.s5 = 0x7fC00000;
 nan_val.s5 = as_float(mask.s5 | exp_mask.s5);
 mask.s6 = x.s6 & 0x003fffff;
 exp_mask.s6 = 0x7fC00000;
 nan_val.s6 = as_float(mask.s6 | exp_mask.s6);
 mask.s7 = x.s7 & 0x003fffff;
 exp_mask.s7 = 0x7fC00000;
 nan_val.s7 = as_float(mask.s7 | exp_mask.s7);
 mask.s8 = x.s8 & 0x003fffff;
 exp_mask.s8 = 0x7fC00000;
 nan_val.s8 = as_float(mask.s8 | exp_mask.s8);
 mask.s9 = x.s9 & 0x003fffff;
 exp_mask.s9 = 0x7fC00000;
 nan_val.s9 = as_float(mask.s9 | exp_mask.s9);
 mask.sa = x.sa & 0x003fffff;
 exp_mask.sa = 0x7fC00000;
 nan_val.sa = as_float(mask.sa | exp_mask.sa);
 mask.sb = x.sb & 0x003fffff;
 exp_mask.sb = 0x7fC00000;
 nan_val.sb = as_float(mask.sb | exp_mask.sb);
 mask.sc = x.sc & 0x003fffff;
 exp_mask.sc = 0x7fC00000;
 nan_val.sc = as_float(mask.sc | exp_mask.sc);
 mask.sd = x.sd & 0x003fffff;
 exp_mask.sd = 0x7fC00000;
 nan_val.sd = as_float(mask.sd | exp_mask.sd);
 mask.se = x.se & 0x003fffff;
 exp_mask.se = 0x7fC00000;
 nan_val.se = as_float(mask.se | exp_mask.se);
 mask.sf = x.sf & 0x003fffff;
 exp_mask.sf = 0x7fC00000;
 nan_val.sf = as_float(mask.sf | exp_mask.sf);
 return nan_val;
 }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(long x);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) nan(ulong x);
inline double __attribute__((__overloadable__,__always_inline__,const)) nan(ulong x){  long mask = x & 0x0007ffffffffffffULL;
 long exp_mask = 0x7ff8000000000000ULL;
 return (as_double(mask | exp_mask));
 }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(long2 x );
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong2 x );
inline double2 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong2 x ){  double2 nan_val;
 long2 mask;
 long2 exp_mask;
 mask.s0 = x.s0 & 0x0007ffffffffffffULL;
 exp_mask.s0 = 0x7ff8000000000000ULL;
 nan_val.s0 = as_double(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x0007ffffffffffffULL;
 exp_mask.s1 = 0x7ff8000000000000ULL;
 nan_val.s1 = as_double(mask.s1 | exp_mask.s1);
 return nan_val;
 }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(long3 x );
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong3 x );
inline double3 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong3 x ){  double3 nan_val;
 long3 mask;
 long3 exp_mask;
 mask.s0 = x.s0 & 0x0007ffffffffffffULL;
 exp_mask.s0 = 0x7ff8000000000000ULL;
 nan_val.s0 = as_double(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x0007ffffffffffffULL;
 exp_mask.s1 = 0x7ff8000000000000ULL;
 nan_val.s1 = as_double(mask.s1 | exp_mask.s1);
 mask.s2 = x.s2 & 0x0007ffffffffffffULL;
 exp_mask.s2 = 0x7ff8000000000000ULL;
 nan_val.s2 = as_double(mask.s2 | exp_mask.s2);
 return nan_val;
 }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(long4 x );
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong4 x );
inline double4 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong4 x ){  double4 nan_val;
 long4 mask;
 long4 exp_mask;
 mask.s0 = x.s0 & 0x0007ffffffffffffULL;
 exp_mask.s0 = 0x7ff8000000000000ULL;
 nan_val.s0 = as_double(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x0007ffffffffffffULL;
 exp_mask.s1 = 0x7ff8000000000000ULL;
 nan_val.s1 = as_double(mask.s1 | exp_mask.s1);
 mask.s2 = x.s2 & 0x0007ffffffffffffULL;
 exp_mask.s2 = 0x7ff8000000000000ULL;
 nan_val.s2 = as_double(mask.s2 | exp_mask.s2);
 mask.s3 = x.s3 & 0x0007ffffffffffffULL;
 exp_mask.s3 = 0x7ff8000000000000ULL;
 nan_val.s3 = as_double(mask.s3 | exp_mask.s3);
 return nan_val;
 }
#endif
double8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(long8 x );
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong8 x );
inline double8 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong8 x ){  double8 nan_val;
 long8 mask;
 long8 exp_mask;
 mask.s0 = x.s0 & 0x0007ffffffffffffULL;
 exp_mask.s0 = 0x7ff8000000000000ULL;
 nan_val.s0 = as_double(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x0007ffffffffffffULL;
 exp_mask.s1 = 0x7ff8000000000000ULL;
 nan_val.s1 = as_double(mask.s1 | exp_mask.s1);
 mask.s2 = x.s2 & 0x0007ffffffffffffULL;
 exp_mask.s2 = 0x7ff8000000000000ULL;
 nan_val.s2 = as_double(mask.s2 | exp_mask.s2);
 mask.s3 = x.s3 & 0x0007ffffffffffffULL;
 exp_mask.s3 = 0x7ff8000000000000ULL;
 nan_val.s3 = as_double(mask.s3 | exp_mask.s3);
 mask.s4 = x.s4 & 0x0007ffffffffffffULL;
 exp_mask.s4 = 0x7ff8000000000000ULL;
 nan_val.s4 = as_double(mask.s4 | exp_mask.s4);
 mask.s5 = x.s5 & 0x0007ffffffffffffULL;
 exp_mask.s5 = 0x7ff8000000000000ULL;
 nan_val.s5 = as_double(mask.s5 | exp_mask.s5);
 mask.s6 = x.s6 & 0x0007ffffffffffffULL;
 exp_mask.s6 = 0x7ff8000000000000ULL;
 nan_val.s6 = as_double(mask.s6 | exp_mask.s6);
 mask.s7 = x.s7 & 0x0007ffffffffffffULL;
 exp_mask.s7 = 0x7ff8000000000000ULL;
 nan_val.s7 = as_double(mask.s7 | exp_mask.s7);
 return nan_val;
 }
#endif
double16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_nan(long16 x );
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong16 x );
inline double16 __attribute__((__overloadable__,__always_inline__,const)) nan(ulong16 x ){  double16 nan_val;
 long16 mask;
 long16 exp_mask;
 mask.s0 = x.s0 & 0x0007ffffffffffffULL;
 exp_mask.s0 = 0x7ff8000000000000ULL;
 nan_val.s0 = as_double(mask.s0 | exp_mask.s0);
 mask.s1 = x.s1 & 0x0007ffffffffffffULL;
 exp_mask.s1 = 0x7ff8000000000000ULL;
 nan_val.s1 = as_double(mask.s1 | exp_mask.s1);
 mask.s2 = x.s2 & 0x0007ffffffffffffULL;
 exp_mask.s2 = 0x7ff8000000000000ULL;
 nan_val.s2 = as_double(mask.s2 | exp_mask.s2);
 mask.s3 = x.s3 & 0x0007ffffffffffffULL;
 exp_mask.s3 = 0x7ff8000000000000ULL;
 nan_val.s3 = as_double(mask.s3 | exp_mask.s3);
 mask.s4 = x.s4 & 0x0007ffffffffffffULL;
 exp_mask.s4 = 0x7ff8000000000000ULL;
 nan_val.s4 = as_double(mask.s4 | exp_mask.s4);
 mask.s5 = x.s5 & 0x0007ffffffffffffULL;
 exp_mask.s5 = 0x7ff8000000000000ULL;
 nan_val.s5 = as_double(mask.s5 | exp_mask.s5);
 mask.s6 = x.s6 & 0x0007ffffffffffffULL;
 exp_mask.s6 = 0x7ff8000000000000ULL;
 nan_val.s6 = as_double(mask.s6 | exp_mask.s6);
 mask.s7 = x.s7 & 0x0007ffffffffffffULL;
 exp_mask.s7 = 0x7ff8000000000000ULL;
 nan_val.s7 = as_double(mask.s7 | exp_mask.s7);
 mask.s8 = x.s8 & 0x0007ffffffffffffULL;
 exp_mask.s8 = 0x7ff8000000000000ULL;
 nan_val.s8 = as_double(mask.s8 | exp_mask.s8);
 mask.s9 = x.s9 & 0x0007ffffffffffffULL;
 exp_mask.s9 = 0x7ff8000000000000ULL;
 nan_val.s9 = as_double(mask.s9 | exp_mask.s9);
 mask.sa = x.sa & 0x0007ffffffffffffULL;
 exp_mask.sa = 0x7ff8000000000000ULL;
 nan_val.sa = as_double(mask.sa | exp_mask.sa);
 mask.sb = x.sb & 0x0007ffffffffffffULL;
 exp_mask.sb = 0x7ff8000000000000ULL;
 nan_val.sb = as_double(mask.sb | exp_mask.sb);
 mask.sc = x.sc & 0x0007ffffffffffffULL;
 exp_mask.sc = 0x7ff8000000000000ULL;
 nan_val.sc = as_double(mask.sc | exp_mask.sc);
 mask.sd = x.sd & 0x0007ffffffffffffULL;
 exp_mask.sd = 0x7ff8000000000000ULL;
 nan_val.sd = as_double(mask.sd | exp_mask.sd);
 mask.se = x.se & 0x0007ffffffffffffULL;
 exp_mask.se = 0x7ff8000000000000ULL;
 nan_val.se = as_double(mask.se | exp_mask.se);
 mask.sf = x.sf & 0x0007ffffffffffffULL;
 exp_mask.sf = 0x7ff8000000000000ULL;
 nan_val.sf = as_double(mask.sf | exp_mask.sf);
 return nan_val;
 }
#endif
float __attribute__((const))  __acl__rintf(float x);
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(float x);
inline float __attribute__((__overloadable__,__always_inline__,const)) rint(float x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) rint(float x ){ return (float)(__spirv_ocl_rint(x)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(float2 x );
inline float2 __attribute__((__overloadable__,__always_inline__,const)) rint(float2 x );
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) rint(float2 x ){ return (float2)(__spirv_ocl_rint(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(float3 x );
inline float3 __attribute__((__overloadable__,__always_inline__,const)) rint(float3 x );
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) rint(float3 x ){ return (float3)(__spirv_ocl_rint(x)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(float4 x );
inline float4 __attribute__((__overloadable__,__always_inline__,const)) rint(float4 x );
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) rint(float4 x ){ return (float4)(__spirv_ocl_rint(x)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(float8 x );
inline float8 __attribute__((__overloadable__,__always_inline__,const)) rint(float8 x );
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__,const)) rint(float8 x ){ return (float8)(__spirv_ocl_rint(x)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(float16 x );
inline float16 __attribute__((__overloadable__,__always_inline__,const)) rint(float16 x );
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__,const)) rint(float16 x ){ return (float16)(__spirv_ocl_rint(x)); }
#endif
double __attribute__((const))  __acl__rintfd(double x);
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(double x);
inline double __attribute__((__overloadable__,__always_inline__,const)) rint(double x );
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) rint(double x ){ return (double)(__spirv_ocl_rint(x)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(double2 x );
inline double2 __attribute__((__overloadable__,__always_inline__,const)) rint(double2 x );
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) rint(double2 x ){ return (double2)(__spirv_ocl_rint(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(double3 x );
inline double3 __attribute__((__overloadable__,__always_inline__,const)) rint(double3 x );
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) rint(double3 x ){ return (double3)(__spirv_ocl_rint(x)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(double4 x );
inline double4 __attribute__((__overloadable__,__always_inline__,const)) rint(double4 x );
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) rint(double4 x ){ return (double4)(__spirv_ocl_rint(x)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(double8 x );
inline double8 __attribute__((__overloadable__,__always_inline__,const)) rint(double8 x );
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__,const)) rint(double8 x ){ return (double8)(__spirv_ocl_rint(x)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_rint(double16 x );
inline double16 __attribute__((__overloadable__,__always_inline__,const)) rint(double16 x );
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__,const)) rint(double16 x ){ return (double16)(__spirv_ocl_rint(x)); }
#endif
double __attribute__((__overloadable__)) __spirv_ocl_native_recip(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_native_recip(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_native_recip(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_native_recip(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_native_recip(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_native_recip(double16 __x );
double __attribute__((__overloadable__)) __spirv_ocl_native_powr(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_native_powr(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_native_powr(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_native_powr(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_native_powr(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_native_powr(double16 __x, double16 __y);
double __attribute__((__overloadable__)) __spirv_ocl_native_divide(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_native_divide(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_native_divide(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_native_divide(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_native_divide(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_native_divide(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_native_recip(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_native_recip(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_native_recip(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_native_recip(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_native_recip(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_native_recip(float16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_native_powr(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_native_powr(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_native_powr(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_native_powr(float4 __x, float4 __y);
float8  __attribute__((__overloadable__)) __spirv_ocl_native_powr(float8 __x, float8 __y);
float16  __attribute__((__overloadable__)) __spirv_ocl_native_powr(float16 __x, float16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_native_divide(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_native_divide(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_native_divide(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_native_divide(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_native_divide(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_native_divide(float16 __x, float16 __y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__)) native_recip(double __x);
inline double __attribute__((__overloadable__)) native_recip(double __x){  return (double) __spirv_ocl_native_recip(__x); }
inline double2 __attribute__((__overloadable__)) native_recip(double2 __x );
inline double2 __attribute__((__overloadable__)) native_recip(double2 __x ){ return (double2)( __spirv_ocl_native_recip(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) native_recip(double3 __x );
inline double3 __attribute__((__overloadable__)) native_recip(double3 __x ){ return (double3)( __spirv_ocl_native_recip(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) native_recip(double4 __x );
inline double4 __attribute__((__overloadable__)) native_recip(double4 __x ){ return (double4)( __spirv_ocl_native_recip(__x)); }
inline double8 __attribute__((__overloadable__)) native_recip(double8 __x );
inline double8 __attribute__((__overloadable__)) native_recip(double8 __x ){ return (double8)( __spirv_ocl_native_recip(__x)); }
inline double16 __attribute__((__overloadable__)) native_recip(double16 __x );
inline double16 __attribute__((__overloadable__)) native_recip(double16 __x ){ return (double16)( __spirv_ocl_native_recip(__x)); }
inline double __attribute__((__overloadable__)) native_powr(double __x, double __y);
inline double __attribute__((__overloadable__)) native_powr(double __x, double __y){  return (double) __spirv_ocl_native_powr(__x, __y); }
inline double2 __attribute__((__overloadable__)) native_powr(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) native_powr(double2 __x, double2 __y){ return (double2)( __spirv_ocl_native_powr(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) native_powr(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) native_powr(double3 __x, double3 __y){ return (double3)( __spirv_ocl_native_powr(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) native_powr(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) native_powr(double4 __x, double4 __y){ return (double4)( __spirv_ocl_native_powr(__x, __y)); }
inline double8 __attribute__((__overloadable__)) native_powr(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) native_powr(double8 __x, double8 __y){ return (double8)( __spirv_ocl_native_powr(__x, __y)); }
inline double16 __attribute__((__overloadable__)) native_powr(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) native_powr(double16 __x, double16 __y){ return (double16)( __spirv_ocl_native_powr(__x, __y)); }
inline double __attribute__((__overloadable__)) native_divide(double __x, double __y);
inline double __attribute__((__overloadable__)) native_divide(double __x, double __y){  return (double) __spirv_ocl_native_divide(__x, __y); }
inline double2 __attribute__((__overloadable__)) native_divide(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) native_divide(double2 __x, double2 __y){ return (double2)( __spirv_ocl_native_divide(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) native_divide(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) native_divide(double3 __x, double3 __y){ return (double3)( __spirv_ocl_native_divide(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) native_divide(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) native_divide(double4 __x, double4 __y){ return (double4)( __spirv_ocl_native_divide(__x, __y)); }
inline double8 __attribute__((__overloadable__)) native_divide(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) native_divide(double8 __x, double8 __y){ return (double8)( __spirv_ocl_native_divide(__x, __y)); }
inline double16 __attribute__((__overloadable__)) native_divide(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) native_divide(double16 __x, double16 __y){ return (double16)( __spirv_ocl_native_divide(__x, __y)); }
inline float __attribute__((__overloadable__)) native_recip(float __x);
inline float __attribute__((__overloadable__)) native_recip(float __x){  return (float) __spirv_ocl_native_recip(__x); }
inline float2 __attribute__((__overloadable__)) native_recip(float2 __x );
inline float2 __attribute__((__overloadable__)) native_recip(float2 __x ){ return (float2)( __spirv_ocl_native_recip(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) native_recip(float3 __x );
inline float3 __attribute__((__overloadable__)) native_recip(float3 __x ){ return (float3)( __spirv_ocl_native_recip(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) native_recip(float4 __x );
inline float4 __attribute__((__overloadable__)) native_recip(float4 __x ){ return (float4)( __spirv_ocl_native_recip(__x)); }
inline float8 __attribute__((__overloadable__)) native_recip(float8 __x );
inline float8 __attribute__((__overloadable__)) native_recip(float8 __x ){ return (float8)( __spirv_ocl_native_recip(__x)); }
inline float16 __attribute__((__overloadable__)) native_recip(float16 __x );
inline float16 __attribute__((__overloadable__)) native_recip(float16 __x ){ return (float16)( __spirv_ocl_native_recip(__x)); }
inline float __attribute__((__overloadable__)) native_powr(float __x, float __y);
inline float __attribute__((__overloadable__)) native_powr(float __x, float __y){  return (float) __spirv_ocl_native_powr(__x, __y); }
inline float2 __attribute__((__overloadable__)) native_powr(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) native_powr(float2 __x, float2 __y){ return (float2)( __spirv_ocl_native_powr(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) native_powr(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) native_powr(float3 __x, float3 __y){ return (float3)( __spirv_ocl_native_powr(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) native_powr(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) native_powr(float4 __x, float4 __y){ return (float4)( __spirv_ocl_native_powr(__x, __y)); }
inline float8 __attribute__((__overloadable__)) native_powr(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) native_powr(float8 __x, float8 __y){ return (float8)( __spirv_ocl_native_powr(__x, __y)); }
inline float16 __attribute__((__overloadable__)) native_powr(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) native_powr(float16 __x, float16 __y){ return (float16)( __spirv_ocl_native_powr(__x, __y)); }
inline float __attribute__((__overloadable__)) native_divide(float __x, float __y);
inline float __attribute__((__overloadable__)) native_divide(float __x, float __y){  return (float) __spirv_ocl_native_divide(__x, __y); }
inline float2 __attribute__((__overloadable__)) native_divide(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) native_divide(float2 __x, float2 __y){ return (float2)( __spirv_ocl_native_divide(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) native_divide(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) native_divide(float3 __x, float3 __y){ return (float3)( __spirv_ocl_native_divide(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) native_divide(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) native_divide(float4 __x, float4 __y){ return (float4)( __spirv_ocl_native_divide(__x, __y)); }
inline float8 __attribute__((__overloadable__)) native_divide(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) native_divide(float8 __x, float8 __y){ return (float8)( __spirv_ocl_native_divide(__x, __y)); }
inline float16 __attribute__((__overloadable__)) native_divide(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) native_divide(float16 __x, float16 __y){ return (float16)( __spirv_ocl_native_divide(__x, __y)); }
#endif
double __attribute__((__overloadable__)) __spirv_ocl_half_powr(double __x, double __y);
double2 __attribute__((__overloadable__)) __spirv_ocl_half_powr(double2 __x, double2 __y);
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_half_powr(double3 __x, double3 __y);
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_half_powr(double4 __x, double4 __y);
double8 __attribute__((__overloadable__)) __spirv_ocl_half_powr(double8 __x, double8 __y);
double16 __attribute__((__overloadable__)) __spirv_ocl_half_powr(double16 __x, double16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_half_powr(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_powr(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_powr(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_powr(float4 __x, float4 __y);
float8  __attribute__((__overloadable__)) __spirv_ocl_half_powr(float8 __x, float8 __y);
float16  __attribute__((__overloadable__)) __spirv_ocl_half_powr(float16 __x, float16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_half_divide(float __x, float __y);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_divide(float2 __x, float2 __y);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_divide(float3 __x, float3 __y);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_divide(float4 __x, float4 __y);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_divide(float8 __x, float8 __y);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_divide(float16 __x, float16 __y);
float __attribute__((__overloadable__)) __spirv_ocl_half_recip(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_recip(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_recip(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_recip(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_recip(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_recip(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_cos(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_cos(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_cos(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_cos(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_cos(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_cos(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_exp(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_exp(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_exp(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_exp(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_exp(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_exp(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_exp2(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_exp2(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_exp2(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_exp2(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_exp2(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_exp2(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_exp10(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_exp10(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_exp10(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_exp10(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_exp10(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_exp10(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_log(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_log(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_log(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_log(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_log(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_log(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_log2(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_log2(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_log2(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_log2(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_log2(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_log2(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_log10(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_log10(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_log10(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_log10(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_log10(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_log10(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_rsqrt(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_rsqrt(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_rsqrt(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_rsqrt(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_rsqrt(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_rsqrt(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_sin(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_sin(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_sin(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_sin(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_sin(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_sin(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_sqrt(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_sqrt(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_sqrt(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_sqrt(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_sqrt(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_sqrt(float16 __x);
float __attribute__((__overloadable__)) __spirv_ocl_half_tan(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_half_tan(float2 __x);
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_half_tan(float3 __x);
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_half_tan(float4 __x);
float8 __attribute__((__overloadable__)) __spirv_ocl_half_tan(float8 __x);
float16 __attribute__((__overloadable__)) __spirv_ocl_half_tan(float16 __x);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__)) half_powr(double __x, double __y);
inline double __attribute__((__overloadable__)) half_powr(double __x, double __y){  return (double) __spirv_ocl_half_powr(__x, __y); }
inline double2 __attribute__((__overloadable__)) half_powr(double2 __x, double2 __y);
inline double2 __attribute__((__overloadable__)) half_powr(double2 __x, double2 __y){ return (double2)( __spirv_ocl_half_powr(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) half_powr(double3 __x, double3 __y);
inline double3 __attribute__((__overloadable__)) half_powr(double3 __x, double3 __y){ return (double3)( __spirv_ocl_half_powr(__x, __y)); }
#endif
inline double4 __attribute__((__overloadable__)) half_powr(double4 __x, double4 __y);
inline double4 __attribute__((__overloadable__)) half_powr(double4 __x, double4 __y){ return (double4)( __spirv_ocl_half_powr(__x, __y)); }
inline double8 __attribute__((__overloadable__)) half_powr(double8 __x, double8 __y);
inline double8 __attribute__((__overloadable__)) half_powr(double8 __x, double8 __y){ return (double8)( __spirv_ocl_half_powr(__x, __y)); }
inline double16 __attribute__((__overloadable__)) half_powr(double16 __x, double16 __y);
inline double16 __attribute__((__overloadable__)) half_powr(double16 __x, double16 __y){ return (double16)( __spirv_ocl_half_powr(__x, __y)); }
inline float __attribute__((__overloadable__)) half_powr(float __x, float __y);
inline float __attribute__((__overloadable__)) half_powr(float __x, float __y){  return (float) __spirv_ocl_half_powr(__x, __y); }
inline float2 __attribute__((__overloadable__)) half_powr(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) half_powr(float2 __x, float2 __y){ return (float2)( __spirv_ocl_half_powr(__x, __y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_powr(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) half_powr(float3 __x, float3 __y){ return (float3)( __spirv_ocl_half_powr(__x, __y)); }
#endif
inline float4 __attribute__((__overloadable__)) half_powr(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) half_powr(float4 __x, float4 __y){ return (float4)( __spirv_ocl_half_powr(__x, __y)); }
inline float8 __attribute__((__overloadable__)) half_powr(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) half_powr(float8 __x, float8 __y){ return (float8)( __spirv_ocl_half_powr(__x, __y)); }
inline float16 __attribute__((__overloadable__)) half_powr(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) half_powr(float16 __x, float16 __y){ return (float16)( __spirv_ocl_half_powr(__x, __y)); }
inline float __attribute__((__overloadable__)) half_divide(float __x, float __y);
inline float __attribute__((__overloadable__)) half_divide(float __x, float __y){ return ((__x)/(__y)); }
inline float2 __attribute__((__overloadable__)) half_divide(float2 __x, float2 __y);
inline float2 __attribute__((__overloadable__)) half_divide(float2 __x, float2 __y){ return ((__x)/(__y)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_divide(float3 __x, float3 __y);
inline float3 __attribute__((__overloadable__)) half_divide(float3 __x, float3 __y){ return ((__x)/(__y)); }
#endif
inline float4 __attribute__((__overloadable__)) half_divide(float4 __x, float4 __y);
inline float4 __attribute__((__overloadable__)) half_divide(float4 __x, float4 __y){ return ((__x)/(__y)); }
inline float8 __attribute__((__overloadable__)) half_divide(float8 __x, float8 __y);
inline float8 __attribute__((__overloadable__)) half_divide(float8 __x, float8 __y){ return ((__x)/(__y)); }
inline float16 __attribute__((__overloadable__)) half_divide(float16 __x, float16 __y);
inline float16 __attribute__((__overloadable__)) half_divide(float16 __x, float16 __y){ return ((__x)/(__y)); }
inline float __attribute__((__overloadable__)) half_recip(float __x);
inline float __attribute__((__overloadable__)) half_recip(float __x){ return (1.0f/(__x)); }
inline float2 __attribute__((__overloadable__)) half_recip(float2 __x);
inline float2 __attribute__((__overloadable__)) half_recip(float2 __x){ return (1.0f/(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_recip(float3 __x);
inline float3 __attribute__((__overloadable__)) half_recip(float3 __x){ return (1.0f/(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) half_recip(float4 __x);
inline float4 __attribute__((__overloadable__)) half_recip(float4 __x){ return (1.0f/(__x)); }
inline float8 __attribute__((__overloadable__)) half_recip(float8 __x);
inline float8 __attribute__((__overloadable__)) half_recip(float8 __x){ return (1.0f/(__x)); }
inline float16 __attribute__((__overloadable__)) half_recip(float16 __x);
inline float16 __attribute__((__overloadable__)) half_recip(float16 __x){ return (1.0f/(__x)); }
inline float __attribute__((__overloadable__)) half_cos(float __x);
inline float __attribute__((__overloadable__)) half_cos(float __x){ return  __spirv_ocl_half_cos(__x); }
inline float2 __attribute__((__overloadable__)) half_cos(float2 __x);
inline float2 __attribute__((__overloadable__)) half_cos(float2 __x){ return  __spirv_ocl_half_cos(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_cos(float3 __x);
inline float3 __attribute__((__overloadable__)) half_cos(float3 __x){ return  __spirv_ocl_half_cos(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_cos(float4 __x);
inline float4 __attribute__((__overloadable__)) half_cos(float4 __x){ return  __spirv_ocl_half_cos(__x); }
inline float8 __attribute__((__overloadable__)) half_cos(float8 __x);
inline float8 __attribute__((__overloadable__)) half_cos(float8 __x){ return  __spirv_ocl_half_cos(__x); }
inline float16 __attribute__((__overloadable__)) half_cos(float16 __x);
inline float16 __attribute__((__overloadable__)) half_cos(float16 __x){ return  __spirv_ocl_half_cos(__x); }
inline float __attribute__((__overloadable__)) half_exp(float __x);
inline float __attribute__((__overloadable__)) half_exp(float __x){ return  __spirv_ocl_half_exp(__x); }
inline float2 __attribute__((__overloadable__)) half_exp(float2 __x);
inline float2 __attribute__((__overloadable__)) half_exp(float2 __x){ return  __spirv_ocl_half_exp(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_exp(float3 __x);
inline float3 __attribute__((__overloadable__)) half_exp(float3 __x){ return  __spirv_ocl_half_exp(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_exp(float4 __x);
inline float4 __attribute__((__overloadable__)) half_exp(float4 __x){ return  __spirv_ocl_half_exp(__x); }
inline float8 __attribute__((__overloadable__)) half_exp(float8 __x);
inline float8 __attribute__((__overloadable__)) half_exp(float8 __x){ return  __spirv_ocl_half_exp(__x); }
inline float16 __attribute__((__overloadable__)) half_exp(float16 __x);
inline float16 __attribute__((__overloadable__)) half_exp(float16 __x){ return  __spirv_ocl_half_exp(__x); }
inline float __attribute__((__overloadable__)) half_exp2(float __x);
inline float __attribute__((__overloadable__)) half_exp2(float __x){ return  __spirv_ocl_half_exp2(__x); }
inline float2 __attribute__((__overloadable__)) half_exp2(float2 __x);
inline float2 __attribute__((__overloadable__)) half_exp2(float2 __x){ return  __spirv_ocl_half_exp2(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_exp2(float3 __x);
inline float3 __attribute__((__overloadable__)) half_exp2(float3 __x){ return  __spirv_ocl_half_exp2(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_exp2(float4 __x);
inline float4 __attribute__((__overloadable__)) half_exp2(float4 __x){ return  __spirv_ocl_half_exp2(__x); }
inline float8 __attribute__((__overloadable__)) half_exp2(float8 __x);
inline float8 __attribute__((__overloadable__)) half_exp2(float8 __x){ return  __spirv_ocl_half_exp2(__x); }
inline float16 __attribute__((__overloadable__)) half_exp2(float16 __x);
inline float16 __attribute__((__overloadable__)) half_exp2(float16 __x){ return  __spirv_ocl_half_exp2(__x); }
inline float __attribute__((__overloadable__)) half_exp10(float __x);
inline float __attribute__((__overloadable__)) half_exp10(float __x){ return  __spirv_ocl_half_exp10(__x); }
inline float2 __attribute__((__overloadable__)) half_exp10(float2 __x);
inline float2 __attribute__((__overloadable__)) half_exp10(float2 __x){ return  __spirv_ocl_half_exp10(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_exp10(float3 __x);
inline float3 __attribute__((__overloadable__)) half_exp10(float3 __x){ return  __spirv_ocl_half_exp10(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_exp10(float4 __x);
inline float4 __attribute__((__overloadable__)) half_exp10(float4 __x){ return  __spirv_ocl_half_exp10(__x); }
inline float8 __attribute__((__overloadable__)) half_exp10(float8 __x);
inline float8 __attribute__((__overloadable__)) half_exp10(float8 __x){ return  __spirv_ocl_half_exp10(__x); }
inline float16 __attribute__((__overloadable__)) half_exp10(float16 __x);
inline float16 __attribute__((__overloadable__)) half_exp10(float16 __x){ return  __spirv_ocl_half_exp10(__x); }
inline float __attribute__((__overloadable__)) half_log(float __x);
inline float __attribute__((__overloadable__)) half_log(float __x){ return  __spirv_ocl_half_log(__x); }
inline float2 __attribute__((__overloadable__)) half_log(float2 __x);
inline float2 __attribute__((__overloadable__)) half_log(float2 __x){ return  __spirv_ocl_half_log(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_log(float3 __x);
inline float3 __attribute__((__overloadable__)) half_log(float3 __x){ return  __spirv_ocl_half_log(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_log(float4 __x);
inline float4 __attribute__((__overloadable__)) half_log(float4 __x){ return  __spirv_ocl_half_log(__x); }
inline float8 __attribute__((__overloadable__)) half_log(float8 __x);
inline float8 __attribute__((__overloadable__)) half_log(float8 __x){ return  __spirv_ocl_half_log(__x); }
inline float16 __attribute__((__overloadable__)) half_log(float16 __x);
inline float16 __attribute__((__overloadable__)) half_log(float16 __x){ return  __spirv_ocl_half_log(__x); }
inline float __attribute__((__overloadable__)) half_log2(float __x);
inline float __attribute__((__overloadable__)) half_log2(float __x){ return  __spirv_ocl_half_log2(__x); }
inline float2 __attribute__((__overloadable__)) half_log2(float2 __x);
inline float2 __attribute__((__overloadable__)) half_log2(float2 __x){ return  __spirv_ocl_half_log2(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_log2(float3 __x);
inline float3 __attribute__((__overloadable__)) half_log2(float3 __x){ return  __spirv_ocl_half_log2(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_log2(float4 __x);
inline float4 __attribute__((__overloadable__)) half_log2(float4 __x){ return  __spirv_ocl_half_log2(__x); }
inline float8 __attribute__((__overloadable__)) half_log2(float8 __x);
inline float8 __attribute__((__overloadable__)) half_log2(float8 __x){ return  __spirv_ocl_half_log2(__x); }
inline float16 __attribute__((__overloadable__)) half_log2(float16 __x);
inline float16 __attribute__((__overloadable__)) half_log2(float16 __x){ return  __spirv_ocl_half_log2(__x); }
inline float __attribute__((__overloadable__)) half_log10(float __x);
inline float __attribute__((__overloadable__)) half_log10(float __x){ return  __spirv_ocl_half_log10(__x); }
inline float2 __attribute__((__overloadable__)) half_log10(float2 __x);
inline float2 __attribute__((__overloadable__)) half_log10(float2 __x){ return  __spirv_ocl_half_log10(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_log10(float3 __x);
inline float3 __attribute__((__overloadable__)) half_log10(float3 __x){ return  __spirv_ocl_half_log10(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_log10(float4 __x);
inline float4 __attribute__((__overloadable__)) half_log10(float4 __x){ return  __spirv_ocl_half_log10(__x); }
inline float8 __attribute__((__overloadable__)) half_log10(float8 __x);
inline float8 __attribute__((__overloadable__)) half_log10(float8 __x){ return  __spirv_ocl_half_log10(__x); }
inline float16 __attribute__((__overloadable__)) half_log10(float16 __x);
inline float16 __attribute__((__overloadable__)) half_log10(float16 __x){ return  __spirv_ocl_half_log10(__x); }
inline float __attribute__((__overloadable__)) half_rsqrt(float __x);
inline float __attribute__((__overloadable__)) half_rsqrt(float __x){ return  __spirv_ocl_half_rsqrt(__x); }
inline float2 __attribute__((__overloadable__)) half_rsqrt(float2 __x);
inline float2 __attribute__((__overloadable__)) half_rsqrt(float2 __x){ return  __spirv_ocl_half_rsqrt(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_rsqrt(float3 __x);
inline float3 __attribute__((__overloadable__)) half_rsqrt(float3 __x){ return  __spirv_ocl_half_rsqrt(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_rsqrt(float4 __x);
inline float4 __attribute__((__overloadable__)) half_rsqrt(float4 __x){ return  __spirv_ocl_half_rsqrt(__x); }
inline float8 __attribute__((__overloadable__)) half_rsqrt(float8 __x);
inline float8 __attribute__((__overloadable__)) half_rsqrt(float8 __x){ return  __spirv_ocl_half_rsqrt(__x); }
inline float16 __attribute__((__overloadable__)) half_rsqrt(float16 __x);
inline float16 __attribute__((__overloadable__)) half_rsqrt(float16 __x){ return  __spirv_ocl_half_rsqrt(__x); }
inline float __attribute__((__overloadable__)) half_sin(float __x);
inline float __attribute__((__overloadable__)) half_sin(float __x){ return  __spirv_ocl_half_sin(__x); }
inline float2 __attribute__((__overloadable__)) half_sin(float2 __x);
inline float2 __attribute__((__overloadable__)) half_sin(float2 __x){ return  __spirv_ocl_half_sin(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_sin(float3 __x);
inline float3 __attribute__((__overloadable__)) half_sin(float3 __x){ return  __spirv_ocl_half_sin(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_sin(float4 __x);
inline float4 __attribute__((__overloadable__)) half_sin(float4 __x){ return  __spirv_ocl_half_sin(__x); }
inline float8 __attribute__((__overloadable__)) half_sin(float8 __x);
inline float8 __attribute__((__overloadable__)) half_sin(float8 __x){ return  __spirv_ocl_half_sin(__x); }
inline float16 __attribute__((__overloadable__)) half_sin(float16 __x);
inline float16 __attribute__((__overloadable__)) half_sin(float16 __x){ return  __spirv_ocl_half_sin(__x); }
inline float __attribute__((__overloadable__)) half_sqrt(float __x);
inline float __attribute__((__overloadable__)) half_sqrt(float __x){ return  __spirv_ocl_half_sqrt(__x); }
inline float2 __attribute__((__overloadable__)) half_sqrt(float2 __x);
inline float2 __attribute__((__overloadable__)) half_sqrt(float2 __x){ return  __spirv_ocl_half_sqrt(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_sqrt(float3 __x);
inline float3 __attribute__((__overloadable__)) half_sqrt(float3 __x){ return  __spirv_ocl_half_sqrt(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_sqrt(float4 __x);
inline float4 __attribute__((__overloadable__)) half_sqrt(float4 __x){ return  __spirv_ocl_half_sqrt(__x); }
inline float8 __attribute__((__overloadable__)) half_sqrt(float8 __x);
inline float8 __attribute__((__overloadable__)) half_sqrt(float8 __x){ return  __spirv_ocl_half_sqrt(__x); }
inline float16 __attribute__((__overloadable__)) half_sqrt(float16 __x);
inline float16 __attribute__((__overloadable__)) half_sqrt(float16 __x){ return  __spirv_ocl_half_sqrt(__x); }
inline float __attribute__((__overloadable__)) half_tan(float __x);
inline float __attribute__((__overloadable__)) half_tan(float __x){ return  __spirv_ocl_half_tan(__x); }
inline float2 __attribute__((__overloadable__)) half_tan(float2 __x);
inline float2 __attribute__((__overloadable__)) half_tan(float2 __x){ return  __spirv_ocl_half_tan(__x); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) half_tan(float3 __x);
inline float3 __attribute__((__overloadable__)) half_tan(float3 __x){ return  __spirv_ocl_half_tan(__x); }
#endif
inline float4 __attribute__((__overloadable__)) half_tan(float4 __x);
inline float4 __attribute__((__overloadable__)) half_tan(float4 __x){ return  __spirv_ocl_half_tan(__x); }
inline float8 __attribute__((__overloadable__)) half_tan(float8 __x);
inline float8 __attribute__((__overloadable__)) half_tan(float8 __x){ return  __spirv_ocl_half_tan(__x); }
inline float16 __attribute__((__overloadable__)) half_tan(float16 __x);
inline float16 __attribute__((__overloadable__)) half_tan(float16 __x){ return  __spirv_ocl_half_tan(__x); }
#endif
float __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float x, float y, private int *quo );
inline float __attribute__((__overloadable__,__always_inline__)) remquo(float x, float y, private int* z);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__)) remquo(float x, float y, private int* z){ return (float)(__spirv_ocl_remquo(x, y, z)); }
#endif
float __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(float x, float y);
inline float __attribute__((__overloadable__,__always_inline__)) remainder(float x, float y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__)) remainder(float x, float y){ return (float)(__spirv_ocl_remainder(x, y)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float2 x, float2 y, private int2 *quo );
inline float2 __attribute__((__overloadable__,__always_inline__)) remquo(float2 x, float2 y, private int2* z);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__)) remquo(float2 x, float2 y, private int2* z){ return (float2)(__spirv_ocl_remquo(x, y, z)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(float2 x, float2 y);
inline float2 __attribute__((__overloadable__,__always_inline__)) remainder(float2 x, float2 y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__)) remainder(float2 x, float2 y){ return (float2)(__spirv_ocl_remainder(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float3 x, float3 y, private int3 *quo );
inline float3 __attribute__((__overloadable__,__always_inline__)) remquo(float3 x, float3 y, private int3* z);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__)) remquo(float3 x, float3 y, private int3* z){ return (float3)(__spirv_ocl_remquo(x, y, z)); }
#endif
float3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(float3 x, float3 y);
inline float3 __attribute__((__overloadable__,__always_inline__)) remainder(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__)) remainder(float3 x, float3 y){ return (float3)(__spirv_ocl_remainder(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float4 x, float4 y, private int4 *quo );
inline float4 __attribute__((__overloadable__,__always_inline__)) remquo(float4 x, float4 y, private int4* z);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__)) remquo(float4 x, float4 y, private int4* z){ return (float4)(__spirv_ocl_remquo(x, y, z)); }
#endif
float4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(float4 x, float4 y);
inline float4 __attribute__((__overloadable__,__always_inline__)) remainder(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__)) remainder(float4 x, float4 y){ return (float4)(__spirv_ocl_remainder(x, y)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float8 x, float8 y, private int8 *quo );
inline float8 __attribute__((__overloadable__,__always_inline__)) remquo(float8 x, float8 y, private int8* z);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__)) remquo(float8 x, float8 y, private int8* z){ return (float8)(__spirv_ocl_remquo(x, y, z)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(float8 x, float8 y);
inline float8 __attribute__((__overloadable__,__always_inline__)) remainder(float8 x, float8 y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__)) remainder(float8 x, float8 y){ return (float8)(__spirv_ocl_remainder(x, y)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float16 x, float16 y, private int16 *quo );
inline float16 __attribute__((__overloadable__,__always_inline__)) remquo(float16 x, float16 y, private int16* z);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__)) remquo(float16 x, float16 y, private int16* z){ return (float16)(__spirv_ocl_remquo(x, y, z)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(float16 x, float16 y);
inline float16 __attribute__((__overloadable__,__always_inline__)) remainder(float16 x, float16 y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__)) remainder(float16 x, float16 y){ return (float16)(__spirv_ocl_remainder(x, y)); }
#endif
float __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float x, float y, global int *quo );
inline float __attribute__((__overloadable__,__always_inline__)) remquo(float x, float y, global int* z);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__)) remquo(float x, float y, global int* z){ return (float)(__spirv_ocl_remquo(x, y, z)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float2 x, float2 y, global int2 *quo );
inline float2 __attribute__((__overloadable__,__always_inline__)) remquo(float2 x, float2 y, global int2* z);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__)) remquo(float2 x, float2 y, global int2* z){ return (float2)(__spirv_ocl_remquo(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float3 x, float3 y, global int3 *quo );
inline float3 __attribute__((__overloadable__,__always_inline__)) remquo(float3 x, float3 y, global int3* z);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__)) remquo(float3 x, float3 y, global int3* z){ return (float3)(__spirv_ocl_remquo(x, y, z)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float4 x, float4 y, global int4 *quo );
inline float4 __attribute__((__overloadable__,__always_inline__)) remquo(float4 x, float4 y, global int4* z);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__)) remquo(float4 x, float4 y, global int4* z){ return (float4)(__spirv_ocl_remquo(x, y, z)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float8 x, float8 y, global int8 *quo );
inline float8 __attribute__((__overloadable__,__always_inline__)) remquo(float8 x, float8 y, global int8* z);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__)) remquo(float8 x, float8 y, global int8* z){ return (float8)(__spirv_ocl_remquo(x, y, z)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float16 x, float16 y, global int16 *quo );
inline float16 __attribute__((__overloadable__,__always_inline__)) remquo(float16 x, float16 y, global int16* z);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__)) remquo(float16 x, float16 y, global int16* z){ return (float16)(__spirv_ocl_remquo(x, y, z)); }
#endif
float __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float x, float y, local int *quo );
inline float __attribute__((__overloadable__,__always_inline__)) remquo(float x, float y, local int* z);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__)) remquo(float x, float y, local int* z){ return (float)(__spirv_ocl_remquo(x, y, z)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float2 x, float2 y, local int2 *quo );
inline float2 __attribute__((__overloadable__,__always_inline__)) remquo(float2 x, float2 y, local int2* z);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__)) remquo(float2 x, float2 y, local int2* z){ return (float2)(__spirv_ocl_remquo(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float3 x, float3 y, local int3 *quo );
inline float3 __attribute__((__overloadable__,__always_inline__)) remquo(float3 x, float3 y, local int3* z);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__)) remquo(float3 x, float3 y, local int3* z){ return (float3)(__spirv_ocl_remquo(x, y, z)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float4 x, float4 y, local int4 *quo );
inline float4 __attribute__((__overloadable__,__always_inline__)) remquo(float4 x, float4 y, local int4* z);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__)) remquo(float4 x, float4 y, local int4* z){ return (float4)(__spirv_ocl_remquo(x, y, z)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float8 x, float8 y, local int8 *quo );
inline float8 __attribute__((__overloadable__,__always_inline__)) remquo(float8 x, float8 y, local int8* z);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__)) remquo(float8 x, float8 y, local int8* z){ return (float8)(__spirv_ocl_remquo(x, y, z)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(float16 x, float16 y, local int16 *quo );
inline float16 __attribute__((__overloadable__,__always_inline__)) remquo(float16 x, float16 y, local int16* z);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__)) remquo(float16 x, float16 y, local int16* z){ return (float16)(__spirv_ocl_remquo(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
#endif
double __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double x, double y, private int *quo );
inline double __attribute__((__overloadable__,__always_inline__)) remquo(double x, double y, private int* z);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__)) remquo(double x, double y, private int* z){ return (double)(__spirv_ocl_remquo(x, y, z)); }
#endif
double __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(double x, double y);
inline double __attribute__((__overloadable__,__always_inline__)) remainder(double x, double y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__)) remainder(double x, double y){ return (double)(__spirv_ocl_remainder(x, y)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double2 x, double2 y, private int2 *quo );
inline double2 __attribute__((__overloadable__,__always_inline__)) remquo(double2 x, double2 y, private int2* z);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__)) remquo(double2 x, double2 y, private int2* z){ return (double2)(__spirv_ocl_remquo(x, y, z)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(double2 x, double2 y);
inline double2 __attribute__((__overloadable__,__always_inline__)) remainder(double2 x, double2 y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__)) remainder(double2 x, double2 y){ return (double2)(__spirv_ocl_remainder(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double3 x, double3 y, private int3 *quo );
inline double3 __attribute__((__overloadable__,__always_inline__)) remquo(double3 x, double3 y, private int3* z);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__)) remquo(double3 x, double3 y, private int3* z){ return (double3)(__spirv_ocl_remquo(x, y, z)); }
#endif
double3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(double3 x, double3 y);
inline double3 __attribute__((__overloadable__,__always_inline__)) remainder(double3 x, double3 y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__)) remainder(double3 x, double3 y){ return (double3)(__spirv_ocl_remainder(x, y)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double4 x, double4 y, private int4 *quo );
inline double4 __attribute__((__overloadable__,__always_inline__)) remquo(double4 x, double4 y, private int4* z);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__)) remquo(double4 x, double4 y, private int4* z){ return (double4)(__spirv_ocl_remquo(x, y, z)); }
#endif
double4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(double4 x, double4 y);
inline double4 __attribute__((__overloadable__,__always_inline__)) remainder(double4 x, double4 y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__)) remainder(double4 x, double4 y){ return (double4)(__spirv_ocl_remainder(x, y)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double8 x, double8 y, private int8 *quo );
inline double8 __attribute__((__overloadable__,__always_inline__)) remquo(double8 x, double8 y, private int8* z);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__)) remquo(double8 x, double8 y, private int8* z){ return (double8)(__spirv_ocl_remquo(x, y, z)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(double8 x, double8 y);
inline double8 __attribute__((__overloadable__,__always_inline__)) remainder(double8 x, double8 y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__)) remainder(double8 x, double8 y){ return (double8)(__spirv_ocl_remainder(x, y)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double16 x, double16 y, private int16 *quo );
inline double16 __attribute__((__overloadable__,__always_inline__)) remquo(double16 x, double16 y, private int16* z);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__)) remquo(double16 x, double16 y, private int16* z){ return (double16)(__spirv_ocl_remquo(x, y, z)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remainder(double16 x, double16 y);
inline double16 __attribute__((__overloadable__,__always_inline__)) remainder(double16 x, double16 y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__)) remainder(double16 x, double16 y){ return (double16)(__spirv_ocl_remainder(x, y)); }
#endif
double __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double x, double y, global int *quo );
inline double __attribute__((__overloadable__,__always_inline__)) remquo(double x, double y, global int* z);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__)) remquo(double x, double y, global int* z){ return (double)(__spirv_ocl_remquo(x, y, z)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double2 x, double2 y, global int2 *quo );
inline double2 __attribute__((__overloadable__,__always_inline__)) remquo(double2 x, double2 y, global int2* z);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__)) remquo(double2 x, double2 y, global int2* z){ return (double2)(__spirv_ocl_remquo(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double3 x, double3 y, global int3 *quo );
inline double3 __attribute__((__overloadable__,__always_inline__)) remquo(double3 x, double3 y, global int3* z);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__)) remquo(double3 x, double3 y, global int3* z){ return (double3)(__spirv_ocl_remquo(x, y, z)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double4 x, double4 y, global int4 *quo );
inline double4 __attribute__((__overloadable__,__always_inline__)) remquo(double4 x, double4 y, global int4* z);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__)) remquo(double4 x, double4 y, global int4* z){ return (double4)(__spirv_ocl_remquo(x, y, z)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double8 x, double8 y, global int8 *quo );
inline double8 __attribute__((__overloadable__,__always_inline__)) remquo(double8 x, double8 y, global int8* z);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__)) remquo(double8 x, double8 y, global int8* z){ return (double8)(__spirv_ocl_remquo(x, y, z)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double16 x, double16 y, global int16 *quo );
inline double16 __attribute__((__overloadable__,__always_inline__)) remquo(double16 x, double16 y, global int16* z);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__)) remquo(double16 x, double16 y, global int16* z){ return (double16)(__spirv_ocl_remquo(x, y, z)); }
#endif
double __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double x, double y, local int *quo );
inline double __attribute__((__overloadable__,__always_inline__)) remquo(double x, double y, local int* z);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__)) remquo(double x, double y, local int* z){ return (double)(__spirv_ocl_remquo(x, y, z)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double2 x, double2 y, local int2 *quo );
inline double2 __attribute__((__overloadable__,__always_inline__)) remquo(double2 x, double2 y, local int2* z);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__)) remquo(double2 x, double2 y, local int2* z){ return (double2)(__spirv_ocl_remquo(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double3 x, double3 y, local int3 *quo );
inline double3 __attribute__((__overloadable__,__always_inline__)) remquo(double3 x, double3 y, local int3* z);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__)) remquo(double3 x, double3 y, local int3* z){ return (double3)(__spirv_ocl_remquo(x, y, z)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double4 x, double4 y, local int4 *quo );
inline double4 __attribute__((__overloadable__,__always_inline__)) remquo(double4 x, double4 y, local int4* z);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__)) remquo(double4 x, double4 y, local int4* z){ return (double4)(__spirv_ocl_remquo(x, y, z)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double8 x, double8 y, local int8 *quo );
inline double8 __attribute__((__overloadable__,__always_inline__)) remquo(double8 x, double8 y, local int8* z);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__)) remquo(double8 x, double8 y, local int8* z){ return (double8)(__spirv_ocl_remquo(x, y, z)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_remquo(double16 x, double16 y, local int16 *quo );
inline double16 __attribute__((__overloadable__,__always_inline__)) remquo(double16 x, double16 y, local int16* z);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__)) remquo(double16 x, double16 y, local int16* z){ return (double16)(__spirv_ocl_remquo(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
#endif
float __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(float __x, float __y);
inline float __attribute__((__overloadable__,__always_inline__)) fmod(float x, float y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__)) fmod(float x, float y){ return (float)(__spirv_ocl_fmod(x, y)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(float2 x, float2 y);
inline float2 __attribute__((__overloadable__,__always_inline__)) fmod(float2 x, float2 y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__)) fmod(float2 x, float2 y){ return (float2)(__spirv_ocl_fmod(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(float3 x, float3 y);
inline float3 __attribute__((__overloadable__,__always_inline__)) fmod(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__)) fmod(float3 x, float3 y){ return (float3)(__spirv_ocl_fmod(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(float4 x, float4 y);
inline float4 __attribute__((__overloadable__,__always_inline__)) fmod(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__)) fmod(float4 x, float4 y){ return (float4)(__spirv_ocl_fmod(x, y)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(float8 x, float8 y);
inline float8 __attribute__((__overloadable__,__always_inline__)) fmod(float8 x, float8 y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__)) fmod(float8 x, float8 y){ return (float8)(__spirv_ocl_fmod(x, y)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(float16 x, float16 y);
inline float16 __attribute__((__overloadable__,__always_inline__)) fmod(float16 x, float16 y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__)) fmod(float16 x, float16 y){ return (float16)(__spirv_ocl_fmod(x, y)); }
#endif
double __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(double __x, double __y);
inline double __attribute__((__overloadable__,__always_inline__)) fmod(double x, double y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__)) fmod(double x, double y){ return (double)(__spirv_ocl_fmod(x, y)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(double2 x, double2 y);
inline double2 __attribute__((__overloadable__,__always_inline__)) fmod(double2 x, double2 y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__)) fmod(double2 x, double2 y){ return (double2)(__spirv_ocl_fmod(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(double3 x, double3 y);
inline double3 __attribute__((__overloadable__,__always_inline__)) fmod(double3 x, double3 y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__)) fmod(double3 x, double3 y){ return (double3)(__spirv_ocl_fmod(x, y)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(double4 x, double4 y);
inline double4 __attribute__((__overloadable__,__always_inline__)) fmod(double4 x, double4 y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__)) fmod(double4 x, double4 y){ return (double4)(__spirv_ocl_fmod(x, y)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(double8 x, double8 y);
inline double8 __attribute__((__overloadable__,__always_inline__)) fmod(double8 x, double8 y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__)) fmod(double8 x, double8 y){ return (double8)(__spirv_ocl_fmod(x, y)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_fmod(double16 x, double16 y);
inline double16 __attribute__((__overloadable__,__always_inline__)) fmod(double16 x, double16 y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__)) fmod(double16 x, double16 y){ return (double16)(__spirv_ocl_fmod(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
#define __CVAttrs __attribute__((__overloadable__,__always_inline__,const))
char2 __CVAttrs shuffle(char2 _x, uchar2 _m);
char2 __CVAttrs shuffle2(char2 _x, char2 _y, uchar2 _m);
char4 __CVAttrs shuffle(char2 _x, uchar4 _m);
char4 __CVAttrs shuffle2(char2 _x, char2 _y, uchar4 _m);
char8 __CVAttrs shuffle(char2 _x, uchar8 _m);
char8 __CVAttrs shuffle2(char2 _x, char2 _y, uchar8 _m);
char16 __CVAttrs shuffle(char2 _x, uchar16 _m);
char16 __CVAttrs shuffle2(char2 _x, char2 _y, uchar16 _m);
char2 __CVAttrs shuffle(char4 _x, uchar2 _m);
char2 __CVAttrs shuffle2(char4 _x, char4 _y, uchar2 _m);
char4 __CVAttrs shuffle(char4 _x, uchar4 _m);
char4 __CVAttrs shuffle2(char4 _x, char4 _y, uchar4 _m);
char8 __CVAttrs shuffle(char4 _x, uchar8 _m);
char8 __CVAttrs shuffle2(char4 _x, char4 _y, uchar8 _m);
char16 __CVAttrs shuffle(char4 _x, uchar16 _m);
char16 __CVAttrs shuffle2(char4 _x, char4 _y, uchar16 _m);
char2 __CVAttrs shuffle(char8 _x, uchar2 _m);
char2 __CVAttrs shuffle2(char8 _x, char8 _y, uchar2 _m);
char4 __CVAttrs shuffle(char8 _x, uchar4 _m);
char4 __CVAttrs shuffle2(char8 _x, char8 _y, uchar4 _m);
char8 __CVAttrs shuffle(char8 _x, uchar8 _m);
char8 __CVAttrs shuffle2(char8 _x, char8 _y, uchar8 _m);
char16 __CVAttrs shuffle(char8 _x, uchar16 _m);
char16 __CVAttrs shuffle2(char8 _x, char8 _y, uchar16 _m);
char2 __CVAttrs shuffle(char16 _x, uchar2 _m);
char2 __CVAttrs shuffle2(char16 _x, char16 _y, uchar2 _m);
char4 __CVAttrs shuffle(char16 _x, uchar4 _m);
char4 __CVAttrs shuffle2(char16 _x, char16 _y, uchar4 _m);
char8 __CVAttrs shuffle(char16 _x, uchar8 _m);
char8 __CVAttrs shuffle2(char16 _x, char16 _y, uchar8 _m);
char16 __CVAttrs shuffle(char16 _x, uchar16 _m);
char16 __CVAttrs shuffle2(char16 _x, char16 _y, uchar16 _m);
uchar2 __CVAttrs shuffle(uchar2 _x, uchar2 _m);
uchar2 __CVAttrs shuffle2(uchar2 _x, uchar2 _y, uchar2 _m);
uchar4 __CVAttrs shuffle(uchar2 _x, uchar4 _m);
uchar4 __CVAttrs shuffle2(uchar2 _x, uchar2 _y, uchar4 _m);
uchar8 __CVAttrs shuffle(uchar2 _x, uchar8 _m);
uchar8 __CVAttrs shuffle2(uchar2 _x, uchar2 _y, uchar8 _m);
uchar16 __CVAttrs shuffle(uchar2 _x, uchar16 _m);
uchar16 __CVAttrs shuffle2(uchar2 _x, uchar2 _y, uchar16 _m);
uchar2 __CVAttrs shuffle(uchar4 _x, uchar2 _m);
uchar2 __CVAttrs shuffle2(uchar4 _x, uchar4 _y, uchar2 _m);
uchar4 __CVAttrs shuffle(uchar4 _x, uchar4 _m);
uchar4 __CVAttrs shuffle2(uchar4 _x, uchar4 _y, uchar4 _m);
uchar8 __CVAttrs shuffle(uchar4 _x, uchar8 _m);
uchar8 __CVAttrs shuffle2(uchar4 _x, uchar4 _y, uchar8 _m);
uchar16 __CVAttrs shuffle(uchar4 _x, uchar16 _m);
uchar16 __CVAttrs shuffle2(uchar4 _x, uchar4 _y, uchar16 _m);
uchar2 __CVAttrs shuffle(uchar8 _x, uchar2 _m);
uchar2 __CVAttrs shuffle2(uchar8 _x, uchar8 _y, uchar2 _m);
uchar4 __CVAttrs shuffle(uchar8 _x, uchar4 _m);
uchar4 __CVAttrs shuffle2(uchar8 _x, uchar8 _y, uchar4 _m);
uchar8 __CVAttrs shuffle(uchar8 _x, uchar8 _m);
uchar8 __CVAttrs shuffle2(uchar8 _x, uchar8 _y, uchar8 _m);
uchar16 __CVAttrs shuffle(uchar8 _x, uchar16 _m);
uchar16 __CVAttrs shuffle2(uchar8 _x, uchar8 _y, uchar16 _m);
uchar2 __CVAttrs shuffle(uchar16 _x, uchar2 _m);
uchar2 __CVAttrs shuffle2(uchar16 _x, uchar16 _y, uchar2 _m);
uchar4 __CVAttrs shuffle(uchar16 _x, uchar4 _m);
uchar4 __CVAttrs shuffle2(uchar16 _x, uchar16 _y, uchar4 _m);
uchar8 __CVAttrs shuffle(uchar16 _x, uchar8 _m);
uchar8 __CVAttrs shuffle2(uchar16 _x, uchar16 _y, uchar8 _m);
uchar16 __CVAttrs shuffle(uchar16 _x, uchar16 _m);
uchar16 __CVAttrs shuffle2(uchar16 _x, uchar16 _y, uchar16 _m);
short2 __CVAttrs shuffle(short2 _x, ushort2 _m);
short2 __CVAttrs shuffle2(short2 _x, short2 _y, ushort2 _m);
short4 __CVAttrs shuffle(short2 _x, ushort4 _m);
short4 __CVAttrs shuffle2(short2 _x, short2 _y, ushort4 _m);
short8 __CVAttrs shuffle(short2 _x, ushort8 _m);
short8 __CVAttrs shuffle2(short2 _x, short2 _y, ushort8 _m);
short16 __CVAttrs shuffle(short2 _x, ushort16 _m);
short16 __CVAttrs shuffle2(short2 _x, short2 _y, ushort16 _m);
short2 __CVAttrs shuffle(short4 _x, ushort2 _m);
short2 __CVAttrs shuffle2(short4 _x, short4 _y, ushort2 _m);
short4 __CVAttrs shuffle(short4 _x, ushort4 _m);
short4 __CVAttrs shuffle2(short4 _x, short4 _y, ushort4 _m);
short8 __CVAttrs shuffle(short4 _x, ushort8 _m);
short8 __CVAttrs shuffle2(short4 _x, short4 _y, ushort8 _m);
short16 __CVAttrs shuffle(short4 _x, ushort16 _m);
short16 __CVAttrs shuffle2(short4 _x, short4 _y, ushort16 _m);
short2 __CVAttrs shuffle(short8 _x, ushort2 _m);
short2 __CVAttrs shuffle2(short8 _x, short8 _y, ushort2 _m);
short4 __CVAttrs shuffle(short8 _x, ushort4 _m);
short4 __CVAttrs shuffle2(short8 _x, short8 _y, ushort4 _m);
short8 __CVAttrs shuffle(short8 _x, ushort8 _m);
short8 __CVAttrs shuffle2(short8 _x, short8 _y, ushort8 _m);
short16 __CVAttrs shuffle(short8 _x, ushort16 _m);
short16 __CVAttrs shuffle2(short8 _x, short8 _y, ushort16 _m);
short2 __CVAttrs shuffle(short16 _x, ushort2 _m);
short2 __CVAttrs shuffle2(short16 _x, short16 _y, ushort2 _m);
short4 __CVAttrs shuffle(short16 _x, ushort4 _m);
short4 __CVAttrs shuffle2(short16 _x, short16 _y, ushort4 _m);
short8 __CVAttrs shuffle(short16 _x, ushort8 _m);
short8 __CVAttrs shuffle2(short16 _x, short16 _y, ushort8 _m);
short16 __CVAttrs shuffle(short16 _x, ushort16 _m);
short16 __CVAttrs shuffle2(short16 _x, short16 _y, ushort16 _m);
ushort2 __CVAttrs shuffle(ushort2 _x, ushort2 _m);
ushort2 __CVAttrs shuffle2(ushort2 _x, ushort2 _y, ushort2 _m);
ushort4 __CVAttrs shuffle(ushort2 _x, ushort4 _m);
ushort4 __CVAttrs shuffle2(ushort2 _x, ushort2 _y, ushort4 _m);
ushort8 __CVAttrs shuffle(ushort2 _x, ushort8 _m);
ushort8 __CVAttrs shuffle2(ushort2 _x, ushort2 _y, ushort8 _m);
ushort16 __CVAttrs shuffle(ushort2 _x, ushort16 _m);
ushort16 __CVAttrs shuffle2(ushort2 _x, ushort2 _y, ushort16 _m);
ushort2 __CVAttrs shuffle(ushort4 _x, ushort2 _m);
ushort2 __CVAttrs shuffle2(ushort4 _x, ushort4 _y, ushort2 _m);
ushort4 __CVAttrs shuffle(ushort4 _x, ushort4 _m);
ushort4 __CVAttrs shuffle2(ushort4 _x, ushort4 _y, ushort4 _m);
ushort8 __CVAttrs shuffle(ushort4 _x, ushort8 _m);
ushort8 __CVAttrs shuffle2(ushort4 _x, ushort4 _y, ushort8 _m);
ushort16 __CVAttrs shuffle(ushort4 _x, ushort16 _m);
ushort16 __CVAttrs shuffle2(ushort4 _x, ushort4 _y, ushort16 _m);
ushort2 __CVAttrs shuffle(ushort8 _x, ushort2 _m);
ushort2 __CVAttrs shuffle2(ushort8 _x, ushort8 _y, ushort2 _m);
ushort4 __CVAttrs shuffle(ushort8 _x, ushort4 _m);
ushort4 __CVAttrs shuffle2(ushort8 _x, ushort8 _y, ushort4 _m);
ushort8 __CVAttrs shuffle(ushort8 _x, ushort8 _m);
ushort8 __CVAttrs shuffle2(ushort8 _x, ushort8 _y, ushort8 _m);
ushort16 __CVAttrs shuffle(ushort8 _x, ushort16 _m);
ushort16 __CVAttrs shuffle2(ushort8 _x, ushort8 _y, ushort16 _m);
ushort2 __CVAttrs shuffle(ushort16 _x, ushort2 _m);
ushort2 __CVAttrs shuffle2(ushort16 _x, ushort16 _y, ushort2 _m);
ushort4 __CVAttrs shuffle(ushort16 _x, ushort4 _m);
ushort4 __CVAttrs shuffle2(ushort16 _x, ushort16 _y, ushort4 _m);
ushort8 __CVAttrs shuffle(ushort16 _x, ushort8 _m);
ushort8 __CVAttrs shuffle2(ushort16 _x, ushort16 _y, ushort8 _m);
ushort16 __CVAttrs shuffle(ushort16 _x, ushort16 _m);
ushort16 __CVAttrs shuffle2(ushort16 _x, ushort16 _y, ushort16 _m);
int2 __CVAttrs shuffle(int2 _x, uint2 _m);
int2 __CVAttrs shuffle2(int2 _x, int2 _y, uint2 _m);
int4 __CVAttrs shuffle(int2 _x, uint4 _m);
int4 __CVAttrs shuffle2(int2 _x, int2 _y, uint4 _m);
int8 __CVAttrs shuffle(int2 _x, uint8 _m);
int8 __CVAttrs shuffle2(int2 _x, int2 _y, uint8 _m);
int16 __CVAttrs shuffle(int2 _x, uint16 _m);
int16 __CVAttrs shuffle2(int2 _x, int2 _y, uint16 _m);
int2 __CVAttrs shuffle(int4 _x, uint2 _m);
int2 __CVAttrs shuffle2(int4 _x, int4 _y, uint2 _m);
int4 __CVAttrs shuffle(int4 _x, uint4 _m);
int4 __CVAttrs shuffle2(int4 _x, int4 _y, uint4 _m);
int8 __CVAttrs shuffle(int4 _x, uint8 _m);
int8 __CVAttrs shuffle2(int4 _x, int4 _y, uint8 _m);
int16 __CVAttrs shuffle(int4 _x, uint16 _m);
int16 __CVAttrs shuffle2(int4 _x, int4 _y, uint16 _m);
int2 __CVAttrs shuffle(int8 _x, uint2 _m);
int2 __CVAttrs shuffle2(int8 _x, int8 _y, uint2 _m);
int4 __CVAttrs shuffle(int8 _x, uint4 _m);
int4 __CVAttrs shuffle2(int8 _x, int8 _y, uint4 _m);
int8 __CVAttrs shuffle(int8 _x, uint8 _m);
int8 __CVAttrs shuffle2(int8 _x, int8 _y, uint8 _m);
int16 __CVAttrs shuffle(int8 _x, uint16 _m);
int16 __CVAttrs shuffle2(int8 _x, int8 _y, uint16 _m);
int2 __CVAttrs shuffle(int16 _x, uint2 _m);
int2 __CVAttrs shuffle2(int16 _x, int16 _y, uint2 _m);
int4 __CVAttrs shuffle(int16 _x, uint4 _m);
int4 __CVAttrs shuffle2(int16 _x, int16 _y, uint4 _m);
int8 __CVAttrs shuffle(int16 _x, uint8 _m);
int8 __CVAttrs shuffle2(int16 _x, int16 _y, uint8 _m);
int16 __CVAttrs shuffle(int16 _x, uint16 _m);
int16 __CVAttrs shuffle2(int16 _x, int16 _y, uint16 _m);
uint2 __CVAttrs shuffle(uint2 _x, uint2 _m);
uint2 __CVAttrs shuffle2(uint2 _x, uint2 _y, uint2 _m);
uint4 __CVAttrs shuffle(uint2 _x, uint4 _m);
uint4 __CVAttrs shuffle2(uint2 _x, uint2 _y, uint4 _m);
uint8 __CVAttrs shuffle(uint2 _x, uint8 _m);
uint8 __CVAttrs shuffle2(uint2 _x, uint2 _y, uint8 _m);
uint16 __CVAttrs shuffle(uint2 _x, uint16 _m);
uint16 __CVAttrs shuffle2(uint2 _x, uint2 _y, uint16 _m);
uint2 __CVAttrs shuffle(uint4 _x, uint2 _m);
uint2 __CVAttrs shuffle2(uint4 _x, uint4 _y, uint2 _m);
uint4 __CVAttrs shuffle(uint4 _x, uint4 _m);
uint4 __CVAttrs shuffle2(uint4 _x, uint4 _y, uint4 _m);
uint8 __CVAttrs shuffle(uint4 _x, uint8 _m);
uint8 __CVAttrs shuffle2(uint4 _x, uint4 _y, uint8 _m);
uint16 __CVAttrs shuffle(uint4 _x, uint16 _m);
uint16 __CVAttrs shuffle2(uint4 _x, uint4 _y, uint16 _m);
uint2 __CVAttrs shuffle(uint8 _x, uint2 _m);
uint2 __CVAttrs shuffle2(uint8 _x, uint8 _y, uint2 _m);
uint4 __CVAttrs shuffle(uint8 _x, uint4 _m);
uint4 __CVAttrs shuffle2(uint8 _x, uint8 _y, uint4 _m);
uint8 __CVAttrs shuffle(uint8 _x, uint8 _m);
uint8 __CVAttrs shuffle2(uint8 _x, uint8 _y, uint8 _m);
uint16 __CVAttrs shuffle(uint8 _x, uint16 _m);
uint16 __CVAttrs shuffle2(uint8 _x, uint8 _y, uint16 _m);
uint2 __CVAttrs shuffle(uint16 _x, uint2 _m);
uint2 __CVAttrs shuffle2(uint16 _x, uint16 _y, uint2 _m);
uint4 __CVAttrs shuffle(uint16 _x, uint4 _m);
uint4 __CVAttrs shuffle2(uint16 _x, uint16 _y, uint4 _m);
uint8 __CVAttrs shuffle(uint16 _x, uint8 _m);
uint8 __CVAttrs shuffle2(uint16 _x, uint16 _y, uint8 _m);
uint16 __CVAttrs shuffle(uint16 _x, uint16 _m);
uint16 __CVAttrs shuffle2(uint16 _x, uint16 _y, uint16 _m);
long2 __CVAttrs shuffle(long2 _x, ulong2 _m);
long2 __CVAttrs shuffle2(long2 _x, long2 _y, ulong2 _m);
long4 __CVAttrs shuffle(long2 _x, ulong4 _m);
long4 __CVAttrs shuffle2(long2 _x, long2 _y, ulong4 _m);
long8 __CVAttrs shuffle(long2 _x, ulong8 _m);
long8 __CVAttrs shuffle2(long2 _x, long2 _y, ulong8 _m);
long16 __CVAttrs shuffle(long2 _x, ulong16 _m);
long16 __CVAttrs shuffle2(long2 _x, long2 _y, ulong16 _m);
long2 __CVAttrs shuffle(long4 _x, ulong2 _m);
long2 __CVAttrs shuffle2(long4 _x, long4 _y, ulong2 _m);
long4 __CVAttrs shuffle(long4 _x, ulong4 _m);
long4 __CVAttrs shuffle2(long4 _x, long4 _y, ulong4 _m);
long8 __CVAttrs shuffle(long4 _x, ulong8 _m);
long8 __CVAttrs shuffle2(long4 _x, long4 _y, ulong8 _m);
long16 __CVAttrs shuffle(long4 _x, ulong16 _m);
long16 __CVAttrs shuffle2(long4 _x, long4 _y, ulong16 _m);
long2 __CVAttrs shuffle(long8 _x, ulong2 _m);
long2 __CVAttrs shuffle2(long8 _x, long8 _y, ulong2 _m);
long4 __CVAttrs shuffle(long8 _x, ulong4 _m);
long4 __CVAttrs shuffle2(long8 _x, long8 _y, ulong4 _m);
long8 __CVAttrs shuffle(long8 _x, ulong8 _m);
long8 __CVAttrs shuffle2(long8 _x, long8 _y, ulong8 _m);
long16 __CVAttrs shuffle(long8 _x, ulong16 _m);
long16 __CVAttrs shuffle2(long8 _x, long8 _y, ulong16 _m);
long2 __CVAttrs shuffle(long16 _x, ulong2 _m);
long2 __CVAttrs shuffle2(long16 _x, long16 _y, ulong2 _m);
long4 __CVAttrs shuffle(long16 _x, ulong4 _m);
long4 __CVAttrs shuffle2(long16 _x, long16 _y, ulong4 _m);
long8 __CVAttrs shuffle(long16 _x, ulong8 _m);
long8 __CVAttrs shuffle2(long16 _x, long16 _y, ulong8 _m);
long16 __CVAttrs shuffle(long16 _x, ulong16 _m);
long16 __CVAttrs shuffle2(long16 _x, long16 _y, ulong16 _m);
ulong2 __CVAttrs shuffle(ulong2 _x, ulong2 _m);
ulong2 __CVAttrs shuffle2(ulong2 _x, ulong2 _y, ulong2 _m);
ulong4 __CVAttrs shuffle(ulong2 _x, ulong4 _m);
ulong4 __CVAttrs shuffle2(ulong2 _x, ulong2 _y, ulong4 _m);
ulong8 __CVAttrs shuffle(ulong2 _x, ulong8 _m);
ulong8 __CVAttrs shuffle2(ulong2 _x, ulong2 _y, ulong8 _m);
ulong16 __CVAttrs shuffle(ulong2 _x, ulong16 _m);
ulong16 __CVAttrs shuffle2(ulong2 _x, ulong2 _y, ulong16 _m);
ulong2 __CVAttrs shuffle(ulong4 _x, ulong2 _m);
ulong2 __CVAttrs shuffle2(ulong4 _x, ulong4 _y, ulong2 _m);
ulong4 __CVAttrs shuffle(ulong4 _x, ulong4 _m);
ulong4 __CVAttrs shuffle2(ulong4 _x, ulong4 _y, ulong4 _m);
ulong8 __CVAttrs shuffle(ulong4 _x, ulong8 _m);
ulong8 __CVAttrs shuffle2(ulong4 _x, ulong4 _y, ulong8 _m);
ulong16 __CVAttrs shuffle(ulong4 _x, ulong16 _m);
ulong16 __CVAttrs shuffle2(ulong4 _x, ulong4 _y, ulong16 _m);
ulong2 __CVAttrs shuffle(ulong8 _x, ulong2 _m);
ulong2 __CVAttrs shuffle2(ulong8 _x, ulong8 _y, ulong2 _m);
ulong4 __CVAttrs shuffle(ulong8 _x, ulong4 _m);
ulong4 __CVAttrs shuffle2(ulong8 _x, ulong8 _y, ulong4 _m);
ulong8 __CVAttrs shuffle(ulong8 _x, ulong8 _m);
ulong8 __CVAttrs shuffle2(ulong8 _x, ulong8 _y, ulong8 _m);
ulong16 __CVAttrs shuffle(ulong8 _x, ulong16 _m);
ulong16 __CVAttrs shuffle2(ulong8 _x, ulong8 _y, ulong16 _m);
ulong2 __CVAttrs shuffle(ulong16 _x, ulong2 _m);
ulong2 __CVAttrs shuffle2(ulong16 _x, ulong16 _y, ulong2 _m);
ulong4 __CVAttrs shuffle(ulong16 _x, ulong4 _m);
ulong4 __CVAttrs shuffle2(ulong16 _x, ulong16 _y, ulong4 _m);
ulong8 __CVAttrs shuffle(ulong16 _x, ulong8 _m);
ulong8 __CVAttrs shuffle2(ulong16 _x, ulong16 _y, ulong8 _m);
ulong16 __CVAttrs shuffle(ulong16 _x, ulong16 _m);
ulong16 __CVAttrs shuffle2(ulong16 _x, ulong16 _y, ulong16 _m);
float2 __CVAttrs shuffle(float2 _x, uint2 _m);
float2 __CVAttrs shuffle2(float2 _x, float2 _y, uint2 _m);
float4 __CVAttrs shuffle(float2 _x, uint4 _m);
float4 __CVAttrs shuffle2(float2 _x, float2 _y, uint4 _m);
float8 __CVAttrs shuffle(float2 _x, uint8 _m);
float8 __CVAttrs shuffle2(float2 _x, float2 _y, uint8 _m);
float16 __CVAttrs shuffle(float2 _x, uint16 _m);
float16 __CVAttrs shuffle2(float2 _x, float2 _y, uint16 _m);
float2 __CVAttrs shuffle(float4 _x, uint2 _m);
float2 __CVAttrs shuffle2(float4 _x, float4 _y, uint2 _m);
float4 __CVAttrs shuffle(float4 _x, uint4 _m);
float4 __CVAttrs shuffle2(float4 _x, float4 _y, uint4 _m);
float8 __CVAttrs shuffle(float4 _x, uint8 _m);
float8 __CVAttrs shuffle2(float4 _x, float4 _y, uint8 _m);
float16 __CVAttrs shuffle(float4 _x, uint16 _m);
float16 __CVAttrs shuffle2(float4 _x, float4 _y, uint16 _m);
float2 __CVAttrs shuffle(float8 _x, uint2 _m);
float2 __CVAttrs shuffle2(float8 _x, float8 _y, uint2 _m);
float4 __CVAttrs shuffle(float8 _x, uint4 _m);
float4 __CVAttrs shuffle2(float8 _x, float8 _y, uint4 _m);
float8 __CVAttrs shuffle(float8 _x, uint8 _m);
float8 __CVAttrs shuffle2(float8 _x, float8 _y, uint8 _m);
float16 __CVAttrs shuffle(float8 _x, uint16 _m);
float16 __CVAttrs shuffle2(float8 _x, float8 _y, uint16 _m);
float2 __CVAttrs shuffle(float16 _x, uint2 _m);
float2 __CVAttrs shuffle2(float16 _x, float16 _y, uint2 _m);
float4 __CVAttrs shuffle(float16 _x, uint4 _m);
float4 __CVAttrs shuffle2(float16 _x, float16 _y, uint4 _m);
float8 __CVAttrs shuffle(float16 _x, uint8 _m);
float8 __CVAttrs shuffle2(float16 _x, float16 _y, uint8 _m);
float16 __CVAttrs shuffle(float16 _x, uint16 _m);
float16 __CVAttrs shuffle2(float16 _x, float16 _y, uint16 _m);
double2 __CVAttrs shuffle(double2 _x, ulong2 _m);
double2 __CVAttrs shuffle2(double2 _x, double2 _y, ulong2 _m);
double4 __CVAttrs shuffle(double2 _x, ulong4 _m);
double4 __CVAttrs shuffle2(double2 _x, double2 _y, ulong4 _m);
double8 __CVAttrs shuffle(double2 _x, ulong8 _m);
double8 __CVAttrs shuffle2(double2 _x, double2 _y, ulong8 _m);
double16 __CVAttrs shuffle(double2 _x, ulong16 _m);
double16 __CVAttrs shuffle2(double2 _x, double2 _y, ulong16 _m);
double2 __CVAttrs shuffle(double4 _x, ulong2 _m);
double2 __CVAttrs shuffle2(double4 _x, double4 _y, ulong2 _m);
double4 __CVAttrs shuffle(double4 _x, ulong4 _m);
double4 __CVAttrs shuffle2(double4 _x, double4 _y, ulong4 _m);
double8 __CVAttrs shuffle(double4 _x, ulong8 _m);
double8 __CVAttrs shuffle2(double4 _x, double4 _y, ulong8 _m);
double16 __CVAttrs shuffle(double4 _x, ulong16 _m);
double16 __CVAttrs shuffle2(double4 _x, double4 _y, ulong16 _m);
double2 __CVAttrs shuffle(double8 _x, ulong2 _m);
double2 __CVAttrs shuffle2(double8 _x, double8 _y, ulong2 _m);
double4 __CVAttrs shuffle(double8 _x, ulong4 _m);
double4 __CVAttrs shuffle2(double8 _x, double8 _y, ulong4 _m);
double8 __CVAttrs shuffle(double8 _x, ulong8 _m);
double8 __CVAttrs shuffle2(double8 _x, double8 _y, ulong8 _m);
double16 __CVAttrs shuffle(double8 _x, ulong16 _m);
double16 __CVAttrs shuffle2(double8 _x, double8 _y, ulong16 _m);
double2 __CVAttrs shuffle(double16 _x, ulong2 _m);
double2 __CVAttrs shuffle2(double16 _x, double16 _y, ulong2 _m);
double4 __CVAttrs shuffle(double16 _x, ulong4 _m);
double4 __CVAttrs shuffle2(double16 _x, double16 _y, ulong4 _m);
double8 __CVAttrs shuffle(double16 _x, ulong8 _m);
double8 __CVAttrs shuffle2(double16 _x, double16 _y, ulong8 _m);
double16 __CVAttrs shuffle(double16 _x, ulong16 _m);
double16 __CVAttrs shuffle2(double16 _x, double16 _y, ulong16 _m);
#undef __CVAttrs

#endif
char2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rchar2( size_t offset, const global char* p);
inline char2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global char*  y);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global char*  y){ return (char2)( __spirv_ocl_vload2__Rchar2(x, y)); }
#endif
char2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rchar2( size_t offset, const local char* p);
inline char2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local char*  y);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local char*  y){ return (char2)( __spirv_ocl_vload2__Rchar2(x, y)); }
#endif
char2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rchar2( size_t offset, const constant char* p);
inline char2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant char*  y);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant char*  y){ return (char2)( __spirv_ocl_vload2__Rchar2(x, y)); }
#endif
char2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rchar2( size_t offset, const private char* p);
inline char2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private char*  y);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private char*  y){ return (char2)( __spirv_ocl_vload2__Rchar2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rchar3( size_t offset, const global char* p);
inline char3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global char*  y);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global char*  y){ return (char3)( __spirv_ocl_vload3__Rchar3(x, y)); }
#endif
char3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rchar3( size_t offset, const local char* p);
inline char3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local char*  y);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local char*  y){ return (char3)( __spirv_ocl_vload3__Rchar3(x, y)); }
#endif
char3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rchar3( size_t offset, const constant char* p);
inline char3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant char*  y);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant char*  y){ return (char3)( __spirv_ocl_vload3__Rchar3(x, y)); }
#endif
char3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rchar3( size_t offset, const private char* p);
inline char3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private char*  y);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private char*  y){ return (char3)( __spirv_ocl_vload3__Rchar3(x, y)); }
#endif
#endif
char4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rchar4( size_t offset, const global char* p);
inline char4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global char*  y);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global char*  y){ return (char4)( __spirv_ocl_vload4__Rchar4(x, y)); }
#endif
char4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rchar4( size_t offset, const local char* p);
inline char4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local char*  y);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local char*  y){ return (char4)( __spirv_ocl_vload4__Rchar4(x, y)); }
#endif
char4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rchar4( size_t offset, const constant char* p);
inline char4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant char*  y);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant char*  y){ return (char4)( __spirv_ocl_vload4__Rchar4(x, y)); }
#endif
char4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rchar4( size_t offset, const private char* p);
inline char4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private char*  y);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private char*  y){ return (char4)( __spirv_ocl_vload4__Rchar4(x, y)); }
#endif
char8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rchar8( size_t offset, const global char* p);
inline char8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global char*  y);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global char*  y){ return (char8)( __spirv_ocl_vload8__Rchar8(x, y)); }
#endif
char8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rchar8( size_t offset, const local char* p);
inline char8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local char*  y);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local char*  y){ return (char8)( __spirv_ocl_vload8__Rchar8(x, y)); }
#endif
char8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rchar8( size_t offset, const constant char* p);
inline char8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant char*  y);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant char*  y){ return (char8)( __spirv_ocl_vload8__Rchar8(x, y)); }
#endif
char8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rchar8( size_t offset, const private char* p);
inline char8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private char*  y);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private char*  y){ return (char8)( __spirv_ocl_vload8__Rchar8(x, y)); }
#endif
char16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rchar16( size_t offset, const global char* p);
inline char16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global char*  y);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global char*  y){ return (char16)( __spirv_ocl_vload16__Rchar16(x, y)); }
#endif
char16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rchar16( size_t offset, const local char* p);
inline char16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local char*  y);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local char*  y){ return (char16)( __spirv_ocl_vload16__Rchar16(x, y)); }
#endif
char16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rchar16( size_t offset, const constant char* p);
inline char16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant char*  y);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant char*  y){ return (char16)( __spirv_ocl_vload16__Rchar16(x, y)); }
#endif
char16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rchar16( size_t offset, const private char* p);
inline char16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private char*  y);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private char*  y){ return (char16)( __spirv_ocl_vload16__Rchar16(x, y)); }
#endif
uchar2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Ruchar2( size_t offset, const global uchar* p);
inline uchar2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global uchar*  y);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global uchar*  y){ return (uchar2)( __spirv_ocl_vload2__Ruchar2(x, y)); }
#endif
uchar2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Ruchar2( size_t offset, const local uchar* p);
inline uchar2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local uchar*  y);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local uchar*  y){ return (uchar2)( __spirv_ocl_vload2__Ruchar2(x, y)); }
#endif
uchar2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Ruchar2( size_t offset, const constant uchar* p);
inline uchar2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant uchar*  y);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant uchar*  y){ return (uchar2)( __spirv_ocl_vload2__Ruchar2(x, y)); }
#endif
uchar2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Ruchar2( size_t offset, const private uchar* p);
inline uchar2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private uchar*  y);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private uchar*  y){ return (uchar2)( __spirv_ocl_vload2__Ruchar2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uchar3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Ruchar3( size_t offset, const global uchar* p);
inline uchar3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global uchar*  y);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global uchar*  y){ return (uchar3)( __spirv_ocl_vload3__Ruchar3(x, y)); }
#endif
uchar3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Ruchar3( size_t offset, const local uchar* p);
inline uchar3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local uchar*  y);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local uchar*  y){ return (uchar3)( __spirv_ocl_vload3__Ruchar3(x, y)); }
#endif
uchar3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Ruchar3( size_t offset, const constant uchar* p);
inline uchar3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant uchar*  y);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant uchar*  y){ return (uchar3)( __spirv_ocl_vload3__Ruchar3(x, y)); }
#endif
uchar3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Ruchar3( size_t offset, const private uchar* p);
inline uchar3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private uchar*  y);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private uchar*  y){ return (uchar3)( __spirv_ocl_vload3__Ruchar3(x, y)); }
#endif
#endif
uchar4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Ruchar4( size_t offset, const global uchar* p);
inline uchar4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global uchar*  y);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global uchar*  y){ return (uchar4)( __spirv_ocl_vload4__Ruchar4(x, y)); }
#endif
uchar4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Ruchar4( size_t offset, const local uchar* p);
inline uchar4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local uchar*  y);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local uchar*  y){ return (uchar4)( __spirv_ocl_vload4__Ruchar4(x, y)); }
#endif
uchar4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Ruchar4( size_t offset, const constant uchar* p);
inline uchar4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant uchar*  y);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant uchar*  y){ return (uchar4)( __spirv_ocl_vload4__Ruchar4(x, y)); }
#endif
uchar4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Ruchar4( size_t offset, const private uchar* p);
inline uchar4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private uchar*  y);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private uchar*  y){ return (uchar4)( __spirv_ocl_vload4__Ruchar4(x, y)); }
#endif
uchar8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Ruchar8( size_t offset, const global uchar* p);
inline uchar8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global uchar*  y);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global uchar*  y){ return (uchar8)( __spirv_ocl_vload8__Ruchar8(x, y)); }
#endif
uchar8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Ruchar8( size_t offset, const local uchar* p);
inline uchar8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local uchar*  y);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local uchar*  y){ return (uchar8)( __spirv_ocl_vload8__Ruchar8(x, y)); }
#endif
uchar8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Ruchar8( size_t offset, const constant uchar* p);
inline uchar8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant uchar*  y);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant uchar*  y){ return (uchar8)( __spirv_ocl_vload8__Ruchar8(x, y)); }
#endif
uchar8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Ruchar8( size_t offset, const private uchar* p);
inline uchar8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private uchar*  y);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private uchar*  y){ return (uchar8)( __spirv_ocl_vload8__Ruchar8(x, y)); }
#endif
uchar16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Ruchar16( size_t offset, const global uchar* p);
inline uchar16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global uchar*  y);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global uchar*  y){ return (uchar16)( __spirv_ocl_vload16__Ruchar16(x, y)); }
#endif
uchar16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Ruchar16( size_t offset, const local uchar* p);
inline uchar16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local uchar*  y);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local uchar*  y){ return (uchar16)( __spirv_ocl_vload16__Ruchar16(x, y)); }
#endif
uchar16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Ruchar16( size_t offset, const constant uchar* p);
inline uchar16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant uchar*  y);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant uchar*  y){ return (uchar16)( __spirv_ocl_vload16__Ruchar16(x, y)); }
#endif
uchar16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Ruchar16( size_t offset, const private uchar* p);
inline uchar16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private uchar*  y);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private uchar*  y){ return (uchar16)( __spirv_ocl_vload16__Ruchar16(x, y)); }
#endif
short2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rshort2( size_t offset, const global short* p);
inline short2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global short*  y);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global short*  y){ return (short2)( __spirv_ocl_vload2__Rshort2(x, y)); }
#endif
short2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rshort2( size_t offset, const local short* p);
inline short2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local short*  y);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local short*  y){ return (short2)( __spirv_ocl_vload2__Rshort2(x, y)); }
#endif
short2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rshort2( size_t offset, const constant short* p);
inline short2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant short*  y);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant short*  y){ return (short2)( __spirv_ocl_vload2__Rshort2(x, y)); }
#endif
short2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rshort2( size_t offset, const private short* p);
inline short2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private short*  y);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private short*  y){ return (short2)( __spirv_ocl_vload2__Rshort2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
short3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rshort3( size_t offset, const global short* p);
inline short3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global short*  y);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global short*  y){ return (short3)( __spirv_ocl_vload3__Rshort3(x, y)); }
#endif
short3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rshort3( size_t offset, const local short* p);
inline short3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local short*  y);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local short*  y){ return (short3)( __spirv_ocl_vload3__Rshort3(x, y)); }
#endif
short3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rshort3( size_t offset, const constant short* p);
inline short3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant short*  y);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant short*  y){ return (short3)( __spirv_ocl_vload3__Rshort3(x, y)); }
#endif
short3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rshort3( size_t offset, const private short* p);
inline short3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private short*  y);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private short*  y){ return (short3)( __spirv_ocl_vload3__Rshort3(x, y)); }
#endif
#endif
short4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rshort4( size_t offset, const global short* p);
inline short4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global short*  y);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global short*  y){ return (short4)( __spirv_ocl_vload4__Rshort4(x, y)); }
#endif
short4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rshort4( size_t offset, const local short* p);
inline short4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local short*  y);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local short*  y){ return (short4)( __spirv_ocl_vload4__Rshort4(x, y)); }
#endif
short4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rshort4( size_t offset, const constant short* p);
inline short4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant short*  y);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant short*  y){ return (short4)( __spirv_ocl_vload4__Rshort4(x, y)); }
#endif
short4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rshort4( size_t offset, const private short* p);
inline short4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private short*  y);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private short*  y){ return (short4)( __spirv_ocl_vload4__Rshort4(x, y)); }
#endif
short8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rshort8( size_t offset, const global short* p);
inline short8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global short*  y);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global short*  y){ return (short8)( __spirv_ocl_vload8__Rshort8(x, y)); }
#endif
short8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rshort8( size_t offset, const local short* p);
inline short8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local short*  y);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local short*  y){ return (short8)( __spirv_ocl_vload8__Rshort8(x, y)); }
#endif
short8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rshort8( size_t offset, const constant short* p);
inline short8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant short*  y);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant short*  y){ return (short8)( __spirv_ocl_vload8__Rshort8(x, y)); }
#endif
short8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rshort8( size_t offset, const private short* p);
inline short8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private short*  y);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private short*  y){ return (short8)( __spirv_ocl_vload8__Rshort8(x, y)); }
#endif
short16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rshort16( size_t offset, const global short* p);
inline short16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global short*  y);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global short*  y){ return (short16)( __spirv_ocl_vload16__Rshort16(x, y)); }
#endif
short16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rshort16( size_t offset, const local short* p);
inline short16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local short*  y);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local short*  y){ return (short16)( __spirv_ocl_vload16__Rshort16(x, y)); }
#endif
short16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rshort16( size_t offset, const constant short* p);
inline short16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant short*  y);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant short*  y){ return (short16)( __spirv_ocl_vload16__Rshort16(x, y)); }
#endif
short16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rshort16( size_t offset, const private short* p);
inline short16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private short*  y);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private short*  y){ return (short16)( __spirv_ocl_vload16__Rshort16(x, y)); }
#endif
ushort2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rushort2( size_t offset, const global ushort* p);
inline ushort2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global ushort*  y);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global ushort*  y){ return (ushort2)( __spirv_ocl_vload2__Rushort2(x, y)); }
#endif
ushort2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rushort2( size_t offset, const local ushort* p);
inline ushort2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local ushort*  y);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local ushort*  y){ return (ushort2)( __spirv_ocl_vload2__Rushort2(x, y)); }
#endif
ushort2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rushort2( size_t offset, const constant ushort* p);
inline ushort2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant ushort*  y);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant ushort*  y){ return (ushort2)( __spirv_ocl_vload2__Rushort2(x, y)); }
#endif
ushort2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rushort2( size_t offset, const private ushort* p);
inline ushort2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private ushort*  y);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private ushort*  y){ return (ushort2)( __spirv_ocl_vload2__Rushort2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ushort3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rushort3( size_t offset, const global ushort* p);
inline ushort3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global ushort*  y);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global ushort*  y){ return (ushort3)( __spirv_ocl_vload3__Rushort3(x, y)); }
#endif
ushort3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rushort3( size_t offset, const local ushort* p);
inline ushort3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local ushort*  y);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local ushort*  y){ return (ushort3)( __spirv_ocl_vload3__Rushort3(x, y)); }
#endif
ushort3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rushort3( size_t offset, const constant ushort* p);
inline ushort3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant ushort*  y);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant ushort*  y){ return (ushort3)( __spirv_ocl_vload3__Rushort3(x, y)); }
#endif
ushort3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rushort3( size_t offset, const private ushort* p);
inline ushort3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private ushort*  y);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private ushort*  y){ return (ushort3)( __spirv_ocl_vload3__Rushort3(x, y)); }
#endif
#endif
ushort4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rushort4( size_t offset, const global ushort* p);
inline ushort4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global ushort*  y);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global ushort*  y){ return (ushort4)( __spirv_ocl_vload4__Rushort4(x, y)); }
#endif
ushort4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rushort4( size_t offset, const local ushort* p);
inline ushort4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local ushort*  y);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local ushort*  y){ return (ushort4)( __spirv_ocl_vload4__Rushort4(x, y)); }
#endif
ushort4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rushort4( size_t offset, const constant ushort* p);
inline ushort4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant ushort*  y);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant ushort*  y){ return (ushort4)( __spirv_ocl_vload4__Rushort4(x, y)); }
#endif
ushort4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rushort4( size_t offset, const private ushort* p);
inline ushort4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private ushort*  y);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private ushort*  y){ return (ushort4)( __spirv_ocl_vload4__Rushort4(x, y)); }
#endif
ushort8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rushort8( size_t offset, const global ushort* p);
inline ushort8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global ushort*  y);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global ushort*  y){ return (ushort8)( __spirv_ocl_vload8__Rushort8(x, y)); }
#endif
ushort8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rushort8( size_t offset, const local ushort* p);
inline ushort8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local ushort*  y);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local ushort*  y){ return (ushort8)( __spirv_ocl_vload8__Rushort8(x, y)); }
#endif
ushort8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rushort8( size_t offset, const constant ushort* p);
inline ushort8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant ushort*  y);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant ushort*  y){ return (ushort8)( __spirv_ocl_vload8__Rushort8(x, y)); }
#endif
ushort8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rushort8( size_t offset, const private ushort* p);
inline ushort8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private ushort*  y);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private ushort*  y){ return (ushort8)( __spirv_ocl_vload8__Rushort8(x, y)); }
#endif
ushort16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rushort16( size_t offset, const global ushort* p);
inline ushort16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global ushort*  y);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global ushort*  y){ return (ushort16)( __spirv_ocl_vload16__Rushort16(x, y)); }
#endif
ushort16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rushort16( size_t offset, const local ushort* p);
inline ushort16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local ushort*  y);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local ushort*  y){ return (ushort16)( __spirv_ocl_vload16__Rushort16(x, y)); }
#endif
ushort16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rushort16( size_t offset, const constant ushort* p);
inline ushort16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant ushort*  y);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant ushort*  y){ return (ushort16)( __spirv_ocl_vload16__Rushort16(x, y)); }
#endif
ushort16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rushort16( size_t offset, const private ushort* p);
inline ushort16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private ushort*  y);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private ushort*  y){ return (ushort16)( __spirv_ocl_vload16__Rushort16(x, y)); }
#endif
int2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rint2( size_t offset, const global int* p);
inline int2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global int*  y);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global int*  y){ return (int2)( __spirv_ocl_vload2__Rint2(x, y)); }
#endif
int2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rint2( size_t offset, const local int* p);
inline int2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local int*  y);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local int*  y){ return (int2)( __spirv_ocl_vload2__Rint2(x, y)); }
#endif
int2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rint2( size_t offset, const constant int* p);
inline int2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant int*  y);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant int*  y){ return (int2)( __spirv_ocl_vload2__Rint2(x, y)); }
#endif
int2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rint2( size_t offset, const private int* p);
inline int2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private int*  y);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private int*  y){ return (int2)( __spirv_ocl_vload2__Rint2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
int3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rint3( size_t offset, const global int* p);
inline int3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global int*  y);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global int*  y){ return (int3)( __spirv_ocl_vload3__Rint3(x, y)); }
#endif
int3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rint3( size_t offset, const local int* p);
inline int3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local int*  y);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local int*  y){ return (int3)( __spirv_ocl_vload3__Rint3(x, y)); }
#endif
int3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rint3( size_t offset, const constant int* p);
inline int3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant int*  y);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant int*  y){ return (int3)( __spirv_ocl_vload3__Rint3(x, y)); }
#endif
int3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rint3( size_t offset, const private int* p);
inline int3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private int*  y);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private int*  y){ return (int3)( __spirv_ocl_vload3__Rint3(x, y)); }
#endif
#endif
int4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rint4( size_t offset, const global int* p);
inline int4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global int*  y);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global int*  y){ return (int4)( __spirv_ocl_vload4__Rint4(x, y)); }
#endif
int4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rint4( size_t offset, const local int* p);
inline int4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local int*  y);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local int*  y){ return (int4)( __spirv_ocl_vload4__Rint4(x, y)); }
#endif
int4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rint4( size_t offset, const constant int* p);
inline int4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant int*  y);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant int*  y){ return (int4)( __spirv_ocl_vload4__Rint4(x, y)); }
#endif
int4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rint4( size_t offset, const private int* p);
inline int4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private int*  y);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private int*  y){ return (int4)( __spirv_ocl_vload4__Rint4(x, y)); }
#endif
int8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rint8( size_t offset, const global int* p);
inline int8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global int*  y);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global int*  y){ return (int8)( __spirv_ocl_vload8__Rint8(x, y)); }
#endif
int8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rint8( size_t offset, const local int* p);
inline int8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local int*  y);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local int*  y){ return (int8)( __spirv_ocl_vload8__Rint8(x, y)); }
#endif
int8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rint8( size_t offset, const constant int* p);
inline int8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant int*  y);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant int*  y){ return (int8)( __spirv_ocl_vload8__Rint8(x, y)); }
#endif
int8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rint8( size_t offset, const private int* p);
inline int8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private int*  y);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private int*  y){ return (int8)( __spirv_ocl_vload8__Rint8(x, y)); }
#endif
int16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rint16( size_t offset, const global int* p);
inline int16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global int*  y);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global int*  y){ return (int16)( __spirv_ocl_vload16__Rint16(x, y)); }
#endif
int16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rint16( size_t offset, const local int* p);
inline int16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local int*  y);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local int*  y){ return (int16)( __spirv_ocl_vload16__Rint16(x, y)); }
#endif
int16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rint16( size_t offset, const constant int* p);
inline int16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant int*  y);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant int*  y){ return (int16)( __spirv_ocl_vload16__Rint16(x, y)); }
#endif
int16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rint16( size_t offset, const private int* p);
inline int16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private int*  y);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private int*  y){ return (int16)( __spirv_ocl_vload16__Rint16(x, y)); }
#endif
uint2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Ruint2( size_t offset, const global uint* p);
inline uint2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global uint*  y);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global uint*  y){ return (uint2)( __spirv_ocl_vload2__Ruint2(x, y)); }
#endif
uint2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Ruint2( size_t offset, const local uint* p);
inline uint2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local uint*  y);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local uint*  y){ return (uint2)( __spirv_ocl_vload2__Ruint2(x, y)); }
#endif
uint2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Ruint2( size_t offset, const constant uint* p);
inline uint2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant uint*  y);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant uint*  y){ return (uint2)( __spirv_ocl_vload2__Ruint2(x, y)); }
#endif
uint2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Ruint2( size_t offset, const private uint* p);
inline uint2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private uint*  y);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private uint*  y){ return (uint2)( __spirv_ocl_vload2__Ruint2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uint3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Ruint3( size_t offset, const global uint* p);
inline uint3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global uint*  y);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global uint*  y){ return (uint3)( __spirv_ocl_vload3__Ruint3(x, y)); }
#endif
uint3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Ruint3( size_t offset, const local uint* p);
inline uint3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local uint*  y);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local uint*  y){ return (uint3)( __spirv_ocl_vload3__Ruint3(x, y)); }
#endif
uint3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Ruint3( size_t offset, const constant uint* p);
inline uint3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant uint*  y);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant uint*  y){ return (uint3)( __spirv_ocl_vload3__Ruint3(x, y)); }
#endif
uint3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Ruint3( size_t offset, const private uint* p);
inline uint3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private uint*  y);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private uint*  y){ return (uint3)( __spirv_ocl_vload3__Ruint3(x, y)); }
#endif
#endif
uint4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Ruint4( size_t offset, const global uint* p);
inline uint4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global uint*  y);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global uint*  y){ return (uint4)( __spirv_ocl_vload4__Ruint4(x, y)); }
#endif
uint4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Ruint4( size_t offset, const local uint* p);
inline uint4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local uint*  y);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local uint*  y){ return (uint4)( __spirv_ocl_vload4__Ruint4(x, y)); }
#endif
uint4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Ruint4( size_t offset, const constant uint* p);
inline uint4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant uint*  y);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant uint*  y){ return (uint4)( __spirv_ocl_vload4__Ruint4(x, y)); }
#endif
uint4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Ruint4( size_t offset, const private uint* p);
inline uint4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private uint*  y);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private uint*  y){ return (uint4)( __spirv_ocl_vload4__Ruint4(x, y)); }
#endif
uint8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Ruint8( size_t offset, const global uint* p);
inline uint8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global uint*  y);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global uint*  y){ return (uint8)( __spirv_ocl_vload8__Ruint8(x, y)); }
#endif
uint8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Ruint8( size_t offset, const local uint* p);
inline uint8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local uint*  y);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local uint*  y){ return (uint8)( __spirv_ocl_vload8__Ruint8(x, y)); }
#endif
uint8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Ruint8( size_t offset, const constant uint* p);
inline uint8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant uint*  y);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant uint*  y){ return (uint8)( __spirv_ocl_vload8__Ruint8(x, y)); }
#endif
uint8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Ruint8( size_t offset, const private uint* p);
inline uint8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private uint*  y);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private uint*  y){ return (uint8)( __spirv_ocl_vload8__Ruint8(x, y)); }
#endif
uint16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Ruint16( size_t offset, const global uint* p);
inline uint16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global uint*  y);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global uint*  y){ return (uint16)( __spirv_ocl_vload16__Ruint16(x, y)); }
#endif
uint16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Ruint16( size_t offset, const local uint* p);
inline uint16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local uint*  y);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local uint*  y){ return (uint16)( __spirv_ocl_vload16__Ruint16(x, y)); }
#endif
uint16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Ruint16( size_t offset, const constant uint* p);
inline uint16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant uint*  y);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant uint*  y){ return (uint16)( __spirv_ocl_vload16__Ruint16(x, y)); }
#endif
uint16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Ruint16( size_t offset, const private uint* p);
inline uint16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private uint*  y);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private uint*  y){ return (uint16)( __spirv_ocl_vload16__Ruint16(x, y)); }
#endif
long2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rlong2( size_t offset, const global long* p);
inline long2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global long*  y);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global long*  y){ return (long2)( __spirv_ocl_vload2__Rlong2(x, y)); }
#endif
long2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rlong2( size_t offset, const local long* p);
inline long2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local long*  y);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local long*  y){ return (long2)( __spirv_ocl_vload2__Rlong2(x, y)); }
#endif
long2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rlong2( size_t offset, const constant long* p);
inline long2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant long*  y);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant long*  y){ return (long2)( __spirv_ocl_vload2__Rlong2(x, y)); }
#endif
long2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rlong2( size_t offset, const private long* p);
inline long2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private long*  y);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private long*  y){ return (long2)( __spirv_ocl_vload2__Rlong2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
long3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rlong3( size_t offset, const global long* p);
inline long3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global long*  y);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global long*  y){ return (long3)( __spirv_ocl_vload3__Rlong3(x, y)); }
#endif
long3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rlong3( size_t offset, const local long* p);
inline long3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local long*  y);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local long*  y){ return (long3)( __spirv_ocl_vload3__Rlong3(x, y)); }
#endif
long3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rlong3( size_t offset, const constant long* p);
inline long3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant long*  y);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant long*  y){ return (long3)( __spirv_ocl_vload3__Rlong3(x, y)); }
#endif
long3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rlong3( size_t offset, const private long* p);
inline long3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private long*  y);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private long*  y){ return (long3)( __spirv_ocl_vload3__Rlong3(x, y)); }
#endif
#endif
long4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rlong4( size_t offset, const global long* p);
inline long4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global long*  y);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global long*  y){ return (long4)( __spirv_ocl_vload4__Rlong4(x, y)); }
#endif
long4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rlong4( size_t offset, const local long* p);
inline long4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local long*  y);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local long*  y){ return (long4)( __spirv_ocl_vload4__Rlong4(x, y)); }
#endif
long4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rlong4( size_t offset, const constant long* p);
inline long4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant long*  y);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant long*  y){ return (long4)( __spirv_ocl_vload4__Rlong4(x, y)); }
#endif
long4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rlong4( size_t offset, const private long* p);
inline long4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private long*  y);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private long*  y){ return (long4)( __spirv_ocl_vload4__Rlong4(x, y)); }
#endif
long8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rlong8( size_t offset, const global long* p);
inline long8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global long*  y);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global long*  y){ return (long8)( __spirv_ocl_vload8__Rlong8(x, y)); }
#endif
long8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rlong8( size_t offset, const local long* p);
inline long8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local long*  y);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local long*  y){ return (long8)( __spirv_ocl_vload8__Rlong8(x, y)); }
#endif
long8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rlong8( size_t offset, const constant long* p);
inline long8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant long*  y);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant long*  y){ return (long8)( __spirv_ocl_vload8__Rlong8(x, y)); }
#endif
long8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rlong8( size_t offset, const private long* p);
inline long8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private long*  y);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private long*  y){ return (long8)( __spirv_ocl_vload8__Rlong8(x, y)); }
#endif
long16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rlong16( size_t offset, const global long* p);
inline long16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global long*  y);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global long*  y){ return (long16)( __spirv_ocl_vload16__Rlong16(x, y)); }
#endif
long16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rlong16( size_t offset, const local long* p);
inline long16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local long*  y);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local long*  y){ return (long16)( __spirv_ocl_vload16__Rlong16(x, y)); }
#endif
long16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rlong16( size_t offset, const constant long* p);
inline long16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant long*  y);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant long*  y){ return (long16)( __spirv_ocl_vload16__Rlong16(x, y)); }
#endif
long16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rlong16( size_t offset, const private long* p);
inline long16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private long*  y);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private long*  y){ return (long16)( __spirv_ocl_vload16__Rlong16(x, y)); }
#endif
ulong2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rulong2( size_t offset, const global ulong* p);
inline ulong2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global ulong*  y);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global ulong*  y){ return (ulong2)( __spirv_ocl_vload2__Rulong2(x, y)); }
#endif
ulong2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rulong2( size_t offset, const local ulong* p);
inline ulong2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local ulong*  y);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local ulong*  y){ return (ulong2)( __spirv_ocl_vload2__Rulong2(x, y)); }
#endif
ulong2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rulong2( size_t offset, const constant ulong* p);
inline ulong2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant ulong*  y);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant ulong*  y){ return (ulong2)( __spirv_ocl_vload2__Rulong2(x, y)); }
#endif
ulong2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rulong2( size_t offset, const private ulong* p);
inline ulong2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private ulong*  y);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private ulong*  y){ return (ulong2)( __spirv_ocl_vload2__Rulong2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ulong3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rulong3( size_t offset, const global ulong* p);
inline ulong3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global ulong*  y);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global ulong*  y){ return (ulong3)( __spirv_ocl_vload3__Rulong3(x, y)); }
#endif
ulong3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rulong3( size_t offset, const local ulong* p);
inline ulong3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local ulong*  y);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local ulong*  y){ return (ulong3)( __spirv_ocl_vload3__Rulong3(x, y)); }
#endif
ulong3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rulong3( size_t offset, const constant ulong* p);
inline ulong3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant ulong*  y);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant ulong*  y){ return (ulong3)( __spirv_ocl_vload3__Rulong3(x, y)); }
#endif
ulong3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rulong3( size_t offset, const private ulong* p);
inline ulong3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private ulong*  y);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private ulong*  y){ return (ulong3)( __spirv_ocl_vload3__Rulong3(x, y)); }
#endif
#endif
ulong4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rulong4( size_t offset, const global ulong* p);
inline ulong4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global ulong*  y);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global ulong*  y){ return (ulong4)( __spirv_ocl_vload4__Rulong4(x, y)); }
#endif
ulong4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rulong4( size_t offset, const local ulong* p);
inline ulong4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local ulong*  y);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local ulong*  y){ return (ulong4)( __spirv_ocl_vload4__Rulong4(x, y)); }
#endif
ulong4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rulong4( size_t offset, const constant ulong* p);
inline ulong4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant ulong*  y);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant ulong*  y){ return (ulong4)( __spirv_ocl_vload4__Rulong4(x, y)); }
#endif
ulong4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rulong4( size_t offset, const private ulong* p);
inline ulong4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private ulong*  y);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private ulong*  y){ return (ulong4)( __spirv_ocl_vload4__Rulong4(x, y)); }
#endif
ulong8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rulong8( size_t offset, const global ulong* p);
inline ulong8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global ulong*  y);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global ulong*  y){ return (ulong8)( __spirv_ocl_vload8__Rulong8(x, y)); }
#endif
ulong8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rulong8( size_t offset, const local ulong* p);
inline ulong8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local ulong*  y);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local ulong*  y){ return (ulong8)( __spirv_ocl_vload8__Rulong8(x, y)); }
#endif
ulong8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rulong8( size_t offset, const constant ulong* p);
inline ulong8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant ulong*  y);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant ulong*  y){ return (ulong8)( __spirv_ocl_vload8__Rulong8(x, y)); }
#endif
ulong8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rulong8( size_t offset, const private ulong* p);
inline ulong8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private ulong*  y);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private ulong*  y){ return (ulong8)( __spirv_ocl_vload8__Rulong8(x, y)); }
#endif
ulong16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rulong16( size_t offset, const global ulong* p);
inline ulong16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global ulong*  y);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global ulong*  y){ return (ulong16)( __spirv_ocl_vload16__Rulong16(x, y)); }
#endif
ulong16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rulong16( size_t offset, const local ulong* p);
inline ulong16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local ulong*  y);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local ulong*  y){ return (ulong16)( __spirv_ocl_vload16__Rulong16(x, y)); }
#endif
ulong16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rulong16( size_t offset, const constant ulong* p);
inline ulong16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant ulong*  y);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant ulong*  y){ return (ulong16)( __spirv_ocl_vload16__Rulong16(x, y)); }
#endif
ulong16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rulong16( size_t offset, const private ulong* p);
inline ulong16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private ulong*  y);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private ulong*  y){ return (ulong16)( __spirv_ocl_vload16__Rulong16(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rfloat2( size_t offset, const global float* p);
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global float*  y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global float*  y){ return (float2)( __spirv_ocl_vload2__Rfloat2(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rfloat2( size_t offset, const local float* p);
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local float*  y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local float*  y){ return (float2)( __spirv_ocl_vload2__Rfloat2(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rfloat2( size_t offset, const constant float* p);
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant float*  y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant float*  y){ return (float2)( __spirv_ocl_vload2__Rfloat2(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rfloat2( size_t offset, const private float* p);
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private float*  y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private float*  y){ return (float2)( __spirv_ocl_vload2__Rfloat2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rfloat3( size_t offset, const global float* p);
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global float*  y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global float*  y){ return (float3)( __spirv_ocl_vload3__Rfloat3(x, y)); }
#endif
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rfloat3( size_t offset, const local float* p);
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local float*  y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local float*  y){ return (float3)( __spirv_ocl_vload3__Rfloat3(x, y)); }
#endif
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rfloat3( size_t offset, const constant float* p);
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant float*  y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant float*  y){ return (float3)( __spirv_ocl_vload3__Rfloat3(x, y)); }
#endif
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rfloat3( size_t offset, const private float* p);
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private float*  y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private float*  y){ return (float3)( __spirv_ocl_vload3__Rfloat3(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rfloat4( size_t offset, const global float* p);
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global float*  y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global float*  y){ return (float4)( __spirv_ocl_vload4__Rfloat4(x, y)); }
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rfloat4( size_t offset, const local float* p);
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local float*  y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local float*  y){ return (float4)( __spirv_ocl_vload4__Rfloat4(x, y)); }
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rfloat4( size_t offset, const constant float* p);
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant float*  y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant float*  y){ return (float4)( __spirv_ocl_vload4__Rfloat4(x, y)); }
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rfloat4( size_t offset, const private float* p);
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private float*  y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private float*  y){ return (float4)( __spirv_ocl_vload4__Rfloat4(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rfloat8( size_t offset, const global float* p);
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global float*  y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global float*  y){ return (float8)( __spirv_ocl_vload8__Rfloat8(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rfloat8( size_t offset, const local float* p);
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local float*  y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local float*  y){ return (float8)( __spirv_ocl_vload8__Rfloat8(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rfloat8( size_t offset, const constant float* p);
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant float*  y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant float*  y){ return (float8)( __spirv_ocl_vload8__Rfloat8(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rfloat8( size_t offset, const private float* p);
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private float*  y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private float*  y){ return (float8)( __spirv_ocl_vload8__Rfloat8(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rfloat16( size_t offset, const global float* p);
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global float*  y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global float*  y){ return (float16)( __spirv_ocl_vload16__Rfloat16(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rfloat16( size_t offset, const local float* p);
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local float*  y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local float*  y){ return (float16)( __spirv_ocl_vload16__Rfloat16(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rfloat16( size_t offset, const constant float* p);
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant float*  y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant float*  y){ return (float16)( __spirv_ocl_vload16__Rfloat16(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rfloat16( size_t offset, const private float* p);
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private float*  y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private float*  y){ return (float16)( __spirv_ocl_vload16__Rfloat16(x, y)); }
#endif
double2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rdouble2( size_t offset, const global double* p);
inline double2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global double*  y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const global double*  y){ return (double2)( __spirv_ocl_vload2__Rdouble2(x, y)); }
#endif
double2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rdouble2( size_t offset, const local double* p);
inline double2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local double*  y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const local double*  y){ return (double2)( __spirv_ocl_vload2__Rdouble2(x, y)); }
#endif
double2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rdouble2( size_t offset, const constant double* p);
inline double2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant double*  y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const constant double*  y){ return (double2)( __spirv_ocl_vload2__Rdouble2(x, y)); }
#endif
double2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload2__Rdouble2( size_t offset, const private double* p);
inline double2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private double*  y);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,pure,__always_inline__)) vload2(size_t x, const private double*  y){ return (double2)( __spirv_ocl_vload2__Rdouble2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rdouble3( size_t offset, const global double* p);
inline double3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global double*  y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const global double*  y){ return (double3)( __spirv_ocl_vload3__Rdouble3(x, y)); }
#endif
double3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rdouble3( size_t offset, const local double* p);
inline double3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local double*  y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const local double*  y){ return (double3)( __spirv_ocl_vload3__Rdouble3(x, y)); }
#endif
double3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rdouble3( size_t offset, const constant double* p);
inline double3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant double*  y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const constant double*  y){ return (double3)( __spirv_ocl_vload3__Rdouble3(x, y)); }
#endif
double3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload3__Rdouble3( size_t offset, const private double* p);
inline double3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private double*  y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,pure,__always_inline__)) vload3(size_t x, const private double*  y){ return (double3)( __spirv_ocl_vload3__Rdouble3(x, y)); }
#endif
#endif
double4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rdouble4( size_t offset, const global double* p);
inline double4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global double*  y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const global double*  y){ return (double4)( __spirv_ocl_vload4__Rdouble4(x, y)); }
#endif
double4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rdouble4( size_t offset, const local double* p);
inline double4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local double*  y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const local double*  y){ return (double4)( __spirv_ocl_vload4__Rdouble4(x, y)); }
#endif
double4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rdouble4( size_t offset, const constant double* p);
inline double4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant double*  y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const constant double*  y){ return (double4)( __spirv_ocl_vload4__Rdouble4(x, y)); }
#endif
double4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload4__Rdouble4( size_t offset, const private double* p);
inline double4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private double*  y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,pure,__always_inline__)) vload4(size_t x, const private double*  y){ return (double4)( __spirv_ocl_vload4__Rdouble4(x, y)); }
#endif
double8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rdouble8( size_t offset, const global double* p);
inline double8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global double*  y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const global double*  y){ return (double8)( __spirv_ocl_vload8__Rdouble8(x, y)); }
#endif
double8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rdouble8( size_t offset, const local double* p);
inline double8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local double*  y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const local double*  y){ return (double8)( __spirv_ocl_vload8__Rdouble8(x, y)); }
#endif
double8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rdouble8( size_t offset, const constant double* p);
inline double8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant double*  y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const constant double*  y){ return (double8)( __spirv_ocl_vload8__Rdouble8(x, y)); }
#endif
double8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload8__Rdouble8( size_t offset, const private double* p);
inline double8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private double*  y);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,pure,__always_inline__)) vload8(size_t x, const private double*  y){ return (double8)( __spirv_ocl_vload8__Rdouble8(x, y)); }
#endif
double16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rdouble16( size_t offset, const global double* p);
inline double16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global double*  y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const global double*  y){ return (double16)( __spirv_ocl_vload16__Rdouble16(x, y)); }
#endif
double16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rdouble16( size_t offset, const local double* p);
inline double16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local double*  y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const local double*  y){ return (double16)( __spirv_ocl_vload16__Rdouble16(x, y)); }
#endif
double16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rdouble16( size_t offset, const constant double* p);
inline double16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant double*  y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const constant double*  y){ return (double16)( __spirv_ocl_vload16__Rdouble16(x, y)); }
#endif
double16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload16__Rdouble16( size_t offset, const private double* p);
inline double16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private double*  y);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,pure,__always_inline__)) vload16(size_t x, const private double*  y){ return (double16)( __spirv_ocl_vload16__Rdouble16(x, y)); }
#endif
float __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half__Rfloat( size_t offset, const global half* p );
inline float __attribute__((__overloadable__,pure,__always_inline__)) vload_half(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,pure,__always_inline__)) vload_half(size_t x, const global half* y){ return (float)( __spirv_ocl_vload_half__Rfloat(x, y)); }
#endif
float __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half__Rfloat( size_t offset, const global half* p );
inline float __attribute__((__overloadable__,pure,__always_inline__)) vloada_half(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,pure,__always_inline__)) vloada_half(size_t x, const global half* y){ return (float)( __spirv_ocl_vloada_half__Rfloat(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half2__Rfloat2( size_t offset, const global half* p );
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload_half2(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload_half2(size_t x, const global half* y){ return (float2)( __spirv_ocl_vload_half2__Rfloat2(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half2__Rfloat2( size_t offset, const global half* p );
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half2(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half2(size_t x, const global half* y){ return (float2)( __spirv_ocl_vloada_half2__Rfloat2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half3__Rfloat3( size_t offset, const global half* p );
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload_half3(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload_half3(size_t x, const global half* y){ return (float3)( __spirv_ocl_vload_half3__Rfloat3(x, y)); }
#endif
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half3__Rfloat3( size_t offset, const global half* p );
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half3(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half3(size_t x, const global half* y){ return (float3)( __spirv_ocl_vloada_half3__Rfloat3(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half4__Rfloat4( size_t offset, const global half* p );
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload_half4(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload_half4(size_t x, const global half* y){ return (float4)( __spirv_ocl_vload_half4__Rfloat4(x, y)); }
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half4__Rfloat4( size_t offset, const global half* p );
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half4(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half4(size_t x, const global half* y){ return (float4)( __spirv_ocl_vloada_half4__Rfloat4(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half8__Rfloat8( size_t offset, const global half* p );
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload_half8(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload_half8(size_t x, const global half* y){ return (float8)( __spirv_ocl_vload_half8__Rfloat8(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half8__Rfloat8( size_t offset, const global half* p );
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half8(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half8(size_t x, const global half* y){ return (float8)( __spirv_ocl_vloada_half8__Rfloat8(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half16__Rfloat16( size_t offset, const global half* p );
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload_half16(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload_half16(size_t x, const global half* y){ return (float16)( __spirv_ocl_vload_half16__Rfloat16(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half16__Rfloat16( size_t offset, const global half* p );
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half16(size_t x, const global half* y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half16(size_t x, const global half* y){ return (float16)( __spirv_ocl_vloada_half16__Rfloat16(x, y)); }
#endif
float __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half__Rfloat( size_t offset, const local half* p );
inline float __attribute__((__overloadable__,pure,__always_inline__)) vload_half(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,pure,__always_inline__)) vload_half(size_t x, const local half* y){ return (float)( __spirv_ocl_vload_half__Rfloat(x, y)); }
#endif
float __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half__Rfloat( size_t offset, const local half* p );
inline float __attribute__((__overloadable__,pure,__always_inline__)) vloada_half(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,pure,__always_inline__)) vloada_half(size_t x, const local half* y){ return (float)( __spirv_ocl_vloada_half__Rfloat(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half2__Rfloat2( size_t offset, const local half* p );
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload_half2(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload_half2(size_t x, const local half* y){ return (float2)( __spirv_ocl_vload_half2__Rfloat2(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half2__Rfloat2( size_t offset, const local half* p );
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half2(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half2(size_t x, const local half* y){ return (float2)( __spirv_ocl_vloada_half2__Rfloat2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half3__Rfloat3( size_t offset, const local half* p );
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload_half3(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload_half3(size_t x, const local half* y){ return (float3)( __spirv_ocl_vload_half3__Rfloat3(x, y)); }
#endif
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half3__Rfloat3( size_t offset, const local half* p );
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half3(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half3(size_t x, const local half* y){ return (float3)( __spirv_ocl_vloada_half3__Rfloat3(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half4__Rfloat4( size_t offset, const local half* p );
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload_half4(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload_half4(size_t x, const local half* y){ return (float4)( __spirv_ocl_vload_half4__Rfloat4(x, y)); }
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half4__Rfloat4( size_t offset, const local half* p );
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half4(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half4(size_t x, const local half* y){ return (float4)( __spirv_ocl_vloada_half4__Rfloat4(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half8__Rfloat8( size_t offset, const local half* p );
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload_half8(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload_half8(size_t x, const local half* y){ return (float8)( __spirv_ocl_vload_half8__Rfloat8(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half8__Rfloat8( size_t offset, const local half* p );
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half8(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half8(size_t x, const local half* y){ return (float8)( __spirv_ocl_vloada_half8__Rfloat8(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half16__Rfloat16( size_t offset, const local half* p );
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload_half16(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload_half16(size_t x, const local half* y){ return (float16)( __spirv_ocl_vload_half16__Rfloat16(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half16__Rfloat16( size_t offset, const local half* p );
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half16(size_t x, const local half* y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half16(size_t x, const local half* y){ return (float16)( __spirv_ocl_vloada_half16__Rfloat16(x, y)); }
#endif
float __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half__Rfloat( size_t offset, const constant half* p );
inline float __attribute__((__overloadable__,pure,__always_inline__)) vload_half(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,pure,__always_inline__)) vload_half(size_t x, const constant half* y){ return (float)( __spirv_ocl_vload_half__Rfloat(x, y)); }
#endif
float __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half__Rfloat( size_t offset, const constant half* p );
inline float __attribute__((__overloadable__,pure,__always_inline__)) vloada_half(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,pure,__always_inline__)) vloada_half(size_t x, const constant half* y){ return (float)( __spirv_ocl_vloada_half__Rfloat(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half2__Rfloat2( size_t offset, const constant half* p );
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload_half2(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload_half2(size_t x, const constant half* y){ return (float2)( __spirv_ocl_vload_half2__Rfloat2(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half2__Rfloat2( size_t offset, const constant half* p );
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half2(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half2(size_t x, const constant half* y){ return (float2)( __spirv_ocl_vloada_half2__Rfloat2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half3__Rfloat3( size_t offset, const constant half* p );
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload_half3(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload_half3(size_t x, const constant half* y){ return (float3)( __spirv_ocl_vload_half3__Rfloat3(x, y)); }
#endif
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half3__Rfloat3( size_t offset, const constant half* p );
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half3(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half3(size_t x, const constant half* y){ return (float3)( __spirv_ocl_vloada_half3__Rfloat3(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half4__Rfloat4( size_t offset, const constant half* p );
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload_half4(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload_half4(size_t x, const constant half* y){ return (float4)( __spirv_ocl_vload_half4__Rfloat4(x, y)); }
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half4__Rfloat4( size_t offset, const constant half* p );
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half4(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half4(size_t x, const constant half* y){ return (float4)( __spirv_ocl_vloada_half4__Rfloat4(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half8__Rfloat8( size_t offset, const constant half* p );
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload_half8(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload_half8(size_t x, const constant half* y){ return (float8)( __spirv_ocl_vload_half8__Rfloat8(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half8__Rfloat8( size_t offset, const constant half* p );
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half8(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half8(size_t x, const constant half* y){ return (float8)( __spirv_ocl_vloada_half8__Rfloat8(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half16__Rfloat16( size_t offset, const constant half* p );
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload_half16(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload_half16(size_t x, const constant half* y){ return (float16)( __spirv_ocl_vload_half16__Rfloat16(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half16__Rfloat16( size_t offset, const constant half* p );
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half16(size_t x, const constant half* y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half16(size_t x, const constant half* y){ return (float16)( __spirv_ocl_vloada_half16__Rfloat16(x, y)); }
#endif
float __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half__Rfloat( size_t offset, const private half* p );
inline float __attribute__((__overloadable__,pure,__always_inline__)) vload_half(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,pure,__always_inline__)) vload_half(size_t x, const private half* y){ return (float)( __spirv_ocl_vload_half__Rfloat(x, y)); }
#endif
float __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half__Rfloat( size_t offset, const private half* p );
inline float __attribute__((__overloadable__,pure,__always_inline__)) vloada_half(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,pure,__always_inline__)) vloada_half(size_t x, const private half* y){ return (float)( __spirv_ocl_vloada_half__Rfloat(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half2__Rfloat2( size_t offset, const private half* p );
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload_half2(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vload_half2(size_t x, const private half* y){ return (float2)( __spirv_ocl_vload_half2__Rfloat2(x, y)); }
#endif
float2 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half2__Rfloat2( size_t offset, const private half* p );
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half2(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half2(size_t x, const private half* y){ return (float2)( __spirv_ocl_vloada_half2__Rfloat2(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half3__Rfloat3( size_t offset, const private half* p );
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload_half3(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vload_half3(size_t x, const private half* y){ return (float3)( __spirv_ocl_vload_half3__Rfloat3(x, y)); }
#endif
float3 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half3__Rfloat3( size_t offset, const private half* p );
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half3(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half3(size_t x, const private half* y){ return (float3)( __spirv_ocl_vloada_half3__Rfloat3(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half4__Rfloat4( size_t offset, const private half* p );
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload_half4(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vload_half4(size_t x, const private half* y){ return (float4)( __spirv_ocl_vload_half4__Rfloat4(x, y)); }
#endif
float4 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half4__Rfloat4( size_t offset, const private half* p );
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half4(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half4(size_t x, const private half* y){ return (float4)( __spirv_ocl_vloada_half4__Rfloat4(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half8__Rfloat8( size_t offset, const private half* p );
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload_half8(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vload_half8(size_t x, const private half* y){ return (float8)( __spirv_ocl_vload_half8__Rfloat8(x, y)); }
#endif
float8 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half8__Rfloat8( size_t offset, const private half* p );
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half8(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half8(size_t x, const private half* y){ return (float8)( __spirv_ocl_vloada_half8__Rfloat8(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vload_half16__Rfloat16( size_t offset, const private half* p );
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload_half16(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vload_half16(size_t x, const private half* y){ return (float16)( __spirv_ocl_vload_half16__Rfloat16(x, y)); }
#endif
float16 __attribute__((__overloadable__,pure,__always_inline__))  __spirv_ocl_vloada_half16__Rfloat16( size_t offset, const private half* p );
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half16(size_t x, const private half* y);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,pure,__always_inline__)) vloada_half16(size_t x, const private half* y){ return (float16)( __spirv_ocl_vloada_half16__Rfloat16(x, y)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( char2 data, size_t offset, global char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(char2 x, size_t y, global char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(char2 x, size_t y, global char* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( char2 data, size_t offset, local char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(char2 x, size_t y, local char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(char2 x, size_t y, local char* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( char2 data, size_t offset, private char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(char2 x, size_t y, private char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(char2 x, size_t y, private char* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( char3 data, size_t offset, global char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(char3 x, size_t y, global char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(char3 x, size_t y, global char* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( char3 data, size_t offset, local char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(char3 x, size_t y, local char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(char3 x, size_t y, local char* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( char3 data, size_t offset, private char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(char3 x, size_t y, private char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(char3 x, size_t y, private char* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( char4 data, size_t offset, global char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(char4 x, size_t y, global char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(char4 x, size_t y, global char* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( char4 data, size_t offset, local char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(char4 x, size_t y, local char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(char4 x, size_t y, local char* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( char4 data, size_t offset, private char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(char4 x, size_t y, private char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(char4 x, size_t y, private char* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( char8 data, size_t offset, global char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(char8 x, size_t y, global char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(char8 x, size_t y, global char* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( char8 data, size_t offset, local char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(char8 x, size_t y, local char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(char8 x, size_t y, local char* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( char8 data, size_t offset, private char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(char8 x, size_t y, private char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(char8 x, size_t y, private char* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( char16 data, size_t offset, global char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(char16 x, size_t y, global char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(char16 x, size_t y, global char* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( char16 data, size_t offset, local char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(char16 x, size_t y, local char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(char16 x, size_t y, local char* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( char16 data, size_t offset, private char* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(char16 x, size_t y, private char* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(char16 x, size_t y, private char* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( uchar2 data, size_t offset, global uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uchar2 x, size_t y, global uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uchar2 x, size_t y, global uchar* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( uchar2 data, size_t offset, local uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uchar2 x, size_t y, local uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uchar2 x, size_t y, local uchar* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( uchar2 data, size_t offset, private uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uchar2 x, size_t y, private uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uchar2 x, size_t y, private uchar* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( uchar3 data, size_t offset, global uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uchar3 x, size_t y, global uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uchar3 x, size_t y, global uchar* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( uchar3 data, size_t offset, local uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uchar3 x, size_t y, local uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uchar3 x, size_t y, local uchar* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( uchar3 data, size_t offset, private uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uchar3 x, size_t y, private uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uchar3 x, size_t y, private uchar* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( uchar4 data, size_t offset, global uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uchar4 x, size_t y, global uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uchar4 x, size_t y, global uchar* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( uchar4 data, size_t offset, local uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uchar4 x, size_t y, local uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uchar4 x, size_t y, local uchar* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( uchar4 data, size_t offset, private uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uchar4 x, size_t y, private uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uchar4 x, size_t y, private uchar* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( uchar8 data, size_t offset, global uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uchar8 x, size_t y, global uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uchar8 x, size_t y, global uchar* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( uchar8 data, size_t offset, local uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uchar8 x, size_t y, local uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uchar8 x, size_t y, local uchar* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( uchar8 data, size_t offset, private uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uchar8 x, size_t y, private uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uchar8 x, size_t y, private uchar* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( uchar16 data, size_t offset, global uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uchar16 x, size_t y, global uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uchar16 x, size_t y, global uchar* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( uchar16 data, size_t offset, local uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uchar16 x, size_t y, local uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uchar16 x, size_t y, local uchar* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( uchar16 data, size_t offset, private uchar* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uchar16 x, size_t y, private uchar* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uchar16 x, size_t y, private uchar* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( short2 data, size_t offset, global short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(short2 x, size_t y, global short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(short2 x, size_t y, global short* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( short2 data, size_t offset, local short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(short2 x, size_t y, local short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(short2 x, size_t y, local short* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( short2 data, size_t offset, private short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(short2 x, size_t y, private short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(short2 x, size_t y, private short* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( short3 data, size_t offset, global short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(short3 x, size_t y, global short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(short3 x, size_t y, global short* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( short3 data, size_t offset, local short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(short3 x, size_t y, local short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(short3 x, size_t y, local short* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( short3 data, size_t offset, private short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(short3 x, size_t y, private short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(short3 x, size_t y, private short* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( short4 data, size_t offset, global short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(short4 x, size_t y, global short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(short4 x, size_t y, global short* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( short4 data, size_t offset, local short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(short4 x, size_t y, local short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(short4 x, size_t y, local short* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( short4 data, size_t offset, private short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(short4 x, size_t y, private short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(short4 x, size_t y, private short* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( short8 data, size_t offset, global short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(short8 x, size_t y, global short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(short8 x, size_t y, global short* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( short8 data, size_t offset, local short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(short8 x, size_t y, local short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(short8 x, size_t y, local short* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( short8 data, size_t offset, private short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(short8 x, size_t y, private short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(short8 x, size_t y, private short* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( short16 data, size_t offset, global short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(short16 x, size_t y, global short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(short16 x, size_t y, global short* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( short16 data, size_t offset, local short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(short16 x, size_t y, local short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(short16 x, size_t y, local short* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( short16 data, size_t offset, private short* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(short16 x, size_t y, private short* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(short16 x, size_t y, private short* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( ushort2 data, size_t offset, global ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ushort2 x, size_t y, global ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ushort2 x, size_t y, global ushort* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( ushort2 data, size_t offset, local ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ushort2 x, size_t y, local ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ushort2 x, size_t y, local ushort* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( ushort2 data, size_t offset, private ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ushort2 x, size_t y, private ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ushort2 x, size_t y, private ushort* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( ushort3 data, size_t offset, global ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ushort3 x, size_t y, global ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ushort3 x, size_t y, global ushort* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( ushort3 data, size_t offset, local ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ushort3 x, size_t y, local ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ushort3 x, size_t y, local ushort* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( ushort3 data, size_t offset, private ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ushort3 x, size_t y, private ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ushort3 x, size_t y, private ushort* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( ushort4 data, size_t offset, global ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ushort4 x, size_t y, global ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ushort4 x, size_t y, global ushort* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( ushort4 data, size_t offset, local ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ushort4 x, size_t y, local ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ushort4 x, size_t y, local ushort* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( ushort4 data, size_t offset, private ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ushort4 x, size_t y, private ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ushort4 x, size_t y, private ushort* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( ushort8 data, size_t offset, global ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ushort8 x, size_t y, global ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ushort8 x, size_t y, global ushort* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( ushort8 data, size_t offset, local ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ushort8 x, size_t y, local ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ushort8 x, size_t y, local ushort* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( ushort8 data, size_t offset, private ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ushort8 x, size_t y, private ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ushort8 x, size_t y, private ushort* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( ushort16 data, size_t offset, global ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ushort16 x, size_t y, global ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ushort16 x, size_t y, global ushort* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( ushort16 data, size_t offset, local ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ushort16 x, size_t y, local ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ushort16 x, size_t y, local ushort* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( ushort16 data, size_t offset, private ushort* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ushort16 x, size_t y, private ushort* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ushort16 x, size_t y, private ushort* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( int2 data, size_t offset, global int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(int2 x, size_t y, global int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(int2 x, size_t y, global int* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( int2 data, size_t offset, local int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(int2 x, size_t y, local int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(int2 x, size_t y, local int* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( int2 data, size_t offset, private int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(int2 x, size_t y, private int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(int2 x, size_t y, private int* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( int3 data, size_t offset, global int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(int3 x, size_t y, global int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(int3 x, size_t y, global int* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( int3 data, size_t offset, local int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(int3 x, size_t y, local int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(int3 x, size_t y, local int* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( int3 data, size_t offset, private int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(int3 x, size_t y, private int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(int3 x, size_t y, private int* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( int4 data, size_t offset, global int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(int4 x, size_t y, global int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(int4 x, size_t y, global int* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( int4 data, size_t offset, local int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(int4 x, size_t y, local int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(int4 x, size_t y, local int* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( int4 data, size_t offset, private int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(int4 x, size_t y, private int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(int4 x, size_t y, private int* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( int8 data, size_t offset, global int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(int8 x, size_t y, global int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(int8 x, size_t y, global int* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( int8 data, size_t offset, local int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(int8 x, size_t y, local int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(int8 x, size_t y, local int* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( int8 data, size_t offset, private int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(int8 x, size_t y, private int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(int8 x, size_t y, private int* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( int16 data, size_t offset, global int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(int16 x, size_t y, global int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(int16 x, size_t y, global int* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( int16 data, size_t offset, local int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(int16 x, size_t y, local int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(int16 x, size_t y, local int* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( int16 data, size_t offset, private int* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(int16 x, size_t y, private int* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(int16 x, size_t y, private int* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( uint2 data, size_t offset, global uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uint2 x, size_t y, global uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uint2 x, size_t y, global uint* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( uint2 data, size_t offset, local uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uint2 x, size_t y, local uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uint2 x, size_t y, local uint* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( uint2 data, size_t offset, private uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uint2 x, size_t y, private uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(uint2 x, size_t y, private uint* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( uint3 data, size_t offset, global uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uint3 x, size_t y, global uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uint3 x, size_t y, global uint* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( uint3 data, size_t offset, local uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uint3 x, size_t y, local uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uint3 x, size_t y, local uint* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( uint3 data, size_t offset, private uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uint3 x, size_t y, private uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(uint3 x, size_t y, private uint* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( uint4 data, size_t offset, global uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uint4 x, size_t y, global uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uint4 x, size_t y, global uint* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( uint4 data, size_t offset, local uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uint4 x, size_t y, local uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uint4 x, size_t y, local uint* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( uint4 data, size_t offset, private uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uint4 x, size_t y, private uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(uint4 x, size_t y, private uint* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( uint8 data, size_t offset, global uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uint8 x, size_t y, global uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uint8 x, size_t y, global uint* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( uint8 data, size_t offset, local uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uint8 x, size_t y, local uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uint8 x, size_t y, local uint* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( uint8 data, size_t offset, private uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uint8 x, size_t y, private uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(uint8 x, size_t y, private uint* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( uint16 data, size_t offset, global uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uint16 x, size_t y, global uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uint16 x, size_t y, global uint* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( uint16 data, size_t offset, local uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uint16 x, size_t y, local uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uint16 x, size_t y, local uint* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( uint16 data, size_t offset, private uint* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uint16 x, size_t y, private uint* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(uint16 x, size_t y, private uint* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( long2 data, size_t offset, global long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(long2 x, size_t y, global long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(long2 x, size_t y, global long* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( long2 data, size_t offset, local long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(long2 x, size_t y, local long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(long2 x, size_t y, local long* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( long2 data, size_t offset, private long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(long2 x, size_t y, private long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(long2 x, size_t y, private long* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( long3 data, size_t offset, global long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(long3 x, size_t y, global long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(long3 x, size_t y, global long* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( long3 data, size_t offset, local long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(long3 x, size_t y, local long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(long3 x, size_t y, local long* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( long3 data, size_t offset, private long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(long3 x, size_t y, private long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(long3 x, size_t y, private long* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( long4 data, size_t offset, global long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(long4 x, size_t y, global long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(long4 x, size_t y, global long* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( long4 data, size_t offset, local long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(long4 x, size_t y, local long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(long4 x, size_t y, local long* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( long4 data, size_t offset, private long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(long4 x, size_t y, private long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(long4 x, size_t y, private long* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( long8 data, size_t offset, global long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(long8 x, size_t y, global long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(long8 x, size_t y, global long* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( long8 data, size_t offset, local long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(long8 x, size_t y, local long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(long8 x, size_t y, local long* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( long8 data, size_t offset, private long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(long8 x, size_t y, private long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(long8 x, size_t y, private long* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( long16 data, size_t offset, global long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(long16 x, size_t y, global long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(long16 x, size_t y, global long* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( long16 data, size_t offset, local long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(long16 x, size_t y, local long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(long16 x, size_t y, local long* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( long16 data, size_t offset, private long* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(long16 x, size_t y, private long* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(long16 x, size_t y, private long* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( ulong2 data, size_t offset, global ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ulong2 x, size_t y, global ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ulong2 x, size_t y, global ulong* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( ulong2 data, size_t offset, local ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ulong2 x, size_t y, local ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ulong2 x, size_t y, local ulong* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( ulong2 data, size_t offset, private ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ulong2 x, size_t y, private ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(ulong2 x, size_t y, private ulong* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( ulong3 data, size_t offset, global ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ulong3 x, size_t y, global ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ulong3 x, size_t y, global ulong* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( ulong3 data, size_t offset, local ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ulong3 x, size_t y, local ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ulong3 x, size_t y, local ulong* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( ulong3 data, size_t offset, private ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ulong3 x, size_t y, private ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(ulong3 x, size_t y, private ulong* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( ulong4 data, size_t offset, global ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ulong4 x, size_t y, global ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ulong4 x, size_t y, global ulong* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( ulong4 data, size_t offset, local ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ulong4 x, size_t y, local ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ulong4 x, size_t y, local ulong* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( ulong4 data, size_t offset, private ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ulong4 x, size_t y, private ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(ulong4 x, size_t y, private ulong* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( ulong8 data, size_t offset, global ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ulong8 x, size_t y, global ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ulong8 x, size_t y, global ulong* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( ulong8 data, size_t offset, local ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ulong8 x, size_t y, local ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ulong8 x, size_t y, local ulong* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( ulong8 data, size_t offset, private ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ulong8 x, size_t y, private ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(ulong8 x, size_t y, private ulong* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( ulong16 data, size_t offset, global ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ulong16 x, size_t y, global ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ulong16 x, size_t y, global ulong* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( ulong16 data, size_t offset, local ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ulong16 x, size_t y, local ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ulong16 x, size_t y, local ulong* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( ulong16 data, size_t offset, private ulong* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ulong16 x, size_t y, private ulong* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(ulong16 x, size_t y, private ulong* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( float2 data, size_t offset, global float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(float2 x, size_t y, global float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(float2 x, size_t y, global float* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( float2 data, size_t offset, local float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(float2 x, size_t y, local float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(float2 x, size_t y, local float* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( float2 data, size_t offset, private float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(float2 x, size_t y, private float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(float2 x, size_t y, private float* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( float3 data, size_t offset, global float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(float3 x, size_t y, global float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(float3 x, size_t y, global float* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( float3 data, size_t offset, local float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(float3 x, size_t y, local float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(float3 x, size_t y, local float* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( float3 data, size_t offset, private float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(float3 x, size_t y, private float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(float3 x, size_t y, private float* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( float4 data, size_t offset, global float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(float4 x, size_t y, global float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(float4 x, size_t y, global float* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( float4 data, size_t offset, local float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(float4 x, size_t y, local float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(float4 x, size_t y, local float* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( float4 data, size_t offset, private float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(float4 x, size_t y, private float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(float4 x, size_t y, private float* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( float8 data, size_t offset, global float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(float8 x, size_t y, global float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(float8 x, size_t y, global float* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( float8 data, size_t offset, local float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(float8 x, size_t y, local float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(float8 x, size_t y, local float* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( float8 data, size_t offset, private float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(float8 x, size_t y, private float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(float8 x, size_t y, private float* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( float16 data, size_t offset, global float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(float16 x, size_t y, global float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(float16 x, size_t y, global float* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( float16 data, size_t offset, local float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(float16 x, size_t y, local float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(float16 x, size_t y, local float* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( float16 data, size_t offset, private float* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(float16 x, size_t y, private float* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(float16 x, size_t y, private float* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( double2 data, size_t offset, global double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(double2 x, size_t y, global double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(double2 x, size_t y, global double* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( double2 data, size_t offset, local double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(double2 x, size_t y, local double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(double2 x, size_t y, local double* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore2( double2 data, size_t offset, private double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore2(double2 x, size_t y, private double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore2(double2 x, size_t y, private double* z){ return (void)(__spirv_ocl_vstore2(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( double3 data, size_t offset, global double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(double3 x, size_t y, global double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(double3 x, size_t y, global double* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( double3 data, size_t offset, local double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(double3 x, size_t y, local double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(double3 x, size_t y, local double* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore3( double3 data, size_t offset, private double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore3(double3 x, size_t y, private double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore3(double3 x, size_t y, private double* z){ return (void)(__spirv_ocl_vstore3(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( double4 data, size_t offset, global double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(double4 x, size_t y, global double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(double4 x, size_t y, global double* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( double4 data, size_t offset, local double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(double4 x, size_t y, local double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(double4 x, size_t y, local double* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore4( double4 data, size_t offset, private double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore4(double4 x, size_t y, private double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore4(double4 x, size_t y, private double* z){ return (void)(__spirv_ocl_vstore4(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( double8 data, size_t offset, global double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(double8 x, size_t y, global double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(double8 x, size_t y, global double* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( double8 data, size_t offset, local double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(double8 x, size_t y, local double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(double8 x, size_t y, local double* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore8( double8 data, size_t offset, private double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore8(double8 x, size_t y, private double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore8(double8 x, size_t y, private double* z){ return (void)(__spirv_ocl_vstore8(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( double16 data, size_t offset, global double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(double16 x, size_t y, global double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(double16 x, size_t y, global double* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( double16 data, size_t offset, local double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(double16 x, size_t y, local double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(double16 x, size_t y, local double* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore16( double16 data, size_t offset, private double* p);
inline void __attribute__((__overloadable__,__always_inline__))vstore16(double16 x, size_t y, private double* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__))vstore16(double16 x, size_t y, private double* z){ return (void)(__spirv_ocl_vstore16(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rte( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rte(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rte(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rte( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rte(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rte(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtz( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtz(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtz(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtz( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtz(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtz(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtp( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtp(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtp(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtp( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtp(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtp(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtn( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtn(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtn(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtn( float data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtn(float x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtn(float x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half2__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half2__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rte( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rte(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rte(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half2__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rte( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rte(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rte(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtz( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtz(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtz(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtz( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtz(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtz(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtp( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtp(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtp(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtp( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtp(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtp(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtn( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtn(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtn(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtn( float2 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtn(float2 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtn(float2 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtn(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half3__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half3__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rte( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rte(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rte(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half3__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rte( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rte(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rte(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtz( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtz(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtz(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtz( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtz(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtz(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtp( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtp(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtp(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtp( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtp(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtp(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtn( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtn(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtn(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtn( float3 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtn(float3 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtn(float3 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtn(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half4__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half4__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rte( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rte(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rte(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half4__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rte( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rte(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rte(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtz( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtz(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtz(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtz( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtz(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtz(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtp( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtp(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtp(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtp( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtp(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtp(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtn( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtn(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtn(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtn( float4 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtn(float4 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtn(float4 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half8__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half8__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rte( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rte(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rte(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half8__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rte( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rte(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rte(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtz( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtz(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtz(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtz( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtz(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtz(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtp( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtp(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtp(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtp( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtp(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtp(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtn( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtn(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtn(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtn( float8 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtn(float8 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtn(float8 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half16__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half16__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rte( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rte(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rte(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half16__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rte( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rte(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rte(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtz( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtz(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtz(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtz( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtz(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtz(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtp( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtp(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtp(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtp( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtp(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtp(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtn( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtn(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtn(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtn( float16 data, size_t offset, global half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtn(float16 x, size_t y, global half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtn(float16 x, size_t y, global half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rte( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rte(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rte(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rte( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rte(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rte(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtz( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtz(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtz(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtz( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtz(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtz(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtp( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtp(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtp(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtp( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtp(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtp(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtn( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtn(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtn(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtn( float data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtn(float x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtn(float x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half2__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half2__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rte( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rte(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rte(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half2__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rte( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rte(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rte(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtz( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtz(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtz(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtz( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtz(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtz(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtp( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtp(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtp(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtp( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtp(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtp(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtn( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtn(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtn(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtn( float2 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtn(float2 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtn(float2 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtn(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half3__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half3__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rte( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rte(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rte(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half3__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rte( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rte(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rte(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtz( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtz(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtz(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtz( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtz(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtz(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtp( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtp(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtp(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtp( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtp(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtp(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtn( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtn(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtn(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtn( float3 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtn(float3 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtn(float3 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtn(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half4__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half4__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rte( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rte(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rte(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half4__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rte( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rte(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rte(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtz( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtz(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtz(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtz( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtz(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtz(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtp( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtp(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtp(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtp( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtp(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtp(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtn( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtn(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtn(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtn( float4 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtn(float4 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtn(float4 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half8__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half8__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rte( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rte(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rte(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half8__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rte( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rte(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rte(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtz( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtz(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtz(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtz( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtz(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtz(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtp( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtp(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtp(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtp( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtp(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtp(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtn( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtn(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtn(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtn( float8 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtn(float8 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtn(float8 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half16__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half16__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rte( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rte(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rte(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half16__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rte( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rte(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rte(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtz( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtz(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtz(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtz( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtz(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtz(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtp( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtp(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtp(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtp( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtp(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtp(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtn( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtn(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtn(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtn( float16 data, size_t offset, local half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtn(float16 x, size_t y, local half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtn(float16 x, size_t y, local half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rte( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rte(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rte(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rte( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rte(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rte(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtz( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtz(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtz(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtz( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtz(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtz(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtp( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtp(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtp(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtp( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtp(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtp(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half__R_rtn( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtn(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half_rtn(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half__R_rtn( float data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtn(float x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half_rtn(float x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half2__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half2__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rte( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rte(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rte(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half2__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rte( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rte(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rte(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtz( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtz(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtz(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtz( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtz(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtz(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtp( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtp(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtp(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtp( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtp(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtp(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half2__R_rtn( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtn(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half2_rtn(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half2__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half2__R_rtn( float2 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtn(float2 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half2_rtn(float2 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half2__R_rtn(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half3__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half3__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rte( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rte(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rte(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half3__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rte( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rte(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rte(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtz( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtz(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtz(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtz( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtz(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtz(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtp( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtp(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtp(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtp( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtp(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtp(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half3__R_rtn( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtn(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half3_rtn(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half3__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half3__R_rtn( float3 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtn(float3 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half3_rtn(float3 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half3__R_rtn(x, y, z)); }
#endif
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half4__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half4__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rte( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rte(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rte(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half4__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rte( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rte(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rte(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtz( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtz(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtz(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtz( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtz(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtz(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtp( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtp(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtp(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtp( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtp(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtp(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half4__R_rtn( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtn(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half4_rtn(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half4__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half4__R_rtn( float4 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtn(float4 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half4_rtn(float4 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half4__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half8__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half8__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rte( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rte(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rte(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half8__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rte( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rte(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rte(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtz( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtz(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtz(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtz( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtz(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtz(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtp( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtp(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtp(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtp( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtp(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtp(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half8__R_rtn( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtn(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half8_rtn(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half8__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half8__R_rtn( float8 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtn(float8 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half8_rtn(float8 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half8__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half16__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half16__R(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rte( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rte(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rte(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half16__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rte( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rte(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rte(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rte(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtz( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtz(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtz(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtz( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtz(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtz(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtz(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtp( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtp(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtp(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtp( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtp(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtp(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtp(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstore_half16__R_rtn( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtn(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstore_half16_rtn(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstore_half16__R_rtn(x, y, z)); }
#endif
void  __attribute__((__overloadable__,__always_inline__)) __spirv_ocl_vstorea_half16__R_rtn( float16 data, size_t offset, private half* p );
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtn(float16 x, size_t y, private half* z);
#ifndef NO_DEFINITION
inline void __attribute__((__overloadable__,__always_inline__)) vstorea_half16_rtn(float16 x, size_t y, private half* z){ return (void)(__spirv_ocl_vstorea_half16__R_rtn(x, y, z)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( char x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( char2 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char2 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char2 x ){ return (int)(__spirv_Any(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( char3 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char3 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char3 x ){ return (int)(__spirv_Any(x)); }
#endif
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( char4 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char4 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char4 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( char8 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char8 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char8 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( char16 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char16 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(char16 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( char x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( char2 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char2 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char2 x ){ return (int)(__spirv_All(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( char3 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char3 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char3 x ){ return (int)(__spirv_All(x)); }
#endif
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( char4 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char4 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char4 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( char8 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char8 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char8 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( char16 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char16 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(char16 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( short x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( short2 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short2 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short2 x ){ return (int)(__spirv_Any(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( short3 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short3 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short3 x ){ return (int)(__spirv_Any(x)); }
#endif
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( short4 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short4 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short4 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( short8 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short8 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short8 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( short16 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short16 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(short16 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( short x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( short2 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short2 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short2 x ){ return (int)(__spirv_All(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( short3 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short3 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short3 x ){ return (int)(__spirv_All(x)); }
#endif
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( short4 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short4 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short4 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( short8 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short8 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short8 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( short16 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short16 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(short16 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( int x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( int2 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int2 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int2 x ){ return (int)(__spirv_Any(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( int3 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int3 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int3 x ){ return (int)(__spirv_Any(x)); }
#endif
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( int4 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int4 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int4 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( int8 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int8 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int8 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( int16 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int16 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(int16 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( int x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( int2 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int2 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int2 x ){ return (int)(__spirv_All(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( int3 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int3 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int3 x ){ return (int)(__spirv_All(x)); }
#endif
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( int4 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int4 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int4 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( int8 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int8 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int8 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( int16 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int16 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(int16 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( long x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( long2 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long2 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long2 x ){ return (int)(__spirv_Any(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( long3 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long3 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long3 x ){ return (int)(__spirv_Any(x)); }
#endif
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( long4 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long4 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long4 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( long8 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long8 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long8 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_Any( long16 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long16 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) any(long16 x ){ return (int)(__spirv_Any(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( long x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( long2 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long2 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long2 x ){ return (int)(__spirv_All(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( long3 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long3 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long3 x ){ return (int)(__spirv_All(x)); }
#endif
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( long4 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long4 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long4 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( long8 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long8 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long8 x ){ return (int)(__spirv_All(x)); }
#endif
bool __attribute__((__overloadable__,__always_inline__,const)) __spirv_All( long16 x);
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long16 x );
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) all(long16 x ){ return (int)(__spirv_All(x)); }
#endif
char __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( char a, char b, char c ) ;
inline char __attribute__((__overloadable__,__always_inline__,const)) bitselect(char x, char y, char z);
#ifndef NO_DEFINITION
inline char __attribute__((__overloadable__,__always_inline__,const)) bitselect(char x, char y, char z){ return (char)(__spirv_ocl_bitselect(x, y, z)); }
#endif
uchar __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uchar a, uchar b, uchar c ) ;
inline uchar __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar x, uchar y, uchar z);
#ifndef NO_DEFINITION
inline uchar __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar x, uchar y, uchar z){ return (uchar)(__spirv_ocl_bitselect(x, y, z)); }
#endif
short __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( short a, short b, short c ) ;
inline short __attribute__((__overloadable__,__always_inline__,const)) bitselect(short x, short y, short z);
#ifndef NO_DEFINITION
inline short __attribute__((__overloadable__,__always_inline__,const)) bitselect(short x, short y, short z){ return (short)(__spirv_ocl_bitselect(x, y, z)); }
#endif
ushort __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ushort a, ushort b, ushort c ) ;
inline ushort __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort x, ushort y, ushort z);
#ifndef NO_DEFINITION
inline ushort __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort x, ushort y, ushort z){ return (ushort)(__spirv_ocl_bitselect(x, y, z)); }
#endif
int __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( int a, int b, int c ) ;
inline int __attribute__((__overloadable__,__always_inline__,const)) bitselect(int x, int y, int z);
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) bitselect(int x, int y, int z){ return (int)(__spirv_ocl_bitselect(x, y, z)); }
#endif
uint __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uint a, uint b, uint c ) ;
inline uint __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint x, uint y, uint z);
#ifndef NO_DEFINITION
inline uint __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint x, uint y, uint z){ return (uint)(__spirv_ocl_bitselect(x, y, z)); }
#endif
long __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( long a, long b, long c ) ;
inline long __attribute__((__overloadable__,__always_inline__,const)) bitselect(long x, long y, long z);
#ifndef NO_DEFINITION
inline long __attribute__((__overloadable__,__always_inline__,const)) bitselect(long x, long y, long z){ return (long)(__spirv_ocl_bitselect(x, y, z)); }
#endif
ulong __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ulong a, ulong b, ulong c ) ;
inline ulong __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong x, ulong y, ulong z);
#ifndef NO_DEFINITION
inline ulong __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong x, ulong y, ulong z){ return (ulong)(__spirv_ocl_bitselect(x, y, z)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( float a, float b, float c ) ;
inline float __attribute__((__overloadable__,__always_inline__,const)) bitselect(float x, float y, float z);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) bitselect(float x, float y, float z){ return (float)(__spirv_ocl_bitselect(x, y, z)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( double a, double b, double c ) ;
inline double __attribute__((__overloadable__,__always_inline__,const)) bitselect(double x, double y, double z);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) bitselect(double x, double y, double z){ return (double)(__spirv_ocl_bitselect(x, y, z)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( char2 a, char2 b, char2 c );
inline char2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char2 x, char2 y, char2 z);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char2 x, char2 y, char2 z){ return (char2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( char3 a, char3 b, char3 c );
inline char3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char3 x, char3 y, char3 z);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char3 x, char3 y, char3 z){ return (char3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( char4 a, char4 b, char4 c );
inline char4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char4 x, char4 y, char4 z);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char4 x, char4 y, char4 z){ return (char4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( char8 a, char8 b, char8 c );
inline char8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char8 x, char8 y, char8 z);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char8 x, char8 y, char8 z){ return (char8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( char16 a, char16 b, char16 c );
inline char16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char16 x, char16 y, char16 z);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(char16 x, char16 y, char16 z){ return (char16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
uchar2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uchar2 a, uchar2 b, uchar2 c );
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar2 x, uchar2 y, uchar2 z);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar2 x, uchar2 y, uchar2 z){ return (uchar2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uchar3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uchar3 a, uchar3 b, uchar3 c );
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar3 x, uchar3 y, uchar3 z);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar3 x, uchar3 y, uchar3 z){ return (uchar3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
uchar4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uchar4 a, uchar4 b, uchar4 c );
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar4 x, uchar4 y, uchar4 z);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar4 x, uchar4 y, uchar4 z){ return (uchar4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
uchar8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uchar8 a, uchar8 b, uchar8 c );
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar8 x, uchar8 y, uchar8 z);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar8 x, uchar8 y, uchar8 z){ return (uchar8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
uchar16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uchar16 a, uchar16 b, uchar16 c );
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar16 x, uchar16 y, uchar16 z);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uchar16 x, uchar16 y, uchar16 z){ return (uchar16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
short2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( short2 a, short2 b, short2 c );
inline short2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short2 x, short2 y, short2 z);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short2 x, short2 y, short2 z){ return (short2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
short3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( short3 a, short3 b, short3 c );
inline short3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short3 x, short3 y, short3 z);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short3 x, short3 y, short3 z){ return (short3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
short4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( short4 a, short4 b, short4 c );
inline short4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short4 x, short4 y, short4 z);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short4 x, short4 y, short4 z){ return (short4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
short8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( short8 a, short8 b, short8 c );
inline short8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short8 x, short8 y, short8 z);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short8 x, short8 y, short8 z){ return (short8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
short16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( short16 a, short16 b, short16 c );
inline short16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short16 x, short16 y, short16 z);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(short16 x, short16 y, short16 z){ return (short16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
ushort2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ushort2 a, ushort2 b, ushort2 c );
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort2 x, ushort2 y, ushort2 z);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort2 x, ushort2 y, ushort2 z){ return (ushort2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ushort3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ushort3 a, ushort3 b, ushort3 c );
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort3 x, ushort3 y, ushort3 z);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort3 x, ushort3 y, ushort3 z){ return (ushort3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
ushort4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ushort4 a, ushort4 b, ushort4 c );
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort4 x, ushort4 y, ushort4 z);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort4 x, ushort4 y, ushort4 z){ return (ushort4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
ushort8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ushort8 a, ushort8 b, ushort8 c );
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort8 x, ushort8 y, ushort8 z);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort8 x, ushort8 y, ushort8 z){ return (ushort8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
ushort16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ushort16 a, ushort16 b, ushort16 c );
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort16 x, ushort16 y, ushort16 z);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ushort16 x, ushort16 y, ushort16 z){ return (ushort16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
int2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( int2 a, int2 b, int2 c );
inline int2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int2 x, int2 y, int2 z);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int2 x, int2 y, int2 z){ return (int2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
int3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( int3 a, int3 b, int3 c );
inline int3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int3 x, int3 y, int3 z);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int3 x, int3 y, int3 z){ return (int3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
int4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( int4 a, int4 b, int4 c );
inline int4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int4 x, int4 y, int4 z);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int4 x, int4 y, int4 z){ return (int4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
int8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( int8 a, int8 b, int8 c );
inline int8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int8 x, int8 y, int8 z);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int8 x, int8 y, int8 z){ return (int8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
int16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( int16 a, int16 b, int16 c );
inline int16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int16 x, int16 y, int16 z);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(int16 x, int16 y, int16 z){ return (int16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
uint2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uint2 a, uint2 b, uint2 c );
inline uint2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint2 x, uint2 y, uint2 z);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint2 x, uint2 y, uint2 z){ return (uint2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uint3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uint3 a, uint3 b, uint3 c );
inline uint3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint3 x, uint3 y, uint3 z);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint3 x, uint3 y, uint3 z){ return (uint3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
uint4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uint4 a, uint4 b, uint4 c );
inline uint4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint4 x, uint4 y, uint4 z);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint4 x, uint4 y, uint4 z){ return (uint4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
uint8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uint8 a, uint8 b, uint8 c );
inline uint8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint8 x, uint8 y, uint8 z);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint8 x, uint8 y, uint8 z){ return (uint8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
uint16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( uint16 a, uint16 b, uint16 c );
inline uint16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint16 x, uint16 y, uint16 z);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(uint16 x, uint16 y, uint16 z){ return (uint16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
long2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( long2 a, long2 b, long2 c );
inline long2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long2 x, long2 y, long2 z);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long2 x, long2 y, long2 z){ return (long2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
long3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( long3 a, long3 b, long3 c );
inline long3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long3 x, long3 y, long3 z);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long3 x, long3 y, long3 z){ return (long3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
long4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( long4 a, long4 b, long4 c );
inline long4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long4 x, long4 y, long4 z);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long4 x, long4 y, long4 z){ return (long4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
long8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( long8 a, long8 b, long8 c );
inline long8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long8 x, long8 y, long8 z);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long8 x, long8 y, long8 z){ return (long8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
long16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( long16 a, long16 b, long16 c );
inline long16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long16 x, long16 y, long16 z);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(long16 x, long16 y, long16 z){ return (long16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
ulong2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ulong2 a, ulong2 b, ulong2 c );
inline ulong2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong2 x, ulong2 y, ulong2 z);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong2 x, ulong2 y, ulong2 z){ return (ulong2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ulong3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ulong3 a, ulong3 b, ulong3 c );
inline ulong3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong3 x, ulong3 y, ulong3 z);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong3 x, ulong3 y, ulong3 z){ return (ulong3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
ulong4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ulong4 a, ulong4 b, ulong4 c );
inline ulong4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong4 x, ulong4 y, ulong4 z);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong4 x, ulong4 y, ulong4 z){ return (ulong4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
ulong8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ulong8 a, ulong8 b, ulong8 c );
inline ulong8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong8 x, ulong8 y, ulong8 z);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong8 x, ulong8 y, ulong8 z){ return (ulong8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
ulong16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( ulong16 a, ulong16 b, ulong16 c );
inline ulong16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong16 x, ulong16 y, ulong16 z);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(ulong16 x, ulong16 y, ulong16 z){ return (ulong16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( float2 a, float2 b, float2 c );
inline float2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float2 x, float2 y, float2 z);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float2 x, float2 y, float2 z){ return (float2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( float3 a, float3 b, float3 c );
inline float3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float3 x, float3 y, float3 z);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float3 x, float3 y, float3 z){ return (float3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( float4 a, float4 b, float4 c );
inline float4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float4 x, float4 y, float4 z);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float4 x, float4 y, float4 z){ return (float4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( float8 a, float8 b, float8 c );
inline float8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float8 x, float8 y, float8 z);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float8 x, float8 y, float8 z){ return (float8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( float16 a, float16 b, float16 c );
inline float16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float16 x, float16 y, float16 z);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(float16 x, float16 y, float16 z){ return (float16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( double2 a, double2 b, double2 c );
inline double2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double2 x, double2 y, double2 z);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double2 x, double2 y, double2 z){ return (double2)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( double3 a, double3 b, double3 c );
inline double3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double3 x, double3 y, double3 z);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double3 x, double3 y, double3 z){ return (double3)(__spirv_ocl_bitselect(x, y, z)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( double4 a, double4 b, double4 c );
inline double4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double4 x, double4 y, double4 z);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double4 x, double4 y, double4 z){ return (double4)(__spirv_ocl_bitselect(x, y, z)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( double8 a, double8 b, double8 c );
inline double8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double8 x, double8 y, double8 z);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double8 x, double8 y, double8 z){ return (double8)(__spirv_ocl_bitselect(x, y, z)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_bitselect( double16 a, double16 b, double16 c );
inline double16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double16 x, double16 y, double16 z);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__,const)) bitselect(double16 x, double16 y, double16 z){ return (double16)(__spirv_ocl_bitselect(x, y, z)); }
#endif
char __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char a, char b, uchar c ) ;
inline char __attribute__((__overloadable__,__always_inline__,const)) select(char x, char y, uchar z);
#ifndef NO_DEFINITION
inline char __attribute__((__overloadable__,__always_inline__,const)) select(char x, char y, uchar z){ return (char)(__spirv_ocl_select(x, y, z)); }
#endif
char __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char a, char b, char c ) ;
inline char __attribute__((__overloadable__,__always_inline__,const)) select(char x, char y, char z);
#ifndef NO_DEFINITION
inline char __attribute__((__overloadable__,__always_inline__,const)) select(char x, char y, char z){ return (char)(__spirv_ocl_select(x, y, z)); }
#endif
uchar __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar a, uchar b, uchar c ) ;
inline uchar __attribute__((__overloadable__,__always_inline__,const)) select(uchar x, uchar y, uchar z);
#ifndef NO_DEFINITION
inline uchar __attribute__((__overloadable__,__always_inline__,const)) select(uchar x, uchar y, uchar z){ return (uchar)(__spirv_ocl_select(x, y, z)); }
#endif
uchar __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar a, uchar b, char c ) ;
inline uchar __attribute__((__overloadable__,__always_inline__,const)) select(uchar x, uchar y, char z);
#ifndef NO_DEFINITION
inline uchar __attribute__((__overloadable__,__always_inline__,const)) select(uchar x, uchar y, char z){ return (uchar)(__spirv_ocl_select(x, y, z)); }
#endif
short __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short a, short b, ushort c ) ;
inline short __attribute__((__overloadable__,__always_inline__,const)) select(short x, short y, ushort z);
#ifndef NO_DEFINITION
inline short __attribute__((__overloadable__,__always_inline__,const)) select(short x, short y, ushort z){ return (short)(__spirv_ocl_select(x, y, z)); }
#endif
short __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short a, short b, short c ) ;
inline short __attribute__((__overloadable__,__always_inline__,const)) select(short x, short y, short z);
#ifndef NO_DEFINITION
inline short __attribute__((__overloadable__,__always_inline__,const)) select(short x, short y, short z){ return (short)(__spirv_ocl_select(x, y, z)); }
#endif
ushort __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort a, ushort b, ushort c ) ;
inline ushort __attribute__((__overloadable__,__always_inline__,const)) select(ushort x, ushort y, ushort z);
#ifndef NO_DEFINITION
inline ushort __attribute__((__overloadable__,__always_inline__,const)) select(ushort x, ushort y, ushort z){ return (ushort)(__spirv_ocl_select(x, y, z)); }
#endif
ushort __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort a, ushort b, short c ) ;
inline ushort __attribute__((__overloadable__,__always_inline__,const)) select(ushort x, ushort y, short z);
#ifndef NO_DEFINITION
inline ushort __attribute__((__overloadable__,__always_inline__,const)) select(ushort x, ushort y, short z){ return (ushort)(__spirv_ocl_select(x, y, z)); }
#endif
int __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int a, int b, uint c ) ;
inline int __attribute__((__overloadable__,__always_inline__,const)) select(int x, int y, uint z);
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) select(int x, int y, uint z){ return (int)(__spirv_ocl_select(x, y, z)); }
#endif
int __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int a, int b, int c ) ;
inline int __attribute__((__overloadable__,__always_inline__,const)) select(int x, int y, int z);
#ifndef NO_DEFINITION
inline int __attribute__((__overloadable__,__always_inline__,const)) select(int x, int y, int z){ return (int)(__spirv_ocl_select(x, y, z)); }
#endif
uint __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint a, uint b, uint c ) ;
inline uint __attribute__((__overloadable__,__always_inline__,const)) select(uint x, uint y, uint z);
#ifndef NO_DEFINITION
inline uint __attribute__((__overloadable__,__always_inline__,const)) select(uint x, uint y, uint z){ return (uint)(__spirv_ocl_select(x, y, z)); }
#endif
uint __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint a, uint b, int c ) ;
inline uint __attribute__((__overloadable__,__always_inline__,const)) select(uint x, uint y, int z);
#ifndef NO_DEFINITION
inline uint __attribute__((__overloadable__,__always_inline__,const)) select(uint x, uint y, int z){ return (uint)(__spirv_ocl_select(x, y, z)); }
#endif
long __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long a, long b, ulong c ) ;
inline long __attribute__((__overloadable__,__always_inline__,const)) select(long x, long y, ulong z);
#ifndef NO_DEFINITION
inline long __attribute__((__overloadable__,__always_inline__,const)) select(long x, long y, ulong z){ return (long)(__spirv_ocl_select(x, y, z)); }
#endif
long __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long a, long b, long c ) ;
inline long __attribute__((__overloadable__,__always_inline__,const)) select(long x, long y, long z);
#ifndef NO_DEFINITION
inline long __attribute__((__overloadable__,__always_inline__,const)) select(long x, long y, long z){ return (long)(__spirv_ocl_select(x, y, z)); }
#endif
ulong __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong a, ulong b, ulong c ) ;
inline ulong __attribute__((__overloadable__,__always_inline__,const)) select(ulong x, ulong y, ulong z);
#ifndef NO_DEFINITION
inline ulong __attribute__((__overloadable__,__always_inline__,const)) select(ulong x, ulong y, ulong z){ return (ulong)(__spirv_ocl_select(x, y, z)); }
#endif
ulong __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong a, ulong b, long c ) ;
inline ulong __attribute__((__overloadable__,__always_inline__,const)) select(ulong x, ulong y, long z);
#ifndef NO_DEFINITION
inline ulong __attribute__((__overloadable__,__always_inline__,const)) select(ulong x, ulong y, long z){ return (ulong)(__spirv_ocl_select(x, y, z)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float a, float b, uint c ) ;
inline float __attribute__((__overloadable__,__always_inline__,const)) select(float x, float y, uint z);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) select(float x, float y, uint z){ return (float)(__spirv_ocl_select(x, y, z)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float a, float b, int c ) ;
inline float __attribute__((__overloadable__,__always_inline__,const)) select(float x, float y, int z);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) select(float x, float y, int z){ return (float)(__spirv_ocl_select(x, y, z)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double a, double b, ulong c ) ;
inline double __attribute__((__overloadable__,__always_inline__,const)) select(double x, double y, ulong z);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) select(double x, double y, ulong z){ return (double)(__spirv_ocl_select(x, y, z)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double a, double b, long c ) ;
inline double __attribute__((__overloadable__,__always_inline__,const)) select(double x, double y, long z);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) select(double x, double y, long z){ return (double)(__spirv_ocl_select(x, y, z)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char2 a, char2 b, uchar2 c );
inline char2 __attribute__((__overloadable__,__always_inline__,const)) select(char2 x, char2 y, uchar2 z);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__,__always_inline__,const)) select(char2 x, char2 y, uchar2 z){ return (char2)(__spirv_ocl_select(x, y, z)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char2 a, char2 b, char2 c );
inline char2 __attribute__((__overloadable__,__always_inline__,const)) select(char2 x, char2 y, char2 z);
#ifndef NO_DEFINITION
inline char2 __attribute__((__overloadable__,__always_inline__,const)) select(char2 x, char2 y, char2 z){ return (char2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char3 a, char3 b, uchar3 c );
inline char3 __attribute__((__overloadable__,__always_inline__,const)) select(char3 x, char3 y, uchar3 z);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__,__always_inline__,const)) select(char3 x, char3 y, uchar3 z){ return (char3)(__spirv_ocl_select(x, y, z)); }
#endif
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char3 a, char3 b, char3 c );
inline char3 __attribute__((__overloadable__,__always_inline__,const)) select(char3 x, char3 y, char3 z);
#ifndef NO_DEFINITION
inline char3 __attribute__((__overloadable__,__always_inline__,const)) select(char3 x, char3 y, char3 z){ return (char3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char4 a, char4 b, uchar4 c );
inline char4 __attribute__((__overloadable__,__always_inline__,const)) select(char4 x, char4 y, uchar4 z);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__,__always_inline__,const)) select(char4 x, char4 y, uchar4 z){ return (char4)(__spirv_ocl_select(x, y, z)); }
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char4 a, char4 b, char4 c );
inline char4 __attribute__((__overloadable__,__always_inline__,const)) select(char4 x, char4 y, char4 z);
#ifndef NO_DEFINITION
inline char4 __attribute__((__overloadable__,__always_inline__,const)) select(char4 x, char4 y, char4 z){ return (char4)(__spirv_ocl_select(x, y, z)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char8 a, char8 b, uchar8 c );
inline char8 __attribute__((__overloadable__,__always_inline__,const)) select(char8 x, char8 y, uchar8 z);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__,__always_inline__,const)) select(char8 x, char8 y, uchar8 z){ return (char8)(__spirv_ocl_select(x, y, z)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char8 a, char8 b, char8 c );
inline char8 __attribute__((__overloadable__,__always_inline__,const)) select(char8 x, char8 y, char8 z);
#ifndef NO_DEFINITION
inline char8 __attribute__((__overloadable__,__always_inline__,const)) select(char8 x, char8 y, char8 z){ return (char8)(__spirv_ocl_select(x, y, z)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char16 a, char16 b, uchar16 c );
inline char16 __attribute__((__overloadable__,__always_inline__,const)) select(char16 x, char16 y, uchar16 z);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__,__always_inline__,const)) select(char16 x, char16 y, uchar16 z){ return (char16)(__spirv_ocl_select(x, y, z)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( char16 a, char16 b, char16 c );
inline char16 __attribute__((__overloadable__,__always_inline__,const)) select(char16 x, char16 y, char16 z);
#ifndef NO_DEFINITION
inline char16 __attribute__((__overloadable__,__always_inline__,const)) select(char16 x, char16 y, char16 z){ return (char16)(__spirv_ocl_select(x, y, z)); }
#endif
uchar2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar2 a, uchar2 b, uchar2 c );
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) select(uchar2 x, uchar2 y, uchar2 z);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) select(uchar2 x, uchar2 y, uchar2 z){ return (uchar2)(__spirv_ocl_select(x, y, z)); }
#endif
uchar2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar2 a, uchar2 b, char2 c );
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) select(uchar2 x, uchar2 y, char2 z);
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) select(uchar2 x, uchar2 y, char2 z){ return (uchar2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uchar3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar3 a, uchar3 b, uchar3 c );
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) select(uchar3 x, uchar3 y, uchar3 z);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) select(uchar3 x, uchar3 y, uchar3 z){ return (uchar3)(__spirv_ocl_select(x, y, z)); }
#endif
uchar3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar3 a, uchar3 b, char3 c );
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) select(uchar3 x, uchar3 y, char3 z);
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) select(uchar3 x, uchar3 y, char3 z){ return (uchar3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
uchar4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar4 a, uchar4 b, uchar4 c );
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) select(uchar4 x, uchar4 y, uchar4 z);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) select(uchar4 x, uchar4 y, uchar4 z){ return (uchar4)(__spirv_ocl_select(x, y, z)); }
#endif
uchar4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar4 a, uchar4 b, char4 c );
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) select(uchar4 x, uchar4 y, char4 z);
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) select(uchar4 x, uchar4 y, char4 z){ return (uchar4)(__spirv_ocl_select(x, y, z)); }
#endif
uchar8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar8 a, uchar8 b, uchar8 c );
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) select(uchar8 x, uchar8 y, uchar8 z);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) select(uchar8 x, uchar8 y, uchar8 z){ return (uchar8)(__spirv_ocl_select(x, y, z)); }
#endif
uchar8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar8 a, uchar8 b, char8 c );
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) select(uchar8 x, uchar8 y, char8 z);
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) select(uchar8 x, uchar8 y, char8 z){ return (uchar8)(__spirv_ocl_select(x, y, z)); }
#endif
uchar16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar16 a, uchar16 b, uchar16 c );
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) select(uchar16 x, uchar16 y, uchar16 z);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) select(uchar16 x, uchar16 y, uchar16 z){ return (uchar16)(__spirv_ocl_select(x, y, z)); }
#endif
uchar16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uchar16 a, uchar16 b, char16 c );
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) select(uchar16 x, uchar16 y, char16 z);
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) select(uchar16 x, uchar16 y, char16 z){ return (uchar16)(__spirv_ocl_select(x, y, z)); }
#endif
short2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short2 a, short2 b, ushort2 c );
inline short2 __attribute__((__overloadable__,__always_inline__,const)) select(short2 x, short2 y, ushort2 z);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__,__always_inline__,const)) select(short2 x, short2 y, ushort2 z){ return (short2)(__spirv_ocl_select(x, y, z)); }
#endif
short2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short2 a, short2 b, short2 c );
inline short2 __attribute__((__overloadable__,__always_inline__,const)) select(short2 x, short2 y, short2 z);
#ifndef NO_DEFINITION
inline short2 __attribute__((__overloadable__,__always_inline__,const)) select(short2 x, short2 y, short2 z){ return (short2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
short3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short3 a, short3 b, ushort3 c );
inline short3 __attribute__((__overloadable__,__always_inline__,const)) select(short3 x, short3 y, ushort3 z);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__,__always_inline__,const)) select(short3 x, short3 y, ushort3 z){ return (short3)(__spirv_ocl_select(x, y, z)); }
#endif
short3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short3 a, short3 b, short3 c );
inline short3 __attribute__((__overloadable__,__always_inline__,const)) select(short3 x, short3 y, short3 z);
#ifndef NO_DEFINITION
inline short3 __attribute__((__overloadable__,__always_inline__,const)) select(short3 x, short3 y, short3 z){ return (short3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
short4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short4 a, short4 b, ushort4 c );
inline short4 __attribute__((__overloadable__,__always_inline__,const)) select(short4 x, short4 y, ushort4 z);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__,__always_inline__,const)) select(short4 x, short4 y, ushort4 z){ return (short4)(__spirv_ocl_select(x, y, z)); }
#endif
short4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short4 a, short4 b, short4 c );
inline short4 __attribute__((__overloadable__,__always_inline__,const)) select(short4 x, short4 y, short4 z);
#ifndef NO_DEFINITION
inline short4 __attribute__((__overloadable__,__always_inline__,const)) select(short4 x, short4 y, short4 z){ return (short4)(__spirv_ocl_select(x, y, z)); }
#endif
short8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short8 a, short8 b, ushort8 c );
inline short8 __attribute__((__overloadable__,__always_inline__,const)) select(short8 x, short8 y, ushort8 z);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__,__always_inline__,const)) select(short8 x, short8 y, ushort8 z){ return (short8)(__spirv_ocl_select(x, y, z)); }
#endif
short8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short8 a, short8 b, short8 c );
inline short8 __attribute__((__overloadable__,__always_inline__,const)) select(short8 x, short8 y, short8 z);
#ifndef NO_DEFINITION
inline short8 __attribute__((__overloadable__,__always_inline__,const)) select(short8 x, short8 y, short8 z){ return (short8)(__spirv_ocl_select(x, y, z)); }
#endif
short16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short16 a, short16 b, ushort16 c );
inline short16 __attribute__((__overloadable__,__always_inline__,const)) select(short16 x, short16 y, ushort16 z);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__,__always_inline__,const)) select(short16 x, short16 y, ushort16 z){ return (short16)(__spirv_ocl_select(x, y, z)); }
#endif
short16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( short16 a, short16 b, short16 c );
inline short16 __attribute__((__overloadable__,__always_inline__,const)) select(short16 x, short16 y, short16 z);
#ifndef NO_DEFINITION
inline short16 __attribute__((__overloadable__,__always_inline__,const)) select(short16 x, short16 y, short16 z){ return (short16)(__spirv_ocl_select(x, y, z)); }
#endif
ushort2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort2 a, ushort2 b, ushort2 c );
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) select(ushort2 x, ushort2 y, ushort2 z);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) select(ushort2 x, ushort2 y, ushort2 z){ return (ushort2)(__spirv_ocl_select(x, y, z)); }
#endif
ushort2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort2 a, ushort2 b, short2 c );
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) select(ushort2 x, ushort2 y, short2 z);
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) select(ushort2 x, ushort2 y, short2 z){ return (ushort2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ushort3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort3 a, ushort3 b, ushort3 c );
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) select(ushort3 x, ushort3 y, ushort3 z);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) select(ushort3 x, ushort3 y, ushort3 z){ return (ushort3)(__spirv_ocl_select(x, y, z)); }
#endif
ushort3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort3 a, ushort3 b, short3 c );
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) select(ushort3 x, ushort3 y, short3 z);
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) select(ushort3 x, ushort3 y, short3 z){ return (ushort3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
ushort4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort4 a, ushort4 b, ushort4 c );
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) select(ushort4 x, ushort4 y, ushort4 z);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) select(ushort4 x, ushort4 y, ushort4 z){ return (ushort4)(__spirv_ocl_select(x, y, z)); }
#endif
ushort4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort4 a, ushort4 b, short4 c );
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) select(ushort4 x, ushort4 y, short4 z);
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) select(ushort4 x, ushort4 y, short4 z){ return (ushort4)(__spirv_ocl_select(x, y, z)); }
#endif
ushort8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort8 a, ushort8 b, ushort8 c );
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) select(ushort8 x, ushort8 y, ushort8 z);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) select(ushort8 x, ushort8 y, ushort8 z){ return (ushort8)(__spirv_ocl_select(x, y, z)); }
#endif
ushort8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort8 a, ushort8 b, short8 c );
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) select(ushort8 x, ushort8 y, short8 z);
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) select(ushort8 x, ushort8 y, short8 z){ return (ushort8)(__spirv_ocl_select(x, y, z)); }
#endif
ushort16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort16 a, ushort16 b, ushort16 c );
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) select(ushort16 x, ushort16 y, ushort16 z);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) select(ushort16 x, ushort16 y, ushort16 z){ return (ushort16)(__spirv_ocl_select(x, y, z)); }
#endif
ushort16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ushort16 a, ushort16 b, short16 c );
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) select(ushort16 x, ushort16 y, short16 z);
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) select(ushort16 x, ushort16 y, short16 z){ return (ushort16)(__spirv_ocl_select(x, y, z)); }
#endif
int2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int2 a, int2 b, uint2 c );
inline int2 __attribute__((__overloadable__,__always_inline__,const)) select(int2 x, int2 y, uint2 z);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) select(int2 x, int2 y, uint2 z){ return (int2)(__spirv_ocl_select(x, y, z)); }
#endif
int2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int2 a, int2 b, int2 c );
inline int2 __attribute__((__overloadable__,__always_inline__,const)) select(int2 x, int2 y, int2 z);
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) select(int2 x, int2 y, int2 z){ return (int2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
int3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int3 a, int3 b, uint3 c );
inline int3 __attribute__((__overloadable__,__always_inline__,const)) select(int3 x, int3 y, uint3 z);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) select(int3 x, int3 y, uint3 z){ return (int3)(__spirv_ocl_select(x, y, z)); }
#endif
int3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int3 a, int3 b, int3 c );
inline int3 __attribute__((__overloadable__,__always_inline__,const)) select(int3 x, int3 y, int3 z);
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) select(int3 x, int3 y, int3 z){ return (int3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
int4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int4 a, int4 b, uint4 c );
inline int4 __attribute__((__overloadable__,__always_inline__,const)) select(int4 x, int4 y, uint4 z);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) select(int4 x, int4 y, uint4 z){ return (int4)(__spirv_ocl_select(x, y, z)); }
#endif
int4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int4 a, int4 b, int4 c );
inline int4 __attribute__((__overloadable__,__always_inline__,const)) select(int4 x, int4 y, int4 z);
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) select(int4 x, int4 y, int4 z){ return (int4)(__spirv_ocl_select(x, y, z)); }
#endif
int8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int8 a, int8 b, uint8 c );
inline int8 __attribute__((__overloadable__,__always_inline__,const)) select(int8 x, int8 y, uint8 z);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) select(int8 x, int8 y, uint8 z){ return (int8)(__spirv_ocl_select(x, y, z)); }
#endif
int8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int8 a, int8 b, int8 c );
inline int8 __attribute__((__overloadable__,__always_inline__,const)) select(int8 x, int8 y, int8 z);
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) select(int8 x, int8 y, int8 z){ return (int8)(__spirv_ocl_select(x, y, z)); }
#endif
int16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int16 a, int16 b, uint16 c );
inline int16 __attribute__((__overloadable__,__always_inline__,const)) select(int16 x, int16 y, uint16 z);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) select(int16 x, int16 y, uint16 z){ return (int16)(__spirv_ocl_select(x, y, z)); }
#endif
int16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( int16 a, int16 b, int16 c );
inline int16 __attribute__((__overloadable__,__always_inline__,const)) select(int16 x, int16 y, int16 z);
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) select(int16 x, int16 y, int16 z){ return (int16)(__spirv_ocl_select(x, y, z)); }
#endif
uint2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint2 a, uint2 b, uint2 c );
inline uint2 __attribute__((__overloadable__,__always_inline__,const)) select(uint2 x, uint2 y, uint2 z);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__,__always_inline__,const)) select(uint2 x, uint2 y, uint2 z){ return (uint2)(__spirv_ocl_select(x, y, z)); }
#endif
uint2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint2 a, uint2 b, int2 c );
inline uint2 __attribute__((__overloadable__,__always_inline__,const)) select(uint2 x, uint2 y, int2 z);
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__,__always_inline__,const)) select(uint2 x, uint2 y, int2 z){ return (uint2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uint3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint3 a, uint3 b, uint3 c );
inline uint3 __attribute__((__overloadable__,__always_inline__,const)) select(uint3 x, uint3 y, uint3 z);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__,__always_inline__,const)) select(uint3 x, uint3 y, uint3 z){ return (uint3)(__spirv_ocl_select(x, y, z)); }
#endif
uint3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint3 a, uint3 b, int3 c );
inline uint3 __attribute__((__overloadable__,__always_inline__,const)) select(uint3 x, uint3 y, int3 z);
#ifndef NO_DEFINITION
inline uint3 __attribute__((__overloadable__,__always_inline__,const)) select(uint3 x, uint3 y, int3 z){ return (uint3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
uint4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint4 a, uint4 b, uint4 c );
inline uint4 __attribute__((__overloadable__,__always_inline__,const)) select(uint4 x, uint4 y, uint4 z);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__,__always_inline__,const)) select(uint4 x, uint4 y, uint4 z){ return (uint4)(__spirv_ocl_select(x, y, z)); }
#endif
uint4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint4 a, uint4 b, int4 c );
inline uint4 __attribute__((__overloadable__,__always_inline__,const)) select(uint4 x, uint4 y, int4 z);
#ifndef NO_DEFINITION
inline uint4 __attribute__((__overloadable__,__always_inline__,const)) select(uint4 x, uint4 y, int4 z){ return (uint4)(__spirv_ocl_select(x, y, z)); }
#endif
uint8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint8 a, uint8 b, uint8 c );
inline uint8 __attribute__((__overloadable__,__always_inline__,const)) select(uint8 x, uint8 y, uint8 z);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__,__always_inline__,const)) select(uint8 x, uint8 y, uint8 z){ return (uint8)(__spirv_ocl_select(x, y, z)); }
#endif
uint8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint8 a, uint8 b, int8 c );
inline uint8 __attribute__((__overloadable__,__always_inline__,const)) select(uint8 x, uint8 y, int8 z);
#ifndef NO_DEFINITION
inline uint8 __attribute__((__overloadable__,__always_inline__,const)) select(uint8 x, uint8 y, int8 z){ return (uint8)(__spirv_ocl_select(x, y, z)); }
#endif
uint16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint16 a, uint16 b, uint16 c );
inline uint16 __attribute__((__overloadable__,__always_inline__,const)) select(uint16 x, uint16 y, uint16 z);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__,__always_inline__,const)) select(uint16 x, uint16 y, uint16 z){ return (uint16)(__spirv_ocl_select(x, y, z)); }
#endif
uint16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( uint16 a, uint16 b, int16 c );
inline uint16 __attribute__((__overloadable__,__always_inline__,const)) select(uint16 x, uint16 y, int16 z);
#ifndef NO_DEFINITION
inline uint16 __attribute__((__overloadable__,__always_inline__,const)) select(uint16 x, uint16 y, int16 z){ return (uint16)(__spirv_ocl_select(x, y, z)); }
#endif
long2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long2 a, long2 b, ulong2 c );
inline long2 __attribute__((__overloadable__,__always_inline__,const)) select(long2 x, long2 y, ulong2 z);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,__always_inline__,const)) select(long2 x, long2 y, ulong2 z){ return (long2)(__spirv_ocl_select(x, y, z)); }
#endif
long2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long2 a, long2 b, long2 c );
inline long2 __attribute__((__overloadable__,__always_inline__,const)) select(long2 x, long2 y, long2 z);
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,__always_inline__,const)) select(long2 x, long2 y, long2 z){ return (long2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
long3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long3 a, long3 b, ulong3 c );
inline long3 __attribute__((__overloadable__,__always_inline__,const)) select(long3 x, long3 y, ulong3 z);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,__always_inline__,const)) select(long3 x, long3 y, ulong3 z){ return (long3)(__spirv_ocl_select(x, y, z)); }
#endif
long3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long3 a, long3 b, long3 c );
inline long3 __attribute__((__overloadable__,__always_inline__,const)) select(long3 x, long3 y, long3 z);
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,__always_inline__,const)) select(long3 x, long3 y, long3 z){ return (long3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
long4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long4 a, long4 b, ulong4 c );
inline long4 __attribute__((__overloadable__,__always_inline__,const)) select(long4 x, long4 y, ulong4 z);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,__always_inline__,const)) select(long4 x, long4 y, ulong4 z){ return (long4)(__spirv_ocl_select(x, y, z)); }
#endif
long4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long4 a, long4 b, long4 c );
inline long4 __attribute__((__overloadable__,__always_inline__,const)) select(long4 x, long4 y, long4 z);
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,__always_inline__,const)) select(long4 x, long4 y, long4 z){ return (long4)(__spirv_ocl_select(x, y, z)); }
#endif
long8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long8 a, long8 b, ulong8 c );
inline long8 __attribute__((__overloadable__,__always_inline__,const)) select(long8 x, long8 y, ulong8 z);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,__always_inline__,const)) select(long8 x, long8 y, ulong8 z){ return (long8)(__spirv_ocl_select(x, y, z)); }
#endif
long8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long8 a, long8 b, long8 c );
inline long8 __attribute__((__overloadable__,__always_inline__,const)) select(long8 x, long8 y, long8 z);
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,__always_inline__,const)) select(long8 x, long8 y, long8 z){ return (long8)(__spirv_ocl_select(x, y, z)); }
#endif
long16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long16 a, long16 b, ulong16 c );
inline long16 __attribute__((__overloadable__,__always_inline__,const)) select(long16 x, long16 y, ulong16 z);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,__always_inline__,const)) select(long16 x, long16 y, ulong16 z){ return (long16)(__spirv_ocl_select(x, y, z)); }
#endif
long16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( long16 a, long16 b, long16 c );
inline long16 __attribute__((__overloadable__,__always_inline__,const)) select(long16 x, long16 y, long16 z);
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,__always_inline__,const)) select(long16 x, long16 y, long16 z){ return (long16)(__spirv_ocl_select(x, y, z)); }
#endif
ulong2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong2 a, ulong2 b, ulong2 c );
inline ulong2 __attribute__((__overloadable__,__always_inline__,const)) select(ulong2 x, ulong2 y, ulong2 z);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__,__always_inline__,const)) select(ulong2 x, ulong2 y, ulong2 z){ return (ulong2)(__spirv_ocl_select(x, y, z)); }
#endif
ulong2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong2 a, ulong2 b, long2 c );
inline ulong2 __attribute__((__overloadable__,__always_inline__,const)) select(ulong2 x, ulong2 y, long2 z);
#ifndef NO_DEFINITION
inline ulong2 __attribute__((__overloadable__,__always_inline__,const)) select(ulong2 x, ulong2 y, long2 z){ return (ulong2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ulong3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong3 a, ulong3 b, ulong3 c );
inline ulong3 __attribute__((__overloadable__,__always_inline__,const)) select(ulong3 x, ulong3 y, ulong3 z);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__,__always_inline__,const)) select(ulong3 x, ulong3 y, ulong3 z){ return (ulong3)(__spirv_ocl_select(x, y, z)); }
#endif
ulong3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong3 a, ulong3 b, long3 c );
inline ulong3 __attribute__((__overloadable__,__always_inline__,const)) select(ulong3 x, ulong3 y, long3 z);
#ifndef NO_DEFINITION
inline ulong3 __attribute__((__overloadable__,__always_inline__,const)) select(ulong3 x, ulong3 y, long3 z){ return (ulong3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
ulong4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong4 a, ulong4 b, ulong4 c );
inline ulong4 __attribute__((__overloadable__,__always_inline__,const)) select(ulong4 x, ulong4 y, ulong4 z);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__,__always_inline__,const)) select(ulong4 x, ulong4 y, ulong4 z){ return (ulong4)(__spirv_ocl_select(x, y, z)); }
#endif
ulong4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong4 a, ulong4 b, long4 c );
inline ulong4 __attribute__((__overloadable__,__always_inline__,const)) select(ulong4 x, ulong4 y, long4 z);
#ifndef NO_DEFINITION
inline ulong4 __attribute__((__overloadable__,__always_inline__,const)) select(ulong4 x, ulong4 y, long4 z){ return (ulong4)(__spirv_ocl_select(x, y, z)); }
#endif
ulong8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong8 a, ulong8 b, ulong8 c );
inline ulong8 __attribute__((__overloadable__,__always_inline__,const)) select(ulong8 x, ulong8 y, ulong8 z);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__,__always_inline__,const)) select(ulong8 x, ulong8 y, ulong8 z){ return (ulong8)(__spirv_ocl_select(x, y, z)); }
#endif
ulong8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong8 a, ulong8 b, long8 c );
inline ulong8 __attribute__((__overloadable__,__always_inline__,const)) select(ulong8 x, ulong8 y, long8 z);
#ifndef NO_DEFINITION
inline ulong8 __attribute__((__overloadable__,__always_inline__,const)) select(ulong8 x, ulong8 y, long8 z){ return (ulong8)(__spirv_ocl_select(x, y, z)); }
#endif
ulong16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong16 a, ulong16 b, ulong16 c );
inline ulong16 __attribute__((__overloadable__,__always_inline__,const)) select(ulong16 x, ulong16 y, ulong16 z);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__,__always_inline__,const)) select(ulong16 x, ulong16 y, ulong16 z){ return (ulong16)(__spirv_ocl_select(x, y, z)); }
#endif
ulong16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( ulong16 a, ulong16 b, long16 c );
inline ulong16 __attribute__((__overloadable__,__always_inline__,const)) select(ulong16 x, ulong16 y, long16 z);
#ifndef NO_DEFINITION
inline ulong16 __attribute__((__overloadable__,__always_inline__,const)) select(ulong16 x, ulong16 y, long16 z){ return (ulong16)(__spirv_ocl_select(x, y, z)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float2 a, float2 b, uint2 c );
inline float2 __attribute__((__overloadable__,__always_inline__,const)) select(float2 x, float2 y, uint2 z);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) select(float2 x, float2 y, uint2 z){ return (float2)(__spirv_ocl_select(x, y, z)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float2 a, float2 b, int2 c );
inline float2 __attribute__((__overloadable__,__always_inline__,const)) select(float2 x, float2 y, int2 z);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) select(float2 x, float2 y, int2 z){ return (float2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float3 a, float3 b, uint3 c );
inline float3 __attribute__((__overloadable__,__always_inline__,const)) select(float3 x, float3 y, uint3 z);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) select(float3 x, float3 y, uint3 z){ return (float3)(__spirv_ocl_select(x, y, z)); }
#endif
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float3 a, float3 b, int3 c );
inline float3 __attribute__((__overloadable__,__always_inline__,const)) select(float3 x, float3 y, int3 z);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) select(float3 x, float3 y, int3 z){ return (float3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float4 a, float4 b, uint4 c );
inline float4 __attribute__((__overloadable__,__always_inline__,const)) select(float4 x, float4 y, uint4 z);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) select(float4 x, float4 y, uint4 z){ return (float4)(__spirv_ocl_select(x, y, z)); }
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float4 a, float4 b, int4 c );
inline float4 __attribute__((__overloadable__,__always_inline__,const)) select(float4 x, float4 y, int4 z);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) select(float4 x, float4 y, int4 z){ return (float4)(__spirv_ocl_select(x, y, z)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float8 a, float8 b, uint8 c );
inline float8 __attribute__((__overloadable__,__always_inline__,const)) select(float8 x, float8 y, uint8 z);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__,const)) select(float8 x, float8 y, uint8 z){ return (float8)(__spirv_ocl_select(x, y, z)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float8 a, float8 b, int8 c );
inline float8 __attribute__((__overloadable__,__always_inline__,const)) select(float8 x, float8 y, int8 z);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__,const)) select(float8 x, float8 y, int8 z){ return (float8)(__spirv_ocl_select(x, y, z)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float16 a, float16 b, uint16 c );
inline float16 __attribute__((__overloadable__,__always_inline__,const)) select(float16 x, float16 y, uint16 z);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__,const)) select(float16 x, float16 y, uint16 z){ return (float16)(__spirv_ocl_select(x, y, z)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( float16 a, float16 b, int16 c );
inline float16 __attribute__((__overloadable__,__always_inline__,const)) select(float16 x, float16 y, int16 z);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__,const)) select(float16 x, float16 y, int16 z){ return (float16)(__spirv_ocl_select(x, y, z)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double2 a, double2 b, ulong2 c );
inline double2 __attribute__((__overloadable__,__always_inline__,const)) select(double2 x, double2 y, ulong2 z);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) select(double2 x, double2 y, ulong2 z){ return (double2)(__spirv_ocl_select(x, y, z)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double2 a, double2 b, long2 c );
inline double2 __attribute__((__overloadable__,__always_inline__,const)) select(double2 x, double2 y, long2 z);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) select(double2 x, double2 y, long2 z){ return (double2)(__spirv_ocl_select(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double3 a, double3 b, ulong3 c );
inline double3 __attribute__((__overloadable__,__always_inline__,const)) select(double3 x, double3 y, ulong3 z);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) select(double3 x, double3 y, ulong3 z){ return (double3)(__spirv_ocl_select(x, y, z)); }
#endif
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double3 a, double3 b, long3 c );
inline double3 __attribute__((__overloadable__,__always_inline__,const)) select(double3 x, double3 y, long3 z);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) select(double3 x, double3 y, long3 z){ return (double3)(__spirv_ocl_select(x, y, z)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double4 a, double4 b, ulong4 c );
inline double4 __attribute__((__overloadable__,__always_inline__,const)) select(double4 x, double4 y, ulong4 z);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) select(double4 x, double4 y, ulong4 z){ return (double4)(__spirv_ocl_select(x, y, z)); }
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double4 a, double4 b, long4 c );
inline double4 __attribute__((__overloadable__,__always_inline__,const)) select(double4 x, double4 y, long4 z);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) select(double4 x, double4 y, long4 z){ return (double4)(__spirv_ocl_select(x, y, z)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double8 a, double8 b, ulong8 c );
inline double8 __attribute__((__overloadable__,__always_inline__,const)) select(double8 x, double8 y, ulong8 z);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__,const)) select(double8 x, double8 y, ulong8 z){ return (double8)(__spirv_ocl_select(x, y, z)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double8 a, double8 b, long8 c );
inline double8 __attribute__((__overloadable__,__always_inline__,const)) select(double8 x, double8 y, long8 z);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__,const)) select(double8 x, double8 y, long8 z){ return (double8)(__spirv_ocl_select(x, y, z)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double16 a, double16 b, ulong16 c );
inline double16 __attribute__((__overloadable__,__always_inline__,const)) select(double16 x, double16 y, ulong16 z);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__,const)) select(double16 x, double16 y, ulong16 z){ return (double16)(__spirv_ocl_select(x, y, z)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_select( double16 a, double16 b, long16 c );
inline double16 __attribute__((__overloadable__,__always_inline__,const)) select(double16 x, double16 y, long16 z);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__,const)) select(double16 x, double16 y, long16 z){ return (double16)(__spirv_ocl_select(x, y, z)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_Dot( float a, float b );
inline float __attribute__((__overloadable__,__always_inline__,const)) dot(float x, float y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) dot(float x, float y){ return (float)(__spirv_Dot(x, y)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_length( float p );
inline float __attribute__((__overloadable__,__always_inline__,const)) length(float x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) length(float x ){ return (float)(__spirv_ocl_length(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_distance(float a, float b);
inline float __attribute__((__overloadable__,__always_inline__,const)) distance(float x, float y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) distance(float x, float y){ return (float)(__spirv_ocl_distance(x, y)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_normalize( float p );
inline float __attribute__((__overloadable__,__always_inline__,const)) normalize(float x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) normalize(float x ){ return (float)(__spirv_ocl_normalize(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_Dot( float2 a, float2 b );
inline float __attribute__((__overloadable__,__always_inline__,const)) dot(float2 x, float2 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) dot(float2 x, float2 y){ return (float)(__spirv_Dot(x, y)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_length(float2 p);
inline float __attribute__((__overloadable__,__always_inline__,const)) length(float2 x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) length(float2 x ){ return (float)(__spirv_ocl_length(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_distance( float2 a,float2 b );
inline float __attribute__((__overloadable__,__always_inline__,const)) distance(float2 x, float2 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) distance(float2 x, float2 y){ return (float)(__spirv_ocl_distance(x, y)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_normalize(float2 p);
inline float2 __attribute__((__overloadable__,__always_inline__,const)) normalize(float2 x );
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) normalize(float2 x ){ return (float2)(__spirv_ocl_normalize(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_Dot( float3 a, float3 b );
inline float __attribute__((__overloadable__,__always_inline__,const)) dot(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) dot(float3 x, float3 y){ return (float)(__spirv_Dot(x, y)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_length(float3 p);
inline float __attribute__((__overloadable__,__always_inline__,const)) length(float3 x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) length(float3 x ){ return (float)(__spirv_ocl_length(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_distance( float3 a,float3 b );
inline float __attribute__((__overloadable__,__always_inline__,const)) distance(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) distance(float3 x, float3 y){ return (float)(__spirv_ocl_distance(x, y)); }
#endif
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_normalize(float3 p);
inline float3 __attribute__((__overloadable__,__always_inline__,const)) normalize(float3 x );
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) normalize(float3 x ){ return (float3)(__spirv_ocl_normalize(x)); }
#endif
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_Dot( float4 a, float4 b );
inline float __attribute__((__overloadable__,__always_inline__,const)) dot(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) dot(float4 x, float4 y){ return (float)(__spirv_Dot(x, y)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_length(float4 p);
inline float __attribute__((__overloadable__,__always_inline__,const)) length(float4 x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) length(float4 x ){ return (float)(__spirv_ocl_length(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_distance( float4 a,float4 b );
inline float __attribute__((__overloadable__,__always_inline__,const)) distance(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) distance(float4 x, float4 y){ return (float)(__spirv_ocl_distance(x, y)); }
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_normalize(float4 p);
inline float4 __attribute__((__overloadable__,__always_inline__,const)) normalize(float4 x );
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) normalize(float4 x ){ return (float4)(__spirv_ocl_normalize(x)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_Dot( double a, double b );
inline double __attribute__((__overloadable__,__always_inline__,const)) dot(double x, double y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) dot(double x, double y){ return (double)(__spirv_Dot(x, y)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_length( double p );
inline double __attribute__((__overloadable__,__always_inline__,const)) length(double x );
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) length(double x ){ return (double)(__spirv_ocl_length(x)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_distance(double a, double b);
inline double __attribute__((__overloadable__,__always_inline__,const)) distance(double x, double y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) distance(double x, double y){ return (double)(__spirv_ocl_distance(x, y)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_normalize( double p );
inline double __attribute__((__overloadable__,__always_inline__,const)) normalize(double x );
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) normalize(double x ){ return (double)(__spirv_ocl_normalize(x)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_Dot( double2 a, double2 b );
inline double __attribute__((__overloadable__,__always_inline__,const)) dot(double2 x, double2 y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) dot(double2 x, double2 y){ return (double)(__spirv_Dot(x, y)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_length(double2 p);
inline double __attribute__((__overloadable__,__always_inline__,const)) length(double2 x );
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) length(double2 x ){ return (double)(__spirv_ocl_length(x)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_distance( double2 a,double2 b );
inline double __attribute__((__overloadable__,__always_inline__,const)) distance(double2 x, double2 y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) distance(double2 x, double2 y){ return (double)(__spirv_ocl_distance(x, y)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_normalize(double2 p);
inline double2 __attribute__((__overloadable__,__always_inline__,const)) normalize(double2 x );
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) normalize(double2 x ){ return (double2)(__spirv_ocl_normalize(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_Dot( double3 a, double3 b );
inline double __attribute__((__overloadable__,__always_inline__,const)) dot(double3 x, double3 y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) dot(double3 x, double3 y){ return (double)(__spirv_Dot(x, y)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_length(double3 p);
inline double __attribute__((__overloadable__,__always_inline__,const)) length(double3 x );
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) length(double3 x ){ return (double)(__spirv_ocl_length(x)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_distance( double3 a,double3 b );
inline double __attribute__((__overloadable__,__always_inline__,const)) distance(double3 x, double3 y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) distance(double3 x, double3 y){ return (double)(__spirv_ocl_distance(x, y)); }
#endif
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_normalize(double3 p);
inline double3 __attribute__((__overloadable__,__always_inline__,const)) normalize(double3 x );
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) normalize(double3 x ){ return (double3)(__spirv_ocl_normalize(x)); }
#endif
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_Dot( double4 a, double4 b );
inline double __attribute__((__overloadable__,__always_inline__,const)) dot(double4 x, double4 y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) dot(double4 x, double4 y){ return (double)(__spirv_Dot(x, y)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_length(double4 p);
inline double __attribute__((__overloadable__,__always_inline__,const)) length(double4 x );
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) length(double4 x ){ return (double)(__spirv_ocl_length(x)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_distance( double4 a,double4 b );
inline double __attribute__((__overloadable__,__always_inline__,const)) distance(double4 x, double4 y);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) distance(double4 x, double4 y){ return (double)(__spirv_ocl_distance(x, y)); }
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_normalize(double4 p);
inline double4 __attribute__((__overloadable__,__always_inline__,const)) normalize(double4 x );
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) normalize(double4 x ){ return (double4)(__spirv_ocl_normalize(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_length(float a);
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_length(float x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_length(float x ){ return (float)(__spirv_ocl_fast_length(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_distance(float p0, float p1);
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_distance(float x, float y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_distance(float x, float y){ return (float)(__spirv_ocl_fast_distance(x, y)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_normalize(float p);
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_normalize(float x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_normalize(float x ){ return (float)(__spirv_ocl_fast_normalize(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_length(float2 a);
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_length(float2 x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_length(float2 x ){ return (float)(__spirv_ocl_fast_length(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_distance(float2 p0, float2 p1 );
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_distance(float2 x, float2 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_distance(float2 x, float2 y){ return (float)(__spirv_ocl_fast_distance(x, y)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_normalize(float2 p);
inline float2 __attribute__((__overloadable__,__always_inline__,const)) fast_normalize(float2 x );
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) fast_normalize(float2 x ){ return (float2)(__spirv_ocl_fast_normalize(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_length(float3 a);
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_length(float3 x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_length(float3 x ){ return (float)(__spirv_ocl_fast_length(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_distance(float3 p0, float3 p1 );
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_distance(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_distance(float3 x, float3 y){ return (float)(__spirv_ocl_fast_distance(x, y)); }
#endif
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_normalize(float3 p);
inline float3 __attribute__((__overloadable__,__always_inline__,const)) fast_normalize(float3 x );
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) fast_normalize(float3 x ){ return (float3)(__spirv_ocl_fast_normalize(x)); }
#endif
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_length(float4 a);
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_length(float4 x );
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_length(float4 x ){ return (float)(__spirv_ocl_fast_length(x)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_distance(float4 p0, float4 p1 );
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_distance(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) fast_distance(float4 x, float4 y){ return (float)(__spirv_ocl_fast_distance(x, y)); }
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_fast_normalize(float4 p);
inline float4 __attribute__((__overloadable__,__always_inline__,const)) fast_normalize(float4 x );
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) fast_normalize(float4 x ){ return (float4)(__spirv_ocl_fast_normalize(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_cross(float3 a, float3 b);
inline float3 __attribute__((__overloadable__,__always_inline__,const)) cross(float3 x, float3 y);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) cross(float3 x, float3 y){ return (float3)(__spirv_ocl_cross(x, y)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_cross(float4 a, float4 b);
inline float4 __attribute__((__overloadable__,__always_inline__,const)) cross(float4 x, float4 y);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) cross(float4 x, float4 y){ return (float4)(__spirv_ocl_cross(x, y)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_cross(double3 a, double3 b);
inline double3 __attribute__((__overloadable__,__always_inline__,const)) cross(double3 x, double3 y);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) cross(double3 x, double3 y){ return (double3)(__spirv_ocl_cross(x, y)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_cross(double4 a, double4 b);
inline double4 __attribute__((__overloadable__,__always_inline__,const)) cross(double4 x, double4 y);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) cross(double4 x, double4 y){ return (double4)(__spirv_ocl_cross(x, y)); }
#endif
float __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(float x, float y, float a);
inline float __attribute__((__overloadable__,__always_inline__,const)) mix(float x, float y, float z);
#ifndef NO_DEFINITION
inline float __attribute__((__overloadable__,__always_inline__,const)) mix(float x, float y, float z){ return (float)(__spirv_ocl_mix(x, y, z)); }
#endif
float2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(float2 x, float2 y, float2 a);
inline float2 __attribute__((__overloadable__,__always_inline__,const)) mix(float2 x, float2 y, float2 z);
#ifndef NO_DEFINITION
inline float2 __attribute__((__overloadable__,__always_inline__,const)) mix(float2 x, float2 y, float2 z){ return (float2)(__spirv_ocl_mix(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(float3 x, float3 y, float3 a);
inline float3 __attribute__((__overloadable__,__always_inline__,const)) mix(float3 x, float3 y, float3 z);
#ifndef NO_DEFINITION
inline float3 __attribute__((__overloadable__,__always_inline__,const)) mix(float3 x, float3 y, float3 z){ return (float3)(__spirv_ocl_mix(x, y, z)); }
#endif
#endif
float4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(float4 x, float4 y, float4 a);
inline float4 __attribute__((__overloadable__,__always_inline__,const)) mix(float4 x, float4 y, float4 z);
#ifndef NO_DEFINITION
inline float4 __attribute__((__overloadable__,__always_inline__,const)) mix(float4 x, float4 y, float4 z){ return (float4)(__spirv_ocl_mix(x, y, z)); }
#endif
float8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(float8 x, float8 y, float8 a);
inline float8 __attribute__((__overloadable__,__always_inline__,const)) mix(float8 x, float8 y, float8 z);
#ifndef NO_DEFINITION
inline float8 __attribute__((__overloadable__,__always_inline__,const)) mix(float8 x, float8 y, float8 z){ return (float8)(__spirv_ocl_mix(x, y, z)); }
#endif
float16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(float16 x, float16 y, float16 a);
inline float16 __attribute__((__overloadable__,__always_inline__,const)) mix(float16 x, float16 y, float16 z);
#ifndef NO_DEFINITION
inline float16 __attribute__((__overloadable__,__always_inline__,const)) mix(float16 x, float16 y, float16 z){ return (float16)(__spirv_ocl_mix(x, y, z)); }
#endif
double __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(double x, double y, double a);
inline double __attribute__((__overloadable__,__always_inline__,const)) mix(double x, double y, double z);
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__,__always_inline__,const)) mix(double x, double y, double z){ return (double)(__spirv_ocl_mix(x, y, z)); }
#endif
double2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(double2 x, double2 y, double2 a);
inline double2 __attribute__((__overloadable__,__always_inline__,const)) mix(double2 x, double2 y, double2 z);
#ifndef NO_DEFINITION
inline double2 __attribute__((__overloadable__,__always_inline__,const)) mix(double2 x, double2 y, double2 z){ return (double2)(__spirv_ocl_mix(x, y, z)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(double3 x, double3 y, double3 a);
inline double3 __attribute__((__overloadable__,__always_inline__,const)) mix(double3 x, double3 y, double3 z);
#ifndef NO_DEFINITION
inline double3 __attribute__((__overloadable__,__always_inline__,const)) mix(double3 x, double3 y, double3 z){ return (double3)(__spirv_ocl_mix(x, y, z)); }
#endif
#endif
double4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(double4 x, double4 y, double4 a);
inline double4 __attribute__((__overloadable__,__always_inline__,const)) mix(double4 x, double4 y, double4 z);
#ifndef NO_DEFINITION
inline double4 __attribute__((__overloadable__,__always_inline__,const)) mix(double4 x, double4 y, double4 z){ return (double4)(__spirv_ocl_mix(x, y, z)); }
#endif
double8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(double8 x, double8 y, double8 a);
inline double8 __attribute__((__overloadable__,__always_inline__,const)) mix(double8 x, double8 y, double8 z);
#ifndef NO_DEFINITION
inline double8 __attribute__((__overloadable__,__always_inline__,const)) mix(double8 x, double8 y, double8 z){ return (double8)(__spirv_ocl_mix(x, y, z)); }
#endif
double16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_mix(double16 x, double16 y, double16 a);
inline double16 __attribute__((__overloadable__,__always_inline__,const)) mix(double16 x, double16 y, double16 z);
#ifndef NO_DEFINITION
inline double16 __attribute__((__overloadable__,__always_inline__,const)) mix(double16 x, double16 y, double16 z){ return (double16)(__spirv_ocl_mix(x, y, z)); }
#endif
bool  __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet( float x );
inline int  __attribute__((__overloadable__,__always_inline__,const)) signbit(float x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) signbit(float x ){ return (int )(__spirv_SignBitSet(x)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(float2 x );
inline int2 __attribute__((__overloadable__,__always_inline__,const)) signbit(float2 x );
#ifndef NO_DEFINITION
inline int2 __attribute__((__overloadable__,__always_inline__,const)) signbit(float2 x ){ return convert_int2(__spirv_SignBitSet(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(float3 x );
inline int3 __attribute__((__overloadable__,__always_inline__,const)) signbit(float3 x );
#ifndef NO_DEFINITION
inline int3 __attribute__((__overloadable__,__always_inline__,const)) signbit(float3 x ){ return convert_int3(__spirv_SignBitSet(x)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(float4 x );
inline int4 __attribute__((__overloadable__,__always_inline__,const)) signbit(float4 x );
#ifndef NO_DEFINITION
inline int4 __attribute__((__overloadable__,__always_inline__,const)) signbit(float4 x ){ return convert_int4(__spirv_SignBitSet(x)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(float8 x );
inline int8 __attribute__((__overloadable__,__always_inline__,const)) signbit(float8 x );
#ifndef NO_DEFINITION
inline int8 __attribute__((__overloadable__,__always_inline__,const)) signbit(float8 x ){ return convert_int8(__spirv_SignBitSet(x)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(float16 x );
inline int16 __attribute__((__overloadable__,__always_inline__,const)) signbit(float16 x );
#ifndef NO_DEFINITION
inline int16 __attribute__((__overloadable__,__always_inline__,const)) signbit(float16 x ){ return convert_int16(__spirv_SignBitSet(x)); }
#endif
bool  __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet( double x );
inline int  __attribute__((__overloadable__,__always_inline__,const)) signbit(double x );
#ifndef NO_DEFINITION
inline int  __attribute__((__overloadable__,__always_inline__,const)) signbit(double x ){ return (int )(__spirv_SignBitSet(x)); }
#endif
char2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(double2 x );
inline long2 __attribute__((__overloadable__,__always_inline__,const)) signbit(double2 x );
#ifndef NO_DEFINITION
inline long2 __attribute__((__overloadable__,__always_inline__,const)) signbit(double2 x ){ return convert_long2(__spirv_SignBitSet(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
char3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(double3 x );
inline long3 __attribute__((__overloadable__,__always_inline__,const)) signbit(double3 x );
#ifndef NO_DEFINITION
inline long3 __attribute__((__overloadable__,__always_inline__,const)) signbit(double3 x ){ return convert_long3(__spirv_SignBitSet(x)); }
#endif
#endif
char4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(double4 x );
inline long4 __attribute__((__overloadable__,__always_inline__,const)) signbit(double4 x );
#ifndef NO_DEFINITION
inline long4 __attribute__((__overloadable__,__always_inline__,const)) signbit(double4 x ){ return convert_long4(__spirv_SignBitSet(x)); }
#endif
char8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(double8 x );
inline long8 __attribute__((__overloadable__,__always_inline__,const)) signbit(double8 x );
#ifndef NO_DEFINITION
inline long8 __attribute__((__overloadable__,__always_inline__,const)) signbit(double8 x ){ return convert_long8(__spirv_SignBitSet(x)); }
#endif
char16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_SignBitSet(double16 x );
inline long16 __attribute__((__overloadable__,__always_inline__,const)) signbit(double16 x );
#ifndef NO_DEFINITION
inline long16 __attribute__((__overloadable__,__always_inline__,const)) signbit(double16 x ){ return convert_long16(__spirv_SignBitSet(x)); }
#endif
double __attribute__((__overloadable__)) __spirv_ocl_sign(double __x);
double2 __attribute__((__overloadable__)) __spirv_ocl_sign(double2 __x );
#if __OPENCL_C_VERSION__ >= 110
double3 __attribute__((__overloadable__)) __spirv_ocl_sign(double3 __x );
#endif
double4 __attribute__((__overloadable__)) __spirv_ocl_sign(double4 __x );
double8 __attribute__((__overloadable__)) __spirv_ocl_sign(double8 __x );
double16 __attribute__((__overloadable__)) __spirv_ocl_sign(double16 __x );
float __attribute__((__overloadable__)) __spirv_ocl_sign(float __x);
float2 __attribute__((__overloadable__)) __spirv_ocl_sign(float2 __x );
#if __OPENCL_C_VERSION__ >= 110
float3 __attribute__((__overloadable__)) __spirv_ocl_sign(float3 __x );
#endif
float4 __attribute__((__overloadable__)) __spirv_ocl_sign(float4 __x );
float8 __attribute__((__overloadable__)) __spirv_ocl_sign(float8 __x );
float16 __attribute__((__overloadable__)) __spirv_ocl_sign(float16 __x );
#ifndef NO_DEFINITION
inline double __attribute__((__overloadable__)) sign(double __x);
inline double __attribute__((__overloadable__)) sign(double __x){  return (double) __spirv_ocl_sign(__x); }
inline double2 __attribute__((__overloadable__)) sign(double2 __x );
inline double2 __attribute__((__overloadable__)) sign(double2 __x ){ return (double2)( __spirv_ocl_sign(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline double3 __attribute__((__overloadable__)) sign(double3 __x );
inline double3 __attribute__((__overloadable__)) sign(double3 __x ){ return (double3)( __spirv_ocl_sign(__x)); }
#endif
inline double4 __attribute__((__overloadable__)) sign(double4 __x );
inline double4 __attribute__((__overloadable__)) sign(double4 __x ){ return (double4)( __spirv_ocl_sign(__x)); }
inline double8 __attribute__((__overloadable__)) sign(double8 __x );
inline double8 __attribute__((__overloadable__)) sign(double8 __x ){ return (double8)( __spirv_ocl_sign(__x)); }
inline double16 __attribute__((__overloadable__)) sign(double16 __x );
inline double16 __attribute__((__overloadable__)) sign(double16 __x ){ return (double16)( __spirv_ocl_sign(__x)); }
inline float __attribute__((__overloadable__)) sign(float __x);
inline float __attribute__((__overloadable__)) sign(float __x){  return (float) __spirv_ocl_sign(__x); }
inline float2 __attribute__((__overloadable__)) sign(float2 __x );
inline float2 __attribute__((__overloadable__)) sign(float2 __x ){ return (float2)( __spirv_ocl_sign(__x)); }
#if __OPENCL_C_VERSION__ >= 110
inline float3 __attribute__((__overloadable__)) sign(float3 __x );
inline float3 __attribute__((__overloadable__)) sign(float3 __x ){ return (float3)( __spirv_ocl_sign(__x)); }
#endif
inline float4 __attribute__((__overloadable__)) sign(float4 __x );
inline float4 __attribute__((__overloadable__)) sign(float4 __x ){ return (float4)( __spirv_ocl_sign(__x)); }
inline float8 __attribute__((__overloadable__)) sign(float8 __x );
inline float8 __attribute__((__overloadable__)) sign(float8 __x ){ return (float8)( __spirv_ocl_sign(__x)); }
inline float16 __attribute__((__overloadable__)) sign(float16 __x );
inline float16 __attribute__((__overloadable__)) sign(float16 __x ){ return (float16)( __spirv_ocl_sign(__x)); }
#endif
uchar __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(char x);
inline uchar __attribute__((__overloadable__,__always_inline__,const)) abs(char x );
#ifndef NO_DEFINITION
inline uchar __attribute__((__overloadable__,__always_inline__,const)) abs(char x ){ return (uchar)(__spirv_ocl_s_abs(x)); }
#endif
uchar2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(char2 x);
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) abs(char2 x );
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) abs(char2 x ){ return (uchar2)(__spirv_ocl_s_abs(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uchar3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(char3 x);
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) abs(char3 x );
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) abs(char3 x ){ return (uchar3)(__spirv_ocl_s_abs(x)); }
#endif
#endif
uchar4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(char4 x);
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) abs(char4 x );
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) abs(char4 x ){ return (uchar4)(__spirv_ocl_s_abs(x)); }
#endif
uchar8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(char8 x);
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) abs(char8 x );
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) abs(char8 x ){ return (uchar8)(__spirv_ocl_s_abs(x)); }
#endif
uchar16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(char16 x);
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) abs(char16 x );
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) abs(char16 x ){ return (uchar16)(__spirv_ocl_s_abs(x)); }
#endif
uchar __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(uchar x);
inline uchar __attribute__((__overloadable__,__always_inline__,const)) abs(uchar x );
#ifndef NO_DEFINITION
inline uchar __attribute__((__overloadable__,__always_inline__,const)) abs(uchar x ){ return (uchar)(__spirv_ocl_u_abs(x)); }
#endif
uchar2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(uchar2 x);
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar2 x );
#ifndef NO_DEFINITION
inline uchar2 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar2 x ){ return (uchar2)(__spirv_ocl_u_abs(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
uchar3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(uchar3 x);
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar3 x );
#ifndef NO_DEFINITION
inline uchar3 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar3 x ){ return (uchar3)(__spirv_ocl_u_abs(x)); }
#endif
#endif
uchar4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(uchar4 x);
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar4 x );
#ifndef NO_DEFINITION
inline uchar4 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar4 x ){ return (uchar4)(__spirv_ocl_u_abs(x)); }
#endif
uchar8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(uchar8 x);
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar8 x );
#ifndef NO_DEFINITION
inline uchar8 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar8 x ){ return (uchar8)(__spirv_ocl_u_abs(x)); }
#endif
uchar16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(uchar16 x);
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar16 x );
#ifndef NO_DEFINITION
inline uchar16 __attribute__((__overloadable__,__always_inline__,const)) abs(uchar16 x ){ return (uchar16)(__spirv_ocl_u_abs(x)); }
#endif
ushort __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(short x);
inline ushort __attribute__((__overloadable__,__always_inline__,const)) abs(short x );
#ifndef NO_DEFINITION
inline ushort __attribute__((__overloadable__,__always_inline__,const)) abs(short x ){ return (ushort)(__spirv_ocl_s_abs(x)); }
#endif
ushort2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(short2 x);
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) abs(short2 x );
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) abs(short2 x ){ return (ushort2)(__spirv_ocl_s_abs(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ushort3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(short3 x);
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) abs(short3 x );
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) abs(short3 x ){ return (ushort3)(__spirv_ocl_s_abs(x)); }
#endif
#endif
ushort4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(short4 x);
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) abs(short4 x );
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) abs(short4 x ){ return (ushort4)(__spirv_ocl_s_abs(x)); }
#endif
ushort8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(short8 x);
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) abs(short8 x );
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) abs(short8 x ){ return (ushort8)(__spirv_ocl_s_abs(x)); }
#endif
ushort16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(short16 x);
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) abs(short16 x );
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) abs(short16 x ){ return (ushort16)(__spirv_ocl_s_abs(x)); }
#endif
ushort __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(ushort x);
inline ushort __attribute__((__overloadable__,__always_inline__,const)) abs(ushort x );
#ifndef NO_DEFINITION
inline ushort __attribute__((__overloadable__,__always_inline__,const)) abs(ushort x ){ return (ushort)(__spirv_ocl_u_abs(x)); }
#endif
ushort2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(ushort2 x);
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort2 x );
#ifndef NO_DEFINITION
inline ushort2 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort2 x ){ return (ushort2)(__spirv_ocl_u_abs(x)); }
#endif
#if __OPENCL_C_VERSION__ >= 110
ushort3 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(ushort3 x);
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort3 x );
#ifndef NO_DEFINITION
inline ushort3 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort3 x ){ return (ushort3)(__spirv_ocl_u_abs(x)); }
#endif
#endif
ushort4 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(ushort4 x);
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort4 x );
#ifndef NO_DEFINITION
inline ushort4 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort4 x ){ return (ushort4)(__spirv_ocl_u_abs(x)); }
#endif
ushort8 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(ushort8 x);
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort8 x );
#ifndef NO_DEFINITION
inline ushort8 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort8 x ){ return (ushort8)(__spirv_ocl_u_abs(x)); }
#endif
ushort16 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_u_abs(ushort16 x);
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort16 x );
#ifndef NO_DEFINITION
inline ushort16 __attribute__((__overloadable__,__always_inline__,const)) abs(ushort16 x ){ return (ushort16)(__spirv_ocl_u_abs(x)); }
#endif
uint __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(int x);
inline uint __attribute__((__overloadable__,__always_inline__,const)) abs(int x );
#ifndef NO_DEFINITION
inline uint __attribute__((__overloadable__,__always_inline__,const)) abs(int x ){ return (uint)(__spirv_ocl_s_abs(x)); }
#endif
uint2 __attribute__((__overloadable__,__always_inline__,const)) __spirv_ocl_s_abs(int2 x);
inline uint2 __attribute__((__overloadable__,__always_inline__,const)) abs(int2 x );
#ifndef NO_DEFINITION
inline uint2 __attribute__((__overloadable__,__always_inline__,const))