/*******************************************************************************
* Copyright 2020 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions
* and limitations under the License.
*
*
* SPDX-License-Identifier: Apache-2.0
*******************************************************************************/

#ifndef _MKL_RNG_DEVICE_MRG32K3A_SKIP_AHEAD_MATRIX_HPP_
#define _MKL_RNG_DEVICE_MRG32K3A_SKIP_AHEAD_MATRIX_HPP_

namespace oneapi::mkl::rng::device::detail {
namespace mrg32k3a_impl {

constexpr std::size_t quantity_of_3x3_matrices = 455; // number of 3x3 matrices for skipping

// There are 2 subsequences of numbers, each containing 455 3x3 matrices
static const std::uint32_t skip_ahead_matrix[2][quantity_of_3x3_matrices][3][3] = {
    // Matrices for the first part of SkipAhead procedure
    // Matrix for nskip = 1 * 8 ^ 0:
    { { { 0, 1, 0 }, { 0, 0, 1 }, { 4294156359, 1403580, 0 } },
      // Matrix for nskip = 2 * 8 ^ 0:
      { { 0, 0, 1 }, { 4294156359, 1403580, 0 }, { 0, 4294156359, 1403580 } },
      // Matrix for nskip = 3 * 8 ^ 0:
      { { 4294156359, 1403580, 0 },
        { 0, 4294156359, 1403580 },
        { 244671815, 2941890554, 4294156359 } },
      // Matrix for nskip = 4 * 8 ^ 0:
      { { 0, 4294156359, 1403580 },
        { 244671815, 2941890554, 4294156359 },
        { 149925673, 489343630, 2941890554 } },
      // Matrix for nskip = 5 * 8 ^ 0:
      { { 244671815, 2941890554, 4294156359 },
        { 149925673, 489343630, 2941890554 },
        { 3782722441, 1831234280, 489343630 } },
      // Matrix for nskip = 6 * 8 ^ 0:
      { { 149925673, 489343630, 2941890554 },
        { 3782722441, 1831234280, 489343630 },
        { 1527363550, 2758233149, 1831234280 } },
      // Matrix for nskip = 7 * 8 ^ 0:
      { { 3782722441, 1831234280, 489343630 },
        { 1527363550, 2758233149, 1831234280 },
        { 4072640363, 939574583, 2758233149 } },
      // Matrix for nskip = 1 * 8 ^ 1:
      { { 1527363550, 2758233149, 1831234280 },
        { 4072640363, 939574583, 2758233149 },
        { 2064391165, 3228066636, 939574583 } },
      // Matrix for nskip = 2 * 8 ^ 1:
      { { 736416029, 2961816100, 342112271 },
        { 387300998, 1062452522, 2961816100 },
        { 2955879160, 340793741, 1062452522 } },
      // Matrix for nskip = 3 * 8 ^ 1:
      { { 3830731060, 3351104823, 355092062 },
        { 4271633387, 3081436279, 3351104823 },
        { 2754512837, 673113417, 3081436279 } },
      // Matrix for nskip = 4 * 8 ^ 1:
      { { 1243502014, 2218748291, 1709215645 },
        { 2019641772, 3847560959, 2218748291 },
        { 3866010231, 2305448679, 3847560959 } },
      // Matrix for nskip = 5 * 8 ^ 1:
      { { 753665800, 3956261650, 1880714717 },
        { 3889504807, 299844503, 3956261650 },
        { 3555787878, 734199116, 299844503 } },
      // Matrix for nskip = 6 * 8 ^ 1:
      { { 1402917279, 671479916, 279477115 },
        { 1066184965, 1957999095, 671479916 },
        { 3803905489, 2154014226, 1957999095 } },
      // Matrix for nskip = 7 * 8 ^ 1:
      { { 1519817277, 3513041072, 37163717 },
        { 3823126416, 1394452522, 3513041072 },
        { 762181894, 1046733826, 1394452522 } },
      // Matrix for nskip = 1 * 8 ^ 2:
      { { 3241775219, 3453352062, 3721871040 },
        { 4062454730, 3015754, 3453352062 },
        { 919711945, 613405362, 3015754 } },
      // Matrix for nskip = 2 * 8 ^ 2:
      { { 1955221006, 1414472808, 1746037714 },
        { 3653507277, 1644962013, 1414472808 },
        { 3501544776, 2336229602, 1644962013 } },
      // Matrix for nskip = 3 * 8 ^ 2:
      { { 2883496440, 2415235089, 3754924652 },
        { 2873360987, 3093961248, 2415235089 },
        { 2551531030, 3967481377, 3093961248 } },
      // Matrix for nskip = 4 * 8 ^ 2:
      { { 1170096663, 49135452, 3441537107 },
        { 1857945175, 1649398389, 49135452 },
        { 333002869, 3109147376, 1649398389 } },
      // Matrix for nskip = 5 * 8 ^ 2:
      { { 3782304170, 536558728, 1207462427 },
        { 2479820532, 1357898065, 536558728 },
        { 3967038637, 280429670, 1357898065 } },
      // Matrix for nskip = 6 * 8 ^ 2:
      { { 1850220783, 2237648487, 4288110946 },
        { 778070070, 3729077970, 2237648487 },
        { 1095506872, 3284249345, 3729077970 } },
      // Matrix for nskip = 7 * 8 ^ 2:
      { { 3963964167, 1824244353, 1280698295 },
        { 1736039316, 2491872331, 1824244353 },
        { 1645622379, 4226305484, 2491872331 } },
      // Matrix for nskip = 1 * 8 ^ 3:
      { { 2299034194, 2297111910, 862649200 },
        { 1399961132, 996706937, 2297111910 },
        { 3439056503, 1481993076, 996706937 } },
      // Matrix for nskip = 2 * 8 ^ 3:
      { { 4146310528, 458782589, 1007330283 },
        { 4241015765, 3979619964, 458782589 },
        { 553886495, 2186897562, 3979619964 } },
      // Matrix for nskip = 3 * 8 ^ 3:
      { { 1146235803, 3119708691, 3977084597 },
        { 1030264372, 1706820424, 3119708691 },
        { 2210423860, 4154877869, 1706820424 } },
      // Matrix for nskip = 4 * 8 ^ 3:
      { { 3630027893, 2130448350, 292773857 },
        { 1392525159, 1299285967, 2130448350 },
        { 2589171163, 1217405758, 1299285967 } },
      // Matrix for nskip = 5 * 8 ^ 3:
      { { 3841954865, 948545149, 4067146304 },
        { 4218117763, 3741945962, 948545149 },
        { 1745368878, 730788749, 3741945962 } },
      // Matrix for nskip = 6 * 8 ^ 3:
      { { 2341737887, 1393299668, 3386176735 },
        { 1655556841, 359678770, 1393299668 },
        { 2175543957, 3314680006, 359678770 } },
      // Matrix for nskip = 7 * 8 ^ 3:
      { { 3121396438, 3210334684, 1062918236 },
        { 325732785, 2721675172, 3210334684 },
        { 3182328265, 241385543, 2721675172 } },
      // Matrix for nskip = 1 * 8 ^ 4:
      { { 892409263, 1999175811, 2979225418 },
        { 1996163538, 2148702503, 1999175811 },
        { 3922720782, 103819730, 2148702503 } },
      // Matrix for nskip = 2 * 8 ^ 4:
      { { 1586003016, 2114210471, 3240775579 },
        { 2777288607, 1400478398, 2114210471 },
        { 3018215420, 535326008, 1400478398 } },
      // Matrix for nskip = 3 * 8 ^ 4:
      { { 377225862, 1098715579, 1378248654 },
        { 2452527982, 3677219860, 1098715579 },
        { 3805011027, 3962510930, 3677219860 } },
      // Matrix for nskip = 4 * 8 ^ 4:
      { { 2188531273, 1783231160, 3576659343 },
        { 1908318389, 379210133, 1783231160 },
        { 554369329, 250053591, 379210133 } },
      // Matrix for nskip = 5 * 8 ^ 4:
      { { 2249717607, 2266741858, 2040546316 },
        { 3093925525, 3510732546, 2266741858 },
        { 2244264588, 3926709784, 3510732546 } },
      // Matrix for nskip = 6 * 8 ^ 4:
      { { 2349663769, 2339070143, 3651849809 },
        { 1360064932, 443349145, 2339070143 },
        { 2864061919, 590074072, 443349145 } },
      // Matrix for nskip = 7 * 8 ^ 4:
      { { 299115015, 4017647307, 737449908 },
        { 1014398637, 352887003, 4017647307 },
        { 2268496651, 499779786, 352887003 } },
      // Matrix for nskip = 1 * 8 ^ 5:
      { { 4022841636, 3951951872, 2143424240 },
        { 1046219306, 1591992468, 3951951872 },
        { 1510277444, 381333958, 1591992468 } },
      // Matrix for nskip = 2 * 8 ^ 5:
      { { 2256493727, 3715182130, 642697923 },
        { 3615342722, 3975008370, 3715182130 },
        { 2405650329, 754337639, 3975008370 } },
      // Matrix for nskip = 3 * 8 ^ 5:
      { { 3246129870, 3068844475, 3738266208 },
        { 668859604, 3798586786, 3068844475 },
        { 3275530821, 2740099935, 3798586786 } },
      // Matrix for nskip = 4 * 8 ^ 5:
      { { 1286664224, 627406673, 963516608 },
        { 1541344588, 460768826, 627406673 },
        { 1089892553, 2717717970, 460768826 } },
      // Matrix for nskip = 5 * 8 ^ 5:
      { { 2092934033, 2692683366, 2826944083 },
        { 1909409603, 3350132528, 2692683366 },
        { 3481095738, 3485350450, 3350132528 } },
      // Matrix for nskip = 6 * 8 ^ 5:
      { { 1918719231, 2970279915, 803149880 },
        { 2389311995, 4195833089, 2970279915 },
        { 166509779, 2105299796, 4195833089 } },
      // Matrix for nskip = 7 * 8 ^ 5:
      { { 3252663202, 2481165293, 694007918 },
        { 1921953957, 350878042, 2481165293 },
        { 1954500233, 1970948165, 350878042 } },
      // Matrix for nskip = 1 * 8 ^ 6:
      { { 2956342842, 3471097641, 2353092905 },
        { 2996150472, 420480221, 3471097641 },
        { 2221681883, 372736411, 420480221 } },
      // Matrix for nskip = 2 * 8 ^ 6:
      { { 420492906, 153526651, 3499730988 },
        { 2662640502, 3278195133, 153526651 },
        { 4086436419, 2510762118, 3278195133 } },
      // Matrix for nskip = 3 * 8 ^ 6:
      { { 600928360, 715341436, 3127996992 },
        { 4276221887, 1953220754, 715341436 },
        { 2074032202, 163100603, 1953220754 } },
      // Matrix for nskip = 4 * 8 ^ 6:
      { { 3310184147, 2228376089, 823220763 },
        { 3992771814, 1693168425, 2228376089 },
        { 2295790366, 1401872772, 1693168425 } },
      // Matrix for nskip = 5 * 8 ^ 6:
      { { 1282168185, 2751813658, 602760489 },
        { 2254465781, 1232521545, 2751813658 },
        { 1025381169, 1981662800, 1232521545 } },
      // Matrix for nskip = 6 * 8 ^ 6:
      { { 460755919, 4283511820, 3208183750 },
        { 3248110895, 730327118, 4283511820 },
        { 1386862282, 926261676, 730327118 } },
      // Matrix for nskip = 7 * 8 ^ 6:
      { { 2392208153, 3129124418, 684400653 },
        { 4025364146, 1122067473, 3129124418 },
        { 773418203, 2967386517, 1122067473 } },
      // Matrix for nskip = 1 * 8 ^ 7:
      { { 2529428830, 1497104068, 4253248635 },
        { 3746310018, 630867741, 1497104068 },
        { 627043435, 721725795, 630867741 } },
      // Matrix for nskip = 2 * 8 ^ 7:
      { { 2571072593, 3039669025, 1591031831 },
        { 526054481, 661344445, 3039669025 },
        { 4246010312, 735391270, 661344445 } },
      // Matrix for nskip = 3 * 8 ^ 7:
      { { 3781620139, 2917363935, 2936154555 },
        { 2668364492, 3297773364, 2917363935 },
        { 2501878263, 3438979384, 3297773364 } },
      // Matrix for nskip = 4 * 8 ^ 7:
      { { 1847312821, 4042890210, 4241772463 },
        { 606605705, 2644799309, 4042890210 },
        { 2658402822, 1342278931, 2644799309 } },
      // Matrix for nskip = 5 * 8 ^ 7:
      { { 3502592220, 3704088248, 4011400538 },
        { 2932838910, 1175764916, 3704088248 },
        { 2865336247, 2471593729, 1175764916 } },
      // Matrix for nskip = 6 * 8 ^ 7:
      { { 3250474907, 3775615386, 3733878711 },
        { 1502779384, 287728234, 3775615386 },
        { 162441370, 246229618, 287728234 } },
      // Matrix for nskip = 7 * 8 ^ 7:
      { { 749636765, 3227070913, 3120894575 },
        { 2853687796, 1910085226, 3227070913 },
        { 2453891386, 4230641571, 1910085226 } },
      // Matrix for nskip = 1 * 8 ^ 8:
      { { 2409846784, 1096138313, 1416249993 },
        { 1501878241, 138013862, 1096138313 },
        { 1617749306, 1975136163, 138013862 } },
      // Matrix for nskip = 2 * 8 ^ 8:
      { { 599453422, 73950522, 2965395603 },
        { 55354701, 3855242202, 73950522 },
        { 3981734504, 3354399019, 3855242202 } },
      // Matrix for nskip = 3 * 8 ^ 8:
      { { 3515748818, 1941532786, 3590950415 },
        { 3557298699, 2872969148, 1941532786 },
        { 3200219335, 3657910297, 2872969148 } },
      // Matrix for nskip = 4 * 8 ^ 8:
      { { 4271076381, 813410089, 3461955319 },
        { 1044920137, 3029005516, 813410089 },
        { 3501837362, 3321539504, 3029005516 } },
      // Matrix for nskip = 5 * 8 ^ 8:
      { { 1749168476, 312277958, 960113158 },
        { 3444686334, 4207289909, 312277958 },
        { 2940543965, 559813450, 4207289909 } },
      // Matrix for nskip = 6 * 8 ^ 8:
      { { 316005085, 3130396563, 3837877063 },
        { 1625744025, 2903706877, 3130396563 },
        { 201947523, 3713704391, 2903706877 } },
      // Matrix for nskip = 7 * 8 ^ 8:
      { { 2725645318, 3806079268, 2159958180 },
        { 1110389513, 1295130289, 3806079268 },
        { 2596032611, 1951986222, 1295130289 } },
      // Matrix for nskip = 1 * 8 ^ 9:
      { { 3058183515, 941408572, 1783998098 },
        { 1546486080, 4116985007, 941408572 },
        { 2247500745, 1460625377, 4116985007 } },
      // Matrix for nskip = 2 * 8 ^ 9:
      { { 4216782514, 3352801941, 2315095646 },
        { 639029973, 94451952, 3352801941 },
        { 1242898773, 3964593332, 94451952 } },
      // Matrix for nskip = 3 * 8 ^ 9:
      { { 3704530610, 1763750345, 4252200234 },
        { 3310872720, 3465004782, 1763750345 },
        { 1602573750, 530766064, 3465004782 } },
      // Matrix for nskip = 4 * 8 ^ 9:
      { { 2264905138, 1926285644, 1108147171 },
        { 2390706911, 385258225, 1926285644 },
        { 3569882325, 3728744670, 385258225 } },
      // Matrix for nskip = 5 * 8 ^ 9:
      { { 1104250853, 2649508927, 1011964068 },
        { 1303004323, 2245340871, 2649508927 },
        { 2225918280, 1790484033, 2245340871 } },
      // Matrix for nskip = 6 * 8 ^ 9:
      { { 704130800, 2663175885, 3195438389 },
        { 2578332381, 377826974, 2663175885 },
        { 3055477316, 116744102, 377826974 } },
      // Matrix for nskip = 7 * 8 ^ 9:
      { { 1534677729, 1538922981, 1955454860 },
        { 3358514099, 279668397, 1538922981 },
        { 1333529549, 1503627474, 279668397 } },
      // Matrix for nskip = 1 * 8 ^ 10:
      { { 270679073, 1065683096, 2992662885 },
        { 4196917281, 2886425156, 1065683096 },
        { 749134119, 1849148167, 2886425156 } },
      // Matrix for nskip = 2 * 8 ^ 10:
      { { 35689930, 1378151623, 951629713 },
        { 673810920, 948843427, 1378151623 },
        { 3808868984, 927013635, 948843427 } },
      // Matrix for nskip = 3 * 8 ^ 10:
      { { 1708907294, 3971013929, 120796985 },
        { 341462694, 1820387182, 3971013929 },
        { 658508974, 1448556483, 1820387182 } },
      // Matrix for nskip = 4 * 8 ^ 10:
      { { 1891490872, 1130489594, 3734864133 },
        { 1457450350, 3362920032, 1130489594 },
        { 638998846, 1401175590, 3362920032 } },
      // Matrix for nskip = 5 * 8 ^ 10:
      { { 2493538871, 1119726169, 3415942617 },
        { 3041636598, 2163282065, 1119726169 },
        { 3770868549, 1056545317, 2163282065 } },
      // Matrix for nskip = 6 * 8 ^ 10:
      { { 3254893662, 3244521128, 1199630310 },
        { 4235017122, 2943451417, 3244521128 },
        { 2697569444, 4187443436, 2943451417 } },
      // Matrix for nskip = 7 * 8 ^ 10:
      { { 4046281084, 3800263816, 3215056790 },
        { 1654449614, 386290994, 3800263816 },
        { 1471940141, 481393463, 386290994 } },
      // Matrix for nskip = 1 * 8 ^ 11:
      { { 2254459023, 2384691454, 1730098031 },
        { 2844861718, 1807491073, 2384691454 },
        { 351423668, 1570264155, 1807491073 } },
      // Matrix for nskip = 2 * 8 ^ 11:
      { { 3047429268, 4245359555, 2449575498 },
        { 1797081212, 1237196477, 4245359555 },
        { 143400628, 3663731096, 1237196477 } },
      // Matrix for nskip = 3 * 8 ^ 11:
      { { 2147359263, 1349445168, 2733446300 },
        { 1305907164, 210670816, 1349445168 },
        { 2509073771, 839244126, 210670816 } },
      // Matrix for nskip = 4 * 8 ^ 11:
      { { 3313321106, 4263819658, 1047529624 },
        { 3719941673, 3155049403, 4263819658 },
        { 1981313839, 4281524426, 3155049403 } },
      // Matrix for nskip = 5 * 8 ^ 11:
      { { 1429567203, 899246895, 3248764453 },
        { 2783815531, 108747348, 899246895 },
        { 256526168, 1467875854, 108747348 } },
      // Matrix for nskip = 6 * 8 ^ 11:
      { { 2740000743, 1423127512, 1283194774 },
        { 700110581, 582760735, 1423127512 },
        { 571933335, 785351190, 582760735 } },
      // Matrix for nskip = 7 * 8 ^ 11:
      { { 448747464, 852164586, 412380392 },
        { 497540878, 2374838356, 852164586 },
        { 1830234951, 2052902650, 2374838356 } },
      // Matrix for nskip = 1 * 8 ^ 12:
      { { 2005252417, 3263186729, 1535805957 },
        { 2951515865, 1729281525, 3263186729 },
        { 1141249417, 2268963059, 1729281525 } },
      // Matrix for nskip = 2 * 8 ^ 12:
      { { 2367065164, 83908466, 4294308508 },
        { 1352516724, 1416676049, 83908466 },
        { 1040867745, 1304732377, 1416676049 } },
      // Matrix for nskip = 3 * 8 ^ 12:
      { { 2985917792, 4096493219, 1529477403 },
        { 1201774212, 2070059496, 4096493219 },
        { 1675108536, 3110356679, 2070059496 } },
      // Matrix for nskip = 4 * 8 ^ 12:
      { { 3214147257, 1434230503, 2944821434 },
        { 2753040912, 4041536918, 1434230503 },
        { 1317260239, 338830578, 4041536918 } },
      // Matrix for nskip = 5 * 8 ^ 12:
      { { 3409339184, 2193226133, 1795377731 },
        { 1348686132, 3710830263, 2193226133 },
        { 2242696089, 3564440066, 3710830263 } },
      // Matrix for nskip = 6 * 8 ^ 12:
      { { 3189933295, 1475654090, 2785534584 },
        { 4286962883, 2397146654, 1475654090 },
        { 403072156, 2221537290, 2397146654 } },
      // Matrix for nskip = 7 * 8 ^ 12:
      { { 741855424, 1898764790, 1822660758 },
        { 1315270526, 1027835471, 1898764790 },
        { 3142787072, 3867031443, 1027835471 } },
      // Matrix for nskip = 1 * 8 ^ 13:
      { { 300628476, 2054743463, 1499597869 },
        { 1762244284, 1422043015, 2054743463 },
        { 3581125669, 1207561803, 1422043015 } },
      // Matrix for nskip = 2 * 8 ^ 13:
      { { 4171745404, 4064983592, 1934508265 },
        { 3049723261, 1744636487, 4064983592 },
        { 947753516, 3952135907, 1744636487 } },
      // Matrix for nskip = 3 * 8 ^ 13:
      { { 392234088, 1933162500, 3586081024 },
        { 4234172394, 2757237142, 1933162500 },
        { 3177450083, 2703743057, 2757237142 } },
      // Matrix for nskip = 4 * 8 ^ 13:
      { { 1625369148, 3577024659, 2778677259 },
        { 1729967818, 1049600974, 3577024659 },
        { 2089137344, 1569794605, 1049600974 } },
      // Matrix for nskip = 5 * 8 ^ 13:
      { { 24259337, 1099944220, 56936276 },
        { 2473082148, 2484906695, 1099944220 },
        { 4143714563, 1902230902, 2484906695 } },
      // Matrix for nskip = 6 * 8 ^ 13:
      { { 53562000, 2164320300, 319591773 },
        { 480516705, 2016775973, 2164320300 },
        { 3670445841, 1306292301, 2016775973 } },
      // Matrix for nskip = 7 * 8 ^ 13:
      { { 1588148001, 2552094779, 2777917575 },
        { 3446764329, 4181915770, 2552094779 },
        { 2748502268, 1366641757, 4181915770 } },
      // Matrix for nskip = 1 * 8 ^ 14:
      { { 1373068765, 3958611830, 569117280 },
        { 410042396, 3551255470, 3958611830 },
        { 869476379, 1680625376, 3551255470 } },
      // Matrix for nskip = 2 * 8 ^ 14:
      { { 2108618602, 2543645250, 913717833 },
        { 2111984988, 1012482542, 2543645250 },
        { 2545745615, 3141042890, 1012482542 } },
      // Matrix for nskip = 3 * 8 ^ 14:
      { { 1200101967, 3500039413, 1380082835 },
        { 1489246316, 1939611745, 3500039413 },
        { 1721948148, 3454434256, 1939611745 } },
      // Matrix for nskip = 4 * 8 ^ 14:
      { { 1157293598, 584852249, 2272893205 },
        { 1631801979, 3013855247, 584852249 },
        { 3977310441, 82049263, 3013855247 } },
      // Matrix for nskip = 5 * 8 ^ 14:
      { { 3527704969, 2070084361, 2336461093 },
        { 675176428, 59273233, 2070084361 },
        { 215288790, 1628101656, 59273233 } },
      // Matrix for nskip = 6 * 8 ^ 14:
      { { 3037143591, 2883460010, 26163475 },
        { 1380682893, 3598790241, 2883460010 },
        { 1573828863, 3515570245, 3598790241 } },
      // Matrix for nskip = 7 * 8 ^ 14:
      { { 2503812675, 2054481550, 2095990336 },
        { 4200011507, 3373769861, 2054481550 },
        { 1172973983, 1101682881, 3373769861 } },
      // Matrix for nskip = 1 * 8 ^ 15:
      { { 3580234334, 3137526662, 2403875621 },
        { 3580869206, 3670086228, 3137526662 },
        { 656744553, 1764904195, 3670086228 } },
      // Matrix for nskip = 2 * 8 ^ 15:
      { { 2792496861, 3634185196, 3887031679 },
        { 3601823850, 3464838365, 3634185196 },
        { 3136165138, 2842987937, 3464838365 } },
      // Matrix for nskip = 3 * 8 ^ 15:
      { { 860869470, 981305692, 955067142 },
        { 1287512071, 3232580086, 981305692 },
        { 1932329582, 2220460662, 3232580086 } },
      // Matrix for nskip = 4 * 8 ^ 15:
      { { 1362557480, 3230022138, 4278720212 },
        { 3427386258, 3848976950, 3230022138 },
        { 2109817045, 2441486578, 3848976950 } },
      // Matrix for nskip = 5 * 8 ^ 15:
      { { 2708545360, 267497185, 2662390285 },
        { 13298153, 1401050440, 267497185 },
        { 2610290298, 574376174, 1401050440 } },
      // Matrix for nskip = 6 * 8 ^ 15:
      { { 4064509494, 1054794505, 2873059524 },
        { 2518650890, 2583418592, 1054794505 },
        { 2277374582, 2950188629, 2583418592 } },
      // Matrix for nskip = 7 * 8 ^ 15:
      { { 43539574, 3585947086, 1551803386 },
        { 4188500293, 3646000753, 3585947086 },
        { 1152314996, 3244390048, 3646000753 } },
      // Matrix for nskip = 1 * 8 ^ 16:
      { { 1198519135, 2007945401, 3868481 },
        { 3335076429, 2082683147, 2007945401 },
        { 2341088247, 888193479, 2082683147 } },
      // Matrix for nskip = 2 * 8 ^ 16:
      { { 3473925387, 3193380570, 565138859 },
        { 307060547, 782210925, 3193380570 },
        { 167617770, 2180014252, 782210925 } },
      // Matrix for nskip = 3 * 8 ^ 16:
      { { 3946174395, 938410993, 2583257939 },
        { 898527522, 1909350615, 938410993 },
        { 1517357015, 2538479259, 1909350615 } },
      // Matrix for nskip = 4 * 8 ^ 16:
      { { 3811588895, 3303532086, 2766583698 },
        { 908630605, 2665400165, 3303532086 },
        { 2499994113, 3316180851, 2665400165 } },
      // Matrix for nskip = 5 * 8 ^ 16:
      { { 2828295511, 296464469, 3400652741 },
        { 3697213244, 3884416364, 296464469 },
        { 2902099262, 1705355356, 3884416364 } },
      // Matrix for nskip = 6 * 8 ^ 16:
      { { 3952581582, 91397022, 1472690314 },
        { 2332659451, 3813545212, 91397022 },
        { 2942299995, 3287843695, 3813545212 } },
      // Matrix for nskip = 7 * 8 ^ 16:
      { { 1334460780, 861234488, 2817452481 },
        { 435895955, 3356827989, 861234488 },
        { 1590379239, 2041861019, 3356827989 } },
      // Matrix for nskip = 1 * 8 ^ 17:
      { { 4288926968, 3033075037, 1505732852 },
        { 1531633406, 645804125, 3033075037 },
        { 2942690261, 2205365640, 645804125 } },
      // Matrix for nskip = 2 * 8 ^ 17:
      { { 3976196483, 3651411522, 1652430357 },
        { 1690405883, 1294990760, 3651411522 },
        { 209339647, 3088484327, 1294990760 } },
      // Matrix for nskip = 3 * 8 ^ 17:
      { { 3313281387, 404839765, 4119379625 },
        { 1282760808, 1769786574, 404839765 },
        { 2156822533, 2134509408, 1769786574 } },
      // Matrix for nskip = 4 * 8 ^ 17:
      { { 3171589548, 2291131070, 2093793287 },
        { 2997812074, 4093879780, 2291131070 },
        { 3255666800, 858124816, 4093879780 } },
      // Matrix for nskip = 5 * 8 ^ 17:
      { { 2671377286, 4060168649, 2412035287 },
        { 2560486338, 828012431, 4060168649 },
        { 431779937, 1288430895, 828012431 } },
      // Matrix for nskip = 6 * 8 ^ 17:
      { { 3419357098, 2547678446, 3186955890 },
        { 3335475366, 2875872016, 2547678446 },
        { 1190772134, 216187195, 2875872016 } },
      // Matrix for nskip = 7 * 8 ^ 17:
      { { 2462780486, 3788991986, 2965830319 },
        { 4101189674, 1696959105, 3788991986 },
        { 170171245, 376763544, 1696959105 } },
      // Matrix for nskip = 1 * 8 ^ 18:
      { { 4113016361, 2999667479, 3995043314 },
        { 1333973326, 4007774239, 2999667479 },
        { 3322921863, 4278103786, 4007774239 } },
      // Matrix for nskip = 2 * 8 ^ 18:
      { { 925786347, 2109676036, 1879981040 },
        { 1701566570, 1489702270, 2109676036 },
        { 2719807628, 158549605, 1489702270 } },
      // Matrix for nskip = 3 * 8 ^ 18:
      { { 988998360, 4224987734, 2705609303 },
        { 3781735882, 3210618179, 4224987734 },
        { 2000646801, 3763764745, 3210618179 } },
      // Matrix for nskip = 4 * 8 ^ 18:
      { { 2255405265, 3460246357, 218033453 },
        { 2135115875, 359516994, 3460246357 },
        { 3568862459, 3114762683, 359516994 } },
      // Matrix for nskip = 5 * 8 ^ 18:
      { { 3151385849, 2749420870, 1663192542 },
        { 3858805987, 658557447, 2749420870 },
        { 3895454596, 3780884000, 658557447 } },
      // Matrix for nskip = 6 * 8 ^ 18:
      { { 1720065491, 953484022, 1382647120 },
        { 1315666944, 2456296663, 953484022 },
        { 572064418, 2149791939, 2456296663 } },
      // Matrix for nskip = 7 * 8 ^ 18:
      { { 2767100879, 4015038188, 1215355080 },
        { 3185998778, 1592475141, 4015038188 },
        { 135551392, 4171059118, 1592475141 } },
      // Matrix for nskip = 1 * 8 ^ 19:
      { { 773148471, 4117539411, 3073622315 },
        { 3807175775, 186466108, 4117539411 },
        { 2842197411, 651334129, 186466108 } },
      // Matrix for nskip = 2 * 8 ^ 19:
      { { 615242951, 1475251263, 3586439101 },
        { 1693917167, 3058812486, 1475251263 },
        { 568701600, 1164226398, 3058812486 } },
      // Matrix for nskip = 3 * 8 ^ 19:
      { { 3729302216, 1041711449, 2647679194 },
        { 3878048889, 135488725, 1041711449 },
        { 508494460, 2178143073, 135488725 } },
      // Matrix for nskip = 4 * 8 ^ 19:
      { { 1632636204, 15370275, 2061555515 },
        { 4187505695, 1741164221, 15370275 },
        { 2882176274, 3978412194, 1741164221 } },
      // Matrix for nskip = 5 * 8 ^ 19:
      { { 4199667935, 4240821442, 3087593298 },
        { 2968278570, 2185585470, 4240821442 },
        { 2826850420, 371506848, 2185585470 } },
      // Matrix for nskip = 6 * 8 ^ 19:
      { { 4002434761, 1455254388, 1267013695 },
        { 2324442395, 2192287989, 1455254388 },
        { 3389390262, 2190852671, 2192287989 } },
      // Matrix for nskip = 7 * 8 ^ 19:
      { { 3722528722, 3193070982, 1527096340 },
        { 3155996013, 2278658572, 3193070982 },
        { 2051186788, 4289100465, 2278658572 } },
      // Matrix for nskip = 1 * 8 ^ 20:
      { { 3446066703, 344820524, 74213775 },
        { 1008543583, 2579620192, 344820524 },
        { 3753911358, 1538453821, 2579620192 } },
      // Matrix for nskip = 2 * 8 ^ 20:
      { { 3600859892, 1269921024, 4069458760 },
        { 2050939727, 2222725697, 1269921024 },
        { 3208347646, 690898125, 2222725697 } },
      // Matrix for nskip = 3 * 8 ^ 20:
      { { 2580978896, 2572090525, 3334144098 },
        { 804558063, 250626667, 2572090525 },
        { 843125518, 1038659713, 250626667 } },
      // Matrix for nskip = 4 * 8 ^ 20:
      { { 599407451, 2806239788, 1742216102 },
        { 975123999, 764869161, 2806239788 },
        { 2729710367, 1845257036, 764869161 } },
      // Matrix for nskip = 5 * 8 ^ 20:
      { { 1900612628, 1237821080, 3847187360 },
        { 4059416755, 2650131939, 1237821080 },
        { 31199658, 2064718263, 2650131939 } },
      // Matrix for nskip = 6 * 8 ^ 20:
      { { 1347324880, 3034196764, 3435152676 },
        { 2459581108, 68307108, 3034196764 },
        { 4060225449, 1313975073, 68307108 } },
      // Matrix for nskip = 7 * 8 ^ 20:
      { { 832405527, 4273872816, 2483412578 },
        { 1083671641, 2619838177, 4273872816 },
        { 3452165941, 3089879239, 2619838177 } },
      // Matrix for nskip = 1 * 8 ^ 21:
      { { 967330218, 3464884028, 3444447102 },
        { 580449578, 1343714307, 3464884028 },
        { 1775329096, 4027221761, 1343714307 } },
      // Matrix for nskip = 2 * 8 ^ 21:
      { { 3426136514, 4123590610, 2477690850 },
        { 1284315665, 1604068527, 4123590610 },
        { 1818147893, 320435440, 1604068527 } },
      // Matrix for nskip = 3 * 8 ^ 21:
      { { 2183845304, 1753369147, 3320030113 },
        { 1615069375, 2429599106, 1753369147 },
        { 4089942461, 816400070, 2429599106 } },
      // Matrix for nskip = 4 * 8 ^ 21:
      { { 2678132557, 89090276, 2719996384 },
        { 607972119, 3383659282, 89090276 },
        { 480221151, 2265789281, 3383659282 } },
      // Matrix for nskip = 5 * 8 ^ 21:
      { { 1549131095, 4063932361, 140002783 },
        { 3213919212, 3321129811, 4063932361 },
        { 2806676458, 1803235719, 3321129811 } },
      // Matrix for nskip = 6 * 8 ^ 21:
      { { 2289583273, 1236554533, 358687301 },
        { 1498394381, 1159516887, 1236554533 },
        { 359182081, 4214998734, 1159516887 } },
      // Matrix for nskip = 7 * 8 ^ 21:
      { { 1434974522, 4046133592, 349947526 },
        { 383007031, 4052481195, 4046133592 },
        { 1677657970, 799675597, 4052481195 } },
      // Matrix for nskip = 1 * 8 ^ 22:
      { { 1827237091, 2290099491, 614471834 },
        { 3711385978, 2748163602, 2290099491 },
        { 2067064347, 1071954219, 2748163602 } },
      // Matrix for nskip = 2 * 8 ^ 22:
      { { 3894793123, 921712152, 596236860 },
        { 4038673596, 4279784147, 921712152 },
        { 1999065039, 859801225, 4279784147 } },
      // Matrix for nskip = 3 * 8 ^ 22:
      { { 3518731582, 2398700699, 3703766159 },
        { 1998914732, 1951351916, 2398700699 },
        { 2852188423, 1461089983, 1951351916 } },
      // Matrix for nskip = 4 * 8 ^ 22:
      { { 7276915, 3205297712, 1204204130 },
        { 2667672243, 2737282292, 3205297712 },
        { 2282864144, 2305990443, 2737282292 } },
      // Matrix for nskip = 5 * 8 ^ 22:
      { { 2376625824, 3090473348, 776691260 },
        { 4067754877, 2149314284, 3090473348 },
        { 198230411, 2870222545, 2149314284 } },
      // Matrix for nskip = 6 * 8 ^ 22:
      { { 1638154181, 688311656, 278971912 },
        { 2626529484, 1769978612, 688311656 },
        { 2951434168, 1794042358, 1769978612 } },
      // Matrix for nskip = 7 * 8 ^ 22:
      { { 3742216352, 1164158193, 1223269258 },
        { 3621125172, 3964660872, 1164158193 },
        { 3373873746, 2614176571, 3964660872 } },
      // Matrix for nskip = 1 * 8 ^ 23:
      { { 935922304, 2428000499, 510672020 },
        { 1541887892, 92472822, 2428000499 },
        { 4146892220, 1307489118, 92472822 } },
      // Matrix for nskip = 2 * 8 ^ 23:
      { { 690398653, 3787391292, 1705516721 },
        { 2953871718, 4173917861, 3787391292 },
        { 817556203, 3090114656, 4173917861 } },
      // Matrix for nskip = 3 * 8 ^ 23:
      { { 2596837368, 523638114, 796925063 },
        { 2436421546, 3808361324, 523638114 },
        { 3645860436, 2767640965, 3808361324 } },
      // Matrix for nskip = 4 * 8 ^ 23:
      { { 476867729, 1917800003, 1740083735 },
        { 3167988201, 1286715218, 1917800003 },
        { 2579365599, 4173763431, 1286715218 } },
      // Matrix for nskip = 5 * 8 ^ 23:
      { { 875985265, 2902381003, 3585549348 },
        { 1487116735, 20494290, 2902381003 },
        { 3417450723, 672893019, 20494290 } },
      // Matrix for nskip = 6 * 8 ^ 23:
      { { 680890926, 3782598365, 3927087723 },
        { 3291528625, 2096301120, 3782598365 },
        { 3927430411, 2089751145, 2096301120 } },
      // Matrix for nskip = 7 * 8 ^ 23:
      { { 2506371881, 3282095953, 1709670308 },
        { 2778786590, 3316228403, 3282095953 },
        { 3936394935, 4103225131, 3316228403 } },
      // Matrix for nskip = 1 * 8 ^ 24:
      { { 4092801160, 3749431174, 542781592 },
        { 1208313783, 217808460, 3749431174 },
        { 2708923752, 348848516, 217808460 } },
      // Matrix for nskip = 2 * 8 ^ 24:
      { { 381829350, 1732869179, 3638540651 },
        { 2509789412, 1114357536, 1732869179 },
        { 2465372475, 350550480, 1114357536 } },
      // Matrix for nskip = 3 * 8 ^ 24:
      { { 4088394360, 3507668274, 103212933 },
        { 1229010797, 2457049990, 3507668274 },
        { 1543332620, 3557973226, 2457049990 } },
      // Matrix for nskip = 4 * 8 ^ 24:
      { { 3712059912, 1698887908, 3706277064 },
        { 2152325130, 232741719, 1698887908 },
        { 4114351745, 170237153, 232741719 } },
      // Matrix for nskip = 5 * 8 ^ 24:
      { { 2230538189, 2798697140, 2813869207 },
        { 2098708615, 4247643355, 2798697140 },
        { 1732506223, 3352831267, 4247643355 } },
      // Matrix for nskip = 6 * 8 ^ 24:
      { { 141104167, 950363290, 3526146168 },
        { 1842485244, 366288723, 950363290 },
        { 901263071, 3346018419, 366288723 } },
      // Matrix for nskip = 7 * 8 ^ 24:
      { { 1273880950, 1252923554, 845609283 },
        { 3523638916, 1756558336, 1252923554 },
        { 983823623, 3396822999, 1756558336 } },
      // Matrix for nskip = 1 * 8 ^ 25:
      { { 993804379, 905755330, 1717718779 },
        { 1712994855, 2713148271, 905755330 },
        { 2200585411, 111258429, 2713148271 } },
      // Matrix for nskip = 2 * 8 ^ 25:
      { { 82758667, 1871391091, 4127413238 },
        { 3672831523, 69195019, 1871391091 },
        { 3672091415, 3528743235, 69195019 } },
      // Matrix for nskip = 3 * 8 ^ 25:
      { { 1954591259, 636118602, 2621269238 },
        { 462961075, 4030630272, 636118602 },
        { 3305976356, 1757343588, 4030630272 } },
      // Matrix for nskip = 4 * 8 ^ 25:
      { { 3361372532, 2329303404, 99651939 },
        { 2008671965, 2931758910, 2329303404 },
        { 1113529483, 2374097189, 2931758910 } },
      // Matrix for nskip = 5 * 8 ^ 25:
      { { 1475330900, 1973232757, 3087886870 },
        { 1184427939, 3491162930, 1973232757 },
        { 4229179055, 3166281484, 3491162930 } },
      // Matrix for nskip = 6 * 8 ^ 25:
      { { 2138712950, 3210181465, 230171794 },
        { 1011789944, 3536018417, 3210181465 },
        { 2847216174, 620673032, 3536018417 } },
      // Matrix for nskip = 7 * 8 ^ 25:
      { { 1691375920, 1708800738, 1210582211 },
        { 2919192023, 1561934882, 1708800738 },
        { 3388931282, 2988640653, 1561934882 } },
      // Matrix for nskip = 1 * 8 ^ 26:
      { { 1831590873, 1588259595, 1314332382 },
        { 2385989343, 2508077280, 1588259595 },
        { 1787615788, 661437137, 2508077280 } },
      // Matrix for nskip = 2 * 8 ^ 26:
      { { 2326052247, 4183591379, 4049009082 },
        { 2604529491, 1453913233, 4183591379 },
        { 2311925423, 1805360390, 1453913233 } },
      // Matrix for nskip = 3 * 8 ^ 26:
      { { 664423898, 2590401961, 4225456867 },
        { 3913458720, 1982184590, 2590401961 },
        { 2950459869, 334885555, 1982184590 } },
      // Matrix for nskip = 4 * 8 ^ 26:
      { { 3956367490, 604461629, 1257432102 },
        { 794711716, 1155867175, 604461629 },
        { 1777070788, 429445904, 1155867175 } },
      // Matrix for nskip = 5 * 8 ^ 26:
      { { 2357556007, 3027793563, 3037152168 },
        { 328118796, 419690250, 3027793563 },
        { 2699357594, 1143766272, 419690250 } },
      // Matrix for nskip = 6 * 8 ^ 26:
      { { 3183717084, 2634631308, 2109777894 },
        { 1745049657, 2872637888, 2634631308 },
        { 3660634616, 2434030341, 2872637888 } },
      // Matrix for nskip = 7 * 8 ^ 26:
      { { 961674331, 524745427, 3832393053 },
        { 2375268260, 2883640227, 524745427 },
        { 3564327755, 2130782725, 2883640227 } },
      // Matrix for nskip = 1 * 8 ^ 27:
      { { 1686241617, 1257046062, 1427609439 },
        { 490376081, 387798431, 1257046062 },
        { 235551485, 1312672615, 387798431 } },
      // Matrix for nskip = 2 * 8 ^ 27:
      { { 2362447880, 3445363024, 3160262066 },
        { 2426867845, 4194339866, 3445363024 },
        { 1046144413, 4177893681, 4194339866 } },
      // Matrix for nskip = 3 * 8 ^ 27:
      { { 2399569099, 1723951785, 2356709199 },
        { 332901774, 3265509251, 1723951785 },
        { 3616767886, 1726850927, 3265509251 } },
      // Matrix for nskip = 4 * 8 ^ 27:
      { { 4251175413, 3559576374, 3107663662 },
        { 697539134, 1909472435, 3559576374 },
        { 280754246, 375835695, 1909472435 } },
      // Matrix for nskip = 5 * 8 ^ 27:
      { { 1441163739, 911930333, 4028966669 },
        { 3689446034, 1473406035, 911930333 },
        { 3884376669, 1954838782, 1473406035 } },
      // Matrix for nskip = 6 * 8 ^ 27:
      { { 751906018, 4203984455, 2167450892 },
        { 3937403282, 1862670973, 4203984455 },
        { 402523958, 496211406, 1862670973 } },
      // Matrix for nskip = 7 * 8 ^ 27:
      { { 726664456, 2233062609, 98234458 },
        { 149028817, 3613797222, 2233062609 },
        { 3848675801, 4164228265, 3613797222 } },
      // Matrix for nskip = 1 * 8 ^ 28:
      { { 1099512970, 712404985, 1571467521 },
        { 546519870, 1135109300, 712404985 },
        { 3325312332, 2352874613, 1135109300 } },
      // Matrix for nskip = 2 * 8 ^ 28:
      { { 1945425936, 1653045514, 381988982 },
        { 3733376326, 414410025, 1653045514 },
        { 1181583679, 1185848176, 414410025 } },
      // Matrix for nskip = 3 * 8 ^ 28:
      { { 80175856, 1301935019, 1963289366 },
        { 3961455404, 65355284, 1301935019 },
        { 3052316027, 2858851708, 65355284 } },
      // Matrix for nskip = 4 * 8 ^ 28:
      { { 2526336124, 3019211015, 4215964965 },
        { 2683163472, 4188191530, 3019211015 },
        { 2964651598, 293801056, 4188191530 } },
      // Matrix for nskip = 5 * 8 ^ 28:
      { { 1749670132, 1387140872, 762351827 },
        { 2971687592, 1196758134, 1387140872 },
        { 237185264, 1741700121, 1196758134 } },
      // Matrix for nskip = 6 * 8 ^ 28:
      { { 4238062407, 481737140, 1487069976 },
        { 878719633, 759707097, 481737140 },
        { 749051338, 825174423, 759707097 } },
      // Matrix for nskip = 7 * 8 ^ 28:
      { { 1955913150, 1130524081, 2151646894 },
        { 499306218, 101202533, 1130524081 },
        { 2744191919, 1603656961, 101202533 } },
      // Matrix for nskip = 1 * 8 ^ 29:
      { { 1444052678, 2253324417, 39719589 },
        { 1880267534, 2391992038, 2253324417 },
        { 987740265, 3691889508, 2391992038 } },
      // Matrix for nskip = 2 * 8 ^ 29:
      { { 166599066, 2335494420, 1232261118 },
        { 2227597731, 2570600780, 2335494420 },
        { 2700034538, 3460843234, 2570600780 } },
      // Matrix for nskip = 3 * 8 ^ 29:
      { { 391577970, 1926759295, 2700541692 },
        { 1952364431, 2281246481, 1926759295 },
        { 1819825140, 2377574285, 2281246481 } },
      // Matrix for nskip = 4 * 8 ^ 29:
      { { 2511338360, 1188954576, 1251401239 },
        { 2511664974, 292276982, 1188954576 },
        { 697844082, 3093661552, 292276982 } },
      // Matrix for nskip = 5 * 8 ^ 29:
      { { 3984792772, 688024800, 2775323178 },
        { 2263182715, 2971941970, 688024800 },
        { 3585402638, 2532257287, 2971941970 } },
      // Matrix for nskip = 6 * 8 ^ 29:
      { { 1029044592, 4040666706, 3671213347 },
        { 902332253, 3140636559, 4040666706 },
        { 1429177194, 3213333408, 3140636559 } },
      // Matrix for nskip = 7 * 8 ^ 29:
      { { 3635935824, 599310841, 2541542820 },
        { 1942681116, 83716008, 599310841 },
        { 2957115888, 464001685, 83716008 } },
      // Matrix for nskip = 1 * 8 ^ 30:
      { { 3624650744, 51993077, 3540268009 },
        { 3252828938, 3710319575, 51993077 },
        { 2858628849, 3910069381, 3710319575 } },
      // Matrix for nskip = 2 * 8 ^ 30:
      { { 655966702, 754002362, 1646581402 },
        { 1958331075, 475572423, 754002362 },
        { 3248619000, 3228514800, 475572423 } },
      // Matrix for nskip = 3 * 8 ^ 30:
      { { 135820422, 1138672588, 1020827900 },
        { 626151178, 4149545048, 1138672588 },
        { 2180788629, 1314604300, 4149545048 } },
      // Matrix for nskip = 4 * 8 ^ 30:
      { { 2760311307, 4166372813, 741596417 },
        { 2282679206, 3090782630, 4166372813 },
        { 3242468721, 1628442374, 3090782630 } },
      // Matrix for nskip = 5 * 8 ^ 30:
      { { 88347075, 1420161828, 3113798953 },
        { 217224032, 2004343529, 1420161828 },
        { 4048389654, 3845790311, 2004343529 } },
      // Matrix for nskip = 6 * 8 ^ 30:
      { { 4237022985, 912148655, 165387559 },
        { 252556101, 230998942, 912148655 },
        { 2978268820, 7678432, 230998942 } },
      // Matrix for nskip = 7 * 8 ^ 30:
      { { 1702648282, 936444437, 2113813328 },
        { 2870633999, 384435053, 936444437 },
        { 2426580506, 1660785110, 384435053 } },
      // Matrix for nskip = 1 * 8 ^ 31:
      { { 4265279407, 3532111852, 1754687396 },
        { 500404765, 2603727025, 3532111852 },
        { 1428367254, 3149485478, 2603727025 } },
      // Matrix for nskip = 2 * 8 ^ 31:
      { { 2873769531, 2081104178, 596284397 },
        { 4153800443, 1261269623, 2081104178 },
        { 3967600061, 1830023157, 1261269623 } },
      // Matrix for nskip = 3 * 8 ^ 31:
      { { 1219416476, 2833805942, 877956083 },
        { 4136201738, 926561185, 2833805942 },
        { 790563916, 2950279312, 926561185 } },
      // Matrix for nskip = 4 * 8 ^ 31:
      { { 278611533, 2229285304, 3443204327 },
        { 3110641420, 77498444, 2229285304 },
        { 3904070810, 1070507239, 77498444 } },
      // Matrix for nskip = 5 * 8 ^ 31:
      { { 1569490059, 1438273012, 1676406913 },
        { 2246148877, 835628171, 1438273012 },
        { 1001911068, 165198836, 835628171 } },
      // Matrix for nskip = 6 * 8 ^ 31:
      { { 219341062, 236464123, 3922106376 },
        { 244990374, 2122146632, 236464123 },
        { 2065383788, 2977102789, 2122146632 } },
      // Matrix for nskip = 7 * 8 ^ 31:
      { { 2250560481, 1729521343, 424414765 },
        { 2059608998, 3276353542, 1729521343 },
        { 2230558099, 3933677451, 3276353542 } },
      // Matrix for nskip = 1 * 8 ^ 32:
      { { 544639534, 568528663, 2177189807 },
        { 2475829068, 121482268, 568528663 },
        { 876978915, 3116647617, 121482268 } },
      // Matrix for nskip = 2 * 8 ^ 32:
      { { 1547862823, 2404658587, 4191448009 },
        { 2158188804, 2976916793, 2404658587 },
        { 168571747, 1691884706, 2976916793 } },
      // Matrix for nskip = 3 * 8 ^ 32:
      { { 2707010111, 2933510859, 4240166566 },
        { 1177241360, 62338927, 2933510859 },
        { 2798158767, 906126073, 62338927 } },
      // Matrix for nskip = 4 * 8 ^ 32:
      { { 3208213311, 4212638780, 3235157352 },
        { 671148556, 2951207765, 4212638780 },
        { 2075145516, 2395485231, 2951207765 } },
      // Matrix for nskip = 5 * 8 ^ 32:
      { { 3757387996, 3349220842, 3722506196 },
        { 224784515, 2952700002, 3349220842 },
        { 1142378033, 2302905244, 2952700002 } },
      // Matrix for nskip = 6 * 8 ^ 32:
      { { 1941283113, 145407649, 659394903 },
        { 347432419, 1571592397, 145407649 },
        { 2204145504, 3369375773, 1571592397 } },
      // Matrix for nskip = 7 * 8 ^ 32:
      { { 1094854803, 386906095, 3767619826 },
        { 1281474767, 179198568, 386906095 },
        { 3021644798, 3594781674, 179198568 } },
      // Matrix for nskip = 1 * 8 ^ 33:
      { { 4080517315, 2133433101, 4043998180 },
        { 2044221845, 867670560, 2133433101 },
        { 834432416, 3613001199, 867670560 } },
      // Matrix for nskip = 2 * 8 ^ 33:
      { { 4102885735, 1319434267, 2678775073 },
        { 740092580, 607380970, 1319434267 },
        { 2198271844, 2610193258, 607380970 } },
      // Matrix for nskip = 3 * 8 ^ 33:
      { { 2725610481, 764583647, 1059048169 },
        { 2571438051, 3510614410, 764583647 },
        { 1753866259, 3525435230, 3510614410 } },
      // Matrix for nskip = 4 * 8 ^ 33:
      { { 1165218048, 1317690360, 1189150958 },
        { 399240205, 2507168618, 1317690360 },
        { 2988334517, 2687593413, 2507168618 } },
      // Matrix for nskip = 5 * 8 ^ 33:
      { { 1160307294, 3843003921, 120011318 },
        { 1648569394, 2331840681, 3843003921 },
        { 2666551617, 1826785014, 2331840681 } },
      // Matrix for nskip = 6 * 8 ^ 33:
      { { 2745374441, 3528536028, 2077936780 },
        { 3475527779, 16047360, 3528536028 },
        { 1346223401, 3691116188, 16047360 } },
      // Matrix for nskip = 7 * 8 ^ 33:
      { { 3985894561, 4225395152, 3428831071 },
        { 3666024757, 3230532631, 4225395152 },
        { 2407932196, 4261187489, 3230532631 } },
      // Matrix for nskip = 1 * 8 ^ 34:
      { { 1028861702, 4082006648, 338232527 },
        { 1888486946, 1842080991, 4082006648 },
        { 3903826366, 3109935091, 1842080991 } },
      // Matrix for nskip = 2 * 8 ^ 34:
      { { 614134826, 2261996505, 2888080641 },
        { 710199359, 2773979788, 2261996505 },
        { 1144301620, 2554371815, 2773979788 } },
      // Matrix for nskip = 3 * 8 ^ 34:
      { { 3872045348, 2988495416, 3084935324 },
        { 1788745968, 3505214566, 2988495416 },
        { 2741627244, 478558438, 3505214566 } },
      // Matrix for nskip = 4 * 8 ^ 34:
      { { 4056173823, 1285620078, 357420018 },
        { 2423072612, 2309408315, 1285620078 },
        { 1533175115, 2760088020, 2309408315 } },
      // Matrix for nskip = 5 * 8 ^ 34:
      { { 3469546091, 369086126, 3478496559 },
        { 3780710118, 589042104, 369086126 },
        { 1900191562, 3935275606, 589042104 } },
      // Matrix for nskip = 6 * 8 ^ 34:
      { { 1682769046, 1059146837, 2627186100 },
        { 975501718, 2081627761, 1059146837 },
        { 4182902400, 2809990303, 2081627761 } },
      // Matrix for nskip = 7 * 8 ^ 34:
      { { 3037332387, 2654288975, 181147870 },
        { 454223518, 808123674, 2654288975 },
        { 967475810, 1382885174, 808123674 } },
      // Matrix for nskip = 1 * 8 ^ 35:
      { { 4264130267, 815015434, 3142242173 },
        { 180649975, 2500813569, 815015434 },
        { 3378723563, 829683767, 2500813569 } },
      // Matrix for nskip = 2 * 8 ^ 35:
      { { 4174387531, 1030729435, 2812778314 },
        { 1752988797, 4044178729, 1030729435 },
        { 467969301, 554748104, 4044178729 } },
      // Matrix for nskip = 3 * 8 ^ 35:
      { { 1224655671, 538480994, 911775489 },
        { 571730491, 1197428336, 538480994 },
        { 310254483, 3482088360, 1197428336 } },
      // Matrix for nskip = 4 * 8 ^ 35:
      { { 1348429235, 2928743274, 3776082629 },
        { 3607529209, 3069812185, 2928743274 },
        { 2542432347, 3208181168, 3069812185 } },
      // Matrix for nskip = 5 * 8 ^ 35:
      { { 2414375640, 2994139106, 1829200407 },
        { 3723068499, 3276234188, 2994139106 },
        { 1384068579, 3863982741, 3276234188 } },
      // Matrix for nskip = 6 * 8 ^ 35:
      { { 798763723, 2897556757, 3145856482 },
        { 3421663444, 3946110585, 2897556757 },
        { 1853745554, 260368160, 3946110585 } },
      // Matrix for nskip = 7 * 8 ^ 35:
      { { 95178102, 3740645591, 3060595950 },
        { 3321952562, 3932965485, 3740645591 },
        { 76660843, 2044406932, 3932965485 } },
      // Matrix for nskip = 1 * 8 ^ 36:
      { { 4064845753, 668285756, 3816217625 },
        { 3713143233, 1380634204, 668285756 },
        { 3533700508, 1192551435, 1380634204 } },
      // Matrix for nskip = 2 * 8 ^ 36:
      { { 1515684518, 1706771705, 728123349 },
        { 3174850469, 2057456462, 1706771705 },
        { 3410402985, 2897339640, 2057456462 } },
      // Matrix for nskip = 3 * 8 ^ 36:
      { { 493252920, 4038063126, 2168451262 },
        { 363246278, 1249105026, 4038063126 },
        { 3395543717, 3358422070, 1249105026 } },
      // Matrix for nskip = 4 * 8 ^ 36:
      { { 3082272717, 531091457, 1390161328 },
        { 3895139973, 2171402857, 531091457 },
        { 4030688141, 3049703400, 2171402857 } },
      // Matrix for nskip = 5 * 8 ^ 36:
      { { 3935740675, 2355871533, 3949682718 },
        { 2931048320, 902295474, 2355871533 },
        { 847382876, 591758943, 902295474 } },
      // Matrix for nskip = 6 * 8 ^ 36:
      { { 1096633558, 956915353, 71119600 },
        { 1282074175, 3814732591, 956915353 },
        { 1834617826, 3605659623, 3814732591 } },
      // Matrix for nskip = 7 * 8 ^ 36:
      { { 1213485394, 883705085, 1819500595 },
        { 3547515338, 2658882772, 883705085 },
        { 3298597677, 2195730734, 2658882772 } },
      // Matrix for nskip = 1 * 8 ^ 37:
      { { 1241147206, 3193892819, 1244284192 },
        { 65180262, 4065669017, 3193892819 },
        { 1484817937, 3661081858, 4065669017 } },
      // Matrix for nskip = 2 * 8 ^ 37:
      { { 1438760812, 3491341751, 3414470157 },
        { 2805337292, 272266053, 3491341751 },
        { 824109230, 3202556526, 272266053 } },
      // Matrix for nskip = 3 * 8 ^ 37:
      { { 3548908153, 1458259435, 2902555273 },
        { 3865796034, 2523447078, 1458259435 },
        { 2359984375, 3898395136, 2523447078 } },
      // Matrix for nskip = 4 * 8 ^ 37:
      { { 135412706, 3627115412, 2345042216 },
        { 1565169824, 2166856449, 3627115412 },
        { 1026946745, 3467845248, 2166856449 } },
      // Matrix for nskip = 5 * 8 ^ 37:
      { { 4146693931, 4048659004, 2768049120 },
        { 2555866488, 2548281288, 4048659004 },
        { 2954738533, 4242463239, 2548281288 } },
      // Matrix for nskip = 6 * 8 ^ 37:
      { { 1796100563, 2291501743, 3432007410 },
        { 1204345078, 1110795947, 2291501743 },
        { 3388382946, 3937816720, 1110795947 } },
      // Matrix for nskip = 7 * 8 ^ 37:
      { { 3208221515, 607811602, 223757102 },
        { 377063363, 3323143974, 607811602 },
        { 279359428, 3272907713, 3323143974 } },
      // Matrix for nskip = 1 * 8 ^ 38:
      { { 1889419951, 3256876154, 1240505488 },
        { 1254783743, 989966800, 3256876154 },
        { 1995297400, 3692472918, 989966800 } },
      // Matrix for nskip = 2 * 8 ^ 38:
      { { 3206226875, 285700890, 496017472 },
        { 2515316194, 2129675196, 285700890 },
        { 1863853990, 2673457552, 2129675196 } },
      // Matrix for nskip = 3 * 8 ^ 38:
      { { 2643396669, 1141176790, 2183048631 },
        { 2796763418, 686457718, 1141176790 },
        { 3473541724, 755015447, 686457718 } },
      // Matrix for nskip = 4 * 8 ^ 38:
      { { 4163770641, 255160418, 772100749 },
        { 1987092456, 3237660221, 255160418 },
        { 1394381051, 4216039401, 3237660221 } },
      // Matrix for nskip = 5 * 8 ^ 38:
      { { 2744038617, 4151599085, 1086739611 },
        { 2137012024, 1231067556, 4151599085 },
        { 2054217062, 1474724988, 1231067556 } },
      // Matrix for nskip = 6 * 8 ^ 38:
      { { 1966926556, 2167105562, 3642406633 },
        { 3575908026, 76072334, 2167105562 },
        { 438275780, 1024705325, 76072334 } },
      // Matrix for nskip = 7 * 8 ^ 38:
      { { 3144149631, 1078973412, 1395133864 },
        { 1200101371, 2263842276, 1078973412 },
        { 1990245354, 4126971783, 2263842276 } },
      // Matrix for nskip = 1 * 8 ^ 39:
      { { 2133915627, 2713747584, 627765421 },
        { 2300605925, 35690583, 2713747584 },
        { 2918902946, 2638220304, 35690583 } },
      // Matrix for nskip = 2 * 8 ^ 39:
      { { 2587549655, 998684270, 4292130625 },
        { 1791772791, 2820705344, 998684270 },
        { 124590158, 3831143549, 2820705344 } },
      // Matrix for nskip = 3 * 8 ^ 39:
      { { 3910080826, 1802646553, 3446926966 },
        { 129865302, 1755670478, 1802646553 },
        { 1006007080, 2257707516, 1755670478 } },
      // Matrix for nskip = 4 * 8 ^ 39:
      { { 978482299, 3200877282, 497605289 },
        { 3717741518, 3737164414, 3200877282 },
        { 4046686626, 861393946, 3737164414 } },
      // Matrix for nskip = 5 * 8 ^ 39:
      { { 3183253558, 201453184, 3145469059 },
        { 3983740037, 3717279042, 201453184 },
        { 976459397, 485566112, 3717279042 } },
      // Matrix for nskip = 6 * 8 ^ 39:
      { { 1649247358, 1293997566, 1141681757 },
        { 2104529013, 3994478979, 1293997566 },
        { 12048398, 1296267255, 3994478979 } },
      // Matrix for nskip = 7 * 8 ^ 39:
      { { 1277127010, 3409985649, 2357026796 },
        { 546146378, 1239287374, 3409985649 },
        { 684416427, 1435662521, 1239287374 } },
      // Matrix for nskip = 1 * 8 ^ 40:
      { { 2665561897, 300934584, 3179822945 },
        { 893043137, 2031413512, 300934584 },
        { 3806926970, 2413249929, 2031413512 } },
      // Matrix for nskip = 2 * 8 ^ 40:
      { { 1417581911, 3071835354, 2575196237 },
        { 4101127251, 1375339216, 3071835354 },
        { 847617977, 3632503316, 1375339216 } },
      // Matrix for nskip = 3 * 8 ^ 40:
      { { 608673033, 22126256, 3556899267 },
        { 1727979207, 849327659, 22126256 },
        { 1702248031, 791369590, 849327659 } },
      // Matrix for nskip = 4 * 8 ^ 40:
      { { 2747488994, 3296604805, 898095468 },
        { 1742777145, 219265369, 3296604805 },
        { 823714885, 667779292, 219265369 } },
      // Matrix for nskip = 5 * 8 ^ 40:
      { { 2021014596, 471433423, 2651735970 },
        { 585977516, 1605468910, 471433423 },
        { 549943099, 3890474462, 1605468910 } },
      // Matrix for nskip = 6 * 8 ^ 40:
      { { 3574350911, 1933183379, 2250823873 },
        { 1024311233, 365568357, 1933183379 },
        { 3430128519, 3029426194, 365568357 } },
      // Matrix for nskip = 7 * 8 ^ 40:
      { { 1074178830, 2265105869, 2758013402 },
        { 4125786414, 1034741107, 2265105869 },
        { 1441524697, 2229554511, 1034741107 } },
      // Matrix for nskip = 1 * 8 ^ 41:
      { { 2640209692, 3040506537, 3626115220 },
        { 161827078, 852668118, 3040506537 },
        { 3856381322, 3360242076, 852668118 } },
      // Matrix for nskip = 2 * 8 ^ 41:
      { { 3734246393, 4151553160, 4177051283 },
        { 266522866, 1731798531, 4151553160 },
        { 632196679, 3864297722, 1731798531 } },
      // Matrix for nskip = 3 * 8 ^ 41:
      { { 688933188, 355423319, 287306155 },
        { 1805598431, 3402169658, 355423319 },
        { 2000267685, 2145558314, 3402169658 } },
      // Matrix for nskip = 4 * 8 ^ 41:
      { { 1694175127, 1087914338, 2384195794 },
        { 2764925057, 505782858, 1087914338 },
        { 3235634082, 807915248, 505782858 } },
      // Matrix for nskip = 5 * 8 ^ 41:
      { { 993693315, 3946332366, 3916271739 },
        { 1789813323, 4018933334, 3946332366 },
        { 441058505, 3553235314, 4018933334 } },
      // Matrix for nskip = 6 * 8 ^ 41:
      { { 1144818794, 3134263190, 1846865568 },
        { 1502689349, 1628360471, 3134263190 },
        { 745146577, 1872576407, 1628360471 } },
      // Matrix for nskip = 7 * 8 ^ 41:
      { { 3398717147, 3990568019, 892329010 },
        { 3847547913, 3198332877, 3990568019 },
        { 333749571, 1549630885, 3198332877 } },
      // Matrix for nskip = 1 * 8 ^ 42:
      { { 2402749950, 2353776151, 75909174 },
        { 890570951, 1752665661, 2353776151 },
        { 3120241607, 3862435696, 1752665661 } },
      // Matrix for nskip = 2 * 8 ^ 42:
      { { 2427906178, 3580155704, 949770784 },
        { 226153695, 1230515664, 3580155704 },
        { 1988835001, 986791581, 1230515664 } },
      // Matrix for nskip = 3 * 8 ^ 42:
      { { 2162922488, 4037183513, 346268022 },
        { 2752767565, 2852643415, 4037183513 },
        { 3557895539, 3796282786, 2852643415 } },
      // Matrix for nskip = 4 * 8 ^ 42:
      { { 1774047142, 3199155377, 3106427820 },
        { 1901920839, 4290900039, 3199155377 },
        { 4178980191, 280623348, 4290900039 } },
      // Matrix for nskip = 5 * 8 ^ 42:
      { { 564504637, 3960126556, 13271050 },
        { 3975695622, 272607318, 3960126556 },
        { 1199282733, 981722530, 272607318 } },
      // Matrix for nskip = 6 * 8 ^ 42:
      { { 3723690896, 3153461912, 693938118 },
        { 2676196226, 1636264737, 3153461912 },
        { 764380249, 3364804206, 1636264737 } },
      // Matrix for nskip = 7 * 8 ^ 42:
      { { 2002746065, 838117661, 347920205 },
        { 3311479485, 2381255152, 838117661 },
        { 4107898714, 2782779087, 2381255152 } },
      // Matrix for nskip = 1 * 8 ^ 43:
      { { 3567524348, 1934119675, 3188270128 },
        { 2997767678, 826363896, 1934119675 },
        { 262952343, 614326610, 826363896 } },
      // Matrix for nskip = 2 * 8 ^ 43:
      { { 1625613062, 4288164505, 2481284279 },
        { 4273461426, 1177260757, 4288164505 },
        { 305959988, 4017252267, 1177260757 } },
      // Matrix for nskip = 3 * 8 ^ 43:
      { { 3536417809, 429648601, 2955466274 },
        { 1272075175, 3057838997, 429648601 },
        { 2269698346, 4011682346, 3057838997 } },
      // Matrix for nskip = 4 * 8 ^ 43:
      { { 337929267, 333342539, 418300166 },
        { 2944208672, 379097734, 333342539 },
        { 2084056909, 3625475947, 379097734 } },
      // Matrix for nskip = 5 * 8 ^ 43:
      { { 68058625, 1918117806, 635887182 },
        { 1946098288, 2963456150, 1918117806 },
        { 2625600235, 2337231210, 2963456150 } },
      // Matrix for nskip = 6 * 8 ^ 43:
      { { 1700493457, 3627573759, 545164662 },
        { 1921927973, 1170497671, 3627573759 },
        { 3094336698, 2906222607, 1170497671 } },
      // Matrix for nskip = 7 * 8 ^ 43:
      { { 575329368, 1216196496, 4089812320 },
        { 2113496301, 1220844336, 1216196496 },
        { 3926254763, 817590918, 1220844336 } },
      // Matrix for nskip = 1 * 8 ^ 44:
      { { 1189899255, 1307754719, 1214919992 },
        { 3736721708, 3514751918, 1307754719 },
        { 732435953, 2021244538, 3514751918 } },
      // Matrix for nskip = 2 * 8 ^ 44:
      { { 4089172695, 1533534334, 525643282 },
        { 1497577018, 1335684482, 1533534334 },
        { 2079007086, 3977541427, 1335684482 } },
      // Matrix for nskip = 3 * 8 ^ 44:
      { { 851614119, 2992100005, 2852461785 },
        { 2850360626, 2514447281, 2992100005 },
        { 978015612, 1397973230, 2514447281 } },
      // Matrix for nskip = 4 * 8 ^ 44:
      { { 3075256652, 2762754934, 3846844247 },
        { 3057872364, 3274545167, 2762754934 },
        { 4028573983, 938934351, 3274545167 } },
      // Matrix for nskip = 5 * 8 ^ 44:
      { { 1356476668, 2626409409, 1479462144 },
        { 1188404397, 1260428167, 2626409409 },
        { 3595448064, 2360949430, 1260428167 } },
      // Matrix for nskip = 6 * 8 ^ 44:
      { { 1027674032, 887967109, 3655047107 },
        { 3381172536, 2839247420, 887967109 },
        { 1109942153, 1231881661, 2839247420 } },
      // Matrix for nskip = 7 * 8 ^ 44:
      { { 3084422684, 3716427472, 3899800153 },
        { 2713114448, 2433847057, 3716427472 },
        { 2089286798, 4032596403, 2433847057 } },
      // Matrix for nskip = 1 * 8 ^ 45:
      { { 2597859300, 2880151048, 2523330453 },
        { 1121709186, 175667448, 2880151048 },
        { 4182510911, 1723133625, 175667448 } },
      // Matrix for nskip = 2 * 8 ^ 45:
      { { 484148868, 1404283933, 2982534313 },
        { 3736767353, 3179865161, 1404283933 },
        { 391120388, 3758716888, 3179865161 } },
      // Matrix for nskip = 3 * 8 ^ 45:
      { { 3773686289, 1118146915, 4257811308 },
        { 2626215981, 2155767823, 1118146915 },
        { 4216113535, 234812272, 2155767823 } },
      // Matrix for nskip = 4 * 8 ^ 45:
      { { 2138867468, 1128973399, 2133702321 },
        { 1613561693, 3622350766, 1128973399 },
        { 1500151924, 3759983985, 3622350766 } },
      // Matrix for nskip = 5 * 8 ^ 45:
      { { 2098219600, 3500149955, 509598935 },
        { 3938592198, 2627573355, 3500149955 },
        { 2296762399, 2144538279, 2627573355 } },
      // Matrix for nskip = 6 * 8 ^ 45:
      { { 1272813809, 709982328, 2430723917 },
        { 3808746634, 1052744045, 709982328 },
        { 346250782, 2541155134, 1052744045 } },
      // Matrix for nskip = 7 * 8 ^ 45:
      { { 959495863, 240812937, 1778012651 },
        { 803153186, 1920219267, 240812937 },
        { 2528085623, 422007, 1920219267 } },
      // Matrix for nskip = 1 * 8 ^ 46:
      { { 3027706760, 3786576552, 2698781808 },
        { 2810527099, 90498489, 3786576552 },
        { 4220122612, 1855245979, 90498489 } },
      // Matrix for nskip = 2 * 8 ^ 46:
      { { 3739389517, 1110440720, 917457922 },
        { 2163873618, 3707591763, 1110440720 },
        { 2667061910, 2533383962, 3707591763 } },
      // Matrix for nskip = 3 * 8 ^ 46:
      { { 3440567542, 213023128, 821316937 },
        { 1289665822, 1120982854, 213023128 },
        { 1107018173, 2157902557, 1120982854 } },
      // Matrix for nskip = 4 * 8 ^ 46:
      { { 1545226000, 1812182123, 3693349190 },
        { 3422065122, 3291428549, 1812182123 },
        { 1193168720, 2072837757, 3291428549 } },
      // Matrix for nskip = 5 * 8 ^ 46:
      { { 1411838727, 1497286518, 2743320941 },
        { 1476608684, 3759942398, 1497286518 },
        { 3033567880, 1132137328, 3759942398 } },
      // Matrix for nskip = 6 * 8 ^ 46:
      { { 4164586694, 3847046376, 939466538 },
        { 455920568, 1287777429, 3847046376 },
        { 2394981758, 891603161, 1287777429 } },
      // Matrix for nskip = 7 * 8 ^ 46:
      { { 3992667160, 390631011, 4070853162 },
        { 1146538952, 1264300453, 390631011 },
        { 2489808111, 407533173, 1264300453 } },
      // Matrix for nskip = 1 * 8 ^ 47:
      { { 3230096243, 2131723358, 3262178024 },
        { 2882890127, 4088518247, 2131723358 },
        { 3991553306, 1282224087, 4088518247 } },
      // Matrix for nskip = 2 * 8 ^ 47:
      { { 301207261, 1722796810, 3697719854 },
        { 3350228505, 3410986694, 1722796810 },
        { 3684514720, 2846958957, 3410986694 } },
      // Matrix for nskip = 3 * 8 ^ 47:
      { { 3625524738, 3319692776, 3795749903 },
        { 1715640681, 1890913372, 3319692776 },
        { 225727143, 928307593, 1890913372 } },
      // Matrix for nskip = 4 * 8 ^ 47:
      { { 1532963114, 4236235786, 3871128158 },
        { 3540401964, 1285250577, 4236235786 },
        { 1105070646, 2764245175, 1285250577 } },
      // Matrix for nskip = 5 * 8 ^ 47:
      { { 3740934706, 2563937648, 2746910512 },
        { 3298575982, 2047742419, 2563937648 },
        { 654443081, 2109897740, 2047742419 } },
      // Matrix for nskip = 6 * 8 ^ 47:
      { { 1240524792, 1728254085, 119873755 },
        { 1505600996, 2604901554, 1728254085 },
        { 3134968130, 2798059827, 2604901554 } },
      // Matrix for nskip = 7 * 8 ^ 47:
      { { 1468859634, 1067606885, 482418964 },
        { 2025997689, 632183943, 1067606885 },
        { 152578308, 2630662559, 632183943 } },
      // Matrix for nskip = 1 * 8 ^ 48:
      { { 210906218, 3068599594, 3034582784 },
        { 340633153, 4004365908, 3068599594 },
        { 4238928187, 2299166464, 4004365908 } },
      // Matrix for nskip = 2 * 8 ^ 48:
      { { 2274701639, 3955606166, 3081246407 },
        { 3199954992, 3948054919, 3955606166 },
        { 2399101442, 3438340286, 3948054919 } },
      // Matrix for nskip = 3 * 8 ^ 48:
      { { 1699759143, 4037535932, 1219209632 },
        { 633837171, 3333667032, 4037535932 },
        { 1309772249, 2404397407, 3333667032 } },
      // Matrix for nskip = 4 * 8 ^ 48:
      { { 504137100, 1182303684, 201533985 },
        { 4188299661, 3042453580, 1182303684 },
        { 2578519273, 2674782930, 3042453580 } },
      // Matrix for nskip = 5 * 8 ^ 48:
      { { 592752793, 2717374630, 1743344011 },
        { 1375705778, 3320840707, 2717374630 },
        { 128640966, 3026546742, 3320840707 } },
      // Matrix for nskip = 6 * 8 ^ 48:
      { { 1370637124, 3074764013, 228550476 },
        { 1199760826, 3450980261, 3074764013 },
        { 1618563336, 1054833852, 3450980261 } },
      // Matrix for nskip = 7 * 8 ^ 48:
      { { 1611431067, 3710031515, 2854732050 },
        { 528870942, 2907234375, 3710031515 },
        { 3445439485, 1092238667, 2907234375 } },
      // Matrix for nskip = 1 * 8 ^ 49:
      { { 1382964588, 2578452047, 3140440866 },
        { 261861891, 1076783073, 2578452047 },
        { 1634588989, 164438428, 1076783073 } },
      // Matrix for nskip = 2 * 8 ^ 49:
      { { 2529186343, 526867394, 3102803247 },
        { 2687252475, 2908898908, 526867394 },
        { 1213100579, 86050422, 2908898908 } },
      // Matrix for nskip = 3 * 8 ^ 49:
      { { 1961703304, 2865880716, 3245956893 },
        { 2618763101, 2785604515, 2865880716 },
        { 2898900229, 1099125661, 2785604515 } },
      // Matrix for nskip = 4 * 8 ^ 49:
      { { 2690118316, 538108523, 790337895 },
        { 4193870709, 1053552056, 538108523 },
        { 1635227281, 4002399925, 1053552056 } },
      // Matrix for nskip = 5 * 8 ^ 49:
      { { 746488794, 2143647216, 1919679021 },
        { 3920176380, 1994557046, 2143647216 },
        { 661950432, 921383941, 1994557046 } },
      // Matrix for nskip = 6 * 8 ^ 49:
      { { 1934635577, 2678342194, 4048456688 },
        { 3769235275, 3122368790, 2678342194 },
        { 3794884445, 2578750044, 3122368790 } },
      // Matrix for nskip = 7 * 8 ^ 49:
      { { 2345462407, 3273239577, 504673677 },
        { 2663769112, 483235505, 3273239577 },
        { 2863427199, 2990731351, 483235505 } },
      // Matrix for nskip = 1 * 8 ^ 50:
      { { 2123712957, 4205383007, 1812304090 },
        { 1095349745, 166243972, 4205383007 },
        { 428569070, 2128782357, 166243972 } },
      // Matrix for nskip = 2 * 8 ^ 50:
      { { 1330151766, 3569679412, 4107175982 },
        { 3808641551, 3621125056, 3569679412 },
        { 4262164578, 1927692878, 3621125056 } },
      // Matrix for nskip = 3 * 8 ^ 50:
      { { 4091558631, 3732834681, 466628750 },
        { 297727134, 2456485740, 3732834681 },
        { 1818617085, 834096815, 2456485740 } },
      // Matrix for nskip = 4 * 8 ^ 50:
      { { 3606295184, 2442739556, 3894922338 },
        { 1629626641, 2729678535, 2442739556 },
        { 3379124758, 4279360935, 2729678535 } },
      // Matrix for nskip = 5 * 8 ^ 50:
      { { 3518339108, 1807718360, 3760359041 },
        { 3698267057, 3466970024, 1807718360 },
        { 3728530930, 3457548085, 3466970024 } },
      // Matrix for nskip = 6 * 8 ^ 50:
      { { 2193444679, 408556626, 3012130337 },
        { 1097569863, 59894341, 408556626 },
        { 3860432799, 476070138, 59894341 } },
      // Matrix for nskip = 7 * 8 ^ 50:
      { { 1063004122, 547821813, 3531749039 },
        { 3513263202, 1281130561, 547821813 },
        { 3768689719, 180869393, 1281130561 } },
      // Matrix for nskip = 1 * 8 ^ 51:
      { { 1052092278, 4249024666, 919210106 },
        { 3253349463, 3629539480, 4249024666 },
        { 852514024, 4025926501, 3629539480 } },
      // Matrix for nskip = 2 * 8 ^ 51:
      { { 12394571, 1252747620, 2133571953 },
        { 4227339509, 3197545170, 1252747620 },
        { 1884529704, 1976203831, 3197545170 } },
      // Matrix for nskip = 3 * 8 ^ 51:
      { { 2331594780, 452832640, 1101195955 },
        { 2939334015, 2029416251, 452832640 },
        { 1096100666, 3366782607, 2029416251 } },
      // Matrix for nskip = 4 * 8 ^ 51:
      { { 2986331025, 2671019282, 2847338542 },
        { 3173738401, 3542657885, 2671019282 },
        { 745203060, 1546667401, 3542657885 } },
      // Matrix for nskip = 5 * 8 ^ 51:
      { { 3475245690, 1308019352, 1824121179 },
        { 2721990050, 584665331, 1308019352 },
        { 935407479, 3072929538, 584665331 } },
      // Matrix for nskip = 6 * 8 ^ 51:
      { { 1254243785, 987948282, 836901607 },
        { 2154496016, 3293370693, 987948282 },
        { 2487351160, 2120370930, 3293370693 } },
      // Matrix for nskip = 7 * 8 ^ 51:
      { { 614238014, 976296831, 2444588607 },
        { 3245218993, 99887253, 976296831 },
        { 4012293175, 407199536, 99887253 } },
      // Matrix for nskip = 1 * 8 ^ 52:
      { { 2613012997, 2311336951, 2911336433 },
        { 1493974713, 92565032, 2311336951 },
        { 2786645250, 257065974, 92565032 } },
      // Matrix for nskip = 2 * 8 ^ 52:
      { { 3424925004, 2776053372, 2204068573 },
        { 3770626858, 2509257810, 2776053372 },
        { 2979919489, 1146336783, 2509257810 } },
      // Matrix for nskip = 3 * 8 ^ 52:
      { { 2499905758, 2215361770, 3750482090 },
        { 1105380130, 3511408930, 2215361770 },
        { 634471839, 2666607166, 3511408930 } },
      // Matrix for nskip = 4 * 8 ^ 52:
      { { 1474384834, 827894421, 515339473 },
        { 1373055755, 1949809417, 827894421 },
        { 3088339524, 1194193824, 1949809417 } },
      // Matrix for nskip = 5 * 8 ^ 52:
      { { 811682426, 1464831324, 673124742 },
        { 1737209131, 4147063048, 1464831324 },
        { 104747063, 352467977, 4147063048 } },
      // Matrix for nskip = 6 * 8 ^ 52:
      { { 1759193844, 2367252271, 658497461 },
        { 2079352492, 183217259, 2367252271 },
        { 4048695575, 533708602, 183217259 } },
      // Matrix for nskip = 7 * 8 ^ 52:
      { { 2604083920, 2202319015, 2821035593 },
        { 3199388318, 109366125, 2202319015 },
        { 552179285, 3360277248, 109366125 } },
      // Matrix for nskip = 1 * 8 ^ 53:
      { { 1825805135, 1289872272, 3700877161 },
        { 3433422861, 4062509844, 1289872272 },
        { 3019008744, 2060641859, 4062509844 } },
      // Matrix for nskip = 2 * 8 ^ 53:
      { { 3842597153, 4253338264, 3424495942 },
        { 698444416, 60268595, 4253338264 },
        { 4096010585, 47309624, 60268595 } },
      // Matrix for nskip = 3 * 8 ^ 53:
      { { 496690861, 2839992631, 523849894 },
        { 3748568076, 1725353677, 2839992631 },
        { 1590121940, 1652142356, 1725353677 } },
      // Matrix for nskip = 4 * 8 ^ 53:
      { { 2662288323, 2043518992, 1593435980 },
        { 1330201507, 3618850300, 2043518992 },
        { 2538793204, 271787962, 3618850300 } },
      // Matrix for nskip = 5 * 8 ^ 53:
      { { 3290637626, 1877437091, 683414954 },
        { 297749, 1492496540, 1877437091 },
        { 2568049682, 3340892636, 1492496540 } },
      // Matrix for nskip = 6 * 8 ^ 53:
      { { 1177494705, 170978053, 1258089776 },
        { 175903832, 2352110692, 170978053 },
        { 3367780341, 265547447, 2352110692 } },
      // Matrix for nskip = 7 * 8 ^ 53:
      { { 4000259518, 1585853138, 1894954679 },
        { 4025122327, 1695479283, 1585853138 },
        { 2854628986, 489784443, 1695479283 } },
      // Matrix for nskip = 1 * 8 ^ 54:
      { { 741020448, 997594656, 2398808739 },
        { 1160477043, 1522130854, 997594656 },
        { 3036916315, 2847712653, 1522130854 } },
      // Matrix for nskip = 2 * 8 ^ 54:
      { { 2654964886, 1889728930, 53329096 },
        { 2042322941, 1621136330, 1889728930 },
        { 1553642730, 784545882, 1621136330 } },
      // Matrix for nskip = 3 * 8 ^ 54:
      { { 900526416, 798626824, 3879214027 },
        { 2219774094, 2513781045, 798626824 },
        { 1455564465, 3987302058, 2513781045 } },
      // Matrix for nskip = 4 * 8 ^ 54:
      { { 1715219514, 2831829177, 929124824 },
        { 997274536, 404228189, 2831829177 },
        { 1386575385, 4107238699, 404228189 } },
      // Matrix for nskip = 5 * 8 ^ 54:
      { { 3216180354, 346253769, 2204236686 },
        { 620690291, 2037367915, 346253769 },
        { 1423172488, 2780020913, 2037367915 } },
      // Matrix for nskip = 6 * 8 ^ 54:
      { { 1361559514, 2840866920, 2161766692 },
        { 3777816531, 4291736115, 2840866920 },
        { 1449118903, 455358549, 4291736115 } },
      // Matrix for nskip = 7 * 8 ^ 54:
      { { 3361155093, 1442101330, 2915072798 },
        { 270047328, 973080601, 1442101330 },
        { 2538519465, 2830816977, 973080601 } },
      // Matrix for nskip = 1 * 8 ^ 55:
      { { 3928131551, 2912523524, 1840499723 },
        { 4216003022, 2970489088, 2912523524 },
        { 1158689953, 1425511081, 2970489088 } },
      // Matrix for nskip = 2 * 8 ^ 55:
      { { 2807004452, 2510299562, 271603006 },
        { 2505735035, 2370490899, 2510299562 },
        { 10873814, 2450376936, 2370490899 } },
      // Matrix for nskip = 3 * 8 ^ 55:
      { { 895842640, 1513759891, 652184790 },
        { 337719276, 3793171443, 1513759891 },
        { 661495819, 1882293939, 3793171443 } },
      // Matrix for nskip = 4 * 8 ^ 55:
      { { 2000734342, 1113679064, 2502160539 },
        { 1475266926, 2787925323, 1113679064 },
        { 1475797635, 3044470744, 2787925323 } },
      // Matrix for nskip = 5 * 8 ^ 55:
      { { 1766616799, 722317846, 1586650055 },
        { 1016766460, 76599155, 722317846 },
        { 2574759301, 623201703, 76599155 } },
      // Matrix for nskip = 6 * 8 ^ 55:
      { { 3664739404, 4014926443, 1080154168 },
        { 2495955387, 1724853627, 4014926443 },
        { 536042925, 1256783759, 1724853627 } },
      // Matrix for nskip = 7 * 8 ^ 55:
      { { 4046813655, 3373283605, 3767126799 },
        { 1560329332, 2618021767, 3373283605 },
        { 527165723, 2030169433, 2618021767 } },
      // Matrix for nskip = 1 * 8 ^ 56:
      { { 1457157056, 1252556678, 3073232607 },
        { 1926798761, 3639907189, 1252556678 },
        { 2067740348, 2256217204, 3639907189 } },
      // Matrix for nskip = 2 * 8 ^ 56:
      { { 3740999688, 1035400458, 3162437311 },
        { 4126312242, 686702830, 1035400458 },
        { 1699805291, 667792040, 686702830 } },
      // Matrix for nskip = 3 * 8 ^ 56:
      { { 1345468819, 1338322079, 817781640 },
        { 2710885009, 1935673443, 1338322079 },
        { 877889863, 2304324596, 1935673443 } },
      // Matrix for nskip = 4 * 8 ^ 56:
      { { 2422495016, 3203768688, 1858240466 },
        { 848719394, 4092709154, 3203768688 },
        { 659945473, 1863075174, 4092709154 } },
      // Matrix for nskip = 5 * 8 ^ 56:
      { { 21345609, 2944772441, 1446242483 },
        { 3854092115, 3931174287, 2944772441 },
        { 3818334033, 340393141, 3931174287 } },
      // Matrix for nskip = 6 * 8 ^ 56:
      { { 2472609977, 1572317229, 2146084483 },
        { 386210076, 1579232146, 1572317229 },
        { 3154153453, 3349077947, 1579232146 } },
      // Matrix for nskip = 7 * 8 ^ 56:
      { { 3934658083, 1547798902, 578076866 },
        { 3707114992, 1649964845, 1547798902 },
        { 3740686873, 217906160, 1649964845 } },
      // Matrix for nskip = 1 * 8 ^ 57:
      { { 246817944, 871751352, 2834051003 },
        { 3976202597, 3721214025, 871751352 },
        { 783929942, 745295675, 3721214025 } },
      // Matrix for nskip = 2 * 8 ^ 57:
      { { 3811740424, 3603608092, 2365398362 },
        { 3826150877, 2906557036, 3603608092 },
        { 2300510686, 966815948, 2906557036 } },
      // Matrix for nskip = 3 * 8 ^ 57:
      { { 2004086842, 752045049, 1443259442 },
        { 4222485982, 2275171478, 752045049 },
        { 959250674, 2731257760, 2275171478 } },
      // Matrix for nskip = 4 * 8 ^ 57:
      { { 2816329160, 18201123, 3367710570 },
        { 437309679, 2220769388, 18201123 },
        { 1346863388, 705296543, 2220769388 } },
      // Matrix for nskip = 5 * 8 ^ 57:
      { { 3868848671, 3006483395, 3903615747 },
        { 1680524656, 2885742075, 3006483395 },
        { 796648897, 2121364560, 2885742075 } },
      // Matrix for nskip = 6 * 8 ^ 57:
      { { 2743985808, 1183199523, 686976485 },
        { 3080242732, 497836434, 1183199523 },
        { 2146196184, 523073130, 497836434 } },
      // Matrix for nskip = 7 * 8 ^ 57:
      { { 281969912, 3168583843, 3387530534 },
        { 3604375441, 89658761, 3168583843 },
        { 3122537866, 3405552447, 89658761 } },
      // Matrix for nskip = 1 * 8 ^ 58:
      { { 3310028953, 1662315499, 132645114 },
        { 2572908401, 3105849797, 1662315499 },
        { 1937586849, 1735620028, 3105849797 } },
      // Matrix for nskip = 2 * 8 ^ 58:
      { { 461386353, 1359675853, 3599822966 },
        { 106675209, 2044154050, 1359675853 },
        { 1787730088, 1149892630, 2044154050 } },
      // Matrix for nskip = 3 * 8 ^ 58:
      { { 1678397435, 2034254929, 404593054 },
        { 308885052, 4143854702, 2034254929 },
        { 1276625905, 1557265403, 4143854702 } },
      // Matrix for nskip = 4 * 8 ^ 58:
      { { 3303902397, 345146034, 1417149696 },
        { 2231869247, 1116882637, 345146034 },
        { 1846832385, 79626976, 1116882637 } },
      // Matrix for nskip = 5 * 8 ^ 58:
      { { 3163825854, 3437355918, 3790302358 },
        { 2966738005, 405418248, 3437355918 },
        { 2935909124, 1737823953, 405418248 } },
      // Matrix for nskip = 6 * 8 ^ 58:
      { { 4188280456, 4245794318, 2115856958 },
        { 3899866941, 2230248511, 4245794318 },
        { 4151131385, 1810874924, 2230248511 } },
      // Matrix for nskip = 7 * 8 ^ 58:
      { { 3183442289, 2647800101, 3155584995 },
        { 1803347712, 3081729031, 2647800101 },
        { 344634507, 408464888, 3081729031 } },
      // Matrix for nskip = 1 * 8 ^ 59:
      { { 2765049417, 3117782790, 1805260159 },
        { 3796182890, 1101141726, 3117782790 },
        { 224270120, 1004001443, 1101141726 } },
      // Matrix for nskip = 2 * 8 ^ 59:
      { { 89118668, 2494198515, 1356989069 },
        { 2490435731, 997151755, 2494198515 },
        { 1175528637, 3444341166, 997151755 } },
      // Matrix for nskip = 3 * 8 ^ 59:
      { { 2610383359, 3160454394, 1595264559 },
        { 613651010, 1733540130, 3160454394 },
        { 1119988193, 1810350755, 1733540130 } },
      // Matrix for nskip = 4 * 8 ^ 59:
      { { 2340639019, 510225634, 286119182 },
        { 2045217287, 1194574818, 510225634 },
        { 2662281592, 1728500627, 1194574818 } },
      // Matrix for nskip = 5 * 8 ^ 59:
      { { 1447842232, 184782823, 1797257364 },
        { 2190899193, 2854828033, 184782823 },
        { 4138436503, 3783089951, 2854828033 } },
      // Matrix for nskip = 6 * 8 ^ 59:
      { { 3892495210, 2262141136, 1078367555 },
        { 3549231332, 2559113701, 2262141136 },
        { 4146978688, 2236162592, 2559113701 } },
      // Matrix for nskip = 7 * 8 ^ 59:
      { { 1510077366, 825286037, 2959985729 },
        { 830287146, 781759955, 825286037 },
        { 359509185, 3182735706, 781759955 } },
      // Matrix for nskip = 1 * 8 ^ 60:
      { { 210787847, 1189120688, 2848040407 },
        { 1087786165, 2343328484, 1189120688 },
        { 3465141330, 2893041005, 2343328484 } },
      // Matrix for nskip = 2 * 8 ^ 60:
      { { 3438170226, 3236285682, 962036916 },
        { 2873263091, 215280489, 3236285682 },
        { 730413847, 1474823842, 215280489 } },
      // Matrix for nskip = 3 * 8 ^ 60:
      { { 1877599976, 489218847, 1841260926 },
        { 1267710679, 4177426677, 489218847 },
        { 3908192573, 1193948814, 4177426677 } },
      // Matrix for nskip = 4 * 8 ^ 60:
      { { 1566461658, 133010024, 2886695328 },
        { 2835827516, 653809404, 133010024 },
        { 3082882924, 3710942807, 653809404 } },
      // Matrix for nskip = 5 * 8 ^ 60:
      { { 1018639212, 4003411060, 3748771156 },
        { 933110981, 1484000297, 4003411060 },
        { 3415991698, 3188783681, 1484000297 } },
      // Matrix for nskip = 6 * 8 ^ 60:
      { { 2630823869, 3185784250, 1624263326 },
        { 1151112872, 440283001, 3185784250 },
        { 4029103059, 1089550911, 440283001 } },
      // Matrix for nskip = 7 * 8 ^ 60:
      { { 2558003006, 4161490031, 868072046 },
        { 2993166332, 1972186265, 4161490031 },
        { 1890899803, 3731240792, 1972186265 } },
      // Matrix for nskip = 1 * 8 ^ 61:
      { { 4201558916, 1263786956, 326001602 },
        { 762846463, 621546357, 1263786956 },
        { 2697142404, 1156650856, 621546357 } },
      // Matrix for nskip = 2 * 8 ^ 61:
      { { 2655768102, 2339029465, 2430211448 },
        { 2669906627, 403962847, 2339029465 },
        { 1483118807, 639660658, 403962847 } },
      // Matrix for nskip = 3 * 8 ^ 61:
      { { 343789192, 2523152864, 3692813188 },
        { 4182218791, 1387544806, 2523152864 },
        { 3364170107, 1607749365, 1387544806 } },
      // Matrix for nskip = 4 * 8 ^ 61:
      { { 3508595200, 4228486662, 754946994 },
        { 1913148390, 3500531602, 4228486662 },
        { 24637, 3773159052, 3500531602 } },
      // Matrix for nskip = 5 * 8 ^ 61:
      { { 1767736432, 2782451483, 925961005 },
        { 1898573829, 779641045, 2782451483 },
        { 4172425777, 3053709304, 779641045 } },
      // Matrix for nskip = 6 * 8 ^ 61:
      { { 917982480, 676540794, 3402535509 },
        { 1997794025, 3184854268, 676540794 },
        { 2501974390, 2557204628, 3184854268 } },
      // Matrix for nskip = 7 * 8 ^ 61:
      { { 2265059434, 3533015776, 2085907395 },
        { 1105268907, 2837239505, 3533015776 },
        { 3031242459, 1173739788, 2837239505 } },
      // Matrix for nskip = 1 * 8 ^ 62:
      { { 4024866227, 1143874914, 3205058469 },
        { 2970344133, 2873927273, 1143874914 },
        { 2167114735, 4095476435, 2873927273 } },
      // Matrix for nskip = 2 * 8 ^ 62:
      { { 1479401095, 2958366486, 3027708794 },
        { 2704486034, 3574053987, 2958366486 },
        { 3630964515, 1276667706, 3574053987 } },
      // Matrix for nskip = 3 * 8 ^ 62:
      { { 3471121, 4212261536, 2870367456 },
        { 3210276198, 3855580426, 4212261536 },
        { 2974755971, 3723431054, 3855580426 } },
      // Matrix for nskip = 4 * 8 ^ 62:
      { { 2035927380, 1363628533, 818363998 },
        { 3023327955, 3968427114, 1363628533 },
        { 1284825950, 2871663372, 3968427114 } },
      // Matrix for nskip = 5 * 8 ^ 62:
      { { 4289867114, 1817891047, 2823353497 },
        { 910331225, 3868760780, 1817891047 },
        { 2783151834, 2379034525, 3868760780 } },
      // Matrix for nskip = 6 * 8 ^ 62:
      { { 2979837612, 1089982006, 1663630835 },
        { 709699817, 1486004709, 1089982006 },
        { 1956455708, 1787357723, 1486004709 } },
      // Matrix for nskip = 7 * 8 ^ 62:
      { { 2852981955, 2215534550, 574323950 },
        { 1169533157, 2975065186, 2215534550 },
        { 2290801870, 428188634, 2975065186 } },
      // Matrix for nskip = 1 * 8 ^ 63:
      { { 3827747418, 3897287251, 4106993377 },
        { 1527779946, 3221052941, 3897287251 },
        { 4178727866, 4281160673, 3221052941 } },
      // Matrix for nskip = 2 * 8 ^ 63:
      { { 1174358892, 2835476193, 959978619 },
        { 850076464, 3774782533, 2835476193 },
        { 3880910680, 3237990203, 3774782533 } },
      // Matrix for nskip = 3 * 8 ^ 63:
      { { 1400690756, 823435890, 1896847210 },
        { 3000499818, 1124911735, 823435890 },
        { 1381972838, 2683742666, 1124911735 } },
      // Matrix for nskip = 4 * 8 ^ 63:
      { { 3128011728, 1998893251, 1400155768 },
        { 1430713735, 2850730926, 1998893251 },
        { 1073801764, 2374744218, 2850730926 } },
      // Matrix for nskip = 5 * 8 ^ 63:
      { { 1152423219, 3000721466, 850809698 },
        { 764299143, 3684505492, 3000721466 },
        { 3524599640, 1299858048, 3684505492 } },
      // Matrix for nskip = 6 * 8 ^ 63:
      { { 2188428625, 3090564778, 4205068615 },
        { 1911908313, 34180751, 3090564778 },
        { 3382776937, 194682771, 34180751 } },
      // Matrix for nskip = 7 * 8 ^ 63:
      { { 3050396426, 627769205, 3010308075 },
        { 987718671, 3026731980, 627769205 },
        { 3527778260, 4200640347, 3026731980 } },
      // Matrix for nskip = 1 * 8 ^ 64:
      { { 364496809, 3951443831, 2338985995 },
        { 2365728271, 1745134545, 3951443831 },
        { 1076500940, 1589192585, 1745134545 } },
      // Matrix for nskip = 2 * 8 ^ 64:
      { { 3304498837, 1325046906, 3381970501 },
        { 1563368115, 3116266625, 1325046906 },
        { 244825785, 4251678855, 3116266625 } },
      // Matrix for nskip = 3 * 8 ^ 64:
      { { 4133678667, 2048440215, 4035662430 },
        { 4086919994, 519191900, 2048440215 },
        { 2789936683, 4051608893, 519191900 } },
      // Matrix for nskip = 4 * 8 ^ 64:
      { { 3603289991, 1324164821, 1776019579 },
        { 1734804890, 3151589272, 1324164821 },
        { 2411297223, 3296772386, 3151589272 } },
      // Matrix for nskip = 5 * 8 ^ 64:
      { { 2599419541, 2726072264, 662164094 },
        { 1554537872, 2065618870, 2726072264 },
        { 1049180268, 439080215, 2065618870 } },
      // Matrix for nskip = 6 * 8 ^ 64:
      { { 1694996757, 2289284793, 2258832764 },
        { 1982364129, 3971544391, 2289284793 },
        { 1140613093, 2605325759, 3971544391 } },
      // Matrix for nskip = 7 * 8 ^ 64:
      { { 3344108032, 1353133572, 2611828466 },
        { 729814057, 219879593, 1353133572 },
        { 1513768211, 1797897504, 219879593 } } },
    // Matrix for nskip = 1 * 8 ^ 0:
    { { { 0, 1, 0 }, { 0, 0, 1 }, { 4293573854, 0, 527612 } },
      // Matrix for nskip = 2 * 8 ^ 0:
      { { 0, 0, 1 }, { 4293573854, 0, 527612 }, { 2706407399, 4293573854, 3497978192 } },
      // Matrix for nskip = 3 * 8 ^ 0:
      { { 4293573854, 0, 527612 },
        { 2706407399, 4293573854, 3497978192 },
        { 1431525864, 2706407399, 3281754271 } },
      // Matrix for nskip = 4 * 8 ^ 0:
      { { 2706407399, 4293573854, 3497978192 },
        { 1431525864, 2706407399, 3281754271 },
        { 97673890, 1431525864, 1673476130 } },
      // Matrix for nskip = 5 * 8 ^ 0:
      { { 1431525864, 2706407399, 3281754271 },
        { 97673890, 1431525864, 1673476130 },
        { 2680076935, 97673890, 1430724370 } },
      // Matrix for nskip = 6 * 8 ^ 0:
      { { 97673890, 1431525864, 1673476130 },
        { 2680076935, 97673890, 1430724370 },
        { 3405842137, 2680076935, 893509979 } },
      // Matrix for nskip = 7 * 8 ^ 0:
      { { 2680076935, 97673890, 1430724370 },
        { 3405842137, 2680076935, 893509979 },
        { 4035147174, 3405842137, 3280220074 } },
      // Matrix for nskip = 1 * 8 ^ 1:
      { { 3405842137, 2680076935, 893509979 },
        { 4035147174, 3405842137, 3280220074 },
        { 2623373296, 4035147174, 361718588 } },
      // Matrix for nskip = 2 * 8 ^ 1:
      { { 818368950, 3790774567, 3542344109 },
        { 1817134745, 818368950, 3321940838 },
        { 3493477402, 1817134745, 2854655037 } },
      // Matrix for nskip = 3 * 8 ^ 1:
      { { 508190223, 940389731, 295549677 },
        { 548891792, 508190223, 4243623497 },
        { 1618914183, 548891792, 2585942386 } },
      // Matrix for nskip = 4 * 8 ^ 1:
      { { 498682467, 2928649385, 811441367 },
        { 1777037472, 498682467, 479207863 },
        { 3058260025, 1777037472, 1528225099 } },
      // Matrix for nskip = 5 * 8 ^ 1:
      { { 1605006689, 1112484358, 2137070446 },
        { 3785946674, 1605006689, 1949907406 },
        { 3243030173, 3785946674, 2339202713 } },
      // Matrix for nskip = 6 * 8 ^ 1:
      { { 1603012465, 493710616, 1996495269 },
        { 3369502947, 1603012465, 1576432507 },
        { 3762770058, 3369502947, 254897698 } },
      // Matrix for nskip = 7 * 8 ^ 1:
      { { 1138020476, 4025114134, 3077305804 },
        { 4152260747, 1138020476, 1057298006 },
        { 1828211552, 4152260747, 3984471979 } },
      // Matrix for nskip = 1 * 8 ^ 2:
      { { 3893311647, 3140922085, 64039185 },
        { 82107183, 3893311647, 2655465224 },
        { 1674879036, 82107183, 1089381262 } },
      // Matrix for nskip = 2 * 8 ^ 2:
      { { 28639152, 3496041927, 2231910770 },
        { 3174683233, 28639152, 2828785870 },
        { 3681140872, 3174683233, 3910194649 } },
      // Matrix for nskip = 3 * 8 ^ 2:
      { { 3488684910, 1250231333, 763303055 },
        { 681409874, 3488684910, 751154769 },
        { 3783909260, 681409874, 1465244270 } },
      // Matrix for nskip = 4 * 8 ^ 2:
      { { 1463826069, 300842059, 3313769518 },
        { 1799677538, 1463826069, 3174861078 },
        { 1882279394, 1799677538, 3509975160 } },
      // Matrix for nskip = 5 * 8 ^ 2:
      { { 2793448161, 3690337147, 4181759810 },
        { 514622120, 2793448161, 3027286223 },
        { 241620347, 514622120, 1328063696 } },
      // Matrix for nskip = 6 * 8 ^ 2:
      { { 3250099852, 3207068910, 3709263791 },
        { 2342747328, 3250099852, 3729690850 },
        { 3983203494, 2342747328, 1023622970 } },
      // Matrix for nskip = 7 * 8 ^ 2:
      { { 3136295372, 3178055245, 2818424094 },
        { 2036073935, 3136295372, 3231583326 },
        { 1782478065, 2036073935, 1053332972 } },
      // Matrix for nskip = 1 * 8 ^ 3:
      { { 2092194020, 184076987, 2202401252 },
        { 3103629604, 2092194020, 3409560232 },
        { 4257445059, 3103629604, 2390202783 } },
      // Matrix for nskip = 2 * 8 ^ 3:
      { { 812917091, 2574011276, 4168802395 },
        { 209817750, 812917091, 2974870628 },
        { 3238802184, 209817750, 3692836406 } },
      // Matrix for nskip = 3 * 8 ^ 3:
      { { 1621943577, 2244624888, 38864005 },
        { 3618177584, 1621943577, 3295260066 },
        { 414159965, 3618177584, 1095692911 } },
      // Matrix for nskip = 4 * 8 ^ 3:
      { { 477309738, 3314523413, 3442242150 },
        { 2755731404, 477309738, 2782713347 },
        { 1606221490, 2755731404, 1033463096 } },
      // Matrix for nskip = 5 * 8 ^ 3:
      { { 3233499061, 2494617440, 1002517819 },
        { 3026123612, 3233499061, 3338202446 },
        { 1979145017, 3026123612, 3790308130 } },
      // Matrix for nskip = 6 * 8 ^ 3:
      { { 2567113113, 781663248, 3993869449 },
        { 402756912, 2567113113, 2817097718 },
        { 3190930010, 402756912, 2884691291 } },
      // Matrix for nskip = 7 * 8 ^ 3:
      { { 2223683788, 4195752245, 2738363134 },
        { 1171605168, 2223683788, 3904649711 },
        { 2631005941, 1171605168, 3445807882 } },
      // Matrix for nskip = 1 * 8 ^ 4:
      { { 2155469603, 3326516116, 3843369786 },
        { 288604458, 2155469603, 571673571 },
        { 1501677614, 288604458, 2928213494 } },
      // Matrix for nskip = 2 * 8 ^ 4:
      { { 2082469029, 749754403, 3963963316 },
        { 2764859700, 2082469029, 3576428059 },
        { 2840894706, 2764859700, 1782279859 } },
      // Matrix for nskip = 3 * 8 ^ 4:
      { { 1583407457, 2056027805, 55614242 },
        { 2405645826, 1583407457, 1737043333 },
        { 1118910623, 2405645826, 1180559812 } },
      // Matrix for nskip = 4 * 8 ^ 4:
      { { 3760163766, 1041986082, 1799196192 },
        { 1022129134, 3760163766, 1332558840 },
        { 276873446, 1022129134, 3979423632 } },
      // Matrix for nskip = 5 * 8 ^ 4:
      { { 1438626566, 3619082489, 1569836243 },
        { 3671597039, 1438626566, 907924984 },
        { 3732297029, 3671597039, 1221779212 } },
      // Matrix for nskip = 6 * 8 ^ 4:
      { { 483787924, 3115606677, 2374703971 },
        { 117552025, 483787924, 4234241969 },
        { 774331833, 117552025, 530787287 } },
      // Matrix for nskip = 7 * 8 ^ 4:
      { { 955925224, 1961750426, 3644821859 },
        { 213414981, 955925224, 927956770 },
        { 1671634731, 213414981, 4186423122 } },
      // Matrix for nskip = 1 * 8 ^ 5:
      { { 1021313167, 1312544548, 1716381787 },
        { 3037868518, 1021313167, 199085085 },
        { 2582787611, 3037868518, 3539882179 } },
      // Matrix for nskip = 2 * 8 ^ 5:
      { { 2569413030, 1631336015, 2594942403 },
        { 1030618503, 2569413030, 3467650326 },
        { 1998739584, 1030618503, 3174552073 } },
      // Matrix for nskip = 3 * 8 ^ 5:
      { { 2179955734, 1825159949, 1082151624 },
        { 937147983, 2179955734, 978382746 },
        { 2629591623, 937147983, 3579678559 } },
      // Matrix for nskip = 4 * 8 ^ 5:
      { { 2334639309, 3114094203, 601680947 },
        { 2110199318, 2334639309, 678342865 },
        { 1649523168, 2110199318, 2154948056 } },
      // Matrix for nskip = 5 * 8 ^ 5:
      { { 2715012491, 247412130, 1566452082 },
        { 3425439428, 2715012491, 3004133824 },
        { 1615468474, 3425439428, 588082730 } },
      // Matrix for nskip = 6 * 8 ^ 5:
      { { 2654502125, 654123598, 3954383978 },
        { 2454987531, 2654502125, 161781366 },
        { 3631058630, 2454987531, 2718719935 } },
      // Matrix for nskip = 7 * 8 ^ 5:
      { { 2620087047, 1022484731, 3275546712 },
        { 4119759001, 2620087047, 1849544363 },
        { 1245152096, 4119759001, 2978477502 } },
      // Matrix for nskip = 1 * 8 ^ 6:
      { { 563657176, 191330473, 1641595774 },
        { 780563537, 563657176, 3029522338 },
        { 2037330914, 780563537, 2084602709 } },
      // Matrix for nskip = 2 * 8 ^ 6:
      { { 3414769923, 1968799026, 2238126504 },
        { 832866376, 3414769923, 3754780168 },
        { 2165145850, 832866376, 1594768331 } },
      // Matrix for nskip = 3 * 8 ^ 6:
      { { 1457310151, 2262086849, 2480319255 },
        { 1778576621, 1457310151, 367796024 },
        { 444536774, 1778576621, 873301213 } },
      // Matrix for nskip = 4 * 8 ^ 6:
      { { 1646861218, 2317984620, 2301581548 },
        { 2672536210, 1646861218, 359763062 },
        { 2391283983, 2672536210, 1885870777 } },
      // Matrix for nskip = 5 * 8 ^ 6:
      { { 2962497351, 1089931025, 970191811 },
        { 2050228336, 2962497351, 1568166288 },
        { 3288162415, 2050228336, 3921597644 } },
      // Matrix for nskip = 6 * 8 ^ 6:
      { { 2468196470, 3544275509, 3557597196 },
        { 3893425026, 2468196470, 2061293842 },
        { 2019325804, 3893425026, 2905314 } },
      // Matrix for nskip = 7 * 8 ^ 6:
      { { 3407411651, 4206194937, 989129012 },
        { 1280115996, 3407411651, 1843205351 },
        { 752661975, 1280115996, 693779416 } },
      // Matrix for nskip = 1 * 8 ^ 7:
      { { 841254072, 3765813448, 1635365181 },
        { 2013240130, 841254072, 605925849 },
        { 3743932305, 2013240130, 400681955 } },
      // Matrix for nskip = 2 * 8 ^ 7:
      { { 1930213004, 2072952279, 3077694794 },
        { 3579956569, 1930213004, 2478539210 },
        { 1960229502, 3579956569, 1455652656 } },
      // Matrix for nskip = 3 * 8 ^ 7:
      { { 490241598, 1155806426, 2341304300 },
        { 1821354750, 490241598, 2364275695 },
        { 3717764728, 1821354750, 1349151461 } },
      // Matrix for nskip = 4 * 8 ^ 7:
      { { 1097613522, 1784540933, 1194440107 },
        { 321747515, 1097613522, 1225209584 },
        { 74521379, 321747515, 4288531000 } },
      // Matrix for nskip = 5 * 8 ^ 7:
      { { 3795899570, 3294470896, 2568537852 },
        { 1615892324, 3795899570, 2277651644 },
        { 245018475, 1615892324, 3269831184 } },
      // Matrix for nskip = 6 * 8 ^ 7:
      { { 2284610128, 1711688841, 2988405862 },
        { 1861018675, 2284610128, 3450880655 },
        { 4077631310, 1861018675, 2595646099 } },
      // Matrix for nskip = 7 * 8 ^ 7:
      { { 1338063869, 4236188627, 4005334159 },
        { 2199059659, 1338063869, 3613475430 },
        { 954928333, 2199059659, 1383222658 } },
      // Matrix for nskip = 1 * 8 ^ 8:
      { { 143812745, 3254530816, 3514348856 },
        { 769295000, 143812745, 2468210728 },
        { 1927161272, 769295000, 522705580 } },
      // Matrix for nskip = 2 * 8 ^ 8:
      { { 2692035063, 2596905012, 1643240704 },
        { 1103432342, 2692035063, 1446182108 },
        { 4161111774, 1103432342, 3076435551 } },
      // Matrix for nskip = 3 * 8 ^ 8:
      { { 1809137988, 2412502608, 3993875038 },
        { 1332423877, 1809137988, 3101816103 },
        { 1366553339, 1332423877, 2986424418 } },
      // Matrix for nskip = 4 * 8 ^ 8:
      { { 2375319030, 1391532370, 3742334018 },
        { 1202100604, 2375319030, 4098434768 },
        { 2327872488, 1202100604, 1471526950 } },
      // Matrix for nskip = 5 * 8 ^ 8:
      { { 953526753, 3517620599, 1558514368 },
        { 3674658855, 953526753, 1517070807 },
        { 828283166, 3674658855, 2689974385 } },
      // Matrix for nskip = 6 * 8 ^ 8:
      { { 3063334100, 3228801559, 269715831 },
        { 612058994, 3063334100, 4143597212 },
        { 1918225488, 612058994, 2055175984 } },
      // Matrix for nskip = 7 * 8 ^ 8:
      { { 2623568215, 482061697, 191091208 },
        { 2499397071, 2623568215, 2970642011 },
        { 759749547, 2499397071, 3510580843 } },
      // Matrix for nskip = 1 * 8 ^ 9:
      { { 4269164791, 2795313144, 2507855960 },
        { 4245372460, 4269164791, 4094914553 },
        { 3873219634, 4245372460, 1473695507 } },
      // Matrix for nskip = 2 * 8 ^ 9:
      { { 513890845, 1208902926, 2870530442 },
        { 1984873167, 513890845, 1257532340 },
        { 1212627640, 1984873167, 2354363842 } },
      // Matrix for nskip = 3 * 8 ^ 9:
      { { 3386048256, 4196280201, 3121820178 },
        { 2926727276, 3386048256, 2790144637 },
        { 3970110476, 2926727276, 3495704635 } },
      // Matrix for nskip = 4 * 8 ^ 9:
      { { 1848364568, 1552116673, 3496528455 },
        { 4160778291, 1848364568, 141769900 },
        { 3611019106, 4160778291, 596424080 } },
      // Matrix for nskip = 5 * 8 ^ 9:
      { { 4194097650, 3986230829, 3091752508 },
        { 3352554321, 4194097650, 4041363667 },
        { 3822925061, 3352554321, 3748054631 } },
      // Matrix for nskip = 6 * 8 ^ 9:
      { { 1292986218, 172755364, 997232463 },
        { 1505642955, 1292986218, 4112978448 },
        { 1757204931, 1505642955, 3038511100 } },
      // Matrix for nskip = 7 * 8 ^ 9:
      { { 3805104355, 3540279669, 2118304338 },
        { 1984875159, 3805104355, 3000869736 },
        { 6466700, 1984875159, 1778898381 } },
      // Matrix for nskip = 1 * 8 ^ 10:
      { { 364070020, 3520039729, 837362349 },
        { 2544671570, 364070020, 2188646679 },
        { 163978331, 2544671570, 672947816 } },
      // Matrix for nskip = 2 * 8 ^ 10:
      { { 1192700714, 3968150021, 298357363 },
        { 635565666, 1192700714, 2589432341 },
        { 2548654227, 635565666, 3531570992 } },
      // Matrix for nskip = 3 * 8 ^ 10:
      { { 3438963520, 1845346034, 2575726025 },
        { 2187600669, 3438963520, 958916489 },
        { 2672427080, 2187600669, 3420061274 } },
      // Matrix for nskip = 4 * 8 ^ 10:
      { { 2709640529, 676525399, 875361870 },
        { 1315499519, 2709640529, 3842690720 },
        { 3300994644, 1315499519, 2446760804 } },
      // Matrix for nskip = 5 * 8 ^ 10:
      { { 1292317767, 393678487, 143711415 },
        { 1162526988, 1292317767, 1311572745 },
        { 344898630, 1162526988, 1362796547 } },
      // Matrix for nskip = 6 * 8 ^ 10:
      { { 2857812374, 598000082, 2114605560 },
        { 3454872661, 2857812374, 2738653578 },
        { 2522086851, 3454872661, 1190449620 } },
      // Matrix for nskip = 7 * 8 ^ 10:
      { { 2614530149, 753841941, 146778273 },
        { 2511297323, 2614530149, 588764284 },
        { 1785429779, 2511297323, 1269211096 } },
      // Matrix for nskip = 1 * 8 ^ 11:
      { { 2742149264, 1410604392, 3032350755 },
        { 3774935330, 2742149264, 597633965 },
        { 4085935803, 3774935330, 3952463556 } },
      // Matrix for nskip = 2 * 8 ^ 11:
      { { 3878579563, 845297523, 1721916511 },
        { 2077922420, 3878579563, 3651360351 },
        { 2177255734, 2077922420, 3791239282 } },
      // Matrix for nskip = 3 * 8 ^ 11:
      { { 2642777370, 1064863813, 4046131253 },
        { 2032494710, 2642777370, 3511906271 },
        { 2787706468, 2032494710, 1602633162 } },
      // Matrix for nskip = 4 * 8 ^ 11:
      { { 1570315355, 4252790045, 3522351060 },
        { 2324624266, 1570315355, 3594939336 },
        { 1725087354, 2324624266, 1338343327 } },
      // Matrix for nskip = 5 * 8 ^ 11:
      { { 3128806513, 3431512800, 3791370211 },
        { 26016991, 3128806513, 1182007239 },
        { 2629261386, 26016991, 1219288409 } },
      // Matrix for nskip = 6 * 8 ^ 11:
      { { 2323129699, 2040722667, 4032945011 },
        { 1824515104, 2323129699, 783304238 },
        { 1910382756, 1824515104, 2009721680 } },
      // Matrix for nskip = 7 * 8 ^ 11:
      { { 495056704, 1303223717, 299029371 },
        { 3001848199, 495056704, 2298546607 },
        { 528121192, 3001848199, 3574765936 } },
      // Matrix for nskip = 1 * 8 ^ 12:
      { { 2305761589, 381933244, 3663579047 },
        { 1355307047, 2305761589, 313617972 },
        { 992174375, 1355307047, 3881593435 } },
      // Matrix for nskip = 2 * 8 ^ 12:
      { { 1667857811, 1564715297, 2263851601 },
        { 3791771273, 1667857811, 4196134923 },
        { 3347975047, 3791771273, 615040705 } },
      // Matrix for nskip = 3 * 8 ^ 12:
      { { 2699274746, 2208033721, 3314336764 },
        { 1723493827, 2699274746, 3721738282 },
        { 3116429712, 1723493827, 763211059 } },
      // Matrix for nskip = 4 * 8 ^ 12:
      { { 4093947334, 3454015638, 2815567716 },
        { 4261953004, 4093947334, 3973733876 },
        { 2979573134, 4261953004, 3757047667 } },
      // Matrix for nskip = 5 * 8 ^ 12:
      { { 1497333242, 3837209858, 4043986454 },
        { 3928412309, 1497333242, 4232950837 },
        { 868538065, 3928412309, 3223762258 } },
      // Matrix for nskip = 6 * 8 ^ 12:
      { { 4178728130, 2981026540, 3927272953 },
        { 668310420, 4178728130, 551557198 },
        { 3532851694, 668310420, 4119399398 } },
      // Matrix for nskip = 7 * 8 ^ 12:
      { { 4121879899, 2179415297, 3607008098 },
        { 243696529, 4121879899, 168490644 },
        { 3444486351, 243696529, 752516370 } },
      // Matrix for nskip = 1 * 8 ^ 13:
      { { 250120061, 570149551, 1513430926 },
        { 3178644752, 250120061, 1701869032 },
        { 4172515680, 3178644752, 4213855850 } },
      // Matrix for nskip = 2 * 8 ^ 13:
      { { 4158106802, 3062358456, 1815738463 },
        { 1379176112, 4158106802, 3926509890 },
        { 2842564878, 1379176112, 2852219546 } },
      // Matrix for nskip = 3 * 8 ^ 13:
      { { 4056930326, 2130453857, 3298513997 },
        { 3059400883, 4056930326, 439468763 },
        { 546163799, 3059400883, 1884270041 } },
      // Matrix for nskip = 4 * 8 ^ 13:
      { { 931848746, 256263523, 2633569246 },
        { 3284646837, 931848746, 2567084715 },
        { 415258465, 3284646837, 2017565947 } },
      // Matrix for nskip = 5 * 8 ^ 13:
      { { 239941751, 4065438988, 4260302551 },
        { 3480241466, 239941751, 1576122049 },
        { 4073589963, 3480241466, 2593293965 } },
      // Matrix for nskip = 6 * 8 ^ 13:
      { { 507915211, 625612469, 3733827320 },
        { 3909587424, 507915211, 3313512626 },
        { 1707582600, 3909587424, 985910059 } },
      // Matrix for nskip = 7 * 8 ^ 13:
      { { 3287778427, 3984689764, 3572719740 },
        { 207904085, 3287778427, 1330617931 },
        { 1894788630, 207904085, 1656936419 } },
      // Matrix for nskip = 1 * 8 ^ 14:
      { { 1648005210, 1032291296, 3987397422 },
        { 1831496020, 1648005210, 2829448427 },
        { 1821082272, 1831496020, 2917140265 } },
      // Matrix for nskip = 2 * 8 ^ 14:
      { { 4161327077, 489964129, 3870847744 },
        { 1669447863, 4161327077, 4292947198 },
        { 1522417114, 1669447863, 2652286672 } },
      // Matrix for nskip = 3 * 8 ^ 14:
      { { 655280634, 3675619486, 3487203083 },
        { 3658400031, 655280634, 4093432727 },
        { 3338913609, 3658400031, 2005464907 } },
      // Matrix for nskip = 4 * 8 ^ 14:
      { { 1270934555, 3136631324, 505612043 },
        { 2981474723, 1270934555, 2528619024 },
        { 625182639, 2981474723, 1008985039 } },
      // Matrix for nskip = 5 * 8 ^ 14:
      { { 2670739471, 1317142118, 928068368 },
        { 3334643457, 2670739471, 3298861790 },
        { 3116973979, 3334643457, 4091848087 } },
      // Matrix for nskip = 6 * 8 ^ 14:
      { { 87174298, 3714928458, 3674535785 },
        { 3591445536, 87174298, 3557842564 },
        { 2600409828, 3591445536, 3509905000 } },
      // Matrix for nskip = 7 * 8 ^ 14:
      { { 1374849292, 3669747751, 313867341 },
        { 2805321474, 1374849292, 3672378692 },
        { 862662086, 2805321474, 1269888877 } },
      // Matrix for nskip = 1 * 8 ^ 15:
      { { 280996820, 143706137, 3013099060 },
        { 1797675893, 280996820, 3743985508 },
        { 1123794455, 1797675893, 2460119169 } },
      // Matrix for nskip = 2 * 8 ^ 15:
      { { 919218027, 4154920441, 1125672685 },
        { 3933041881, 919218027, 474242849 },
        { 564891116, 3933041881, 2263904321 } },
      // Matrix for nskip = 3 * 8 ^ 15:
      { { 4046953169, 707039159, 59087677 },
        { 552285455, 4046953169, 3367709189 },
        { 1558638678, 552285455, 3541844079 } },
      // Matrix for nskip = 4 * 8 ^ 15:
      { { 2920112852, 1965329198, 1177141043 },
        { 2135250851, 2920112852, 969184056 },
        { 296035385, 2135250851, 4267827987 } },
      // Matrix for nskip = 5 * 8 ^ 15:
      { { 3182682829, 216191227, 2317042610 },
        { 3166912454, 3182682829, 3895260799 },
        { 3316963881, 3166912454, 2773111558 } },
      // Matrix for nskip = 6 * 8 ^ 15:
      { { 4005961945, 962333604, 1596766252 },
        { 155090437, 4005961945, 3465811606 },
        { 995757623, 155090437, 842864023 } },
      // Matrix for nskip = 7 * 8 ^ 15:
      { { 3616509225, 3195052585, 2901642782 },
        { 4257279454, 3616509225, 3209952933 },
        { 159699513, 4257279454, 746020360 } },
      // Matrix for nskip = 1 * 8 ^ 16:
      { { 1481142942, 4120754772, 1088557292 },
        { 265491023, 1481142942, 2860005744 },
        { 301796252, 265491023, 1935975979 } },
      // Matrix for nskip = 2 * 8 ^ 16:
      { { 2111859033, 2813610100, 1001476468 },
        { 73849832, 2111859033, 3980799998 },
        { 3330206241, 73849832, 1933943506 } },
      // Matrix for nskip = 3 * 8 ^ 16:
      { { 4238802520, 1791251057, 3659825373 },
        { 756158319, 4238802520, 1208877520 },
        { 3666294602, 756158319, 1800377045 } },
      // Matrix for nskip = 4 * 8 ^ 16:
      { { 1781286360, 3661231931, 3509383709 },
        { 2753158871, 1781286360, 3119883109 },
        { 3576525143, 2753158871, 551079002 } },
      // Matrix for nskip = 5 * 8 ^ 16:
      { { 1150902763, 3730191199, 946744850 },
        { 3422735839, 1150902763, 2750435170 },
        { 3792794843, 3422735839, 808249292 } },
      // Matrix for nskip = 6 * 8 ^ 16:
      { { 429107478, 1467997203, 689359610 },
        { 3244671951, 429107478, 2795337511 },
        { 3397069741, 3244671951, 186846111 } },
      // Matrix for nskip = 7 * 8 ^ 16:
      { { 1453148331, 352897577, 3494583787 },
        { 2340848640, 1453148331, 3699044308 },
        { 3239904192, 2340848640, 209181640 } },
      // Matrix for nskip = 1 * 8 ^ 17:
      { { 1185024844, 587779104, 1004942725 },
        { 3763632860, 1185024844, 947424568 },
        { 3811666068, 3763632860, 2352253462 } },
      // Matrix for nskip = 2 * 8 ^ 17:
      { { 1310227170, 218138208, 3172947233 },
        { 766129426, 1310227170, 1808643264 },
        { 2226659371, 766129426, 3853798112 } },
      // Matrix for nskip = 3 * 8 ^ 17:
      { { 3141996820, 528748361, 1701083808 },
        { 2360837423, 3141996820, 2513545590 },
        { 1425244435, 2360837423, 4192496132 } },
      // Matrix for nskip = 4 * 8 ^ 17:
      { { 2230902378, 4243560874, 2491962392 },
        { 3836629116, 2230902378, 3637515403 },
        { 2846140932, 3836629116, 3083355464 } },
      // Matrix for nskip = 5 * 8 ^ 17:
      { { 506476814, 1267508030, 152968246 },
        { 1117668151, 506476814, 2848688169 },
        { 3001214254, 1117668151, 3940649164 } },
      // Matrix for nskip = 6 * 8 ^ 17:
      { { 1544421101, 772024440, 2364160468 },
        { 2733679040, 1544421101, 965008581 },
        { 2290142084, 2733679040, 3167919795 } },
      // Matrix for nskip = 7 * 8 ^ 17:
      { { 2195717687, 3299928213, 1911548095 },
        { 3677807589, 2195717687, 2979544321 },
        { 1288751520, 3677807589, 1379093393 } },
      // Matrix for nskip = 1 * 8 ^ 18:
      { { 999448569, 1464488480, 3344426626 },
        { 946166795, 999448569, 340856814 },
        { 3686999436, 946166795, 3231079441 } },
      // Matrix for nskip = 2 * 8 ^ 18:
      { { 1226155368, 3477563770, 550006884 },
        { 2378667355, 1226155368, 1493409040 },
        { 260364836, 2378667355, 4133888397 } },
      // Matrix for nskip = 3 * 8 ^ 18:
      { { 662024646, 2039234405, 3990280006 },
        { 2342461604, 662024646, 17023679 },
        { 1965981888, 2342461604, 1830518881 } },
      // Matrix for nskip = 4 * 8 ^ 18:
      { { 1277901832, 310796286, 2818511068 },
        { 3088910653, 1277901832, 3303406025 },
        { 2507911914, 3088910653, 3712928074 } },
      // Matrix for nskip = 5 * 8 ^ 18:
      { { 1103450261, 1722381279, 1394112836 },
        { 640743651, 1103450261, 198700731 },
        { 1095985628, 640743651, 2694625446 } },
      // Matrix for nskip = 6 * 8 ^ 18:
      { { 4043182751, 1859059885, 1911031801 },
        { 2638851660, 4043182751, 4012210417 },
        { 783591639, 2638851660, 2188651115 } },
      // Matrix for nskip = 7 * 8 ^ 18:
      { { 2318313639, 843870069, 2868175764 },
        { 3777361816, 2318313639, 4070019017 },
        { 2087410703, 3777361816, 2574355460 } },
      // Matrix for nskip = 1 * 8 ^ 19:
      { { 481918378, 339570348, 1728801469 },
        { 1623163429, 481918378, 2209094694 },
        { 3146982514, 1623163429, 508445538 } },
      // Matrix for nskip = 2 * 8 ^ 19:
      { { 3138921230, 2381863183, 1992357430 },
        { 1024510915, 3138921230, 2122851650 },
        { 1453455184, 1024510915, 941946604 } },
      // Matrix for nskip = 3 * 8 ^ 19:
      { { 3235663883, 499846706, 3251827412 },
        { 801993191, 3235663883, 2207701640 },
        { 1201194185, 801993191, 2705683748 } },
      // Matrix for nskip = 4 * 8 ^ 19:
      { { 2465372719, 1391015357, 3328905025 },
        { 1821933605, 2465372719, 1343489680 },
        { 3648970313, 1821933605, 1816599716 } },
      // Matrix for nskip = 5 * 8 ^ 19:
      { { 582796091, 1306170361, 1574617829 },
        { 4167642903, 582796091, 284777447 },
        { 3124784671, 4167642903, 2539713186 } },
      // Matrix for nskip = 6 * 8 ^ 19:
      { { 116486317, 2122591885, 1696181092 },
        { 381403852, 116486317, 2932149608 },
        { 3221291545, 381403852, 2742038256 } },
      // Matrix for nskip = 7 * 8 ^ 19:
      { { 3035480468, 2182693760, 2351066479 },
        { 638141264, 3035480468, 100617977 },
        { 478641834, 638141264, 479301469 } },
      // Matrix for nskip = 1 * 8 ^ 20:
      { { 118634664, 3358712512, 2492792220 },
        { 348833376, 118634664, 2495544591 },
        { 3235582254, 348833376, 4043157504 } },
      // Matrix for nskip = 2 * 8 ^ 20:
      { { 2303067090, 3371139074, 1967771133 },
        { 598630070, 2303067090, 1819012637 },
        { 2049250561, 598630070, 4093044926 } },
      // Matrix for nskip = 3 * 8 ^ 20:
      { { 897071837, 763331173, 3837362577 },
        { 294683328, 897071837, 2496877097 },
        { 2268904495, 294683328, 3496861697 } },
      // Matrix for nskip = 4 * 8 ^ 20:
      { { 3035321857, 3971176093, 226779704 },
        { 3361614254, 3035321857, 2807125404 },
        { 326640887, 3361614254, 3147308542 } },
      // Matrix for nskip = 5 * 8 ^ 20:
      { { 4010547095, 2725421511, 511986932 },
        { 1545732164, 4010547095, 2643845410 },
        { 2010134838, 1545732164, 3633977146 } },
      // Matrix for nskip = 6 * 8 ^ 20:
      { { 3118026103, 1037137281, 1600236290 },
        { 2957620899, 3118026103, 433027378 },
        { 2926759199, 2957620899, 3989342054 } },
      // Matrix for nskip = 7 * 8 ^ 20:
      { { 2423025801, 3089536821, 995021703 },
        { 3613148280, 2423025801, 241254395 },
        { 2857733472, 3613148280, 1868423350 } },
      // Matrix for nskip = 1 * 8 ^ 21:
      { { 1774298149, 4179629947, 3145006948 },
        { 1688753503, 1774298149, 94869516 },
        { 2327946901, 1688753503, 2786835219 } },
      // Matrix for nskip = 2 * 8 ^ 21:
      { { 185429251, 88142322, 3372328450 },
        { 1198432931, 185429251, 1527068783 },
        { 2880072915, 1198432931, 2782214191 } },
      // Matrix for nskip = 3 * 8 ^ 21:
      { { 2610521617, 1116660734, 2002689706 },
        { 152508922, 2610521617, 2005955946 },
        { 3106947611, 152508922, 239569623 } },
      // Matrix for nskip = 4 * 8 ^ 21:
      { { 127447080, 487724245, 2942566616 },
        { 2180042365, 127447080, 1722814040 },
        { 288658537, 2180042365, 4036691926 } },
      // Matrix for nskip = 5 * 8 ^ 21:
      { { 3269833722, 2788004771, 1482042877 },
        { 834850082, 3269833722, 219243029 },
        { 3704080414, 834850082, 2784167151 } },
      // Matrix for nskip = 6 * 8 ^ 21:
      { { 3956830949, 61587123, 1894752970 },
        { 1989171734, 3956830949, 3197042083 },
        { 457585003, 1989171734, 948838482 } },
      // Matrix for nskip = 7 * 8 ^ 21:
      { { 1982687998, 3610851352, 1902386191 },
        { 2465097713, 1982687998, 1172472587 },
        { 1202471365, 2465097713, 3151246066 } },
      // Matrix for nskip = 1 * 8 ^ 22:
      { { 1614979968, 1486547157, 1122661217 },
        { 3976346810, 1614979968, 2343603502 },
        { 3049605934, 3976346810, 440737492 } },
      // Matrix for nskip = 2 * 8 ^ 22:
      { { 613698149, 3416334823, 3832821180 },
        { 1308958254, 613698149, 1338381534 },
        { 4058246217, 1308958254, 2070907998 } },
      // Matrix for nskip = 3 * 8 ^ 22:
      { { 4069522778, 1558347771, 1555772973 },
        { 2924102885, 4069522778, 561176530 },
        { 566720713, 2924102885, 2660857604 } },
      // Matrix for nskip = 4 * 8 ^ 22:
      { { 2575546527, 1033712257, 125034191 },
        { 2091411644, 2575546527, 226649669 },
        { 1198488263, 2091411644, 1522580506 } },
      // Matrix for nskip = 5 * 8 ^ 22:
      { { 180639007, 1841709550, 234837148 },
        { 2219662691, 180639007, 4181748462 },
        { 3183232763, 2219662691, 2120135993 } },
      // Matrix for nskip = 6 * 8 ^ 22:
      { { 4275704717, 2295071345, 1852983492 },
        { 3461773529, 4275704717, 417692359 },
        { 1477011348, 3461773529, 1587362209 } },
      // Matrix for nskip = 7 * 8 ^ 22:
      { { 755069175, 2381439395, 890314398 },
        { 3019982523, 755069175, 572921618 },
        { 330076245, 3019982523, 2885887051 } },
      // Matrix for nskip = 1 * 8 ^ 23:
      { { 1051614737, 227719572, 3725579556 },
        { 3910426444, 1051614737, 2075080920 },
        { 3357426062, 3910426444, 1473179318 } },
      // Matrix for nskip = 2 * 8 ^ 23:
      { { 2999155498, 2971093563, 2685380188 },
        { 93938118, 2999155498, 4035265564 },
        { 3853931650, 93938118, 2034180250 } },
      // Matrix for nskip = 3 * 8 ^ 23:
      { { 3543842569, 1469908890, 519769416 },
        { 3600765500, 3543842569, 1553393489 },
        { 60922281, 3600765500, 1226136476 } },
      // Matrix for nskip = 4 * 8 ^ 23:
      { { 1253368368, 2860152458, 2836784419 },
        { 1656084047, 1253368368, 646811031 },
        { 3103367928, 1656084047, 3114448889 } },
      // Matrix for nskip = 5 * 8 ^ 23:
      { { 2205916258, 1604698588, 3155610724 },
        { 2362004551, 2205916258, 181736283 },
        { 3847535541, 2362004551, 3814972479 } },
      // Matrix for nskip = 6 * 8 ^ 23:
      { { 7725939, 1654580658, 4264117811 },
        { 1274240457, 7725939, 2108223515 },
        { 1813716775, 1274240457, 2141296207 } },
      // Matrix for nskip = 7 * 8 ^ 23:
      { { 1828440339, 726307104, 566806600 },
        { 2069873554, 1828440339, 2003524657 },
        { 2528019064, 2069873554, 868624934 } },
      // Matrix for nskip = 1 * 8 ^ 24:
      { { 2962469315, 4021086500, 2670244515 },
        { 299199825, 2962469315, 3624275162 },
        { 3634541206, 299199825, 1684552227 } },
      // Matrix for nskip = 2 * 8 ^ 24:
      { { 804213223, 438999528, 3143925885 },
        { 1625976775, 804213223, 1494982903 },
        { 3498104358, 1625976775, 881729466 } },
      // Matrix for nskip = 3 * 8 ^ 24:
      { { 2885386524, 2618720282, 4093772765 },
        { 1140571071, 2885386524, 2989367205 },
        { 2802821649, 1140571071, 742292537 } },
      // Matrix for nskip = 4 * 8 ^ 24:
      { { 1547173514, 490999994, 918013965 },
        { 1312079237, 1547173514, 1905431135 },
        { 3784344293, 1312079237, 3643511238 } },
      // Matrix for nskip = 5 * 8 ^ 24:
      { { 3363084915, 889964766, 2840623993 },
        { 485137636, 3363084915, 1563107974 },
        { 4117358359, 485137636, 2655518143 } },
      // Matrix for nskip = 6 * 8 ^ 24:
      { { 2014523666, 1476325540, 1550754572 },
        { 588313388, 2014523666, 2691287218 },
        { 4248816946, 588313388, 1568942409 } },
      // Matrix for nskip = 7 * 8 ^ 24:
      { { 2407332340, 3541076740, 1876171062 },
        { 1127328556, 2407332340, 3702106930 },
        { 1804600645, 1127328556, 2140373745 } },
      // Matrix for nskip = 1 * 8 ^ 25:
      { { 3846994569, 2894966137, 1130633118 },
        { 4115190113, 3846994569, 777098754 },
        { 3088495692, 4115190113, 2193427908 } },
      // Matrix for nskip = 2 * 8 ^ 25:
      { { 1511326704, 3759209742, 1610795712 },
        { 4292754251, 1511326704, 3889917532 },
        { 3859662829, 4292754251, 3708466080 } },
      // Matrix for nskip = 3 * 8 ^ 25:
      { { 2721725192, 3847490931, 444351073 },
        { 429225403, 2721725192, 673508566 },
        { 387279730, 429225403, 3104869093 } },
      // Matrix for nskip = 4 * 8 ^ 25:
      { { 972103006, 964807713, 878035866 },
        { 4248550197, 972103006, 1926628839 },
        { 1448629089, 4248550197, 3196114006 } },
      // Matrix for nskip = 5 * 8 ^ 25:
      { { 549140019, 2935386277, 4206854109 },
        { 459549553, 549140019, 1011901572 },
        { 821145437, 459549553, 302470082 } },
      // Matrix for nskip = 6 * 8 ^ 25:
      { { 907238901, 2926293232, 2865846472 },
        { 840689212, 907238901, 1249197731 },
        { 4278768404, 840689212, 3331097822 } },
      // Matrix for nskip = 7 * 8 ^ 25:
      { { 105585154, 3513063153, 2552212444 },
        { 379969606, 105585154, 378686420 },
        { 3414457398, 379969606, 3084470277 } },
      // Matrix for nskip = 1 * 8 ^ 26:
      { { 3497384788, 3174249442, 3182508868 },
        { 3864816447, 3497384788, 3038399593 },
        { 2546884738, 3864816447, 2980208068 } },
      // Matrix for nskip = 2 * 8 ^ 26:
      { { 1776335558, 1189944887, 4095757548 },
        { 3813600746, 1776335558, 789475914 },
        { 4119698302, 3813600746, 2145357457 } },
      // Matrix for nskip = 3 * 8 ^ 26:
      { { 1736653518, 945282763, 3568863651 },
        { 2539405616, 1736653518, 3870991887 },
        { 1676082014, 2539405616, 4282213129 } },
      // Matrix for nskip = 4 * 8 ^ 26:
      { { 4022832294, 4130146837, 1942923647 },
        { 1675130777, 4022832294, 916677004 },
        { 4089786548, 1675130777, 116540512 } },
      // Matrix for nskip = 5 * 8 ^ 26:
      { { 3414208535, 1938436883, 1996617380 },
        { 3508342845, 3414208535, 3024221061 },
        { 863275511, 3508342845, 3926625937 } },
      // Matrix for nskip = 6 * 8 ^ 26:
      { { 943060309, 1550884686, 1524180490 },
        { 1603911046, 943060309, 659956132 },
        { 3864471824, 1603911046, 1981894197 } },
      // Matrix for nskip = 7 * 8 ^ 26:
      { { 4039258344, 2877267458, 1263654722 },
        { 2264646264, 4039258344, 866786660 },
        { 3436002161, 2264646264, 1103279181 } },
      // Matrix for nskip = 1 * 8 ^ 27:
      { { 165639584, 1205513289, 2037453462 },
        { 1444587280, 165639584, 161923120 },
        { 2617085459, 1444587280, 2006913311 } },
      // Matrix for nskip = 2 * 8 ^ 27:
      { { 3458099202, 3062421748, 4052486999 },
        { 1064270720, 3458099202, 230768332 },
        { 4056228301, 1064270720, 2219267779 } },
      // Matrix for nskip = 3 * 8 ^ 27:
      { { 4130534548, 3958841381, 2978123129 },
        { 3549040929, 4130534548, 624596665 },
        { 3007893075, 3549040929, 2033981581 } },
      // Matrix for nskip = 4 * 8 ^ 27:
      { { 296275263, 3452455838, 2081462173 },
        { 1789143993, 296275263, 3463234943 },
        { 2097389984, 1789143993, 3447191459 } },
      // Matrix for nskip = 5 * 8 ^ 27:
      { { 3690699991, 194807645, 3499022088 },
        { 895650639, 3690699991, 202155710 },
        { 3063493626, 895650639, 2818867049 } },
      // Matrix for nskip = 6 * 8 ^ 27:
      { { 775854673, 2918396394, 2709062415 },
        { 2684216609, 775854673, 721391189 },
        { 4036938266, 2684216609, 1742271124 } },
      // Matrix for nskip = 7 * 8 ^ 27:
      { { 3150458758, 4126093705, 1386916196 },
        { 3083923483, 3150458758, 2299677089 },
        { 1576871217, 3083923483, 1393814954 } },
      // Matrix for nskip = 1 * 8 ^ 28:
      { { 2828288883, 3866690251, 410553827 },
        { 1587005542, 2828288883, 1469478670 },
        { 2766486018, 1587005542, 2627363449 } },
      // Matrix for nskip = 2 * 8 ^ 28:
      { { 3288027530, 412403981, 2458742268 },
        { 4267121909, 3288027530, 138566505 },
        { 420803572, 4267121909, 4094554844 } },
      // Matrix for nskip = 3 * 8 ^ 28:
      { { 2136361676, 3398888999, 2068559481 },
        { 3790597750, 2136361676, 3281478755 },
        { 4056706273, 3790597750, 1765993677 } },
      // Matrix for nskip = 4 * 8 ^ 28:
      { { 3844599430, 2430152838, 3283485436 },
        { 2486244684, 3844599430, 4252427633 },
        { 3560842909, 2486244684, 3960267499 } },
      // Matrix for nskip = 5 * 8 ^ 28:
      { { 3419145577, 107246070, 429885456 },
        { 1381214928, 3419145577, 1111366755 },
        { 767007913, 1381214928, 2270459619 } },
      // Matrix for nskip = 6 * 8 ^ 28:
      { { 1494013447, 1485743041, 931794028 },
        { 3674972444, 1494013447, 2085831739 },
        { 62603161, 3674972444, 555083053 } },
      // Matrix for nskip = 7 * 8 ^ 28:
      { { 1677686741, 1049056456, 3063490072 },
        { 3432517708, 1677686741, 1550912558 },
        { 3096606227, 3432517708, 349068991 } },
      // Matrix for nskip = 1 * 8 ^ 29:
      { { 67933059, 1294996291, 2657888382 },
        { 513233413, 67933059, 1379805031 },
        { 44564058, 513233413, 86971645 } },
      // Matrix for nskip = 2 * 8 ^ 29:
      { { 2732588524, 1866530072, 818237694 },
        { 2540507736, 2732588524, 3257104212 },
        { 1164400003, 2540507736, 1124501551 } },
      // Matrix for nskip = 3 * 8 ^ 29:
      { { 1412660773, 1524580236, 2800129005 },
        { 3198153122, 1412660773, 3904718713 },
        { 2546401509, 3198153122, 386568104 } },
      // Matrix for nskip = 4 * 8 ^ 29:
      { { 4199239222, 3155848463, 2121388468 },
        { 1135554501, 4199239222, 2056492193 },
        { 3251740389, 1135554501, 2343537248 } },
      // Matrix for nskip = 5 * 8 ^ 29:
      { { 3239971958, 3891714065, 1807213249 },
        { 3694822198, 3239971958, 3557488352 },
        { 2750758637, 3694822198, 163867522 } },
      // Matrix for nskip = 6 * 8 ^ 29:
      { { 884974087, 1753139982, 2087168228 },
        { 2226758301, 884974087, 1590955204 },
        { 1886560387, 2226758301, 4000127015 } },
      // Matrix for nskip = 7 * 8 ^ 29:
      { { 3230269711, 3957529982, 3575750396 },
        { 3930348525, 3230269711, 2594598825 },
        { 3785901658, 3930348525, 4178374892 } },
      // Matrix for nskip = 1 * 8 ^ 30:
      { { 550710036, 500329021, 1075236085 },
        { 356444753, 550710036, 1634965500 },
        { 58733535, 356444753, 1261552815 } },
      // Matrix for nskip = 2 * 8 ^ 30:
      { { 708689546, 419139045, 2012018174 },
        { 706488081, 708689546, 1113760995 },
        { 585555005, 706488081, 76092226 } },
      // Matrix for nskip = 3 * 8 ^ 30:
      { { 2584730290, 103417098, 2018833769 },
        { 831116151, 2584730290, 1919249397 },
        { 1036497162, 831116151, 2546254144 } },
      // Matrix for nskip = 4 * 8 ^ 30:
      { { 1293182265, 3168473803, 366230236 },
        { 3319068849, 1293182265, 1085259665 },
        { 1675229290, 3319068849, 3912300371 } },
      // Matrix for nskip = 5 * 8 ^ 30:
      { { 2602420349, 3992244735, 1543754813 },
        { 3770060220, 2602420349, 1407637442 },
        { 944746705, 3770060220, 2920440850 } },
      // Matrix for nskip = 6 * 8 ^ 30:
      { { 1601703108, 619857159, 1219413461 },
        { 2824672719, 1601703108, 3707169777 },
        { 3352413650, 2824672719, 1098132331 } },
      // Matrix for nskip = 7 * 8 ^ 30:
      { { 3630967154, 3444173778, 3289446159 },
        { 1769199423, 3630967154, 2021155330 },
        { 1478978985, 1769199423, 1976131087 } },
      // Matrix for nskip = 1 * 8 ^ 31:
      { { 3186089068, 4188864734, 1211781402 },
        { 756122322, 3186089068, 578262892 },
        { 2518961174, 756122322, 1658665581 } },
      // Matrix for nskip = 2 * 8 ^ 31:
      { { 1347291439, 2050427676, 736113023 },
        { 4102191254, 1347291439, 878627148 },
        { 1293500383, 4102191254, 745646810 } },
      // Matrix for nskip = 3 * 8 ^ 31:
      { { 1428398286, 758558167, 59314928 },
        { 2615508955, 1428398286, 3061138405 },
        { 1098162878, 2615508955, 2401469211 } },
      // Matrix for nskip = 4 * 8 ^ 31:
      { { 4196897331, 3436564969, 1900167098 },
        { 3108887846, 4196897331, 2697923227 },
        { 1405263476, 3108887846, 314631094 } },
      // Matrix for nskip = 5 * 8 ^ 31:
      { { 3004743607, 2733058282, 4202297421 },
        { 956778663, 3004743607, 1815192601 },
        { 2211295748, 956778663, 3626831178 } },
      // Matrix for nskip = 6 * 8 ^ 31:
      { { 3694919563, 2520419703, 731922800 },
        { 540077867, 3694919563, 2433069844 },
        { 2129238146, 540077867, 301939378 } },
      // Matrix for nskip = 7 * 8 ^ 31:
      { { 2475140271, 37335008, 2778457406 },
        { 2217587145, 2475140271, 1363889163 },
        { 135344313, 2217587145, 1707617706 } },
      // Matrix for nskip = 1 * 8 ^ 32:
      { { 958383622, 3694638688, 1150087061 },
        { 3770009830, 958383622, 793326651 },
        { 533700213, 3770009830, 1513734026 } },
      // Matrix for nskip = 2 * 8 ^ 32:
      { { 4119603367, 3479396923, 3534176399 },
        { 3765397477, 4119603367, 1458031003 },
        { 3380901602, 3765397477, 2684083587 } },
      // Matrix for nskip = 3 * 8 ^ 32:
      { { 178016378, 1184002529, 789650986 },
        { 389885259, 178016378, 3729279189 },
        { 1268575347, 389885259, 4091367000 } },
      // Matrix for nskip = 4 * 8 ^ 32:
      { { 980937351, 2094378936, 448446028 },
        { 1421333909, 980937351, 3405683645 },
        { 323724368, 1421333909, 338680738 } },
      // Matrix for nskip = 5 * 8 ^ 32:
      { { 2381808660, 341372255, 146194193 },
        { 4185254045, 2381808660, 1244677534 },
        { 2006223188, 4185254045, 3589653882 } },
      // Matrix for nskip = 6 * 8 ^ 32:
      { { 1104593159, 2457034166, 4243190272 },
        { 2690000574, 1104593159, 3592133108 },
        { 3935039161, 2690000574, 2028886430 } },
      // Matrix for nskip = 7 * 8 ^ 32:
      { { 798595991, 3072704016, 1453032677 },
        { 3595149031, 798595991, 1556294726 },
        { 775957906, 3595149031, 208124234 } },
      // Matrix for nskip = 1 * 8 ^ 33:
      { { 2942968846, 4293637338, 3549906544 },
        { 527851489, 2942968846, 3852871282 },
        { 4209198933, 527851489, 1091268872 } },
      // Matrix for nskip = 2 * 8 ^ 33:
      { { 1975983015, 2092556693, 611187071 },
        { 3982652344, 1975983015, 3001736262 },
        { 2055073597, 3982652344, 1875181995 } },
      // Matrix for nskip = 3 * 8 ^ 33:
      { { 1752967931, 1167063522, 3817182484 },
        { 3760899628, 1752967931, 2808655727 },
        { 3110603267, 3760899628, 1832178008 } },
      // Matrix for nskip = 4 * 8 ^ 33:
      { { 2970221269, 880904779, 2447465272 },
        { 2888742196, 2970221269, 3521651749 },
        { 3019977656, 2888742196, 2712717326 } },
      // Matrix for nskip = 5 * 8 ^ 33:
      { { 604958655, 442191761, 1996070625 },
        { 1269454015, 604958655, 814754560 },
        { 507433046, 1269454015, 2488458391 } },
      // Matrix for nskip = 6 * 8 ^ 33:
      { { 710612185, 99734716, 3956229929 },
        { 2137129319, 710612185, 2895847378 },
        { 1727032860, 2137129319, 1001260701 } },
      // Matrix for nskip = 7 * 8 ^ 33:
      { { 1066664047, 4152765348, 1734907969 },
        { 2968154336, 1066664047, 2381691001 },
        { 1497199245, 2968154336, 3563839605 } },
      // Matrix for nskip = 1 * 8 ^ 34:
      { { 419134859, 2976059897, 747864206 },
        { 4101695717, 419134859, 4264593116 },
        { 2657991148, 4101695717, 2542621682 } },
      // Matrix for nskip = 2 * 8 ^ 34:
      { { 4043135299, 1612983166, 1149778656 },
        { 1267010518, 4043135299, 3496325546 },
        { 3094232897, 1267010518, 2949176293 } },
      // Matrix for nskip = 3 * 8 ^ 34:
      { { 3214297332, 2846434362, 4106231685 },
        { 1780972559, 3214297332, 1132838092 },
        { 1348023856, 1780972559, 537227984 } },
      // Matrix for nskip = 4 * 8 ^ 34:
      { { 3949395794, 1774568686, 2123036003 },
        { 2182983404, 3949395794, 2355671350 },
        { 2820933455, 2182983404, 513963325 } },
      // Matrix for nskip = 5 * 8 ^ 34:
      { { 1877604589, 3803366824, 2927718923 },
        { 2817972608, 1877604589, 901177092 },
        { 1008515195, 2817972608, 1900906578 } },
      // Matrix for nskip = 6 * 8 ^ 34:
      { { 2247365780, 1508191753, 929996525 },
        { 2014701429, 2247365780, 2906849518 },
        { 1864911773, 2014701429, 634217040 } },
      // Matrix for nskip = 7 * 8 ^ 34:
      { { 3200692723, 3246632578, 3558417384 },
        { 733273917, 3200692723, 715293224 },
        { 3878803573, 733273917, 3720987401 } },
      // Matrix for nskip = 1 * 8 ^ 35:
      { { 3046911698, 2576744453, 2492729814 },
        { 4277866093, 3046911698, 3146977604 },
        { 2249371766, 4277866093, 3622293976 } },
      // Matrix for nskip = 2 * 8 ^ 35:
      { { 1391529818, 423458502, 2587125255 },
        { 3536237833, 1391529818, 985347517 },
        { 157623850, 3536237833, 1015566287 } },
      // Matrix for nskip = 3 * 8 ^ 35:
      { { 2768170623, 2671124421, 1038000683 },
        { 2258964805, 2768170623, 3036723158 },
        { 2454977948, 2258964805, 2502325941 } },
      // Matrix for nskip = 4 * 8 ^ 35:
      { { 48329260, 2599277669, 821961664 },
        { 902187690, 48329260, 1716556555 },
        { 4019658974, 902187690, 950730510 } },
      // Matrix for nskip = 5 * 8 ^ 35:
      { { 3100975771, 1019061132, 1844417430 },
        { 1634016885, 3100975771, 2161076681 },
        { 378757639, 1634016885, 4124897232 } },
      // Matrix for nskip = 6 * 8 ^ 35:
      { { 1045387495, 796030826, 1236131839 },
        { 2328291482, 1045387495, 2884310858 },
        { 3863948457, 2328291482, 465921502 } },
      // Matrix for nskip = 7 * 8 ^ 35:
      { { 3483511399, 741205873, 1920164372 },
        { 1105604243, 3483511399, 2420741811 },
        { 2484220821, 1105604243, 2513215163 } },
      // Matrix for nskip = 1 * 8 ^ 36:
      { { 1318489562, 1530977112, 3713577419 },
        { 4270158447, 1318489562, 1654940598 },
        { 2679964938, 4270158447, 1337075195 } },
      // Matrix for nskip = 2 * 8 ^ 36:
      { { 770600793, 3249576224, 3578552768 },
        { 2710443459, 770600793, 2990852339 },
        { 3098163705, 2710443459, 522138188 } },
      // Matrix for nskip = 3 * 8 ^ 36:
      { { 3299888517, 1806316064, 2474407987 },
        { 3432253975, 3299888517, 3480703284 },
        { 201692417, 3432253975, 1711417284 } },
      // Matrix for nskip = 4 * 8 ^ 36:
      { { 2803285489, 1922250286, 3164022812 },
        { 477609731, 2803285489, 2140252218 },
        { 2252852611, 477609731, 3058519788 } },
      // Matrix for nskip = 5 * 8 ^ 36:
      { { 3735324161, 860809210, 2792496593 },
        { 1613420642, 3735324161, 651730634 },
        { 3412387271, 1613420642, 2796594703 } },
      // Matrix for nskip = 6 * 8 ^ 36:
      { { 993539593, 3499265007, 3772074010 },
        { 3213913829, 993539593, 3655831787 },
        { 2561980091, 3213913829, 2164990937 } },
      // Matrix for nskip = 7 * 8 ^ 36:
      { { 76754721, 818311023, 1258273773 },
        { 2914546594, 76754721, 3007787703 },
        { 1554324281, 2914546594, 1645121444 } },
      // Matrix for nskip = 1 * 8 ^ 37:
      { { 208329741, 3633562083, 3548346666 },
        { 3892091460, 208329741, 516833304 },
        { 3440632377, 3892091460, 1638833719 } },
      // Matrix for nskip = 2 * 8 ^ 37:
      { { 1816075033, 3570111203, 959489356 },
        { 3482051486, 1816075033, 861657108 },
        { 3119495098, 3482051486, 2576849579 } },
      // Matrix for nskip = 3 * 8 ^ 37:
      { { 955576990, 607798602, 220457899 },
        { 760121425, 955576990, 1155400464 },
        { 1209136348, 760121425, 1165671753 } },
      // Matrix for nskip = 4 * 8 ^ 37:
      { { 4240216888, 2891584407, 2102314945 },
        { 4064489450, 4240216888, 1427441010 },
        { 2441164913, 4064489450, 3558527186 } },
      // Matrix for nskip = 5 * 8 ^ 37:
      { { 3943073787, 2113696223, 3840029496 },
        { 42559030, 3943073787, 2203932271 },
        { 638717597, 42559030, 3208053933 } },
      // Matrix for nskip = 6 * 8 ^ 37:
      { { 714331518, 510361535, 3438751245 },
        { 2783614947, 714331518, 666348656 },
        { 4028058908, 2783614947, 2994150339 } },
      // Matrix for nskip = 7 * 8 ^ 37:
      { { 3978295779, 1441779930, 4249164235 },
        { 1006134725, 3978295779, 2022224066 },
        { 1257228544, 1006134725, 3563676111 } },
      // Matrix for nskip = 1 * 8 ^ 38:
      { { 2918371295, 65155283, 3469357011 },
        { 3579773554, 2918371295, 3494391959 },
        { 3266584309, 3579773554, 3837485479 } },
      // Matrix for nskip = 2 * 8 ^ 38:
      { { 2959420453, 1365016881, 4082486022 },
        { 236489012, 2959420453, 3802558529 },
        { 2687043642, 236489012, 2547086826 } },
      // Matrix for nskip = 3 * 8 ^ 38:
      { { 3501988208, 1843500325, 3464182128 },
        { 969269805, 3501988208, 2232088910 },
        { 3829792024, 969269805, 2334756085 } },
      // Matrix for nskip = 4 * 8 ^ 38:
      { { 4185325422, 2762854843, 3200044912 },
        { 3664909559, 4185325422, 3543921700 },
        { 4240262918, 3664909559, 2853212443 } },
      // Matrix for nskip = 5 * 8 ^ 38:
      { { 3870531367, 2625370600, 1928035826 },
        { 1477778653, 3870531367, 4167218005 },
        { 2810379745, 1477778653, 1547435981 } },
      // Matrix for nskip = 6 * 8 ^ 38:
      { { 2166942438, 2045317959, 2862960125 },
        { 1192305592, 2166942438, 2202186359 },
        { 1282445014, 1192305592, 3680855685 } },
      // Matrix for nskip = 7 * 8 ^ 38:
      { { 4183888729, 1630438655, 1622555680 },
        { 841523235, 4183888729, 266662726 },
        { 1888300357, 841523235, 553070804 } },
      // Matrix for nskip = 1 * 8 ^ 39:
      { { 2618500928, 4237264351, 1470046497 },
        { 1893990098, 2618500928, 2982567031 },
        { 3017062825, 1893990098, 3195556801 } },
      // Matrix for nskip = 2 * 8 ^ 39:
      { { 1868464655, 3407681142, 1652841784 },
        { 1678569574, 1868464655, 4162480901 },
        { 1477016185, 1678569574, 4145063890 } },
      // Matrix for nskip = 3 * 8 ^ 39:
      { { 346858981, 2885211332, 1550050752 },
        { 3168708136, 346858981, 2121517268 },
        { 696413464, 3168708136, 2779761666 } },
      // Matrix for nskip = 4 * 8 ^ 39:
      { { 792188465, 4251338402, 2219407026 },
        { 3840340879, 792188465, 3493367465 },
        { 2979958414, 3840340879, 2338974139 } },
      // Matrix for nskip = 5 * 8 ^ 39:
      { { 3859433262, 3764728773, 1297631730 },
        { 3833824001, 3859433262, 1333287789 },
        { 1909447704, 3833824001, 2135933046 } },
      // Matrix for nskip = 6 * 8 ^ 39:
      { { 102264893, 4038432252, 2717349223 },
        { 709433989, 102264893, 1807326569 },
        { 2997676666, 709433989, 3722753261 } },
      // Matrix for nskip = 7 * 8 ^ 39:
      { { 4020257258, 1217293203, 2346103599 },
        { 3809824315, 4020257258, 576285090 },
        { 3162683019, 3809824315, 2652264596 } },
      // Matrix for nskip = 1 * 8 ^ 40:
      { { 478845700, 2378167062, 882114621 },
        { 1674533845, 478845700, 3572905305 },
        { 3571222880, 1674533845, 1242316901 } },
      // Matrix for nskip = 2 * 8 ^ 40:
      { { 2636090868, 1972761498, 71690719 },
        { 1228103463, 2636090868, 1280685025 },
        { 3741735502, 1228103463, 994061750 } },
      // Matrix for nskip = 3 * 8 ^ 40:
      { { 2765592972, 3759047976, 2089192298 },
        { 2592791249, 2765592972, 2079317731 },
        { 3195761319, 2592791249, 913428082 } },
      // Matrix for nskip = 4 * 8 ^ 40:
      { { 1156725261, 1100755307, 221922891 },
        { 2892200461, 1156725261, 1505716533 },
        { 2287613563, 2892200461, 3689457190 } },
      // Matrix for nskip = 5 * 8 ^ 40:
      { { 716602832, 851112058, 2726490354 },
        { 328778061, 716602832, 2662750501 },
        { 2300190858, 328778061, 2031908929 } },
      // Matrix for nskip = 6 * 8 ^ 40:
      { { 131535614, 3548535605, 1837882588 },
        { 3257415168, 131535614, 1374937136 },
        { 1879184234, 3257415168, 167534374 } },
      // Matrix for nskip = 7 * 8 ^ 40:
      { { 3131954528, 4223897546, 515553914 },
        { 326215900, 3131954528, 644217952 },
        { 934922655, 326215900, 2645770575 } },
      // Matrix for nskip = 1 * 8 ^ 41:
      { { 1387244644, 3135090808, 1243609165 },
        { 1724967466, 1387244644, 3296353235 },
        { 1064364031, 1724967466, 2107521044 } },
      // Matrix for nskip = 2 * 8 ^ 41:
      { { 2822471992, 2034317853, 2071407475 },
        { 170903528, 2822471992, 1322162887 },
        { 2524982332, 170903528, 2656231333 } },
      // Matrix for nskip = 3 * 8 ^ 41:
      { { 2401421275, 3219909065, 1167519964 },
        { 3200856372, 2401421275, 2651362201 },
        { 3150793696, 3200856372, 3740263529 } },
      // Matrix for nskip = 4 * 8 ^ 41:
      { { 3653936868, 3893194049, 2484299328 },
        { 1313746234, 3653936868, 1705346273 },
        { 1397638018, 1313746234, 4015529545 } },
      // Matrix for nskip = 5 * 8 ^ 41:
      { { 762850190, 2502708647, 3030789377 },
        { 605169915, 762850190, 2517301940 },
        { 2651641442, 605169915, 3739297479 } },
      // Matrix for nskip = 6 * 8 ^ 41:
      { { 4185157227, 3109351418, 2907095532 },
        { 3981440524, 4185157227, 2447807956 },
        { 1358765607, 3981440524, 2947483756 } },
      // Matrix for nskip = 7 * 8 ^ 41:
      { { 616351240, 2708761949, 3510102453 },
        { 1192816102, 616351240, 3430261471 },
        { 3769975746, 1192816102, 1092752722 } },
      // Matrix for nskip = 1 * 8 ^ 42:
      { { 4129760842, 1671665759, 1677834656 },
        { 3200005334, 4129760842, 3486207172 },
        { 2850728736, 3200005334, 3076201597 } },
      // Matrix for nskip = 2 * 8 ^ 42:
      { { 1464411153, 277697599, 1610723613 },
        { 32183930, 1464411153, 1022607788 },
        { 2824425944, 32183930, 2093834863 } },
      // Matrix for nskip = 3 * 8 ^ 42:
      { { 4289888328, 3225021158, 546274137 },
        { 3161813725, 4289888328, 3178255601 },
        { 811227116, 3161813725, 2040329321 } },
      // Matrix for nskip = 4 * 8 ^ 42:
      { { 3492361727, 1027004383, 3167429889 },
        { 3674905362, 3492361727, 3572939265 },
        { 4270409313, 3674905362, 698814233 } },
      // Matrix for nskip = 5 * 8 ^ 42:
      { { 1024068271, 2798745077, 2659447825 },
        { 2040144100, 1024068271, 1035060877 },
        { 2866843005, 2040144100, 787687659 } },
      // Matrix for nskip = 6 * 8 ^ 42:
      { { 2906151318, 3986151835, 2581649800 },
        { 571744464, 2906151318, 1834943086 },
        { 3448634312, 571744464, 290967548 } },
      // Matrix for nskip = 7 * 8 ^ 42:
      { { 1570041711, 1880130578, 2514738078 },
        { 3388141786, 1570041711, 744775425 },
        { 2735736928, 3388141786, 964597855 } },
      // Matrix for nskip = 1 * 8 ^ 43:
      { { 880482061, 205175925, 4070445105 },
        { 2208329119, 880482061, 1933248566 },
        { 3741227945, 2208329119, 3962062826 } },
      // Matrix for nskip = 2 * 8 ^ 43:
      { { 4184605179, 1189429800, 567967482 },
        { 107217966, 4184605179, 784865788 },
        { 549462420, 107217966, 3134382704 } },
      // Matrix for nskip = 3 * 8 ^ 43:
      { { 1386364785, 4079260578, 3001857777 },
        { 3010784539, 1386364785, 3667065093 },
        { 3692171012, 3010784539, 2361530061 } },
      // Matrix for nskip = 4 * 8 ^ 43:
      { { 2732536445, 1231107067, 3374588386 },
        { 409954030, 2732536445, 1044831206 },
        { 3398162498, 409954030, 3505648581 } },
      // Matrix for nskip = 5 * 8 ^ 43:
      { { 3249719425, 4215633308, 1637240461 },
        { 151877124, 3249719425, 2638755179 },
        { 3634975465, 151877124, 1546467979 } },
      // Matrix for nskip = 6 * 8 ^ 43:
      { { 2408251701, 89238831, 4165007723 },
        { 4262743528, 2408251701, 4114669800 },
        { 2878757823, 4262743528, 3182943863 } },
      // Matrix for nskip = 7 * 8 ^ 43:
      { { 1831049905, 2380192587, 325575207 },
        { 2045407448, 1831049905, 3463310486 },
        { 1637651789, 2045407448, 1889914987 } },
      // Matrix for nskip = 1 * 8 ^ 44:
      { { 2169560691, 1076348534, 637306236 },
        { 3704346564, 2169560691, 293694496 },
        { 632453145, 3704346564, 1609425246 } },
      // Matrix for nskip = 2 * 8 ^ 44:
      { { 372115891, 3928812480, 2830541169 },
        { 3056527841, 372115891, 1924239834 },
        { 3044937468, 3056527841, 547142630 } },
      // Matrix for nskip = 3 * 8 ^ 44:
      { { 3652440052, 1383186997, 3140353867 },
        { 1157890357, 3652440052, 3280219833 },
        { 2953685245, 1157890357, 481162011 } },
      // Matrix for nskip = 4 * 8 ^ 44:
      { { 1660852083, 3635660815, 1389092450 },
        { 1025573319, 1660852083, 3276803366 },
        { 4036331438, 1025573319, 4092197741 } },
      // Matrix for nskip = 5 * 8 ^ 44:
      { { 2683005143, 1323793242, 1291869629 },
        { 2903240813, 2683005143, 3854329533 },
        { 2695585089, 2903240813, 1426976484 } },
      // Matrix for nskip = 6 * 8 ^ 44:
      { { 56767734, 116994667, 111909274 },
        { 3730950473, 56767734, 2191610434 },
        { 1091419714, 3730950473, 718571338 } },
      // Matrix for nskip = 7 * 8 ^ 44:
      { { 336318787, 391538001, 10025372 },
        { 3157633492, 336318787, 2821500332 },
        { 3413552779, 3157633492, 4255875513 } },
      // Matrix for nskip = 1 * 8 ^ 45:
      { { 1360732901, 2887812973, 4101068693 },
        { 52572783, 1360732901, 112458461 },
        { 2636566855, 52572783, 1136777988 } },
      // Matrix for nskip = 2 * 8 ^ 45:
      { { 3455696508, 536919193, 3978804036 },
        { 3094157668, 3455696508, 3821833900 },
        { 2278849016, 3094157668, 2531965909 } },
      // Matrix for nskip = 3 * 8 ^ 45:
      { { 105839550, 1126024816, 287198647 },
        { 351807867, 105839550, 643672297 },
        { 1483330368, 351807867, 3781751861 } },
      // Matrix for nskip = 4 * 8 ^ 45:
      { { 2125991744, 890897326, 3790557569 },
        { 1433592392, 2125991744, 3671109604 },
        { 808215503, 1433592392, 2446306581 } },
      // Matrix for nskip = 5 * 8 ^ 45:
      { { 3640380877, 422210679, 1510633752 },
        { 1569172639, 3640380877, 3192250064 },
        { 1376060847, 1569172639, 2027936709 } },
      // Matrix for nskip = 6 * 8 ^ 45:
      { { 3177388361, 1344488735, 2994552097 },
        { 284988983, 3177388361, 3227966904 },
        { 2044803401, 284988983, 4277058832 } },
      // Matrix for nskip = 7 * 8 ^ 45:
      { { 3412413108, 4186230758, 3922996456 },
        { 3683836901, 3412413108, 271458827 },
        { 3964969101, 3683836901, 539759068 } },
      // Matrix for nskip = 1 * 8 ^ 46:
      { { 3524411799, 932865240, 1838275365 },
        { 1789634890, 3524411799, 4130736474 },
        { 2252266098, 1789634890, 3048775967 } },
      // Matrix for nskip = 2 * 8 ^ 46:
      { { 1773339925, 948403862, 1999624391 },
        { 983864203, 1773339925, 3734776305 },
        { 314407045, 983864203, 2648614071 } },
      // Matrix for nskip = 3 * 8 ^ 46:
      { { 1928167136, 2078532030, 1690025039 },
        { 2529043017, 1928167136, 1858653225 },
        { 2142588179, 2529043017, 2188623418 } },
      // Matrix for nskip = 4 * 8 ^ 46:
      { { 321802921, 1099164995, 2112167358 },
        { 3760936985, 321802921, 1003573324 },
        { 3758858458, 3760936985, 4014658840 } },
      // Matrix for nskip = 5 * 8 ^ 46:
      { { 774593807, 1711411238, 3653945922 },
        { 1751249890, 774593807, 10024535 },
        { 9872042, 1751249890, 2762944894 } },
      // Matrix for nskip = 6 * 8 ^ 46:
      { { 2825735696, 1396615016, 3702967335 },
        { 3652693925, 2825735696, 4120492766 },
        { 1992385943, 3652693925, 686943862 } },
      // Matrix for nskip = 7 * 8 ^ 46:
      { { 2314946087, 4102352240, 989909889 },
        { 459855750, 2314946087, 1424771850 },
        { 1469834717, 459855750, 2094187769 } },
      // Matrix for nskip = 1 * 8 ^ 47:
      { { 2196438580, 805386227, 4266375092 },
        { 4124675351, 2196438580, 2527961345 },
        { 94452540, 4124675351, 2825656399 } },
      // Matrix for nskip = 2 * 8 ^ 47:
      { { 66735368, 2228005807, 4186703168 },
        { 2624855312, 66735368, 2708679078 },
        { 4098470056, 2624855312, 1773862183 } },
      // Matrix for nskip = 3 * 8 ^ 47:
      { { 320933009, 1915174474, 3744070526 },
        { 562558814, 320933009, 1706424966 },
        { 413766233, 562558814, 2881230326 } },
      // Matrix for nskip = 4 * 8 ^ 47:
      { { 3072642883, 2746897053, 2690305546 },
        { 1105106652, 3072642883, 4047666135 },
        { 2862886282, 1105106652, 3597347398 } },
      // Matrix for nskip = 5 * 8 ^ 47:
      { { 1498353481, 3428325510, 1424606567 },
        { 372840925, 1498353481, 1901161856 },
        { 1201903815, 372840925, 1622747589 } },
      // Matrix for nskip = 6 * 8 ^ 47:
      { { 3754310983, 2829438112, 3947637114 },
        { 2617184648, 3754310983, 3119630359 },
        { 2102395010, 2617184648, 2313448358 } },
      // Matrix for nskip = 7 * 8 ^ 47:
      { { 2033651727, 3918276995, 2324222273 },
        { 2517499860, 2033651727, 3237758154 },
        { 3966641526, 2517499860, 2296152269 } },
      // Matrix for nskip = 1 * 8 ^ 48:
      { { 232906611, 3873338256, 4051554873 },
        { 3027413363, 232906611, 3159432673 },
        { 3872967050, 3027413363, 987156327 } },
      // Matrix for nskip = 2 * 8 ^ 48:
      { { 1160686753, 3676603152, 1635979789 },
        { 1447386846, 1160686753, 2670438424 },
        { 816212890, 1447386846, 4288868534 } },
      // Matrix for nskip = 3 * 8 ^ 48:
      { { 232406022, 1438391315, 351811028 },
        { 792615675, 232406022, 2249558877 },
        { 4000461186, 792615675, 3773572468 } },
      // Matrix for nskip = 4 * 8 ^ 48:
      { { 3825238244, 1445162354, 2362389441 },
        { 3440193648, 3825238244, 3520937545 },
        { 2652790808, 3440193648, 405299994 } },
      // Matrix for nskip = 5 * 8 ^ 48:
      { { 1153297111, 1584881761, 3755481813 },
        { 2565782177, 1153297111, 595979811 },
        { 3520546605, 2565782177, 1485833084 } },
      // Matrix for nskip = 6 * 8 ^ 48:
      { { 2264796250, 1995295374, 4156333842 },
        { 4182411213, 2264796250, 3692855966 },
        { 2398102705, 4182411213, 135106935 } },
      // Matrix for nskip = 7 * 8 ^ 48:
      { { 1510709042, 3654924984, 4137143940 },
        { 3411234559, 1510709042, 3713963703 },
        { 3111723660, 3411234559, 3580357515 } },
      // Matrix for nskip = 1 * 8 ^ 49:
      { { 1984094858, 532165989, 2027397575 },
        { 1455977136, 1984094858, 2433255524 },
        { 1039994763, 1455977136, 2069333087 } },
      // Matrix for nskip = 2 * 8 ^ 49:
      { { 3680843319, 2332949611, 3516795313 },
        { 2033851810, 3680843319, 3843367307 },
        { 3686294589, 2033851810, 3912995069 } },
      // Matrix for nskip = 3 * 8 ^ 49:
      { { 2570307024, 165497191, 3880130435 },
        { 540713030, 2570307024, 1096034689 },
        { 3859799631, 540713030, 3714945286 } },
      // Matrix for nskip = 4 * 8 ^ 49:
      { { 967423689, 1724183394, 635932799 },
        { 641380480, 967423689, 2145297779 },
        { 1723000412, 641380480, 455633660 } },
      // Matrix for nskip = 5 * 8 ^ 49:
      { { 2807559499, 2180128950, 1968769828 },
        { 1885526032, 2807559499, 3568246807 },
        { 1874951461, 1885526032, 2399805320 } },
      // Matrix for nskip = 6 * 8 ^ 49:
      { { 743327961, 3817146458, 2078921540 },
        { 752843557, 743327961, 3382133383 },
        { 1546279541, 752843557, 4269455046 } },
      // Matrix for nskip = 7 * 8 ^ 49:
      { { 355924266, 3865252236, 3092467664 },
        { 2414940441, 355924266, 3290161562 },
        { 493050060, 2414940441, 2727946913 } },
      // Matrix for nskip = 1 * 8 ^ 50:
      { { 2130938335, 1534972306, 2511584766 },
        { 273828453, 2130938335, 3112810093 },
        { 4084843716, 273828453, 1399334152 } },
      // Matrix for nskip = 2 * 8 ^ 50:
      { { 168278549, 541167592, 190177712 },
        { 403188859, 168278549, 2092073970 },
        { 58789558, 403188859, 2777887189 } },
      // Matrix for nskip = 3 * 8 ^ 50:
      { { 664028138, 360061317, 3240810721 },
        { 3427777045, 664028138, 589375738 },
        { 1247469758, 3427777045, 4103288151 } },
      // Matrix for nskip = 4 * 8 ^ 50:
      { { 634843389, 4082275720, 2092828966 },
        { 351187677, 634843389, 1312056270 },
        { 3347241070, 351187677, 2417192332 } },
      // Matrix for nskip = 5 * 8 ^ 50:
      { { 3269976890, 3103127568, 907107523 },
        { 3154851935, 3269976890, 1078491382 },
        { 1129461097, 3154851935, 3960596933 } },
      // Matrix for nskip = 6 * 8 ^ 50:
      { { 1155790154, 89494164, 1039763155 },
        { 393005763, 1155790154, 2648470077 },
        { 2830413843, 393005763, 1280581785 } },
      // Matrix for nskip = 7 * 8 ^ 50:
      { { 2340682307, 3775335435, 3604492026 },
        { 4198859651, 2340682307, 1392463605 },
        { 1917833692, 4198859651, 2536657316 } },
      // Matrix for nskip = 1 * 8 ^ 51:
      { { 443276110, 1113643788, 271102234 },
        { 3083745876, 443276110, 3370743767 },
        { 4200577503, 3083745876, 3298601960 } },
      // Matrix for nskip = 2 * 8 ^ 51:
      { { 3533393557, 764977733, 3400275098 },
        { 144639933, 3533393557, 2646475951 },
        { 77963866, 144639933, 3794766611 } },
      // Matrix for nskip = 3 * 8 ^ 51:
      { { 914011908, 1379977154, 3635095314 },
        { 4096393357, 914011908, 962932343 },
        { 410940557, 4096393357, 2300259911 } },
      // Matrix for nskip = 4 * 8 ^ 51:
      { { 4064854722, 1198665008, 2872196602 },
        { 3274748603, 4064854722, 4164637970 },
        { 4238693771, 3274748603, 1981721347 } },
      // Matrix for nskip = 5 * 8 ^ 51:
      { { 658075764, 868441731, 631337149 },
        { 3000164892, 658075764, 3213078611 },
        { 2494369285, 3000164892, 1969086166 } },
      // Matrix for nskip = 6 * 8 ^ 51:
      { { 1202027740, 1218291611, 251455117 },
        { 1904530179, 1202027740, 1121637945 },
        { 2014861157, 1904530179, 3331497439 } },
      // Matrix for nskip = 7 * 8 ^ 51:
      { { 860183345, 3722900937, 2577917907 },
        { 184407828, 860183345, 3959662009 },
        { 1130199284, 184407828, 1996334021 } },
      // Matrix for nskip = 1 * 8 ^ 52:
      { { 2279220396, 2355957139, 1417574285 },
        { 885864931, 2279220396, 1344421653 },
        { 1895527787, 885864931, 3726919367 } },
      // Matrix for nskip = 2 * 8 ^ 52:
      { { 2898100178, 2427331008, 348923199 },
        { 3175444953, 2898100178, 4290541487 },
        { 246118669, 3175444953, 3410622769 } },
      // Matrix for nskip = 3 * 8 ^ 52:
      { { 55373162, 3987120186, 2739617092 },
        { 488341106, 55373162, 3877861726 },
        { 468535899, 488341106, 2277317349 } },
      // Matrix for nskip = 4 * 8 ^ 52:
      { { 284442065, 4064194676, 2295560707 },
        { 4182706556, 284442065, 3696899246 },
        { 1201342255, 4182706556, 1145356382 } },
      // Matrix for nskip = 5 * 8 ^ 52:
      { { 854963956, 3894612396, 2185360428 },
        { 3161673906, 854963956, 1200638109 },
        { 808492591, 3161673906, 1983142708 } },
      // Matrix for nskip = 6 * 8 ^ 52:
      { { 2146747531, 896368240, 1430380976 },
        { 1613992473, 2146747531, 901075807 },
        { 2390399884, 1613992473, 270201416 } },
      // Matrix for nskip = 7 * 8 ^ 52:
      { { 1033390767, 4214343810, 3176316290 },
        { 238941078, 1033390767, 957806905 },
        { 3045719234, 238941078, 3992043804 } },
      // Matrix for nskip = 1 * 8 ^ 53:
      { { 656615546, 442908965, 3724738272 },
        { 1624967553, 656615546, 798014134 },
        { 1157949454, 1624967553, 496247378 } },
      // Matrix for nskip = 2 * 8 ^ 53:
      { { 265689579, 675056541, 3009083380 },
        { 3820679930, 265689579, 2961990151 },
        { 562287964, 3820679930, 1853486796 } },
      // Matrix for nskip = 3 * 8 ^ 53:
      { { 3115797761, 1090045712, 399035362 },
        { 452658959, 3115797761, 3053809839 },
        { 3970000518, 452658959, 2899502994 } },
      // Matrix for nskip = 4 * 8 ^ 53:
      { { 1675739167, 2319843005, 760605578 },
        { 4161492847, 1675739167, 226142150 },
        { 1017447188, 4161492847, 3431158427 } },
      // Matrix for nskip = 5 * 8 ^ 53:
      { { 1814415714, 3446998641, 1659100687 },
        { 299018378, 1814415714, 3661851369 },
        { 2777381296, 299018378, 730677422 } },
      // Matrix for nskip = 6 * 8 ^ 53:
      { { 497640593, 3005114205, 2309875696 },
        { 3522463659, 497640593, 590519806 },
        { 855175401, 3522463659, 1973739759 } },
      // Matrix for nskip = 7 * 8 ^ 53:
      { { 2668363194, 344864589, 270881279 },
        { 981182918, 2668363194, 1986955069 },
        { 956851812, 981182918, 3901969881 } },
      // Matrix for nskip = 1 * 8 ^ 54:
      { { 1759873736, 2334568602, 2154570180 },
        { 1812793060, 1759873736, 2111094408 },
        { 1168460586, 1812793060, 2495653141 } },
      // Matrix for nskip = 2 * 8 ^ 54:
      { { 317621194, 868104288, 664971082 },
        { 2340275074, 317621194, 2168960688 },
        { 725706104, 2340275074, 3532023115 } },
      // Matrix for nskip = 3 * 8 ^ 54:
      { { 3585587043, 2378713321, 2463381051 },
        { 2919944362, 3585587043, 1464119531 },
        { 3588451359, 2919944362, 1912059035 } },
      // Matrix for nskip = 4 * 8 ^ 54:
      { { 3926931954, 2907684453, 615601328 },
        { 1132340715, 3926931954, 676995757 },
        { 1154819290, 1132340715, 1662727700 } },
      // Matrix for nskip = 5 * 8 ^ 54:
      { { 918221359, 2912639129, 1883551759 },
        { 4114315731, 918221359, 1703365082 },
        { 2391341541, 4114315731, 3946112236 } },
      // Matrix for nskip = 6 * 8 ^ 54:
      { { 2495152894, 362016218, 2659927506 },
        { 1721141770, 2495152894, 2577006096 },
        { 73701594, 1721141770, 2683266250 } },
      // Matrix for nskip = 7 * 8 ^ 54:
      { { 1978338540, 424481557, 341918993 },
        { 3862312182, 1978338540, 436776944 },
        { 566398653, 3862312182, 1196282660 } },
      // Matrix for nskip = 1 * 8 ^ 55:
      { { 3921782078, 3376494857, 2969567377 },
        { 475345024, 3921782078, 4206379953 },
        { 1795936544, 475345024, 934679595 } },
      // Matrix for nskip = 2 * 8 ^ 55:
      { { 3119292228, 741613041, 2083352304 },
        { 1047885963, 3119292228, 1581078542 },
        { 1065969969, 1047885963, 661718928 } },
      // Matrix for nskip = 3 * 8 ^ 55:
      { { 3193382049, 573569291, 3880461974 },
        { 1401117517, 3193382049, 335339494 },
        { 2267936793, 1401117517, 2098160992 } },
      // Matrix for nskip = 4 * 8 ^ 55:
      { { 3643472111, 2870554228, 3995474529 },
        { 3804264051, 3643472111, 1366457944 },
        { 1246805564, 3804264051, 993186530 } },
      // Matrix for nskip = 5 * 8 ^ 55:
      { { 2693567720, 1775121226, 3619720132 },
        { 1859333754, 2693567720, 2377603858 },
        { 2682882800, 1859333754, 532216705 } },
      // Matrix for nskip = 6 * 8 ^ 55:
      { { 2520305729, 3279882298, 2663387463 },
        { 1160802169, 2520305729, 1363372142 },
        { 92806587, 1160802169, 3842743664 } },
      // Matrix for nskip = 7 * 8 ^ 55:
      { { 1402382861, 2128689614, 967911190 },
        { 1124729601, 1402382861, 1908361865 },
        { 2731098528, 1124729601, 3607037865 } },
      // Matrix for nskip = 1 * 8 ^ 56:
      { { 796711791, 3878204845, 3160293932 },
        { 255632881, 796711791, 3778927111 },
        { 3472564181, 255632881, 388382377 } },
      // Matrix for nskip = 2 * 8 ^ 56:
      { { 1776984101, 1742284034, 3449763933 },
        { 1349354417, 1776984101, 1264780832 },
        { 715722511, 1349354417, 1213319489 } },
      // Matrix for nskip = 3 * 8 ^ 56:
      { { 3231284907, 2981539575, 3476263944 },
        { 3070932389, 3231284907, 4183678140 },
        { 4073569309, 3070932389, 1095273395 } },
      // Matrix for nskip = 4 * 8 ^ 56:
      { { 4261866865, 1914382786, 201872335 },
        { 614207188, 4261866865, 1853554849 },
        { 2046042882, 614207188, 3193186353 } },
      // Matrix for nskip = 5 * 8 ^ 56:
      { { 4179922982, 2821238835, 3720886954 },
        { 1712333408, 4179922982, 2683472927 },
        { 2838663503, 1712333408, 3967303913 } },
      // Matrix for nskip = 6 * 8 ^ 56:
      { { 2701381139, 3664845069, 2023182114 },
        { 2420177830, 2701381139, 1924402503 },
        { 3429706463, 2420177830, 2803635446 } },
      // Matrix for nskip = 7 * 8 ^ 56:
      { { 4122275824, 2032046756, 1051494202 },
        { 2221023672, 4122275824, 722305627 },
        { 547107197, 2221023672, 2228432272 } },
      // Matrix for nskip = 1 * 8 ^ 57:
      { { 2210205512, 2847073169, 3324925707 },
        { 1251969297, 2210205512, 3491451503 },
        { 470400916, 1251969297, 2184392547 } },
      // Matrix for nskip = 2 * 8 ^ 57:
      { { 1523590942, 2391111113, 68341529 },
        { 295466806, 1523590942, 4143310876 },
        { 3527253079, 295466806, 4059123142 } },
      // Matrix for nskip = 3 * 8 ^ 57:
      { { 3667945349, 431655152, 2687669798 },
        { 1584045661, 3667945349, 2642149990 },
        { 2169193555, 1584045661, 2115882504 } },
      // Matrix for nskip = 4 * 8 ^ 57:
      { { 1406902110, 3735012720, 1774518130 },
        { 1814959027, 1406902110, 1560544267 },
        { 346472965, 1814959027, 964257199 } },
      // Matrix for nskip = 5 * 8 ^ 57:
      { { 2718256179, 4102604932, 4277499868 },
        { 3681834937, 2718256179, 4201441381 },
        { 1715953284, 3681834937, 1112580533 } },
      // Matrix for nskip = 6 * 8 ^ 57:
      { { 992368492, 2710608111, 2674694909 },
        { 3754191262, 992368492, 1060465580 },
        { 2574962339, 3754191262, 60540513 } },
      // Matrix for nskip = 7 * 8 ^ 57:
      { { 1719209658, 2756912996, 4193028814 },
        { 4256860235, 1719209658, 3552491408 },
        { 1070852068, 4256860235, 3586319939 } },
      // Matrix for nskip = 1 * 8 ^ 58:
      { { 855309653, 4208503105, 1518467541 },
        { 2025248418, 855309653, 4148125749 },
        { 1349947330, 2025248418, 1168504873 } },
      // Matrix for nskip = 2 * 8 ^ 58:
      { { 2375338156, 3629519168, 409696181 },
        { 252401654, 2375338156, 3992097193 },
        { 2793725401, 252401654, 1350184085 } },
      // Matrix for nskip = 3 * 8 ^ 58:
      { { 2856909490, 1191427722, 3088217623 },
        { 3529719882, 2856909490, 204704202 },
        { 1918223997, 3529719882, 2282426993 } },
      // Matrix for nskip = 4 * 8 ^ 58:
      { { 873141039, 3885583138, 361604799 },
        { 3554143374, 873141039, 894746180 },
        { 1919765327, 3554143374, 876210854 } },
      // Matrix for nskip = 5 * 8 ^ 58:
      { { 652228317, 107568976, 2576316170 },
        { 790910548, 652228317, 1352723275 },
        { 1091561936, 790910548, 1291982092 } },
      // Matrix for nskip = 6 * 8 ^ 58:
      { { 3452179482, 4206785268, 2363956864 },
        { 2619693001, 3452179482, 54522393 },
        { 4241208723, 2619693001, 2583115784 } },
      // Matrix for nskip = 7 * 8 ^ 58:
      { { 547180410, 904354606, 3387638559 },
        { 2429997228, 547180410, 1350013492 },
        { 4258335371, 2429997228, 1689405508 } },
      // Matrix for nskip = 1 * 8 ^ 59:
      { { 246368794, 1703793169, 2317362874 },
        { 2300930144, 246368794, 2560214589 },
        { 2016163623, 2300930144, 1504276775 } },
      // Matrix for nskip = 2 * 8 ^ 59:
      { { 1574610921, 2147546631, 4103450226 },
        { 107416526, 1574610921, 1773803959 },
        { 1402542742, 107416526, 550063800 } },
      // Matrix for nskip = 3 * 8 ^ 59:
      { { 2364572364, 3566983915, 468574833 },
        { 3825719596, 2364572364, 3679744745 },
        { 2445832362, 3825719596, 1752846470 } },
      // Matrix for nskip = 4 * 8 ^ 59:
      { { 363388665, 592194244, 1746615522 },
        { 2637234667, 363388665, 4031408742 },
        { 2895130475, 2637234667, 296510335 } },
      // Matrix for nskip = 5 * 8 ^ 59:
      { { 208003776, 91247399, 1566440482 },
        { 2144494056, 208003776, 1022614336 },
        { 2439698058, 2144494056, 4292230862 } },
      // Matrix for nskip = 6 * 8 ^ 59:
      { { 2823846657, 4257316854, 3340983277 },
        { 218486499, 2823846657, 3142931989 },
        { 2351513088, 218486499, 3471595726 } },
      // Matrix for nskip = 7 * 8 ^ 59:
      { { 3562083579, 3058668461, 1588504573 },
        { 2047897620, 3562083579, 1674831117 },
        { 965798968, 2047897620, 1212961148 } },
      // Matrix for nskip = 1 * 8 ^ 60:
      { { 3997368560, 3047771871, 3178383826 },
        { 1160174754, 3997368560, 4027094919 },
        { 1234984211, 1160174754, 4226264344 } },
      // Matrix for nskip = 2 * 8 ^ 60:
      { { 3303179301, 4243968063, 3235964171 },
        { 1776841674, 3303179301, 2867287469 },
        { 1500495759, 1776841674, 1708226553 } },
      // Matrix for nskip = 3 * 8 ^ 60:
      { { 1859001036, 2962890971, 2391336228 },
        { 1694166096, 1859001036, 593465055 },
        { 1377070160, 1694166096, 2513927224 } },
      // Matrix for nskip = 4 * 8 ^ 60:
      { { 1482944153, 3192311574, 354466071 },
        { 3932773012, 1482944153, 389193591 },
        { 3350181058, 3932773012, 3398059015 } },
      // Matrix for nskip = 5 * 8 ^ 60:
      { { 3478906695, 565159378, 3563812138 },
        { 2637114657, 3478906695, 1117546206 },
        { 909882870, 2637114657, 2819889512 } },
      // Matrix for nskip = 6 * 8 ^ 60:
      { { 3406907174, 3949116664, 536198867 },
        { 3969663510, 3406907174, 915271858 },
        { 1537382635, 3969663510, 1154112679 } },
      // Matrix for nskip = 7 * 8 ^ 60:
      { { 1488624292, 2799268852, 4148140705 },
        { 2326140461, 1488624292, 2413540258 },
        { 3071215524, 2326140461, 1918378675 } },
      // Matrix for nskip = 1 * 8 ^ 61:
      { { 640968550, 3226860971, 922372912 },
        { 1254989667, 640968550, 2383815228 },
        { 2027371896, 1254989667, 2925300409 } },
      // Matrix for nskip = 2 * 8 ^ 61:
      { { 2313146046, 3910187183, 1377591475 },
        { 1689291784, 2313146046, 4255405993 },
        { 1650609719, 1689291784, 1897624297 } },
      // Matrix for nskip = 3 * 8 ^ 61:
      { { 3547277681, 272901338, 2842437455 },
        { 1746901015, 3547277681, 4272690944 },
        { 2000451168, 1746901015, 417326012 } },
      // Matrix for nskip = 4 * 8 ^ 61:
      { { 3656310954, 882924050, 2702189958 },
        { 3185020283, 3656310954, 1923190496 },
        { 2449669145, 3185020283, 4235849984 } },
      // Matrix for nskip = 5 * 8 ^ 61:
      { { 3659342577, 1641516630, 2539516650 },
        { 2275633679, 3659342577, 167207049 },
        { 1798452176, 2275633679, 1651075902 } },
      // Matrix for nskip = 6 * 8 ^ 61:
      { { 1932812117, 4060977130, 4129096120 },
        { 4247470915, 1932812117, 1398719693 },
        { 101546088, 4247470915, 103612315 } },
      // Matrix for nskip = 7 * 8 ^ 61:
      { { 3420997084, 2682742609, 1335389027 },
        { 3883479775, 3420997084, 1501959755 },
        { 1647828648, 3883479775, 3801963100 } },
      // Matrix for nskip = 1 * 8 ^ 62:
      { { 377232416, 1498446142, 4229103619 },
        { 3926377906, 377232416, 600268838 },
        { 511317726, 3926377906, 216160452 } },
      // Matrix for nskip = 2 * 8 ^ 62:
      { { 1969399344, 3273966859, 4220943579 },
        { 3952111894, 1969399344, 575096961 },
        { 3815277103, 3952111894, 792177412 } },
      // Matrix for nskip = 3 * 8 ^ 62:
      { { 1779275464, 2781126556, 2466688033 },
        { 1573179329, 1779275464, 2922475892 },
        { 3416534728, 1573179329, 2830179495 } },
      // Matrix for nskip = 4 * 8 ^ 62:
      { { 2957238169, 1410010554, 1523740068 },
        { 3949237584, 2957238169, 74149658 },
        { 2564746147, 3949237584, 2557663578 } },
      // Matrix for nskip = 5 * 8 ^ 62:
      { { 2132274169, 3311898863, 3609324462 },
        { 3719565953, 2132274169, 3678195166 },
        { 284265108, 3719565953, 4278461540 } },
      // Matrix for nskip = 6 * 8 ^ 62:
      { { 2540404064, 675336157, 1264339488 },
        { 29787664, 2540404064, 3475225382 },
        { 591030331, 29787664, 1242712946 } },
      // Matrix for nskip = 7 * 8 ^ 62:
      { { 3161673998, 796026877, 3360592842 },
        { 1326727008, 3161673998, 3697232048 },
        { 330692835, 1326727008, 3520194976 } },
      // Matrix for nskip = 1 * 8 ^ 63:
      { { 3377318569, 1927835240, 2556102508 },
        { 3022040116, 3377318569, 2549406364 },
        { 2387074241, 3022040116, 1477293711 } },
      // Matrix for nskip = 2 * 8 ^ 63:
      { { 257306870, 1748489735, 547809226 },
        { 3708493374, 257306870, 4183546362 },
        { 4435502, 3708493374, 1607696753 } },
      // Matrix for nskip = 3 * 8 ^ 63:
      { { 2404623323, 4132820260, 1615062394 },
        { 1844725476, 2404623323, 570318859 },
        { 2839043606, 1844725476, 1375837008 } },
      // Matrix for nskip = 4 * 8 ^ 63:
      { { 4076910933, 930542270, 3433720143 },
        { 675898567, 4076910933, 892406741 },
        { 5625977, 675898567, 2412946221 } },
      // Matrix for nskip = 5 * 8 ^ 63:
      { { 3143857447, 1394551864, 4202002846 },
        { 973255696, 3143857447, 3968325674 },
        { 2327635494, 973255696, 1217794308 } },
      // Matrix for nskip = 6 * 8 ^ 63:
      { { 2448094751, 2840824567, 1627957632 },
        { 1469753239, 2448094751, 4063581553 },
        { 3388871077, 1469753239, 3521935017 } },
      // Matrix for nskip = 7 * 8 ^ 63:
      { { 1593620760, 1002861683, 2173731154 },
        { 3577868319, 1593620760, 39982755 },
        { 3566899985, 3577868319, 207847804 } },
      // Matrix for nskip = 1 * 8 ^ 64:
      { { 2146755704, 2635194649, 1512299181 },
        { 3860948634, 2146755704, 3641948767 },
        { 3872596381, 3860948634, 1350534123 } },
      // Matrix for nskip = 2 * 8 ^ 64:
      { { 2650974852, 2792146306, 1334806440 },
        { 3511147120, 2650974852, 3467471104 },
        { 2826608091, 3511147120, 3185213777 } },
      // Matrix for nskip = 3 * 8 ^ 64:
      { { 4154591539, 929373784, 2614972987 },
        { 617404183, 4154591539, 1283899280 },
        { 637243382, 617404183, 1889016496 } },
      // Matrix for nskip = 4 * 8 ^ 64:
      { { 1735625475, 2923145251, 885546512 },
        { 926645131, 1735625475, 2358202840 },
        { 3503695789, 926645131, 2511917556 } },
      // Matrix for nskip = 5 * 8 ^ 64:
      { { 3169405477, 2071788237, 2197719325 },
        { 3454276765, 3169405477, 354513440 },
        { 3433509316, 3454276765, 3884018107 } },
      // Matrix for nskip = 6 * 8 ^ 64:
      { { 154139786, 961249414, 3740576106 },
        { 1113118249, 154139786, 3880685356 },
        { 177260972, 1113118249, 1811433812 } },
      // Matrix for nskip = 7 * 8 ^ 64:
      { { 2636917497, 3922853891, 3167851814 },
        { 911696899, 2636917497, 1449426394 },
        { 2845905825, 911696899, 1062710260 } } }
};

} // namespace mrg32k3a_impl
} // namespace oneapi::mkl::rng::device::detail

#endif // _MKL_RNG_DEVICE_MRG32K3A_SKIP_AHEAD_MATRIX_HPP_
