<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="msxsl"
                xmlns:exsl="http://exslt.org/common"
                exsl:keep_exsl_namespace=""
    syntax="norules"
  xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
  xmlns:int="http://www.w3.org/2001/XMLSchema#int"
  xmlns:double="http://www.w3.org/2001/XMLSchema#double"
  xmlns:str="http://exslt.org/strings"
                xmlns:fnc="urn:functions">
  <xsl:import href="config://include/gpu_common_functions.inc"/>
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="gpuHotspots">false</xsl:param>
  <xsl:param name="gpuOffload">false</xsl:param>
  <xsl:template match="/">
    <knobs>
      <xsl:variable name="collectGTPin" select="(exsl:ctx('gpuProfilingModeAtk', '') = 'characterization' and exsl:ctx('metricsGroup', '') = 'instruction-count') or exsl:ctx('gpuProfilingModeAtk', '') = 'source-analysis'"/>
      <collectGTPin>
        <xsl:value-of select="$collectGTPin"/>
      </collectGTPin>
      <programming_apis>
        <xsl:choose>
          <xsl:when test="exsl:ctx('targetOS')='MacOSX'">
            <collectorKnob knob="collectGpuMetal"><xsl:value-of select="exsl:ctx('gpuOpenCLCollection', 0)"/></collectorKnob>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="gpuVariables" select="document('config://analysis_type/include/gpu_variables.xsl')"/>
            <xsl:variable name="gpuTargets" select="$gpuVariables//variables/gpuTargets"/>
            <xsl:variable name="knobValues">
              <xsl:for-each select="exsl:node-set($gpuTargets)/gpuTarget">
                <xsl:variable name="targetGPUBDF" select="string(gpuAdapterToUse)"/>
                <value>
                  <xsl:value-of select="$targetGPUBDF"/>
                  <xsl:text>|</xsl:text>
                  <xsl:choose>
                    <xsl:when test="$collectGTPin = 'true'">true</xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="exsl:ctx('gpuOpenCLCollection', 'true')"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </value>
              </xsl:for-each>
              </xsl:variable>
            <collectorKnob knob="collectGpuOpenCl">
              <xsl:value-of select="fnc:node_join($knobValues)"/>
            </collectorKnob>
          </xsl:otherwise>
        </xsl:choose>
      </programming_apis>
      <inline>
        <xsl:choose>
          <xsl:when test="$collectGTPin = 'true'">
            <collectorKnob knob="showInlinesByDefault">true</collectorKnob>
            <collectorKnob knob="hideSystemByDefault">true</collectorKnob>
          </xsl:when>
          <xsl:otherwise>
            <collectorKnob knob="showInlinesByDefault">false</collectorKnob>
          </xsl:otherwise>
        </xsl:choose>
      </inline>
      <xsl:variable name="runtool" select="document('config://analysis_type/include/runtool.xsl')"/>
      <xsl:variable name="runtoolToUse" select="$runtool//variables/runtoolToUse"/>
      <hostCollector>
        <xsl:choose>
          <xsl:when test="$runtoolToUse='runss'">
            <xsl:if test="not(exsl:ctx('isTPSSAvailable', 0)) and not(exsl:ctx('isPtraceAvailable', 0))">
              <xsl:value-of select="exsl:error('%RunssBasicHotspotsNotSupported')"/>
            </xsl:if>
            <xsl:if test="exsl:ctx('isPtraceScopeLimited', 0)">
              <xsl:value-of select="exsl:error('%RunssPtraceScopeLimited')"/>
            </xsl:if>
            <collectorKnob knob="collectSamplesMode">
              <xsl:choose>
                <xsl:when test="$collectGTPin = 'true'">
                  <xsl:text>off</xsl:text>
                </xsl:when>
                <xsl:when test="$gpuOffload = 'true' and exsl:ctx('enableStackCollect', 0)">
                  <xsl:text>stack</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>nostack</xsl:text>
                </xsl:otherwise>
              </xsl:choose>
            </collectorKnob>
            <collectorKnob knob="samplingInterval">10</collectorKnob>
            <collectorKnob knob="stackStitching">false</collectorKnob>
          </xsl:when>
          <xsl:otherwise>
            <xsl:copy-of select="document('config://analysis_type/include/prerequisites.xsl')/pmu_prerequisites/*"/>
            <xsl:variable name="MainEvents" select="document('config://analysis_type/include/common_events.xsl')/events/cpi/text()"/>
            <collectorKnob knob="pmuEventConfig"><xsl:value-of select="$MainEvents"/></collectorKnob>
            <xsl:if test="$gpuOffload = 'true'">
              <collectorKnob knob="enableStackCollection"><xsl:value-of select="exsl:ctx('enableStackCollect', 0)"/></collectorKnob>
            </xsl:if>
            <xsl:if test="$gpuHotspots = 'true'">
              <collectorKnob knob="eventMode">all</collectorKnob>
              <boolean:collectorKnob knob="enableCSwitch">false</boolean:collectorKnob>
              <collectorKnob knob="pmuSamplingInterval"><xsl:value-of select="format-number(exsl:ctx('samplingInterval', 1), '#.####')"/></collectorKnob>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>
      </hostCollector>
      <bandwidth>
        <xsl:if test="exsl:ctx('collectMemoryBW', 0) and
          ((exsl:ctx('gpuProfilingModeAtk') = 'characterization' and $gpuHotspots = 'true') or
          $gpuOffload = 'true')">
          <xsl:choose>
            <xsl:when test="$runtoolToUse='runss'">
              <xsl:value-of select="exsl:error('%BandwidthIsNotWorkWithoutSampling')"/>
            </xsl:when>
            <xsl:otherwise>
              <boolean:collectorKnob knob="collectMemBandwidth">true</boolean:collectorKnob>
              <collectorKnob knob="dramBandwidthLimits">true</collectorKnob>
              <xsl:value-of select="exsl:warning('%BandwidthLimitsCollectionIsEnabledByDefaultWarning')"/>
              <xsl:if test="$gpuHotspots = 'true'">
                <collectorKnob knob="collectPCIeBandwidth">true</collectorKnob>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </bandwidth>
      <cpuGPUBandwidth>
        <xsl:if test="exsl:ctx('collectCPUGPUBandwidth', 0) and $gpuOffload = 'true'">
          <xsl:choose>
            <xsl:when test="$runtoolToUse='runss'">
              <xsl:value-of select="exsl:error('%CPUGPUBandwidthIsNotWorkWithoutSampling')"/>
            </xsl:when>
            <xsl:otherwise>
              <boolean:collectorKnob knob="collectCPUGPUBandwidth">true</boolean:collectorKnob>
              <boolean:collectorKnob knob="collectMemBandwidth">true</boolean:collectorKnob>
              <collectorKnob knob="dramBandwidthLimits">true</collectorKnob>
              <xsl:value-of select="exsl:warning('%BandwidthLimitsCollectionIsEnabledByDefaultWarning')"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </cpuGPUBandwidth>
    </knobs>
  </xsl:template>
</xsl:stylesheet>
