# Copyright (C) 2023 Intel Corporation
# SPDX-License-Identifier: MIT

import pandas as pd

from mpp.core.types import EventInfoDataFrameColumns as eidc


class EventInfoGenerator:

    def __init__(self, df: pd.DataFrame):
        self.verify_preconditions(df)
        self._df = df
        self._get_event_info()

    @staticmethod
    def verify_preconditions(df: pd.DataFrame):
        if eidc.NAME not in df.columns or eidc.DEVICE not in df.columns:
            raise NameError(f"'{eidc.NAME}' and '{eidc.DEVICE}' required in dataframe")

    @property
    def event_info(self):
        return self._event_info

    def _get_event_info(self):
        self._event_info = self._df[[eidc.NAME, eidc.DEVICE]].drop_duplicates().sort_values(by=[eidc.NAME, eidc.DEVICE],
                                                                                            axis='rows')
