# Copyright (C) 2024 Intel Corporation
# SPDX-License-Identifier: MIT

from dataclasses import dataclass, field
from typing import Dict, List, Any

@dataclass
class SystemInformation:
    processor_features: Dict[str, Dict[str, any]] = field(default_factory=dict)
    system_features: Dict[str, Any] = field(default_factory=dict)
    uncore_units: Dict[str, Any] = field(default_factory=dict)
    ref_tsc: int = 0
    unique_core_types: List[str] = field(default_factory=list)
    has_modules: bool = False


@dataclass
class ApiArgs:
    from mpp.core.views import ViewAggregationLevel
    from mpp.core.metric_computer import MetricComputer
    from mpp.core.types import EventInfoDataFrame
    from cli.writers.base import OutputWriter

    system_information: SystemInformation = field(default_factory=SystemInformation)
    event_info: EventInfoDataFrame = None

    # view information
    retire_latency: bool = False
    aggregation_levels: List[ViewAggregationLevel] = field(default_factory=list)
    metric_computer_map: Dict[str, MetricComputer] = field(default_factory=dict)  # field(default_factory=lambda: ({
    # 'null': _NullMetricComputer([])}))
    
    # output information
    is_parallel: bool = False
    no_detail_views: bool = False
    percentile: int = None
    output_directory: str = ''
    output_prefix: str = ''
    output_writers: List[OutputWriter] = field(default_factory=list)
