/*
 * Copyright (C) 2005 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/


#ifndef _SYS_INFO_H_
#define _SYS_INFO_H_

#include "lwpmudrv_defines.h"

typedef struct __generic_ioctl {
    U32    size;
    S32    ret;
    U64    rsv[3];
} GENERIC_IOCTL;

#define GENERIC_IOCTL_size(gio)     (gio)->size
#define GENERIC_IOCTL_ret(gio)      (gio)->ret

//
// This one is unusual in that it's really a variable
// size. The system_info field is just a easy way
// to access the base information, but the actual size
// when used tends to be much larger that what is
// shown here.
//
typedef struct __system_info {
    GENERIC_IOCTL gen;
    VTSA_SYS_INFO sys_info;
} IOCTL_SYS_INFO;

#define  IOCTL_SYS_INFO_gen(isi)         (isi)->gen
#define  IOCTL_SYS_INFO_sys_info(isi)    (isi)->sys_info

extern  U32   SYS_INFO_Build (void);
extern  void  SYS_INFO_Transfer (PVOID buf_usr_to_drv, unsigned long len_usr_to_drv);
extern  void  SYS_INFO_Destroy (void);

#endif
