/*COPYRIGHT**
 *
 * Copyright (C) 2019 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.















**COPYRIGHT*/





#ifndef _PMU_LIST_H_INC_
#define _PMU_LIST_H_INC_

extern U32 drv_type;

/************************************************************/
/*
 * PMU list API for checking valid PMU list
 *
 ************************************************************/

/*!
 * @fn         DRV_BOOL PMU_LIST_Check_MSR (U32)
 *
 * @brief      Search the MSR address in the list
 *
 * @param      MSR address to be checked
 *
 * @return     TRUE if the MSR address is found in the list,
 *             FALSE otherwise
 */
extern DRV_BOOL PMU_LIST_Check_MSR(U32 msr_id);

/*!
 * @fn         DRV_BOOL PMU_LIST_Check_PCI (U8, U8, U8, U32)
 *
 * @brief      Search the PCI programming info in the list
 *
 * @param      bus_id - PCI bus id
 *             device_id - PCI device id
 *             func_id - PCI function id
 *             offset - PCI offset
 *
 * @return     TRUE if the PCI information is found in the list,
 *             FALSE otherwise
 */
extern DRV_BOOL
PMU_LIST_Check_PCI(U8 bus_id, U8 device_id, U8 func_id, U32 offset);

/*!
 * @fn         DRV_BOOL PMU_LIST_Check_MMIO (PMU_MMIO_BAR_INFO_NODE,
 *                                           PMU_MMIO_BAR_INFO_NODE,
 *                                           U32)
 *
 * @brief      Search the MMIO programming info in the list
 *
 * @param      primary - pimary MMIO BAR programming info
 *             secondary - secondary MMIO BAR programming info
 *             offset - MMIO offset
 *
 * @return     TRUE if the MMIO information is found in the list,
 *             FALSE otherwise
 */
extern DRV_BOOL
PMU_LIST_Check_MMIO(PMU_MMIO_BAR_INFO_NODE primary,
		    PMU_MMIO_BAR_INFO_NODE secondary,
		    U32                    offset);

/*!
 * @fn         OS_STATUS PMU_LIST_Initialize (S32 *)
 * @brief      Detect the CPU id and locate the applicable PMU list
 *
 * @param      index value of the allowlist. -1 if not found.
 *
 * @return     OS_SUCCESS
 */
extern OS_STATUS PMU_LIST_Initialize(S32 *idx);

/*!
 * @fn         OS_STATUS PMU_LIST_Build_MSR_List (void)
 * @brief      Build the MSR search tree
 *
 * @param      None
 *
 * @return     OS_SUCCESS
 */
extern OS_STATUS PMU_LIST_Build_MSR_List(void);

/*!
 * @fn         OS_STATUS PMU_LIST_Build_PCI_List (void)
 * @brief      Build the PCI search tree
 *
 * @param      None
 *
 * @return     OS_SUCCESS
 */
extern OS_STATUS PMU_LIST_Build_PCI_List(void);

/*!
 * @fn         OS_STATUS PMU_LIST_Build_MMIO_List (void)
 * @brief      Build the MMIO search tree
 *
 * @param      None
 *
 * @return     OS_SUCCESS
 */
extern OS_STATUS PMU_LIST_Build_MMIO_List(void);

/*!
 * @fn         OS_STATUS PMU_LIST_Add_To_MMIO_List (U64, void*, U8)
 *
 * @brief      Adds entry to the mmio list
 *
 * @param      U64   key  - key for the node in the MMIO BST
 *             void *addr - address to add into the node for additional checks
 *
 * @return     OS_SUCCESS
 */
extern OS_STATUS PMU_LIST_Add_To_MMIO_List(U64 key, void *addr);

/*!
 * @fn         OS_STATUS PMU_LIST_Clean_Up (void)
 * @brief      Clean up all the search trees
 *
 * @param      None
 *
 * @return     OS_SUCCESS
 */
extern OS_STATUS PMU_LIST_Clean_Up(void);

#endif

