/*
 * Copyright (C) 2002 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#define MSR_GS_BASE   0xc0000101

# These offsets map directly to members of struct trapframe in <machine/frame.h>
#define OFFSET_RDI  0x0
#define OFFSET_RSI  0x8
#define OFFSET_RDX  0x10
#define OFFSET_RCX  0x18
#define OFFSET_R8   0x20
#define OFFSET_R9   0x28
#define OFFSET_RAX  0x30
#define OFFSET_RBX  0x38
#define OFFSET_RBP  0x40
#define OFFSET_R10  0x48
#define OFFSET_R11  0x50
#define OFFSET_R12  0x58
#define OFFSET_R13  0x60
#define OFFSET_R14  0x68
#define OFFSET_R15  0x70
#define OFFSET_RIP  0x98

.text

#***********************************************************************
#
#    SYS_Get_IDT_Base
#            Get the IDT Desc address
#
#    Entry:  pointer to location to store idt Desc
#
#    Exit:  none
#
# void SYS_Get_IDT_Base(U64 *pIdtDesc);
#
#***********************************************************************
        .global SYS_Get_IDT_Base
SYS_Get_IDT_Base:
        SIDT (%rdi)
        ret

#***********************************************************************
#
#    SYS_Get_GDT_Base
#            Get the GDT Desc address
#
#    Entry:  pointer to location to store gdt Desc
#
#    Exit:  none
#
# void SYS_Get_GDT_Base(U64 *pGdtDesc);
#
#***********************************************************************
        .global SYS_Get_GDT_Base
SYS_Get_GDT_Base:
        SGDT (%rdi)
        ret

#***********************************************************************
#
#    SYS_Get_TSC
#            Get the current TSC
#
#    Entry:  pointer to location to store gdt Desc
#
#    Exit:  none
#
# void SYS_Get_TSC(U64 *tsc);
#
#***********************************************************************
#        .global SYS_Get_TSC
#SYS_Get_TSC:
#        rdtsc
#        ret

#***********************************************************************
#
#    SYS_IO_Delay
#            Add a short delay to the instruction stream
#
#    Entry:  none
#
#    Exit:  none
#
# void SYS_IO_Delay(void);
#
#***********************************************************************
        .global SYS_IO_Delay
SYS_IO_Delay:
         ret

# ----------------------------------------------------------------------------
# name:         SYS_PerfVec_Handler
#
# description:  ISR entry for local APIC PERF interrupt vector
#
# Input:        n/a
#
# Output:       n/a
# ----------------------------------------------------------------------------

        .global SYS_Perfvec_Handler
SYS_Perfvec_Handler:
	.cfi_startproc
        cld                 // cause the kernel likes it this way...

        subq    $OFFSET_RIP,%rsp
        movq    %rdi,OFFSET_RDI(%rsp)
        movq    %rsi,OFFSET_RSI(%rsp)
        movq    %rdx,OFFSET_RDX(%rsp)
        movq    %rcx,OFFSET_RCX(%rsp)
        movq    %r8,OFFSET_R8(%rsp)
        movq    %r9,OFFSET_R9(%rsp)
        movq    %rax,OFFSET_RAX(%rsp)
        movq    %rbx,OFFSET_RBX(%rsp)
        movq    %rbp,OFFSET_RBP(%rsp)
        movq    %r10,OFFSET_R10(%rsp)
        movq    %r11,OFFSET_R11(%rsp)
        movq    %r12,OFFSET_R12(%rsp)
        movq    %r13,OFFSET_R13(%rsp)
        movq    %r14,OFFSET_R14(%rsp)
        movq    %r15,OFFSET_R15(%rsp)

        movl  $MSR_GS_BASE,%ecx     // for the moment, do the safe swapgs check
        rdmsr
        xorl  %ebx,%ebx             // assume no swapgs (ebx == 0)
        testl %edx,%edx
        js    1f
        swapgs
        movl  $1,%ebx               // ebx == 1 means we did a swapgs
1:      movq %rsp,%rdi              // pt_regs is the first argument

        //
        // ebx is zero if no swap, one if swap
        // ebx is preserved in C calling convention...
        //
        // NOTE: the C code is responsible for ACK'ing the APIC!!!
        //
        call PMI_Interrupt_Handler

        //
        // Don't want an interrupt while we are doing the swapgs stuff
        //
        cli
        testl %ebx,%ebx
        jz 2f
        swapgs

2:      movq    OFFSET_RDI(%rsp),%rdi
        movq    OFFSET_RSI(%rsp),%rsi
        movq    OFFSET_RDX(%rsp),%rdx
        movq    OFFSET_RCX(%rsp),%rcx
        movq    OFFSET_R8(%rsp),%r8
        movq    OFFSET_R9(%rsp),%r9
        movq    OFFSET_RAX(%rsp),%rax
        movq    OFFSET_RBX(%rsp),%rbx
        movq    OFFSET_RBP(%rsp),%rbp
        movq    OFFSET_R10(%rsp),%r10
        movq    OFFSET_R11(%rsp),%r11
        movq    OFFSET_R12(%rsp),%r12
        movq    OFFSET_R13(%rsp),%r13
        movq    OFFSET_R14(%rsp),%r14
        movq    OFFSET_R15(%rsp),%r15
        addq    $OFFSET_RIP,%rsp

        iretq
        .cfi_endproc
