/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.utils;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class SideEffectChecker {
    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull GrExpression exp) {
        if (exp == null) {
            SideEffectChecker.$$$reportNull$$$0(0);
        }
        SideEffectsVisitor visitor2 = new SideEffectsVisitor();
        exp.accept(visitor2);
        return visitor2.mayHaveSideEffects();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker", "mayHaveSideEffects"));
    }

    private static class SideEffectsVisitor
    extends GroovyRecursiveElementVisitor {
        private boolean mayHaveSideEffects = false;

        private SideEffectsVisitor() {
        }

        @Override
        public void visitElement(@NotNull GroovyPsiElement element) {
            if (element == null) {
                SideEffectsVisitor.$$$reportNull$$$0(0);
            }
            if (!this.mayHaveSideEffects) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(1);
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitAssignmentExpression(expression);
            this.mayHaveSideEffects = true;
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(2);
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitMethodCallExpression(expression);
            this.mayHaveSideEffects = true;
        }

        @Override
        public void visitNewExpression(@NotNull GrNewExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(3);
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitNewExpression(expression);
            this.mayHaveSideEffects = true;
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(4);
            }
            if (this.mayHaveSideEffects) {
                return;
            }
            super.visitUnaryExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(GroovyTokenTypes.mINC) || tokenType.equals(GroovyTokenTypes.mDEC)) {
                this.mayHaveSideEffects = true;
            }
        }

        public boolean mayHaveSideEffects() {
            return this.mayHaveSideEffects;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/utils/SideEffectChecker$SideEffectsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

