/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.Structure;

public final class Chain
implements Structure {
    public Model model;
    public int chainID;
    public int chainNo;
    public Group[] groups;
    public int groupCount;
    public int selectedGroupCount;

    Chain(Model model, int chainID, int chainNo) {
        this.model = model;
        this.chainID = chainID;
        this.chainNo = chainNo;
        this.groups = new Group[16];
    }

    public String getIDStr() {
        return this.chainID == 0 ? "" : (this.chainID < 256 ? "" + (char)this.chainID : this.model.ms.vwr.getChainIDStr(this.chainID));
    }

    void calcSelectedGroupsCount(BS bsSelected) {
        this.selectedGroupCount = 0;
        for (int i = 0; i < this.groupCount; ++i) {
            int n;
            Group group = this.groups[i];
            if (this.groups[i].isSelected(bsSelected)) {
                int n2 = this.selectedGroupCount;
                n = n2;
                this.selectedGroupCount = n2 + 1;
            } else {
                n = -1;
            }
            group.selectedIndex = n;
        }
    }

    void fixIndices(int atomsDeleted, BS bsDeleted) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].fixIndices(atomsDeleted, bsDeleted);
        }
    }

    @Override
    public void setAtomBits(BS bs) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].setAtomBits(bs);
        }
    }

    @Override
    public void setAtomBitsAndClear(BS bs, BS bsOut) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].setAtomBitsAndClear(bs, bsOut);
        }
    }
}

