/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.StreamUtils;

public final class MirrorAction
extends JosmAction {
    public MirrorAction() {
        super(I18n.tr("Mirror", new Object[0]), "mirror", I18n.tr("Mirror selected nodes and ways.", new Object[0]), Shortcut.registerShortcut("tools:mirror", I18n.tr("Tools: {0}", I18n.tr("Mirror", new Object[0])), 77, 5005), true);
        this.setHelpId(HelpUtil.ht("/Action/Mirror"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection sel = this.getLayerManager().getEditDataSet().getSelected();
        HashSet<Node> nodes = new HashSet<Node>();
        for (OsmPrimitive osm : sel) {
            if (osm instanceof Node) {
                nodes.add((Node)osm);
                continue;
            }
            if (!(osm instanceof Way)) continue;
            nodes.addAll(((Way)osm).getNodes());
        }
        if (nodes.isEmpty()) {
            new Notification(I18n.tr("Please select at least one node or way.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        double minEast = 2.0E10;
        double maxEast = -2.0E10;
        for (Node n2 : nodes) {
            double east = n2.getEastNorth().east();
            minEast = Math.min(minEast, east);
            maxEast = Math.max(maxEast, east);
        }
        double middle = (minEast + maxEast) / 2.0;
        Collection cmds = nodes.stream().map(n -> new MoveCommand((OsmPrimitive)n, 2.0 * (middle - n.getEastNorth().east()), 0.0)).collect(StreamUtils.toUnmodifiableList());
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Mirror", new Object[0]), cmds));
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }
}

