/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.kafka.trogdor.workload.PayloadGenerator;

public class SequentialPayloadGenerator
implements PayloadGenerator {
    private final int size;
    private final long startOffset;
    private final ByteBuffer buf;

    @JsonCreator
    public SequentialPayloadGenerator(@JsonProperty(value="size") int size, @JsonProperty(value="offset") long startOffset) {
        this.size = size;
        this.startOffset = startOffset;
        this.buf = ByteBuffer.allocate(8);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @JsonProperty
    public int size() {
        return this.size;
    }

    @JsonProperty
    public long startOffset() {
        return this.startOffset;
    }

    @Override
    public synchronized byte[] generate(long position) {
        this.buf.clear();
        this.buf.putLong(position + this.startOffset);
        byte[] result = new byte[this.size];
        System.arraycopy(this.buf.array(), 0, result, 0, Math.min(this.buf.array().length, result.length));
        return result;
    }
}

