/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.os;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ProcessRedirect {
    private ProcessRedirect() {
    }

    public static ProcessBuilder.Redirect discard() {
        return ProcessBuilder.Redirect.to(new File(ProcessRedirect.isWindows() ? "NUL" : "/dev/null"));
    }

    private static boolean isWindows() {
        SecurityManager sm = System.getSecurityManager();
        return (sm == null ? ProcessRedirect.getOsName() : ProcessRedirect.getOsNamePrivileged()).toLowerCase(Locale.ROOT).contains("windows");
    }

    private static String getOsNamePrivileged() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ProcessRedirect.getOsName();
            }
        });
    }

    private static String getOsName() {
        return System.getProperty("os.name", "unknown");
    }
}

