/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.function.Predicate;

public final class HotDeploymentWatchedFileBuildItem
extends MultiBuildItem {
    private final String location;
    private final Predicate<String> locationPredicate;
    private final boolean restartNeeded;

    public static Builder builder() {
        return new Builder();
    }

    public HotDeploymentWatchedFileBuildItem(String location) {
        this(location, true);
    }

    public HotDeploymentWatchedFileBuildItem(String location, boolean restartNeeded) {
        this(location, null, restartNeeded);
    }

    private HotDeploymentWatchedFileBuildItem(String location, Predicate<String> locationPredicate, boolean restartNeeded) {
        if (location == null && locationPredicate == null) {
            throw new IllegalArgumentException("Either location or predicate must be set");
        }
        this.location = location;
        this.locationPredicate = locationPredicate;
        this.restartNeeded = restartNeeded;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public Predicate<String> getLocationPredicate() {
        return this.locationPredicate;
    }

    public boolean hasLocationPredicate() {
        return this.locationPredicate != null;
    }

    public boolean isRestartNeeded() {
        return this.restartNeeded;
    }

    public static class Builder {
        private String location;
        private Predicate<String> locationPredicate;
        private boolean restartNeeded = true;

        public Builder setLocation(String location) {
            if (this.locationPredicate != null) {
                throw new IllegalArgumentException("Predicate already set");
            }
            this.location = location;
            return this;
        }

        public Builder setLocationPredicate(Predicate<String> locationPredicate) {
            if (this.location != null) {
                throw new IllegalArgumentException("Location already set");
            }
            this.locationPredicate = locationPredicate;
            return this;
        }

        public Builder setRestartNeeded(boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
            return this;
        }

        public HotDeploymentWatchedFileBuildItem build() {
            return new HotDeploymentWatchedFileBuildItem(this.location, this.locationPredicate, this.restartNeeded);
        }
    }
}

