/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport.handler;

import java.util.Iterator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.util.BulkUtil;
import org.opensearch.timeseries.util.ClientUtil;
import org.opensearch.timeseries.util.IndexUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.client.Client;

public class ResultIndexingHandler<ResultType extends IndexableResult, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>> {
    private static final Logger LOG = LogManager.getLogger(ResultIndexingHandler.class);
    public static final String FAIL_TO_SAVE_ERR_MSG = "Fail to save %s: ";
    public static final String SUCCESS_SAVING_MSG = "Succeed in saving %s";
    public static final String CANNOT_SAVE_ERR_MSG = "Cannot save %s due to write block.";
    public static final String RETRY_SAVING_ERR_MSG = "Retry in saving %s: ";
    protected final Client client;
    protected final ThreadPool threadPool;
    protected final BackoffPolicy savingBackoffPolicy;
    protected final String defaultResultIndexName;
    protected final IndexManagementType timeSeriesIndices;
    protected boolean fixedDoc;
    protected final ClientUtil clientUtil;
    protected final IndexUtils indexUtils;
    protected final ClusterService clusterService;

    public ResultIndexingHandler(Client client, Settings settings, ThreadPool threadPool, String indexName, IndexManagementType timeSeriesIndices, ClientUtil clientUtil, IndexUtils indexUtils, ClusterService clusterService, Setting<TimeValue> backOffDelaySetting, Setting<Integer> maxRetrySetting) {
        this.client = client;
        this.threadPool = threadPool;
        this.savingBackoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)((TimeValue)backOffDelaySetting.get(settings)), (int)((Integer)maxRetrySetting.get(settings)));
        this.defaultResultIndexName = indexName;
        this.timeSeriesIndices = timeSeriesIndices;
        this.fixedDoc = false;
        this.clientUtil = clientUtil;
        this.indexUtils = indexUtils;
        this.clusterService = clusterService;
    }

    public void setFixedDoc(boolean fixedDoc) {
        this.fixedDoc = fixedDoc;
    }

    public void index(ResultType toSave, String configId, String indexOrAliasName) {
        if (indexOrAliasName != null) {
            if (this.indexUtils.checkIndicesBlocked(this.clusterService.state(), ClusterBlockLevel.WRITE, indexOrAliasName)) {
                LOG.warn(String.format(Locale.ROOT, CANNOT_SAVE_ERR_MSG, configId));
                return;
            }
            if (!((IndexManagement)this.timeSeriesIndices).doesIndexExist(indexOrAliasName) && !((IndexManagement)this.timeSeriesIndices).doesAliasExist(indexOrAliasName)) {
                ((IndexManagement)this.timeSeriesIndices).initCustomResultIndexDirectly(indexOrAliasName, (ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                    if (response.isAcknowledged()) {
                        this.save(toSave, configId, indexOrAliasName);
                    } else {
                        LOG.error(String.format(Locale.ROOT, "Creating custom result index %s with mappings call not acknowledged", indexOrAliasName));
                    }
                }, exception -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                        this.save(toSave, configId, indexOrAliasName);
                    } else {
                        LOG.error(String.format(Locale.ROOT, "cannot create result index %s", indexOrAliasName), (Throwable)exception);
                    }
                }));
            } else {
                ((IndexManagement)this.timeSeriesIndices).validateResultIndexMapping(indexOrAliasName, (ActionListener<Boolean>)ActionListener.wrap(valid -> {
                    if (!valid.booleanValue()) {
                        LOG.error("wrong index mapping of custom result index");
                    } else {
                        this.save(toSave, configId, indexOrAliasName);
                    }
                }, exception -> LOG.error(String.format(Locale.ROOT, "cannot validate result index %s", indexOrAliasName), (Throwable)exception)));
            }
        } else {
            if (this.indexUtils.checkIndicesBlocked(this.clusterService.state(), ClusterBlockLevel.WRITE, this.defaultResultIndexName)) {
                LOG.warn(String.format(Locale.ROOT, CANNOT_SAVE_ERR_MSG, configId));
                return;
            }
            if (!((IndexManagement)this.timeSeriesIndices).doesDefaultResultIndexExist()) {
                ((IndexManagement)this.timeSeriesIndices).initDefaultResultIndexDirectly((ActionListener<CreateIndexResponse>)ActionListener.wrap(initResponse -> this.onCreateIndexResponse((CreateIndexResponse)initResponse, toSave, configId), exception -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                        this.save(toSave, configId);
                    } else {
                        LOG.error(String.format(Locale.ROOT, "Unexpected error creating index %s", this.defaultResultIndexName), (Throwable)exception);
                    }
                }));
            } else {
                this.save(toSave, configId);
            }
        }
    }

    private void onCreateIndexResponse(CreateIndexResponse response, ResultType toSave, String detectorId) {
        if (!response.isAcknowledged()) {
            throw new TimeSeriesException(detectorId, String.format(Locale.ROOT, "Creating %s with mappings call not acknowledged.", this.defaultResultIndexName));
        }
        this.save(toSave, detectorId);
    }

    protected void save(ResultType toSave, String detectorId) {
        this.save(toSave, detectorId, this.defaultResultIndexName);
    }

    protected void save(ResultType toSave, String detectorId, String indexName) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            IndexRequest indexRequest = new IndexRequest(indexName).source(toSave.toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE));
            if (this.fixedDoc) {
                indexRequest.id(detectorId);
            }
            this.saveIteration(indexRequest, detectorId, this.savingBackoffPolicy.iterator());
        }
        catch (Exception e) {
            LOG.error(String.format(Locale.ROOT, "Failed to save %s", indexName), (Throwable)e);
            throw new TimeSeriesException(detectorId, String.format(Locale.ROOT, "Cannot save %s", indexName));
        }
    }

    void saveIteration(IndexRequest indexRequest, String configId, Iterator<TimeValue> backoff) {
        this.clientUtil.asyncRequest(indexRequest, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1), ActionListener.wrap(response -> LOG.debug(String.format(Locale.ROOT, SUCCESS_SAVING_MSG, configId)), exception -> {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exception);
            if (!(cause instanceof OpenSearchRejectedExecutionException) || !backoff.hasNext()) {
                LOG.error(String.format(Locale.ROOT, FAIL_TO_SAVE_ERR_MSG, configId), cause);
            } else {
                TimeValue nextDelay = (TimeValue)backoff.next();
                LOG.warn(String.format(Locale.ROOT, RETRY_SAVING_ERR_MSG, configId), cause);
                this.threadPool.schedule(() -> this.saveIteration(BulkUtil.cloneIndexRequest(indexRequest), configId, backoff), nextDelay, "same");
            }
        }));
    }
}

