/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common.ui;

import de.tuberlin.polymake.common.ui.SliderEvent;
import de.tuberlin.polymake.common.ui.SliderListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PolymakeSlider {
    protected Box sliderBox = Box.createHorizontalBox();
    protected JLabel label;
    protected JTextField valueField = new JTextField(3);
    protected JSlider slider = new JSlider(0, 100);
    protected Vector sliderListeners = new Vector();
    private double min = 0.0;
    private double max = 1.0;
    private double value = 0.0;

    public PolymakeSlider(String string, double d, double d2, double d3) {
        this.min = d;
        this.max = d2;
        this.label = new JLabel(string);
        this.valueField.setText(Double.toString(d3));
        this.valueField.setPreferredSize(new Dimension(40, 20));
        this.valueField.setMaximumSize(new Dimension(40, 20));
        this.valueField.setMinimumSize(new Dimension(40, 20));
        this.valueField.setActionCommand("valueField");
        this.valueField.addActionListener(new ActionListener(this){
            final /* synthetic */ PolymakeSlider this$0;
            {
                PolymakeSlider polymakeSlider2 = polymakeSlider;
                Objects.requireNonNull(polymakeSlider2);
                this.this$0 = polymakeSlider2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(this.this$0.valueField.getText());
                    if (this.this$0.value != d) {
                        this.this$0.setDoubleValue(d);
                        this.this$0.notifyListeners();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.slider.setValue((int)Math.round(100.0 * (d3 - this.min) / (this.max - this.min)));
        this.slider.addChangeListener(new ChangeListener(this){
            final /* synthetic */ PolymakeSlider this$0;
            {
                PolymakeSlider polymakeSlider2 = polymakeSlider;
                Objects.requireNonNull(polymakeSlider2);
                this.this$0 = polymakeSlider2;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (this.this$0.slider.getValueIsAdjusting() && this.this$0.value != (double)this.this$0.slider.getValue()) {
                    this.this$0.setDoubleValue(this.this$0.min + (double)this.this$0.slider.getValue() * (this.this$0.max - this.this$0.min) / 100.0);
                    this.this$0.notifyListeners();
                }
            }
        });
        this.label.setBorder(new EmptyBorder(0, 4, 0, 2));
        this.label.setPreferredSize(new Dimension(100, 20));
        this.sliderBox.add(this.label);
        this.sliderBox.add(Box.createHorizontalGlue());
        this.sliderBox.add(this.valueField);
        this.sliderBox.add(this.slider);
    }

    public Component getComponent() {
        return this.sliderBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDoubleValue() {
        JTextField jTextField = this.valueField;
        synchronized (jTextField) {
            this.value = Double.parseDouble(this.valueField.getText());
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDoubleValue(double d) {
        if (d < this.min) {
            d = this.min;
        }
        if (d > this.max) {
            d = this.max;
        }
        this.value = d;
        JTextField jTextField = this.valueField;
        synchronized (jTextField) {
            this.valueField.setText(Double.toString(d));
            this.slider.setValue((int)Math.round(100.0 * (d - this.min) / (this.max - this.min)));
        }
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void addSliderListener(SliderListener sliderListener) {
        this.sliderListeners.add(sliderListener);
    }

    private void notifyListeners() {
        for (SliderListener sliderListener : this.sliderListeners) {
            sliderListener.sliderValueChanged(new SliderEvent(this, 0x100000));
        }
    }

    public void setEnabled(boolean bl) {
        this.slider.setEnabled(bl);
        this.valueField.setEnabled(bl);
    }
}

