\name{DiscreteGaussianDerivativeImageFilter}
\alias{DiscreteGaussianDerivativeImageFilter}
\title{DiscreteGaussianDerivativeImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Calculates image derivatives using discrete derivative gaussian
kernels. This filter calculates Gaussian derivative by separable
convolution of an image and a discrete Gaussian derivative operator
(kernel).
DiscreteGaussianDerivativeImageFilter}
\details{
The Gaussian operators used here were described by Tony Lindeberg
(Discrete Scale-Space Theory and the Scale-Space Primal Sketch.
Dissertation. Royal Institute of Technology, Stockholm, Sweden. May
1991.)
The variance or standard deviation (sigma) will be evaluated as pixel
units if SetUseImageSpacing is off (false) or as physical units if
SetUseImageSpacing is on (true, default). The variance can be set
independently in each dimension.
When the Gaussian kernel is small, this filter tends to run faster
than itk::RecursiveGaussianImageFilter .
Ivan Macia, Vicomtech, Spain, https://www.vicomtech.org/en
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/179
See:
GaussianDerivativeOperator
Image
Neighborhood
NeighborhoodOperator
DiscreteGaussianDerivative for the procedural interface
itk::DiscreteGaussianDerivativeImageFilter for the Doxygen on the original ITK class.
DiscreteGaussianDerivativeImageFilter}
%C++ includes: sitkDiscreteGaussianDerivativeImageFilter.h
\section{Methods}{
\describe{
\item{ DiscreteGaussianDerivativeImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetMaximumError() const:}{
The algorithm will size the discrete kernel so that the error
resulting from truncation of the kernel is no greater than
MaximumError. The default is 0.01 in each dimension.
}
\item{unsigned int GetMaximumKernelWidth() const:}{
Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalizeAcrossScale() const:}{
Set/Get the flag for calculating scale-space normalized derivatives.
Normalized derivatives are obtained multiplying by the scale parameter
t.
}
\item{std::vector< unsigned int > GetOrder() const:}{
Order of derivatives in each dimension. Sets the derivative order
independently for each dimension, but see also SetOrder(const unsigned int v) . The default is 1 in each dimension.
}
\item{bool GetUseImageSpacing() const:}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Default is ImageSpacingOn.
}
\item{std::vector< double > GetVariance() const:}{
The variance for the discrete Gaussian kernel. Sets the variance
independently for each dimension, but see also SetVariance(const double v) . The default is 0.0 in each dimension. If UseImageSpacing is true,
the units are the physical units of your image. If UseImageSpacing is
false then the units are pixels.
}
\item{Self NormalizeAcrossScaleOff():}{}
\item{Self NormalizeAcrossScaleOn():}{
Set the value of NormalizeAcrossScale to true or false respectfully.
}
\item{Self SetMaximumError(double MaximumError):}{
Convenience Set methods for setting all dimensional parameters to the
same values.
}
\item{Self SetMaximumKernelWidth(unsigned int MaximumKernelWidth):}{
Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.
}
\item{Self SetNormalizeAcrossScale(bool NormalizeAcrossScale):}{
Set/Get the flag for calculating scale-space normalized derivatives.
Normalized derivatives are obtained multiplying by the scale parameter
t.
}
\item{Self SetOrder(std::vector< unsigned int > Order):}{
Convenience Set methods for setting all dimensional parameters to the
same values.
}
\item{Self SetOrder(unsigned int value):}{
Set the values of the Order vector all to value
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Default is ImageSpacingOn.
}
\item{Self SetVariance(double value):}{
Set the values of the Variance vector all to value
}
\item{Self SetVariance(std::vector< double > Variance):}{
Convenience Set methods for setting all dimensional parameters to the
same values.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~DiscreteGaussianDerivativeImageFilter():}{
Destructor
}
}
}
