/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import dev.ai4j.openai4j.FilePersistor;
import dev.ai4j.openai4j.image.GenerateImagesResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Path;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

class PersistorConverterFactory
extends Converter.Factory {
    private final Path persistTo;

    PersistorConverterFactory(Path persistTo) {
        this.persistTo = persistTo;
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        return new PersistorConverter(retrofit.nextResponseBodyConverter((Converter.Factory)this, type, annotations));
    }

    private class PersistorConverter<T>
    implements Converter<ResponseBody, T> {
        private final Converter<ResponseBody, T> delegate;

        PersistorConverter(Converter<ResponseBody, T> delegate) {
            this.delegate = delegate;
        }

        public T convert(ResponseBody value) throws IOException {
            Object response = this.delegate.convert((Object)value);
            if (response instanceof GenerateImagesResponse) {
                ((GenerateImagesResponse)response).data().forEach(data -> {
                    try {
                        data.url(data.url() != null ? FilePersistor.persistFromUri(data.url(), PersistorConverterFactory.this.persistTo).toUri() : FilePersistor.persistFromBase64String(data.b64Json(), PersistorConverterFactory.this.persistTo).toUri());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            return (T)response;
        }
    }
}

