/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Compressor;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateWriter {
    private static final long MAX_FLUSH_INTERVAL = TimeUnit.NANOSECONDS.convert(Overseer.STATE_UPDATE_DELAY, TimeUnit.MILLISECONDS);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static ZkWriteCommand NO_OP = ZkWriteCommand.NO_OP;
    protected final ZkStateReader reader;
    protected final Stats stats;
    protected Map<String, ZkWriteCommand> updates = new HashMap<String, ZkWriteCommand>();
    private int numUpdates = 0;
    protected ClusterState clusterState = null;
    protected long lastUpdatedTime = 0L;
    protected boolean invalidState = false;
    protected int minStateByteLenForCompression;
    protected Compressor compressor;

    public ZkStateWriter(ZkStateReader zkStateReader, Stats stats, int minStateByteLenForCompression, Compressor compressor) {
        assert (zkStateReader != null);
        this.reader = zkStateReader;
        this.stats = stats;
        this.clusterState = zkStateReader.getClusterState();
        this.minStateByteLenForCompression = minStateByteLenForCompression;
        this.compressor = compressor;
    }

    public void updateClusterState(Function<ClusterState, ClusterState> fun) {
        this.clusterState = fun.apply(this.clusterState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState enqueueUpdate(ClusterState prevState, List<ZkWriteCommand> cmds, ZkWriteCallback callback) throws IllegalStateException, Exception {
        if (this.invalidState) {
            throw new IllegalStateException("ZkStateWriter has seen a tragic error, this instance can no longer be used");
        }
        if (cmds.isEmpty()) {
            return prevState;
        }
        if (this.isNoOps(cmds)) {
            return prevState;
        }
        boolean forceFlush = false;
        if (cmds.size() == 1) {
            Iterator<ZkWriteCommand> cmd = cmds.get(0);
            if (((ZkWriteCommand)((Object)cmd)).collection != null && ((ZkWriteCommand)((Object)cmd)).collection.isPerReplicaState()) {
                if (this.updates.containsKey(((ZkWriteCommand)((Object)cmd)).name)) {
                    this.writeUpdate(this.updates.remove(((ZkWriteCommand)((Object)cmd)).name));
                }
                try {
                    ClusterState clusterState = this.writeUpdate((ZkWriteCommand)((Object)cmd));
                    return clusterState;
                }
                finally {
                    if (callback != null) {
                        callback.onWrite();
                    }
                }
            }
        } else {
            for (ZkWriteCommand cmd : cmds) {
                if (cmd.collection == null || !cmd.collection.isPerReplicaState()) continue;
                forceFlush = true;
                break;
            }
        }
        for (ZkWriteCommand cmd : cmds) {
            if (cmd == NO_OP) continue;
            prevState = prevState.copyWith(cmd.name, cmd.collection);
            this.updates.put(cmd.name, cmd);
            ++this.numUpdates;
        }
        this.clusterState = prevState;
        if (forceFlush || this.maybeFlushAfter()) {
            ClusterState state = this.writePendingUpdates();
            if (callback != null) {
                callback.onWrite();
            }
            return state;
        }
        return this.clusterState;
    }

    private boolean isNoOps(List<ZkWriteCommand> cmds) {
        for (ZkWriteCommand cmd : cmds) {
            if (cmd == NO_OP) continue;
            return false;
        }
        return true;
    }

    private boolean maybeFlushAfter() {
        return System.nanoTime() - this.lastUpdatedTime > MAX_FLUSH_INTERVAL || this.numUpdates > Overseer.STATE_UPDATE_BATCH_SIZE;
    }

    public boolean hasPendingUpdates() {
        return this.numUpdates != 0;
    }

    public ClusterState writeUpdate(ZkWriteCommand command) throws IllegalStateException, KeeperException, InterruptedException {
        HashMap<String, ZkWriteCommand> commands = new HashMap<String, ZkWriteCommand>();
        commands.put(command.name, command);
        return this.writePendingUpdates(commands, false);
    }

    public ClusterState writePendingUpdates() throws KeeperException, InterruptedException {
        return this.writePendingUpdates(this.updates, true);
    }

    public ClusterState writePendingUpdates(Map<String, ZkWriteCommand> updates, boolean resetPendingUpdateCounters) throws IllegalStateException, KeeperException, InterruptedException {
        if (this.invalidState) {
            throw new IllegalStateException("ZkStateWriter has seen a tragic error, this instance can no longer be used");
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format(Locale.ROOT, "Request to write pending updates with updates of length: %d, pending updates of length: %d, writing all pending updates: %b", updates.size(), this.updates.size(), updates == this.updates));
        }
        if (updates == this.updates && !this.hasPendingUpdates()) {
            if (log.isDebugEnabled()) {
                log.debug("Attempted to flush all pending updates, but there are no pending updates");
            }
            return this.clusterState;
        }
        Timer.Context timerContext = this.stats.time("update_state");
        boolean success = false;
        try {
            if (!updates.isEmpty()) {
                for (Map.Entry<String, ZkWriteCommand> entry : updates.entrySet()) {
                    DocCollection currentCollState;
                    String name = entry.getKey();
                    String path = DocCollection.getCollectionPath((String)name);
                    ZkWriteCommand cmd = entry.getValue();
                    DocCollection c = cmd.collection;
                    if (cmd.ops != null) {
                        cmd.ops.persist(path, this.reader.getZkClient());
                        this.clusterState = this.clusterState.copyWith(name, cmd.collection.setPerReplicaStates(PerReplicaStatesOps.fetch((String)cmd.collection.getZNode(), (SolrZkClient)this.reader.getZkClient(), null)));
                    }
                    if (!cmd.persistJsonState) continue;
                    if (c == null) {
                        log.debug("going to delete state.json {}", (Object)path);
                        this.reader.getZkClient().clean(path);
                    } else {
                        DocCollection newCollection;
                        Stat stat;
                        byte[] data = Utils.toJSON(Collections.singletonMap(c.getName(), c));
                        if (this.minStateByteLenForCompression > -1 && data.length > this.minStateByteLenForCompression) {
                            data = this.compressor.compressBytes(data, data.length / 10);
                        }
                        if (this.reader.getZkClient().exists(path, true).booleanValue()) {
                            if (log.isDebugEnabled()) {
                                log.debug("going to update_collection {} version: {}", (Object)path, (Object)c.getZNodeVersion());
                            }
                            stat = this.reader.getZkClient().setData(path, data, c.getZNodeVersion(), true);
                            newCollection = DocCollection.create((String)name, (Map)c.getSlicesMap(), (Map)c.getProperties(), (DocRouter)c.getRouter(), (int)stat.getVersion(), (Instant)Instant.ofEpochMilli(stat.getCtime()), (DocCollection.PrsSupplier)PerReplicaStatesOps.getZkClientPrsSupplier((SolrZkClient)this.reader.getZkClient(), (String)path));
                            this.clusterState = this.clusterState.copyWith(name, newCollection);
                        } else {
                            log.debug("going to create_collection {}", (Object)path);
                            stat = new Stat();
                            this.reader.getZkClient().create(path, data, CreateMode.PERSISTENT, true, stat);
                            newCollection = DocCollection.create((String)name, (Map)c.getSlicesMap(), (Map)c.getProperties(), (DocRouter)c.getRouter(), (int)0, (Instant)Instant.ofEpochMilli(stat.getCtime()), (DocCollection.PrsSupplier)PerReplicaStatesOps.getZkClientPrsSupplier((SolrZkClient)this.reader.getZkClient(), (String)path));
                            this.clusterState = this.clusterState.copyWith(name, newCollection);
                        }
                    }
                    if (cmd.ops != null || !cmd.isPerReplicaStateCollection || (currentCollState = this.clusterState.getCollection(cmd.name)) == null) continue;
                    this.clusterState = this.clusterState.copyWith(name, currentCollState.setPerReplicaStates(PerReplicaStatesOps.fetch((String)currentCollState.getZNode(), (SolrZkClient)this.reader.getZkClient(), null)));
                }
                updates.clear();
            }
            if (resetPendingUpdateCounters) {
                this.resetPendingUpdateCounters();
            }
            success = true;
        }
        catch (KeeperException.BadVersionException bve) {
            this.invalidState = true;
            throw bve;
        }
        finally {
            timerContext.stop();
            if (success) {
                this.stats.success("update_state");
            } else {
                this.stats.error("update_state");
            }
        }
        log.trace("New Cluster State is: {}", (Object)this.clusterState);
        return this.clusterState;
    }

    public void resetPendingUpdateCounters() {
        this.lastUpdatedTime = System.nanoTime();
        this.numUpdates = 0;
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public static interface ZkWriteCallback {
        public void onWrite() throws Exception;
    }
}

