/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;

public abstract class FrameworkListener
implements LifecycleListener,
ContainerListener {
    protected final ConcurrentHashMap<Context, LifecycleListener> contextListeners = new ConcurrentHashMap();

    protected abstract LifecycleListener createLifecycleListener(Context var1);

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        Lifecycle lifecycle = lifecycleEvent.getLifecycle();
        if ("before_start".equals(lifecycleEvent.getType()) && lifecycle instanceof Server) {
            Server server = (Server)lifecycle;
            this.registerListenersForServer(server);
        }
    }

    @Override
    public void containerEvent(ContainerEvent containerEvent) {
        String string = containerEvent.getType();
        if ("addChild".equals(string)) {
            this.processContainerAddChild((Container)containerEvent.getData());
        } else if ("removeChild".equals(string)) {
            this.processContainerRemoveChild((Container)containerEvent.getData());
        }
    }

    protected void registerListenersForServer(Server server) {
        for (Service service : server.findServices()) {
            Engine engine = service.getContainer();
            if (engine == null) continue;
            engine.addContainerListener(this);
            this.registerListenersForEngine(engine);
        }
    }

    protected void registerListenersForEngine(Engine engine) {
        for (Container container : engine.findChildren()) {
            Host host = (Host)container;
            host.addContainerListener(this);
            this.registerListenersForHost(host);
        }
    }

    protected void registerListenersForHost(Host host) {
        for (Container container : host.findChildren()) {
            Context context = (Context)container;
            this.registerContextListener(context);
        }
    }

    protected void registerContextListener(Context context) {
        LifecycleListener lifecycleListener = this.createLifecycleListener(context);
        this.contextListeners.put(context, lifecycleListener);
        context.addLifecycleListener(lifecycleListener);
    }

    protected void processContainerAddChild(Container container) {
        if (container instanceof Context) {
            this.registerContextListener((Context)container);
        } else if (container instanceof Engine) {
            this.registerListenersForEngine((Engine)container);
        } else if (container instanceof Host) {
            this.registerListenersForHost((Host)container);
        }
    }

    protected void processContainerRemoveChild(Container container) {
        if (container instanceof Context) {
            LifecycleListener lifecycleListener = this.contextListeners.remove(container);
            if (lifecycleListener != null) {
                container.removeLifecycleListener(lifecycleListener);
            }
        } else if (container instanceof Host || container instanceof Engine) {
            container.removeContainerListener(this);
        }
    }
}

