/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.reflect;

import com.sun.javafx.reflect.ReflectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;

public final class MethodUtil
extends SecureClassLoader {
    private static final Method bounce = MethodUtil.getTrampoline();

    private MethodUtil() {
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?>[] classArray) throws NoSuchMethodException {
        ReflectUtil.checkPackageAccess(clazz);
        return clazz.getMethod(string, classArray);
    }

    public static Method[] getMethods(Class<?> clazz) {
        ReflectUtil.checkPackageAccess(clazz);
        return clazz.getMethods();
    }

    public static Module getTrampolineModule() {
        return bounce.getDeclaringClass().getModule();
    }

    public static Object invoke(Method method, Object object, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        try {
            return bounce.invoke(null, method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvocationTargetException) {
                throw (InvocationTargetException)throwable;
            }
            if (throwable instanceof IllegalAccessException) {
                throw (IllegalAccessException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("Unexpected invocation error", throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Unexpected invocation error", illegalAccessException);
        }
    }

    private static Method getTrampoline() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Class clazz = MethodUtil.getTrampolineClass();
                    Class[] classArray = new Class[]{Method.class, Object.class, Object[].class};
                    Method method = clazz.getDeclaredMethod("invoke", classArray);
                    method.setAccessible(true);
                    return method;
                }
            });
        }
        catch (Exception exception) {
            throw new InternalError("bouncer cannot be found", exception);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        ReflectUtil.checkPackageAccess(string);
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.getParent().loadClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        block9: {
            Class<?> clazz;
            block10: {
                if (!string.startsWith("com.sun.javafx.reflect.")) {
                    throw new ClassNotFoundException(string);
                }
                String string2 = string.replace('.', '/').concat(".class");
                InputStream inputStream = MethodUtil.class.getModule().getResourceAsStream(string2);
                if (inputStream == null) break block9;
                InputStream inputStream2 = inputStream;
                try {
                    byte[] byArray = inputStream.readAllBytes();
                    clazz = this.defineClass(string, byArray);
                    if (inputStream2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new ClassNotFoundException(string, iOException);
                    }
                }
                inputStream2.close();
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private Class<?> defineClass(String string, byte[] byArray) throws IOException {
        CodeSource codeSource = new CodeSource(null, (Certificate[])null);
        if (!string.equals("com.sun.javafx.reflect.Trampoline")) {
            throw new IOException("MethodUtil: bad name " + string);
        }
        return this.defineClass(string, byArray, 0, byArray.length, codeSource);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }

    private static Class<?> getTrampolineClass() {
        try {
            return Class.forName("com.sun.javafx.reflect.Trampoline", true, new MethodUtil());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

