﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcases/ConnectCases_EXPORTS.h>
#include <aws/connectcases/model/CustomFieldsFilter.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace ConnectCases
{
namespace Model
{

  /**
   * <p>A filter for related items of type <code>Custom</code>.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CustomFilter">AWS
   * API Reference</a></p>
   */
  class CustomFilter
  {
  public:
    AWS_CONNECTCASES_API CustomFilter() = default;
    AWS_CONNECTCASES_API CustomFilter(Aws::Utils::Json::JsonView jsonValue);
    AWS_CONNECTCASES_API CustomFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CONNECTCASES_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Filter conditions for custom fields.</p>
     */
    inline const CustomFieldsFilter& GetFields() const { return m_fields; }
    inline bool FieldsHasBeenSet() const { return m_fieldsHasBeenSet; }
    template<typename FieldsT = CustomFieldsFilter>
    void SetFields(FieldsT&& value) { m_fieldsHasBeenSet = true; m_fields = std::forward<FieldsT>(value); }
    template<typename FieldsT = CustomFieldsFilter>
    CustomFilter& WithFields(FieldsT&& value) { SetFields(std::forward<FieldsT>(value)); return *this;}
    ///@}
  private:

    CustomFieldsFilter m_fields;
    bool m_fieldsHasBeenSet = false;
  };

} // namespace Model
} // namespace ConnectCases
} // namespace Aws
