/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.UndertowConnectorLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

public final class DirectByteBufferDeallocator {
    private static final boolean SUPPORTED;
    private static final Method cleaner;
    private static final Method cleanerClean;
    private static final Unsafe UNSAFE;

    private DirectByteBufferDeallocator() {
    }

    public static void free(ByteBuffer buffer) {
        if (SUPPORTED && buffer != null && buffer.isDirect()) {
            try {
                if (UNSAFE != null) {
                    cleanerClean.invoke((Object)UNSAFE, buffer);
                } else {
                    Object cleaner = DirectByteBufferDeallocator.cleaner.invoke((Object)buffer, new Object[0]);
                    cleanerClean.invoke(cleaner, new Object[0]);
                }
            }
            catch (Throwable t) {
                UndertowConnectorLogger.ROOT_LOGGER.directBufferDeallocationFailed(t);
            }
        }
    }

    private static Unsafe getUnsafe() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

                @Override
                public Unsafe run() {
                    return DirectByteBufferDeallocator.getUnsafe0();
                }
            });
        }
        return DirectByteBufferDeallocator.getUnsafe0();
    }

    private static Unsafe getUnsafe0() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Throwable t) {
            throw new RuntimeException("JDK did not allow accessing unsafe", t);
        }
    }

    static {
        boolean supported;
        String versionString = System.getProperty("java.specification.version");
        if (versionString.startsWith("1.")) {
            versionString = versionString.substring(2);
        }
        int version = Integer.parseInt(versionString);
        Method tmpCleaner = null;
        Method tmpCleanerClean = null;
        Unsafe tmpUnsafe = null;
        if (version < 9) {
            try {
                tmpCleaner = Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
                tmpCleaner.setAccessible(true);
                tmpCleanerClean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                tmpCleanerClean.setAccessible(true);
                supported = true;
            }
            catch (Throwable t) {
                UndertowConnectorLogger.ROOT_LOGGER.directBufferDeallocatorInitializationFailed(t);
                supported = false;
            }
        } else {
            tmpUnsafe = DirectByteBufferDeallocator.getUnsafe();
            try {
                tmpCleanerClean = tmpUnsafe.getClass().getDeclaredMethod("invokeCleaner", ByteBuffer.class);
                tmpCleanerClean.setAccessible(true);
                supported = true;
            }
            catch (Throwable t) {
                UndertowConnectorLogger.ROOT_LOGGER.directBufferDeallocatorInitializationFailed(t);
                supported = false;
            }
        }
        SUPPORTED = supported;
        cleaner = tmpCleaner;
        cleanerClean = tmpCleanerClean;
        UNSAFE = tmpUnsafe;
    }
}

