﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/waf/WAF_EXPORTS.h>
#include <aws/waf/model/WebACLSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WAF {
namespace Model {
class ListWebACLsResult {
 public:
  AWS_WAF_API ListWebACLsResult() = default;
  AWS_WAF_API ListWebACLsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WAF_API ListWebACLsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>If you have more <code>WebACL</code> objects than the number that you
   * specified for <code>Limit</code> in the request, the response includes a
   * <code>NextMarker</code> value. To list more <code>WebACL</code> objects, submit
   * another <code>ListWebACLs</code> request, and specify the
   * <code>NextMarker</code> value from the response in the <code>NextMarker</code>
   * value in the next request.</p>
   */
  inline const Aws::String& GetNextMarker() const { return m_nextMarker; }
  template <typename NextMarkerT = Aws::String>
  void SetNextMarker(NextMarkerT&& value) {
    m_nextMarkerHasBeenSet = true;
    m_nextMarker = std::forward<NextMarkerT>(value);
  }
  template <typename NextMarkerT = Aws::String>
  ListWebACLsResult& WithNextMarker(NextMarkerT&& value) {
    SetNextMarker(std::forward<NextMarkerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of <a>WebACLSummary</a> objects.</p>
   */
  inline const Aws::Vector<WebACLSummary>& GetWebACLs() const { return m_webACLs; }
  template <typename WebACLsT = Aws::Vector<WebACLSummary>>
  void SetWebACLs(WebACLsT&& value) {
    m_webACLsHasBeenSet = true;
    m_webACLs = std::forward<WebACLsT>(value);
  }
  template <typename WebACLsT = Aws::Vector<WebACLSummary>>
  ListWebACLsResult& WithWebACLs(WebACLsT&& value) {
    SetWebACLs(std::forward<WebACLsT>(value));
    return *this;
  }
  template <typename WebACLsT = WebACLSummary>
  ListWebACLsResult& AddWebACLs(WebACLsT&& value) {
    m_webACLsHasBeenSet = true;
    m_webACLs.emplace_back(std::forward<WebACLsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListWebACLsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextMarker;

  Aws::Vector<WebACLSummary> m_webACLs;

  Aws::String m_requestId;
  bool m_nextMarkerHasBeenSet = false;
  bool m_webACLsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAF
}  // namespace Aws
