/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

class Utils {
    Utils() {
    }

    static File getPathToJar(Class<?> clazz) {
        URL frameworkUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            return new File(frameworkUrl.toURI()).getCanonicalFile().getParentFile();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static void setDefineIfNeeded(String name, String value) {
        if (Utils.isDefineNotSet(name)) {
            Utils.setDefine(name, value);
        }
    }

    static boolean isDefineNotSet(String name) {
        return System.getProperty(name, null) == null;
    }

    static String setDefine(String name, String value) {
        return System.setProperty(name, value);
    }
}

