/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.geom.plane.AffineTransform;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;

public class Label
extends GraphShape {
    private Font font;
    private float fontScale;
    private CharSequence text;
    private final Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){

        @Override
        public void visit(Font.Glyph glyph, AffineTransform affineTransform) {
            if (!glyph.isNonContour()) {
                OutlineShape outlineShape = glyph.getShape();
                outlineShape.setSharpness(Label.this.oshapeSharpness);
                Label.this.region.addOutlineShape(outlineShape, affineTransform, Label.this.rgbaColor);
            }
        }
    };

    public Label(int n, Font font, float f, CharSequence charSequence) {
        super(n);
        this.font = font;
        this.fontScale = f;
        this.text = charSequence;
    }

    public Label(int n, Font font, CharSequence charSequence) {
        this(n, font, 1.0f, charSequence);
    }

    public CharSequence getText() {
        return this.text;
    }

    public boolean setText(CharSequence charSequence) {
        if (!this.text.equals(charSequence)) {
            this.text = charSequence;
            this.markShapeDirty();
            return true;
        }
        return false;
    }

    public boolean setText(GL2ES2 gL2ES2, CharSequence charSequence) {
        if (this.setText(charSequence)) {
            this.validate(gL2ES2);
            return true;
        }
        return false;
    }

    public boolean setText(GLProfile gLProfile, CharSequence charSequence) {
        if (this.setText(charSequence)) {
            this.validate(gLProfile);
            return true;
        }
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
            this.markShapeDirty();
            return true;
        }
        return false;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public float getLineHeight() {
        return this.fontScale * this.font.getLineHeight();
    }

    public float getScaledLineHeight() {
        return this.getScale().y() * this.fontScale * this.font.getLineHeight();
    }

    public boolean setFontScale(float f) {
        if (this.fontScale != f) {
            this.fontScale = f;
            this.markShapeDirty();
            return true;
        }
        return false;
    }

    public static AABBox getUnscaledGlyphBounds(Font font, CharSequence charSequence) {
        return font.getGlyphBounds(charSequence);
    }

    public AABBox getUnscaledGlyphBounds() {
        return Label.getUnscaledGlyphBounds(this.font, this.text);
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        AffineTransform affineTransform3 = new AffineTransform();
        int[] nArray = TextRegionUtil.countStringRegion(this.font, this.text, new int[2]);
        this.resetGLRegion(gLProfile, gL2ES2, null, nArray[0], nArray[1]);
        AABBox aABBox = this.font.getGlyphBounds(this.text, affineTransform2, affineTransform3);
        affineTransform.setToScale(this.fontScale, this.fontScale);
        affineTransform.translate(-aABBox.getMinX(), -aABBox.getMinY(), affineTransform2);
        aABBox = this.font.processString(this.glyphVisitor, affineTransform, this.text, affineTransform2, affineTransform3);
        this.setRotationPivot(aABBox.getCenter());
        this.box.copy(aABBox);
    }

    @Override
    public String getSubString() {
        int n = Math.min(this.text.length(), 8);
        return super.getSubString() + ", fscale " + this.fontScale + ", '" + this.text.subSequence(0, n) + "'";
    }
}

