/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.jvm.toolchain.internal.FileBasedInstallationFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.jspecify.annotations.Nullable;

public class JabbaInstallationSupplier
implements InstallationSupplier {
    private final ToolchainConfiguration toolchainConfiguration;

    @Inject
    public JabbaInstallationSupplier(ToolchainConfiguration toolchainConfiguration) {
        this.toolchainConfiguration = toolchainConfiguration;
    }

    @Override
    public String getSourceName() {
        return "Jabba";
    }

    @Override
    public Set<InstallationLocation> get() {
        return this.findJavaCandidates(this.toolchainConfiguration.getJabbaHomeDirectory());
    }

    private Set<InstallationLocation> findJavaCandidates(@Nullable File candidatesDir) {
        if (candidatesDir != null) {
            File root = new File(candidatesDir, "jdk");
            return FileBasedInstallationFactory.fromDirectory(root, this.getSourceName(), InstallationLocation::autoDetected);
        }
        return Collections.emptySet();
    }
}

