/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import com.google.common.base.Optional;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.semanticweb.owlapi.formats.RioRDFDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.rio.RioRenderer;
import org.semanticweb.owlapi.util.AbstractOWLStorer;

public class RioStorer
extends AbstractOWLStorer {
    private static final long serialVersionUID = 40000L;
    private transient RDFHandler rioHandler;
    private final OWLDocumentFormatFactory ontFormat;
    private final Resource[] contexts;

    public RioStorer(OWLDocumentFormatFactory ontologyFormat, RDFHandler rioHandler, Resource ... contexts) {
        this(ontologyFormat, contexts);
        this.rioHandler = rioHandler;
    }

    public RioStorer(OWLDocumentFormatFactory ontologyFormat, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.ontFormat = ontologyFormat;
        this.contexts = contexts;
    }

    @Override
    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return this.ontFormat.createFormat().equals(ontologyFormat);
    }

    protected RDFHandler getRDFHandlerForWriter(@Nullable RDFFormat format, Writer writer, @Nullable String baseIRI) throws OWLOntologyStorageException {
        if (format == null) {
            return new StatementCollector();
        }
        try {
            return this.getWriter(format, writer, baseIRI);
        }
        catch (URISyntaxException | UnsupportedRDFormatException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    protected RDFWriter getWriter(RDFFormat format, Writer writer, @Nullable String baseIRI) throws URISyntaxException {
        if (baseIRI == null || format.equals((Object)RDFFormat.RDFXML)) {
            return Rio.createWriter((RDFFormat)format, (Writer)writer);
        }
        return Rio.createWriter((RDFFormat)format, (Writer)writer, (String)baseIRI);
    }

    protected static RDFHandler getRDFHandlerForOutputStream(RDFFormat format, OutputStream outputStream) throws OWLOntologyStorageException {
        if (format == null) {
            return new StatementCollector();
        }
        try {
            return Rio.createWriter((RDFFormat)format, (OutputStream)outputStream);
        }
        catch (UnsupportedRDFormatException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    public RDFHandler getRioHandler() {
        return this.rioHandler;
    }

    public void setRioHandler(RDFHandler rioHandler) {
        this.rioHandler = rioHandler;
    }

    @Override
    protected void storeOntology(@Nonnull OWLOntology ontology, Writer writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (this.rioHandler == null) {
            if (!(format instanceof RioRDFDocumentFormat)) {
                throw new OWLOntologyStorageException("Unable to use RioOntologyStorer to store this format as it is not recognised as a RioRDFOntologyFormat: " + format);
            }
            RioRDFDocumentFormat rioFormat = (RioRDFDocumentFormat)format;
            if (format.isTextual()) {
                this.rioHandler = this.getRDFHandlerForWriter(rioFormat.getRioFormat(), writer, format.isPrefixOWLOntologyFormat() ? format.asPrefixOWLOntologyFormat().getDefaultPrefix() : null);
            } else {
                throw new OWLOntologyStorageException("Unable to use storeOntology with a Writer as the desired format is not textual. Format was " + format);
            }
        }
        try {
            this.addSettingsIfPresent(format);
            RioRenderer ren = new RioRenderer(ontology, this.rioHandler, format, this.contexts(ontology, format));
            ren.render();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Override
    protected void storeOntology(@Nonnull OWLOntology ontology, OutputStream outputStream, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (this.rioHandler == null) {
            if (!(format instanceof RioRDFDocumentFormat)) {
                throw new OWLOntologyStorageException("Unable to use RioOntologyStorer to store this format as it is not recognised as a RioRDFOntologyFormat: " + format);
            }
            RioRDFDocumentFormat rioFormat = (RioRDFDocumentFormat)format;
            if (format.isTextual()) {
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                    this.rioHandler = this.getRDFHandlerForWriter(rioFormat.getRioFormat(), writer, format.isPrefixOWLOntologyFormat() ? format.asPrefixOWLOntologyFormat().getDefaultPrefix() : null);
                }
                catch (IOException e) {
                    throw new OWLOntologyStorageException(e);
                }
            } else {
                this.rioHandler = RioStorer.getRDFHandlerForOutputStream(rioFormat.getRioFormat(), outputStream);
            }
        }
        try {
            this.addSettingsIfPresent(format);
            RioRenderer ren = new RioRenderer(ontology, this.rioHandler, format, this.contexts(ontology, format));
            ren.render();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    private Resource[] contexts(OWLOntology o, OWLDocumentFormat d) {
        Serializable namedGraphOverride;
        Optional<org.semanticweb.owlapi.model.IRI> ontologyIRI;
        boolean shouldUseOntologyIRI = o.getOWLOntologyManager().getOntologyLoaderConfiguration().shouldOutputNamedGraphIRI();
        String namedGraph = null;
        if (shouldUseOntologyIRI && (ontologyIRI = o.getOntologyID().getOntologyIRI()).isPresent()) {
            namedGraph = ((org.semanticweb.owlapi.model.IRI)ontologyIRI.get()).toString();
        }
        if ((namedGraphOverride = d.getParameter((Serializable)((Object)"namedGraphOverride"), (Serializable)((Object)namedGraph))) != null) {
            IRI context = SimpleValueFactory.getInstance().createIRI(namedGraphOverride.toString());
            if (this.contexts.length == 0) {
                return new Resource[]{context};
            }
            Resource[] toReturn = new Resource[this.contexts.length + 1];
            System.arraycopy(this.contexts, 0, toReturn, 0, this.contexts.length);
            toReturn[this.contexts.length] = context;
            return toReturn;
        }
        return this.contexts;
    }

    protected void addSettingsIfPresent(OWLDocumentFormat format) {
        if (this.rioHandler instanceof RDFWriter) {
            RDFWriter w = (RDFWriter)this.rioHandler;
            Collection<RioSetting<?>> supportedSettings = this.knownSettings(w);
            for (RioSetting<?> r : supportedSettings) {
                Serializable v = format.getParameter((Serializable)r, null);
                if (v == null) continue;
                w.getWriterConfig().set(r, (Object)v);
            }
        }
    }

    protected Collection<RioSetting<?>> knownSettings(RDFWriter w) {
        try {
            return w.getSupportedSettings();
        }
        catch (UnsupportedOperationException e) {
            LOGGER.debug("Bug in RIO means this exception is thrown in some formats where an unmodifiable class is modified.  As a workaround, OWLAPI will try all the known settings - relying on the caller to only use supported settings.", (Throwable)e);
            return Arrays.asList(JSONLDSettings.COMPACT_ARRAYS, JSONLDSettings.HIERARCHICAL_VIEW, JSONLDSettings.JSONLD_MODE, JSONLDSettings.OPTIMIZE, JSONLDSettings.USE_NATIVE_TYPES, JSONLDSettings.USE_RDF_TYPE, BasicWriterSettings.BASE_DIRECTIVE, BasicWriterSettings.INLINE_BLANK_NODES, BasicWriterSettings.PRETTY_PRINT, BasicWriterSettings.RDF_LANGSTRING_TO_LANG_LITERAL, BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL, NTriplesWriterSettings.ESCAPE_UNICODE);
        }
    }
}

