/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionChangeSupport;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.FurnitureCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FurnitureCatalog {
    private List<FurnitureCategory> categories = new ArrayList<FurnitureCategory>();
    private final CollectionChangeSupport<CatalogPieceOfFurniture> furnitureChangeSupport = new CollectionChangeSupport(this);

    public List<FurnitureCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public int getCategoriesCount() {
        return this.categories.size();
    }

    public FurnitureCategory getCategory(int n) {
        return this.categories.get(n);
    }

    public void addFurnitureListener(CollectionListener<CatalogPieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.addCollectionListener(collectionListener);
    }

    public void removeFurnitureListener(CollectionListener<CatalogPieceOfFurniture> collectionListener) {
        this.furnitureChangeSupport.removeCollectionListener(collectionListener);
    }

    public void add(FurnitureCategory furnitureCategory, CatalogPieceOfFurniture catalogPieceOfFurniture) {
        int n = Collections.binarySearch(this.categories, furnitureCategory);
        if (n < 0) {
            furnitureCategory = new FurnitureCategory(furnitureCategory.getName());
            this.categories.add(-n - 1, furnitureCategory);
        } else {
            furnitureCategory = this.categories.get(n);
        }
        furnitureCategory.add(catalogPieceOfFurniture);
        this.furnitureChangeSupport.fireCollectionChanged(catalogPieceOfFurniture, furnitureCategory.getIndexOfPieceOfFurniture(catalogPieceOfFurniture), CollectionEvent.Type.ADD);
    }

    public void delete(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        int n;
        FurnitureCategory furnitureCategory = catalogPieceOfFurniture.getCategory();
        if (furnitureCategory != null && (n = furnitureCategory.getIndexOfPieceOfFurniture(catalogPieceOfFurniture)) >= 0) {
            furnitureCategory.delete(catalogPieceOfFurniture);
            if (furnitureCategory.getFurnitureCount() == 0) {
                this.categories = new ArrayList<FurnitureCategory>(this.categories);
                this.categories.remove(furnitureCategory);
            }
            this.furnitureChangeSupport.fireCollectionChanged(catalogPieceOfFurniture, n, CollectionEvent.Type.DELETE);
            return;
        }
        throw new IllegalArgumentException("catalog doesn't contain piece " + catalogPieceOfFurniture.getName());
    }

    public CatalogPieceOfFurniture getPieceOfFurnitureWithId(String string) {
        for (FurnitureCategory furnitureCategory : this.categories) {
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                if (!string.equals(catalogPieceOfFurniture.getId())) continue;
                return catalogPieceOfFurniture;
            }
        }
        return null;
    }
}

