﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotfleetwise/IoTFleetWise_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTFleetWise {
namespace Model {

/**
 * <p>A group of signals that are defined in a hierarchical
 * structure.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotfleetwise-2021-06-17/Branch">AWS
 * API Reference</a></p>
 */
class Branch {
 public:
  AWS_IOTFLEETWISE_API Branch() = default;
  AWS_IOTFLEETWISE_API Branch(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTFLEETWISE_API Branch& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTFLEETWISE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The fully qualified name of the branch. For example, the fully qualified name
   * of a branch might be <code>Vehicle.Body.Engine</code>.</p>
   */
  inline const Aws::String& GetFullyQualifiedName() const { return m_fullyQualifiedName; }
  inline bool FullyQualifiedNameHasBeenSet() const { return m_fullyQualifiedNameHasBeenSet; }
  template <typename FullyQualifiedNameT = Aws::String>
  void SetFullyQualifiedName(FullyQualifiedNameT&& value) {
    m_fullyQualifiedNameHasBeenSet = true;
    m_fullyQualifiedName = std::forward<FullyQualifiedNameT>(value);
  }
  template <typename FullyQualifiedNameT = Aws::String>
  Branch& WithFullyQualifiedName(FullyQualifiedNameT&& value) {
    SetFullyQualifiedName(std::forward<FullyQualifiedNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A brief description of the branch.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  Branch& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The deprecation message for the node or the branch that was moved or
   * deleted.</p>
   */
  inline const Aws::String& GetDeprecationMessage() const { return m_deprecationMessage; }
  inline bool DeprecationMessageHasBeenSet() const { return m_deprecationMessageHasBeenSet; }
  template <typename DeprecationMessageT = Aws::String>
  void SetDeprecationMessage(DeprecationMessageT&& value) {
    m_deprecationMessageHasBeenSet = true;
    m_deprecationMessage = std::forward<DeprecationMessageT>(value);
  }
  template <typename DeprecationMessageT = Aws::String>
  Branch& WithDeprecationMessage(DeprecationMessageT&& value) {
    SetDeprecationMessage(std::forward<DeprecationMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A comment in addition to the description.</p>
   */
  inline const Aws::String& GetComment() const { return m_comment; }
  inline bool CommentHasBeenSet() const { return m_commentHasBeenSet; }
  template <typename CommentT = Aws::String>
  void SetComment(CommentT&& value) {
    m_commentHasBeenSet = true;
    m_comment = std::forward<CommentT>(value);
  }
  template <typename CommentT = Aws::String>
  Branch& WithComment(CommentT&& value) {
    SetComment(std::forward<CommentT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_fullyQualifiedName;
  bool m_fullyQualifiedNameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::String m_deprecationMessage;
  bool m_deprecationMessageHasBeenSet = false;

  Aws::String m_comment;
  bool m_commentHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTFleetWise
}  // namespace Aws
