// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { formatError } from "./logging.js";
/**
 * @internal
 */
export function checkSubscription(logger, subscription) {
    if (!subscription.match(/^[0-9a-zA-Z-._ ]+$/)) {
        const error = new Error(`Subscription '${subscription}' contains invalid characters. If this is the name of a subscription, use ` +
            `its ID instead. You can locate your subscription by following the instructions listed here: ` +
            `https://learn.microsoft.com/azure/azure-portal/get-subscription-tenant-id`);
        logger.info(formatError("", error));
        throw error;
    }
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/7d842fb85a0275a4a8e4d7e040d2625abbf7f084/node_modules/@azure/identity/dist/workerd/util/subscriptionUtils.js.map