/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import java.io.File;
import java.io.IOException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultMetadataFileSource;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataFileSource;
import org.gradle.api.internal.filestore.ArtifactIdentifierFileStore;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.PersistentModuleSource;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class DefaultMetadataFileSourceCodec
implements PersistentModuleSource.Codec<MetadataFileSource> {
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ArtifactIdentifierFileStore fileStore;

    public DefaultMetadataFileSourceCodec(ImmutableModuleIdentifierFactory moduleIdentifierFactory, ArtifactIdentifierFileStore fileStore) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.fileStore = fileStore;
    }

    @Override
    public void encode(MetadataFileSource moduleSource, Encoder encoder) throws IOException {
        ModuleComponentArtifactIdentifier artifactId = moduleSource.getArtifactId();
        ModuleComponentIdentifier componentIdentifier = artifactId.getComponentIdentifier();
        encoder.writeString((CharSequence)componentIdentifier.getGroup());
        encoder.writeString((CharSequence)componentIdentifier.getModule());
        encoder.writeString((CharSequence)componentIdentifier.getVersion());
        encoder.writeString((CharSequence)artifactId.getFileName());
        encoder.writeBinary(moduleSource.getSha1().toByteArray());
    }

    @Override
    public MetadataFileSource decode(Decoder decoder) throws IOException {
        String group = decoder.readString();
        String module = decoder.readString();
        String version = decoder.readString();
        String name = decoder.readString();
        byte[] sha1 = decoder.readBinary();
        DefaultMetadataFileSource source = this.createSource(sha1, group, module, version, name);
        return source;
    }

    private DefaultMetadataFileSource createSource(byte[] sha1, String group, String module, String version, String name) {
        ModuleComponentFileArtifactIdentifier artifactId = this.createArtifactId(group, module, version, name);
        HashCode hashCode = HashCode.fromBytes((byte[])sha1);
        File metadataFile = this.fileStore.whereIs(artifactId, hashCode.toString());
        return new DefaultMetadataFileSource(artifactId, metadataFile, hashCode);
    }

    private ModuleComponentFileArtifactIdentifier createArtifactId(String group, String module, String version, String name) {
        return new ModuleComponentFileArtifactIdentifier(DefaultModuleComponentIdentifier.newId(this.moduleIdentifierFactory.module(group, module), version), name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.moduleIdentifierFactory.hashCode();
    }
}

