/*
   igraph library.
   Copyright (C) 2009-2025  The igraph development team <igraph@igraph.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

#ifndef IGRAPH_HEAP_H
#define IGRAPH_HEAP_H

#include "igraph_decls.h"
#include "igraph_error.h"
#include "igraph_types.h"

IGRAPH_BEGIN_C_DECLS

/* -------------------------------------------------- */
/* Heap                                               */
/* -------------------------------------------------- */

/**
 * Heap data type.
 * \ingroup internal
 */

#define BASE_IGRAPH_REAL
#define HEAP_TYPE_MAX
#include "igraph_pmt.h"
#include "igraph_heap_pmt.h"
#include "igraph_pmt_off.h"
#undef HEAP_TYPE_MAX
#define HEAP_TYPE_MIN
#include "igraph_pmt.h"
#include "igraph_heap_pmt.h"
#include "igraph_pmt_off.h"
#undef HEAP_TYPE_MIN
#undef BASE_IGRAPH_REAL

#define BASE_INT
#define HEAP_TYPE_MAX
#include "igraph_pmt.h"
#include "igraph_heap_pmt.h"
#include "igraph_pmt_off.h"
#undef HEAP_TYPE_MAX
#define HEAP_TYPE_MIN
#include "igraph_pmt.h"
#include "igraph_heap_pmt.h"
#include "igraph_pmt_off.h"
#undef HEAP_TYPE_MIN
#undef BASE_INT

#define BASE_CHAR
#define HEAP_TYPE_MAX
#include "igraph_pmt.h"
#include "igraph_heap_pmt.h"
#include "igraph_pmt_off.h"
#undef HEAP_TYPE_MAX
#define HEAP_TYPE_MIN
#include "igraph_pmt.h"
#include "igraph_heap_pmt.h"
#include "igraph_pmt_off.h"
#undef HEAP_TYPE_MIN
#undef BASE_CHAR

#define IGRAPH_HEAP_NULL { 0,0,0 }

IGRAPH_END_C_DECLS

#endif
