/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import javajs.util.Lst;
import javax.swing.JTextField;
import jspecview.common.JSViewer;

public class CommandHistory {
    private JSViewer vwr;
    private JTextField input;
    private Lst<String> cmdList = new Lst();
    private int cmdPt = -1;
    private int cmdOffset = 0;

    public CommandHistory(JSViewer jSViewer, JTextField jTextField) {
        this.vwr = jSViewer;
        this.input = jTextField;
    }

    public void keyPressed(int n) {
        switch (n) {
            case 27: {
                this.input.setText("");
                return;
            }
            case 10: {
                String string = this.input.getText();
                this.addCommand(string);
                this.vwr.runScript(string);
                this.input.setText("");
                this.input.requestFocusInWindow();
                return;
            }
            case 38: 
            case 40: {
                String string = this.recallCommand(n == 38);
                if (string == null) break;
                this.input.setText(string);
            }
        }
    }

    private synchronized String recallCommand(boolean bl) {
        int n;
        this.cmdOffset = 0;
        if (bl) {
            if (this.cmdPt < 0 || this.cmdPt == this.cmdList.size()) {
                return "";
            }
            this.cmdOffset = -1;
        } else {
            if (this.cmdPt <= 0) {
                return "";
            }
            if (--this.cmdPt < 0) {
                this.cmdPt = 0;
            }
        }
        if (bl) {
            int n2 = this.cmdPt;
            n = n2;
            this.cmdPt = n2 + 1;
        } else {
            n = this.cmdPt;
        }
        String string = (String)this.cmdList.get(n);
        return string;
    }

    private void addCommand(String string) {
        this.cmdPt += this.cmdOffset;
        this.cmdOffset = 0;
        if (this.cmdPt < 0) {
            this.cmdPt = 0;
        }
        if (this.cmdPt < this.cmdList.size() && ((String)this.cmdList.get(this.cmdPt)).equals(string)) {
            return;
        }
        this.cmdList.add(this.cmdPt, string);
    }

    void dumpList() {
        int n = 0;
        while (n < this.cmdList.size()) {
            System.out.println(String.valueOf(n == this.cmdPt ? ">" : "") + n + "\t" + (String)this.cmdList.get(n));
            ++n;
        }
        System.out.println("");
    }
}

