/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate1_9_0_Final
extends CustomKeycloakTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String userFederationProviderTableName = this.database.correctObjectName("USER_FEDERATION_PROVIDER", Table.class);
        try {
            try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select REALM_ID, USERFEDERATIONPROVIDERS_ID from " + this.getTableName("FED_PROVIDERS"));
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String realmId = resultSet.getString(1);
                    String userFederationProviderId = resultSet.getString(2);
                    UpdateStatement updateStatement = new UpdateStatement(null, null, userFederationProviderTableName).addNewColumnValue("REALM_ID", (Object)realmId).setWhereClause("ID='" + userFederationProviderId + "'");
                    this.statements.add(updateStatement);
                }
            }
            this.confirmationMessage.append("Updated " + this.statements.size() + " records in USER_FEDERATION_PROVIDER table");
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Update 1.9.0.Final";
    }
}

