/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.jideoss.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.icons.FlatTabbedPaneCloseIcon;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.UIScale;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatJideTabbedPaneUI
extends BasicJideTabbedPaneUI {
    protected Color foreground;
    protected Color disabledForeground;
    protected Color selectedBackground;
    protected Color underlineColor;
    protected Color disabledUnderlineColor;
    protected Color hoverColor;
    protected Color focusColor;
    protected Color tabSeparatorColor;
    protected Color contentAreaColor;
    protected int tabHeight;
    protected int tabSelectionHeight;
    protected int contentSeparatorHeight;
    protected boolean showTabSeparators;
    protected boolean tabSeparatorsFullHeight;
    protected boolean hasFullBorder;
    protected boolean tabsOverlapBorder;
    protected Icon closeIcon;
    protected Icon arrowIcon;
    protected String arrowType;
    protected Insets buttonInsets;
    protected int buttonArc;
    protected Color buttonHoverBackground;
    protected Color buttonPressedBackground;
    protected int closeButtonLeftMarginUnscaled;
    protected int closeButtonRightMarginUnscaled;
    private Object[] oldRenderingHints;

    public static ComponentUI createUI(JComponent c) {
        LookAndFeelFactory.installJideExtension();
        return new FlatJideTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this._background = UIDefaultsLookup.getColor("JideTabbedPane.background");
        this.foreground = UIManager.getColor("TabbedPane.foreground");
        this.disabledForeground = UIManager.getColor("TabbedPane.disabledForeground");
        this.selectedBackground = UIManager.getColor("TabbedPane.selectedBackground");
        this.underlineColor = UIManager.getColor("TabbedPane.underlineColor");
        this.disabledUnderlineColor = UIManager.getColor("TabbedPane.disabledUnderlineColor");
        this.hoverColor = UIManager.getColor("TabbedPane.hoverColor");
        this.focusColor = UIManager.getColor("TabbedPane.focusColor");
        this.tabSeparatorColor = UIManager.getColor("TabbedPane.tabSeparatorColor");
        this.contentAreaColor = UIManager.getColor("TabbedPane.contentAreaColor");
        this.tabHeight = UIManager.getInt("TabbedPane.tabHeight");
        this.tabSelectionHeight = UIManager.getInt("TabbedPane.tabSelectionHeight");
        this.contentSeparatorHeight = UIManager.getInt("TabbedPane.contentSeparatorHeight");
        this.showTabSeparators = UIManager.getBoolean("TabbedPane.showTabSeparators");
        this.tabSeparatorsFullHeight = UIManager.getBoolean("TabbedPane.tabSeparatorsFullHeight");
        this.hasFullBorder = UIManager.getBoolean("TabbedPane.hasFullBorder");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this.arrowType = UIManager.getString("TabbedPane.arrowType");
        this.buttonInsets = UIManager.getInsets("TabbedPane.buttonInsets");
        this.buttonArc = UIManager.getInt("TabbedPane.buttonArc");
        this.buttonHoverBackground = UIManager.getColor("TabbedPane.buttonHoverBackground");
        this.buttonPressedBackground = UIManager.getColor("TabbedPane.buttonPressedBackground");
        this.closeButtonLeftMarginUnscaled = this._closeButtonLeftMargin;
        this.closeButtonRightMarginUnscaled = this._closeButtonRightMargin;
        this._textIconGap = UIScale.scale(this._textIconGap);
        this.tabHeight = UIScale.scale(this.tabHeight);
        this.tabSelectionHeight = UIScale.scale(this.tabSelectionHeight);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.foreground = null;
        this.disabledForeground = null;
        this.selectedBackground = null;
        this.underlineColor = null;
        this.disabledUnderlineColor = null;
        this.hoverColor = null;
        this.focusColor = null;
        this.tabSeparatorColor = null;
        this.contentAreaColor = null;
        this.buttonHoverBackground = null;
        this.buttonPressedBackground = null;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.closeIcon = new FlatJideTabCloseIcon();
        this.arrowIcon = new FlatJideTabAreaArrowIcon();
        if (this._tabScroller != null) {
            this._tabScroller.scrollForwardButton.setIcon(this.arrowIcon);
            this._tabScroller.scrollBackwardButton.setIcon(this.arrowIcon);
            this._tabScroller.listButton.setIcon(this.arrowIcon);
            this._tabScroller.closeButton.setIcon(this.closeIcon);
            this._tabScroller.scrollForwardButton.setContentAreaFilled(false);
            this._tabScroller.scrollBackwardButton.setContentAreaFilled(false);
            this._tabScroller.listButton.setContentAreaFilled(false);
            this._tabScroller.closeButton.setContentAreaFilled(false);
        }
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        this.closeIcon = null;
        this.arrowIcon = null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener superListener = super.createPropertyChangeListener();
        return e -> {
            superListener.propertyChange(e);
            switch (e.getPropertyName()) {
                case "selectedIndex": {
                    this.repaintTab((Integer)e.getOldValue());
                    this.repaintTab((Integer)e.getNewValue());
                    break;
                }
                case "tabAreaInsets": 
                case "tabInsets": 
                case "gripper": 
                case "JTabbedPane.showTabSeparators": 
                case "JTabbedPane.hasFullBorder": {
                    this._tabPane.revalidate();
                    this._tabPane.repaint();
                }
            }
        };
    }

    private void repaintTab(int tabIndex) {
        if (tabIndex < 0 || tabIndex >= this._tabPane.getTabCount()) {
            return;
        }
        Rectangle r = this.getTabBounds(this._tabPane, tabIndex);
        if (r != null) {
            this._tabPane.repaint(r);
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return new BasicJideTabbedPaneUI.RolloverMouseHandler(this);
    }

    @Override
    protected MouseMotionListener createMouseMotionListener() {
        return new BasicJideTabbedPaneUI.RolloverMouseMotionHandler(this);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return this._tabPane.getTabLayoutPolicy() == 1 ? new FlatJideTabbedPaneScrollLayout() : super.createLayoutManager();
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, FontMetrics metrics) {
        this.updateCloseButtonMargins();
        return Math.max(this.tabHeight, super.calculateTabHeight(tabPlacement, tabIndex, metrics));
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        this.updateCloseButtonMargins();
        return Math.max(this.tabHeight, super.calculateTabWidth(tabPlacement, tabIndex, metrics) - 3);
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return UIScale.scale(super.getTabInsets(tabPlacement, tabIndex));
    }

    @Override
    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        return UIScale.scale(super.getSelectedTabPadInsets(tabPlacement));
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        return UIScale.scale(super.getTabAreaInsets(tabPlacement));
    }

    @Override
    protected int getTabShape() {
        return 3;
    }

    @Override
    protected int getLeftMargin() {
        return 0;
    }

    @Override
    protected int getTabGap() {
        return 0;
    }

    @Override
    protected int getLayoutSize() {
        return 0;
    }

    @Override
    protected int getTabRightPadding() {
        return 0;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return FlatUIUtils.addInsets(this.getContentBorderInsets0(tabPlacement), UIScale.scale(super.getContentBorderInsets(tabPlacement)));
    }

    private Insets getContentBorderInsets0(int tabPlacement) {
        boolean hasFullBorder = FlatClientProperties.clientPropertyBoolean(this._tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int sh = UIScale.scale(this.contentSeparatorHeight);
        Insets insets = hasFullBorder ? new Insets(sh, sh, sh, sh) : new Insets(sh, 0, 0, 0);
        Insets contentBorderInsets = new Insets(0, 0, 0, 0);
        FlatJideTabbedPaneUI.rotateInsets(insets, contentBorderInsets, tabPlacement);
        return contentBorderInsets;
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        this.oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
        super.update(g2, c);
        FlatUIUtils.resetRenderingHints(g2, this.oldRenderingHints);
        this.oldRenderingHints = null;
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        super.paint(g2, c);
        if (!this.scrollableTabLayoutEnabled() && this._tabPane.getTabCount() > 0) {
            this.paintTabArea(g2, this._tabPane.getTabPlacement(), this._tabPane.getSelectedIndex(), c);
        }
    }

    @Override
    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        boolean enabled = this._tabPane.isEnabled();
        g2.setColor(enabled && this._tabPane.isEnabledAt(tabIndex) && (this._indexMouseOver == tabIndex || this._closeButtons != null && ((JideTabbedPane.NoFocusButton)this._closeButtons[tabIndex]).isMouseOver()) ? this.hoverColor : (enabled && isSelected && FlatUIUtils.isPermanentFocusOwner(this._tabPane) ? this.focusColor : (this.selectedBackground != null && enabled && isSelected ? this.selectedBackground : this._tabPane.getBackgroundAt(tabIndex))));
        g2.fillRect(x, y, w, h2);
    }

    @Override
    protected void paintText(Graphics g2, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        if (!this._tabPane.isEnabled() || !this._tabPane.isEnabledAt(tabIndex)) {
            class DisabledTextGraphics
            extends Graphics2DProxy {
                private int count;

                public DisabledTextGraphics(Graphics delegate) {
                    super((Graphics2D)delegate);
                }

                @Override
                public Graphics create() {
                    return new DisabledTextGraphics(super.create());
                }

                @Override
                public void drawString(String str, int x, int y) {
                    ++this.count;
                    if (this.count % 2 != 1) {
                        return;
                    }
                    this.setColor(FlatJideTabbedPaneUI.this.disabledForeground);
                    super.drawString(str, x, y);
                }
            }
            g2 = new DisabledTextGraphics(g2);
        }
        Graphics g22 = g2;
        FlatUIUtils.runWithoutRenderingHints(g2, this.oldRenderingHints, () -> super.paintText(g22, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected));
    }

    @Override
    protected void paintTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        if (FlatClientProperties.clientPropertyBoolean(this._tabPane, "JTabbedPane.showTabSeparators", this.showTabSeparators) && !this.isLastInRun(tabIndex)) {
            this.paintTabSeparator(g2, tabPlacement, x, y, w, h2);
        }
        if (isSelected) {
            this.paintTabSelection(g2, tabPlacement, x, y, w, h2);
        }
    }

    protected void paintTabSeparator(Graphics g2, int tabPlacement, int x, int y, int w, int h2) {
        float sepWidth = UIScale.scale(1.0f);
        float offset = this.tabSeparatorsFullHeight ? 0.0f : UIScale.scale(5.0f);
        g2.setColor(this.tabSeparatorColor != null ? this.tabSeparatorColor : this.contentAreaColor);
        if (tabPlacement == 2 || tabPlacement == 4) {
            ((Graphics2D)g2).fill(new Rectangle2D.Float((float)x + offset, (float)(y + h2) - sepWidth, (float)w - offset * 2.0f, sepWidth));
        } else if (this._tabPane.getComponentOrientation().isLeftToRight()) {
            ((Graphics2D)g2).fill(new Rectangle2D.Float((float)(x + w) - sepWidth, (float)y + offset, sepWidth, (float)h2 - offset * 2.0f));
        } else {
            ((Graphics2D)g2).fill(new Rectangle2D.Float(x, (float)y + offset, sepWidth, (float)h2 - offset * 2.0f));
        }
    }

    protected void paintTabSelection(Graphics g2, int tabPlacement, int x, int y, int w, int h2) {
        Rectangle clipBounds;
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Rectangle rectangle = clipBounds = this.scrollableTabLayoutEnabled() ? g2.getClipBounds() : null;
        if (clipBounds != null) {
            Rectangle newClipBounds = new Rectangle(clipBounds);
            int contentSeparatorHeight = UIScale.scale(this.contentSeparatorHeight);
            switch (tabPlacement) {
                default: {
                    newClipBounds.height += contentSeparatorHeight;
                    break;
                }
                case 3: {
                    newClipBounds.y -= contentSeparatorHeight;
                    newClipBounds.height += contentSeparatorHeight;
                    break;
                }
                case 2: {
                    newClipBounds.width += contentSeparatorHeight;
                    break;
                }
                case 4: {
                    newClipBounds.x -= contentSeparatorHeight;
                    newClipBounds.width += contentSeparatorHeight;
                }
            }
            g2.setClip(newClipBounds);
        }
        g2.setColor(this._tabPane.isEnabled() ? this.underlineColor : this.disabledUnderlineColor);
        Insets contentInsets = this.getContentBorderInsets0(tabPlacement);
        switch (tabPlacement) {
            default: {
                int sy = y + h2 + contentInsets.top - this.tabSelectionHeight;
                g2.fillRect(x, sy, w, this.tabSelectionHeight);
                break;
            }
            case 3: {
                g2.fillRect(x, y - contentInsets.bottom, w, this.tabSelectionHeight);
                break;
            }
            case 2: {
                int sx = x + w + contentInsets.left - this.tabSelectionHeight;
                g2.fillRect(sx, y, this.tabSelectionHeight, h2);
                break;
            }
            case 4: {
                g2.fillRect(x - contentInsets.right, y, this.tabSelectionHeight, h2);
            }
        }
        if (clipBounds != null) {
            g2.setClip(clipBounds);
        }
    }

    @Override
    protected void paintContentBorder(Graphics g2, int tabPlacement, int selectedIndex) {
        if (!this._tabPane.isTabShown()) {
            return;
        }
        Insets insets = this._tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = this._tabPane.getWidth() - insets.right - insets.left;
        int h2 = this._tabPane.getHeight() - insets.top - insets.bottom;
        Dimension lsize = this.isTabLeadingComponentVisible() ? this._tabLeadingComponent.getPreferredSize() : new Dimension();
        Dimension tsize = this.isTabTrailingComponentVisible() ? this._tabTrailingComponent.getPreferredSize() : new Dimension();
        switch (tabPlacement) {
            case 2: {
                x += Math.max(this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth), Math.max(lsize.width, tsize.width));
                if (this.tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this._runCount, this._maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h2 -= this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                h2 += tabAreaInsets.top;
                break;
            }
            default: {
                y += Math.max(this.calculateTabAreaHeight(tabPlacement, this._runCount, this._maxTabHeight), Math.max(lsize.height, tsize.height));
                if (this.tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h2 -= y - insets.top;
            }
        }
        boolean hasFullBorder = FlatClientProperties.clientPropertyBoolean(this._tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int sh = UIScale.scale(this.contentSeparatorHeight * 100);
        Insets ci = new Insets(0, 0, 0, 0);
        FlatJideTabbedPaneUI.rotateInsets(hasFullBorder ? new Insets(sh, sh, sh, sh) : new Insets(sh, 0, 0, 0), ci, tabPlacement);
        g2.setColor(this.contentAreaColor);
        Path2D.Float path = new Path2D.Float(0);
        path.append(new Rectangle2D.Float(x, y, w, h2), false);
        path.append(new Rectangle2D.Float((float)x + (float)ci.left / 100.0f, (float)y + (float)ci.top / 100.0f, (float)w - (float)ci.left / 100.0f - (float)ci.right / 100.0f, (float)h2 - (float)ci.top / 100.0f - (float)ci.bottom / 100.0f), false);
        ((Graphics2D)g2).fill(path);
        if (this.scrollableTabLayoutEnabled() && selectedIndex >= 0 && this._tabScroller != null && this._tabScroller.viewport != null) {
            Rectangle tabRect = this.getTabBounds(this._tabPane, selectedIndex);
            Shape oldClip = g2.getClip();
            g2.setClip(this._tabScroller.viewport.getBounds());
            this.paintTabSelection(g2, tabPlacement, tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            g2.setClip(oldClip);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g2, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            Rectangle tabRect2 = new Rectangle(0, 0, tabRect.height, tabRect.width);
            Rectangle iconRect2 = new Rectangle();
            Rectangle textRect2 = new Rectangle();
            super.layoutLabel(1, metrics, tabIndex, title, icon, tabRect2, iconRect2, textRect2, isSelected);
            textRect.x = tabRect.x + textRect2.y;
            textRect.y = tabRect.y + textRect2.x;
            textRect.width = textRect2.height;
            textRect.height = textRect2.width;
            if (tabPlacement == 2) {
                textRect.y += metrics.getHeight() / 2;
            }
            iconRect.x = tabRect.x + iconRect2.y;
            iconRect.y = tabRect.y + iconRect2.x;
            iconRect.width = iconRect2.height;
            iconRect.height = iconRect2.width;
        } else {
            super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        }
    }

    @Override
    protected Rectangle getTabsTextBoundsAt(int tabIndex) {
        Rectangle rect = super.getTabsTextBoundsAt(tabIndex);
        rect.x += this.getTabInsets((int)this._tabPane.getTabPlacement(), (int)tabIndex).left;
        return rect;
    }

    private boolean isLastInRun(int tabIndex) {
        int run = this.getRunForTab(this._tabPane.getTabCount(), tabIndex);
        return this.lastTabInRun(this._tabPane.getTabCount(), run) == tabIndex;
    }

    private boolean isLeftToRight() {
        return this._tabPane.getComponentOrientation().isLeftToRight();
    }

    private boolean isHorizontalTabPlacement() {
        int tabPlacement = this._tabPane.getTabPlacement();
        return tabPlacement == 1 || tabPlacement == 3;
    }

    @Override
    protected void ensureCurrentRects(int leftMargin, int tabCount) {
        int oldFitStyleBoundSize = this._fitStyleBoundSize;
        int oldFitStyleFirstTabMargin = this._fitStyleFirstTabMargin;
        int oldCompressedStyleNoIconRectSize = this._compressedStyleNoIconRectSize;
        int oldCompressedStyleIconMargin = this._compressedStyleIconMargin;
        int oldFixedStyleRectSize = this._fixedStyleRectSize;
        this._fitStyleBoundSize = UIScale.scale(this._fitStyleBoundSize);
        this._fitStyleFirstTabMargin = UIScale.scale(this._fitStyleFirstTabMargin);
        this._compressedStyleNoIconRectSize = UIScale.scale(this._compressedStyleNoIconRectSize);
        this._compressedStyleIconMargin = UIScale.scale(this._compressedStyleIconMargin);
        this._fixedStyleRectSize = UIScale.scale(this._fixedStyleRectSize);
        super.ensureCurrentRects(leftMargin, tabCount);
        this._fitStyleBoundSize = oldFitStyleBoundSize;
        this._fitStyleFirstTabMargin = oldFitStyleFirstTabMargin;
        this._compressedStyleNoIconRectSize = oldCompressedStyleNoIconRectSize;
        this._compressedStyleIconMargin = oldCompressedStyleIconMargin;
        this._fixedStyleRectSize = oldFixedStyleRectSize;
    }

    @Override
    public void ensureCloseButtonCreated() {
        super.ensureCloseButtonCreated();
        if (this._closeButtons == null) {
            return;
        }
        for (JButton closeButton : this._closeButtons) {
            if (closeButton.getIcon() != this.closeIcon) {
                closeButton.setIcon(this.closeIcon);
            }
            if (!closeButton.isContentAreaFilled()) continue;
            closeButton.setContentAreaFilled(false);
        }
    }

    protected void updateCloseButtonMargins() {
        this._closeButtonLeftMargin = UIScale.scale(this.closeButtonLeftMarginUnscaled);
        this._closeButtonRightMargin = UIScale.scale(this.closeButtonRightMarginUnscaled);
        int offset = (this.closeIcon.getIconWidth() - 16) / 2;
        this._closeButtonLeftMargin += offset;
        this._closeButtonRightMargin += offset;
    }

    protected class FlatJideTabAreaArrowIcon
    implements Icon {
        protected FlatJideTabAreaArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
            JideTabbedPane.NoFocusButton button = (JideTabbedPane.NoFocusButton)c;
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
            if (button.isEnabled()) {
                Color background;
                Color color = FlatJideTabbedPaneUI.this.buttonPressedBackground != null && button.isMousePressed() ? FlatJideTabbedPaneUI.this.buttonPressedBackground : (background = FlatJideTabbedPaneUI.this.buttonHoverBackground != null && button.isMouseOver() ? FlatJideTabbedPaneUI.this.buttonHoverBackground : null);
                if (background != null) {
                    Insets insets = new Insets(0, 0, 0, 0);
                    BasicJideTabbedPaneUI.rotateInsets(FlatJideTabbedPaneUI.this.buttonInsets, insets, FlatJideTabbedPaneUI.this._tabPane.getTabPlacement());
                    g2.setColor(FlatUIUtils.deriveColor(background, FlatJideTabbedPaneUI.this._tabPane.getBackground()));
                    FlatUIUtils.paintComponentBackground((Graphics2D)g2, insets.left, insets.top, button.getWidth() - insets.left - insets.right, button.getHeight() - insets.top - insets.bottom, 0.0f, UIScale.scale((float)FlatJideTabbedPaneUI.this.buttonArc));
                }
            }
            int direction = -1;
            block0 : switch (button.getType()) {
                case 2: {
                    direction = FlatJideTabbedPaneUI.this.isHorizontalTabPlacement() ? (FlatJideTabbedPaneUI.this.isLeftToRight() ? 7 : 3) : 1;
                    break;
                }
                case 1: {
                    direction = FlatJideTabbedPaneUI.this.isHorizontalTabPlacement() ? (FlatJideTabbedPaneUI.this.isLeftToRight() ? 3 : 7) : 5;
                    break;
                }
                case 5: {
                    switch (FlatJideTabbedPaneUI.this._tabPane.getTabPlacement()) {
                        default: {
                            direction = 5;
                            break block0;
                        }
                        case 3: {
                            direction = 1;
                            break block0;
                        }
                        case 2: {
                            direction = 3;
                            break block0;
                        }
                        case 4: 
                    }
                    direction = 7;
                }
            }
            g2.setColor(button.isEnabled() ? FlatJideTabbedPaneUI.this.foreground : FlatJideTabbedPaneUI.this.disabledForeground);
            FlatUIUtils.paintArrow((Graphics2D)g2, 0, 0, button.getWidth(), button.getHeight(), direction, FlatUIUtils.isChevron(FlatJideTabbedPaneUI.this.arrowType), 10, 1.0f, 0.0f, 0.0f);
            FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
        }

        @Override
        public int getIconWidth() {
            return UIScale.scale(16);
        }

        @Override
        public int getIconHeight() {
            return UIScale.scale(16);
        }
    }

    protected class FlatJideTabCloseIcon
    extends FlatTabbedPaneCloseIcon {
        protected FlatJideTabCloseIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g2, int x, int y) {
            Object property;
            JideTabbedPane.NoFocusButton button = (JideTabbedPane.NoFocusButton)c;
            if (FlatJideTabbedPaneUI.this._tabPane.isShowCloseButtonOnMouseOver() && !button.isMouseOver() && (property = FlatJideTabbedPaneUI.this._tabPane.getClientProperty("JideTabbedPane.mouseOverTabIndex")) instanceof Integer && button.getIndex() >= 0 && ((Integer)property).intValue() != button.getIndex()) {
                return;
            }
            super.paintIcon(c, g2, x, y);
        }
    }

    protected class FlatJideTabbedPaneScrollLayout
    extends BasicJideTabbedPaneUI.TabbedPaneScrollLayout {
        protected FlatJideTabbedPaneScrollLayout() {
            super(FlatJideTabbedPaneUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            FlatJideTabbedPaneUI.this.updateCloseButtonMargins();
            super.layoutContainer(parent);
            this.updateCloseButtons();
            this.updateArrowButtons();
        }

        private void updateCloseButtons() {
            if (!(FlatJideTabbedPaneUI.this.scrollableTabLayoutEnabled() && FlatJideTabbedPaneUI.this.isShowCloseButton() && FlatJideTabbedPaneUI.this.isShowCloseButtonOnTab())) {
                return;
            }
            Color background = FlatJideTabbedPaneUI.this._tabPane.getBackground();
            for (int i = 0; i < FlatJideTabbedPaneUI.this._closeButtons.length; ++i) {
                JButton closeButton = FlatJideTabbedPaneUI.this._closeButtons[i];
                if (closeButton.getWidth() == 0 || closeButton.getHeight() == 0) continue;
                closeButton.setBounds(this.getTabCloseBounds(i));
                closeButton.setBackground(background);
            }
        }

        private Rectangle getTabCloseBounds(int tabIndex) {
            int iconWidth = FlatJideTabbedPaneUI.this.closeIcon.getIconWidth();
            int iconHeight = FlatJideTabbedPaneUI.this.closeIcon.getIconHeight();
            Rectangle tabRect = FlatJideTabbedPaneUI.this._rects[tabIndex];
            Insets tabInsets = FlatJideTabbedPaneUI.this.getTabInsets(FlatJideTabbedPaneUI.this._tabPane.getTabPlacement(), tabIndex);
            if (FlatJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || FlatJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                return new Rectangle(FlatJideTabbedPaneUI.this._tabPane.getComponentOrientation().isLeftToRight() ? tabRect.x + tabRect.width - tabInsets.right / 3 * 2 - iconWidth : tabRect.x + tabInsets.left / 3 * 2, tabRect.y + (tabRect.height - iconHeight) / 2, iconWidth, iconHeight);
            }
            return new Rectangle(tabRect.x + (tabRect.width - iconWidth) / 2, tabRect.y + tabRect.height - tabInsets.bottom / 3 * 2 - iconHeight, iconWidth, iconHeight);
        }

        private void updateArrowButtons() {
            Dimension tsize;
            if (!FlatJideTabbedPaneUI.this.scrollableTabLayoutEnabled() || !FlatJideTabbedPaneUI.this._tabPane.isTabShown()) {
                return;
            }
            Insets insets = FlatJideTabbedPaneUI.this._tabPane.getInsets();
            int tabPlacement = FlatJideTabbedPaneUI.this._tabPane.getTabPlacement();
            Insets tabAreaInsets = FlatJideTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension dimension = tsize = FlatJideTabbedPaneUI.this.isTabTrailingComponentVisible() ? FlatJideTabbedPaneUI.this._tabTrailingComponent.getSize() : new Dimension();
            if (tabPlacement == 1 || tabPlacement == 3) {
                int maxTabHeight = tabPlacement == 3 ? FlatJideTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement) : FlatJideTabbedPaneUI.this._maxTabHeight;
                boolean leftToRight = FlatJideTabbedPaneUI.this.isLeftToRight();
                int x = leftToRight ? FlatJideTabbedPaneUI.this._tabPane.getWidth() - insets.right - tsize.width : insets.left + tsize.width;
                int y = FlatJideTabbedPaneUI.this._tabScroller.viewport.getY();
                int h2 = maxTabHeight;
                y = tabPlacement == 1 ? (y += FlatJideTabbedPaneUI.this._tabScroller.viewport.getHeight() - h2 - tabAreaInsets.bottom) : (y += tabAreaInsets.top);
                if (!FlatJideTabbedPaneUI.this.isShowCloseButtonOnTab()) {
                    x = this.layoutButtonHorizontal(FlatJideTabbedPaneUI.this._tabScroller.closeButton, 16, x, y, h2, leftToRight);
                }
                x = this.layoutButtonHorizontal(FlatJideTabbedPaneUI.this._tabScroller.listButton, 24, x, y, h2, leftToRight);
                x = this.layoutButtonHorizontal(FlatJideTabbedPaneUI.this._tabScroller.scrollForwardButton, 16, x, y, h2, leftToRight);
                x = this.layoutButtonHorizontal(FlatJideTabbedPaneUI.this._tabScroller.scrollBackwardButton, 16, x, y, h2, leftToRight);
                Rectangle r = FlatJideTabbedPaneUI.this._tabScroller.viewport.getBounds();
                if (leftToRight) {
                    FlatJideTabbedPaneUI.this._tabScroller.viewport.setSize(x - r.x, r.height);
                } else {
                    FlatJideTabbedPaneUI.this._tabScroller.viewport.setBounds(x, r.y, r.width - (x - r.x), r.height);
                }
            } else {
                int maxTabWidth = tabPlacement == 4 ? FlatJideTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement) : FlatJideTabbedPaneUI.this._maxTabWidth;
                int x = FlatJideTabbedPaneUI.this._tabScroller.viewport.getX();
                int y = FlatJideTabbedPaneUI.this._tabPane.getHeight() - insets.bottom - tsize.height;
                int w = maxTabWidth;
                x = tabPlacement == 2 ? (x += FlatJideTabbedPaneUI.this._tabScroller.viewport.getWidth() - w - tabAreaInsets.right) : (x += tabAreaInsets.left);
                if (!FlatJideTabbedPaneUI.this.isShowCloseButtonOnTab()) {
                    y = this.layoutButtonVertical(FlatJideTabbedPaneUI.this._tabScroller.closeButton, 16, x, y, w);
                }
                y = this.layoutButtonVertical(FlatJideTabbedPaneUI.this._tabScroller.listButton, 24, x, y, w);
                y = this.layoutButtonVertical(FlatJideTabbedPaneUI.this._tabScroller.scrollForwardButton, 16, x, y, w);
                y = this.layoutButtonVertical(FlatJideTabbedPaneUI.this._tabScroller.scrollBackwardButton, 16, x, y, w);
                Rectangle r = FlatJideTabbedPaneUI.this._tabScroller.viewport.getBounds();
                FlatJideTabbedPaneUI.this._tabScroller.viewport.setSize(r.width, y - r.y);
            }
        }

        private int layoutButtonHorizontal(JButton button, int wu, int x, int y, int h2, boolean leftToRight) {
            if (button.isVisible()) {
                int w = UIScale.scale(wu);
                if (leftToRight) {
                    x -= w;
                }
                button.setBounds(x, y, w, h2);
                if (!leftToRight) {
                    x += w;
                }
            }
            return x;
        }

        private int layoutButtonVertical(JButton button, int hu, int x, int y, int w) {
            if (button.isVisible()) {
                int h2 = UIScale.scale(hu);
                button.setBounds(x, y -= h2, w, h2);
            }
            return y;
        }
    }
}

