/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AvailableInstanceCapacityListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceCapacity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailableCapacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailableCapacity> {
    private static final SdkField<List<InstanceCapacity>> AVAILABLE_INSTANCE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailableInstanceCapacity").getter(AvailableCapacity.getter(AvailableCapacity::availableInstanceCapacity)).setter(AvailableCapacity.setter(Builder::availableInstanceCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCapacity").unmarshallLocationName("availableInstanceCapacity").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> AVAILABLE_V_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableVCpus").getter(AvailableCapacity.getter(AvailableCapacity::availableVCpus)).setter(AvailableCapacity.setter(Builder::availableVCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableVCpus").unmarshallLocationName("availableVCpus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_INSTANCE_CAPACITY_FIELD, AVAILABLE_V_CPUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AvailableCapacity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<InstanceCapacity> availableInstanceCapacity;
    private final Integer availableVCpus;

    private AvailableCapacity(BuilderImpl builder) {
        this.availableInstanceCapacity = builder.availableInstanceCapacity;
        this.availableVCpus = builder.availableVCpus;
    }

    public final boolean hasAvailableInstanceCapacity() {
        return this.availableInstanceCapacity != null && !(this.availableInstanceCapacity instanceof SdkAutoConstructList);
    }

    public final List<InstanceCapacity> availableInstanceCapacity() {
        return this.availableInstanceCapacity;
    }

    public final Integer availableVCpus() {
        return this.availableVCpus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableInstanceCapacity() ? this.availableInstanceCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availableVCpus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableCapacity)) {
            return false;
        }
        AvailableCapacity other = (AvailableCapacity)obj;
        return this.hasAvailableInstanceCapacity() == other.hasAvailableInstanceCapacity() && Objects.equals(this.availableInstanceCapacity(), other.availableInstanceCapacity()) && Objects.equals(this.availableVCpus(), other.availableVCpus());
    }

    public final String toString() {
        return ToString.builder((String)"AvailableCapacity").add("AvailableInstanceCapacity", this.hasAvailableInstanceCapacity() ? this.availableInstanceCapacity() : null).add("AvailableVCpus", (Object)this.availableVCpus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailableInstanceCapacity": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCapacity()));
            }
            case "AvailableVCpus": {
                return Optional.ofNullable(clazz.cast(this.availableVCpus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailableInstanceCapacity", AVAILABLE_INSTANCE_CAPACITY_FIELD);
        map.put("AvailableVCpus", AVAILABLE_V_CPUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailableCapacity, T> g) {
        return obj -> g.apply((AvailableCapacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceCapacity> availableInstanceCapacity = DefaultSdkAutoConstructList.getInstance();
        private Integer availableVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableCapacity model) {
            this.availableInstanceCapacity(model.availableInstanceCapacity);
            this.availableVCpus(model.availableVCpus);
        }

        public final List<InstanceCapacity.Builder> getAvailableInstanceCapacity() {
            List<InstanceCapacity.Builder> result = AvailableInstanceCapacityListCopier.copyToBuilder(this.availableInstanceCapacity);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailableInstanceCapacity(Collection<InstanceCapacity.BuilderImpl> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copyFromBuilder(availableInstanceCapacity);
        }

        @Override
        public final Builder availableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copy(availableInstanceCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableInstanceCapacity(InstanceCapacity ... availableInstanceCapacity) {
            this.availableInstanceCapacity(Arrays.asList(availableInstanceCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableInstanceCapacity(Consumer<InstanceCapacity.Builder> ... availableInstanceCapacity) {
            this.availableInstanceCapacity(Stream.of(availableInstanceCapacity).map(c -> (InstanceCapacity)((InstanceCapacity.Builder)InstanceCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getAvailableVCpus() {
            return this.availableVCpus;
        }

        public final void setAvailableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
        }

        @Override
        public final Builder availableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
            return this;
        }

        public AvailableCapacity build() {
            return new AvailableCapacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailableCapacity> {
        public Builder availableInstanceCapacity(Collection<InstanceCapacity> var1);

        public Builder availableInstanceCapacity(InstanceCapacity ... var1);

        public Builder availableInstanceCapacity(Consumer<InstanceCapacity.Builder> ... var1);

        public Builder availableVCpus(Integer var1);
    }
}

