/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PlacementGroup;
import software.amazon.awssdk.services.ec2.model.PlacementGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePlacementGroupsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribePlacementGroupsResponse> {
    private static final SdkField<List<PlacementGroup>> PLACEMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlacementGroups").getter(DescribePlacementGroupsResponse.getter(DescribePlacementGroupsResponse::placementGroups)).setter(DescribePlacementGroupsResponse.setter(Builder::placementGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroupSet").unmarshallLocationName("placementGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePlacementGroupsResponse.memberNameToFieldInitializer();
    private final List<PlacementGroup> placementGroups;

    private DescribePlacementGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.placementGroups = builder.placementGroups;
    }

    public final boolean hasPlacementGroups() {
        return this.placementGroups != null && !(this.placementGroups instanceof SdkAutoConstructList);
    }

    public final List<PlacementGroup> placementGroups() {
        return this.placementGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementGroups() ? this.placementGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlacementGroupsResponse)) {
            return false;
        }
        DescribePlacementGroupsResponse other = (DescribePlacementGroupsResponse)((Object)obj);
        return this.hasPlacementGroups() == other.hasPlacementGroups() && Objects.equals(this.placementGroups(), other.placementGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePlacementGroupsResponse").add("PlacementGroups", this.hasPlacementGroups() ? this.placementGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlacementGroups": {
                return Optional.ofNullable(clazz.cast(this.placementGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PlacementGroup>>> map = new HashMap<String, SdkField<List<PlacementGroup>>>();
        map.put("PlacementGroupSet", PLACEMENT_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePlacementGroupsResponse, T> g) {
        return obj -> g.apply((DescribePlacementGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<PlacementGroup> placementGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlacementGroupsResponse model) {
            super(model);
            this.placementGroups(model.placementGroups);
        }

        public final List<PlacementGroup.Builder> getPlacementGroups() {
            List<PlacementGroup.Builder> result = PlacementGroupListCopier.copyToBuilder(this.placementGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementGroups(Collection<PlacementGroup.BuilderImpl> placementGroups) {
            this.placementGroups = PlacementGroupListCopier.copyFromBuilder(placementGroups);
        }

        @Override
        public final Builder placementGroups(Collection<PlacementGroup> placementGroups) {
            this.placementGroups = PlacementGroupListCopier.copy(placementGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroups(PlacementGroup ... placementGroups) {
            this.placementGroups(Arrays.asList(placementGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementGroups(Consumer<PlacementGroup.Builder> ... placementGroups) {
            this.placementGroups(Stream.of(placementGroups).map(c -> (PlacementGroup)((PlacementGroup.Builder)PlacementGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePlacementGroupsResponse build() {
            return new DescribePlacementGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePlacementGroupsResponse> {
        public Builder placementGroups(Collection<PlacementGroup> var1);

        public Builder placementGroups(PlacementGroup ... var1);

        public Builder placementGroups(Consumer<PlacementGroup.Builder> ... var1);
    }
}

